
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `gi_nazioni`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gi_nazioni` (
  `sigla_nazione` varchar(6) NOT NULL,
  `codice_belfiore` varchar(8) NOT NULL,
  `denominazione_nazione` varchar(100) NOT NULL,
  `denominazione_cittadinanza` varchar(100) NOT NULL,
  PRIMARY KEY (`sigla_nazione`),
  UNIQUE KEY `codice_belfiore` (`codice_belfiore`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gi_nazioni` WRITE;
/*!40000 ALTER TABLE `gi_nazioni` DISABLE KEYS */;
INSERT INTO `gi_nazioni` VALUES ('122','Z122','MAN (ISOLA)','MANNESE');
INSERT INTO `gi_nazioni` VALUES ('124','Z124','NORMANNE (ISOLE)=ISOLE DEL CANALE','NORMANNE (ISOLE)=ISOLE DEL CANALE');
INSERT INTO `gi_nazioni` VALUES ('136','Z136','GEORGIA','GEORGIANA');
INSERT INTO `gi_nazioni` VALUES ('137','Z137','ARMENIA','ARMENA');
INSERT INTO `gi_nazioni` VALUES ('141','Z141','AZERBAIDJAN','AZERBAIGIANA');
INSERT INTO `gi_nazioni` VALUES ('142','Z142','KIRGHIZISTAN','KIRGHISA');
INSERT INTO `gi_nazioni` VALUES ('143','Z143','UZBEKISTAN','UZBEKA');
INSERT INTO `gi_nazioni` VALUES ('147','Z147','TAGIKISTAN','TAGIKA');
INSERT INTO `gi_nazioni` VALUES ('151','Z151','TURKMENISTAN','TURKMENA');
INSERT INTO `gi_nazioni` VALUES ('152','Z152','KAZAKHISTAN','KAZAKA');
INSERT INTO `gi_nazioni` VALUES ('201','Z201','ARABIA MERIDIONALE FEDERAZIONE','YEMENITA (FEDERAZIONE DELL\'ARABIA MERIDIONALE)');
INSERT INTO `gi_nazioni` VALUES ('202','Z202','ARABIA MERIDIONALE PROTETTORATO','YEMENITA (PROTETTORATO DELL\'ARABIA MERIDIONALE)');
INSERT INTO `gi_nazioni` VALUES ('218','Z218','GAZA (TERRITORIO DI)','PALESTINESE (TERRITORIO DI GAZA)');
INSERT INTO `gi_nazioni` VALUES ('238','Z238','RYUKYU (ISOLE)','GIAPPONESE (ISOLE RYUKYU)');
INSERT INTO `gi_nazioni` VALUES ('239','Z239','SIKKIM','SIKKIM');
INSERT INTO `gi_nazioni` VALUES ('303','Z303','BASUTOLAND SUD AFRICA BRITANN','LESOTHIANA (BASUTOLAND-SUD AFRICA BRITANNICO)');
INSERT INTO `gi_nazioni` VALUES ('304','Z304','BECIUANIA SUD AFRICA BRITANNICO','BECIUANA');
INSERT INTO `gi_nazioni` VALUES ('323','Z323','IFNI','MAROCCHINA (IFNI)');
INSERT INTO `gi_nazioni` VALUES ('339','Z339','SAHARA SPAGNOLO','SAHARIANA (SAHARA SPAGNOLO)');
INSERT INTO `gi_nazioni` VALUES ('350','Z350','TANGANICA','TANZANIANA (TANGANICA)');
INSERT INTO `gi_nazioni` VALUES ('356','Z356','ZANZIBAR','TANZANIANA (ZANZIBAR)');
INSERT INTO `gi_nazioni` VALUES ('362','Z362','SAHARA MERIDIONALE','SAHARIANA (SAHARA MERIDIONALE)');
INSERT INTO `gi_nazioni` VALUES ('363','Z363','SAHARA SETTENTRIONALE','SAHARIANA (SAHARA SETTENTRIONALE)');
INSERT INTO `gi_nazioni` VALUES ('364','Z364','BOPHUTHATSWANA','BATSWANA');
INSERT INTO `gi_nazioni` VALUES ('365','Z365','TRANSKEI','TRANSKEI');
INSERT INTO `gi_nazioni` VALUES ('366','Z366','VENDA','VENDA');
INSERT INTO `gi_nazioni` VALUES ('367','Z367','CISKEI','CENTRAFICANA (CISKEI)');
INSERT INTO `gi_nazioni` VALUES ('369','Z369','NYASALAND','MALAWIANA');
INSERT INTO `gi_nazioni` VALUES ('500','Z500','ANTILLE BRITANNICHE','ANTILLANA (ANTILLE BRITANNICHE)');
INSERT INTO `gi_nazioni` VALUES ('517','Z517','PANAMA ZONA DEL CANALE','PANAMENSE (PANAMA ZONA DEL CANALE)');
INSERT INTO `gi_nazioni` VALUES ('521','Z521','ANTILLE BRITANNICHE','ANTILLANA (ANTILLE BRITANNICHE)');
INSERT INTO `gi_nazioni` VALUES ('523','Z523','ANTILLE BRITANNICHE','ANTILLANA (ANTILLE BRITANNICHE)');
INSERT INTO `gi_nazioni` VALUES ('701','Z701','CAROLINE (ISOLE)','MICRONESIANA (ISOLE CAROLINE)');
INSERT INTO `gi_nazioni` VALUES ('705','Z705','GILBERT E ELLICE (ISOLE)','CENTRAFICANA (ISOLE GILBERT E ELLICE)');
INSERT INTO `gi_nazioni` VALUES ('707','Z707','IRIAN OCCIDENTALE','PAPUANA');
INSERT INTO `gi_nazioni` VALUES ('708','Z708','MACQUARIE (ISOLE)','MACQUARIE (ISOLE)');
INSERT INTO `gi_nazioni` VALUES ('709','Z709','MARCUS (ISOLE)','GIAPPONESE (ISOLE MARCUS)');
INSERT INTO `gi_nazioni` VALUES ('712','Z712','MIDWAY (ISOLE)','MIDWAY (ISOLE)');
INSERT INTO `gi_nazioni` VALUES ('721','Z721','ISOLE CILENE (PASQUA E SALA Y GOMEZ)','ISOLE CILENE (PASQUA E SALA Y GOMEZ)');
INSERT INTO `gi_nazioni` VALUES ('800','Z800','DIPENDENZE CANADESI','CANADESE (DIPENDENZE CANADESI)');
INSERT INTO `gi_nazioni` VALUES ('801','Z801','DIPENDENZE NORVEGESI ARTICHE','NORVEGESE (DIPENDENZE NORVEGESI ARTICHE)');
INSERT INTO `gi_nazioni` VALUES ('802','Z802','DIPENDENZE SOVIETICHE','RUSSA (DIPENDENZE RUSSE)');
INSERT INTO `gi_nazioni` VALUES ('900','Z900','DIPENDENZE AUSTRALIANE','AUSTRALIANA (DIPENDENZE AUSTRALIANE)');
INSERT INTO `gi_nazioni` VALUES ('901','Z901','DIPENDENZE BRITANNICHE','BRITANNICA (DIPENDENZE BRITANNICHE)');
INSERT INTO `gi_nazioni` VALUES ('902','Z902','DIPENDENZE FRANCESI','FRANCESE (DIPENDENZE FRANCESI)');
INSERT INTO `gi_nazioni` VALUES ('903','Z903','DIPENDENZE NEOZELANDESI','NEOZELANDESE (DIPENDENZE NEOZELANDESI)');
INSERT INTO `gi_nazioni` VALUES ('904','Z904','DIPENDENZE NORVEGESI ANTARTICHE','NORVEGESE (DIPENDENZE NORVEGESI ANTARTICHE)');
INSERT INTO `gi_nazioni` VALUES ('905','Z905','DIPENDENZE STATUNITENSI','STATUNITENSE (DIPENDENZE STATUNITENSI)');
INSERT INTO `gi_nazioni` VALUES ('906','Z906','DIPENDENZE SUDAFRICANE','SUDAFRICANA (DIPENDENZE SUDAFRICANE)');
INSERT INTO `gi_nazioni` VALUES ('907','Z907','SUD SUDAN','SUDSUDANESE');
INSERT INTO `gi_nazioni` VALUES ('A','Z102','AUSTRIA','AUSTRIACA');
INSERT INTO `gi_nazioni` VALUES ('ADN','Z246','YEMEN','YEMENITA');
INSERT INTO `gi_nazioni` VALUES ('AFG','Z200','AFGHANISTAN','AFGANA');
INSERT INTO `gi_nazioni` VALUES ('AG','Z532','ANTIGUA E BARBUDA','ANTIGUANA, BARBUDANA');
INSERT INTO `gi_nazioni` VALUES ('AIA','Z529','ANGUILLA (ISOLA)','ANGUILLANA');
INSERT INTO `gi_nazioni` VALUES ('AL','Z100','ALBANIA','ALBANESE');
INSERT INTO `gi_nazioni` VALUES ('AND','Z101','ANDORRA','ANDORRANA');
INSERT INTO `gi_nazioni` VALUES ('ANG','Z302','ANGOLA','ANGOLANA');
INSERT INTO `gi_nazioni` VALUES ('ANT','Z501','ANTILLE OLANDESI','ANTILLANA (ANTILLE OLANDESI)');
INSERT INTO `gi_nazioni` VALUES ('ARM','Z252','ARMENIA','ARMENA');
INSERT INTO `gi_nazioni` VALUES ('ASM','Z725','SAMOA AMERICANE (ISOLE)','SAMOANA AMERICANA');
INSERT INTO `gi_nazioni` VALUES ('AUS','Z700','AUSTRALIA','AUSTRALIANA');
INSERT INTO `gi_nazioni` VALUES ('AZ','Z253','AZERBAIDJAN','AZERBAIGIANA');
INSERT INTO `gi_nazioni` VALUES ('B','Z103','BELGIO','BELGA');
INSERT INTO `gi_nazioni` VALUES ('BB','Z358','BOTSWANA','BOTSWANIANA');
INSERT INTO `gi_nazioni` VALUES ('BD','Z249','BANGLADESH','BENGALESE');
INSERT INTO `gi_nazioni` VALUES ('BDS','Z522','BARBADOS','BARBADIANA');
INSERT INTO `gi_nazioni` VALUES ('BG','Z104','BULGARIA','BULGARA');
INSERT INTO `gi_nazioni` VALUES ('BH','Z512','BELIZE','BELIZIANA');
INSERT INTO `gi_nazioni` VALUES ('BHT','Z205','BHUTAN','BHUTANESE');
INSERT INTO `gi_nazioni` VALUES ('BIH','Z153','BOSNIA ED ERZEGOVINA','BOSNIACA');
INSERT INTO `gi_nazioni` VALUES ('BMU','Z400','BERMUDA (ISOLE)','BERMUDIANA');
INSERT INTO `gi_nazioni` VALUES ('BOL','Z601','BOLIVIA','BOLIVIANA');
INSERT INTO `gi_nazioni` VALUES ('BPB','Z314','BENIN','BENINESE');
INSERT INTO `gi_nazioni` VALUES ('BR','Z602','BRASILE','BRASILIANA');
INSERT INTO `gi_nazioni` VALUES ('BRN','Z204','BAHREIN','BAHRAYNI');
INSERT INTO `gi_nazioni` VALUES ('BRU','Z207','BRUNEI','BRUNEIANA');
INSERT INTO `gi_nazioni` VALUES ('BS','Z502','BAHAMAS','BAHAMENSE');
INSERT INTO `gi_nazioni` VALUES ('BU','Z305','BURUNDI','BURUNDESE');
INSERT INTO `gi_nazioni` VALUES ('BUR','Z206','MYANMAR (BIRMANIA)','BIRMANA');
INSERT INTO `gi_nazioni` VALUES ('BVI','Z525','VERGINI BRITANNICHE (ISOLE)','BRITANNICA (ISOLE VERGINI BRITANNICHE)');
INSERT INTO `gi_nazioni` VALUES ('BY','Z139','BIELORUSSIA=RUSSIA BIANCA','BIELORUSSA');
INSERT INTO `gi_nazioni` VALUES ('C','Z504','CUBA','CUBANA');
INSERT INTO `gi_nazioni` VALUES ('CAM','Z306','CAMERUN','CAMERUNESE');
INSERT INTO `gi_nazioni` VALUES ('CB','Z370','CONGO BELGA','CONGOLESE (CONGO BELGA)');
INSERT INTO `gi_nazioni` VALUES ('CCK','Z212','COCOS (ISOLE)','COCOS (ISOLE)');
INSERT INTO `gi_nazioni` VALUES ('CDN','Z401','CANADA','CANADESE');
INSERT INTO `gi_nazioni` VALUES ('CFS','Z346','SOMALIA FRANCESE','TERRITORIO FRANCESE DEGLI AFAR E DEGLI ISSA');
INSERT INTO `gi_nazioni` VALUES ('CH','Z133','SVIZZERA','SVIZZERA');
INSERT INTO `gi_nazioni` VALUES ('CI','Z313','COSTA D\'AVORIO','IVORIANA');
INSERT INTO `gi_nazioni` VALUES ('CL','Z209','SRI LANKA','CINGALESE');
INSERT INTO `gi_nazioni` VALUES ('CN','Z210','CINA REPUBBLICA POPOLARE','CINESE');
INSERT INTO `gi_nazioni` VALUES ('CO','Z604','COLOMBIA','COLOMBIANA');
INSERT INTO `gi_nazioni` VALUES ('COK','Z703','COOK (ISOLE)','COOKESE');
INSERT INTO `gi_nazioni` VALUES ('COM','Z310','COMORE','COMORIANA');
INSERT INTO `gi_nazioni` VALUES ('CR','Z503','COSTA RICA','COSTARICANA');
INSERT INTO `gi_nazioni` VALUES ('CS','Z105','CECOSLOVACCHIA','CECA (CECOSLOVACCHIA)');
INSERT INTO `gi_nazioni` VALUES ('CV','Z307','CAPO VERDE','CAPOVERDIANA');
INSERT INTO `gi_nazioni` VALUES ('CXR','Z702','CHRISTMAS (ISOLA)','CHRISTMAS (ISOLA)');
INSERT INTO `gi_nazioni` VALUES ('CY','Z211','CIPRO','CIPRIOTA');
INSERT INTO `gi_nazioni` VALUES ('CYM','Z530','CAYMAN (ISOLE)','CAYMANIANA');
INSERT INTO `gi_nazioni` VALUES ('CZ','Z156','CECA REPUBBLICA','CECA');
INSERT INTO `gi_nazioni` VALUES ('D','Z112','GERMANIA','TEDESCA');
INSERT INTO `gi_nazioni` VALUES ('DDR','Z111','GERMANIA REPUBBLICA DEMOCRATICA','TEDESCA (REPUBBLICA DEMOCRATICA TEDESCA)');
INSERT INTO `gi_nazioni` VALUES ('DJI','Z361','DJIBOUTI','GIBUTIANA');
INSERT INTO `gi_nazioni` VALUES ('DK','Z107','DANIMARCA','DANESE');
INSERT INTO `gi_nazioni` VALUES ('DOM','Z505','DOMINICANA REPUBBLICA','DOMINICANA (REPUBBLICA DOMINICANA)');
INSERT INTO `gi_nazioni` VALUES ('DVR','Z214','COREA DEL NORD','NORDCOREANA');
INSERT INTO `gi_nazioni` VALUES ('DZ','Z301','ALGERIA','ALGERINA');
INSERT INTO `gi_nazioni` VALUES ('E','Z131','SPAGNA','SPAGNOLA');
INSERT INTO `gi_nazioni` VALUES ('EAK','Z322','KENYA','KENIOTA');
INSERT INTO `gi_nazioni` VALUES ('EAT','Z357','TANZANIA','TANZANIANA');
INSERT INTO `gi_nazioni` VALUES ('EAU','Z353','UGANDA','UGANDESE');
INSERT INTO `gi_nazioni` VALUES ('EC','Z605','ECUADOR','ECUADOREGNA');
INSERT INTO `gi_nazioni` VALUES ('ER','Z368','ERITREA','ERITREA');
INSERT INTO `gi_nazioni` VALUES ('ES','Z506','EL SALVADOR','SALVADOREGNA');
INSERT INTO `gi_nazioni` VALUES ('EST','Z144','ESTONIA','ESTONE');
INSERT INTO `gi_nazioni` VALUES ('ET','Z336','EGITTO','EGIZIANA');
INSERT INTO `gi_nazioni` VALUES ('ETH','Z315','ETIOPIA','ETIOPE');
INSERT INTO `gi_nazioni` VALUES ('F','Z110','FRANCIA','FRANCESE');
INSERT INTO `gi_nazioni` VALUES ('FIN','Z109','FINLANDIA','FINLANDESE');
INSERT INTO `gi_nazioni` VALUES ('FJI','Z704','FIGI=VITI','FIGIANA');
INSERT INTO `gi_nazioni` VALUES ('FL','Z119','LIECHTENSTEIN','LIECHTENSTEINESE');
INSERT INTO `gi_nazioni` VALUES ('FLK','Z609','MALVINE=FALKLAND (ISOLE)','MALVINIANA');
INSERT INTO `gi_nazioni` VALUES ('FO','Z108','FAER OER (ISOLE)','FAROESE');
INSERT INTO `gi_nazioni` VALUES ('FSM','Z735','MICRONESIA STATI FEDERATI','MICRONESIANA');
INSERT INTO `gi_nazioni` VALUES ('G','Z316','GABON','GABONESE');
INSERT INTO `gi_nazioni` VALUES ('GB','Z114','GRAN BRETAGNA E IRLANDA DEL NORD','BRITANNICA');
INSERT INTO `gi_nazioni` VALUES ('GBZ','Z113','GIBILTERRA','GIBILTERRINA');
INSERT INTO `gi_nazioni` VALUES ('GCA','Z509','GUATEMALA','GUATEMALTECA');
INSERT INTO `gi_nazioni` VALUES ('GE','Z254','GEORGIA','GEORGIANA');
INSERT INTO `gi_nazioni` VALUES ('GF','Z607','GUYANA=GUIANA FRANCESE','GUYANASE (GUAYANA=GUIANA FRANCESE)');
INSERT INTO `gi_nazioni` VALUES ('GH','Z318','GHANA','GHANESE');
INSERT INTO `gi_nazioni` VALUES ('GNB','Z320','GUINEA-BISSAU','GUINEENSE');
INSERT INTO `gi_nazioni` VALUES ('GP','Z508','GUADALUPA','GUADALUPEENSE');
INSERT INTO `gi_nazioni` VALUES ('GQ','Z321','GUINEA EQUATORIALE','EQUATOGUINEANA');
INSERT INTO `gi_nazioni` VALUES ('GR','Z115','GRECIA','GRECA');
INSERT INTO `gi_nazioni` VALUES ('GRL','Z402','GROENLANDIA','GROENLANDESE');
INSERT INTO `gi_nazioni` VALUES ('GUM','Z706','GUAM (ISOLA)','GUAMANIANE');
INSERT INTO `gi_nazioni` VALUES ('GUY','Z606','GUYANA','GUYANASE');
INSERT INTO `gi_nazioni` VALUES ('H','Z134','UNGHERIA','UNGHERESE');
INSERT INTO `gi_nazioni` VALUES ('HK','Z221','HONG KONG','HONGKONGHESE');
INSERT INTO `gi_nazioni` VALUES ('HKJ','Z220','GIORDANIA','GIORDANA');
INSERT INTO `gi_nazioni` VALUES ('HN','Z511','HONDURAS','HONDUREGNA');
INSERT INTO `gi_nazioni` VALUES ('HR','Z149','CROAZIA','CROATA');
INSERT INTO `gi_nazioni` VALUES ('IL','Z226','ISRAELE','ISRAELIANA');
INSERT INTO `gi_nazioni` VALUES ('IND','Z222','INDIA','INDIANA');
INSERT INTO `gi_nazioni` VALUES ('IR','Z224','IRAN','IRANIANA');
INSERT INTO `gi_nazioni` VALUES ('IRL','Z116','IRLANDA=EIRE','IRLANDESE');
INSERT INTO `gi_nazioni` VALUES ('IRQ','Z225','IRAQ','IRACHENA');
INSERT INTO `gi_nazioni` VALUES ('IS','Z117','ISLANDA','ISLANDESE');
INSERT INTO `gi_nazioni` VALUES ('IT','','ITALIA','ITALIANA');
INSERT INTO `gi_nazioni` VALUES ('J','Z219','GIAPPONE','GIAPPONESE');
INSERT INTO `gi_nazioni` VALUES ('JA','Z507','GIAMAICA','GIAMAICANA');
INSERT INTO `gi_nazioni` VALUES ('K','Z208','CAMBOGIA','CAMBOGIANA');
INSERT INTO `gi_nazioni` VALUES ('KIR','Z731','KIRIBATI','GILBERTESE');
INSERT INTO `gi_nazioni` VALUES ('KN','Z533','SAINT KITTS E NEVIS=SAINT CHRISTOPHER E','NEVISIANA');
INSERT INTO `gi_nazioni` VALUES ('KS','Z256','KIRGHIZISTAN','KIRGHISA');
INSERT INTO `gi_nazioni` VALUES ('KSA','Z203','ARABIA SAUDITA','SAUDITA');
INSERT INTO `gi_nazioni` VALUES ('KWT','Z227','KUWAIT','KUWAITIANA');
INSERT INTO `gi_nazioni` VALUES ('KZ','Z255','KAZAKHISTAN','KAZAKA');
INSERT INTO `gi_nazioni` VALUES ('L','Z120','LUSSEMBURGO','LUSSEMBURGHESE');
INSERT INTO `gi_nazioni` VALUES ('LAO','Z228','LAOS','LAOTIANA');
INSERT INTO `gi_nazioni` VALUES ('LAR','Z326','LIBIA','LIBICA');
INSERT INTO `gi_nazioni` VALUES ('LB','Z325','LIBERIA','LIBERIANA');
INSERT INTO `gi_nazioni` VALUES ('LS','Z359','LESOTHO','LESOTHIANA');
INSERT INTO `gi_nazioni` VALUES ('LT','Z146','LITUANIA','LITUANA');
INSERT INTO `gi_nazioni` VALUES ('LV','Z145','LETTONIA','LETTONE');
INSERT INTO `gi_nazioni` VALUES ('M','Z121','MALTA','MALTESE');
INSERT INTO `gi_nazioni` VALUES ('MA','Z330','MAROCCO','MAROCCHINA');
INSERT INTO `gi_nazioni` VALUES ('MAC','Z231','MACAO','MACAO');
INSERT INTO `gi_nazioni` VALUES ('MAL','Z247','MALAYSIA','MALESE');
INSERT INTO `gi_nazioni` VALUES ('MC','Z123','MONACO','MONEGASCA');
INSERT INTO `gi_nazioni` VALUES ('MD','Z140','MOLDAVIA','MOLDAVA');
INSERT INTO `gi_nazioni` VALUES ('MEX','Z514','MESSICO','MESSICANA');
INSERT INTO `gi_nazioni` VALUES ('MH','Z711','MARSHALL  (ISOLE)','MARSHALL');
INSERT INTO `gi_nazioni` VALUES ('MK','Z148','MACEDONIA','MACEDONE');
INSERT INTO `gi_nazioni` VALUES ('MNE','Z159','MONTENEGRO','MONTENEGRINA');
INSERT INTO `gi_nazioni` VALUES ('MNG','Z233','MONGOLIA','MONGOLA');
INSERT INTO `gi_nazioni` VALUES ('MNP','Z710','MARIANNE (ISOLE)','MARIANNE (ISOLE)');
INSERT INTO `gi_nazioni` VALUES ('MOC','Z333','MOZAMBICO','MOZAMBICANA');
INSERT INTO `gi_nazioni` VALUES ('MQ','Z513','MARTINICA','MARTINICANA');
INSERT INTO `gi_nazioni` VALUES ('MS','Z332','MAURITIUS (ISOLE)','MAURIZIANA');
INSERT INTO `gi_nazioni` VALUES ('MSR','Z531','MONTSERRAT','MONTSERRATIANA');
INSERT INTO `gi_nazioni` VALUES ('MV','Z232','MALDIVE','MALDIVIANA');
INSERT INTO `gi_nazioni` VALUES ('MW','Z328','MALAWI','MALAWAIANA');
INSERT INTO `gi_nazioni` VALUES ('MY','Z230','MALAYSIA','MALESE');
INSERT INTO `gi_nazioni` VALUES ('MYT','Z360','MAYOTTE (ISOLA)','FRANCESE (ISOLA MAYOTTE)');
INSERT INTO `gi_nazioni` VALUES ('N','Z125','NORVEGIA','NORVEGESE');
INSERT INTO `gi_nazioni` VALUES ('NAM','Z300','NAMIBIA','NAMIBIANA');
INSERT INTO `gi_nazioni` VALUES ('NAU','Z713','NAURU','NAURUANA');
INSERT INTO `gi_nazioni` VALUES ('NCL','Z716','NUOVA CALEDONIA (ISOLE E DIPENDENZE)','CALEDONIANA');
INSERT INTO `gi_nazioni` VALUES ('NEP','Z234','NEPAL','NEPALESE');
INSERT INTO `gi_nazioni` VALUES ('NFK','Z715','NORFOLK (ISOLE E ISOLE DEL MAR DEI CORAL','NORFOLK (ISOLE E ISOLE DEL MAR DEI CORALLI)');
INSERT INTO `gi_nazioni` VALUES ('NHE','Z717','NUOVE EBRIDI (ISOLE CONDOMINIO FRANCO-IN','NUOVE EBRIDI (ISOLE CONDOMINIO FRANCO-INGLESE)');
INSERT INTO `gi_nazioni` VALUES ('NIC','Z515','NICARAGUA','NICARAGUENSE');
INSERT INTO `gi_nazioni` VALUES ('NIU','Z714','NIUE=SAVAGE (ISOLE)','NIUEANA');
INSERT INTO `gi_nazioni` VALUES ('NL','Z126','PAESI BASSI','OLANDESE');
INSERT INTO `gi_nazioni` VALUES ('NZ','Z719','NUOVA ZELANDA','NEOZELANDESE');
INSERT INTO `gi_nazioni` VALUES ('OM','Z235','OMAN','OMANITA');
INSERT INTO `gi_nazioni` VALUES ('P','Z128','PORTOGALLO','PORTOGHESE');
INSERT INTO `gi_nazioni` VALUES ('PA','Z516','PANAMA','PANAMENSE');
INSERT INTO `gi_nazioni` VALUES ('PAL','Z734','PALAU','PALAUANA');
INSERT INTO `gi_nazioni` VALUES ('PCN','Z722','PITCAIRN (E DIPENDENZE)','PITCAIRN (E DIPENDENZE)');
INSERT INTO `gi_nazioni` VALUES ('PE','Z611','PERU\'','PERUVIANA');
INSERT INTO `gi_nazioni` VALUES ('PG','Z720','PAPUASIA','GUINEANA (PAPUASIA)');
INSERT INTO `gi_nazioni` VALUES ('PG.','Z718','NUOVA GUINEA','GUINEANA (NUOVA GUINEA)');
INSERT INTO `gi_nazioni` VALUES ('PK','Z236','PAKISTAN','PAKISTANA');
INSERT INTO `gi_nazioni` VALUES ('PL','Z127','POLONIA','POLACCA');
INSERT INTO `gi_nazioni` VALUES ('PN','Z161','TERRITORI PALESTINESI','PALESTINESE (TERRITORI PALESTINESI)');
INSERT INTO `gi_nazioni` VALUES ('PNG','Z730','PAPUA NUOVA GUINEA','GUINEANA (PAPUA NUOVA GUINEA)');
INSERT INTO `gi_nazioni` VALUES ('PRI','Z518','PUERTO RICO','PORTORICANA');
INSERT INTO `gi_nazioni` VALUES ('PY','Z610','PARAGUAY','PARAGUAIANA');
INSERT INTO `gi_nazioni` VALUES ('PYF','Z723','POLINESIA FRANCESE (ISOLE)','POLINESIANA');
INSERT INTO `gi_nazioni` VALUES ('Q','Z237','QATAR','QATARIOTA');
INSERT INTO `gi_nazioni` VALUES ('RA','Z600','ARGENTINA','ARGENTINA');
INSERT INTO `gi_nazioni` VALUES ('RC','Z217','CINA REPUBBLICA NAZIONALE=TAIWAN','TAIWANESE');
INSERT INTO `gi_nazioni` VALUES ('RCA','Z308','CENTRAFRICANA REPUBBLICA','CENTRAFICANA');
INSERT INTO `gi_nazioni` VALUES ('RCB','Z311','CONGO REPUBBLICA POPOLARE','CONGOLESE (REPUBBLICA POPOLARE DEL CONGO)');
INSERT INTO `gi_nazioni` VALUES ('RCH','Z603','CILE','CILENA');
INSERT INTO `gi_nazioni` VALUES ('REU','Z324','LA REUNION (ISOLA)','REUNIONESE');
INSERT INTO `gi_nazioni` VALUES ('RG','Z319','GUINEA','GUINEANA (GUINEA)');
INSERT INTO `gi_nazioni` VALUES ('RH','Z510','HAITI','HAITIANA');
INSERT INTO `gi_nazioni` VALUES ('RHV','Z354','BURKINA FASO','BURKINABÈ');
INSERT INTO `gi_nazioni` VALUES ('RI','Z223','INDONESIA','INDONESIANA');
INSERT INTO `gi_nazioni` VALUES ('RIM','Z331','MAURITANIA','MAURITANA');
INSERT INTO `gi_nazioni` VALUES ('RL','Z229','LIBANO','LIBANESE');
INSERT INTO `gi_nazioni` VALUES ('RM','Z327','MADAGASCAR','MALGASCIA');
INSERT INTO `gi_nazioni` VALUES ('RMM','Z329','MALI','MALIANA');
INSERT INTO `gi_nazioni` VALUES ('RN','Z334','NIGER','NIGERINA');
INSERT INTO `gi_nazioni` VALUES ('RO','Z129','ROMANIA','ROMENA');
INSERT INTO `gi_nazioni` VALUES ('ROK','Z213','COREA DEL SUD','SUDCOREANA');
INSERT INTO `gi_nazioni` VALUES ('ROU','Z613','URUGUAY','URUGUAIANA');
INSERT INTO `gi_nazioni` VALUES ('RP','Z216','FILIPPINE','FILIPPINA');
INSERT INTO `gi_nazioni` VALUES ('RSM','Z130','SAN MARINO','SAMMARINESE');
INSERT INTO `gi_nazioni` VALUES ('RUS','Z154','RUSSIA=FEDERAZIONE RUSSA','RUSSA');
INSERT INTO `gi_nazioni` VALUES ('RWA','Z338','RUANDA','RUANDESE');
INSERT INTO `gi_nazioni` VALUES ('S','Z132','SVEZIA','SVEDESE');
INSERT INTO `gi_nazioni` VALUES ('SCG','Z157','SERBIA E MONTENEGRO','SERBA (SERBIA E MONTENEGRO)');
INSERT INTO `gi_nazioni` VALUES ('SD','Z349','SWAZILAND','SWAZI');
INSERT INTO `gi_nazioni` VALUES ('SGP','Z248','SINGAPORE','SINGAPORIANA');
INSERT INTO `gi_nazioni` VALUES ('SHN','Z340','SANT\'ELENA (ISOLA)','SANTELENIANA');
INSERT INTO `gi_nazioni` VALUES ('SK','Z155','SLOVACCHIA','SLOVACCA');
INSERT INTO `gi_nazioni` VALUES ('SLB','Z724','SALOMONE (ISOLE)','SALOMONE');
INSERT INTO `gi_nazioni` VALUES ('SLO','Z150','SLOVENIA','SLOVENA');
INSERT INTO `gi_nazioni` VALUES ('SME','Z608','SURINAME','SURINAMESE');
INSERT INTO `gi_nazioni` VALUES ('SN','Z343','SENEGAL','SENEGALESE');
INSERT INTO `gi_nazioni` VALUES ('SO','Z345','SOMALIA','SOMALA');
INSERT INTO `gi_nazioni` VALUES ('SPM','Z403','SAINT PIERRE ET MIQUELON (ISOLE)','FRANCESE (ISOLE SAINT PIERRE ET MIQUELON)');
INSERT INTO `gi_nazioni` VALUES ('SRB','Z158','SERBIA','SERBA');
INSERT INTO `gi_nazioni` VALUES ('STP','Z341','SAO TOME E PRINCIPE','SAO TOME\' E PRINCIPE');
INSERT INTO `gi_nazioni` VALUES ('SU','Z135','UNIONE REPUBBLICHE SOCIALISTE SOVIETICHE','SOVIETICA');
INSERT INTO `gi_nazioni` VALUES ('SUN','Z348','SUDAN','SUDANESE');
INSERT INTO `gi_nazioni` VALUES ('SY','Z342','SEYCHELLES','SEYCHELLESE');
INSERT INTO `gi_nazioni` VALUES ('SYR','Z240','SIRIA','SIRIANA');
INSERT INTO `gi_nazioni` VALUES ('T','Z241','THAILANDIA','THAILANDESE');
INSERT INTO `gi_nazioni` VALUES ('TCA','Z519','TURKS E CAICOS (ISOLE)','TURKS E CAICOS (ISOLE)');
INSERT INTO `gi_nazioni` VALUES ('TCH','Z309','CIAD','CIADIANA');
INSERT INTO `gi_nazioni` VALUES ('TG','Z351','TOGO','TOGOLESE');
INSERT INTO `gi_nazioni` VALUES ('TJ','Z257','TAGIKISTAN','TAGIKA');
INSERT INTO `gi_nazioni` VALUES ('TKL','Z727','TOKELAU=ISOLE DELL\'UNIONE','TONGANIANA');
INSERT INTO `gi_nazioni` VALUES ('TL','Z242','TIMOR (ISOLA)','TIMORESE');
INSERT INTO `gi_nazioni` VALUES ('TM','Z258','TURKMENISTAN','TURKMENA');
INSERT INTO `gi_nazioni` VALUES ('TN','Z352','TUNISIA','TUNISINA');
INSERT INTO `gi_nazioni` VALUES ('TO','Z728','TONGA=ISOLE DEGLI AMICI','TONGANA');
INSERT INTO `gi_nazioni` VALUES ('TR','Z243','TURCHIA','TURCA');
INSERT INTO `gi_nazioni` VALUES ('TT','Z612','TRINIDAD E TOBAGO','TRINIDADIANA');
INSERT INTO `gi_nazioni` VALUES ('TUV','Z732','TUVALU','TUVALUANA');
INSERT INTO `gi_nazioni` VALUES ('UA','Z138','UCRAINA','UCRAINA');
INSERT INTO `gi_nazioni` VALUES ('UAE','Z215','EMIRATI ARABI UNITI','EMIRATINA');
INSERT INTO `gi_nazioni` VALUES ('UNK','Z160','KOSSOVO','KOSOVARA');
INSERT INTO `gi_nazioni` VALUES ('USA','Z404','STATI UNITI D\'AMERICA','STATUNITENSE');
INSERT INTO `gi_nazioni` VALUES ('UZ','Z259','UZBEKISTAN','UZBEKA');
INSERT INTO `gi_nazioni` VALUES ('V','Z106','CITTA\' DEL VATICANO','VATICANA');
INSERT INTO `gi_nazioni` VALUES ('VIR','Z520','VERGINI AMERICANE (ISOLE)','STATUNITENSE (ISOLE VERGINI AMERICANE)');
INSERT INTO `gi_nazioni` VALUES ('VN','Z251','VIETNAM','VIETNAMITA');
INSERT INTO `gi_nazioni` VALUES ('VNN','Z245','VIETNAM DEL NORD','NORDVIETNAMITA');
INSERT INTO `gi_nazioni` VALUES ('VNS','Z244','VIETNAM DEL SUD','SUDVIETNAMITA');
INSERT INTO `gi_nazioni` VALUES ('VU','Z733','VANUATU','VANUATUANA');
INSERT INTO `gi_nazioni` VALUES ('WAG','Z317','GAMBIA','GAMBIANA');
INSERT INTO `gi_nazioni` VALUES ('WAL','Z344','SIERRA LEONE','SIERRALEONESE');
INSERT INTO `gi_nazioni` VALUES ('WAN','Z335','NIGERIA','NIGERIANA');
INSERT INTO `gi_nazioni` VALUES ('WD','Z526','DOMINICA','DOMINICANA (DOMINICA)');
INSERT INTO `gi_nazioni` VALUES ('WG','Z524','GRENADA','GRENADINA');
INSERT INTO `gi_nazioni` VALUES ('WL','Z527','SAINT LUCIA','SANTALUCIANA');
INSERT INTO `gi_nazioni` VALUES ('WLF','Z729','WALLIS E FUTUNA (ISOLE)','WALLIS E FUTUNA (ISOLE)');
INSERT INTO `gi_nazioni` VALUES ('WS','Z726','SAMOA (ISOLE)','SAMOANA');
INSERT INTO `gi_nazioni` VALUES ('WV','Z528','SAINT VINCENT E GRENADINE','VINCENTIANA');
INSERT INTO `gi_nazioni` VALUES ('YS','Z250','YEMEN REP. DEM. POPOLARE','YEMENITA (REPUBBLICA DEMOCRATICA POPOLARE DELLO YEMEN)');
INSERT INTO `gi_nazioni` VALUES ('YU','Z118','JUGOSLAVIA','IUGOSLAVA');
INSERT INTO `gi_nazioni` VALUES ('YV','Z614','VENEZUELA','VENEZUELANA');
INSERT INTO `gi_nazioni` VALUES ('Z','Z355','ZAMBIA','ZAMBIANA');
INSERT INTO `gi_nazioni` VALUES ('ZA','Z347','SUDAFRICANA REPUBBLICA','SUDAFRICANA');
INSERT INTO `gi_nazioni` VALUES ('ZRE','Z312','CONGO REPUBBLICA DEMOCRATICA','CONGOLESE (REPUBBLICA DEMOCRATICA DEL CONGO)');
INSERT INTO `gi_nazioni` VALUES ('ZW','Z337','ZIMBABWE','ZIMBABWIANA');
/*!40000 ALTER TABLE `gi_nazioni` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gi_regioni`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gi_regioni` (
  `ripartizione_geografica` varchar(20) NOT NULL,
  `codice_regione` varchar(4) NOT NULL,
  `denominazione_regione` varchar(50) NOT NULL,
  `tipologia_regione` varchar(30) NOT NULL,
  `numero_province` int(11) NOT NULL,
  `numero_comuni` int(11) NOT NULL,
  `superficie_kmq` decimal(10,4) NOT NULL,
  PRIMARY KEY (`codice_regione`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gi_regioni` WRITE;
/*!40000 ALTER TABLE `gi_regioni` DISABLE KEYS */;
INSERT INTO `gi_regioni` VALUES ('Nord-ovest','01','Piemonte','statuto ordinario',8,1180,25391.7034);
INSERT INTO `gi_regioni` VALUES ('Nord-ovest','02','Valle d\'Aosta/Vallée d\'Aoste','statuto speciale',1,74,3260.5014);
INSERT INTO `gi_regioni` VALUES ('Nord-ovest','03','Lombardia','statuto ordinario',12,1502,23862.8390);
INSERT INTO `gi_regioni` VALUES ('Nord-est','04','Trentino-Alto Adige/Südtirol','statuto speciale',2,282,13607.7563);
INSERT INTO `gi_regioni` VALUES ('Nord-est','05','Veneto','statuto ordinario',7,560,18354.2207);
INSERT INTO `gi_regioni` VALUES ('Nord-est','06','Friuli-Venezia Giulia','statuto speciale',4,215,7933.1665);
INSERT INTO `gi_regioni` VALUES ('Nord-ovest','07','Liguria','statuto ordinario',4,234,5419.4520);
INSERT INTO `gi_regioni` VALUES ('Nord-est','08','Emilia-Romagna','statuto ordinario',9,330,22501.2671);
INSERT INTO `gi_regioni` VALUES ('Centro','09','Toscana','statuto ordinario',10,273,22989.9040);
INSERT INTO `gi_regioni` VALUES ('Centro','10','Umbria','statuto ordinario',2,92,8464.3584);
INSERT INTO `gi_regioni` VALUES ('Centro','11','Marche','statuto ordinario',5,225,9345.8919);
INSERT INTO `gi_regioni` VALUES ('Centro','12','Lazio','statuto ordinario',5,378,17236.2082);
INSERT INTO `gi_regioni` VALUES ('Sud','13','Abruzzo','statuto ordinario',4,305,10831.3399);
INSERT INTO `gi_regioni` VALUES ('Sud','14','Molise','statuto ordinario',2,136,4461.3591);
INSERT INTO `gi_regioni` VALUES ('Sud','15','Campania','statuto ordinario',5,550,13675.3313);
INSERT INTO `gi_regioni` VALUES ('Sud','16','Puglia','statuto ordinario',6,257,19538.4463);
INSERT INTO `gi_regioni` VALUES ('Sud','17','Basilicata','statuto ordinario',2,131,10073.9127);
INSERT INTO `gi_regioni` VALUES ('Sud','18','Calabria','statuto ordinario',5,404,15217.0982);
INSERT INTO `gi_regioni` VALUES ('Isole','19','Sicilia','statuto speciale',9,391,25832.4612);
INSERT INTO `gi_regioni` VALUES ('Isole','20','Sardegna','statuto speciale',9,377,24109.9204);
/*!40000 ALTER TABLE `gi_regioni` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gi_province`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gi_province` (
  `codice_regione` varchar(4) NOT NULL,
  `sigla_provincia` varchar(4) NOT NULL,
  `denominazione_provincia` varchar(50) NOT NULL,
  `tipologia_provincia` varchar(100) NOT NULL,
  `numero_comuni` int(11) NOT NULL,
  `superficie_kmq` decimal(10,4) NOT NULL,
  `codice_sovracomunale` varchar(6) NOT NULL,
  PRIMARY KEY (`sigla_provincia`),
  UNIQUE KEY `codice_sovracomunale` (`codice_sovracomunale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gi_province` WRITE;
/*!40000 ALTER TABLE `gi_province` DISABLE KEYS */;
INSERT INTO `gi_province` VALUES ('19','AG','Agrigento','Libero consorzio di comuni',43,3053.8476,'084');
INSERT INTO `gi_province` VALUES ('01','AL','Alessandria','Provincia',187,3558.4988,'006');
INSERT INTO `gi_province` VALUES ('11','AN','Ancona','Provincia',47,1962.8560,'042');
INSERT INTO `gi_province` VALUES ('02','AO','Valle d\'Aosta/Vallée d\'Aoste','Provincia',74,3260.5014,'007');
INSERT INTO `gi_province` VALUES ('11','AP','Ascoli Piceno','Provincia',33,1228.6084,'044');
INSERT INTO `gi_province` VALUES ('13','AQ','L\'Aquila','Provincia',108,5048.0699,'066');
INSERT INTO `gi_province` VALUES ('09','AR','Arezzo','Provincia',36,3233.6923,'051');
INSERT INTO `gi_province` VALUES ('01','AT','Asti','Provincia',117,1509.8837,'005');
INSERT INTO `gi_province` VALUES ('15','AV','Avellino','Provincia',118,2806.5339,'064');
INSERT INTO `gi_province` VALUES ('16','BA','Bari','Citta metropolitana',41,3862.3022,'272');
INSERT INTO `gi_province` VALUES ('03','BG','Bergamo','Provincia',243,2754.9776,'016');
INSERT INTO `gi_province` VALUES ('01','BI','Biella','Provincia',74,912.8755,'096');
INSERT INTO `gi_province` VALUES ('05','BL','Belluno','Provincia',60,3609.4576,'025');
INSERT INTO `gi_province` VALUES ('15','BN','Benevento','Provincia',78,2079.5411,'062');
INSERT INTO `gi_province` VALUES ('08','BO','Bologna','Citta metropolitana',55,3702.7025,'237');
INSERT INTO `gi_province` VALUES ('16','BR','Brindisi','Provincia',20,1861.4448,'074');
INSERT INTO `gi_province` VALUES ('03','BS','Brescia','Provincia',205,4785.2655,'017');
INSERT INTO `gi_province` VALUES ('16','BT','Barletta-Andria-Trani','Provincia',10,1542.5857,'110');
INSERT INTO `gi_province` VALUES ('04','BZ','Bolzano/Bozen','Provincia autonoma',116,7399.8664,'021');
INSERT INTO `gi_province` VALUES ('20','CA','Cagliari','Citta metropolitana',17,1250.0802,'292');
INSERT INTO `gi_province` VALUES ('14','CB','Campobasso','Provincia',84,2926.2367,'070');
INSERT INTO `gi_province` VALUES ('15','CE','Caserta','Provincia',104,2652.8768,'061');
INSERT INTO `gi_province` VALUES ('13','CH','Chieti','Provincia',104,2599.7078,'069');
INSERT INTO `gi_province` VALUES ('19','CL','Caltanissetta','Libero consorzio di comuni',22,2137.8780,'085');
INSERT INTO `gi_province` VALUES ('01','CN','Cuneo','Provincia',247,6897.5707,'004');
INSERT INTO `gi_province` VALUES ('03','CO','Como','Provincia',147,1280.2443,'013');
INSERT INTO `gi_province` VALUES ('03','CR','Cremona','Provincia',113,1768.7761,'019');
INSERT INTO `gi_province` VALUES ('18','CS','Cosenza','Provincia',150,6707.7324,'078');
INSERT INTO `gi_province` VALUES ('19','CT','Catania','Citta metropolitana',58,3575.7532,'287');
INSERT INTO `gi_province` VALUES ('18','CZ','Catanzaro','Provincia',80,2415.4630,'079');
INSERT INTO `gi_province` VALUES ('19','EN','Enna','Libero consorzio di comuni',20,2574.4569,'086');
INSERT INTO `gi_province` VALUES ('08','FC','Forlì-Cesena','Provincia',30,2378.2176,'040');
INSERT INTO `gi_province` VALUES ('08','FE','Ferrara','Provincia',21,2626.8845,'038');
INSERT INTO `gi_province` VALUES ('16','FG','Foggia','Provincia',61,7006.6088,'071');
INSERT INTO `gi_province` VALUES ('09','FI','Firenze','Citta metropolitana',41,3513.2944,'248');
INSERT INTO `gi_province` VALUES ('11','FM','Fermo','Provincia',40,862.9883,'109');
INSERT INTO `gi_province` VALUES ('12','FR','Frosinone','Provincia',91,3246.9386,'060');
INSERT INTO `gi_province` VALUES ('07','GE','Genova','Citta metropolitana',67,1834.6851,'210');
INSERT INTO `gi_province` VALUES ('06','GO','Gorizia','Unità non amministrativa',25,475.2688,'031');
INSERT INTO `gi_province` VALUES ('09','GR','Grosseto','Provincia',28,4502.9911,'053');
INSERT INTO `gi_province` VALUES ('07','IM','Imperia','Provincia',66,1156.1005,'008');
INSERT INTO `gi_province` VALUES ('14','IS','Isernia','Provincia',52,1535.1224,'094');
INSERT INTO `gi_province` VALUES ('18','KR','Crotone','Provincia',27,1735.2799,'101');
INSERT INTO `gi_province` VALUES ('03','LC','Lecco','Provincia',84,805.2909,'097');
INSERT INTO `gi_province` VALUES ('16','LE','Lecce','Provincia',96,2797.8753,'075');
INSERT INTO `gi_province` VALUES ('09','LI','Livorno','Provincia',19,1215.7199,'049');
INSERT INTO `gi_province` VALUES ('03','LO','Lodi','Provincia',60,783.5348,'098');
INSERT INTO `gi_province` VALUES ('12','LT','Latina','Provincia',33,2258.0380,'059');
INSERT INTO `gi_province` VALUES ('09','LU','Lucca','Provincia',33,1773.9099,'046');
INSERT INTO `gi_province` VALUES ('03','MB','Monza e della Brianza','Provincia',55,405.2053,'108');
INSERT INTO `gi_province` VALUES ('11','MC','Macerata','Provincia',55,2779.7043,'043');
INSERT INTO `gi_province` VALUES ('19','ME','Messina','Citta metropolitana',108,3265.6385,'283');
INSERT INTO `gi_province` VALUES ('03','MI','Milano','Citta metropolitana',133,1574.8656,'215');
INSERT INTO `gi_province` VALUES ('03','MN','Mantova','Provincia',64,2342.0461,'020');
INSERT INTO `gi_province` VALUES ('08','MO','Modena','Provincia',47,2687.9155,'036');
INSERT INTO `gi_province` VALUES ('09','MS','Massa-Carrara','Provincia',17,1154.5549,'045');
INSERT INTO `gi_province` VALUES ('17','MT','Matera','Provincia',31,3479.1405,'077');
INSERT INTO `gi_province` VALUES ('15','NA','Napoli','Citta metropolitana',92,1180.1174,'263');
INSERT INTO `gi_province` VALUES ('01','NO','Novara','Provincia',87,1340.1408,'003');
INSERT INTO `gi_province` VALUES ('20','NU','Nuoro','Provincia',74,5640.3301,'091');
INSERT INTO `gi_province` VALUES ('20','OR','Oristano','Provincia',87,2991.3615,'095');
INSERT INTO `gi_province` VALUES ('19','PA','Palermo','Citta metropolitana',82,5007.2403,'282');
INSERT INTO `gi_province` VALUES ('08','PC','Piacenza','Provincia',46,2585.9915,'033');
INSERT INTO `gi_province` VALUES ('05','PD','Padova','Provincia',101,2143.0099,'028');
INSERT INTO `gi_province` VALUES ('13','PE','Pescara','Provincia',46,1229.5741,'068');
INSERT INTO `gi_province` VALUES ('10','PG','Perugia','Provincia',59,6337.4156,'054');
INSERT INTO `gi_province` VALUES ('09','PI','Pisa','Provincia',37,2444.7171,'050');
INSERT INTO `gi_province` VALUES ('06','PN','Pordenone','Unità non amministrativa',50,2274.8873,'093');
INSERT INTO `gi_province` VALUES ('09','PO','Prato','Provincia',7,365.3896,'100');
INSERT INTO `gi_province` VALUES ('08','PR','Parma','Provincia',44,3446.5930,'034');
INSERT INTO `gi_province` VALUES ('09','PT','Pistoia','Provincia',20,964.6782,'047');
INSERT INTO `gi_province` VALUES ('11','PU','Pesaro e Urbino','Provincia',50,2511.7349,'041');
INSERT INTO `gi_province` VALUES ('03','PV','Pavia','Provincia',185,2968.1907,'018');
INSERT INTO `gi_province` VALUES ('17','PZ','Potenza','Provincia',100,6594.7722,'076');
INSERT INTO `gi_province` VALUES ('08','RA','Ravenna','Provincia',18,1859.1320,'039');
INSERT INTO `gi_province` VALUES ('18','RC','Reggio Calabria','Citta metropolitana',97,3209.3112,'280');
INSERT INTO `gi_province` VALUES ('08','RE','Reggio nell\'Emilia','Provincia',42,2291.1120,'035');
INSERT INTO `gi_province` VALUES ('19','RG','Ragusa','Libero consorzio di comuni',12,1623.8624,'088');
INSERT INTO `gi_province` VALUES ('12','RI','Rieti','Provincia',73,2749.5890,'057');
INSERT INTO `gi_province` VALUES ('12','RM','Roma','Citta metropolitana',121,5366.6113,'258');
INSERT INTO `gi_province` VALUES ('08','RN','Rimini','Provincia',27,922.7185,'099');
INSERT INTO `gi_province` VALUES ('05','RO','Rovigo','Provincia',50,1824.5619,'029');
INSERT INTO `gi_province` VALUES ('15','SA','Salerno','Provincia',158,4956.2621,'065');
INSERT INTO `gi_province` VALUES ('09','SI','Siena','Provincia',35,3820.9566,'052');
INSERT INTO `gi_province` VALUES ('03','SO','Sondrio','Provincia',77,3195.7809,'014');
INSERT INTO `gi_province` VALUES ('07','SP','La Spezia','Provincia',32,882.3457,'011');
INSERT INTO `gi_province` VALUES ('19','SR','Siracusa','Libero consorzio di comuni',21,2123.7244,'089');
INSERT INTO `gi_province` VALUES ('20','SS','Sassari','Provincia',92,7695.3123,'090');
INSERT INTO `gi_province` VALUES ('20','SU','Sud Sardegna','Provincia',107,6532.8363,'111');
INSERT INTO `gi_province` VALUES ('07','SV','Savona','Provincia',69,1546.3207,'009');
INSERT INTO `gi_province` VALUES ('16','TA','Taranto','Provincia',29,2467.6295,'073');
INSERT INTO `gi_province` VALUES ('13','TE','Teramo','Provincia',47,1953.9881,'067');
INSERT INTO `gi_province` VALUES ('04','TN','Trento','Provincia autonoma',166,6207.8899,'022');
INSERT INTO `gi_province` VALUES ('01','TO','Torino','Citta metropolitana',312,6828.1721,'201');
INSERT INTO `gi_province` VALUES ('19','TP','Trapani','Libero consorzio di comuni',25,2470.0599,'081');
INSERT INTO `gi_province` VALUES ('10','TR','Terni','Provincia',33,2126.9428,'055');
INSERT INTO `gi_province` VALUES ('06','TS','Trieste','Unità non amministrativa',6,212.5113,'032');
INSERT INTO `gi_province` VALUES ('05','TV','Treviso','Provincia',94,2478.9348,'026');
INSERT INTO `gi_province` VALUES ('06','UD','Udine','Unità non amministrativa',134,4970.4991,'030');
INSERT INTO `gi_province` VALUES ('03','VA','Varese','Provincia',136,1198.6612,'012');
INSERT INTO `gi_province` VALUES ('01','VB','Verbano-Cusio-Ossola','Provincia',74,2262.1551,'103');
INSERT INTO `gi_province` VALUES ('01','VC','Vercelli','Provincia',82,2082.4067,'002');
INSERT INTO `gi_province` VALUES ('05','VE','Venezia','Citta metropolitana',44,2480.3727,'227');
INSERT INTO `gi_province` VALUES ('05','VI','Vicenza','Provincia',113,2721.8512,'024');
INSERT INTO `gi_province` VALUES ('05','VR','Verona','Provincia',98,3096.0326,'023');
INSERT INTO `gi_province` VALUES ('12','VT','Viterbo','Provincia',60,3615.0313,'056');
INSERT INTO `gi_province` VALUES ('18','VV','Vibo Valentia','Provincia',50,1149.3117,'102');
/*!40000 ALTER TABLE `gi_province` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gi_comuni`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gi_comuni` (
  `sigla_provincia` varchar(4) NOT NULL,
  `codice_istat` varchar(12) NOT NULL,
  `denominazione_ita_altra` varchar(191) NOT NULL,
  `denominazione_ita` varchar(191) NOT NULL,
  `denominazione_altra` varchar(191) NOT NULL,
  `flag_capoluogo` varchar(4) NOT NULL,
  `codice_belfiore` varchar(8) NOT NULL,
  `lat` decimal(13,7) NOT NULL,
  `lon` decimal(13,7) NOT NULL,
  `superficie_kmq` decimal(10,4) NOT NULL,
  `codice_sovracomunale` varchar(6) NOT NULL,
  PRIMARY KEY (`codice_istat`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gi_comuni` WRITE;
/*!40000 ALTER TABLE `gi_comuni` DISABLE KEYS */;
INSERT INTO `gi_comuni` VALUES ('TO','001001','Agliè','Agliè','','NO','A074',45.3634669,7.7686057,13.2407,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001002','Airasca','Airasca','','NO','A109',44.9170061,7.4845045,16.0327,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001003','Ala di Stura','Ala di Stura','','NO','A117',45.3149237,7.3043670,46.1749,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001004','Albiano d\'Ivrea','Albiano d\'Ivrea','','NO','A157',45.4336463,7.9495045,11.6770,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001006','Almese','Almese','','NO','A218',45.1176654,7.3951859,17.9879,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001007','Alpette','Alpette','','NO','A221',45.4099554,7.5785615,5.5557,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001008','Alpignano','Alpignano','','NO','A222',45.0944686,7.5242628,11.8972,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001009','Andezeno','Andezeno','','NO','A275',45.0358946,7.8699281,7.4766,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001010','Andrate','Andrate','','NO','A282',45.5283724,7.8738546,9.3573,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001011','Angrogna','Angrogna','','NO','A295',44.8436082,7.2242658,38.4088,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001012','Arignano','Arignano','','NO','A405',45.0437016,7.9018970,7.9611,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001013','Avigliana','Avigliana','','NO','A518',45.0793678,7.3963516,22.9933,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001014','Azeglio','Azeglio','','NO','A525',45.4248532,7.9947436,9.8641,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001015','Bairo','Bairo','','NO','A584',45.3862699,7.7569141,7.0805,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001016','Balangero','Balangero','','NO','A587',45.2700030,7.5192683,12.9315,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001017','Baldissero Canavese','Baldissero Canavese','','NO','A590',45.4084019,7.7443534,4.6465,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001018','Baldissero Torinese','Baldissero Torinese','','NO','A591',45.0684291,7.8177989,15.5118,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001019','Balme','Balme','','NO','A599',45.3023388,7.2183609,62.7379,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001020','Banchette','Banchette','','NO','A607',45.4608248,7.8563818,2.0108,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001021','Barbania','Barbania','','NO','A625',45.2904913,7.6304781,12.7821,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001022','Bardonecchia','Bardonecchia','','NO','A651',45.0781507,6.7038976,132.3111,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001023','Barone Canavese','Barone Canavese','','NO','A673',45.3277288,7.8705578,3.9888,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001024','Beinasco','Beinasco','','NO','A734',45.0220788,7.5790186,6.9173,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001025','Bibiana','Bibiana','','NO','A853',44.7975980,7.2898046,18.4711,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001026','Bobbio Pellice','Bobbio Pellice','','NO','A910',44.8076971,7.1170209,94.1049,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001027','Bollengo','Bollengo','','NO','A941',45.4733455,7.9453007,14.3398,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001028','Borgaro Torinese','Borgaro Torinese','','NO','A990',45.1520050,7.6578945,10.8136,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001029','Borgiallo','Borgiallo','','NO','B003',45.4167662,7.6677454,7.0506,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001030','Borgofranco d\'Ivrea','Borgofranco d\'Ivrea','','NO','B015',45.5124142,7.8594264,13.3007,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001031','Borgomasino','Borgomasino','','NO','B021',45.3616875,7.9887949,12.0970,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001032','Borgone Susa','Borgone Susa','','NO','B024',45.1231172,7.2412061,4.9407,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001033','Bosconero','Bosconero','','NO','B075',45.2686534,7.7651464,10.9326,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001034','Brandizzo','Brandizzo','','NO','B121',45.1775115,7.8414393,6.3944,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001035','Bricherasio','Bricherasio','','NO','B171',44.8255744,7.3028322,22.8629,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001036','Brosso','Brosso','','NO','B205',45.4926955,7.8033171,11.1146,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001037','Brozolo','Brozolo','','NO','B209',45.1173992,8.0712843,8.9214,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001038','Bruino','Bruino','','NO','B216',45.0202276,7.4677006,5.7648,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001039','Brusasco','Brusasco','','NO','B225',45.1560453,8.0601414,14.2210,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001040','Bruzolo','Bruzolo','','NO','B232',45.1431777,7.1939889,12.5302,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001041','Buriasco','Buriasco','','NO','B278',44.8735338,7.4118721,14.7791,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001042','Burolo','Burolo','','NO','B279',45.4840947,7.9319799,5.4655,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001043','Busano','Busano','','NO','B284',45.3288942,7.6554181,5.0997,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001044','Bussoleno','Bussoleno','','NO','B297',45.1373365,7.1493898,37.4083,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001045','Buttigliera Alta','Buttigliera Alta','','NO','B305',45.0669813,7.4368254,8.1008,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001046','Cafasse','Cafasse','','NO','B350',45.2446575,7.5181803,10.4286,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001047','Caluso','Caluso','','NO','B435',45.3078184,7.8914899,39.3056,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001048','Cambiano','Cambiano','','NO','B462',44.9734653,7.7792962,14.1118,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001049','Campiglione Fenile','Campiglione Fenile','','NO','B512',44.8021531,7.3250696,11.2164,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001050','Candia Canavese','Candia Canavese','','NO','B588',45.3281447,7.8865424,9.3217,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001051','Candiolo','Candiolo','','NO','B592',44.9603898,7.6013874,12.0907,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001052','Canischio','Canischio','','NO','B605',45.3743281,7.5951811,11.9514,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001053','Cantalupa','Cantalupa','','NO','B628',44.9402685,7.3326819,11.3822,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001054','Cantoira','Cantoira','','NO','B637',45.3432131,7.3817884,23.0569,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001055','Caprie','Caprie','','NO','B705',45.1178288,7.3325530,16.3344,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001056','Caravino','Caravino','','NO','B733',45.3986173,7.9601459,11.4834,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001057','Carema','Carema','','NO','B762',45.5844506,7.8123537,10.5759,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001058','Carignano','Carignano','','NO','B777',44.9080171,7.6760348,49.9511,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001059','Carmagnola','Carmagnola','','NO','B791',44.8464786,7.7180847,95.9817,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001060','Casalborgone','Casalborgone','','NO','B867',45.1299488,7.9405843,20.2674,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001061','Cascinette d\'Ivrea','Cascinette d\'Ivrea','','NO','B953',45.4787767,7.9038942,2.2658,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001062','Caselette','Caselette','','NO','B955',45.1058965,7.4832283,14.1999,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001063','Caselle Torinese','Caselle Torinese','','NO','B960',45.1772268,7.6479830,23.8012,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001064','Castagneto Po','Castagneto Po','','NO','C045',45.1606279,7.8870392,11.4318,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001065','Castagnole Piemonte','Castagnole Piemonte','','NO','C048',44.8985413,7.5665658,17.2175,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001066','Castellamonte','Castellamonte','','NO','C133',45.3833442,7.7098255,38.2575,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001067','Castelnuovo Nigra','Castelnuovo Nigra','','NO','C241',45.4372093,7.6952282,28.6535,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001068','Castiglione Torinese','Castiglione Torinese','','NO','C307',45.1233326,7.8162459,14.2039,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001069','Cavagnolo','Cavagnolo','','NO','C369',45.1521104,8.0513851,12.6643,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001070','Cavour','Cavour','','NO','C404',44.7841236,7.3751914,48.6086,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001071','Cercenasco','Cercenasco','','NO','C487',44.8612625,7.5012234,13.2433,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001072','Ceres','Ceres','','NO','C497',45.3130672,7.3893349,27.9603,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001073','Ceresole Reale','Ceresole Reale','','NO','C505',45.4325151,7.2325365,100.0257,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001074','Cesana Torinese','Cesana Torinese','','NO','C564',44.9524243,6.7942070,121.8391,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001075','Chialamberto','Chialamberto','','NO','C604',45.3628552,7.3458800,35.4132,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001076','Chianocco','Chianocco','','NO','C610',45.1485930,7.1695443,18.7972,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001077','Chiaverano','Chiaverano','','NO','C624',45.5003948,7.9023271,11.7809,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001078','Chieri','Chieri','','NO','C627',45.0131646,7.8210215,54.2119,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001079','Chiesanuova','Chiesanuova','','NO','C629',45.4174247,7.6568511,4.2282,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001080','Chiomonte','Chiomonte','','NO','C639',45.1196670,6.9840367,26.8478,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001081','Chiusa di San Michele','Chiusa di San Michele','','NO','C655',45.1015733,7.3264647,5.8307,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001082','Chivasso','Chivasso','','NO','C665',45.1908493,7.8871226,50.8683,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001083','Ciconio','Ciconio','','NO','C679',45.3303533,7.7599853,3.0449,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001084','Cintano','Cintano','','NO','C711',45.4279710,7.6867646,5.0355,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001085','Cinzano','Cinzano','','NO','C715',45.0938750,7.9210939,6.1823,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001086','Ciriè','Ciriè','','NO','C722',45.2317279,7.6045879,17.8430,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001087','Claviere','Claviere','','NO','C793',44.9385626,6.7493542,2.6844,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001088','Coassolo Torinese','Coassolo Torinese','','NO','C801',45.3010009,7.4614939,27.9457,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001089','Coazze','Coazze','','NO','C803',45.0514171,7.2947246,56.0503,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001090','Collegno','Collegno','','NO','C860',45.0774023,7.5691576,18.1874,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001091','Colleretto Castelnuovo','Colleretto Castelnuovo','','NO','C867',45.4214414,7.6789845,6.3067,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001092','Colleretto Giacosa','Colleretto Giacosa','','NO','C868',45.4328712,7.7999950,4.6628,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001093','Condove','Condove','','NO','C955',45.1170113,7.3105314,70.9524,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001094','Corio','Corio','','NO','D008',45.3127335,7.5326020,41.6073,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001095','Cossano Canavese','Cossano Canavese','','NO','D092',45.3883116,7.9934226,3.1156,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001096','Cuceglio','Cuceglio','','NO','D197',45.3587593,7.8148720,7.0072,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001097','Cumiana','Cumiana','','NO','D202',44.9827474,7.3741814,60.8053,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001098','Cuorgnè','Cuorgnè','','NO','D208',45.3913262,7.6486960,19.1172,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001099','Druento','Druento','','NO','D373',45.1342731,7.5762577,27.5180,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001100','Exilles','Exilles','','NO','D433',45.0974883,6.9296051,46.5827,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001101','Favria','Favria','','NO','D520',45.3328760,7.6879370,14.9446,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001102','Feletto','Feletto','','NO','D524',45.3054802,7.7471143,8.0921,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001103','Fenestrelle','Fenestrelle','','NO','D532',45.0339532,7.0517340,49.1852,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001104','Fiano','Fiano','','NO','D562',45.2181318,7.5197510,11.9079,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001105','Fiorano Canavese','Fiorano Canavese','','NO','D608',45.4675874,7.8289681,4.4557,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001106','Foglizzo','Foglizzo','','NO','D646',45.2720467,7.8231524,15.6107,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001107','Forno Canavese','Forno Canavese','','NO','D725',45.3467729,7.5867669,16.5492,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001108','Frassinetto','Frassinetto','','NO','D781',45.4360589,7.6057321,24.8678,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001109','Front','Front','','NO','D805',45.2794926,7.6657259,10.9346,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001110','Frossasco','Frossasco','','NO','D812',44.9334809,7.3508656,20.2477,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001111','Garzigliana','Garzigliana','','NO','D931',44.8367675,7.3747354,7.1974,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001112','Gassino Torinese','Gassino Torinese','','NO','D933',45.1274618,7.8246237,20.0507,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001113','Germagnano','Germagnano','','NO','D983',45.2620584,7.4666277,14.2223,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001114','Giaglione','Giaglione','','NO','E009',45.1397024,7.0141191,33.6589,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001115','Giaveno','Giaveno','','NO','E020',45.0447344,7.3530799,71.9214,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001116','Givoletto','Givoletto','','NO','E067',45.1588163,7.4968477,13.1063,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001117','Gravere','Gravere','','NO','E154',45.1239955,7.0209034,18.9759,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001118','Groscavallo','Groscavallo','','NO','E199',45.3688981,7.2823768,92.2074,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001119','Grosso','Grosso','','NO','E203',45.2578068,7.5582660,4.3392,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001120','Grugliasco','Grugliasco','','NO','E216',45.0619938,7.5777858,13.0865,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001121','Ingria','Ingria','','NO','E301',45.4661534,7.5708119,15.2309,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001122','Inverso Pinasca','Inverso Pinasca','','NO','E311',44.9471112,7.2159869,8.0552,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001123','Isolabella','Isolabella','','NO','E345',44.9066201,7.9093993,4.8314,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001124','Issiglio','Issiglio','','NO','E368',45.4468372,7.7540952,5.4014,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001125','Ivrea','Ivrea','','NO','E379',45.4662336,7.8759117,30.5098,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001126','La Cassa','La Cassa','','NO','E394',45.1818170,7.5191053,11.8554,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001127','La Loggia','La Loggia','','NO','E423',44.9566817,7.6676999,13.0895,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001128','Lanzo Torinese','Lanzo Torinese','','NO','E445',45.2722552,7.4765958,10.3843,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001129','Lauriano','Lauriano','','NO','E484',45.1584257,7.9915852,14.0697,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001130','Leini','Leini','','NO','E518',45.1839595,7.7149873,31.8759,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001131','Lemie','Lemie','','NO','E520',45.2286823,7.2927537,45.4474,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001132','Lessolo','Lessolo','','NO','E551',45.4757766,7.8140443,7.8232,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001133','Levone','Levone','','NO','E566',45.3181626,7.6059193,5.3962,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001134','Locana','Locana','','NO','E635',45.4169171,7.4617755,132.2437,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001135','Lombardore','Lombardore','','NO','E660',45.2356416,7.7362896,12.6186,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001136','Lombriasco','Lombriasco','','NO','E661',44.8416798,7.6359489,7.2857,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001137','Loranzè','Loranzè','','NO','E683',45.4413818,7.8110524,4.2485,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001139','Luserna San Giovanni','Luserna San Giovanni','','NO','E758',44.8144535,7.2460158,17.6374,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001140','Lusernetta','Lusernetta','','NO','E759',44.8026038,7.2497624,7.1318,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001141','Lusigliè','Lusigliè','','NO','E763',45.3185725,7.7664656,5.1510,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001142','Macello','Macello','','NO','E782',44.8511813,7.4008373,14.3349,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001143','Maglione','Maglione','','NO','E817',45.3476727,8.0117232,6.3965,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001144','Marentino','Marentino','','NO','E941',45.0580474,7.8733109,11.1559,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001145','Massello','Massello','','NO','F041',44.9585084,7.0570144,37.9355,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001146','Mathi','Mathi','','NO','F053',45.2567508,7.5411799,7.2130,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001147','Mattie','Mattie','','NO','F058',45.1188218,7.1120177,28.2778,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001148','Mazzè','Mazzè','','NO','F067',45.2985603,7.9368307,27.0427,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001149','Meana di Susa','Meana di Susa','','NO','F074',45.1210435,7.0684893,16.5905,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001150','Mercenasco','Mercenasco','','NO','F140',45.3570306,7.8826050,12.7399,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001152','Mezzenile','Mezzenile','','NO','F182',45.2923447,7.3949146,29.0525,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001153','Mombello di Torino','Mombello di Torino','','NO','F315',45.0463613,7.9195538,4.3443,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001154','Mompantero','Mompantero','','NO','F318',45.1399475,7.0580018,30.1456,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001155','Monastero di Lanzo','Monastero di Lanzo','','NO','F327',45.3014494,7.4391173,17.5545,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001156','Moncalieri','Moncalieri','','NO','F335',45.0009565,7.6853163,47.3946,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001157','Moncenisio','Moncenisio','','NO','D553',45.2052427,6.9835832,4.4607,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001158','Montaldo Torinese','Montaldo Torinese','','NO','F407',45.0663754,7.8509022,4.7439,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001159','Montalenghe','Montalenghe','','NO','F411',45.3377012,7.8397746,6.6070,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001160','Montalto Dora','Montalto Dora','','NO','F420',45.4938030,7.8640930,7.3980,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001161','Montanaro','Montanaro','','NO','F422',45.2329277,7.8528765,20.9776,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001162','Monteu da Po','Monteu da Po','','NO','F651',45.1504808,8.0147719,7.3803,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001163','Moriondo Torinese','Moriondo Torinese','','NO','F733',45.0390345,7.9440562,6.5533,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001164','Nichelino','Nichelino','','NO','F889',44.9951033,7.6475753,20.7664,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001165','Noasca','Noasca','','NO','F906',45.4542767,7.3147200,78.2832,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001166','Nole','Nole','','NO','F925',45.2421626,7.5745341,11.1980,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001167','Nomaglio','Nomaglio','','NO','F927',45.5351902,7.8597546,3.1131,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001168','None','None','','NO','F931',44.9323135,7.5412404,24.6858,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001169','Novalesa','Novalesa','','NO','F948',45.1875238,7.0146266,28.7921,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001170','Oglianico','Oglianico','','NO','G010',45.3426372,7.6927590,6.2768,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001171','Orbassano','Orbassano','','NO','G087',45.0070492,7.5369689,22.1491,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001172','Orio Canavese','Orio Canavese','','NO','G109',45.3284705,7.8603204,7.1912,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001173','Osasco','Osasco','','NO','G151',44.8494947,7.3429993,5.6143,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001174','Osasio','Osasio','','NO','G152',44.8694831,7.6076093,4.9401,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001175','Oulx','Oulx','','NO','G196',45.0312715,6.8322431,99.5177,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001176','Ozegna','Ozegna','','NO','G202',45.3489931,7.7432096,5.4178,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001177','Palazzo Canavese','Palazzo Canavese','','NO','G262',45.4577007,7.9782036,5.1450,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001178','Pancalieri','Pancalieri','','NO','G303',44.8304877,7.5881886,15.4009,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001179','Parella','Parella','','NO','G330',45.4300035,7.7909823,2.7322,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001180','Pavarolo','Pavarolo','','NO','G387',45.0686502,7.8352060,4.4638,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001181','Pavone Canavese','Pavone Canavese','','NO','G392',45.4352456,7.8539878,11.4805,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001183','Pecetto Torinese','Pecetto Torinese','','NO','G398',45.0185761,7.7486286,9.2476,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001184','Perosa Argentina','Perosa Argentina','','NO','G463',44.9581802,7.1922752,25.9475,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001185','Perosa Canavese','Perosa Canavese','','NO','G462',45.3971383,7.8292811,4.6306,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001186','Perrero','Perrero','','NO','G465',44.9374383,7.1152518,63.1720,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001187','Pertusio','Pertusio','','NO','G477',45.3532858,7.6388871,3.8854,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001188','Pessinetto','Pessinetto','','NO','G505',45.2905289,7.4028414,5.6202,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001189','Pianezza','Pianezza','','NO','G559',45.1007066,7.5465646,16.4082,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001190','Pinasca','Pinasca','','NO','G672',44.9426379,7.2277062,34.9661,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001191','Pinerolo','Pinerolo','','NO','G674',44.8873333,7.3320503,49.9877,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001192','Pino Torinese','Pino Torinese','','NO','G678',45.0434900,7.7721855,21.8061,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001193','Piobesi Torinese','Piobesi Torinese','','NO','G684',44.9330906,7.6119242,19.3538,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001194','Piossasco','Piossasco','','NO','G691',44.9906200,7.4626508,39.7727,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001195','Piscina','Piscina','','NO','G705',44.9194511,7.4259070,9.7560,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001196','Piverone','Piverone','','NO','G719',45.4475126,8.0070956,11.0868,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001197','Poirino','Poirino','','NO','G777',44.9211226,7.8436611,75.6908,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001198','Pomaretto','Pomaretto','','NO','G805',44.9550893,7.1821205,8.5166,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001199','Pont Canavese','Pont Canavese','','NO','G826',45.4207259,7.5937483,18.3676,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001200','Porte','Porte','','NO','G900',44.8876041,7.2680289,4.4359,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001201','Pragelato','Pragelato','','NO','G973',45.0162815,6.9423638,89.0846,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001202','Prali','Prali','','NO','G978',44.8892028,7.0487925,72.6308,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001203','Pralormo','Pralormo','','NO','G979',44.8613363,7.9006551,29.9367,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001204','Pramollo','Pramollo','','NO','G982',44.9044962,7.2116611,22.5421,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001205','Prarostino','Prarostino','','NO','G986',44.8657846,7.2698904,10.9127,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001206','Prascorsano','Prascorsano','','NO','G988',45.3676358,7.6157409,6.3692,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001207','Pratiglione','Pratiglione','','NO','G997',45.3537235,7.5961516,8.0238,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001208','Quagliuzzo','Quagliuzzo','','NO','H100',45.4264676,7.7818622,1.9468,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001209','Quassolo','Quassolo','','NO','H120',45.5248927,7.8326743,3.8872,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001210','Quincinetto','Quincinetto','','NO','H127',45.5609053,7.8058246,17.6063,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001211','Reano','Reano','','NO','H207',45.0518058,7.4295710,6.9073,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001212','Ribordone','Ribordone','','NO','H270',45.4315947,7.5023903,43.5611,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001213','Rivalba','Rivalba','','NO','H333',45.1187242,7.8872327,10.7161,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001214','Rivalta di Torino','Rivalta di Torino','','NO','H335',45.0345702,7.5233376,25.1163,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001215','Riva presso Chieri','Riva presso Chieri','','NO','H337',44.9862982,7.8689799,35.7344,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001216','Rivara','Rivara','','NO','H338',45.3323205,7.6251090,12.4540,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001217','Rivarolo Canavese','Rivarolo Canavese','','NO','H340',45.3326602,7.7253461,32.4061,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001218','Rivarossa','Rivarossa','','NO','H344',45.2512937,7.7171498,10.7585,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001219','Rivoli','Rivoli','','NO','H355',45.0701331,7.5338280,29.5165,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001220','Robassomero','Robassomero','','NO','H367',45.1999976,7.5702295,8.5866,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001221','Rocca Canavese','Rocca Canavese','','NO','H386',45.3091428,7.5789708,13.9344,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001222','Roletto','Roletto','','NO','H498',44.9251935,7.3306731,9.7144,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001223','Romano Canavese','Romano Canavese','','NO','H511',45.3913153,7.8678554,11.2427,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001224','Ronco Canavese','Ronco Canavese','','NO','H539',45.4994480,7.5456181,96.2584,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001225','Rondissone','Rondissone','','NO','H547',45.2466423,7.9656188,10.8409,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001226','Rorà','Rorà','','NO','H554',44.7926007,7.1975782,12.5584,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001227','Roure','Roure','','NO','H555',45.0009970,7.1291240,59.6585,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001228','Rosta','Rosta','','NO','H583',45.0713368,7.4640422,8.8569,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001229','Rubiana','Rubiana','','NO','H627',45.1391657,7.3824508,27.0456,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001230','Rueglio','Rueglio','','NO','H631',45.4678999,7.7558044,14.9395,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001231','Salassa','Salassa','','NO','H691',45.3596256,7.6893394,5.0629,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001232','Salbertrand','Salbertrand','','NO','H684',45.0723272,6.8836766,38.4476,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001233','Salerano Canavese','Salerano Canavese','','NO','H702',45.4564496,7.8498869,2.1355,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001234','Salza di Pinerolo','Salza di Pinerolo','','NO','H734',44.9406925,7.0530248,16.0352,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001235','Samone','Samone','','NO','H753',45.4493270,7.8457639,2.3781,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001236','San Benigno Canavese','San Benigno Canavese','','NO','H775',45.2240048,7.7826941,22.2443,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001237','San Carlo Canavese','San Carlo Canavese','','NO','H789',45.2481463,7.6102029,20.8112,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001238','San Colombano Belmonte','San Colombano Belmonte','','NO','H804',45.3819260,7.6183219,3.6092,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001239','San Didero','San Didero','','NO','H820',45.1351318,7.2151984,3.2869,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001240','San Francesco al Campo','San Francesco al Campo','','NO','H847',45.2255513,7.6556645,15.0038,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001241','Sangano','Sangano','','NO','H855',45.0262148,7.4504772,6.8081,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001242','San Germano Chisone','San Germano Chisone','','NO','H862',44.8986733,7.2408642,15.8806,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001243','San Gillio','San Gillio','','NO','H873',45.1420013,7.5338675,8.5727,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001244','San Giorgio Canavese','San Giorgio Canavese','','NO','H890',45.3355763,7.7941640,20.2368,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001245','San Giorio di Susa','San Giorio di Susa','','NO','H900',45.1283968,7.1775082,19.7443,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001246','San Giusto Canavese','San Giusto Canavese','','NO','H936',45.3123452,7.8082940,9.6905,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001247','San Martino Canavese','San Martino Canavese','','NO','H997',45.3944869,7.8183919,9.7520,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001248','San Maurizio Canavese','San Maurizio Canavese','','NO','I024',45.2189815,7.6306847,17.2200,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001249','San Mauro Torinese','San Mauro Torinese','','NO','I030',45.1030232,7.7663607,12.6388,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001250','San Pietro Val Lemina','San Pietro Val Lemina','','NO','I090',44.9073306,7.3135293,12.2964,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001251','San Ponso','San Ponso','','NO','I126',45.3508451,7.6675594,1.9194,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001252','San Raffaele Cimena','San Raffaele Cimena','','NO','I137',45.1472202,7.8487635,11.3369,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001253','San Sebastiano da Po','San Sebastiano da Po','','NO','I152',45.1664892,7.9535600,16.7266,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001254','San Secondo di Pinerolo','San Secondo di Pinerolo','','NO','I154',44.8667166,7.2986813,12.1729,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001255','Sant\'Ambrogio di Torino','Sant\'Ambrogio di Torino','','NO','I258',45.0996162,7.3591937,8.5325,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001256','Sant\'Antonino di Susa','Sant\'Antonino di Susa','','NO','I296',45.1071794,7.2735256,9.9452,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001257','Santena','Santena','','NO','I327',44.9488433,7.7725028,16.4538,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001258','Sauze di Cesana','Sauze di Cesana','','NO','I465',44.9404219,6.8605526,78.0498,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001259','Sauze d\'Oulx','Sauze d\'Oulx','','NO','I466',45.0280988,6.8582554,17.5152,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001260','Scalenghe','Scalenghe','','NO','I490',44.8883292,7.4979651,31.3834,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001261','Scarmagno','Scarmagno','','NO','I511',45.3858210,7.8408965,8.0046,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001262','Sciolze','Sciolze','','NO','I539',45.0950139,7.8776455,11.3644,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001263','Sestriere','Sestriere','','NO','I692',44.9576328,6.8764939,26.4401,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001264','Settimo Rottaro','Settimo Rottaro','','NO','I701',45.4048986,7.9922828,6.3192,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001265','Settimo Torinese','Settimo Torinese','','NO','I703',45.1369502,7.7712554,31.2707,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001266','Settimo Vittone','Settimo Vittone','','NO','I702',45.5461989,7.8343565,23.2521,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001267','Sparone','Sparone','','NO','I886',45.4133082,7.5442450,30.0701,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001268','Strambinello','Strambinello','','NO','I969',45.4233819,7.7687468,2.1320,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001269','Strambino','Strambino','','NO','I970',45.3846248,7.8806770,22.5362,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001270','Susa','Susa','','NO','L013',45.1352774,7.0464163,11.0425,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001271','Tavagnasco','Tavagnasco','','NO','L066',45.5431713,7.8225983,8.6068,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001272','Torino','Torino','','SI','L219',45.0732891,7.6806958,130.0282,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001273','Torrazza Piemonte','Torrazza Piemonte','','NO','L238',45.2151575,7.9748498,10.1198,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001274','Torre Canavese','Torre Canavese','','NO','L247',45.3918129,7.7605986,5.3765,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001275','Torre Pellice','Torre Pellice','','NO','L277',44.8208762,7.2236356,21.4086,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001276','Trana','Trana','','NO','L327',45.0370807,7.4173159,16.3859,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001278','Traversella','Traversella','','NO','L345',45.5089979,7.7497482,38.9818,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001279','Traves','Traves','','NO','L340',45.2705658,7.4297647,10.7070,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001280','Trofarello','Trofarello','','NO','L445',44.9859394,7.7401159,12.2550,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001281','Usseaux','Usseaux','','NO','L515',45.0490316,7.0279473,38.3679,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001282','Usseglio','Usseglio','','NO','L516',45.2326695,7.2172473,98.6094,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001283','Vaie','Vaie','','NO','L538',45.1019442,7.2864963,7.2567,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001284','Val della Torre','Val della Torre','','NO','L555',45.1555681,7.4494082,36.3071,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001285','Valgioie','Valgioie','','NO','L578',45.0759732,7.3399975,9.1885,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001286','Vallo Torinese','Vallo Torinese','','NO','L629',45.2234604,7.4992399,6.1546,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001287','Valperga','Valperga','','NO','L644',45.3699160,7.6567710,11.8564,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001288','Valprato Soana','Valprato Soana','','NO','B510',45.5223756,7.5489749,71.8341,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001289','Varisella','Varisella','','NO','L685',45.2101015,7.4894240,22.5555,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001290','Vauda Canavese','Vauda Canavese','','NO','L698',45.2794046,7.6181679,6.9598,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001291','Venaus','Venaus','','NO','L726',45.1547379,7.0119549,18.9292,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001292','Venaria Reale','Venaria Reale','','NO','L727',45.1325369,7.6315017,20.5679,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001293','Verolengo','Verolengo','','NO','L779',45.1902431,7.9699124,29.2622,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001294','Verrua Savoia','Verrua Savoia','','NO','L787',45.1565984,8.0931009,32.0709,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001295','Vestignè','Vestignè','','NO','L811',45.3866525,7.9538495,11.8257,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001296','Vialfrè','Vialfrè','','NO','L830',45.3808825,7.8182154,4.6576,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001298','Vidracco','Vidracco','','NO','L857',45.4303825,7.7589086,2.9424,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001299','Vigone','Vigone','','NO','L898',44.8421351,7.4945610,40.7815,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001300','Villafranca Piemonte','Villafranca Piemonte','','NO','L948',44.7810234,7.5044919,51.2713,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001301','Villanova Canavese','Villanova Canavese','','NO','L982',45.2428035,7.5540469,4.2592,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001302','Villarbasse','Villarbasse','','NO','M002',45.0449369,7.4679776,10.4499,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001303','Villar Dora','Villar Dora','','NO','L999',45.1177944,7.3838021,5.7354,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001304','Villareggia','Villareggia','','NO','M004',45.3109562,7.9784647,11.5731,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001305','Villar Focchiardo','Villar Focchiardo','','NO','M007',45.1096556,7.2265811,25.6492,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001306','Villar Pellice','Villar Pellice','','NO','M013',44.8086259,7.1583554,60.0830,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001307','Villar Perosa','Villar Perosa','','NO','M014',44.9202092,7.2492886,11.3742,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001308','Villastellone','Villastellone','','NO','M027',44.9215581,7.7452811,19.6779,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001309','Vinovo','Vinovo','','NO','M060',44.9487676,7.6342468,17.6055,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001310','Virle Piemonte','Virle Piemonte','','NO','M069',44.8660009,7.5690156,14.2887,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001311','Vische','Vische','','NO','M071',45.3332672,7.9508054,17.2094,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001312','Vistrorio','Vistrorio','','NO','M080',45.4410792,7.7693372,4.8076,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001313','Viù','Viù','','NO','M094',45.2389483,7.3764677,84.2413,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001314','Volpiano','Volpiano','','NO','M122',45.2019855,7.7756018,32.4890,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001315','Volvera','Volvera','','NO','M133',44.9550567,7.5123717,21.0411,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001316','Mappano','Mappano','','NO','M316',45.1477232,7.7062633,9.7795,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001317','Val di Chy','Val di Chy','','NO','M405',45.4602040,7.7769592,13.8081,'201');
INSERT INTO `gi_comuni` VALUES ('TO','001318','Valchiusa','Valchiusa','','NO','M415',45.4943236,7.7794356,50.0775,'201');
INSERT INTO `gi_comuni` VALUES ('VC','002002','Alagna Valsesia','Alagna Valsesia','','NO','A119',45.8533433,7.9380903,133.8267,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002003','Albano Vercellese','Albano Vercellese','','NO','A130',45.4251777,8.3804928,13.9237,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002004','Alice Castello','Alice Castello','','NO','A198',45.3665256,8.0748050,24.5687,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002006','Arborio','Arborio','','NO','A358',45.4961087,8.3890054,22.9725,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002007','Asigliano Vercellese','Asigliano Vercellese','','NO','A466',45.2612274,8.4062038,26.3671,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002008','Balmuccia','Balmuccia','','NO','A600',45.8184287,8.1381009,9.6814,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002009','Balocco','Balocco','','NO','A601',45.4555733,8.2810247,16.7051,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002011','Bianzè','Bianzè','','NO','A847',45.3073896,8.1200343,41.9853,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002014','Boccioleto','Boccioleto','','NO','A914',45.8299673,8.1132939,33.6004,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002015','Borgo d\'Ale','Borgo d\'Ale','','NO','B009',45.3500173,8.0533733,39.6074,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002016','Borgosesia','Borgosesia','','NO','B041',45.7169175,8.2763563,41.1322,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002017','Borgo Vercelli','Borgo Vercelli','','NO','B046',45.3571343,8.4664437,19.3646,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002021','Buronzo','Buronzo','','NO','B280',45.4820959,8.2682816,25.0583,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002025','Campertogno','Campertogno','','NO','B505',45.7992405,8.0319955,34.5229,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002029','Carcoforo','Carcoforo','','NO','B752',45.9095077,8.0501304,22.7034,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002030','Caresana','Caresana','','NO','B767',45.2210317,8.5065028,23.8614,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002031','Caresanablot','Caresanablot','','NO','B768',45.3546894,8.3950800,10.7619,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002032','Carisio','Carisio','','NO','B782',45.4085899,8.1986488,29.7352,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002033','Casanova Elvo','Casanova Elvo','','NO','B928',45.3995512,8.2932972,16.3220,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002035','San Giacomo Vercellese','San Giacomo Vercellese','','NO','B952',45.4973587,8.3254526,9.6221,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002041','Cervatto','Cervatto','','NO','C548',45.8831907,8.1619161,9.7564,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002042','Cigliano','Cigliano','','NO','C680',45.3095741,8.0215075,25.4344,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002043','Civiasco','Civiasco','','NO','C757',45.8067941,8.2929290,7.4153,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002045','Collobiano','Collobiano','','NO','C884',45.3970812,8.3485733,8.9052,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002047','Costanzana','Costanzana','','NO','D113',45.2362016,8.3700480,20.5940,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002048','Cravagliana','Cravagliana','','NO','D132',45.8472240,8.2010621,34.8122,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002049','Crescentino','Crescentino','','NO','D154',45.1922243,8.1025205,47.8762,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002052','Crova','Crova','','NO','D187',45.3300515,8.2119560,14.0401,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002054','Desana','Desana','','NO','D281',45.2686726,8.3576894,16.7260,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002057','Fobello','Fobello','','NO','D641',45.8895243,8.1589386,28.2579,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002058','Fontanetto Po','Fontanetto Po','','NO','D676',45.1934858,8.1916100,23.2743,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002059','Formigliana','Formigliana','','NO','D712',45.4285834,8.2934452,16.8996,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002061','Gattinara','Gattinara','','NO','D938',45.6179229,8.3707626,33.7087,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002062','Ghislarengo','Ghislarengo','','NO','E007',45.5293119,8.3844347,12.6316,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002065','Greggio','Greggio','','NO','E163',45.4517299,8.3824334,12.0095,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002066','Guardabosone','Guardabosone','','NO','E237',45.7017497,8.2504035,6.2755,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002067','Lamporo','Lamporo','','NO','E433',45.2300239,8.0973859,9.8583,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002068','Lenta','Lenta','','NO','E528',45.5555768,8.3846004,18.9963,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002070','Lignana','Lignana','','NO','E583',45.2853163,8.3460624,22.2939,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002071','Livorno Ferraris','Livorno Ferraris','','NO','E626',45.2816599,8.0820345,58.0077,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002072','Lozzolo','Lozzolo','','NO','E711',45.6221459,8.3220233,6.7051,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002078','Mollia','Mollia','','NO','F297',45.8152849,8.0310091,13.5470,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002079','Moncrivello','Moncrivello','','NO','F342',45.3312414,7.9958681,19.8658,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002082','Motta de\' Conti','Motta de\' Conti','','NO','F774',45.1930881,8.5203608,11.4923,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002088','Olcenengo','Olcenengo','','NO','G016',45.3635894,8.3113958,16.4029,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002089','Oldenico','Oldenico','','NO','G018',45.4023734,8.3826833,6.7187,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002090','Palazzolo Vercellese','Palazzolo Vercellese','','NO','G266',45.1844798,8.2328541,14.3626,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002091','Pertengo','Pertengo','','NO','G471',45.2356218,8.4176310,8.5179,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002093','Pezzana','Pezzana','','NO','G528',45.2621670,8.4841787,17.2402,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002096','Pila','Pila','','NO','G666',45.7702168,8.0808508,9.0284,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002097','Piode','Piode','','NO','G685',45.7697761,8.0527669,13.1165,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002102','Postua','Postua','','NO','G940',45.7142284,8.2314964,16.1718,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002104','Prarolo','Prarolo','','NO','G985',45.2821620,8.4792928,11.6908,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002107','Quarona','Quarona','','NO','H108',45.7598673,8.2654611,16.4261,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002108','Quinto Vercellese','Quinto Vercellese','','NO','H132',45.3804772,8.3621678,10.9581,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002110','Rassa','Rassa','','NO','H188',45.7691927,8.0151122,43.8761,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002113','Rimella','Rimella','','NO','H293',45.9082620,8.1819034,25.9965,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002115','Rive','Rive','','NO','H346',45.2126066,8.4183070,9.4023,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002116','Roasio','Roasio','','NO','H365',45.6087028,8.2889560,27.8330,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002118','Ronsecco','Ronsecco','','NO','H549',45.2536696,8.2777377,24.3399,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002121','Rossa','Rossa','','NO','H577',45.8335536,8.1256335,12.0034,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002122','Rovasenda','Rovasenda','','NO','H364',45.5367138,8.3136841,29.3320,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002126','Salasco','Salasco','','NO','H690',45.3253311,8.2636722,12.0691,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002127','Sali Vercellese','Sali Vercellese','','NO','H707',45.3093805,8.3297391,8.8992,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002128','Saluggia','Saluggia','','NO','H725',45.2358678,8.0112083,31.9311,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002131','San Germano Vercellese','San Germano Vercellese','','NO','H861',45.3502903,8.2510737,30.6976,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002133','Santhià','Santhià','','NO','I337',45.3669515,8.1743400,53.3340,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002134','Scopa','Scopa','','NO','I544',45.7917247,8.1129765,22.4730,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002135','Scopello','Scopello','','NO','I545',45.7736558,8.0948674,18.2342,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002137','Serravalle Sesia','Serravalle Sesia','','NO','I663',45.6861532,8.3114647,20.6115,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002142','Stroppiana','Stroppiana','','NO','I984',45.2314128,8.4533186,18.5022,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002147','Tricerro','Tricerro','','NO','L420',45.2338530,8.3250521,12.1636,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002148','Trino','Trino','','NO','L429',45.1941660,8.2968829,70.4394,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002150','Tronzano Vercellese','Tronzano Vercellese','','NO','L451',45.3427197,8.1745758,44.7473,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002152','Valduggia','Valduggia','','NO','L566',45.7263817,8.3278468,28.1124,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002156','Varallo','Varallo','','NO','L669',45.8139621,8.2561968,102.9418,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002158','Vercelli','Vercelli','','SI','L750',45.3239845,8.4232144,79.9556,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002163','Villarboit','Villarboit','','NO','M003',45.4365745,8.3367442,25.6215,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002164','Villata','Villata','','NO','M028',45.3854396,8.4328002,14.6991,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002166','Vocca','Vocca','','NO','M106',45.8310243,8.1874999,20.1894,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002170','Alto Sermenza','Alto Sermenza','','NO','M389',45.8584278,8.0630581,60.2410,'002');
INSERT INTO `gi_comuni` VALUES ('VC','002171','Cellio con Breia','Cellio con Breia','','NO','M398',45.7554576,8.3131315,17.4209,'002');
INSERT INTO `gi_comuni` VALUES ('NO','003001','Agrate Conturbia','Agrate Conturbia','','NO','A088',45.6760853,8.5598353,14.5400,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003002','Ameno','Ameno','','NO','A264',45.7888831,8.4395097,10.1309,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003006','Armeno','Armeno','','NO','A414',45.8219823,8.4391625,31.2865,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003008','Arona','Arona','','NO','A429',45.7604427,8.5596661,14.9937,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003012','Barengo','Barengo','','NO','A653',45.5747120,8.5121523,19.5793,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003016','Bellinzago Novarese','Bellinzago Novarese','','NO','A752',45.5699618,8.6401943,39.4166,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003018','Biandrate','Biandrate','','NO','A844',45.4538720,8.4636849,12.1177,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003019','Boca','Boca','','NO','A911',45.6784331,8.4088915,9.5750,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003021','Bogogno','Bogogno','','NO','A929',45.6671713,8.5344759,8.5639,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003022','Bolzano Novarese','Bolzano Novarese','','NO','A953',45.7628699,8.4441637,3.6285,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003023','Borgolavezzaro','Borgolavezzaro','','NO','B016',45.3183562,8.6993390,21.1844,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003024','Borgomanero','Borgomanero','','NO','B019',45.6987411,8.4631085,31.6402,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003025','Borgo Ticino','Borgo Ticino','','NO','B043',45.6877412,8.6051198,13.2118,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003026','Briga Novarese','Briga Novarese','','NO','B176',45.7314826,8.4514911,4.8352,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003027','Briona','Briona','','NO','B183',45.5421887,8.4798095,24.6202,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003030','Caltignaga','Caltignaga','','NO','B431',45.5170977,8.5875877,22.3202,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003032','Cameri','Cameri','','NO','B473',45.5010792,8.6622246,40.1201,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003036','Carpignano Sesia','Carpignano Sesia','','NO','B823',45.5352457,8.4182732,14.5806,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003037','Casalbeltrame','Casalbeltrame','','NO','B864',45.4360610,8.4684360,16.1064,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003039','Casaleggio Novara','Casaleggio Novara','','NO','B883',45.4861551,8.4926366,10.2577,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003040','Casalino','Casalino','','NO','B897',45.3576824,8.5227151,39.2353,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003041','Casalvolone','Casalvolone','','NO','B920',45.3993759,8.4640911,17.4406,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003042','Castellazzo Novarese','Castellazzo Novarese','','NO','C149',45.5140156,8.4887096,11.1362,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003043','Castelletto sopra Ticino','Castelletto sopra Ticino','','NO','C166',45.7140506,8.6423544,14.8541,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003044','Cavaglietto','Cavaglietto','','NO','C364',45.6031297,8.5009758,6.4447,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003045','Cavaglio d\'Agogna','Cavaglio d\'Agogna','','NO','C365',45.6121759,8.4829540,9.9230,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003047','Cavallirio','Cavallirio','','NO','C378',45.6650072,8.3967207,8.2700,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003049','Cerano','Cerano','','NO','C483',45.4108206,8.7808342,32.9875,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003051','Colazza','Colazza','','NO','C829',45.7905461,8.4973044,2.9749,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003052','Comignago','Comignago','','NO','C926',45.7116349,8.5629843,4.3483,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003055','Cressa','Cressa','','NO','D162',45.6480752,8.5071919,7.1937,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003058','Cureggio','Cureggio','','NO','D216',45.6751255,8.4613425,8.4253,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003060','Divignano','Divignano','','NO','D309',45.6623177,8.6015221,5.0052,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003062','Dormelletto','Dormelletto','','NO','D347',45.7299471,8.5732374,7.1835,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003065','Fara Novarese','Fara Novarese','','NO','D492',45.5551553,8.4590680,9.1297,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003066','Fontaneto d\'Agogna','Fontaneto d\'Agogna','','NO','D675',45.6399695,8.4841803,21.3003,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003068','Galliate','Galliate','','NO','D872',45.4776303,8.6952155,29.2244,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003069','Garbagna Novarese','Garbagna Novarese','','NO','D911',45.3866557,8.6596751,10.0525,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003070','Gargallo','Gargallo','','NO','D921',45.7275177,8.4292431,3.8321,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003073','Ghemme','Ghemme','','NO','E001',45.5977769,8.4201445,20.3587,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003076','Gozzano','Gozzano','','NO','E120',45.7474019,8.4346675,12.2126,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003077','Granozzo con Monticello','Granozzo con Monticello','','NO','E143',45.3597821,8.5737831,19.1445,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003079','Grignasco','Grignasco','','NO','E177',45.6820262,8.3396951,14.3431,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003082','Invorio','Invorio','','NO','E314',45.7558822,8.4868148,17.3834,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003083','Landiona','Landiona','','NO','E436',45.4968621,8.4221343,7.2531,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003084','Lesa','Lesa','','NO','E544',45.8300977,8.5647848,13.4172,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003088','Maggiora','Maggiora','','NO','E803',45.6907794,8.4210033,10.9345,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003090','Mandello Vitta','Mandello Vitta','','NO','E880',45.4951692,8.4591716,5.7968,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003091','Marano Ticino','Marano Ticino','','NO','E907',45.6297598,8.6319372,8.1004,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003093','Massino Visconti','Massino Visconti','','NO','F047',45.8219023,8.5388064,6.8691,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003095','Meina','Meina','','NO','F093',45.7900453,8.5376919,7.5635,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003097','Mezzomerico','Mezzomerico','','NO','F188',45.6202726,8.6045925,7.5980,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003098','Miasino','Miasino','','NO','F191',45.8021058,8.4302634,5.4584,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003100','Momo','Momo','','NO','F317',45.5739320,8.5553671,23.2701,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003103','Nebbiuno','Nebbiuno','','NO','F859',45.8060806,8.5242221,8.2726,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003104','Nibbiola','Nibbiola','','NO','F886',45.3718476,8.6563164,11.5944,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003106','Novara','Novara','','SI','F952',45.4458504,8.6219480,102.8995,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003108','Oleggio','Oleggio','','NO','G019',45.5963825,8.6374759,37.5585,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003109','Oleggio Castello','Oleggio Castello','','NO','G020',45.7493850,8.5298410,6.1314,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003112','Orta San Giulio','Orta San Giulio','','NO','G134',45.7998369,8.4051688,6.6457,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003114','Paruzzaro','Paruzzaro','','NO','G349',45.7486889,8.5133252,5.4444,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003115','Pella','Pella','','NO','G421',45.7970766,8.3831702,7.9348,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003116','Pettenasco','Pettenasco','','NO','G520',45.8173284,8.4085679,7.1000,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003119','Pisano','Pisano','','NO','G703',45.7935374,8.5104159,2.8094,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003120','Pogno','Pogno','','NO','G775',45.7566695,8.3831012,9.9212,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003121','Pombia','Pombia','','NO','G809',45.6491038,8.6327453,12.3470,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003122','Prato Sesia','Prato Sesia','','NO','H001',45.6478623,8.3737385,12.3737,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003129','Recetto','Recetto','','NO','H213',45.4609596,8.4365359,8.8344,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003130','Romagnano Sesia','Romagnano Sesia','','NO','H502',45.6333932,8.3826912,17.9953,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003131','Romentino','Romentino','','NO','H518',45.4626025,8.7208650,17.6482,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003133','San Maurizio d\'Opaglio','San Maurizio d\'Opaglio','','NO','I025',45.7723901,8.3910007,8.6515,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003134','San Nazzaro Sesia','San Nazzaro Sesia','','NO','I052',45.4380942,8.4235444,11.4399,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003135','San Pietro Mosezzo','San Pietro Mosezzo','','NO','I116',45.4556397,8.5434353,35.1539,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003138','Sillavengo','Sillavengo','','NO','I736',45.5204214,8.4404986,9.7620,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003139','Sizzano','Sizzano','','NO','I767',45.5773308,8.4373053,10.8530,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003140','Soriso','Soriso','','NO','I857',45.7424197,8.4091416,6.4252,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003141','Sozzago','Sozzago','','NO','I880',45.3979676,8.7209912,12.8600,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003143','Suno','Suno','','NO','L007',45.6311547,8.5409006,21.3862,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003144','Terdobbiate','Terdobbiate','','NO','L104',45.3763443,8.6951047,8.5690,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003146','Tornaco','Tornaco','','NO','L223',45.3574195,8.7179151,12.9713,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003149','Trecate','Trecate','','NO','L356',45.4318269,8.7349776,38.3832,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003153','Vaprio d\'Agogna','Vaprio d\'Agogna','','NO','L668',45.6035576,8.5540248,10.1734,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003154','Varallo Pombia','Varallo Pombia','','NO','L670',45.6671991,8.6334322,13.6061,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003158','Vespolate','Vespolate','','NO','L808',45.3495042,8.6690243,17.7477,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003159','Vicolungo','Vicolungo','','NO','L847',45.4788013,8.4612454,13.3519,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003164','Vinzaglio','Vinzaglio','','NO','M062',45.3236605,8.5183846,15.5827,'003');
INSERT INTO `gi_comuni` VALUES ('NO','003166','Gattico-Veruno','Gattico-Veruno','','NO','M416',45.7090414,8.5204495,26.3397,'003');
INSERT INTO `gi_comuni` VALUES ('CN','004001','Acceglio','Acceglio','','NO','A016',44.4757747,6.9911262,152.0795,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004002','Aisone','Aisone','','NO','A113',44.3134963,7.2208087,37.2255,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004003','Alba','Alba','','NO','A124',44.7010636,8.0358650,53.1846,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004004','Albaretto della Torre','Albaretto della Torre','','NO','A139',44.5958525,8.0640777,4.5606,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004005','Alto','Alto','','NO','A238',44.1082408,8.0035104,7.7155,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004006','Argentera','Argentera','','NO','A394',44.3795647,6.9693790,76.4328,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004007','Arguello','Arguello','','NO','A396',44.5829453,8.1107105,4.9895,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004008','Bagnasco','Bagnasco','','NO','A555',44.3020108,8.0425744,30.6151,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004009','Bagnolo Piemonte','Bagnolo Piemonte','','NO','A571',44.7599564,7.3153725,63.3463,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004010','Baldissero d\'Alba','Baldissero d\'Alba','','NO','A589',44.7586894,7.9155818,15.2008,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004011','Barbaresco','Barbaresco','','NO','A629',44.7255261,8.0805074,7.7103,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004012','Barge','Barge','','NO','A660',44.7252317,7.3236942,81.6488,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004013','Barolo','Barolo','','NO','A671',44.6099777,7.9418227,5.5783,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004014','Bastia Mondovì','Bastia Mondovì','','NO','A709',44.4413431,7.8933181,12.3639,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004015','Battifollo','Battifollo','','NO','A716',44.3191918,8.0095719,11.2317,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004016','Beinette','Beinette','','NO','A735',44.3656422,7.6457490,17.6690,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004017','Bellino','Bellino','','NO','A750',44.5807274,7.0147325,62.1064,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004018','Belvedere Langhe','Belvedere Langhe','','NO','A774',44.4945899,7.9740884,4.8454,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004019','Bene Vagienna','Bene Vagienna','','NO','A779',44.5451996,7.8328219,48.8357,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004020','Benevello','Benevello','','NO','A782',44.6281561,8.1057596,5.3025,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004021','Bergolo','Bergolo','','NO','A798',44.5479773,8.1835731,3.2270,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004022','Bernezzo','Bernezzo','','NO','A805',44.3885948,7.4353252,26.0966,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004023','Bonvicino','Bonvicino','','NO','A979',44.5036408,8.0158248,7.2945,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004024','Borgomale','Borgomale','','NO','B018',44.6203380,8.1328266,8.3226,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004025','Borgo San Dalmazzo','Borgo San Dalmazzo','','NO','B033',44.3287307,7.4875792,22.1112,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004026','Bosia','Bosia','','NO','B079',44.6025463,8.1462310,5.5728,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004027','Bossolasco','Bossolasco','','NO','B084',44.5267619,8.0575084,14.7239,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004028','Boves','Boves','','NO','B101',44.3297580,7.5516836,51.2054,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004029','Bra','Bra','','NO','B111',44.6981854,7.8546811,59.3977,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004030','Briaglia','Briaglia','','NO','B167',44.3950610,7.8769069,6.3155,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004031','Briga Alta','Briga Alta','','NO','B175',44.0832339,7.7508240,51.8327,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004032','Brondello','Brondello','','NO','B200',44.6013397,7.4078098,10.2021,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004033','Brossasco','Brossasco','','NO','B204',44.5701756,7.3609686,27.7689,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004034','Busca','Busca','','NO','B285',44.5135354,7.4734820,76.3141,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004035','Camerana','Camerana','','NO','B467',44.4226636,8.1407764,23.5912,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004037','Canale','Canale','','NO','B573',44.7971679,7.9914244,18.0783,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004038','Canosio','Canosio','','NO','B621',44.4552894,7.0813641,48.1219,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004039','Caprauna','Caprauna','','NO','B692',44.1158460,7.9548871,11.6152,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004040','Caraglio','Caraglio','','NO','B719',44.4176825,7.4275651,41.9043,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004041','Caramagna Piemonte','Caramagna Piemonte','','NO','B720',44.7804338,7.7411636,26.3781,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004042','Cardè','Cardè','','NO','B755',44.7441377,7.4782657,19.4029,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004043','Carrù','Carrù','','NO','B841',44.4785513,7.8802367,25.8218,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004044','Cartignano','Cartignano','','NO','B845',44.4769253,7.2878915,6.3472,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004045','Casalgrasso','Casalgrasso','','NO','B894',44.8193516,7.6251596,17.8827,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004046','Castagnito','Castagnito','','NO','C046',44.7565100,8.0300963,7.0965,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004047','Casteldelfino','Casteldelfino','','NO','C081',44.5909842,7.0690308,33.9267,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004049','Castelletto Stura','Castelletto Stura','','NO','C165',44.4441955,7.6390663,16.9844,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004050','Castelletto Uzzone','Castelletto Uzzone','','NO','C167',44.4943580,8.1886150,15.2683,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004051','Castellinaldo d\'Alba','Castellinaldo d\'Alba','','NO','C173',44.7754860,8.0316605,7.6011,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004052','Castellino Tanaro','Castellino Tanaro','','NO','C176',44.4277301,7.9818733,11.2329,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004053','Castelmagno','Castelmagno','','NO','C205',44.4092292,7.2124112,49.3761,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004054','Castelnuovo di Ceva','Castelnuovo di Ceva','','NO','C214',44.3549053,8.1277030,6.2642,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004055','Castiglione Falletto','Castiglione Falletto','','NO','C314',44.6233151,7.9790685,4.8335,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004056','Castiglione Tinella','Castiglione Tinella','','NO','C317',44.7260957,8.1894800,11.8359,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004057','Castino','Castino','','NO','C323',44.6170564,8.1812254,15.6268,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004058','Cavallerleone','Cavallerleone','','NO','C375',44.7395794,7.6628412,16.5825,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004059','Cavallermaggiore','Cavallermaggiore','','NO','C376',44.7078749,7.6877385,51.2757,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004060','Celle di Macra','Celle di Macra','','NO','C441',44.4825401,7.1796819,31.5003,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004061','Centallo','Centallo','','NO','C466',44.5008919,7.5869249,42.6012,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004062','Ceresole Alba','Ceresole Alba','','NO','C504',44.7994688,7.8206197,37.1599,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004063','Cerretto Langhe','Cerretto Langhe','','NO','C530',44.5743611,8.0978133,9.8602,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004064','Cervasca','Cervasca','','NO','C547',44.3829408,7.4682686,18.3174,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004065','Cervere','Cervere','','NO','C550',44.6346754,7.7931627,18.8551,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004066','Ceva','Ceva','','NO','C589',44.3861728,8.0351954,43.1998,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004067','Cherasco','Cherasco','','NO','C599',44.6522131,7.8582499,81.1392,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004068','Chiusa di Pesio','Chiusa di Pesio','','NO','C653',44.3247041,7.6779404,95.7309,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004069','Cigliè','Cigliè','','NO','C681',44.4353702,7.9263117,5.7882,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004070','Cissone','Cissone','','NO','C738',44.5630441,8.0305312,5.9856,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004071','Clavesana','Clavesana','','NO','C792',44.4821466,7.9120654,17.1105,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004072','Corneliano d\'Alba','Corneliano d\'Alba','','NO','D022',44.7354899,7.9613258,9.8310,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004073','Cortemilia','Cortemilia','','NO','D062',44.5809003,8.1919263,24.9875,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004074','Cossano Belbo','Cossano Belbo','','NO','D093',44.6690265,8.1986566,20.7652,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004075','Costigliole Saluzzo','Costigliole Saluzzo','','NO','D120',44.5646197,7.4850170,15.3999,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004076','Cravanzana','Cravanzana','','NO','D133',44.5731485,8.1282172,8.4215,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004077','Crissolo','Crissolo','','NO','D172',44.6990019,7.1572847,52.1862,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004078','Cuneo','Cuneo','','SI','D205',44.3932959,7.5512277,119.6040,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004079','Demonte','Demonte','','NO','D271',44.3153331,7.2975503,127.0172,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004080','Diano d\'Alba','Diano d\'Alba','','NO','D291',44.6514464,8.0276856,17.3307,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004081','Dogliani','Dogliani','','NO','D314',44.5299748,7.9449441,35.6590,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004082','Dronero','Dronero','','NO','D372',44.4674954,7.3630286,58.3343,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004083','Elva','Elva','','NO','D401',44.5397173,7.0896081,26.0868,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004084','Entracque','Entracque','','NO','D410',44.2407422,7.3977731,161.1097,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004085','Envie','Envie','','NO','D412',44.6818228,7.3721825,25.0771,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004086','Farigliano','Farigliano','','NO','D499',44.5117458,7.9170361,16.4286,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004087','Faule','Faule','','NO','D511',44.8054495,7.5806752,7.2630,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004088','Feisoglio','Feisoglio','','NO','D523',44.5433588,8.1042745,7.4264,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004089','Fossano','Fossano','','NO','D742',44.5493716,7.7248397,129.6495,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004090','Frabosa Soprana','Frabosa Soprana','','NO','D751',44.2872961,7.8066838,47.1459,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004091','Frabosa Sottana','Frabosa Sottana','','NO','D752',44.3020837,7.7983016,37.9299,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004092','Frassino','Frassino','','NO','D782',44.5713420,7.2757209,16.9072,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004093','Gaiola','Gaiola','','NO','D856',44.3352030,7.4068005,5.1563,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004094','Gambasca','Gambasca','','NO','D894',44.6293828,7.3475098,5.5257,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004095','Garessio','Garessio','','NO','D920',44.1971891,8.0300498,130.3570,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004096','Genola','Genola','','NO','D967',44.5879574,7.6626001,14.0349,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004097','Gorzegno','Gorzegno','','NO','E111',44.5118324,8.1351125,14.2204,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004098','Gottasecca','Gottasecca','','NO','E115',44.4617130,8.1671339,13.7191,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004099','Govone','Govone','','NO','E118',44.8046803,8.0998171,19.1389,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004100','Grinzane Cavour','Grinzane Cavour','','NO','E182',44.6565548,7.9821516,3.9535,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004101','Guarene','Guarene','','NO','E251',44.7377803,8.0336407,13.5402,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004102','Igliano','Igliano','','NO','E282',44.4434642,8.0124698,3.2942,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004103','Isasca','Isasca','','NO','E327',44.5870893,7.3814035,5.3862,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004104','Lagnasco','Lagnasco','','NO','E406',44.6246191,7.5552578,18.0543,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004105','La Morra','La Morra','','NO','E430',44.6373352,7.9334918,24.3903,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004106','Lequio Berria','Lequio Berria','','NO','E540',44.6045887,8.0976968,11.8662,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004107','Lequio Tanaro','Lequio Tanaro','','NO','E539',44.5603195,7.8836143,12.1828,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004108','Lesegno','Lesegno','','NO','E546',44.4012286,7.9665852,14.2354,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004109','Levice','Levice','','NO','E564',44.5376157,8.1566211,15.6354,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004110','Limone Piemonte','Limone Piemonte','','NO','E597',44.2013522,7.5760457,70.8014,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004111','Lisio','Lisio','','NO','E615',44.3066638,7.9797521,8.1336,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004112','Macra','Macra','','NO','E789',44.4998778,7.1792259,24.2385,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004113','Magliano Alfieri','Magliano Alfieri','','NO','E809',44.7664785,8.0678110,9.3602,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004114','Magliano Alpi','Magliano Alpi','','NO','E808',44.4581287,7.7995736,33.0423,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004115','Mango','Mango','','NO','E887',44.6845446,8.1503795,19.8580,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004116','Manta','Manta','','NO','E894',44.6142723,7.4863262,11.7443,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004117','Marene','Marene','','NO','E939',44.6613564,7.7289334,28.9306,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004118','Margarita','Margarita','','NO','E945',44.4025411,7.6868558,11.4749,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004119','Marmora','Marmora','','NO','E963',44.4575197,7.0944606,40.8981,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004120','Marsaglia','Marsaglia','','NO','E973',44.4522811,7.9830170,13.3421,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004121','Martiniana Po','Martiniana Po','','NO','E988',44.6263906,7.3663226,13.2859,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004122','Melle','Melle','','NO','F114',44.5623409,7.3206087,27.9766,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004123','Moiola','Moiola','','NO','F279',44.3196828,7.3888555,15.4453,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004124','Mombarcaro','Mombarcaro','','NO','F309',44.4677434,8.0863646,20.4047,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004125','Mombasiglio','Mombasiglio','','NO','F312',44.3633555,7.9697961,17.7983,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004126','Monastero di Vasco','Monastero di Vasco','','NO','F326',44.3400640,7.8228866,17.3340,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004127','Monasterolo Casotto','Monasterolo Casotto','','NO','F329',44.3307547,7.9410501,7.8642,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004128','Monasterolo di Savigliano','Monasterolo di Savigliano','','NO','F330',44.6861988,7.6208212,15.1243,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004129','Monchiero','Monchiero','','NO','F338',44.5730028,7.9180610,5.0070,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004130','Mondovì','Mondovì','','NO','F351',44.3871333,7.8197531,86.3421,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004131','Monesiglio','Monesiglio','','NO','F355',44.4649004,8.1163577,12.9759,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004132','Monforte d\'Alba','Monforte d\'Alba','','NO','F358',44.5823416,7.9683934,25.1238,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004133','Montà','Montà','','NO','F385',44.8131026,7.9599368,26.6838,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004134','Montaldo di Mondovì','Montaldo di Mondovì','','NO','F405',44.3194434,7.8658339,24.1071,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004135','Montaldo Roero','Montaldo Roero','','NO','F408',44.7686105,7.9244268,11.8206,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004136','Montanera','Montanera','','NO','F424',44.4619525,7.6655978,11.7560,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004137','Montelupo Albese','Montelupo Albese','','NO','F550',44.6230649,8.0463822,6.3808,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004138','Montemale di Cuneo','Montemale di Cuneo','','NO','F558',44.4376730,7.3727951,11.3681,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004139','Monterosso Grana','Monterosso Grana','','NO','F608',44.4088829,7.3238848,42.1794,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004140','Monteu Roero','Monteu Roero','','NO','F654',44.7802231,7.9309261,24.7332,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004141','Montezemolo','Montezemolo','','NO','F666',44.3782997,8.1415717,7.0015,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004142','Monticello d\'Alba','Monticello d\'Alba','','NO','F669',44.7182443,7.9409824,10.0940,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004143','Moretta','Moretta','','NO','F723',44.7639140,7.5369229,23.8784,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004144','Morozzo','Morozzo','','NO','F743',44.4230516,7.7104388,21.9388,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004145','Murazzano','Murazzano','','NO','F809',44.4737821,8.0188033,27.6315,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004146','Murello','Murello','','NO','F811',44.7530041,7.6009471,17.6373,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004147','Narzole','Narzole','','NO','F846',44.5940436,7.8705583,26.4288,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004148','Neive','Neive','','NO','F863',44.7262797,8.1156191,21.2698,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004149','Neviglie','Neviglie','','NO','F883',44.6920459,8.1159811,8.0166,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004150','Niella Belbo','Niella Belbo','','NO','F894',44.5132893,8.0792119,11.5619,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004151','Niella Tanaro','Niella Tanaro','','NO','F895',44.4148514,7.9213755,15.8670,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004152','Novello','Novello','','NO','F961',44.5871163,7.9276788,11.7526,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004153','Nucetto','Nucetto','','NO','F972',44.3393647,8.0588943,7.7886,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004154','Oncino','Oncino','','NO','G066',44.6761147,7.1901656,47.3709,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004155','Ormea','Ormea','','NO','G114',44.1485506,7.9106229,124.6858,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004156','Ostana','Ostana','','NO','G183',44.6922736,7.1884305,14.0795,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004157','Paesana','Paesana','','NO','G228',44.6853159,7.2767452,58.2841,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004158','Pagno','Pagno','','NO','G240',44.6137203,7.4300207,8.6427,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004159','Pamparato','Pamparato','','NO','G302',44.2771631,7.9138561,34.5471,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004160','Paroldo','Paroldo','','NO','G339',44.4316881,8.0713229,12.4572,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004161','Perletto','Perletto','','NO','G457',44.5989474,8.2141321,9.6734,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004162','Perlo','Perlo','','NO','G458',44.3330295,8.0835597,10.2559,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004163','Peveragno','Peveragno','','NO','G526',44.3299499,7.6171106,67.5695,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004164','Pezzolo Valle Uzzone','Pezzolo Valle Uzzone','','NO','G532',44.5392524,8.1941244,26.6076,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004165','Pianfei','Pianfei','','NO','G561',44.3705182,7.7097710,15.2206,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004166','Piasco','Piasco','','NO','G575',44.5685997,7.4574896,10.7026,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004167','Pietraporzio','Pietraporzio','','NO','G625',44.3440213,7.0318583,55.6750,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004168','Piobesi d\'Alba','Piobesi d\'Alba','','NO','G683',44.7349155,7.9786686,4.0975,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004169','Piozzo','Piozzo','','NO','G697',44.5158074,7.8923662,14.2914,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004170','Pocapaglia','Pocapaglia','','NO','G742',44.7192317,7.8866351,17.6134,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004171','Polonghera','Polonghera','','NO','G800',44.8033435,7.5960802,10.4392,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004172','Pontechianale','Pontechianale','','NO','G837',44.6219810,7.0282854,95.3139,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004173','Pradleves','Pradleves','','NO','G970',44.4185979,7.2821413,19.3791,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004174','Prazzo','Prazzo','','NO','H011',44.4830471,7.0554484,52.7729,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004175','Priero','Priero','','NO','H059',44.3765484,8.0923965,19.7753,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004176','Priocca','Priocca','','NO','H068',44.7907593,8.0622058,8.8400,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004177','Priola','Priola','','NO','H069',44.2460193,8.0223568,27.8175,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004178','Prunetto','Prunetto','','NO','H085',44.4894268,8.1443638,14.0875,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004179','Racconigi','Racconigi','','NO','H150',44.7676679,7.6759159,48.0574,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004180','Revello','Revello','','NO','H247',44.6546988,7.3890482,52.6349,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004181','Rifreddo','Rifreddo','','NO','H285',44.6506250,7.3491331,6.9465,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004182','Rittana','Rittana','','NO','H326',44.3505703,7.4005426,11.2380,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004183','Roaschia','Roaschia','','NO','H362',44.2701308,7.4561396,23.6169,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004184','Roascio','Roascio','','NO','H363',44.4171093,8.0225000,6.4807,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004185','Robilante','Robilante','','NO','H377',44.2940681,7.5111216,24.6928,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004186','Roburent','Roburent','','NO','H378',44.3045166,7.8912847,29.7529,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004187','Roccabruna','Roccabruna','','NO','H385',44.4765883,7.3417608,24.2693,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004188','Rocca Cigliè','Rocca Cigliè','','NO','H391',44.4440266,7.9511440,6.9838,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004189','Rocca de\' Baldi','Rocca de\' Baldi','','NO','H395',44.4301395,7.7456524,26.8508,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004190','Roccaforte Mondovì','Roccaforte Mondovì','','NO','H407',44.3184068,7.7458755,84.3083,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004191','Roccasparvera','Roccasparvera','','NO','H447',44.3414473,7.4410724,11.1716,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004192','Roccavione','Roccavione','','NO','H453',44.3144001,7.4812007,19.4425,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004193','Rocchetta Belbo','Rocchetta Belbo','','NO','H462',44.6370104,8.1751304,4.4864,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004194','Roddi','Roddi','','NO','H472',44.6785228,7.9761208,9.5237,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004195','Roddino','Roddino','','NO','H473',44.5744536,8.0177327,10.5857,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004196','Rodello','Rodello','','NO','H474',44.6305370,8.0593180,8.8762,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004197','Rossana','Rossana','','NO','H578',44.5424086,7.4326140,19.9071,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004198','Ruffia','Ruffia','','NO','H633',44.7073004,7.6025278,7.4769,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004199','Sale delle Langhe','Sale delle Langhe','','NO','H695',44.3970555,8.0834080,10.8119,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004200','Sale San Giovanni','Sale San Giovanni','','NO','H704',44.3992718,8.0788146,7.9621,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004201','Saliceto','Saliceto','','NO','H710',44.4132886,8.1668003,24.3592,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004202','Salmour','Salmour','','NO','H716',44.5781748,7.7921823,12.7538,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004203','Saluzzo','Saluzzo','','NO','H727',44.6455080,7.4876911,79.8620,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004204','Sambuco','Sambuco','','NO','H746',44.3377259,7.0766967,46.1142,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004205','Sampeyre','Sampeyre','','NO','H755',44.5793645,7.1889458,99.1126,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004206','San Benedetto Belbo','San Benedetto Belbo','','NO','H770',44.4897939,8.0579026,4.9684,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004207','San Damiano Macra','San Damiano Macra','','NO','H812',44.4884694,7.2563744,54.3054,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004208','Sanfrè','Sanfrè','','NO','H851',44.7522504,7.8035792,15.4191,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004209','Sanfront','Sanfront','','NO','H852',44.6457674,7.3202690,39.9799,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004210','San Michele Mondovì','San Michele Mondovì','','NO','I037',44.3765698,7.9082315,18.1876,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004211','Sant\'Albano Stura','Sant\'Albano Stura','','NO','I210',44.5099835,7.7209801,27.5216,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004212','Santa Vittoria d\'Alba','Santa Vittoria d\'Alba','','NO','I316',44.6964873,7.9332310,10.2434,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004213','Santo Stefano Belbo','Santo Stefano Belbo','','NO','I367',44.7075926,8.2310293,27.1606,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004214','Santo Stefano Roero','Santo Stefano Roero','','NO','I372',44.7887546,7.9398823,12.9906,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004215','Savigliano','Savigliano','','NO','I470',44.6479622,7.6574521,110.6183,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004216','Scagnello','Scagnello','','NO','I484',44.3322757,7.9868784,9.2432,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004217','Scarnafigi','Scarnafigi','','NO','I512',44.6817461,7.5669408,30.5420,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004218','Serralunga d\'Alba','Serralunga d\'Alba','','NO','I646',44.6092497,8.0006722,8.6066,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004219','Serravalle Langhe','Serravalle Langhe','','NO','I659',44.5609607,8.0576692,8.8936,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004220','Sinio','Sinio','','NO','I750',44.6002481,8.0212819,8.5892,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004221','Somano','Somano','','NO','I817',44.5358819,8.0114720,11.9063,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004222','Sommariva del Bosco','Sommariva del Bosco','','NO','I822',44.7713054,7.7843794,35.3210,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004223','Sommariva Perno','Sommariva Perno','','NO','I823',44.7430802,7.9052119,17.4083,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004224','Stroppo','Stroppo','','NO','I985',44.5056907,7.1259160,28.1558,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004225','Tarantasca','Tarantasca','','NO','L048',44.4935585,7.5452089,12.3530,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004226','Torre Bormida','Torre Bormida','','NO','L252',44.5630869,8.1556394,7.0475,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004227','Torre Mondovì','Torre Mondovì','','NO','L241',44.3520629,7.9002844,18.1723,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004228','Torre San Giorgio','Torre San Giorgio','','NO','L278',44.7357551,7.5300318,5.3204,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004229','Torresina','Torresina','','NO','L281',44.4321975,8.0347811,3.8305,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004230','Treiso','Treiso','','NO','L367',44.6890702,8.0874202,9.8634,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004231','Trezzo Tinella','Trezzo Tinella','','NO','L410',44.6769407,8.1075954,10.6206,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004232','Trinità','Trinità','','NO','L427',44.5074797,7.7580509,28.2971,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004233','Valdieri','Valdieri','','NO','L558',44.2776145,7.3961354,153.1434,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004234','Valgrana','Valgrana','','NO','L580',44.4096853,7.3806207,23.0040,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004235','Valloriate','Valloriate','','NO','L631',44.3381380,7.3745683,16.9749,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004237','Venasca','Venasca','','NO','L729',44.5625223,7.3949742,20.4006,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004238','Verduno','Verduno','','NO','L758',44.6681188,7.9337351,7.0926,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004239','Vernante','Vernante','','NO','L771',44.2455568,7.5338168,61.9380,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004240','Verzuolo','Verzuolo','','NO','L804',44.5995071,7.4830974,26.0905,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004241','Vezza d\'Alba','Vezza d\'Alba','','NO','L817',44.7634856,7.9935733,14.1191,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004242','Vicoforte','Vicoforte','','NO','L841',44.3748905,7.8649098,25.4829,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004243','Vignolo','Vignolo','','NO','L888',44.3595537,7.4700289,7.9083,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004244','Villafalletto','Villafalletto','','NO','L942',44.5441914,7.5389963,29.5718,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004245','Villanova Mondovì','Villanova Mondovì','','NO','L974',44.3445434,7.7623353,28.4412,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004246','Villanova Solaro','Villanova Solaro','','NO','L990',44.7296734,7.5759918,14.4850,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004247','Villar San Costanzo','Villar San Costanzo','','NO','M015',44.4829819,7.3803123,19.9548,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004248','Vinadio','Vinadio','','NO','M055',44.3069342,7.1741472,182.8001,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004249','Viola','Viola','','NO','M063',44.2904622,7.9662523,20.9770,'004');
INSERT INTO `gi_comuni` VALUES ('CN','004250','Vottignasco','Vottignasco','','NO','M136',44.5648105,7.5782301,8.1660,'004');
INSERT INTO `gi_comuni` VALUES ('AT','005001','Agliano Terme','Agliano Terme','','NO','A072',44.7907490,8.2511043,15.3665,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005002','Albugnano','Albugnano','','NO','A173',45.0780470,7.9715161,9.7334,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005003','Antignano','Antignano','','NO','A312',44.8454625,8.1337936,10.9681,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005004','Aramengo','Aramengo','','NO','A352',45.0996770,8.0019784,11.6540,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005005','Asti','Asti','','SI','A479',44.8995129,8.2049712,150.7372,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005006','Azzano d\'Asti','Azzano d\'Asti','','NO','A527',44.8744333,8.2676579,6.5103,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005007','Baldichieri d\'Asti','Baldichieri d\'Asti','','NO','A588',44.9069682,8.0911076,5.1139,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005008','Belveglio','Belveglio','','NO','A770',44.8304487,8.3301103,4.9694,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005009','Berzano di San Pietro','Berzano di San Pietro','','NO','A812',45.0948590,7.9540244,7.1327,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005010','Bruno','Bruno','','NO','B221',44.7906604,8.4402838,9.0782,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005011','Bubbio','Bubbio','','NO','B236',44.6638640,8.2935505,15.7926,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005012','Buttigliera d\'Asti','Buttigliera d\'Asti','','NO','B306',45.0225774,7.9505529,19.2543,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005013','Calamandrana','Calamandrana','','NO','B376',44.7365618,8.3356648,12.7757,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005014','Calliano Monferrato','Calliano Monferrato','','NO','B418',45.0062188,8.2573348,17.3359,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005015','Calosso','Calosso','','NO','B425',44.7394181,8.2270371,15.5611,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005016','Camerano Casasco','Camerano Casasco','','NO','B469',44.9886285,8.0908953,6.9385,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005017','Canelli','Canelli','','NO','B594',44.7198592,8.2881758,23.5836,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005018','Cantarana','Cantarana','','NO','B633',44.9004162,8.0306724,9.7675,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005019','Capriglio','Capriglio','','NO','B707',45.0041319,8.0082417,5.0599,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005020','Casorzo Monferrato','Casorzo Monferrato','','NO','B991',45.0228920,8.3341606,12.8964,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005021','Cassinasco','Cassinasco','','NO','C022',44.6887047,8.3022146,11.7639,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005022','Castagnole delle Lanze','Castagnole delle Lanze','','NO','C049',44.7549128,8.1491345,21.6692,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005023','Castagnole Monferrato','Castagnole Monferrato','','NO','C047',44.9614799,8.3062292,17.3311,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005024','Castel Boglione','Castel Boglione','','NO','C064',44.7205655,8.3811933,11.8816,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005025','Castell\'Alfero','Castell\'Alfero','','NO','C127',44.9827893,8.2093972,19.9380,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005026','Castellero','Castellero','','NO','C154',44.9240043,8.0747552,4.2968,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005027','Castelletto Molina','Castelletto Molina','','NO','C161',44.7503768,8.4328590,3.1049,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005028','Castello di Annone','Castello di Annone','','NO','A300',44.8787597,8.3137187,23.0617,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005029','Castelnuovo Belbo','Castelnuovo Belbo','','NO','C226',44.8018401,8.4122642,9.5630,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005030','Castelnuovo Calcea','Castelnuovo Calcea','','NO','C230',44.7883509,8.2851516,8.3484,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005031','Castelnuovo Don Bosco','Castelnuovo Don Bosco','','NO','C232',45.0411961,7.9635170,21.2074,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005032','Castel Rocchero','Castel Rocchero','','NO','C253',44.7187793,8.4159806,5.7547,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005033','Cellarengo','Cellarengo','','NO','C438',44.8659801,7.9449759,10.8215,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005034','Celle Enomondo','Celle Enomondo','','NO','C440',44.8566369,8.1229814,5.7996,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005035','Cerreto d\'Asti','Cerreto d\'Asti','','NO','C528',45.0496967,8.0366045,4.0796,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005036','Cerro Tanaro','Cerro Tanaro','','NO','C533',44.8726414,8.3601606,4.5754,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005037','Cessole','Cessole','','NO','C583',44.6480183,8.2432013,12.3379,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005038','Chiusano d\'Asti','Chiusano d\'Asti','','NO','C658',44.9850336,8.1178203,2.2134,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005039','Cinaglio','Cinaglio','','NO','C701',44.9747983,8.1002994,5.7404,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005040','Cisterna d\'Asti','Cisterna d\'Asti','','NO','C739',44.8261552,8.0048746,10.6629,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005041','Coazzolo','Coazzolo','','NO','C804',44.7281869,8.1451216,3.9776,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005042','Cocconato','Cocconato','','NO','C807',45.0872835,8.0390309,16.7334,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005044','Corsione','Corsione','','NO','D046',45.0009039,8.1457741,4.9975,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005045','Cortandone','Cortandone','','NO','D050',44.9596782,8.0575443,5.0444,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005046','Cortanze','Cortanze','','NO','D051',45.0151863,8.0896395,4.4574,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005047','Cortazzone','Cortazzone','','NO','D052',44.9795622,8.0619107,10.1694,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005048','Cortiglione','Cortiglione','','NO','D072',44.8229427,8.3585691,8.2217,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005049','Cossombrato','Cossombrato','','NO','D101',44.9941269,8.1375506,5.5421,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005050','Costigliole d\'Asti','Costigliole d\'Asti','','NO','D119',44.7880644,8.1805847,36.8427,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005051','Cunico','Cunico','','NO','D207',45.0404477,8.0972234,6.6298,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005052','Dusino San Michele','Dusino San Michele','','NO','D388',44.9201554,7.9722940,12.2987,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005053','Ferrere','Ferrere','','NO','D554',44.8765287,7.9940764,14.1436,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005054','Fontanile','Fontanile','','NO','D678',44.7534097,8.4221196,8.1277,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005055','Frinco','Frinco','','NO','D802',45.0055731,8.1752065,7.2329,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005056','Grana Monferrato','Grana Monferrato','','NO','E134',44.9980758,8.2991629,5.9842,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005057','Grazzano Badoglio','Grazzano Badoglio','','NO','E159',45.0389545,8.3134793,10.2313,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005058','Incisa Scapaccino','Incisa Scapaccino','','NO','E295',44.8087903,8.3809359,20.7024,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005059','Isola d\'Asti','Isola d\'Asti','','NO','E338',44.8294272,8.1771922,13.3677,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005060','Loazzolo','Loazzolo','','NO','E633',44.6689304,8.2585150,14.4563,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005061','Maranzana','Maranzana','','NO','E917',44.7597686,8.4768031,4.8566,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005062','Maretto','Maretto','','NO','E944',44.9443385,8.0342386,5.2135,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005063','Moasca','Moasca','','NO','F254',44.7625444,8.2779585,4.1459,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005064','Mombaldone','Mombaldone','','NO','F308',44.5692574,8.3291904,12.0997,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005065','Mombaruzzo','Mombaruzzo','','NO','F311',44.7710252,8.4487173,21.9843,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005066','Mombercelli','Mombercelli','','NO','F316',44.8169727,8.2944351,14.4234,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005067','Monale','Monale','','NO','F323',44.9361117,8.0716802,8.8214,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005068','Monastero Bormida','Monastero Bormida','','NO','F325',44.6475669,8.3246284,14.3781,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005069','Moncalvo','Moncalvo','','NO','F336',45.0513964,8.2634272,17.3529,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005070','Moncucco Torinese','Moncucco Torinese','','NO','F343',45.0678990,7.9319620,14.4092,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005071','Mongardino','Mongardino','','NO','F361',44.8488424,8.2187150,7.1263,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005072','Montabone','Montabone','','NO','F386',44.6983963,8.3895631,8.7218,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005073','Montafia','Montafia','','NO','F390',44.9891790,8.0251809,14.5441,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005074','Montaldo Scarampi','Montaldo Scarampi','','NO','F409',44.8285917,8.2573931,6.6563,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005075','Montechiaro d\'Asti','Montechiaro d\'Asti','','NO','F468',45.0081031,8.1124447,10.2000,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005076','Montegrosso d\'Asti','Montegrosso d\'Asti','','NO','F527',44.8223204,8.2387808,15.5120,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005077','Montemagno Monferrato','Montemagno Monferrato','','NO','F556',44.9840129,8.3239544,15.8150,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005080','Nizza Monferrato','Nizza Monferrato','','NO','F902',44.7743544,8.3563842,30.1999,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005081','Olmo Gentile','Olmo Gentile','','NO','G048',44.5856953,8.2472012,5.8632,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005082','Passerano Marmorito','Passerano Marmorito','','NO','G358',45.0563842,8.0187948,12.0250,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005083','Penango','Penango','','NO','G430',45.0332832,8.2501326,9.6254,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005084','Piea','Piea','','NO','G593',45.0252886,8.0720990,8.9473,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005085','Pino d\'Asti','Pino d\'Asti','','NO','G676',45.0581585,7.9861785,4.0484,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005086','Piovà Massaia','Piovà Massaia','','NO','G692',45.0544768,8.0509442,11.1877,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005087','Portacomaro','Portacomaro','','NO','G894',44.9570029,8.2585798,11.4060,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005088','Quaranti','Quaranti','','NO','H102',44.7507014,8.4492279,2.9571,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005089','Refrancore','Refrancore','','NO','H219',44.9376141,8.3427597,13.1939,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005090','Revigliasco d\'Asti','Revigliasco d\'Asti','','NO','H250',44.8588181,8.1583660,8.6929,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005091','Roatto','Roatto','','NO','H366',44.9514810,8.0265889,6.2698,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005092','Robella','Robella','','NO','H376',45.1022890,8.0995048,12.2702,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005093','Rocca d\'Arazzo','Rocca d\'Arazzo','','NO','H392',44.8738081,8.2858584,12.6467,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005094','Roccaverano','Roccaverano','','NO','H451',44.5930316,8.2719567,29.9472,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005095','Rocchetta Palafea','Rocchetta Palafea','','NO','H466',44.7070139,8.3457017,7.5302,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005096','Rocchetta Tanaro','Rocchetta Tanaro','','NO','H468',44.8588773,8.3443300,15.7135,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005097','San Damiano d\'Asti','San Damiano d\'Asti','','NO','H811',44.8343328,8.0654033,47.8198,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005098','San Giorgio Scarampi','San Giorgio Scarampi','','NO','H899',44.6113242,8.2421093,5.9657,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005099','San Martino Alfieri','San Martino Alfieri','','NO','H987',44.8188246,8.1092090,7.1371,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005100','San Marzano Oliveto','San Marzano Oliveto','','NO','I017',44.7533183,8.2962628,9.7180,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005101','San Paolo Solbrito','San Paolo Solbrito','','NO','I076',44.9522076,7.9727849,12.0543,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005103','Scurzolengo','Scurzolengo','','NO','I555',44.9656540,8.2783001,5.4308,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005104','Serole','Serole','','NO','I637',44.5537494,8.2597335,12.1300,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005105','Sessame','Sessame','','NO','I678',44.6689021,8.3378299,8.4850,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005106','Settime','Settime','','NO','I698',44.9629416,8.1135239,6.6323,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005107','Soglio','Soglio','','NO','I781',44.9974218,8.0781754,3.2525,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005108','Tigliole','Tigliole','','NO','L168',44.8873636,8.0755204,16.0660,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005109','Tonco','Tonco','','NO','L203',45.0241424,8.1898283,11.9352,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005111','Vaglio Serra','Vaglio Serra','','NO','L531',44.7968192,8.3389868,4.7746,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005112','Valfenera','Valfenera','','NO','L574',44.8966982,7.9652509,21.8964,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005113','Vesime','Vesime','','NO','L807',44.6371372,8.2283024,13.0805,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005114','Viale','Viale','','NO','L829',44.9991839,8.0521003,3.7893,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005115','Viarigi','Viarigi','','NO','L834',44.9805162,8.3586711,13.5622,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005116','Vigliano d\'Asti','Vigliano d\'Asti','','NO','L879',44.8350904,8.2319282,6.4003,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005117','Villafranca d\'Asti','Villafranca d\'Asti','','NO','L945',44.9135461,8.0322338,12.7140,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005118','Villanova d\'Asti','Villanova d\'Asti','','NO','L984',44.9418796,7.9372224,41.6082,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005119','Villa San Secondo','Villa San Secondo','','NO','M019',45.0051290,8.1352243,6.1618,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005120','Vinchio','Vinchio','','NO','M058',44.8073824,8.3173166,9.5261,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005121','Montiglio Monferrato','Montiglio Monferrato','','NO','M302',45.0674912,8.0976875,27.0125,'005');
INSERT INTO `gi_comuni` VALUES ('AT','005122','Moransengo-Tonengo','Moransengo-Tonengo','','NO','M434',45.1182563,8.0163642,10.4048,'005');
INSERT INTO `gi_comuni` VALUES ('AL','006001','Acqui Terme','Acqui Terme','','NO','A052',44.6766347,8.4695766,32.8709,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006002','Albera Ligure','Albera Ligure','','NO','A146',44.7030063,9.0649073,21.2242,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006003','Alessandria','Alessandria','','SI','A182',44.9127963,8.6153323,203.9287,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006004','Alfiano Natta','Alfiano Natta','','NO','A189',45.0471599,8.2084235,13.0718,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006005','Alice Bel Colle','Alice Bel Colle','','NO','A197',44.7258002,8.4512672,12.0219,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006007','Altavilla Monferrato','Altavilla Monferrato','','NO','A227',44.9928971,8.3756940,11.5771,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006008','Alzano Scrivia','Alzano Scrivia','','NO','A245',45.0175412,8.8811864,2.2938,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006009','Arquata Scrivia','Arquata Scrivia','','NO','A436',44.6867498,8.8857228,29.0046,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006010','Avolasca','Avolasca','','NO','A523',44.8032980,8.9654715,12.2588,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006011','Balzola','Balzola','','NO','A605',45.1831799,8.4024938,16.9420,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006012','Basaluzzo','Basaluzzo','','NO','A689',44.7682613,8.7058986,15.0979,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006013','Bassignana','Bassignana','','NO','A708',45.0032201,8.7358518,28.6075,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006014','Belforte Monferrato','Belforte Monferrato','','NO','A738',44.6243595,8.6616150,8.3075,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006015','Bergamasco','Bergamasco','','NO','A793',44.8271697,8.4552974,13.4729,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006016','Berzano di Tortona','Berzano di Tortona','','NO','A813',44.8764084,8.9505903,2.8960,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006017','Bistagno','Bistagno','','NO','A889',44.6619116,8.3685932,17.7020,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006018','Borghetto di Borbera','Borghetto di Borbera','','NO','A998',44.7310704,8.9453107,39.4255,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006019','Borgoratto Alessandrino','Borgoratto Alessandrino','','NO','B029',44.8365096,8.5393712,6.6151,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006020','Borgo San Martino','Borgo San Martino','','NO','B037',45.0891136,8.5236817,9.6998,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006021','Bosco Marengo','Bosco Marengo','','NO','B071',44.8220858,8.6760280,44.1476,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006022','Bosio','Bosio','','NO','B080',44.6477472,8.7919887,67.2025,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006023','Bozzole','Bozzole','','NO','B109',45.0679296,8.6049452,9.0394,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006024','Brignano-Frascata','Brignano-Frascata','','NO','B179',44.8119803,9.0408340,17.5082,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006025','Cabella Ligure','Cabella Ligure','','NO','B311',44.6732730,9.0964891,46.8182,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006026','Camagna Monferrato','Camagna Monferrato','','NO','B453',45.0177406,8.4303099,9.1860,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006027','Camino','Camino','','NO','B482',45.1622111,8.2869967,18.4237,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006028','Cantalupo Ligure','Cantalupo Ligure','','NO','B629',44.7189409,9.0443333,24.3352,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006029','Capriata d\'Orba','Capriata d\'Orba','','NO','B701',44.7305138,8.6893322,28.5478,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006030','Carbonara Scrivia','Carbonara Scrivia','','NO','B736',44.8497685,8.8706939,5.1461,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006031','Carentino','Carentino','','NO','B765',44.8288246,8.4704528,9.7981,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006032','Carezzano','Carezzano','','NO','B769',44.8067475,8.9000341,10.3474,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006033','Carpeneto','Carpeneto','','NO','B818',44.6772066,8.6062337,13.3606,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006034','Carrega Ligure','Carrega Ligure','','NO','B836',44.6192534,9.1759216,55.0782,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006035','Carrosio','Carrosio','','NO','B840',44.6594149,8.8321908,6.9817,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006036','Cartosio','Cartosio','','NO','B847',44.5911636,8.4185599,16.5109,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006037','Casal Cermelli','Casal Cermelli','','NO','B870',44.8356911,8.6223328,12.1648,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006038','Casaleggio Boiro','Casaleggio Boiro','','NO','B882',44.6340990,8.7314957,12.1727,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006039','Casale Monferrato','Casale Monferrato','','NO','B885',45.1349646,8.4525968,85.6197,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006040','Casalnoceto','Casalnoceto','','NO','B902',44.9131294,8.9819561,12.7328,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006041','Casasco','Casasco','','NO','B941',44.8281016,9.0060784,9.1692,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006043','Cassine','Cassine','','NO','C027',44.7482602,8.5254485,32.9171,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006044','Cassinelle','Cassinelle','','NO','C030',44.6067792,8.5604511,23.7110,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006045','Castellania Coppi','Castellania Coppi','','NO','C137',44.7988823,8.9305807,7.2056,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006046','Castellar Guidobono','Castellar Guidobono','','NO','C142',44.9062539,8.9466930,2.6570,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006047','Castellazzo Bormida','Castellazzo Bormida','','NO','C148',44.8453157,8.5769763,45.0956,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006048','Castelletto d\'Erro','Castelletto d\'Erro','','NO','C156',44.6251117,8.3944958,4.8382,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006049','Castelletto d\'Orba','Castelletto d\'Orba','','NO','C158',44.6857757,8.7024214,14.0157,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006050','Castelletto Merli','Castelletto Merli','','NO','C160',45.0748354,8.2409256,11.6784,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006051','Castelletto Monferrato','Castelletto Monferrato','','NO','C162',44.9799137,8.5652871,9.5728,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006052','Castelnuovo Bormida','Castelnuovo Bormida','','NO','C229',44.7436715,8.5462287,13.2364,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006053','Castelnuovo Scrivia','Castelnuovo Scrivia','','NO','C243',44.9795135,8.8815635,45.0792,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006054','Castelspina','Castelspina','','NO','C274',44.8041563,8.5826001,5.7453,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006055','Cavatore','Cavatore','','NO','C387',44.6308980,8.4523836,10.8925,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006056','Cella Monte','Cella Monte','','NO','C432',45.0747571,8.3905724,5.6568,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006057','Cereseto','Cereseto','','NO','C503',45.0859661,8.3170329,10.2984,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006058','Cerreto Grue','Cerreto Grue','','NO','C507',44.8418503,8.9319379,4.7132,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006059','Cerrina Monferrato','Cerrina Monferrato','','NO','C531',45.1202094,8.2151674,17.4231,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006060','Coniolo','Coniolo','','NO','C962',45.1469233,8.3720033,10.4725,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006061','Conzano','Conzano','','NO','C977',45.0205887,8.4560113,11.7816,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006062','Costa Vescovato','Costa Vescovato','','NO','D102',44.8168279,8.9285906,7.4787,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006063','Cremolino','Cremolino','','NO','D149',44.6374253,8.5857098,14.4701,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006065','Denice','Denice','','NO','D272',44.5987740,8.3339207,7.3246,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006066','Dernice','Dernice','','NO','D277',44.7672660,9.0498189,18.1871,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006067','Fabbrica Curone','Fabbrica Curone','','NO','D447',44.7548191,9.1541586,53.6661,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006068','Felizzano','Felizzano','','NO','D528',44.8980383,8.4358404,25.4219,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006069','Fraconalto','Fraconalto','','NO','D559',44.5921246,8.8779788,17.6406,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006070','Francavilla Bisio','Francavilla Bisio','','NO','D759',44.7358621,8.7316428,7.8163,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006071','Frascaro','Frascaro','','NO','D770',44.8270373,8.5326729,5.3307,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006072','Frassinello Monferrato','Frassinello Monferrato','','NO','D777',45.0315323,8.3866071,8.3842,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006073','Frassineto Po','Frassineto Po','','NO','D780',45.1340670,8.5362089,29.6005,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006074','Fresonara','Fresonara','','NO','D797',44.7826853,8.6849203,6.9602,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006075','Frugarolo','Frugarolo','','NO','D813',44.8390548,8.6791373,27.1188,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006076','Fubine Monferrato','Fubine Monferrato','','NO','D814',44.9655413,8.4255193,25.0467,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006077','Gabiano','Gabiano','','NO','D835',45.1588575,8.1928585,17.8001,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006078','Gamalero','Gamalero','','NO','D890',44.8085998,8.5429633,12.0335,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006079','Garbagna','Garbagna','','NO','D910',44.7809161,8.9990718,20.5070,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006081','Gavi','Gavi','','NO','D944',44.6883498,8.8037977,44.6965,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006082','Giarole','Giarole','','NO','E015',45.0606860,8.5678515,5.2835,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006083','Gremiasco','Gremiasco','','NO','E164',44.7970616,9.1046930,17.3207,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006084','Grognardo','Grognardo','','NO','E188',44.6298705,8.4913963,9.0638,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006085','Grondona','Grondona','','NO','E191',44.6963933,8.9664722,26.2349,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006086','Guazzora','Guazzora','','NO','E255',45.0135093,8.8449197,2.8938,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006087','Isola Sant\'Antonio','Isola Sant\'Antonio','','NO','E360',45.0308383,8.8503817,23.7039,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006088','Lerma','Lerma','','NO','E543',44.6349790,8.7125102,14.5420,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006090','Malvicino','Malvicino','','NO','E870',44.5597009,8.4141375,8.9753,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006091','Masio','Masio','','NO','F015',44.8692286,8.4081076,22.6788,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006092','Melazzo','Melazzo','','NO','F096',44.6439390,8.4269041,19.5990,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006093','Merana','Merana','','NO','F131',44.5178121,8.2975087,9.5210,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006094','Mirabello Monferrato','Mirabello Monferrato','','NO','F232',45.0357373,8.5233843,13.2519,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006095','Molare','Molare','','NO','F281',44.6206359,8.6010896,32.2505,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006096','Molino dei Torti','Molino dei Torti','','NO','F293',45.0235475,8.8919854,2.5773,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006097','Mombello Monferrato','Mombello Monferrato','','NO','F313',45.1330223,8.2509152,19.6127,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006098','Momperone','Momperone','','NO','F320',44.8386909,9.0346280,8.6262,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006099','Moncestino','Moncestino','','NO','F337',45.1549091,8.1583171,6.5692,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006100','Mongiardino Ligure','Mongiardino Ligure','','NO','F365',44.6385546,9.0612637,29.1157,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006101','Monleale','Monleale','','NO','F374',44.8850418,8.9843890,9.5097,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006102','Montacuto','Montacuto','','NO','F387',44.7667560,9.1067452,23.5259,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006103','Montaldeo','Montaldeo','','NO','F403',44.6665318,8.7306334,5.3966,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006104','Montaldo Bormida','Montaldo Bormida','','NO','F404',44.6834665,8.5890963,5.6707,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006105','Montecastello','Montecastello','','NO','F455',44.9489154,8.6865903,7.6724,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006106','Montechiaro d\'Acqui','Montechiaro d\'Acqui','','NO','F469',44.5948950,8.3796355,17.3920,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006107','Montegioco','Montegioco','','NO','F518',44.8377323,8.9540495,5.4766,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006108','Montemarzino','Montemarzino','','NO','F562',44.8486860,8.9928682,9.9267,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006109','Morano sul Po','Morano sul Po','','NO','F707',45.1639707,8.3656328,17.5375,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006110','Morbello','Morbello','','NO','F713',44.6034876,8.5099954,24.1045,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006111','Mornese','Mornese','','NO','F737',44.6408489,8.7556999,13.2468,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006112','Morsasco','Morsasco','','NO','F751',44.6645899,8.5491272,10.1649,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006113','Murisengo','Murisengo','','NO','F814',45.0835082,8.1371320,15.3750,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006114','Novi Ligure','Novi Ligure','','NO','F965',44.7601748,8.7871152,54.9899,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006115','Occimiano','Occimiano','','NO','F995',45.0601811,8.5066720,22.3603,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006116','Odalengo Grande','Odalengo Grande','','NO','F997',45.1095002,8.1667229,15.2056,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006117','Odalengo Piccolo','Odalengo Piccolo','','NO','F998',45.0719671,8.2095103,7.5761,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006118','Olivola','Olivola','','NO','G042',45.0376601,8.3669236,2.8510,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006119','Orsara Bormida','Orsara Bormida','','NO','G124',44.6900971,8.5624583,5.1143,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006120','Ottiglio','Ottiglio','','NO','G193',45.0518549,8.3391379,14.3991,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006121','Ovada','Ovada','','NO','G197',44.6377036,8.6459454,35.4931,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006122','Oviglio','Oviglio','','NO','G199',44.8597705,8.4869081,27.0781,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006123','Ozzano Monferrato','Ozzano Monferrato','','NO','G204',45.1018088,8.3762616,15.1320,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006124','Paderna','Paderna','','NO','G215',44.8206420,8.8900557,4.4705,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006125','Pareto','Pareto','','NO','G334',44.5160585,8.3825603,42.1663,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006126','Parodi Ligure','Parodi Ligure','','NO','G338',44.6708069,8.7585882,12.5721,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006127','Pasturana','Pasturana','','NO','G367',44.7503965,8.7488816,5.3070,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006128','Pecetto di Valenza','Pecetto di Valenza','','NO','G397',44.9897070,8.6705109,11.3680,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006129','Pietra Marazzi','Pietra Marazzi','','NO','G619',44.9441247,8.6705203,8.1094,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006131','Pomaro Monferrato','Pomaro Monferrato','','NO','G807',45.0638948,8.5951931,13.3491,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006132','Pontecurone','Pontecurone','','NO','G839',44.9589469,8.9358760,29.8913,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006133','Pontestura','Pontestura','','NO','G858',45.1436491,8.3325439,19.1353,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006134','Ponti','Ponti','','NO','G861',44.6273329,8.3652591,11.7869,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006135','Ponzano Monferrato','Ponzano Monferrato','','NO','G872',45.0844956,8.2662567,11.6059,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006136','Ponzone','Ponzone','','NO','G877',44.5886374,8.4588849,68.5660,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006137','Pozzol Groppo','Pozzol Groppo','','NO','G960',44.8774340,9.0293417,14.5158,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006138','Pozzolo Formigaro','Pozzolo Formigaro','','NO','G961',44.7939006,8.7817118,36.3237,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006139','Prasco','Prasco','','NO','G987',44.6423704,8.5527972,5.9831,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006140','Predosa','Predosa','','NO','H021',44.7527923,8.6591881,32.7038,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006141','Quargnento','Quargnento','','NO','H104',44.9448372,8.4876779,36.0505,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006142','Quattordio','Quattordio','','NO','H121',44.8991087,8.4058724,17.8065,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006143','Ricaldone','Ricaldone','','NO','H272',44.7320387,8.4694640,9.9499,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006144','Rivalta Bormida','Rivalta Bormida','','NO','H334',44.7112799,8.5503217,10.0881,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006145','Rivarone','Rivarone','','NO','H343',44.9776935,8.7157013,6.3423,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006146','Roccaforte Ligure','Roccaforte Ligure','','NO','H406',44.6777279,9.0277673,20.5942,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006147','Rocca Grimalda','Rocca Grimalda','','NO','H414',44.6710637,8.6471857,15.4441,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006148','Rocchetta Ligure','Rocchetta Ligure','','NO','H465',44.7065387,9.0499964,9.8655,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006149','Rosignano Monferrato','Rosignano Monferrato','','NO','H569',45.0798534,8.3990395,19.3034,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006150','Sala Monferrato','Sala Monferrato','','NO','H677',45.0755626,8.3582902,7.6049,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006151','Sale','Sale','','NO','H694',44.9849267,8.8091767,45.3322,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006152','San Cristoforo','San Cristoforo','','NO','H810',44.6919846,8.7507352,3.4589,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006153','San Giorgio Monferrato','San Giorgio Monferrato','','NO','H878',45.1077185,8.4152262,7.1345,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006154','San Salvatore Monferrato','San Salvatore Monferrato','','NO','I144',44.9947997,8.5667100,31.7798,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006155','San Sebastiano Curone','San Sebastiano Curone','','NO','I150',44.7854846,9.0653733,4.0649,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006156','Sant\'Agata Fossili','Sant\'Agata Fossili','','NO','I190',44.7858309,8.9190034,7.9406,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006157','Sardigliano','Sardigliano','','NO','I429',44.7543691,8.9077369,12.8248,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006158','Sarezzano','Sarezzano','','NO','I432',44.8675981,8.9153832,13.8586,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006159','Serralunga di Crea','Serralunga di Crea','','NO','I645',45.1008131,8.2817335,8.9295,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006160','Serravalle Scrivia','Serravalle Scrivia','','NO','I657',44.7193252,8.8583485,15.9601,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006161','Sezzadio','Sezzadio','','NO','I711',44.7855617,8.5729603,34.6799,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006162','Silvano d\'Orba','Silvano d\'Orba','','NO','I738',44.6856213,8.6707513,12.1554,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006163','Solero','Solero','','NO','I798',44.9197341,8.5076642,22.6362,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006164','Solonghello','Solonghello','','NO','I808',45.1309437,8.2818208,4.9650,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006165','Spigno Monferrato','Spigno Monferrato','','NO','I901',44.5429496,8.3353613,54.1844,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006166','Spineto Scrivia','Spineto Scrivia','','NO','I911',44.8375523,8.8723907,3.8076,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006167','Stazzano','Stazzano','','NO','I941',44.7272068,8.8672666,18.2208,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006168','Strevi','Strevi','','NO','I977',44.6986978,8.5224348,15.1015,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006169','Tagliolo Monferrato','Tagliolo Monferrato','','NO','L027',44.6390486,8.6683012,26.2577,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006170','Tassarolo','Tassarolo','','NO','L059',44.7265644,8.7695113,7.2619,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006171','Terruggia','Terruggia','','NO','L139',45.0830938,8.4422723,7.4528,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006172','Terzo','Terzo','','NO','L143',44.6694908,8.4211867,8.8837,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006173','Ticineto','Ticineto','','NO','L165',45.0973899,8.5561407,8.0744,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006174','Tortona','Tortona','','NO','L304',44.8948335,8.8601847,98.7397,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006175','Treville','Treville','','NO','L403',45.0971075,8.3596816,4.7509,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006176','Trisobbio','Trisobbio','','NO','L432',44.6623358,8.5863836,9.2394,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006177','Valenza','Valenza','','NO','L570',45.0144106,8.6461524,48.4272,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006178','Valmacca','Valmacca','','NO','L633',45.1004420,8.5824252,12.4340,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006179','Vignale Monferrato','Vignale Monferrato','','NO','L881',45.0109205,8.3965957,18.2230,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006180','Vignole Borbera','Vignole Borbera','','NO','L887',44.7083088,8.8904036,8.5116,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006181','Viguzzolo','Viguzzolo','','NO','L904',44.9052324,8.9194878,18.2717,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006182','Villadeati','Villadeati','','NO','L931',45.0725884,8.1693456,14.2930,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006183','Villalvernia','Villalvernia','','NO','L963',44.8175559,8.8566101,4.5925,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006184','Villamiroglio','Villamiroglio','','NO','L970',45.1344559,8.1697453,9.9382,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006185','Villanova Monferrato','Villanova Monferrato','','NO','L972',45.1817950,8.4785868,16.7386,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006186','Villaromagnano','Villaromagnano','','NO','M009',44.8510037,8.8871985,6.0690,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006187','Visone','Visone','','NO','M077',44.6620156,8.5033026,12.7542,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006188','Volpedo','Volpedo','','NO','M120',44.8887963,8.9833643,10.4424,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006189','Volpeglino','Volpeglino','','NO','M121',44.8929706,8.9589614,3.2594,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006190','Voltaggio','Voltaggio','','NO','M123',44.6201729,8.8427161,52.5628,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006191','Cassano Spinola','Cassano Spinola','','NO','M388',44.7661671,8.8632150,16.9862,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006192','Alluvioni Piovera','Alluvioni Piovera','','NO','M397',44.9953873,8.7725996,24.2632,'006');
INSERT INTO `gi_comuni` VALUES ('AL','006193','Lu e Cuccaro Monferrato','Lu e Cuccaro Monferrato','','NO','M420',45.0017748,8.4842791,27.3312,'006');
INSERT INTO `gi_comuni` VALUES ('AO','007001','Allein','Allein','','NO','A205',45.8081472,7.2717773,8.1402,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007002','Antey-Saint-André','Antey-Saint-André','','NO','A305',45.8049344,7.5931979,11.7596,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007003','Aosta','Aosta','','SI','A326',45.7375761,7.3201260,21.4015,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007004','Arnad','Arnad','','NO','A424',45.6449350,7.7212415,28.5210,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007005','Arvier','Arvier','','NO','A452',45.7035361,7.1692836,33.3124,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007006','Avise','Avise','','NO','A521',45.7087081,7.1413145,52.6306,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007007','Ayas','Ayas','','NO','A094',45.8115713,7.6865927,129.2088,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007008','Aymavilles','Aymavilles','','NO','A108',45.7013842,7.2405069,53.3601,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007009','Bard','Bard','','NO','A643',45.6074889,7.7466436,3.1375,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007010','Bionaz','Bionaz','','NO','A877',45.8736960,7.4235176,142.3642,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007011','Brissogne','Brissogne','','NO','B192',45.7273887,7.4031775,26.0134,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007012','Brusson','Brusson','','NO','B230',45.7586604,7.7327123,55.1183,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007013','Challand-Saint-Anselme','Challand-Saint-Anselme','','NO','C593',45.7163717,7.7364954,28.0375,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007014','Challand-Saint-Victor','Challand-Saint-Victor','','NO','C594',45.6897873,7.7064502,25.0960,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007015','Chambave','Chambave','','NO','C595',45.7442840,7.5499283,21.4479,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007016','Chamois','Chamois','','NO','B491',45.8381943,7.6201422,14.8983,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007017','Champdepraz','Champdepraz','','NO','C596',45.6857719,7.6577399,48.7389,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007018','Champorcher','Champorcher','','NO','B540',45.6245124,7.6207762,68.3015,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007019','Charvensod','Charvensod','','NO','C598',45.7204520,7.3254024,25.7756,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007020','Châtillon','Châtillon','','NO','C294',45.7486457,7.6112250,39.3396,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007021','Cogne','Cogne','','NO','C821',45.6081076,7.3558484,212.8632,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007022','Courmayeur','Courmayeur','','NO','D012',45.7931064,6.9721683,209.7843,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007023','Donnas','Donnas','','NO','D338',45.6034622,7.7674352,34.0724,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007024','Doues','Doues','','NO','D356',45.8186679,7.3064265,15.8408,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007025','Emarèse','Emarèse','','NO','D402',45.7246974,7.7004790,10.2262,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007026','Etroubles','Etroubles','','NO','D444',45.8196866,7.2330462,39.6257,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007027','Fénis','Fénis','','NO','D537',45.7361317,7.4942621,68.0764,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007028','Fontainemore','Fontainemore','','NO','D666',45.6490179,7.8609143,31.7450,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007029','Gaby','Gaby','','NO','D839',45.7129119,7.8822666,32.7747,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007030','Gignod','Gignod','','NO','E029',45.7782877,7.2962081,25.9115,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007031','Gressan','Gressan','','NO','E165',45.7215494,7.2894355,25.3647,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007032','Gressoney-La-Trinité','Gressoney-La-Trinité','','NO','E167',45.8272674,7.8231796,66.1115,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007033','Gressoney-Saint-Jean','Gressoney-Saint-Jean','','NO','E168',45.7767680,7.8275424,70.0466,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007034','Hône','Hône','','NO','E273',45.6118952,7.7355913,12.7493,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007035','Introd','Introd','','NO','E306',45.6916406,7.1872093,19.9193,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007036','Issime','Issime','','NO','E369',45.6854327,7.8542203,34.4593,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007037','Issogne','Issogne','','NO','E371',45.6538991,7.6844305,23.5213,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007038','Jovençan','Jovençan','','NO','E391',45.7139559,7.2749217,6.8324,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007039','La Magdeleine','La Magdeleine','','NO','A308',45.8108193,7.6190786,8.6867,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007040','La Salle','La Salle','','NO','E458',45.7468773,7.0725473,83.5892,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007041','La Thuile','La Thuile','','NO','E470',45.7168095,6.9490713,126.0374,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007042','Lillianes','Lillianes','','NO','E587',45.6327794,7.8450681,18.6355,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007043','Montjovet','Montjovet','','NO','F367',45.7042167,7.6741673,18.9519,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007044','Morgex','Morgex','','NO','F726',45.7569730,7.0360754,43.7831,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007045','Nus','Nus','','NO','F987',45.7391173,7.4670006,56.8425,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007046','Ollomont','Ollomont','','NO','G045',45.8496152,7.3100431,53.7066,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007047','Oyace','Oyace','','NO','G012',45.8507779,7.3819063,30.3418,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007048','Perloz','Perloz','','NO','G459',45.6130802,7.8086624,23.2111,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007049','Pollein','Pollein','','NO','G794',45.7280909,7.3571974,15.2119,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007050','Pontboset','Pontboset','','NO','G545',45.6063883,7.6876180,33.4030,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007051','Pontey','Pontey','','NO','G860',45.7379414,7.5913424,16.0028,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007052','Pont-Saint-Martin','Pont-Saint-Martin','','NO','G854',45.5997737,7.7978805,6.9424,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007053','Pré-Saint-Didier','Pré-Saint-Didier','','NO','H042',45.7640776,6.9859424,33.4110,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007054','Quart','Quart','','NO','H110',45.7406777,7.4156030,62.1019,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007055','Rhêmes-Notre-Dame','Rhêmes-Notre-Dame','','NO','H262',45.5697162,7.1185239,86.8659,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007056','Rhêmes-Saint-Georges','Rhêmes-Saint-Georges','','NO','H263',45.6552729,7.1552314,36.3989,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007057','Roisan','Roisan','','NO','H497',45.7843173,7.3105570,14.7089,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007058','Saint-Christophe','Saint-Christophe','','NO','H669',45.7483467,7.3577772,14.5163,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007059','Saint-Denis','Saint-Denis','','NO','H670',45.7521788,7.5571857,11.3863,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007060','Saint-Marcel','Saint-Marcel','','NO','H671',45.7312801,7.4445077,42.4877,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007061','Saint-Nicolas','Saint-Nicolas','','NO','H672',45.7165160,7.1680853,15.3268,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007062','Saint-Oyen','Saint-Oyen','','NO','H673',45.8248459,7.2134283,9.5974,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007063','Saint-Pierre','Saint-Pierre','','NO','H674',45.7104335,7.2260036,26.2102,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007064','Saint-Rhémy-en-Bosses','Saint-Rhémy-en-Bosses','','NO','H675',45.8213310,7.1783856,64.7518,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007065','Saint-Vincent','Saint-Vincent','','NO','H676',45.7502549,7.6474477,20.8529,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007066','Sarre','Sarre','','NO','I442',45.7178556,7.2576607,28.4349,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007067','Torgnon','Torgnon','','NO','L217',45.8014084,7.5705222,42.4837,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007068','Valgrisenche','Valgrisenche','','NO','L582',45.6303119,7.0647545,113.5725,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007069','Valpelline','Valpelline','','NO','L643',45.8264343,7.3285457,31.6171,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007070','Valsavarenche','Valsavarenche','','NO','L647',45.5920447,7.2083440,138.0640,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007071','Valtournenche','Valtournenche','','NO','L654',45.8770885,7.6227557,116.1951,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007072','Verrayes','Verrayes','','NO','L783',45.7616751,7.5323182,22.5451,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007073','Verrès','Verrès','','NO','C282',45.6687316,7.6899242,8.4637,'007');
INSERT INTO `gi_comuni` VALUES ('AO','007074','Villeneuve','Villeneuve','','NO','L981',45.7027318,7.2077186,8.6359,'007');
INSERT INTO `gi_comuni` VALUES ('IM','008001','Airole','Airole','','NO','A111',43.8716987,7.5535255,14.6335,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008002','Apricale','Apricale','','NO','A338',43.8804395,7.6604559,19.6643,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008003','Aquila d\'Arroscia','Aquila d\'Arroscia','','NO','A344',44.0832602,8.0054724,9.8538,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008004','Armo','Armo','','NO','A418',44.0873294,7.9139972,10.1524,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008005','Aurigo','Aurigo','','NO','A499',43.9829820,7.9225722,9.3954,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008006','Badalucco','Badalucco','','NO','A536',43.9156560,7.8470545,16.1435,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008007','Bajardo','Bajardo','','NO','A581',43.9035671,7.7182353,24.4246,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008008','Bordighera','Bordighera','','NO','A984',43.7793477,7.6723874,10.8416,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008009','Borghetto d\'Arroscia','Borghetto d\'Arroscia','','NO','A993',44.0574747,7.9818439,25.9316,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008010','Borgomaro','Borgomaro','','NO','B020',43.9755629,7.9449326,23.1314,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008011','Camporosso','Camporosso','','NO','B559',43.8151379,7.6283701,18.0438,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008012','Caravonica','Caravonica','','NO','B734',43.9923865,7.9588567,4.6408,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008014','Castellaro','Castellaro','','NO','C143',43.8640914,7.8686352,7.9908,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008015','Castel Vittorio','Castel Vittorio','','NO','C110',43.9286991,7.6731642,25.7667,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008016','Ceriana','Ceriana','','NO','C511',43.8792158,7.7743700,32.1632,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008017','Cervo','Cervo','','NO','C559',43.9253200,8.1144129,3.6269,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008018','Cesio','Cesio','','NO','C578',44.0077093,7.9749855,8.7247,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008019','Chiusanico','Chiusanico','','NO','C657',43.9731949,7.9916040,13.6297,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008020','Chiusavecchia','Chiusavecchia','','NO','C660',43.9678804,7.9833472,4.0137,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008021','Cipressa','Cipressa','','NO','C718',43.8529799,7.9339896,9.4299,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008022','Civezza','Civezza','','NO','C755',43.8793093,7.9513003,4.0480,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008023','Cosio d\'Arroscia','Cosio d\'Arroscia','','NO','D087',44.0757649,7.8311471,40.6052,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008024','Costarainera','Costarainera','','NO','D114',43.8489468,7.9498666,2.4028,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008025','Diano Arentino','Diano Arentino','','NO','D293',43.9479689,8.0422928,8.3816,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008026','Diano Castello','Diano Castello','','NO','D296',43.9241089,8.0670603,5.9699,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008027','Diano Marina','Diano Marina','','NO','D297',43.9100897,8.0817608,6.6564,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008028','Diano San Pietro','Diano San Pietro','','NO','D298',43.9310011,8.0685858,11.8714,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008029','Dolceacqua','Dolceacqua','','NO','D318',43.8480598,7.6234003,19.9907,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008030','Dolcedo','Dolcedo','','NO','D319',43.9071182,7.9510789,19.8128,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008031','Imperia','Imperia','','SI','E290',43.8855883,8.0278634,45.2996,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008032','Isolabona','Isolabona','','NO','E346',43.8799711,7.6388396,12.6567,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008033','Lucinasco','Lucinasco','','NO','E719',43.9677323,7.9627080,7.9307,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008034','Mendatica','Mendatica','','NO','F123',44.0763657,7.8055581,30.7068,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008035','Molini di Triora','Molini di Triora','','NO','F290',43.9900855,7.7743379,58.0593,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008037','Montegrosso Pian Latte','Montegrosso Pian Latte','','NO','F528',44.0665880,7.8176147,10.1965,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008038','Olivetta San Michele','Olivetta San Michele','','NO','G041',43.8797738,7.5154847,14.0010,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008039','Ospedaletti','Ospedaletti','','NO','G164',43.8007179,7.7176938,5.2357,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008040','Perinaldo','Perinaldo','','NO','G454',43.8667887,7.6738554,20.1764,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008041','Pietrabruna','Pietrabruna','','NO','G607',43.8896627,7.9033984,10.1164,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008042','Pieve di Teco','Pieve di Teco','','NO','G632',44.0469735,7.9152231,40.5732,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008043','Pigna','Pigna','','NO','G660',43.9329372,7.6634249,53.7245,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008044','Pompeiana','Pompeiana','','NO','G814',43.8517266,7.8875716,5.2994,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008045','Pontedassio','Pontedassio','','NO','G840',43.9400234,8.0124134,13.3625,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008046','Pornassio','Pornassio','','NO','G890',44.0702516,7.8709098,26.8538,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008047','Prelà','Prelà','','NO','H027',43.9261930,7.9370000,14.9046,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008048','Ranzo','Ranzo','','NO','H180',44.0595148,8.0144192,10.7952,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008049','Rezzo','Rezzo','','NO','H257',44.0202886,7.8721565,37.4462,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008050','Riva Ligure','Riva Ligure','','NO','H328',43.8375471,7.8819105,2.1032,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008051','Rocchetta Nervina','Rocchetta Nervina','','NO','H460',43.8901268,7.6003202,15.1805,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008052','San Bartolomeo al Mare','San Bartolomeo al Mare','','NO','H763',43.9285818,8.1021434,10.7239,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008053','San Biagio della Cima','San Biagio della Cima','','NO','H780',43.8182376,7.6498478,4.2755,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008054','San Lorenzo al Mare','San Lorenzo al Mare','','NO','H957',43.8536077,7.9639299,1.4545,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008055','Sanremo','Sanremo','','NO','I138',43.8224858,7.7867483,56.1378,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008056','Santo Stefano al Mare','Santo Stefano al Mare','','NO','I365',43.8371560,7.8990725,2.6930,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008057','Seborga','Seborga','','NO','I556',43.8261106,7.6939512,4.8530,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008058','Soldano','Soldano','','NO','I796',43.8267061,7.6540568,3.7244,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008059','Taggia','Taggia','','NO','L024',43.8435760,7.8504414,31.0411,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008060','Terzorio','Terzorio','','NO','L146',43.8528991,7.8982695,1.8775,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008061','Triora','Triora','','NO','L430',43.9937799,7.7621309,67.9296,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008062','Vallebona','Vallebona','','NO','L596',43.8132937,7.6668935,5.7240,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008063','Vallecrosia','Vallecrosia','','NO','L599',43.7931451,7.6438220,3.6309,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008064','Vasia','Vasia','','NO','L693',43.9332296,7.9542975,11.2190,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008065','Ventimiglia','Ventimiglia','','NO','L741',43.7902499,7.6084888,53.8736,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008066','Vessalico','Vessalico','','NO','L809',44.0462025,7.9622667,10.4908,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008067','Villa Faraldi','Villa Faraldi','','NO','L943',43.9670567,8.0914697,9.9660,'008');
INSERT INTO `gi_comuni` VALUES ('IM','008068','Montalto Carpasio','Montalto Carpasio','','NO','M387',43.9598814,7.8666656,29.9226,'008');
INSERT INTO `gi_comuni` VALUES ('SV','009001','Alassio','Alassio','','NO','A122',44.0080070,8.1729865,17.1522,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009002','Albenga','Albenga','','NO','A145',44.0490791,8.2129091,36.6747,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009003','Albissola Marina','Albissola Marina','','NO','A165',44.3273186,8.5032164,3.2536,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009004','Albisola Superiore','Albisola Superiore','','NO','A166',44.3396826,8.5103612,28.4813,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009005','Altare','Altare','','NO','A226',44.3347408,8.3440312,11.6012,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009006','Andora','Andora','','NO','A278',43.9582113,8.1400358,31.6861,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009007','Arnasco','Arnasco','','NO','A422',44.0778985,8.1059023,5.8287,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009008','Balestrino','Balestrino','','NO','A593',44.1248954,8.1745996,11.4417,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009009','Bardineto','Bardineto','','NO','A647',44.1920803,8.1293496,29.9538,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009010','Bergeggi','Bergeggi','','NO','A796',44.2489581,8.4439553,3.7963,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009011','Boissano','Boissano','','NO','A931',44.1342859,8.2212140,8.2823,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009012','Borghetto Santo Spirito','Borghetto Santo Spirito','','NO','A999',44.1152000,8.2421829,5.3890,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009013','Borgio Verezzi','Borgio Verezzi','','NO','B005',44.1601012,8.3047624,2.8951,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009014','Bormida','Bormida','','NO','B048',44.2786251,8.2326347,22.3858,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009015','Cairo Montenotte','Cairo Montenotte','','NO','B369',44.3979531,8.2777014,100.4700,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009016','Calice Ligure','Calice Ligure','','NO','B409',44.2048877,8.2942196,20.6744,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009017','Calizzano','Calizzano','','NO','B416',44.2353720,8.1155934,62.8537,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009018','Carcare','Carcare','','NO','B748',44.3579380,8.2908307,10.3028,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009019','Casanova Lerrone','Casanova Lerrone','','NO','B927',44.0315139,8.0482573,24.2226,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009020','Castelbianco','Castelbianco','','NO','C063',44.1132216,8.0748016,14.7196,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009021','Castelvecchio di Rocca Barbena','Castelvecchio di Rocca Barbena','','NO','C276',44.1303259,8.1155510,16.2220,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009022','Celle Ligure','Celle Ligure','','NO','C443',44.3420236,8.5452217,9.5661,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009023','Cengio','Cengio','','NO','C463',44.3875739,8.2086430,18.4864,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009024','Ceriale','Ceriale','','NO','C510',44.0963373,8.2320759,10.9613,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009025','Cisano sul Neva','Cisano sul Neva','','NO','C729',44.0871864,8.1448887,12.1633,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009026','Cosseria','Cosseria','','NO','D095',44.3685146,8.2344936,12.5746,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009027','Dego','Dego','','NO','D264',44.4493147,8.3106031,66.8359,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009028','Erli','Erli','','NO','D424',44.1365726,8.1053238,16.5439,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009029','Finale Ligure','Finale Ligure','','NO','D600',44.1689406,8.3436465,35.1041,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009030','Garlenda','Garlenda','','NO','D927',44.0323280,8.0942616,8.0899,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009031','Giustenice','Giustenice','','NO','E064',44.1722714,8.2462043,17.2986,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009032','Giusvalla','Giusvalla','','NO','E066',44.4494152,8.3937743,19.6756,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009033','Laigueglia','Laigueglia','','NO','E414',43.9745778,8.1581881,2.7559,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009034','Loano','Loano','','NO','E632',44.1291321,8.2597614,13.5580,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009035','Magliolo','Magliolo','','NO','E816',44.1918988,8.2505752,19.4486,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009036','Mallare','Mallare','','NO','E860',44.2914624,8.2975619,32.0486,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009037','Massimino','Massimino','','NO','F046',44.2993910,8.0712212,7.9178,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009038','Millesimo','Millesimo','','NO','F213',44.3643481,8.2056441,15.6556,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009039','Mioglia','Mioglia','','NO','F226',44.4898722,8.4112199,19.2530,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009040','Murialdo','Murialdo','','NO','F813',44.3155390,8.1609525,39.1647,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009041','Nasino','Nasino','','NO','F847',44.1150786,8.0278217,22.3545,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009042','Noli','Noli','','NO','F926',44.2056521,8.4161605,9.7306,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009043','Onzo','Onzo','','NO','G076',44.0693651,8.0513121,8.0375,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009044','Orco Feglino','Orco Feglino','','NO','D522',44.2195599,8.3251692,17.2616,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009045','Ortovero','Ortovero','','NO','G144',44.0538202,8.0911228,9.6782,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009046','Osiglia','Osiglia','','NO','G155',44.2808891,8.2006071,28.2112,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009047','Pallare','Pallare','','NO','G281',44.3269439,8.2757580,21.4329,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009048','Piana Crixia','Piana Crixia','','NO','G542',44.4858350,8.3068909,30.5873,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009049','Pietra Ligure','Pietra Ligure','','NO','G605',44.1488564,8.2828306,9.7063,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009050','Plodio','Plodio','','NO','G741',44.3565179,8.2435115,8.6259,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009051','Pontinvrea','Pontinvrea','','NO','G866',44.4448729,8.4345997,24.8125,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009052','Quiliano','Quiliano','','NO','H126',44.2933299,8.4114515,49.6589,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009053','Rialto','Rialto','','NO','H266',44.2196136,8.2747528,19.6354,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009054','Roccavignale','Roccavignale','','NO','H452',44.3619156,8.1920058,17.8800,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009055','Sassello','Sassello','','NO','I453',44.4790706,8.4899241,100.7387,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009056','Savona','Savona','','SI','I480',44.3074889,8.4811294,65.5253,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009057','Spotorno','Spotorno','','NO','I926',44.2268292,8.4159993,7.9846,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009058','Stella','Stella','','NO','I946',44.3968125,8.4931401,43.8875,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009059','Stellanello','Stellanello','','NO','I947',44.0003152,8.0593232,17.7682,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009060','Testico','Testico','','NO','L152',44.0053965,8.0309954,10.1533,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009061','Toirano','Toirano','','NO','L190',44.1268600,8.2071763,18.9335,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009062','Tovo San Giacomo','Tovo San Giacomo','','NO','L315',44.1763603,8.2683172,9.4071,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009063','Urbe','Urbe','','NO','L499',44.4874668,8.5920827,31.1704,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009064','Vado Ligure','Vado Ligure','','NO','L528',44.2692584,8.4362765,23.7790,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009065','Varazze','Varazze','','NO','L675',44.3598947,8.5763064,47.9861,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009066','Vendone','Vendone','','NO','L730',44.0739317,8.0743071,10.2145,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009067','Vezzi Portio','Vezzi Portio','','NO','L823',44.2289477,8.3619416,9.0668,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009068','Villanova d\'Albenga','Villanova d\'Albenga','','NO','L975',44.0458893,8.1430853,15.7406,'009');
INSERT INTO `gi_comuni` VALUES ('SV','009069','Zuccarello','Zuccarello','','NO','M197',44.1112915,8.1156259,10.9635,'009');
INSERT INTO `gi_comuni` VALUES ('GE','010001','Arenzano','Arenzano','','NO','A388',44.4018258,8.6823090,24.2566,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010002','Avegno','Avegno','','NO','A506',44.3822968,9.1587366,11.0251,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010003','Bargagli','Bargagli','','NO','A658',44.4445265,9.0882759,16.4770,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010004','Bogliasco','Bogliasco','','NO','A922',44.3782034,9.0698193,4.4305,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010005','Borzonasca','Borzonasca','','NO','B067',44.4221756,9.3868095,80.3601,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010006','Busalla','Busalla','','NO','B282',44.5708295,8.9451193,16.8761,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010007','Camogli','Camogli','','NO','B490',44.3477492,9.1564789,10.1144,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010008','Campo Ligure','Campo Ligure','','NO','B538',44.5383304,8.6977090,23.5913,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010009','Campomorone','Campomorone','','NO','B551',44.5066837,8.8926928,25.6882,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010010','Carasco','Carasco','','NO','B726',44.3512346,9.3439511,8.3498,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010011','Casarza Ligure','Casarza Ligure','','NO','B939',44.2712325,9.4526940,28.1396,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010012','Casella','Casella','','NO','B956',44.5349222,8.9991771,7.9598,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010013','Castiglione Chiavarese','Castiglione Chiavarese','','NO','C302',44.2746007,9.5133558,29.6269,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010014','Ceranesi','Ceranesi','','NO','C481',44.5039658,8.8944489,31.1068,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010015','Chiavari','Chiavari','','NO','C621',44.3167222,9.3240471,12.4160,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010016','Cicagna','Cicagna','','NO','C673',44.4085011,9.2366600,10.8310,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010017','Cogoleto','Cogoleto','','NO','C823',44.3895448,8.6466775,20.6014,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010018','Cogorno','Cogorno','','NO','C826',44.3284477,9.3521265,9.2435,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010019','Coreglia Ligure','Coreglia Ligure','','NO','C995',44.3919885,9.2669615,7.8917,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010020','Crocefieschi','Crocefieschi','','NO','D175',44.5847802,9.0231405,11.8299,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010021','Davagna','Davagna','','NO','D255',44.4647270,9.0866465,20.6818,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010022','Fascia','Fascia','','NO','D509',44.5645025,9.2362835,10.8552,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010023','Favale di Malvaro','Favale di Malvaro','','NO','D512',44.4519983,9.2580620,16.7748,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010024','Fontanigorda','Fontanigorda','','NO','D677',44.5465578,9.3049637,16.3556,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010025','Genova','Genova','','SI','D969',44.4114928,8.9326876,239.9337,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010026','Gorreto','Gorreto','','NO','E109',44.6049722,9.2920884,19.1434,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010027','Isola del Cantone','Isola del Cantone','','NO','E341',44.6458100,8.9562761,47.8463,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010028','Lavagna','Lavagna','','NO','E488',44.3070784,9.3448784,13.9207,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010029','Leivi','Leivi','','NO','E519',44.3454720,9.3182319,9.5142,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010030','Lorsica','Lorsica','','NO','E695',44.4320633,9.2747218,18.0129,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010031','Lumarzo','Lumarzo','','NO','E737',44.4410090,9.1360629,25.4929,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010032','Masone','Masone','','NO','F020',44.5036411,8.7116755,29.6541,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010033','Mele','Mele','','NO','F098',44.4453633,8.7480039,16.9408,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010034','Mezzanego','Mezzanego','','NO','F173',44.3836639,9.3769092,28.6185,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010035','Mignanego','Mignanego','','NO','F202',44.5276135,8.9147518,16.4181,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010036','Moconesi','Moconesi','','NO','F256',44.4195246,9.2123522,16.5087,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010037','Moneglia','Moneglia','','NO','F354',44.2385296,9.4901413,15.6124,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010038','Montebruno','Montebruno','','NO','F445',44.5270623,9.2498687,17.5701,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010039','Montoggio','Montoggio','','NO','F682',44.5155926,9.0442261,47.6669,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010040','Ne','Ne','','NO','F858',44.3442564,9.3985063,63.3296,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010041','Neirone','Neirone','','NO','F862',44.4542763,9.1908948,30.2060,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010042','Orero','Orero','','NO','G093',44.4071951,9.2746498,16.1774,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010043','Pieve Ligure','Pieve Ligure','','NO','G646',44.3750042,9.0864821,3.6570,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010044','Portofino','Portofino','','NO','G913',44.3039959,9.2073993,2.6968,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010045','Propata','Propata','','NO','H073',44.5646978,9.1848861,17.2717,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010046','Rapallo','Rapallo','','NO','H183',44.3503136,9.2318083,33.7735,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010047','Recco','Recco','','NO','H212',44.3621696,9.1435571,9.5648,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010048','Rezzoaglio','Rezzoaglio','','NO','H258',44.5257210,9.3867174,104.1467,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010049','Ronco Scrivia','Ronco Scrivia','','NO','H536',44.6081978,8.9550222,30.3478,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010050','Rondanina','Rondanina','','NO','H546',44.5623634,9.2176327,12.8943,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010051','Rossiglione','Rossiglione','','NO','H581',44.5620283,8.6705257,47.8634,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010052','Rovegno','Rovegno','','NO','H599',44.5770857,9.2786696,44.4603,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010053','San Colombano Certenoli','San Colombano Certenoli','','NO','H802',44.3717295,9.3130861,41.5576,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010054','Santa Margherita Ligure','Santa Margherita Ligure','','NO','I225',44.3348732,9.2099514,10.1008,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010055','Sant\'Olcese','Sant\'Olcese','','NO','I346',44.4836522,8.9676521,21.9523,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010056','Santo Stefano d\'Aveto','Santo Stefano d\'Aveto','','NO','I368',44.5477960,9.4509780,55.0797,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010057','Savignone','Savignone','','NO','I475',44.5637789,8.9879703,21.6156,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010058','Serra Riccò','Serra Riccò','','NO','I640',44.5078432,8.9360067,26.4233,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010059','Sestri Levante','Sestri Levante','','NO','I693',44.2698329,9.3931921,33.4109,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010060','Sori','Sori','','NO','I852',44.3728046,9.1043663,13.0486,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010061','Tiglieto','Tiglieto','','NO','L167',44.5246390,8.6200184,24.5797,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010062','Torriglia','Torriglia','','NO','L298',44.5189732,9.1577277,59.8266,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010063','Tribogna','Tribogna','','NO','L416',44.4162732,9.1956089,6.8616,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010064','Uscio','Uscio','','NO','L507',44.4131786,9.1633290,9.6564,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010065','Valbrevenna','Valbrevenna','','NO','L546',44.5565372,9.0650533,34.5696,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010066','Vobbia','Vobbia','','NO','M105',44.5997275,9.0398278,33.4785,'210');
INSERT INTO `gi_comuni` VALUES ('GE','010067','Zoagli','Zoagli','','NO','M182',44.3370093,9.2672588,7.7978,'210');
INSERT INTO `gi_comuni` VALUES ('SP','011001','Ameglia','Ameglia','','NO','A261',44.0678535,9.9580580,14.4725,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011002','Arcola','Arcola','','NO','A373',44.1142763,9.9053428,16.3743,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011003','Beverino','Beverino','','NO','A836',44.1939159,9.7692300,34.9018,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011004','Bolano','Bolano','','NO','A932',44.1888909,9.8953074,14.5006,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011005','Bonassola','Bonassola','','NO','A961',44.1832875,9.5841131,9.3061,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011006','Borghetto di Vara','Borghetto di Vara','','NO','A992',44.2237902,9.7213442,26.9429,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011007','Brugnato','Brugnato','','NO','B214',44.2368382,9.7250560,12.1625,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011008','Calice al Cornoviglio','Calice al Cornoviglio','','NO','B410',44.2424361,9.8358532,33.8331,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011009','Carro','Carro','','NO','B838',44.2722122,9.6087517,31.5562,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011010','Carrodano','Carrodano','','NO','B839',44.2420333,9.6562163,21.8866,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011011','Castelnuovo Magra','Castelnuovo Magra','','NO','C240',44.0912585,10.0025445,15.1410,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011012','Deiva Marina','Deiva Marina','','NO','D265',44.2188221,9.5206110,13.9702,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011013','Follo','Follo','','NO','D655',44.1626947,9.8621288,23.1713,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011014','Framura','Framura','','NO','D758',44.2088771,9.5543630,19.3551,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011015','La Spezia','La Spezia','','SI','E463',44.1070346,9.8281896,51.7964,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011016','Lerici','Lerici','','NO','E542',44.0764146,9.9114739,15.8122,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011017','Levanto','Levanto','','NO','E560',44.1699213,9.6124474,36.4792,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011018','Maissana','Maissana','','NO','E842',44.3366364,9.5349897,45.5611,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011019','Monterosso al Mare','Monterosso al Mare','','NO','F609',44.1462552,9.6560966,11.0330,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011020','Luni','Luni','','NO','G143',44.0850025,10.0419073,13.8414,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011021','Pignone','Pignone','','NO','G664',44.1791630,9.7240793,17.9720,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011022','Portovenere','Portovenere','','NO','G925',44.0524778,9.8365543,7.8274,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011023','Riccò del Golfo di Spezia','Riccò del Golfo di Spezia','','NO','H275',44.1555447,9.7634101,37.6766,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011024','Riomaggiore','Riomaggiore','','NO','H304',44.0997191,9.7378620,10.2247,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011025','Rocchetta di Vara','Rocchetta di Vara','','NO','H461',44.2511710,9.7569008,32.7521,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011026','Santo Stefano di Magra','Santo Stefano di Magra','','NO','I363',44.1623774,9.9151666,14.0178,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011027','Sarzana','Sarzana','','NO','I449',44.1128722,9.9597012,34.6015,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011028','Sesta Godano','Sesta Godano','','NO','E070',44.2939570,9.6757573,68.3970,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011029','Varese Ligure','Varese Ligure','','NO','L681',44.3776925,9.5956378,137.5714,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011030','Vernazza','Vernazza','','NO','L774',44.1353166,9.6836947,12.3823,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011031','Vezzano Ligure','Vezzano Ligure','','NO','L819',44.1412538,9.8845273,18.2257,'011');
INSERT INTO `gi_comuni` VALUES ('SP','011032','Zignago','Zignago','','NO','M177',44.2775369,9.7450346,28.5997,'011');
INSERT INTO `gi_comuni` VALUES ('VA','012001','Agra','Agra','','NO','A085',46.0338319,8.7726899,2.9318,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012002','Albizzate','Albizzate','','NO','A167',45.7238817,8.8038596,3.8037,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012003','Angera','Angera','','NO','A290',45.7722639,8.5756830,17.5543,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012004','Arcisate','Arcisate','','NO','A371',45.8597726,8.8602482,12.0631,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012005','Arsago Seprio','Arsago Seprio','','NO','A441',45.6880056,8.7310712,10.4233,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012006','Azzate','Azzate','','NO','A531',45.7812435,8.7966449,4.7014,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012007','Azzio','Azzio','','NO','A532',45.8846917,8.7094940,1.9929,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012008','Barasso','Barasso','','NO','A619',45.8403586,8.7580622,4.0054,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012010','Bedero Valcuvia','Bedero Valcuvia','','NO','A728',45.9141491,8.7939478,2.6464,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012011','Besano','Besano','','NO','A819',45.8892330,8.8899453,3.0573,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012012','Besnate','Besnate','','NO','A825',45.7004404,8.7695484,7.3672,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012013','Besozzo','Besozzo','','NO','A826',45.8478959,8.6695550,13.8449,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012014','Biandronno','Biandronno','','NO','A845',45.8217420,8.7130938,9.5359,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012015','Bisuschio','Bisuschio','','NO','A891',45.8736993,8.8705111,6.9402,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012016','Bodio Lomnago','Bodio Lomnago','','NO','A918',45.7897059,8.7512003,3.9888,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012017','Brebbia','Brebbia','','NO','B126',45.8285776,8.6498389,7.0442,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012019','Brenta','Brenta','','NO','B150',45.8949211,8.6849324,4.1056,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012020','Brezzo di Bedero','Brezzo di Bedero','','NO','B166',45.9777739,8.7201111,9.8934,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012021','Brinzio','Brinzio','','NO','B182',45.8879313,8.7901901,6.3059,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012022','Brissago-Valtravaglia','Brissago-Valtravaglia','','NO','B191',45.9498367,8.7466544,6.1279,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012023','Brunello','Brunello','','NO','B219',45.7652477,8.7975022,1.6617,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012024','Brusimpiano','Brusimpiano','','NO','B228',45.9466221,8.8897892,5.8957,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012025','Buguggiate','Buguggiate','','NO','B258',45.7857522,8.8055043,2.4113,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012026','Busto Arsizio','Busto Arsizio','','NO','B300',45.6141246,8.8549948,30.7615,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012027','Cadegliano-Viconago','Cadegliano-Viconago','','NO','B326',45.9588585,8.8445200,10.1395,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012029','Cairate','Cairate','','NO','B368',45.6924862,8.8733714,11.3224,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012030','Cantello','Cantello','','NO','B634',45.8214691,8.8961048,9.3470,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012031','Caravate','Caravate','','NO','B732',45.8783957,8.6539351,5.1915,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012032','Cardano al Campo','Cardano al Campo','','NO','B754',45.6445077,8.7731652,9.3546,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012033','Carnago','Carnago','','NO','B796',45.7209295,8.8370003,6.1350,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012034','Caronno Pertusella','Caronno Pertusella','','NO','B805',45.5974102,9.0485158,8.6933,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012035','Caronno Varesino','Caronno Varesino','','NO','B807',45.7388007,8.8310431,5.7187,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012036','Casale Litta','Casale Litta','','NO','B875',45.7683704,8.7372988,10.6469,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012037','Casalzuigno','Casalzuigno','','NO','B921',45.9057755,8.7073993,7.4386,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012038','Casciago','Casciago','','NO','B949',45.8349782,8.7814609,4.2729,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012039','Casorate Sempione','Casorate Sempione','','NO','B987',45.6716823,8.7403386,7.0962,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012040','Cassano Magnago','Cassano Magnago','','NO','C004',45.6750298,8.8219311,12.0572,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012041','Cassano Valcuvia','Cassano Valcuvia','','NO','B999',45.9326427,8.7682591,3.8776,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012042','Castellanza','Castellanza','','NO','C139',45.6124980,8.8992183,7.0936,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012043','Castello Cabiaglio','Castello Cabiaglio','','NO','B312',45.8933422,8.7553733,7.0716,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012044','Castelseprio','Castelseprio','','NO','C273',45.7169562,8.8612558,3.8417,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012045','Castelveccana','Castelveccana','','NO','C181',45.9491897,8.6689602,20.9906,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012046','Castiglione Olona','Castiglione Olona','','NO','C300',45.7560801,8.8648126,6.8586,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012047','Castronno','Castronno','','NO','C343',45.7471118,8.8136429,3.6610,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012048','Cavaria con Premezzo','Cavaria con Premezzo','','NO','C382',45.6947613,8.8049823,3.3292,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012049','Cazzago Brabbia','Cazzago Brabbia','','NO','C409',45.7965592,8.7331676,4.0389,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012050','Cislago','Cislago','','NO','C732',45.6606874,8.9706846,10.8108,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012051','Cittiglio','Cittiglio','','NO','C751',45.8946518,8.6686910,10.9779,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012052','Clivio','Clivio','','NO','C796',45.8634373,8.9329959,2.9747,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012053','Cocquio-Trevisago','Cocquio-Trevisago','','NO','C810',45.8597314,8.6961106,9.7189,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012054','Comabbio','Comabbio','','NO','C911',45.7724197,8.6748839,4.7092,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012055','Comerio','Comerio','','NO','C922',45.8386698,8.7473622,5.7165,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012056','Cremenaga','Cremenaga','','NO','D144',45.9883784,8.8073000,4.4455,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012057','Crosio della Valle','Crosio della Valle','','NO','D185',45.7590238,8.7720698,1.5147,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012058','Cuasso al Monte','Cuasso al Monte','','NO','D192',45.9148599,8.8793777,16.4165,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012059','Cugliate-Fabiasco','Cugliate-Fabiasco','','NO','D199',45.9476888,8.8215731,6.2963,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012060','Cunardo','Cunardo','','NO','D204',45.9375565,8.8033998,5.9746,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012061','Curiglia con Monteviasco','Curiglia con Monteviasco','','NO','D217',46.0604818,8.8034511,10.9073,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012062','Cuveglio','Cuveglio','','NO','D238',45.9051808,8.7347238,7.3431,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012063','Cuvio','Cuvio','','NO','D239',45.8967596,8.7310901,5.8731,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012064','Daverio','Daverio','','NO','D256',45.7747888,8.7712271,4.0365,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012065','Dumenza','Dumenza','','NO','D384',46.0244321,8.7858402,18.3301,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012066','Duno','Duno','','NO','D385',45.9134902,8.7392524,2.5271,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012067','Fagnano Olona','Fagnano Olona','','NO','D467',45.6696277,8.8740644,8.7000,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012068','Ferno','Ferno','','NO','D543',45.6115916,8.7588639,8.4108,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012069','Ferrera di Varese','Ferrera di Varese','','NO','D551',45.9327179,8.7872225,1.6211,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012070','Gallarate','Gallarate','','NO','D869',45.6602041,8.7932315,21.2137,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012071','Galliate Lombardo','Galliate Lombardo','','NO','D871',45.7843896,8.7710781,3.2630,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012072','Gavirate','Gavirate','','NO','D946',45.8425868,8.7178025,11.8770,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012073','Gazzada Schianno','Gazzada Schianno','','NO','D951',45.7838098,8.8266102,4.7612,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012074','Gemonio','Gemonio','','NO','D963',45.8785532,8.6770768,3.6964,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012075','Gerenzano','Gerenzano','','NO','D981',45.6390022,8.9988173,9.9841,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012076','Germignaga','Germignaga','','NO','D987',45.9932506,8.7256901,4.4535,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012077','Golasecca','Golasecca','','NO','E079',45.6968342,8.6550293,7.4262,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012078','Gorla Maggiore','Gorla Maggiore','','NO','E101',45.6644313,8.8907614,5.1616,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012079','Gorla Minore','Gorla Minore','','NO','E102',45.6429446,8.8974289,7.4697,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012080','Gornate Olona','Gornate Olona','','NO','E104',45.7399811,8.8603830,4.7558,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012081','Grantola','Grantola','','NO','E144',45.9507034,8.7754160,2.0493,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012082','Inarzo','Inarzo','','NO','E292',45.7859599,8.7363475,2.5174,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012083','Induno Olona','Induno Olona','','NO','E299',45.8518590,8.8384289,12.3999,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012084','Ispra','Ispra','','NO','E367',45.8161076,8.6102102,16.0088,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012085','Jerago con Orago','Jerago con Orago','','NO','E386',45.7073936,8.7907715,3.8473,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012086','Lavena Ponte Tresa','Lavena Ponte Tresa','','NO','E494',45.9612336,8.8604659,4.3749,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012087','Laveno-Mombello','Laveno-Mombello','','NO','E496',45.9125051,8.6185770,23.3213,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012088','Leggiuno','Leggiuno','','NO','E510',45.8749845,8.6203558,13.4130,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012089','Lonate Ceppino','Lonate Ceppino','','NO','E665',45.7038338,8.8764510,4.8209,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012090','Lonate Pozzolo','Lonate Pozzolo','','NO','E666',45.5994983,8.7510049,29.5829,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012091','Lozza','Lozza','','NO','E707',45.7754234,8.8571683,1.7801,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012092','Luino','Luino','','NO','E734',46.0025424,8.7424195,21.0822,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012093','Luvinate','Luvinate','','NO','E769',45.8404735,8.7683104,3.8830,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012096','Malnate','Malnate','','NO','E863',45.8000104,8.8802536,8.7395,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012097','Marchirolo','Marchirolo','','NO','E929',45.9514816,8.8346601,5.5342,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012098','Marnate','Marnate','','NO','E965',45.6291540,8.9015050,4.8508,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012099','Marzio','Marzio','','NO','F002',45.9383041,8.8584127,1.9274,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012100','Masciago Primo','Masciago Primo','','NO','F007',45.9164580,8.7808327,1.9513,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012101','Mercallo','Mercallo','','NO','F134',45.7482911,8.6705519,5.3982,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012102','Mesenzana','Mesenzana','','NO','F154',45.9471010,8.7588866,5.0089,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012103','Montegrino Valtravaglia','Montegrino Valtravaglia','','NO','F526',45.9723688,8.7696981,10.1601,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012104','Monvalle','Monvalle','','NO','F703',45.8580205,8.6319948,4.5151,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012105','Morazzone','Morazzone','','NO','F711',45.7680608,8.8295389,5.8308,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012106','Mornago','Mornago','','NO','F736',45.7474559,8.7519840,12.2090,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012107','Oggiona con Santo Stefano','Oggiona con Santo Stefano','','NO','G008',45.7007551,8.8226756,2.7429,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012108','Olgiate Olona','Olgiate Olona','','NO','G028',45.6296169,8.8886692,7.2952,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012109','Origgio','Origgio','','NO','G103',45.5997568,9.0176383,7.8113,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012110','Orino','Orino','','NO','G105',45.8819193,8.7155537,3.8574,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012113','Porto Ceresio','Porto Ceresio','','NO','G906',45.9031816,8.9058098,5.5639,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012114','Porto Valtravaglia','Porto Valtravaglia','','NO','G907',45.9621401,8.6809393,16.3021,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012115','Rancio Valcuvia','Rancio Valcuvia','','NO','H173',45.9163932,8.7701659,4.3551,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012116','Ranco','Ranco','','NO','H174',45.7977287,8.5713644,6.7518,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012117','Saltrio','Saltrio','','NO','H723',45.8735929,8.9243717,3.5019,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012118','Samarate','Samarate','','NO','H736',45.6303454,8.7850915,15.9934,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012119','Saronno','Saronno','','NO','I441',45.6237471,9.0364046,11.2029,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012120','Sesto Calende','Sesto Calende','','NO','I688',45.7237443,8.6314340,25.0142,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012121','Solbiate Arno','Solbiate Arno','','NO','I793',45.7195453,8.8152890,3.1934,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012122','Solbiate Olona','Solbiate Olona','','NO','I794',45.6528762,8.8867876,5.0367,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012123','Somma Lombardo','Somma Lombardo','','NO','I819',45.6834795,8.7065170,30.2039,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012124','Sumirago','Sumirago','','NO','L003',45.7406633,8.7807544,11.7422,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012125','Taino','Taino','','NO','L032',45.7649071,8.6159774,7.7456,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012126','Ternate','Ternate','','NO','L115',45.7824411,8.6901038,4.6568,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012127','Tradate','Tradate','','NO','L319',45.7135120,8.9059783,21.3537,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012128','Travedona-Monate','Travedona-Monate','','NO','L342',45.8069463,8.6745525,9.6726,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012129','Tronzano Lago Maggiore','Tronzano Lago Maggiore','','NO','A705',46.0888636,8.7336507,11.0428,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012130','Uboldo','Uboldo','','NO','L480',45.6107202,9.0030687,10.5872,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012131','Valganna','Valganna','','NO','L577',45.9022057,8.8252610,12.7623,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012132','Varano Borghi','Varano Borghi','','NO','L671',45.7746873,8.7030664,3.2387,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012133','Varese','Varese','','SI','L682',45.8184917,8.8240295,55.0110,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012134','Vedano Olona','Vedano Olona','','NO','L703',45.7770304,8.8859183,6.9862,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012136','Venegono Inferiore','Venegono Inferiore','','NO','L733',45.7376635,8.8995757,6.0229,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012137','Venegono Superiore','Venegono Superiore','','NO','L734',45.7491256,8.9018514,6.9027,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012138','Vergiate','Vergiate','','NO','L765',45.7245496,8.6954124,21.7765,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012139','Viggiù','Viggiù','','NO','L876',45.8712728,8.9060365,9.1964,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012140','Vizzola Ticino','Vizzola Ticino','','NO','M101',45.6311841,8.6853760,7.6227,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012141','Sangiano','Sangiano','','NO','H872',45.8753222,8.6327224,2.2612,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012142','Maccagno con Pino e Veddasca','Maccagno con Pino e Veddasca','','NO','M339',46.0426008,8.7384071,41.7895,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012143','Cadrezzate con Osmate','Cadrezzate con Osmate','','NO','M425',45.7978390,8.6429928,8.2205,'012');
INSERT INTO `gi_comuni` VALUES ('VA','012144','Bardello con Malgesso e Bregano','Bardello con Malgesso e Bregano','','NO','M433',45.8266369,8.6851845,7.4300,'012');
INSERT INTO `gi_comuni` VALUES ('CO','013003','Albavilla','Albavilla','','NO','A143',45.8022558,9.1875143,10.5257,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013004','Albese con Cassano','Albese con Cassano','','NO','A153',45.7963189,9.1627712,8.0154,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013005','Albiolo','Albiolo','','NO','A164',45.8073031,8.9371818,2.9319,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013006','Alserio','Alserio','','NO','A224',45.7815721,9.1998093,1.7485,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013007','Alzate Brianza','Alzate Brianza','','NO','A249',45.7670947,9.1816784,7.4002,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013009','Anzano del Parco','Anzano del Parco','','NO','A319',45.7705607,9.1989878,3.2535,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013010','Appiano Gentile','Appiano Gentile','','NO','A333',45.7384929,8.9817757,12.7588,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013011','Argegno','Argegno','','NO','A391',45.9451734,9.1279587,4.1715,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013012','Arosio','Arosio','','NO','A430',45.7177634,9.2086322,2.5009,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013013','Asso','Asso','','NO','A476',45.8616109,9.2693908,6.4571,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013015','Barni','Barni','','NO','A670',45.9104113,9.2642795,5.6757,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013021','Bene Lario','Bene Lario','','NO','A778',46.0288905,9.1837788,5.6808,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013022','Beregazzo con Figliaro','Beregazzo con Figliaro','','NO','A791',45.7759098,8.9508799,3.9224,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013023','Binago','Binago','','NO','A870',45.7841813,8.9220242,7.1178,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013024','Bizzarone','Bizzarone','','NO','A898',45.8345200,8.9438784,2.6909,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013025','Blessagno','Blessagno','','NO','A904',45.9613482,9.0974203,3.5122,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013026','Blevio','Blevio','','NO','A905',45.8392383,9.1036062,5.4617,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013028','Bregnano','Bregnano','','NO','B134',45.6987461,9.0610766,6.1077,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013029','Brenna','Brenna','','NO','B144',45.7431885,9.1851163,5.1299,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013030','Brienno','Brienno','','NO','B172',45.9120384,9.1315317,8.9326,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013032','Brunate','Brunate','','NO','B218',45.8191672,9.0968211,2.0080,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013034','Bulgarograsso','Bulgarograsso','','NO','B262',45.7501287,9.0083872,3.8721,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013035','Cabiate','Cabiate','','NO','B313',45.6754772,9.1680035,3.0869,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013036','Cadorago','Cadorago','','NO','B346',45.7245041,9.0380392,7.3597,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013037','Caglio','Caglio','','NO','B355',45.8715005,9.2380854,6.6089,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013040','Campione d\'Italia','Campione d\'Italia','','NO','B513',45.9700818,8.9707009,2.8111,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013041','Cantù','Cantù','','NO','B639',45.7391398,9.1266516,23.3646,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013042','Canzo','Canzo','','NO','B641',45.8500090,9.2734710,11.2855,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013043','Capiago Intimiano','Capiago Intimiano','','NO','B653',45.7721725,9.1243411,5.9224,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013044','Carate Urio','Carate Urio','','NO','B730',45.8733740,9.1275423,7.0757,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013045','Carbonate','Carbonate','','NO','B742',45.6846879,8.9404789,4.9825,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013046','Carimate','Carimate','','NO','B778',45.7021363,9.1146943,5.1649,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013047','Carlazzo','Carlazzo','','NO','B785',46.0499964,9.1550695,12.8110,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013048','Carugo','Carugo','','NO','B851',45.7089007,9.1935626,4.0306,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013052','Caslino d\'Erba','Caslino d\'Erba','','NO','B974',45.8374274,9.2268015,6.7926,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013053','Casnate con Bernate','Casnate con Bernate','','NO','B977',45.7567856,9.0746355,5.3607,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013055','Cassina Rizzardi','Cassina Rizzardi','','NO','C020',45.7505114,9.0311503,3.3916,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013058','Castelmarte','Castelmarte','','NO','C206',45.8326626,9.2325453,1.9416,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013059','Castelnuovo Bozzente','Castelnuovo Bozzente','','NO','C220',45.7629642,8.9396746,3.6857,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013062','Cavargna','Cavargna','','NO','C381',46.0907478,9.1111684,15.0619,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013063','Cerano d\'Intelvi','Cerano d\'Intelvi','','NO','C482',45.9459151,9.0879298,5.8732,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013064','Cermenate','Cermenate','','NO','C516',45.6994866,9.0800057,8.2533,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013065','Cernobbio','Cernobbio','','NO','C520',45.8396485,9.0743633,11.9638,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013068','Cirimido','Cirimido','','NO','C724',45.7004257,9.0110704,2.6651,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013071','Claino con Osteno','Claino con Osteno','','NO','C787',46.0069113,9.0843233,12.7583,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013074','Colonno','Colonno','','NO','C902',45.9575495,9.1551931,5.8705,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013075','Como','Como','','SI','C933',45.8100107,9.0851559,37.3262,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013077','Corrido','Corrido','','NO','D041',46.0467217,9.1377593,6.1752,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013083','Cremia','Cremia','','NO','D147',46.0870553,9.2717531,10.0759,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013084','Cucciago','Cucciago','','NO','D196',45.7400698,9.0939617,5.0329,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013085','Cusino','Cusino','','NO','D232',46.0741881,9.1527977,9.6770,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013087','Dizzasco','Dizzasco','','NO','D310',45.9449051,9.0980395,3.8367,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013089','Domaso','Domaso','','NO','D329',46.1502474,9.3290696,6.3694,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013090','Dongo','Dongo','','NO','D341',46.1230842,9.2794895,7.1213,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013092','Dosso del Liro','Dosso del Liro','','NO','D355',46.1633214,9.2736603,23.6415,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013095','Erba','Erba','','NO','D416',45.8119101,9.2231903,17.9205,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013097','Eupilio','Eupilio','','NO','D445',45.8152206,9.2638623,6.7905,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013098','Faggeto Lario','Faggeto Lario','','NO','D462',45.8591841,9.1591066,17.8403,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013099','Faloppio','Faloppio','','NO','D482',45.8117265,8.9636159,4.1356,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013100','Fenegrò','Fenegrò','','NO','D531',45.7006516,9.0012404,5.5508,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013101','Figino Serenza','Figino Serenza','','NO','D579',45.7134005,9.1288176,5.0162,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013102','Fino Mornasco','Fino Mornasco','','NO','D605',45.7456610,9.0505377,7.1388,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013106','Garzeno','Garzeno','','NO','D930',46.1341534,9.2483208,28.8143,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013107','Gera Lario','Gera Lario','','NO','D974',46.1693932,9.3716213,7.0914,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013110','Grandate','Grandate','','NO','E139',45.7733970,9.0605462,3.0467,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013111','Grandola ed Uniti','Grandola ed Uniti','','NO','E141',46.0308602,9.2078948,16.6884,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013113','Griante','Griante','','NO','E172',45.9940485,9.2354086,6.7125,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013114','Guanzate','Guanzate','','NO','E235',45.7242600,9.0134588,6.7543,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013118','Inverigo','Inverigo','','NO','E309',45.7349653,9.2163467,10.3431,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013119','Laglio','Laglio','','NO','E405',45.8835171,9.1401410,6.1815,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013120','Laino','Laino','','NO','E416',45.9838978,9.0735350,6.4904,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013121','Lambrugo','Lambrugo','','NO','E428',45.7583521,9.2416482,1.8382,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013123','Lasnigo','Lasnigo','','NO','E462',45.8822268,9.2672173,5.6409,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013126','Lezzeno','Lezzeno','','NO','E569',45.9465050,9.1943919,20.5680,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013128','Limido Comasco','Limido Comasco','','NO','E593',45.6904226,8.9812840,4.6757,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013129','Lipomo','Lipomo','','NO','E607',45.7947328,9.1215499,2.3310,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013130','Livo','Livo','','NO','E623',46.1675711,9.3025023,33.0161,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013131','Locate Varesino','Locate Varesino','','NO','E638',45.6903482,8.9308318,6.0366,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013133','Lomazzo','Lomazzo','','NO','E659',45.6991647,9.0408748,9.5663,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013134','Longone al Segrino','Longone al Segrino','','NO','E679',45.8172566,9.2510283,1.4067,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013135','Luisago','Luisago','','NO','E735',45.7604783,9.0439323,2.1116,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013136','Lurago d\'Erba','Lurago d\'Erba','','NO','E749',45.7527833,9.2222938,4.5263,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013137','Lurago Marinone','Lurago Marinone','','NO','E750',45.7055710,8.9833314,3.6508,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013138','Lurate Caccivio','Lurate Caccivio','','NO','E753',45.7673792,9.0014728,5.9673,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013139','Magreglio','Magreglio','','NO','E830',45.9200995,9.2618043,3.2533,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013143','Mariano Comense','Mariano Comense','','NO','E951',45.6983023,9.1801413,13.6994,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013144','Maslianico','Maslianico','','NO','F017',45.8425723,9.0470412,1.3352,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013145','Menaggio','Menaggio','','NO','F120',46.0211632,9.2389339,11.8724,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013147','Merone','Merone','','NO','F151',45.7876517,9.2470928,3.4586,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013152','Moltrasio','Moltrasio','','NO','F305',45.8612715,9.0989138,9.0722,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013153','Monguzzo','Monguzzo','','NO','F372',45.7829011,9.2323496,3.8966,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013154','Montano Lucino','Montano Lucino','','NO','F427',45.7861500,9.0394800,5.1176,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013155','Montemezzo','Montemezzo','','NO','F564',46.1780286,9.3749995,9.0740,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013157','Montorfano','Montorfano','','NO','F688',45.7859046,9.1468766,3.5137,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013159','Mozzate','Mozzate','','NO','F788',45.6750021,8.9559421,10.7108,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013160','Musso','Musso','','NO','F828',46.1113466,9.2747765,3.8456,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013161','Nesso','Nesso','','NO','F877',45.9114501,9.1570748,14.5864,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013163','Novedrate','Novedrate','','NO','F958',45.6987572,9.1201499,2.8282,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013165','Olgiate Comasco','Olgiate Comasco','','NO','G025',45.7848659,8.9688245,10.8691,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013169','Oltrona di San Mamette','Oltrona di San Mamette','','NO','G056',45.7577050,8.9779706,2.7424,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013170','Orsenigo','Orsenigo','','NO','G126',45.7783507,9.1852194,4.3750,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013178','Peglio','Peglio','','NO','G415',46.1599122,9.2939323,10.6719,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013183','Pianello del Lario','Pianello del Lario','','NO','G556',46.0983661,9.2756819,9.7263,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013184','Pigra','Pigra','','NO','G665',45.9574595,9.1276782,4.3856,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013185','Plesio','Plesio','','NO','G737',46.0427059,9.2266904,16.9589,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013186','Pognana Lario','Pognana Lario','','NO','G773',45.8794614,9.1579343,5.1932,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013187','Ponna','Ponna','','NO','G821',45.9893663,9.0941137,5.8135,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013188','Ponte Lambro','Ponte Lambro','','NO','G847',45.8303311,9.2252154,3.4330,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013189','Porlezza','Porlezza','','NO','G889',46.0369224,9.1202785,18.6216,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013192','Proserpio','Proserpio','','NO','H074',45.8276283,9.2482657,2.2615,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013193','Pusiano','Pusiano','','NO','H094',45.8136493,9.2828801,3.1844,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013195','Rezzago','Rezzago','','NO','H255',45.8660418,9.2508210,4.0621,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013197','Rodero','Rodero','','NO','H478',45.8226639,8.9133983,2.5373,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013201','Rovellasca','Rovellasca','','NO','H601',45.6696500,9.0504962,3.3051,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013202','Rovello Porro','Rovello Porro','','NO','H602',45.6543431,9.0411318,5.6352,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013203','Sala Comacina','Sala Comacina','','NO','H679',45.9658193,9.1684078,4.5861,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013204','San Bartolomeo Val Cavargna','San Bartolomeo Val Cavargna','','NO','H760',46.0825336,9.1462630,10.6976,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013206','San Fermo della Battaglia','San Fermo della Battaglia','','NO','H840',45.8080925,9.0486705,5.7879,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013207','San Nazzaro Val Cavargna','San Nazzaro Val Cavargna','','NO','I051',46.0892924,9.1305331,12.8828,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013211','Schignano','Schignano','','NO','I529',45.9267287,9.1008806,10.0612,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013212','Senna Comasco','Senna Comasco','','NO','I611',45.7636536,9.1089568,2.6502,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013216','Sorico','Sorico','','NO','I856',46.1724260,9.3815145,24.4702,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013217','Sormano','Sormano','','NO','I860',45.8788017,9.2475114,10.5839,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013218','Stazzona','Stazzona','','NO','I943',46.1400330,9.2764510,7.2925,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013222','Tavernerio','Tavernerio','','NO','L071',45.7996809,9.1503944,11.6371,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013223','Torno','Torno','','NO','L228',45.8575388,9.1150502,7.3927,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013226','Trezzone','Trezzone','','NO','L413',46.1709095,9.3510963,3.9493,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013227','Turate','Turate','','NO','L470',45.6556277,9.0021797,10.4240,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013229','Valbrona','Valbrona','','NO','L547',45.8792539,9.2986944,13.3815,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013232','Valmorea','Valmorea','','NO','L640',45.8135466,8.9291794,3.0674,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013233','Val Rezzo','Val Rezzo','','NO','H259',46.0716099,9.1109149,6.5594,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013234','Valsolda','Valsolda','','NO','C936',46.0247210,9.0528259,31.9105,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013236','Veleso','Veleso','','NO','L715',45.9085603,9.1815401,6.0404,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013238','Veniano','Veniano','','NO','L737',45.7180345,8.9862272,3.0976,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013239','Vercana','Vercana','','NO','L748',46.1594523,9.3318212,15.1311,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013242','Vertemate con Minoprio','Vertemate con Minoprio','','NO','L792',45.7278459,9.0733144,5.6150,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013245','Villa Guardia','Villa Guardia','','NO','L956',45.7739419,9.0233962,7.7541,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013246','Zelbio','Zelbio','','NO','M156',45.9049881,9.1808685,4.6779,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013248','San Siro','San Siro','','NO','I162',46.0552737,9.2585125,18.7543,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013249','Gravedona ed Uniti','Gravedona ed Uniti','','NO','M315',46.1481477,9.3062159,39.5098,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013250','Bellagio','Bellagio','','NO','M335',45.9854295,9.2621708,29.1572,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013251','Colverde','Colverde','','NO','M336',45.8105932,9.0074427,8.5840,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013252','Tremezzina','Tremezzina','','NO','M341',45.9734476,9.1957868,29.2260,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013253','Alta Valle Intelvi','Alta Valle Intelvi','','NO','M383',45.9796136,9.0220985,25.4620,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013254','Centro Valle Intelvi','Centro Valle Intelvi','','NO','M394',45.9678765,9.0777426,19.5238,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013255','Solbiate con Cagno','Solbiate con Cagno','','NO','M412',45.7903335,8.9351320,7.4755,'013');
INSERT INTO `gi_comuni` VALUES ('CO','013256','Uggiate con Ronago','Uggiate con Ronago','','NO','M435',45.8251828,8.9691433,7.7569,'013');
INSERT INTO `gi_comuni` VALUES ('SO','014001','Albaredo per San Marco','Albaredo per San Marco','','NO','A135',46.1023385,9.5900442,18.9914,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014002','Albosaggia','Albosaggia','','NO','A172',46.1472868,9.8531512,34.3677,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014003','Andalo Valtellino','Andalo Valtellino','','NO','A273',46.1326602,9.4744212,6.7780,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014004','Aprica','Aprica','','NO','A337',46.1534468,10.1520601,20.2499,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014005','Ardenno','Ardenno','','NO','A382',46.1719031,9.6523590,17.2478,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014006','Bema','Bema','','NO','A777',46.1075550,9.5641467,19.3094,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014007','Berbenno di Valtellina','Berbenno di Valtellina','','NO','A787',46.1686472,9.7422324,35.6681,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014008','Bianzone','Bianzone','','NO','A848',46.1870547,10.1068410,17.2141,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014009','Bormio','Bormio','','NO','B049',46.4695191,10.3761620,41.2611,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014010','Buglio in Monte','Buglio in Monte','','NO','B255',46.1830146,9.6767247,27.9847,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014011','Caiolo','Caiolo','','NO','B366',46.1511172,9.8174064,32.8847,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014012','Campodolcino','Campodolcino','','NO','B530',46.4021714,9.3543205,48.6788,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014013','Caspoggio','Caspoggio','','NO','B993',46.2644278,9.8643850,7.1673,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014014','Castello dell\'Acqua','Castello dell\'Acqua','','NO','C186',46.1457531,10.0127424,14.1633,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014015','Castione Andevenno','Castione Andevenno','','NO','C325',46.1731029,9.8007323,16.9870,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014016','Cedrasco','Cedrasco','','NO','C418',46.1485658,9.7665365,14.5789,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014017','Cercino','Cercino','','NO','C493',46.1573112,9.5082764,5.7020,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014018','Chiavenna','Chiavenna','','NO','C623',46.3210125,9.4035085,10.9213,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014019','Chiesa in Valmalenco','Chiesa in Valmalenco','','NO','C628',46.2638219,9.8482549,107.5031,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014020','Chiuro','Chiuro','','NO','C651',46.1706858,9.9890970,52.0594,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014021','Cino','Cino','','NO','C709',46.1578342,9.4863172,5.0390,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014022','Civo','Civo','','NO','C785',46.1564955,9.5812752,25.0402,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014023','Colorina','Colorina','','NO','C903',46.1514366,9.7320557,17.8671,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014024','Cosio Valtellino','Cosio Valtellino','','NO','D088',46.1308854,9.5517943,23.7979,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014025','Dazio','Dazio','','NO','D258',46.1616812,9.6031599,3.5520,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014026','Delebio','Delebio','','NO','D266',46.1370846,9.4592406,22.1651,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014027','Dubino','Dubino','','NO','D377',46.1537001,9.4559153,13.6421,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014028','Faedo Valtellino','Faedo Valtellino','','NO','D456',46.1529220,9.9058966,4.7844,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014029','Forcola','Forcola','','NO','D694',46.1573938,9.6622687,15.6848,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014030','Fusine','Fusine','','NO','D830',46.1491993,9.7489417,37.4901,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014031','Gerola Alta','Gerola Alta','','NO','D990',46.0586987,9.5508560,37.1717,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014032','Gordona','Gordona','','NO','E090',46.2913609,9.3678189,62.8367,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014033','Grosio','Grosio','','NO','E200',46.2983329,10.2754297,127.0150,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014034','Grosotto','Grosotto','','NO','E201',46.2799643,10.2581810,53.2263,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014035','Madesimo','Madesimo','','NO','E342',46.4274793,9.3439780,85.7460,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014036','Lanzada','Lanzada','','NO','E443',46.2695935,9.8716274,117.2163,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014037','Livigno','Livigno','','NO','E621',46.5386205,10.1348616,227.4220,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014038','Lovero','Lovero','','NO','E705',46.2321157,10.2302741,13.2844,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014039','Mantello','Mantello','','NO','E896',46.1524555,9.4886211,3.7826,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014040','Mazzo di Valtellina','Mazzo di Valtellina','','NO','F070',46.2584773,10.2558824,15.1417,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014041','Mello','Mello','','NO','F115',46.1543093,9.5475898,11.5793,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014043','Mese','Mese','','NO','F153',46.3056028,9.3801444,4.1307,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014044','Montagna in Valtellina','Montagna in Valtellina','','NO','F393',46.1792683,9.9045248,45.3566,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014045','Morbegno','Morbegno','','NO','F712',46.1307951,9.5703664,14.9624,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014046','Novate Mezzola','Novate Mezzola','','NO','F956',46.2209894,9.4479105,99.6409,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014047','Pedesina','Pedesina','','NO','G410',46.0821937,9.5493198,6.2794,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014048','Piantedo','Piantedo','','NO','G572',46.1361274,9.4302860,6.8205,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014049','Piateda','Piateda','','NO','G576',46.1596505,9.9415441,70.9480,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014050','Piuro','Piuro','','NO','G718',46.3301654,9.4208704,84.0045,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014051','Poggiridenti','Poggiridenti','','NO','G431',46.1765657,9.9300845,2.8567,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014052','Ponte in Valtellina','Ponte in Valtellina','','NO','G829',46.1746913,9.9802131,67.5715,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014053','Postalesio','Postalesio','','NO','G937',46.1732842,9.7771467,10.6986,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014054','Prata Camportaccio','Prata Camportaccio','','NO','G993',46.3074967,9.3977818,27.8786,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014055','Rasura','Rasura','','NO','H192',46.0992894,9.5531658,6.0505,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014056','Rogolo','Rogolo','','NO','H493',46.1355350,9.4873974,12.9552,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014057','Samolaco','Samolaco','','NO','H752',46.2463307,9.3948387,45.7111,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014058','San Giacomo Filippo','San Giacomo Filippo','','NO','H868',46.3372777,9.3707481,62.0802,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014059','Sernio','Sernio','','NO','I636',46.2237880,10.2030549,9.5678,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014060','Sondalo','Sondalo','','NO','I828',46.3310931,10.3253249,95.6409,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014061','Sondrio','Sondrio','','SI','I829',46.1709959,9.8712633,20.7370,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014062','Spriana','Spriana','','NO','I928',46.2202479,9.8646420,7.8059,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014063','Talamona','Talamona','','NO','L035',46.1363186,9.6098782,21.0519,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014064','Tartano','Tartano','','NO','L056',46.1068678,9.6801446,47.2713,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014065','Teglio','Teglio','','NO','L084',46.1724134,10.0671593,115.0963,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014066','Tirano','Tirano','','NO','L175',46.2157046,10.1735663,32.3786,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014067','Torre di Santa Maria','Torre di Santa Maria','','NO','L244',46.2337110,9.8515533,43.8226,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014068','Tovo di Sant\'Agata','Tovo di Sant\'Agata','','NO','L316',46.2447869,10.2454483,11.1776,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014069','Traona','Traona','','NO','L330',46.1494295,9.5265109,6.2706,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014070','Tresivio','Tresivio','','NO','L392',46.1761871,9.9441474,15.0638,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014071','Valdidentro','Valdidentro','','NO','L557',46.4896953,10.2951533,226.0070,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014072','Valdisotto','Valdisotto','','NO','L563',46.4264447,10.3551430,89.8043,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014073','Valfurva','Valfurva','','NO','L576',46.4629854,10.4107071,215.3171,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014074','Val Masino','Val Masino','','NO','L638',46.2127512,9.6372204,116.3806,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014075','Verceia','Verceia','','NO','L749',46.1977465,9.4516418,11.3624,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014076','Vervio','Vervio','','NO','L799',46.2524256,10.2398562,12.4919,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014077','Villa di Chiavenna','Villa di Chiavenna','','NO','L907',46.3311172,9.4870414,32.7078,'014');
INSERT INTO `gi_comuni` VALUES ('SO','014078','Villa di Tirano','Villa di Tirano','','NO','L908',46.2027664,10.1310527,24.6774,'014');
INSERT INTO `gi_comuni` VALUES ('MI','015002','Abbiategrasso','Abbiategrasso','','NO','A010',45.3985721,8.9164468,47.5077,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015005','Albairate','Albairate','','NO','A127',45.4200722,8.9379830,15.3567,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015007','Arconate','Arconate','','NO','A375',45.5412149,8.8513707,8.6086,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015009','Arese','Arese','','NO','A389',45.5499153,9.0787240,6.5739,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015010','Arluno','Arluno','','NO','A413',45.5061635,8.9471748,12.5026,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015011','Assago','Assago','','NO','A473',45.4056359,9.1317040,8.2851,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015012','Bareggio','Bareggio','','NO','A652',45.4765575,8.9966384,11.2577,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015014','Basiano','Basiano','','NO','A697',45.5734117,9.4697812,4.6096,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015015','Basiglio','Basiglio','','NO','A699',45.3615688,9.1579832,8.7281,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015016','Bellinzago Lombardo','Bellinzago Lombardo','','NO','A751',45.5410280,9.4463711,4.8219,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015019','Bernate Ticino','Bernate Ticino','','NO','A804',45.4796893,8.8181296,12.0961,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015022','Besate','Besate','','NO','A820',45.3112537,8.9687849,12.8608,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015024','Binasco','Binasco','','NO','A872',45.3321920,9.0996124,3.8327,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015026','Boffalora sopra Ticino','Boffalora sopra Ticino','','NO','A920',45.4675677,8.8296863,7.7724,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015027','Bollate','Bollate','','NO','A940',45.5438146,9.1176638,12.9103,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015032','Bresso','Bresso','','NO','B162',45.5375910,9.1876244,3.3824,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015035','Bubbiano','Bubbiano','','NO','B235',45.3275505,9.0153824,2.8261,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015036','Buccinasco','Buccinasco','','NO','B240',45.4223315,9.1083124,11.6900,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015038','Buscate','Buscate','','NO','B286',45.5447940,8.8122372,7.6267,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015040','Bussero','Bussero','','NO','B292',45.5364451,9.3722252,4.4325,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015041','Busto Garolfo','Busto Garolfo','','NO','B301',45.5455791,8.8850385,12.8642,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015042','Calvignasco','Calvignasco','','NO','B448',45.3330192,9.0192732,1.7639,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015044','Cambiago','Cambiago','','NO','B461',45.5705054,9.4249719,7.2253,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015046','Canegrate','Canegrate','','NO','B593',45.5706521,8.9266966,5.1707,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015050','Carpiano','Carpiano','','NO','B820',45.3408669,9.2737354,17.4575,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015051','Carugate','Carugate','','NO','B850',45.5496216,9.3384912,5.5679,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015055','Casarile','Casarile','','NO','B938',45.3170254,9.1055261,7.5408,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015058','Casorezzo','Casorezzo','','NO','B989',45.5180796,8.9036926,6.5312,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015059','Cassano d\'Adda','Cassano d\'Adda','','NO','C003',45.5255492,9.5207800,18.3635,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015060','Cassina de\' Pecchi','Cassina de\' Pecchi','','NO','C014',45.5197855,9.3642418,6.9880,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015061','Cassinetta di Lugagnano','Cassinetta di Lugagnano','','NO','C033',45.4257147,8.9099964,3.3447,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015062','Castano Primo','Castano Primo','','NO','C052',45.5527102,8.7759992,19.2305,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015070','Cernusco sul Naviglio','Cernusco sul Naviglio','','NO','C523',45.5238246,9.3330379,13.0757,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015071','Cerro al Lambro','Cerro al Lambro','','NO','C536',45.3314744,9.3439380,10.3711,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015072','Cerro Maggiore','Cerro Maggiore','','NO','C537',45.5934731,8.9506756,9.9372,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015074','Cesano Boscone','Cesano Boscone','','NO','C565',45.4473588,9.0939722,4.0145,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015076','Cesate','Cesate','','NO','C569',45.5950793,9.0755458,5.6706,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015077','Cinisello Balsamo','Cinisello Balsamo','','NO','C707',45.5584290,9.2137083,12.8137,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015078','Cisliano','Cisliano','','NO','C733',45.4460030,8.9860760,14.8193,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015081','Cologno Monzese','Cologno Monzese','','NO','C895',45.5296731,9.2744287,8.6598,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015082','Colturano','Colturano','','NO','C908',45.3810259,9.3477092,4.3001,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015085','Corbetta','Corbetta','','NO','C986',45.4677102,8.9218743,18.5218,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015086','Cormano','Cormano','','NO','D013',45.5431689,9.1728646,4.4852,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015087','Cornaredo','Cornaredo','','NO','D018',45.5019652,9.0258710,11.2473,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015093','Corsico','Corsico','','NO','D045',45.4318253,9.1085901,5.1564,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015096','Cuggiono','Cuggiono','','NO','D198',45.5042680,8.8166382,15.1309,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015097','Cusago','Cusago','','NO','D229',45.4464609,9.0334702,11.6815,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015098','Cusano Milanino','Cusano Milanino','','NO','D231',45.5513035,9.1814572,3.1317,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015099','Dairago','Dairago','','NO','D244',45.5690840,8.8652509,5.7711,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015101','Dresano','Dresano','','NO','D367',45.3722633,9.3607396,3.2471,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015103','Gaggiano','Gaggiano','','NO','D845',45.4063247,9.0342143,26.3598,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015105','Garbagnate Milanese','Garbagnate Milanese','','NO','D912',45.5763318,9.0792061,8.8990,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015106','Gessate','Gessate','','NO','D995',45.5538319,9.4358608,7.8256,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015108','Gorgonzola','Gorgonzola','','NO','E094',45.5308893,9.4045913,10.2563,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015110','Grezzago','Grezzago','','NO','E170',45.5915938,9.4943159,2.3245,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015112','Gudo Visconti','Gudo Visconti','','NO','E258',45.3730946,8.9990303,5.9409,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015113','Inveruno','Inveruno','','NO','E313',45.5134830,8.8540778,11.8782,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015114','Inzago','Inzago','','NO','E317',45.5409938,9.4818099,11.9716,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015115','Lacchiarella','Lacchiarella','','NO','E395',45.3221677,9.1367818,23.7863,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015116','Lainate','Lainate','','NO','E415',45.5714493,9.0267305,12.6457,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015118','Legnano','Legnano','','NO','E514',45.5953733,8.9188843,17.3045,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015122','Liscate','Liscate','','NO','E610',45.4808891,9.4090923,9.3317,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015125','Locate di Triulzi','Locate di Triulzi','','NO','E639',45.3576344,9.2216414,12.1832,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015130','Magenta','Magenta','','NO','E801',45.4660668,8.8835200,21.9942,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015131','Magnago','Magnago','','NO','E819',45.5797752,8.8011791,11.0968,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015134','Marcallo con Casone','Marcallo con Casone','','NO','E921',45.4843605,8.8672677,8.1736,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015136','Masate','Masate','','NO','F003',45.5680836,9.4641701,4.4505,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015139','Mediglia','Mediglia','','NO','F084',45.4011204,9.3235746,21.5995,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015140','Melegnano','Melegnano','','NO','F100',45.3575539,9.3243278,4.5550,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015142','Melzo','Melzo','','NO','F119',45.4980716,9.4244382,10.1511,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015144','Mesero','Mesero','','NO','F155',45.5003620,8.8547203,5.6985,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015146','Milano','Milano','','SI','F205',45.4666470,9.1906475,181.3260,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015150','Morimondo','Morimondo','','NO','D033',45.3518907,8.9544080,26.0933,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015151','Motta Visconti','Motta Visconti','','NO','F783',45.2885216,8.9927136,10.3949,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015154','Nerviano','Nerviano','','NO','F874',45.5543086,8.9701149,13.0284,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015155','Nosate','Nosate','','NO','F939',45.5523512,8.7261460,4.6700,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015157','Novate Milanese','Novate Milanese','','NO','F955',45.5325250,9.1349972,5.4080,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015158','Noviglio','Noviglio','','NO','F968',45.3577611,9.0709221,15.5588,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015159','Opera','Opera','','NO','G078',45.3772810,9.2117194,7.6139,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015164','Ossona','Ossona','','NO','G181',45.5062005,8.9004402,6.0229,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015165','Ozzero','Ozzero','','NO','G206',45.3664706,8.9244954,11.0889,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015166','Paderno Dugnano','Paderno Dugnano','','NO','G220',45.5685732,9.1660538,14.1138,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015167','Pantigliate','Pantigliate','','NO','G316',45.4392449,9.3526812,5.8740,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015168','Parabiago','Parabiago','','NO','G324',45.5569111,8.9512650,14.7147,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015169','Paullo','Paullo','','NO','G385',45.4171838,9.3981981,9.1262,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015170','Pero','Pero','','NO','C013',45.5105108,9.0890836,5.0409,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015171','Peschiera Borromeo','Peschiera Borromeo','','NO','G488',45.4317327,9.3114733,23.0443,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015172','Pessano con Bornago','Pessano con Bornago','','NO','G502',45.5494148,9.3876699,6.7359,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015173','Pieve Emanuele','Pieve Emanuele','','NO','G634',45.3532362,9.2002992,13.3623,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015175','Pioltello','Pioltello','','NO','G686',45.4969947,9.3292182,12.8646,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015176','Pogliano Milanese','Pogliano Milanese','','NO','G772',45.5371656,8.9918588,4.6856,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015177','Pozzo d\'Adda','Pozzo d\'Adda','','NO','G955',45.5772984,9.5008316,4.5583,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015178','Pozzuolo Martesana','Pozzuolo Martesana','','NO','G965',45.5134501,9.4529448,11.8779,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015179','Pregnana Milanese','Pregnana Milanese','','NO','H026',45.5168227,9.0090587,5.0524,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015181','Rescaldina','Rescaldina','','NO','H240',45.6159785,8.9501174,8.0746,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015182','Rho','Rho','','NO','H264',45.5289705,9.0401377,22.4249,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015183','Robecchetto con Induno','Robecchetto con Induno','','NO','H371',45.5339561,8.7653738,13.7435,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015184','Robecco sul Naviglio','Robecco sul Naviglio','','NO','H373',45.4353247,8.8883256,19.4343,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015185','Rodano','Rodano','','NO','H470',45.4744834,9.3519922,12.7435,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015188','Rosate','Rosate','','NO','H560',45.3491464,9.0170464,18.6704,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015189','Rozzano','Rozzano','','NO','H623',45.3812077,9.1527824,12.0623,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015191','San Colombano al Lambro','San Colombano al Lambro','','NO','H803',45.1813760,9.4895696,16.2509,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015192','San Donato Milanese','San Donato Milanese','','NO','H827',45.4166884,9.2654098,12.8906,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015194','San Giorgio su Legnano','San Giorgio su Legnano','','NO','H884',45.5766161,8.9163437,2.2372,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015195','San Giuliano Milanese','San Giuliano Milanese','','NO','H930',45.4001762,9.2849440,31.0261,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015200','Santo Stefano Ticino','Santo Stefano Ticino','','NO','I361',45.4877899,8.9193468,5.0175,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015201','San Vittore Olona','San Vittore Olona','','NO','I409',45.5868839,8.9433724,3.5887,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015202','San Zenone al Lambro','San Zenone al Lambro','','NO','I415',45.3277945,9.3565873,7.4262,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015204','Sedriano','Sedriano','','NO','I566',45.4880851,8.9712099,7.7873,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015205','Segrate','Segrate','','NO','I577',45.4895456,9.2923487,17.6534,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015206','Senago','Senago','','NO','I602',45.5752368,9.1174390,8.7536,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015209','Sesto San Giovanni','Sesto San Giovanni','','NO','I690',45.5336597,9.2366362,11.8809,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015210','Settala','Settala','','NO','I696',45.4544468,9.3867426,17.5597,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015211','Settimo Milanese','Settimo Milanese','','NO','I700',45.4803937,9.0555206,10.6704,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015213','Solaro','Solaro','','NO','I786',45.6167774,9.0795106,6.9168,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015219','Trezzano Rosa','Trezzano Rosa','','NO','L408',45.5831683,9.4889006,3.3892,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015220','Trezzano sul Naviglio','Trezzano sul Naviglio','','NO','L409',45.4179686,9.0690703,10.8581,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015221','Trezzo sull\'Adda','Trezzo sull\'Adda','','NO','L411',45.6100542,9.5199985,13.1701,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015222','Tribiano','Tribiano','','NO','L415',45.4141732,9.3769162,7.0934,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015224','Truccazzano','Truccazzano','','NO','L454',45.4835870,9.4689781,21.9939,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015226','Turbigo','Turbigo','','NO','L471',45.5282568,8.7347234,8.5756,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015229','Vanzago','Vanzago','','NO','L665',45.5264124,8.9977350,6.0670,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015230','Vaprio d\'Adda','Vaprio d\'Adda','','NO','L667',45.5755317,9.5324511,7.0814,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015236','Vernate','Vernate','','NO','L773',45.3165105,9.0592675,14.4070,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015237','Vignate','Vignate','','NO','L883',45.4960084,9.3767927,8.8280,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015242','Vimodrone','Vimodrone','','NO','M053',45.5143067,9.2870679,4.7030,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015243','Vittuone','Vittuone','','NO','M091',45.4878308,8.9533589,6.1818,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015244','Vizzolo Predabissi','Vizzolo Predabissi','','NO','M102',45.3602274,9.3461384,5.6604,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015247','Zibido San Giacomo','Zibido San Giacomo','','NO','M176',45.3602460,9.1059468,24.7003,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015248','Villa Cortese','Villa Cortese','','NO','L928',45.5654637,8.8856737,3.5919,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015249','Vanzaghello','Vanzaghello','','NO','L664',45.5778194,8.7855557,5.5169,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015250','Baranzate','Baranzate','','NO','A618',45.5275655,9.1138940,2.9697,'215');
INSERT INTO `gi_comuni` VALUES ('MI','015251','Vermezzo con Zelo','Vermezzo con Zelo','','NO','M424',45.3952378,8.9807668,10.8175,'215');
INSERT INTO `gi_comuni` VALUES ('BG','016001','Adrara San Martino','Adrara San Martino','','NO','A057',45.7003820,9.9494999,12.7997,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016002','Adrara San Rocco','Adrara San Rocco','','NO','A058',45.7138419,9.9588692,9.3968,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016003','Albano Sant\'Alessandro','Albano Sant\'Alessandro','','NO','A129',45.6860740,9.7680952,5.4795,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016004','Albino','Albino','','NO','A163',45.7605969,9.7969412,32.0311,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016005','Almè','Almè','','NO','A214',45.7400580,9.6175739,1.8604,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016006','Almenno San Bartolomeo','Almenno San Bartolomeo','','NO','A216',45.7456452,9.5800122,10.6401,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016007','Almenno San Salvatore','Almenno San Salvatore','','NO','A217',45.7506146,9.5865693,4.9043,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016008','Alzano Lombardo','Alzano Lombardo','','NO','A246',45.7315151,9.7278222,13.5078,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016009','Ambivere','Ambivere','','NO','A259',45.7200338,9.5489112,3.3865,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016010','Antegnate','Antegnate','','NO','A304',45.4844224,9.7898618,9.7152,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016011','Arcene','Arcene','','NO','A365',45.5758610,9.6135634,4.4855,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016012','Ardesio','Ardesio','','NO','A383',45.9381605,9.9296771,54.4065,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016013','Arzago d\'Adda','Arzago d\'Adda','','NO','A440',45.4814792,9.5615678,9.3657,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016014','Averara','Averara','','NO','A511',45.9880448,9.6306164,10.3949,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016015','Aviatico','Aviatico','','NO','A517',45.8000530,9.7706093,8.3780,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016016','Azzano San Paolo','Azzano San Paolo','','NO','A528',45.6603421,9.6756521,4.0548,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016017','Azzone','Azzone','','NO','A533',45.9785554,10.1127964,17.4717,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016018','Bagnatica','Bagnatica','','NO','A557',45.6636650,9.7814108,6.4746,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016019','Barbata','Barbata','','NO','A631',45.4761720,9.7763756,7.8414,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016020','Bariano','Bariano','','NO','A664',45.5135094,9.7052186,7.0452,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016021','Barzana','Barzana','','NO','A684',45.7339398,9.5674623,2.1780,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016022','Bedulita','Bedulita','','NO','A732',45.7915379,9.5512501,4.3132,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016023','Berbenno','Berbenno','','NO','A786',45.8135560,9.5698265,6.2423,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016024','Bergamo','Bergamo','','SI','A794',45.6947848,9.6677110,39.8637,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016025','Berzo San Fermo','Berzo San Fermo','','NO','A815',45.7181482,9.9030359,5.9499,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016026','Bianzano','Bianzano','','NO','A846',45.7733458,9.9178761,6.6631,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016027','Blello','Blello','','NO','A903',45.8338377,9.5750723,2.1638,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016028','Bolgare','Bolgare','','NO','A937',45.6338566,9.8173280,8.4544,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016029','Boltiere','Boltiere','','NO','A950',45.5997398,9.5782064,4.1142,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016030','Bonate Sopra','Bonate Sopra','','NO','A963',45.6828728,9.5583590,5.8953,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016031','Bonate Sotto','Bonate Sotto','','NO','A962',45.6665739,9.5613082,6.2387,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016032','Borgo di Terzo','Borgo di Terzo','','NO','B010',45.7202910,9.8926505,1.7995,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016033','Bossico','Bossico','','NO','B083',45.8272520,10.0444252,7.3173,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016034','Bottanuco','Bottanuco','','NO','B088',45.6407612,9.5036253,5.8419,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016035','Bracca','Bracca','','NO','B112',45.8237638,9.7081408,5.5662,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016036','Branzi','Branzi','','NO','B123',46.0053384,9.7601611,25.8029,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016037','Brembate','Brembate','','NO','B137',45.6039137,9.5552312,5.6119,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016038','Brembate di Sopra','Brembate di Sopra','','NO','B138',45.7180643,9.5797531,4.1173,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016040','Brignano Gera d\'Adda','Brignano Gera d\'Adda','','NO','B178',45.5432393,9.6482743,12.0931,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016041','Brumano','Brumano','','NO','B217',45.8533340,9.5010795,8.2002,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016042','Brusaporto','Brusaporto','','NO','B223',45.6708627,9.7613106,5.2284,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016043','Calcinate','Calcinate','','NO','B393',45.6180815,9.7998439,14.7743,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016044','Calcio','Calcio','','NO','B395',45.5070882,9.8485510,15.5425,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016046','Calusco d\'Adda','Calusco d\'Adda','','NO','B434',45.6886469,9.4704421,8.3358,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016047','Calvenzano','Calvenzano','','NO','B442',45.4948800,9.5993034,6.7514,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016048','Camerata Cornello','Camerata Cornello','','NO','B471',45.9010699,9.6547921,12.8896,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016049','Canonica d\'Adda','Canonica d\'Adda','','NO','B618',45.5752193,9.5389053,3.1997,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016050','Capizzone','Capizzone','','NO','B661',45.7857429,9.5667456,4.5756,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016051','Capriate San Gervasio','Capriate San Gervasio','','NO','B703',45.6089706,9.5282581,5.5203,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016052','Caprino Bergamasco','Caprino Bergamasco','','NO','B710',45.7474536,9.4818091,8.7922,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016053','Caravaggio','Caravaggio','','NO','B731',45.4971962,9.6441812,32.9826,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016055','Carobbio degli Angeli','Carobbio degli Angeli','','NO','B801',45.6685986,9.8312568,6.7764,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016056','Carona','Carona','','NO','B803',46.0218343,9.7855157,44.1750,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016057','Carvico','Carvico','','NO','B854',45.7049424,9.4798713,4.6580,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016058','Casazza','Casazza','','NO','B947',45.7512693,9.9067345,7.1323,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016059','Casirate d\'Adda','Casirate d\'Adda','','NO','B971',45.4939601,9.5681575,10.2080,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016060','Casnigo','Casnigo','','NO','B978',45.8148644,9.8662705,13.7296,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016061','Cassiglio','Cassiglio','','NO','C007',45.9668602,9.6135799,13.3719,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016062','Castelli Calepio','Castelli Calepio','','NO','C079',45.6413810,9.9022602,10.2329,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016063','Castel Rozzone','Castel Rozzone','','NO','C255',45.5554288,9.6237853,1.6940,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016064','Castione della Presolana','Castione della Presolana','','NO','C324',45.9087818,10.0371247,42.5658,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016065','Castro','Castro','','NO','C337',45.8038035,10.0669787,2.5917,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016066','Cavernago','Cavernago','','NO','C396',45.6251056,9.7614565,7.8693,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016067','Cazzano Sant\'Andrea','Cazzano Sant\'Andrea','','NO','C410',45.8112797,9.8825615,1.9690,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016068','Cenate Sopra','Cenate Sopra','','NO','C456',45.7117751,9.8242372,6.9886,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016069','Cenate Sotto','Cenate Sotto','','NO','C457',45.6973574,9.8225143,4.6680,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016070','Cene','Cene','','NO','C459',45.7794056,9.8257477,8.5819,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016071','Cerete','Cerete','','NO','C506',45.8672314,9.9944149,14.0068,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016072','Chignolo d\'Isola','Chignolo d\'Isola','','NO','C635',45.6670203,9.5269093,5.7582,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016073','Chiuduno','Chiuduno','','NO','C649',45.6508152,9.8487159,6.9540,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016074','Cisano Bergamasco','Cisano Bergamasco','','NO','C728',45.7393671,9.4786942,7.8867,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016075','Ciserano','Ciserano','','NO','C730',45.5868974,9.6014053,5.2562,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016076','Cividate al Piano','Cividate al Piano','','NO','C759',45.5550545,9.8322277,9.5419,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016077','Clusone','Clusone','','NO','C800',45.8910062,9.9483317,26.4917,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016078','Colere','Colere','','NO','C835',45.9739366,10.0832425,18.6084,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016079','Cologno al Serio','Cologno al Serio','','NO','C894',45.5807125,9.7061495,18.5430,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016080','Colzate','Colzate','','NO','C910',45.8159964,9.8561218,6.7309,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016081','Comun Nuovo','Comun Nuovo','','NO','C937',45.6228296,9.6625778,6.6520,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016082','Corna Imagna','Corna Imagna','','NO','D015',45.8316176,9.5426588,4.5454,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016083','Cortenuova','Cortenuova','','NO','D066',45.5372313,9.7873911,7.1832,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016084','Costa di Mezzate','Costa di Mezzate','','NO','D110',45.6628132,9.7942700,5.3799,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016085','Costa Valle Imagna','Costa Valle Imagna','','NO','D103',45.8031988,9.5038293,4.4311,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016086','Costa Volpino','Costa Volpino','','NO','D117',45.8272349,10.0974534,18.7357,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016087','Covo','Covo','','NO','D126',45.5003385,9.7699814,13.0089,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016088','Credaro','Credaro','','NO','D139',45.6613815,9.9285774,3.3076,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016089','Curno','Curno','','NO','D221',45.6916043,9.6112492,4.7542,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016090','Cusio','Cusio','','NO','D233',45.9910373,9.6027399,9.4503,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016091','Dalmine','Dalmine','','NO','D245',45.6479660,9.6011078,11.9222,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016092','Dossena','Dossena','','NO','D352',45.8782484,9.7017649,19.5844,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016093','Endine Gaiano','Endine Gaiano','','NO','D406',45.7909944,9.9787321,20.9407,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016094','Entratico','Entratico','','NO','D411',45.7054862,9.8746589,4.0676,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016096','Fara Gera d\'Adda','Fara Gera d\'Adda','','NO','D490',45.5530198,9.5316447,10.7595,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016097','Fara Olivana con Sola','Fara Olivana con Sola','','NO','D491',45.4943843,9.7481439,4.8797,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016098','Filago','Filago','','NO','D588',45.6372686,9.5548369,5.3418,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016099','Fino del Monte','Fino del Monte','','NO','D604',45.8904433,9.9921375,4.3861,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016100','Fiorano al Serio','Fiorano al Serio','','NO','D606',45.7995732,9.8416167,1.0488,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016101','Fontanella','Fontanella','','NO','D672',45.4697802,9.8018194,17.8533,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016102','Fonteno','Fonteno','','NO','D684',45.7584836,10.0194648,10.8528,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016103','Foppolo','Foppolo','','NO','D688',46.0439805,9.7550626,16.5699,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016104','Foresto Sparso','Foresto Sparso','','NO','D697',45.6945622,9.9092878,7.8478,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016105','Fornovo San Giovanni','Fornovo San Giovanni','','NO','D727',45.4972791,9.6774196,7.0115,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016106','Fuipiano Valle Imagna','Fuipiano Valle Imagna','','NO','D817',45.8571449,9.5250004,4.4803,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016107','Gandellino','Gandellino','','NO','D903',45.9900773,9.9463196,25.0127,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016108','Gandino','Gandino','','NO','D905',45.8116413,9.9031477,28.8991,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016109','Gandosso','Gandosso','','NO','D906',45.6617128,9.8900565,3.0904,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016110','Gaverina Terme','Gaverina Terme','','NO','D943',45.7581894,9.8858539,5.2813,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016111','Gazzaniga','Gazzaniga','','NO','D952',45.7966941,9.8365195,14.5850,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016113','Ghisalba','Ghisalba','','NO','E006',45.5937459,9.7538775,10.7144,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016114','Gorlago','Gorlago','','NO','E100',45.6769883,9.8291569,5.4260,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016115','Gorle','Gorle','','NO','E103',45.7038585,9.7210999,2.6426,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016116','Gorno','Gorno','','NO','E106',45.8618203,9.8431233,9.9617,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016117','Grassobbio','Grassobbio','','NO','E148',45.6567032,9.7244573,8.7009,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016118','Gromo','Gromo','','NO','E189',45.9690198,9.9289408,20.0718,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016119','Grone','Grone','','NO','E192',45.7271074,9.9116857,7.4546,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016120','Grumello del Monte','Grumello del Monte','','NO','E219',45.6355456,9.8729605,9.9725,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016121','Isola di Fondra','Isola di Fondra','','NO','E353',45.9807875,9.7474858,12.7911,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016122','Isso','Isso','','NO','E370',45.4760659,9.7573961,5.1639,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016123','Lallio','Lallio','','NO','E422',45.6683900,9.6284322,2.1067,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016124','Leffe','Leffe','','NO','E509',45.7997748,9.8850518,6.8694,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016125','Lenna','Lenna','','NO','E524',45.9439414,9.6783857,12.8840,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016126','Levate','Levate','','NO','E562',45.6253085,9.6244751,5.3920,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016127','Locatello','Locatello','','NO','E640',45.8353662,9.5348250,3.6985,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016128','Lovere','Lovere','','NO','E704',45.8195828,10.0791588,8.0301,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016129','Lurano','Lurano','','NO','E751',45.5661456,9.6408004,4.1649,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016130','Luzzana','Luzzana','','NO','E770',45.7166303,9.8819149,3.5215,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016131','Madone','Madone','','NO','E794',45.6500302,9.5475438,3.2217,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016132','Mapello','Mapello','','NO','E901',45.7091066,9.5473164,8.5905,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016133','Martinengo','Martinengo','','NO','E987',45.5704761,9.7675566,21.9609,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016134','Mezzoldo','Mezzoldo','','NO','F186',46.0125025,9.6648734,18.9987,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016135','Misano di Gera d\'Adda','Misano di Gera d\'Adda','','NO','F243',45.4696910,9.6206091,6.3156,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016136','Moio de\' Calvi','Moio de\' Calvi','','NO','F276',45.9517816,9.6989877,6.1547,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016137','Monasterolo del Castello','Monasterolo del Castello','','NO','F328',45.7631576,9.9300006,8.8269,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016139','Montello','Montello','','NO','F547',45.6724540,9.8038840,1.6572,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016140','Morengo','Morengo','','NO','F720',45.5339858,9.7042313,9.6489,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016141','Mornico al Serio','Mornico al Serio','','NO','F738',45.5916106,9.8085226,7.0558,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016142','Mozzanica','Mozzanica','','NO','F786',45.4766159,9.6924504,9.6300,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016143','Mozzo','Mozzo','','NO','F791',45.6995408,9.6075111,3.6635,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016144','Nembro','Nembro','','NO','F864',45.7433457,9.7594442,15.0486,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016145','Olmo al Brembo','Olmo al Brembo','','NO','G049',45.9698825,9.6484737,7.7333,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016146','Oltre il Colle','Oltre il Colle','','NO','G050',45.8926519,9.7680246,32.8097,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016147','Oltressenda Alta','Oltressenda Alta','','NO','G054',45.9145915,9.9448995,17.2865,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016148','Oneta','Oneta','','NO','G068',45.8711032,9.8187746,19.1577,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016149','Onore','Onore','','NO','G075',45.8905096,10.0112433,11.9787,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016150','Orio al Serio','Orio al Serio','','NO','G108',45.6760796,9.6925836,3.1967,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016151','Ornica','Ornica','','NO','G118',45.9886189,9.5791269,15.0822,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016152','Osio Sopra','Osio Sopra','','NO','G159',45.6301584,9.5915309,5.4038,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016153','Osio Sotto','Osio Sotto','','NO','G160',45.6164722,9.5916600,7.5952,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016154','Pagazzano','Pagazzano','','NO','G233',45.5334444,9.6716741,5.2982,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016155','Paladina','Paladina','','NO','G249',45.7277779,9.6045724,2.0772,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016156','Palazzago','Palazzago','','NO','G259',45.7522626,9.5348237,13.7419,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016157','Palosco','Palosco','','NO','G295',45.5842700,9.8361439,10.7249,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016158','Parre','Parre','','NO','G346',45.8771231,9.8919147,22.5062,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016159','Parzanica','Parzanica','','NO','G350',45.7374535,10.0346438,9.9573,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016160','Pedrengo','Pedrengo','','NO','G412',45.6986987,9.7356764,3.3811,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016161','Peia','Peia','','NO','G418',45.8008606,9.8987541,4.4257,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016162','Pianico','Pianico','','NO','G564',45.8109540,10.0437846,3.0342,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016163','Piario','Piario','','NO','G574',45.8963125,9.9241055,1.4529,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016164','Piazza Brembana','Piazza Brembana','','NO','G579',45.9446636,9.6768602,6.9640,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016165','Piazzatorre','Piazzatorre','','NO','G583',45.9891306,9.6825779,24.3421,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016166','Piazzolo','Piazzolo','','NO','G588',45.9799219,9.6719050,4.2065,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016167','Pognano','Pognano','','NO','G774',45.5850847,9.6437330,3.1431,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016168','Ponte Nossa','Ponte Nossa','','NO','F941',45.8666265,9.8835389,5.3627,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016169','Ponteranica','Ponteranica','','NO','G853',45.7308027,9.6548720,8.4030,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016170','Ponte San Pietro','Ponte San Pietro','','NO','G856',45.6979619,9.5882594,4.5719,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016171','Pontida','Pontida','','NO','G864',45.7324732,9.5013752,10.3946,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016172','Pontirolo Nuovo','Pontirolo Nuovo','','NO','G867',45.5687976,9.5697451,10.9815,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016173','Pradalunga','Pradalunga','','NO','G968',45.7487468,9.7868722,8.3619,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016174','Predore','Predore','','NO','H020',45.6806847,10.0194781,10.8860,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016175','Premolo','Premolo','','NO','H036',45.8686443,9.8753819,17.7777,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016176','Presezzo','Presezzo','','NO','H046',45.6916053,9.5667220,2.4689,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016177','Pumenengo','Pumenengo','','NO','H091',45.4806137,9.8713882,9.8394,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016178','Ranica','Ranica','','NO','H176',45.7270259,9.7156567,4.2208,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016179','Ranzanico','Ranzanico','','NO','H177',45.7893956,9.9356220,7.0219,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016180','Riva di Solto','Riva di Solto','','NO','H331',45.7739128,10.0378440,8.4964,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016182','Rogno','Rogno','','NO','H492',45.8577537,10.1335115,15.9102,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016183','Romano di Lombardia','Romano di Lombardia','','NO','H509',45.5195868,9.7542499,19.7680,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016184','Roncobello','Roncobello','','NO','H535',45.9556901,9.7488581,25.5578,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016185','Roncola','Roncola','','NO','H544',45.7681634,9.5612973,5.0126,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016186','Rota d\'Imagna','Rota d\'Imagna','','NO','H584',45.8317208,9.5109635,6.0575,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016187','Rovetta','Rovetta','','NO','H615',45.8915461,9.9873760,24.3842,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016188','San Giovanni Bianco','San Giovanni Bianco','','NO','H910',45.8745504,9.6518373,31.0356,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016189','San Paolo d\'Argon','San Paolo d\'Argon','','NO','B310',45.6901509,9.8036536,5.2901,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016190','San Pellegrino Terme','San Pellegrino Terme','','NO','I079',45.8385418,9.6648865,22.9209,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016191','Santa Brigida','Santa Brigida','','NO','I168',45.9829906,9.6256898,14.1666,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016193','Sarnico','Sarnico','','NO','I437',45.6678878,9.9583829,6.9565,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016194','Scanzorosciate','Scanzorosciate','','NO','I506',45.7110217,9.7387149,10.7903,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016195','Schilpario','Schilpario','','NO','I530',46.0096007,10.1540652,63.5407,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016196','Sedrina','Sedrina','','NO','I567',45.7816724,9.6236803,5.7950,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016197','Selvino','Selvino','','NO','I597',45.7811576,9.7523561,6.5886,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016198','Seriate','Seriate','','NO','I628',45.6845442,9.7178795,12.4223,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016199','Serina','Serina','','NO','I629',45.8714427,9.7301184,26.8593,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016200','Solto Collina','Solto Collina','','NO','I812',45.7823449,10.0247422,11.5048,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016201','Songavazzo','Songavazzo','','NO','I830',45.8800713,9.9895638,12.5598,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016202','Sorisole','Sorisole','','NO','I858',45.7447403,9.6590676,12.4514,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016203','Sotto il Monte Giovanni XXIII','Sotto il Monte Giovanni XXIII','','NO','I869',45.7056517,9.4989346,4.9108,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016204','Sovere','Sovere','','NO','I873',45.8233068,10.0250778,17.8959,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016205','Spinone al Lago','Spinone al Lago','','NO','I916',45.7640575,9.9191987,2.0151,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016206','Spirano','Spirano','','NO','I919',45.5822553,9.6709517,9.3273,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016207','Stezzano','Stezzano','','NO','I951',45.6512926,9.6523936,9.2564,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016208','Strozza','Strozza','','NO','I986',45.7748377,9.5762993,3.8884,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016209','Suisio','Suisio','','NO','I997',45.6576741,9.5023475,4.3547,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016210','Taleggio','Taleggio','','NO','L037',45.8923524,9.5667810,46.9057,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016211','Tavernola Bergamasca','Tavernola Bergamasca','','NO','L073',45.7102457,10.0476590,11.0399,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016212','Telgate','Telgate','','NO','L087',45.6272642,9.8542784,8.3763,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016213','Terno d\'Isola','Terno d\'Isola','','NO','L118',45.6836057,9.5314937,4.1202,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016214','Torre Boldone','Torre Boldone','','NO','L251',45.7161130,9.7077411,3.4293,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016215','Torre de\' Busi','Torre de\' Busi','','NO','L257',45.7745741,9.4802118,8.9191,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016216','Torre de\' Roveri','Torre de\' Roveri','','NO','L265',45.7003688,9.7714321,2.6608,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016217','Torre Pallavicina','Torre Pallavicina','','NO','L276',45.4407556,9.8617328,10.8868,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016218','Trescore Balneario','Trescore Balneario','','NO','L388',45.6937433,9.8425070,13.6399,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016219','Treviglio','Treviglio','','NO','L400',45.5217529,9.5927085,32.6256,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016220','Treviolo','Treviolo','','NO','L404',45.6716315,9.6111601,8.5098,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016221','Ubiale Clanezzo','Ubiale Clanezzo','','NO','C789',45.7819384,9.6159938,7.4671,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016222','Urgnano','Urgnano','','NO','L502',45.5987508,9.6912546,15.0515,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016223','Valbondione','Valbondione','','NO','L544',46.0367916,10.0122590,97.0607,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016224','Valbrembo','Valbrembo','','NO','L545',45.7134795,9.6081276,3.7776,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016225','Valgoglio','Valgoglio','','NO','L579',45.9752703,9.9135900,32.1402,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016226','Valleve','Valleve','','NO','L623',46.0268540,9.7437043,14.5664,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016227','Valnegra','Valnegra','','NO','L642',45.9484496,9.6923065,2.3326,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016229','Valtorta','Valtorta','','NO','L655',45.9777889,9.5351187,30.7488,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016230','Vedeseta','Vedeseta','','NO','L707',45.8907892,9.5403270,19.4188,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016232','Verdellino','Verdellino','','NO','L752',45.6028253,9.6150647,3.8272,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016233','Verdello','Verdello','','NO','L753',45.6077281,9.6287266,7.0791,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016234','Vertova','Vertova','','NO','L795',45.8077724,9.8519012,15.4556,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016235','Viadanica','Viadanica','','NO','L827',45.6854537,9.9658508,5.3065,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016236','Vigano San Martino','Vigano San Martino','','NO','L865',45.7257652,9.8937098,3.7059,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016237','Vigolo','Vigolo','','NO','L894',45.7162340,10.0218324,12.4450,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016238','Villa d\'Adda','Villa d\'Adda','','NO','L929',45.7128637,9.4653922,6.0744,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016239','Villa d\'Almè','Villa d\'Almè','','NO','A215',45.7463713,9.6179229,6.5174,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016240','Villa di Serio','Villa di Serio','','NO','L936',45.7214213,9.7356468,4.5273,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016241','Villa d\'Ogna','Villa d\'Ogna','','NO','L938',45.9075354,9.9304188,4.9595,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016242','Villongo','Villongo','','NO','M045',45.6732170,9.9341348,5.9371,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016243','Vilminore di Scalve','Vilminore di Scalve','','NO','M050',45.9969626,10.0912866,40.7246,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016244','Zandobbio','Zandobbio','','NO','M144',45.6881416,9.8525025,6.5171,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016245','Zanica','Zanica','','NO','M147',45.6431644,9.6832493,15.0929,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016246','Zogno','Zogno','','NO','M184',45.7939562,9.6656738,35.2755,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016247','Costa Serina','Costa Serina','','NO','D111',45.8310088,9.7401137,12.0310,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016248','Algua','Algua','','NO','A193',45.8258691,9.7226501,8.4820,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016249','Cornalba','Cornalba','','NO','D016',45.8502518,9.7446421,9.2996,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016250','Medolago','Medolago','','NO','F085',45.6710400,9.4940997,4.0054,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016251','Solza','Solza','','NO','I813',45.6773415,9.4887409,1.2340,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016252','Sant\'Omobono Terme','Sant\'Omobono Terme','','NO','M333',45.8117420,9.5355050,16.1757,'016');
INSERT INTO `gi_comuni` VALUES ('BG','016253','Val Brembilla','Val Brembilla','','NO','M334',45.8193240,9.5977441,31.2691,'016');
INSERT INTO `gi_comuni` VALUES ('BS','017001','Acquafredda','Acquafredda','','NO','A034',45.3071860,10.4119388,9.5260,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017002','Adro','Adro','','NO','A060',45.6250126,9.9565514,14.2472,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017003','Agnosine','Agnosine','','NO','A082',45.6501993,10.3529579,13.3341,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017004','Alfianello','Alfianello','','NO','A188',45.2677464,10.1494122,13.8475,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017005','Anfo','Anfo','','NO','A288',45.7644999,10.4933493,23.9328,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017006','Angolo Terme','Angolo Terme','','NO','A293',45.8910976,10.1483104,30.7166,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017007','Artogne','Artogne','','NO','A451',45.8496727,10.1655859,20.9384,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017008','Azzano Mella','Azzano Mella','','NO','A529',45.4547470,10.1157523,10.3622,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017009','Bagnolo Mella','Bagnolo Mella','','NO','A569',45.4293088,10.1789849,31.3547,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017010','Bagolino','Bagolino','','NO','A578',45.8217604,10.4680093,108.8360,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017011','Barbariga','Barbariga','','NO','A630',45.4053093,10.0548630,11.4041,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017012','Barghe','Barghe','','NO','A661',45.6796354,10.4084566,5.4563,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017013','Bassano Bresciano','Bassano Bresciano','','NO','A702',45.3260988,10.1288404,9.4165,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017014','Bedizzole','Bedizzole','','NO','A729',45.5111483,10.4206714,26.3281,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017015','Berlingo','Berlingo','','NO','A799',45.5029981,10.0394514,4.6530,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017016','Berzo Demo','Berzo Demo','','NO','A816',46.0929891,10.3363687,15.3629,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017017','Berzo Inferiore','Berzo Inferiore','','NO','A817',45.9323282,10.2786854,21.9660,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017018','Bienno','Bienno','','NO','A861',45.9355722,10.2954559,46.7495,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017019','Bione','Bione','','NO','A878',45.6734280,10.3398077,17.3119,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017020','Borgo San Giacomo','Borgo San Giacomo','','NO','B035',45.3501934,9.9679357,29.3874,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017021','Borgosatollo','Borgosatollo','','NO','B040',45.4762439,10.2396932,8.3319,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017022','Borno','Borno','','NO','B054',45.9467421,10.2058153,30.2796,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017023','Botticino','Botticino','','NO','B091',45.5432965,10.3232947,18.3315,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017024','Bovegno','Bovegno','','NO','B100',45.7934155,10.2734321,48.0393,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017025','Bovezzo','Bovezzo','','NO','B102',45.5913105,10.2430966,6.4349,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017026','Brandico','Brandico','','NO','B120',45.4542532,10.0535159,8.3182,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017027','Braone','Braone','','NO','B124',45.9901985,10.3428499,13.3147,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017028','Breno','Breno','','NO','B149',45.9571191,10.3022274,59.8983,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017029','Brescia','Brescia','','SI','B157',45.5399355,10.2191130,90.4011,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017030','Brione','Brione','','NO','B184',45.6394179,10.1422472,6.8058,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017031','Caino','Caino','','NO','B365',45.6123377,10.3161652,17.5488,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017032','Calcinato','Calcinato','','NO','B394',45.4565618,10.4178648,33.2049,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017033','Calvagese della Riviera','Calvagese della Riviera','','NO','B436',45.5413249,10.4462878,11.7827,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017034','Calvisano','Calvisano','','NO','B450',45.3488539,10.3426878,44.6112,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017035','Capo di Ponte','Capo di Ponte','','NO','B664',46.0314070,10.3441231,18.1373,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017036','Capovalle','Capovalle','','NO','B676',45.7543779,10.5442505,23.0733,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017037','Capriano del Colle','Capriano del Colle','','NO','B698',45.4552322,10.1286115,13.7604,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017038','Capriolo','Capriolo','','NO','B711',45.6370223,9.9338573,10.5780,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017039','Carpenedolo','Carpenedolo','','NO','B817',45.3623087,10.4298698,30.1016,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017040','Castegnato','Castegnato','','NO','C055',45.5643534,10.1163358,9.2273,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017041','Castelcovati','Castelcovati','','NO','C072',45.5043802,9.9447764,6.3239,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017042','Castel Mella','Castel Mella','','NO','C208',45.4976407,10.1417911,7.5858,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017043','Castenedolo','Castenedolo','','NO','C293',45.4707471,10.3006755,26.1071,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017044','Casto','Casto','','NO','C330',45.6956432,10.3178839,21.3119,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017045','Castrezzato','Castrezzato','','NO','C332',45.5120517,9.9791254,13.7119,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017046','Cazzago San Martino','Cazzago San Martino','','NO','C408',45.5805552,10.0261924,22.2028,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017047','Cedegolo','Cedegolo','','NO','C417',46.0773599,10.3497520,11.1050,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017048','Cellatica','Cellatica','','NO','C439',45.5840491,10.1800596,6.6750,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017049','Cerveno','Cerveno','','NO','C549',46.0036756,10.3244421,21.2855,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017050','Ceto','Ceto','','NO','C585',46.0031593,10.3509657,31.9035,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017051','Cevo','Cevo','','NO','C591',46.0807156,10.3674988,35.4150,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017052','Chiari','Chiari','','NO','C618',45.5372504,9.9315476,37.6874,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017053','Cigole','Cigole','','NO','C685',45.3093401,10.1929087,10.0867,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017054','Cimbergo','Cimbergo','','NO','C691',46.0235074,10.3647134,24.8492,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017055','Cividate Camuno','Cividate Camuno','','NO','C760',45.9450662,10.2782339,3.2641,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017056','Coccaglio','Coccaglio','','NO','C806',45.5621542,9.9778315,12.2794,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017057','Collebeato','Collebeato','','NO','C850',45.5853557,10.2151469,5.4718,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017058','Collio','Collio','','NO','C883',45.8101286,10.3341741,53.5026,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017059','Cologne','Cologne','','NO','C893',45.5849247,9.9434083,14.0012,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017060','Comezzano-Cizzago','Comezzano-Cizzago','','NO','C925',45.4720000,9.9526504,14.9972,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017061','Concesio','Concesio','','NO','C948',45.6070377,10.2162942,18.9396,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017062','Corte Franca','Corte Franca','','NO','D058',45.6372182,10.0069109,14.2349,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017063','Corteno Golgi','Corteno Golgi','','NO','D064',46.1667087,10.2432153,82.9269,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017064','Corzano','Corzano','','NO','D082',45.4440485,10.0075153,12.3822,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017065','Darfo Boario Terme','Darfo Boario Terme','','NO','D251',45.8837180,10.1808586,35.9243,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017066','Dello','Dello','','NO','D270',45.4178472,10.0751691,23.3507,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017067','Desenzano del Garda','Desenzano del Garda','','NO','D284',45.4693778,10.5396558,59.3758,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017068','Edolo','Edolo','','NO','D391',46.1809944,10.3338947,89.3178,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017069','Erbusco','Erbusco','','NO','D421',45.5986115,9.9722795,15.8842,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017070','Esine','Esine','','NO','D434',45.9244338,10.2566614,30.3272,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017071','Fiesse','Fiesse','','NO','D576',45.2332185,10.3192468,15.9025,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017072','Flero','Flero','','NO','D634',45.4840472,10.1745318,9.6472,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017073','Gambara','Gambara','','NO','D891',45.2544007,10.2978763,31.7518,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017074','Gardone Riviera','Gardone Riviera','','NO','D917',45.6220529,10.5618258,21.4656,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017075','Gardone Val Trompia','Gardone Val Trompia','','NO','D918',45.6888378,10.1830598,26.9499,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017076','Gargnano','Gargnano','','NO','D924',45.6882573,10.6637928,76.4145,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017077','Gavardo','Gavardo','','NO','D940',45.5845282,10.4368428,29.6782,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017078','Ghedi','Ghedi','','NO','D999',45.4015634,10.2770851,60.7646,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017079','Gianico','Gianico','','NO','E010',45.8645037,10.1815743,13.2793,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017080','Gottolengo','Gottolengo','','NO','E116',45.2907968,10.2696244,29.3052,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017081','Gussago','Gussago','','NO','E271',45.5924215,10.1531673,25.0930,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017082','Idro','Idro','','NO','E280',45.7354892,10.4731274,22.6792,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017083','Incudine','Incudine','','NO','E297',46.2214469,10.3585194,19.4397,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017084','Irma','Irma','','NO','E325',45.7711723,10.2839890,4.9706,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017085','Iseo','Iseo','','NO','E333',45.6599897,10.0484328,28.3072,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017086','Isorella','Isorella','','NO','E364',45.3084765,10.3218964,15.2858,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017087','Lavenone','Lavenone','','NO','E497',45.7389808,10.4380588,31.6438,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017088','Leno','Leno','','NO','E526',45.3664861,10.2191331,58.7070,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017089','Limone sul Garda','Limone sul Garda','','NO','E596',45.8109912,10.7909943,23.1104,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017090','Lodrino','Lodrino','','NO','E652',45.7179216,10.2790435,16.0908,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017091','Lograto','Lograto','','NO','E654',45.4830629,10.0572876,12.5781,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017092','Lonato del Garda','Lonato del Garda','','NO','M312',45.4613709,10.4844539,68.4985,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017093','Longhena','Longhena','','NO','E673',45.4377985,10.0578227,3.6424,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017094','Losine','Losine','','NO','E698',45.9843133,10.3179770,6.3282,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017095','Lozio','Lozio','','NO','E706',45.9861715,10.2601602,24.0027,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017096','Lumezzane','Lumezzane','','NO','E738',45.6501150,10.2617794,31.4449,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017097','Maclodio','Maclodio','','NO','E787',45.4769720,10.0429126,4.9530,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017098','Magasa','Magasa','','NO','E800',45.7819127,10.6166523,19.3067,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017099','Mairano','Mairano','','NO','E841',45.4502364,10.0762756,11.3919,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017100','Malegno','Malegno','','NO','E851',45.9505807,10.2733562,7.2138,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017101','Malonno','Malonno','','NO','E865',46.1200015,10.3159650,31.3837,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017102','Manerba del Garda','Manerba del Garda','','NO','E883',45.5496366,10.5512734,36.7113,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017103','Manerbio','Manerbio','','NO','E884',45.3547209,10.1388462,27.3045,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017104','Marcheno','Marcheno','','NO','E928',45.7060585,10.2141983,22.3273,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017105','Marmentino','Marmentino','','NO','E961',45.7557412,10.2874015,17.9770,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017106','Marone','Marone','','NO','E967',45.7378839,10.0925356,23.8825,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017107','Mazzano','Mazzano','','NO','F063',45.5044255,10.3572029,15.7525,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017108','Milzano','Milzano','','NO','F216',45.2739986,10.2016241,8.4938,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017109','Moniga del Garda','Moniga del Garda','','NO','F373',45.5289937,10.5376348,14.6371,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017110','Monno','Monno','','NO','F375',46.2115647,10.3397494,31.0098,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017111','Monte Isola','Monte Isola','','NO','F532',45.7153982,10.0797289,12.6064,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017112','Monticelli Brusati','Monticelli Brusati','','NO','F672',45.6322197,10.0995671,10.9074,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017113','Montichiari','Montichiari','','NO','F471',45.4117117,10.3942599,81.5653,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017114','Montirone','Montirone','','NO','F680',45.4437620,10.2311405,10.5279,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017115','Mura','Mura','','NO','F806',45.7137982,10.3432329,12.6600,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017116','Muscoline','Muscoline','','NO','F820',45.5627124,10.4606301,10.0381,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017117','Nave','Nave','','NO','F851',45.5856345,10.2779675,27.0450,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017118','Niardo','Niardo','','NO','F884',45.9784661,10.3348391,22.2308,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017119','Nuvolento','Nuvolento','','NO','F989',45.5458239,10.3846898,7.3270,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017120','Nuvolera','Nuvolera','','NO','F990',45.5330921,10.3703046,13.3438,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017121','Odolo','Odolo','','NO','G001',45.6485487,10.3882225,6.4388,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017122','Offlaga','Offlaga','','NO','G006',45.3866390,10.1162472,23.2015,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017123','Ome','Ome','','NO','G061',45.6243746,10.1238917,9.6886,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017124','Ono San Pietro','Ono San Pietro','','NO','G074',46.0169579,10.3269445,13.9654,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017125','Orzinuovi','Orzinuovi','','NO','G149',45.4023494,9.9241354,47.9842,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017126','Orzivecchi','Orzivecchi','','NO','G150',45.4206936,9.9616519,9.9083,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017127','Ospitaletto','Ospitaletto','','NO','G170',45.5561764,10.0742060,9.4839,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017128','Ossimo','Ossimo','','NO','G179',45.9462310,10.2292973,14.6509,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017129','Padenghe sul Garda','Padenghe sul Garda','','NO','G213',45.5082920,10.5077620,26.8908,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017130','Paderno Franciacorta','Paderno Franciacorta','','NO','G217',45.5894019,10.0774217,5.8416,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017131','Paisco Loveno','Paisco Loveno','','NO','G247',46.0794233,10.2958776,36.0007,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017132','Paitone','Paitone','','NO','G248',45.5533305,10.4011361,8.2140,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017133','Palazzolo sull\'Oglio','Palazzolo sull\'Oglio','','NO','G264',45.5990946,9.8851433,23.4018,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017134','Paratico','Paratico','','NO','G327',45.6597686,9.9547340,6.0996,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017135','Paspardo','Paspardo','','NO','G354',46.0309756,10.3704382,11.3506,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017136','Passirano','Passirano','','NO','G361',45.5981153,10.0644549,13.3192,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017137','Pavone del Mella','Pavone del Mella','','NO','G391',45.3023719,10.2055078,11.7252,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017138','San Paolo','San Paolo','','NO','G407',45.3712552,10.0245999,18.5200,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017139','Pertica Alta','Pertica Alta','','NO','G474',45.7428694,10.3437633,21.1247,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017140','Pertica Bassa','Pertica Bassa','','NO','G475',45.7520223,10.3730915,30.2723,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017141','Pezzaze','Pezzaze','','NO','G529',45.7744881,10.2381134,21.6850,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017142','Pian Camuno','Pian Camuno','','NO','G546',45.8425186,10.1555157,10.6930,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017143','Pisogne','Pisogne','','NO','G710',45.8048692,10.1089311,49.2456,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017144','Polaveno','Polaveno','','NO','G779',45.6608642,10.1244980,9.1290,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017145','Polpenazze del Garda','Polpenazze del Garda','','NO','G801',45.5522550,10.5082857,9.0029,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017146','Pompiano','Pompiano','','NO','G815',45.4315338,9.9869124,15.2540,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017147','Poncarale','Poncarale','','NO','G818',45.4605552,10.1739530,12.7979,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017148','Ponte di Legno','Ponte di Legno','','NO','G844',46.2595522,10.5074528,100.0992,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017149','Pontevico','Pontevico','','NO','G859',45.2719637,10.0859243,29.1086,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017150','Pontoglio','Pontoglio','','NO','G869',45.5695840,9.8521546,11.0717,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017151','Pozzolengo','Pozzolengo','','NO','G959',45.4034404,10.6293094,20.9976,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017152','Pralboino','Pralboino','','NO','G977',45.2681234,10.2150513,17.3038,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017153','Preseglie','Preseglie','','NO','H043',45.6666942,10.3944075,11.7086,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017155','Prevalle','Prevalle','','NO','H055',45.5431497,10.4205727,9.7871,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017156','Provaglio d\'Iseo','Provaglio d\'Iseo','','NO','H078',45.6360506,10.0442959,16.1905,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017157','Provaglio Val Sabbia','Provaglio Val Sabbia','','NO','H077',45.6869476,10.4373461,14.9498,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017158','Puegnago del Garda','Puegnago del Garda','','NO','H086',45.5686735,10.5113012,11.0849,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017159','Quinzano d\'Oglio','Quinzano d\'Oglio','','NO','H140',45.3121155,10.0091965,21.0640,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017160','Remedello','Remedello','','NO','H230',45.2787819,10.3721418,21.5427,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017161','Rezzato','Rezzato','','NO','H256',45.5139575,10.3169790,18.4259,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017162','Roccafranca','Roccafranca','','NO','H410',45.4641808,9.9119967,19.3527,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017163','Rodengo Saiano','Rodengo Saiano','','NO','H477',45.5975455,10.1091908,12.7972,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017164','Roè Volciano','Roè Volciano','','NO','H484',45.6224962,10.4955111,5.6887,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017165','Roncadelle','Roncadelle','','NO','H525',45.5273198,10.1494760,9.2857,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017166','Rovato','Rovato','','NO','H598',45.5682589,9.9970479,26.1676,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017167','Rudiano','Rudiano','','NO','H630',45.4882556,9.8838187,9.9935,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017168','Sabbio Chiese','Sabbio Chiese','','NO','H650',45.6573346,10.4185505,18.3450,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017169','Sale Marasino','Sale Marasino','','NO','H699',45.7141008,10.1116738,16.5273,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017170','Salò','Salò','','NO','H717',45.6071518,10.5285756,27.4670,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017171','San Felice del Benaco','San Felice del Benaco','','NO','H838',45.5844529,10.5479635,20.2695,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017172','San Gervasio Bresciano','San Gervasio Bresciano','','NO','H865',45.3059870,10.1497600,10.5930,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017173','San Zeno Naviglio','San Zeno Naviglio','','NO','I412',45.4910658,10.2151464,6.5035,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017174','Sarezzo','Sarezzo','','NO','I433',45.6538249,10.2029746,17.9885,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017175','Saviore dell\'Adamello','Saviore dell\'Adamello','','NO','I476',46.0795850,10.3987000,84.1662,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017176','Sellero','Sellero','','NO','I588',46.0565903,10.3449142,14.4226,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017177','Seniga','Seniga','','NO','I607',45.2434505,10.1775033,12.9335,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017178','Serle','Serle','','NO','I631',45.5616107,10.3682557,18.2540,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017179','Sirmione','Sirmione','','NO','I633',45.4632321,10.6090768,26.3269,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017180','Soiano del Lago','Soiano del Lago','','NO','I782',45.5366512,10.5137146,5.8560,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017181','Sonico','Sonico','','NO','I831',46.1617161,10.3541169,60.8670,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017182','Sulzano','Sulzano','','NO','L002',45.6903567,10.1000523,10.5396,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017183','Tavernole sul Mella','Tavernole sul Mella','','NO','C698',45.7480647,10.2402811,19.9353,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017184','Temù','Temù','','NO','L094',46.2488479,10.4699223,43.4023,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017185','Tignale','Tignale','','NO','L169',45.7384709,10.7203397,45.6965,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017186','Torbole Casaglia','Torbole Casaglia','','NO','L210',45.5095851,10.1080445,13.5536,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017187','Toscolano-Maderno','Toscolano-Maderno','','NO','L312',45.6416628,10.6091161,58.1586,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017188','Travagliato','Travagliato','','NO','L339',45.5234030,10.0802571,17.5267,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017189','Tremosine sul Garda','Tremosine sul Garda','','NO','L372',45.7714490,10.7600039,72.4014,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017190','Trenzano','Trenzano','','NO','L380',45.4761776,10.0126019,19.9625,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017191','Treviso Bresciano','Treviso Bresciano','','NO','L406',45.7122342,10.4633966,17.9701,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017192','Urago d\'Oglio','Urago d\'Oglio','','NO','L494',45.5143752,9.8682254,10.5796,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017193','Vallio Terme','Vallio Terme','','NO','L626',45.6102010,10.3907623,14.9941,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017194','Valvestino','Valvestino','','NO','L468',45.7619014,10.5948987,31.2872,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017195','Verolanuova','Verolanuova','','NO','L777',45.3265005,10.0747561,25.9661,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017196','Verolavecchia','Verolavecchia','','NO','L778',45.3302495,10.0529847,21.3682,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017197','Vestone','Vestone','','NO','L812',45.7099674,10.4043130,13.0389,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017198','Vezza d\'Oglio','Vezza d\'Oglio','','NO','L816',46.2401504,10.4001171,54.1228,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017199','Villa Carcina','Villa Carcina','','NO','L919',45.6324233,10.1937271,14.1118,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017200','Villachiara','Villachiara','','NO','L923',45.3569530,9.9301220,17.3184,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017201','Villanuova sul Clisi','Villanuova sul Clisi','','NO','L995',45.6012158,10.4541431,9.0147,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017202','Vione','Vione','','NO','M065',46.2488445,10.4477285,35.2785,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017203','Visano','Visano','','NO','M070',45.3167525,10.3689184,11.3944,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017204','Vobarno','Vobarno','','NO','M104',45.6471011,10.4958182,53.2857,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017205','Zone','Zone','','NO','M188',45.7623662,10.1171562,19.7686,'017');
INSERT INTO `gi_comuni` VALUES ('BS','017206','Piancogno','Piancogno','','NO','G549',45.9188303,10.2204948,14.2403,'017');
INSERT INTO `gi_comuni` VALUES ('PV','018001','Alagna','Alagna','','NO','A118',45.1668971,8.8916119,8.5275,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018003','Albonese','Albonese','','NO','A171',45.2945117,8.7070475,4.3047,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018004','Albuzzano','Albuzzano','','NO','A175',45.1863424,9.2751984,15.4397,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018005','Arena Po','Arena Po','','NO','A387',45.0964010,9.3628428,22.3574,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018006','Badia Pavese','Badia Pavese','','NO','A538',45.1209766,9.4673729,4.9576,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018007','Bagnaria','Bagnaria','','NO','A550',44.8256663,9.1231611,17.1156,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018008','Barbianello','Barbianello','','NO','A634',45.0753687,9.2066912,11.7284,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018009','Bascapè','Bascapè','','NO','A690',45.3072344,9.3131165,13.4730,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018011','Bastida Pancarana','Bastida Pancarana','','NO','A712',45.0850814,9.0831710,12.7250,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018012','Battuda','Battuda','','NO','A718',45.2735639,9.0774142,7.2084,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018013','Belgioioso','Belgioioso','','NO','A741',45.1621685,9.3147908,24.8096,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018014','Bereguardo','Bereguardo','','NO','A792',45.2576372,9.0258435,17.5287,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018015','Borgarello','Borgarello','','NO','A989',45.2399925,9.1426868,5.0435,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018016','Borgo Priolo','Borgo Priolo','','NO','B028',44.9666969,9.1481125,28.8628,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018017','Borgoratto Mormorolo','Borgoratto Mormorolo','','NO','B030',44.9310766,9.1926310,16.3063,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018018','Borgo San Siro','Borgo San Siro','','NO','B038',45.2348932,8.9131581,17.8348,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018019','Bornasco','Bornasco','','NO','B051',45.2675986,9.2191172,13.0353,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018020','Bosnasco','Bosnasco','','NO','B082',45.0645831,9.3583575,4.8266,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018021','Brallo di Pregola','Brallo di Pregola','','NO','B117',44.7380280,9.2809309,46.2376,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018022','Breme','Breme','','NO','B142',45.1266490,8.6210837,18.9689,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018023','Bressana Bottarone','Bressana Bottarone','','NO','B159',45.0770873,9.1340140,12.6348,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018024','Broni','Broni','','NO','B201',45.0619647,9.2614460,20.5205,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018025','Calvignano','Calvignano','','NO','B447',44.9826359,9.1695338,6.8632,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018026','Campospinoso Albaredo','Campospinoso Albaredo','','NO','B567',45.1020375,9.2480875,12.4565,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018027','Candia Lomellina','Candia Lomellina','','NO','B587',45.1759514,8.5951459,27.7877,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018029','Canneto Pavese','Canneto Pavese','','NO','B613',45.0520072,9.2793241,5.7281,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018030','Carbonara al Ticino','Carbonara al Ticino','','NO','B741',45.1654244,9.0606702,14.5469,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018031','Casanova Lonati','Casanova Lonati','','NO','B929',45.0940205,9.2138150,4.9138,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018032','Casatisma','Casatisma','','NO','B945',45.0487638,9.1294728,5.5754,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018033','Casei Gerola','Casei Gerola','','NO','B954',45.0063116,8.9270886,24.9077,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018034','Casorate Primo','Casorate Primo','','NO','B988',45.3109086,9.0184478,9.8781,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018035','Cassolnovo','Cassolnovo','','NO','C038',45.3658576,8.8091168,31.5848,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018036','Castana','Castana','','NO','C050',45.0262436,9.2738814,5.3346,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018037','Casteggio','Casteggio','','NO','C053',45.0124199,9.1249267,17.4507,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018038','Castelletto di Branduzzo','Castelletto di Branduzzo','','NO','C157',45.0707587,9.0986488,11.6323,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018039','Castello d\'Agogna','Castello d\'Agogna','','NO','C184',45.2328388,8.6892342,10.7426,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018040','Castelnovetto','Castelnovetto','','NO','C213',45.2542831,8.6118979,17.7868,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018041','Cava Manara','Cava Manara','','NO','C360',45.1399913,9.1097808,17.0961,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018042','Cecima','Cecima','','NO','C414',44.8508371,9.0801406,9.9929,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018043','Ceranova','Ceranova','','NO','C484',45.2590687,9.2386762,4.7072,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018044','Ceretto Lomellina','Ceretto Lomellina','','NO','C508',45.2465673,8.6726330,7.3796,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018045','Cergnago','Cergnago','','NO','C509',45.1982534,8.7740223,13.7788,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018046','Certosa di Pavia','Certosa di Pavia','','NO','C541',45.2543413,9.1280909,10.3602,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018047','Cervesina','Cervesina','','NO','C551',45.0626624,9.0160583,12.1631,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018048','Chignolo Po','Chignolo Po','','NO','C637',45.1533745,9.4897075,23.3964,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018049','Cigognola','Cigognola','','NO','C684',45.0330215,9.2437469,8.0211,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018050','Cilavegna','Cilavegna','','NO','C686',45.3102534,8.7428508,17.8451,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018051','Codevilla','Codevilla','','NO','C813',44.9630226,9.0582653,12.7773,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018052','Confienza','Confienza','','NO','C958',45.3319090,8.5575716,26.6581,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018053','Copiano','Copiano','','NO','C979',45.1953354,9.3219687,4.3698,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018054','Corana','Corana','','NO','C982',45.0612429,8.9691163,13.1736,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018057','Corvino San Quirico','Corvino San Quirico','','NO','D081',45.0156492,9.1588586,4.2843,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018058','Costa de\' Nobili','Costa de\' Nobili','','NO','D109',45.1301016,9.3794782,11.5045,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018059','Cozzo','Cozzo','','NO','D127',45.1924465,8.6114960,17.8970,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018060','Cura Carpignano','Cura Carpignano','','NO','B824',45.2122300,9.2568459,10.8216,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018061','Dorno','Dorno','','NO','D348',45.1549307,8.9510492,30.1739,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018062','Ferrera Erbognone','Ferrera Erbognone','','NO','D552',45.1143726,8.8627119,18.9026,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018063','Filighera','Filighera','','NO','D594',45.1772739,9.3141155,7.9917,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018064','Fortunago','Fortunago','','NO','D732',44.9227876,9.1855108,17.8466,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018065','Frascarolo','Frascarolo','','NO','D771',45.0463369,8.6830041,23.8562,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018066','Galliavola','Galliavola','','NO','D873',45.0970442,8.8191035,9.4295,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018067','Gambarana','Gambarana','','NO','D892',45.0286679,8.7663519,11.7491,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018068','Gambolò','Gambolò','','NO','D901',45.2572194,8.8587738,51.5330,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018069','Garlasco','Garlasco','','NO','D925',45.1963857,8.9229629,39.1564,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018071','Gerenzago','Gerenzago','','NO','D980',45.2035965,9.3622104,5.3542,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018072','Giussago','Giussago','','NO','E062',45.2847215,9.1420106,25.2404,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018073','Godiasco Salice Terme','Godiasco Salice Terme','','NO','E072',44.8964603,9.0562470,20.5250,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018074','Golferenzo','Golferenzo','','NO','E081',44.9619092,9.3063161,4.6676,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018075','Gravellona Lomellina','Gravellona Lomellina','','NO','E152',45.3295296,8.7659031,20.7595,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018076','Gropello Cairoli','Gropello Cairoli','','NO','E195',45.1771786,8.9921341,26.4335,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018077','Inverno e Monteleone','Inverno e Monteleone','','NO','E310',45.1984892,9.3851549,9.4483,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018078','Landriano','Landriano','','NO','E437',45.3105758,9.2593874,15.2626,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018079','Langosco','Langosco','','NO','E439',45.2153517,8.5628170,16.0072,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018080','Lardirago','Lardirago','','NO','E454',45.2354672,9.2343954,5.3139,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018081','Linarolo','Linarolo','','NO','E600',45.1582008,9.2701035,13.1158,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018082','Lirio','Lirio','','NO','E608',44.9936134,9.2566113,1.6871,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018083','Lomello','Lomello','','NO','E662',45.1214546,8.7937599,22.0574,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018084','Lungavilla','Lungavilla','','NO','B387',45.0427495,9.0808539,6.7792,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018085','Magherno','Magherno','','NO','E804',45.2231629,9.3281395,5.1413,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018086','Marcignago','Marcignago','','NO','E934',45.2526346,9.0785257,10.0614,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018087','Marzano','Marzano','','NO','E999',45.2470353,9.2959658,9.2063,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018088','Mede','Mede','','NO','F080',45.0968563,8.7368975,32.8806,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018089','Menconico','Menconico','','NO','F122',44.7958651,9.2790021,28.2087,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018090','Mezzana Bigli','Mezzana Bigli','','NO','F170',45.0601472,8.8468093,19.1479,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018091','Mezzana Rabattone','Mezzana Rabattone','','NO','F171',45.0951327,9.0295249,6.8967,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018092','Mezzanino','Mezzanino','','NO','F175',45.1255726,9.2053541,12.5490,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018093','Miradolo Terme','Miradolo Terme','','NO','F238',45.1716138,9.4429862,9.8505,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018094','Montalto Pavese','Montalto Pavese','','NO','F417',44.9785925,9.2116608,18.9613,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018095','Montebello della Battaglia','Montebello della Battaglia','','NO','F440',45.0005894,9.1035118,15.8823,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018096','Montecalvo Versiggia','Montecalvo Versiggia','','NO','F449',44.9717415,9.2854935,11.4986,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018097','Montescano','Montescano','','NO','F638',45.0319399,9.2953051,2.2871,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018098','Montesegale','Montesegale','','NO','F644',44.9063559,9.1269600,14.7734,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018099','Monticelli Pavese','Monticelli Pavese','','NO','F670',45.1106801,9.5154037,20.3571,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018100','Montù Beccaria','Montù Beccaria','','NO','F701',45.0381730,9.3128340,15.5166,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018101','Mornico Losana','Mornico Losana','','NO','F739',45.0098279,9.2049618,8.4550,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018102','Mortara','Mortara','','NO','F754',45.2518232,8.7379967,51.9444,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018103','Nicorvo','Nicorvo','','NO','F891',45.2858711,8.6678365,8.0022,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018104','Olevano di Lomellina','Olevano di Lomellina','','NO','G021',45.2134704,8.7184158,15.5565,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018105','Oliva Gessi','Oliva Gessi','','NO','G032',45.0056987,9.1740460,4.0764,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018106','Ottobiano','Ottobiano','','NO','G194',45.1527615,8.8298347,24.8724,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018107','Palestro','Palestro','','NO','G275',45.3025523,8.5330013,18.7202,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018108','Pancarana','Pancarana','','NO','G304',45.0750601,9.0510369,6.3341,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018109','Parona','Parona','','NO','G342',45.2826559,8.7498259,9.4001,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018110','Pavia','Pavia','','SI','G388',45.1850329,9.1597740,63.5629,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018111','Pietra de\' Giorgi','Pietra de\' Giorgi','','NO','G612',45.0205951,9.2309346,11.3212,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018112','Pieve Albignola','Pieve Albignola','','NO','G635',45.1139771,8.9590154,18.0986,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018113','Pieve del Cairo','Pieve del Cairo','','NO','G639',45.0506627,8.8049105,25.0902,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018114','Pieve Porto Morone','Pieve Porto Morone','','NO','G650',45.1133629,9.4380645,16.4764,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018115','Pinarolo Po','Pinarolo Po','','NO','G671',45.0679413,9.1676092,11.3988,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018116','Pizzale','Pizzale','','NO','G720',45.0359860,9.0484197,7.1450,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018117','Ponte Nizza','Ponte Nizza','','NO','G851',44.8518076,9.0971930,22.3667,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018118','Portalbera','Portalbera','','NO','G895',45.1000458,9.3204659,4.5486,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018119','Rea','Rea','','NO','H204',45.1157234,9.1547443,2.1652,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018120','Redavalle','Redavalle','','NO','H216',45.0378149,9.2039531,5.6826,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018121','Retorbido','Retorbido','','NO','H246',44.9493898,9.0362506,11.7898,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018122','Rivanazzano Terme','Rivanazzano Terme','','NO','H336',44.9299396,9.0161959,28.8775,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018123','Robbio','Robbio','','NO','H369',45.2900742,8.5936975,40.4552,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018124','Robecco Pavese','Robecco Pavese','','NO','H375',45.0489826,9.1493370,6.9427,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018125','Rocca de\' Giorgi','Rocca de\' Giorgi','','NO','H396',44.9734136,9.2504223,10.5586,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018126','Rocca Susella','Rocca Susella','','NO','H450',44.9131697,9.0957719,13.0215,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018127','Rognano','Rognano','','NO','H491',45.2886377,9.0894752,9.5591,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018128','Romagnese','Romagnese','','NO','H505',44.8379342,9.3288638,29.6998,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018129','Roncaro','Roncaro','','NO','H527',45.2257083,9.2769379,5.0456,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018130','Rosasco','Rosasco','','NO','H559',45.2496976,8.5802666,19.2748,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018131','Rovescala','Rovescala','','NO','H614',45.0106364,9.3480674,8.4149,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018133','San Cipriano Po','San Cipriano Po','','NO','H799',45.1061603,9.2839240,8.4843,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018134','San Damiano al Colle','San Damiano al Colle','','NO','H814',45.0266048,9.3480727,6.4630,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018135','San Genesio ed Uniti','San Genesio ed Uniti','','NO','H859',45.2336546,9.1800360,9.0488,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018136','San Giorgio di Lomellina','San Giorgio di Lomellina','','NO','H885',45.1737879,8.7913460,25.3032,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018137','San Martino Siccomario','San Martino Siccomario','','NO','I014',45.1570933,9.1346851,14.3300,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018138','Sannazzaro de\' Burgondi','Sannazzaro de\' Burgondi','','NO','I048',45.1022942,8.9065546,23.3419,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018139','Santa Cristina e Bissone','Santa Cristina e Bissone','','NO','I175',45.1567865,9.4011310,22.4868,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018140','Santa Giuletta','Santa Giuletta','','NO','I203',45.0338451,9.1813162,11.0718,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018141','Sant\'Alessio con Vialone','Sant\'Alessio con Vialone','','NO','I213',45.2221648,9.2251352,6.6966,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018142','Santa Margherita di Staffora','Santa Margherita di Staffora','','NO','I230',44.7710929,9.2409034,36.9180,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018143','Santa Maria della Versa','Santa Maria della Versa','','NO','I237',44.9862027,9.3003024,18.0642,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018144','Sant\'Angelo Lomellina','Sant\'Angelo Lomellina','','NO','I276',45.2458024,8.6428854,10.6423,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018145','San Zenone al Po','San Zenone al Po','','NO','I416',45.1086068,9.3641052,7.1480,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018146','Sartirana Lomellina','Sartirana Lomellina','','NO','I447',45.1147048,8.6641478,29.7835,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018147','Scaldasole','Scaldasole','','NO','I487',45.1243793,8.9100866,11.7959,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018148','Semiana','Semiana','','NO','I599',45.1377117,8.7302950,9.8075,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018149','Silvano Pietra','Silvano Pietra','','NO','I739',45.0392361,8.9471795,13.7048,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018150','Siziano','Siziano','','NO','E265',45.3189467,9.2002489,11.5039,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018151','Sommo','Sommo','','NO','I825',45.1286848,9.0827272,14.8709,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018152','Spessa','Spessa','','NO','I894',45.1118077,9.3486587,12.2325,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018153','Stradella','Stradella','','NO','I968',45.0760175,9.2960192,18.9143,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018154','Suardi','Suardi','','NO','B014',45.0347136,8.7424516,9.9185,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018155','Torrazza Coste','Torrazza Coste','','NO','L237',44.9756507,9.0875338,16.2238,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018156','Torre Beretti e Castellaro','Torre Beretti e Castellaro','','NO','L250',45.0608812,8.6723083,17.5090,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018157','Torre d\'Arese','Torre d\'Arese','','NO','L256',45.2424560,9.3168260,4.5966,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018158','Torre de\' Negri','Torre de\' Negri','','NO','L262',45.1506360,9.3355300,3.9932,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018159','Torre d\'Isola','Torre d\'Isola','','NO','L269',45.2172661,9.0773126,16.7379,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018160','Torrevecchia Pia','Torrevecchia Pia','','NO','L285',45.2836766,9.2979757,16.9643,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018161','Torricella Verzate','Torricella Verzate','','NO','L292',45.0175709,9.1752863,3.5622,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018162','Travacò Siccomario','Travacò Siccomario','','NO','I236',45.1520271,9.1618695,17.2871,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018163','Trivolzio','Trivolzio','','NO','L440',45.2621945,9.0472577,3.7945,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018164','Tromello','Tromello','','NO','L449',45.2102175,8.8722436,35.4848,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018165','Trovo','Trovo','','NO','L453',45.2834508,9.0377266,8.0126,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018166','Val di Nizza','Val di Nizza','','NO','L562',44.8776357,9.1650306,29.6597,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018167','Valeggio','Valeggio','','NO','L568',45.1523765,8.8617260,9.8527,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018168','Valle Lomellina','Valle Lomellina','','NO','L593',45.1496838,8.6648358,26.7771,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018169','Valle Salimbene','Valle Salimbene','','NO','L617',45.1696002,9.2341895,7.4217,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018171','Varzi','Varzi','','NO','L690',44.8233602,9.1972405,57.3209,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018172','Velezzo Lomellina','Velezzo Lomellina','','NO','L716',45.1634941,8.7369592,8.1279,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018173','Vellezzo Bellini','Vellezzo Bellini','','NO','L720',45.2686184,9.1010199,8.2802,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018174','Verretto','Verretto','','NO','L784',45.0401316,9.1105902,2.8851,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018175','Verrua Po','Verrua Po','','NO','L788',45.1099757,9.1754008,11.0711,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018176','Vidigulfo','Vidigulfo','','NO','L854',45.2932429,9.2354748,15.7667,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018177','Vigevano','Vigevano','','NO','L872',45.3178059,8.8599043,81.3636,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018178','Villa Biscossi','Villa Biscossi','','NO','L917',45.0900135,8.7889764,4.9793,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018179','Villanova d\'Ardenghi','Villanova d\'Ardenghi','','NO','L983',45.1710273,9.0411035,6.6380,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018180','Villanterio','Villanterio','','NO','L994',45.2175908,9.3602988,14.5925,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018181','Vistarino','Vistarino','','NO','M079',45.2115538,9.3064542,9.4860,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018182','Voghera','Voghera','','NO','M109',44.9931094,9.0085646,63.4077,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018183','Volpara','Volpara','','NO','M119',44.9527965,9.2965796,3.6234,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018184','Zavattarello','Zavattarello','','NO','M150',44.8687437,9.2654316,28.3654,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018185','Zeccone','Zeccone','','NO','M152',45.2607619,9.1995521,5.6495,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018186','Zeme','Zeme','','NO','M161',45.1973293,8.6660406,24.8770,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018187','Zenevredo','Zenevredo','','NO','M162',45.0524447,9.3257629,5.4890,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018188','Zerbo','Zerbo','','NO','M166',45.1113652,9.3939047,6.2840,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018189','Zerbolò','Zerbolò','','NO','M167',45.2064212,9.0141399,37.5237,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018190','Zinasco','Zinasco','','NO','M180',45.1276697,9.0290556,29.7918,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018191','Cornale e Bastida','Cornale e Bastida','','NO','M338',45.0433464,8.9112005,3.7351,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018192','Corteolona e Genzone','Corteolona e Genzone','','NO','M372',45.1566095,9.3678274,14.3415,'018');
INSERT INTO `gi_comuni` VALUES ('PV','018193','Colli Verdi','Colli Verdi','','NO','M419',44.9276824,9.2761137,40.9543,'018');
INSERT INTO `gi_comuni` VALUES ('CR','019001','Acquanegra Cremonese','Acquanegra Cremonese','','NO','A039',45.1708605,9.8883333,9.2214,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019002','Agnadello','Agnadello','','NO','A076',45.4460430,9.5605952,11.9854,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019003','Annicco','Annicco','','NO','A299',45.2444364,9.8826824,19.4746,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019004','Azzanello','Azzanello','','NO','A526',45.3122227,9.9220289,10.9198,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019005','Bagnolo Cremasco','Bagnolo Cremasco','','NO','A570',45.3612947,9.6098560,10.3557,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019006','Bonemerse','Bonemerse','','NO','A972',45.1133187,10.0787102,5.9577,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019007','Bordolano','Bordolano','','NO','A986',45.2938971,9.9864968,8.1286,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019009','Calvatone','Calvatone','','NO','B439',45.1291870,10.4419961,13.6371,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019010','Camisano','Camisano','','NO','B484',45.4435782,9.7440764,11.2398,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019011','Campagnola Cremasca','Campagnola Cremasca','','NO','B498',45.3983491,9.6687967,4.5777,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019012','Capergnanica','Capergnanica','','NO','B650',45.3380753,9.6441742,6.8438,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019013','Cappella Cantone','Cappella Cantone','','NO','B679',45.2464548,9.8387405,13.3928,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019014','Cappella de\' Picenardi','Cappella de\' Picenardi','','NO','B680',45.1581259,10.2305471,14.1600,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019015','Capralba','Capralba','','NO','B686',45.4450420,9.6443335,13.4970,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019016','Casalbuttano ed Uniti','Casalbuttano ed Uniti','','NO','B869',45.2514429,9.9627417,22.8126,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019017','Casale Cremasco-Vidolasco','Casale Cremasco-Vidolasco','','NO','B881',45.4332024,9.7133908,9.2201,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019018','Casaletto Ceredano','Casaletto Ceredano','','NO','B889',45.3192354,9.6176388,6.2588,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019019','Casaletto di Sopra','Casaletto di Sopra','','NO','B890',45.4192616,9.7826117,8.7801,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019020','Casaletto Vaprio','Casaletto Vaprio','','NO','B891',45.4084766,9.6289079,5.4756,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019021','Casalmaggiore','Casalmaggiore','','NO','B898',44.9860203,10.4144780,64.2700,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019022','Casalmorano','Casalmorano','','NO','B900',45.2870684,9.8979160,12.5723,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019023','Casteldidone','Casteldidone','','NO','C089',45.0691827,10.4053997,10.8122,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019024','Castel Gabbiano','Castel Gabbiano','','NO','C115',45.4698006,9.7150746,5.7991,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019025','Castelleone','Castelleone','','NO','C153',45.2936359,9.7642379,45.1206,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019026','Castelverde','Castelverde','','NO','B129',45.1875291,9.9960604,30.9321,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019027','Castelvisconti','Castelvisconti','','NO','C290',45.3042994,9.9423949,10.1000,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019028','Cella Dati','Cella Dati','','NO','C435',45.0972349,10.2215925,18.9043,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019029','Chieve','Chieve','','NO','C634',45.3383871,9.6141377,6.1501,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019030','Cicognolo','Cicognolo','','NO','C678',45.1669809,10.1950163,7.0125,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019031','Cingia de\' Botti','Cingia de\' Botti','','NO','C703',45.0841227,10.2752807,14.5165,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019032','Corte de\' Cortesi con Cignone','Corte de\' Cortesi con Cignone','','NO','D056',45.2726975,10.0077905,12.6854,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019033','Corte de\' Frati','Corte de\' Frati','','NO','D057',45.2200369,10.0976000,19.9269,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019034','Credera Rubbiano','Credera Rubbiano','','NO','D141',45.3022950,9.6552790,13.9776,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019035','Crema','Crema','','NO','D142',45.3633237,9.6863792,34.2246,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019036','Cremona','Cremona','','SI','D150',45.1333671,10.0242087,70.1867,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019037','Cremosano','Cremosano','','NO','D151',45.3960478,9.6391777,5.8913,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019038','Crotta d\'Adda','Crotta d\'Adda','','NO','D186',45.1597567,9.8538666,12.6474,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019039','Cumignano sul Naviglio','Cumignano sul Naviglio','','NO','D203',45.3537591,9.8376402,6.6917,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019040','Derovere','Derovere','','NO','D278',45.1107759,10.2486276,10.1348,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019041','Dovera','Dovera','','NO','D358',45.3652975,9.5415240,20.6915,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019043','Fiesco','Fiesco','','NO','D574',45.3362594,9.7779891,8.3075,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019044','Formigara','Formigara','','NO','D710',45.2238582,9.7701689,12.3220,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019045','Gabbioneta-Binanuova','Gabbioneta-Binanuova','','NO','D834',45.2171223,10.2233253,15.8454,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019046','Gadesco-Pieve Delmona','Gadesco-Pieve Delmona','','NO','D841',45.1553345,10.1162077,16.7855,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019047','Genivolta','Genivolta','','NO','D966',45.3344829,9.8791851,18.7391,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019048','Gerre de\' Caprioli','Gerre de\' Caprioli','','NO','D993',45.1052584,10.0402810,7.6582,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019049','Gombito','Gombito','','NO','E082',45.2620470,9.7298166,9.3634,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019050','Grontardo','Grontardo','','NO','E193',45.2014402,10.1512366,12.2933,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019051','Grumello Cremonese ed Uniti','Grumello Cremonese ed Uniti','','NO','E217',45.1932207,9.8673900,22.5967,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019052','Gussola','Gussola','','NO','E272',45.0095949,10.3505939,25.1272,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019053','Isola Dovarese','Isola Dovarese','','NO','E356',45.1756534,10.3119989,9.5226,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019054','Izano','Izano','','NO','E380',45.3558049,9.7550792,6.1463,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019055','Madignano','Madignano','','NO','E793',45.3445201,9.7252394,10.9609,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019056','Malagnino','Malagnino','','NO','E843',45.1335954,10.1156052,10.5569,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019057','Martignana di Po','Martignana di Po','','NO','E983',45.0109540,10.3792632,14.7694,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019058','Monte Cremasco','Monte Cremasco','','NO','F434',45.3717384,9.5719415,2.3443,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019059','Montodine','Montodine','','NO','F681',45.2853732,9.7100189,11.7931,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019060','Moscazzano','Moscazzano','','NO','F761',45.2928950,9.6851319,8.2645,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019061','Motta Baluffi','Motta Baluffi','','NO','F771',45.0544495,10.2595884,16.4571,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019062','Offanengo','Offanengo','','NO','G004',45.3815229,9.7420934,12.5449,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019063','Olmeneta','Olmeneta','','NO','G047',45.2354353,10.0216732,9.1395,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019064','Ostiano','Ostiano','','NO','G185',45.2235177,10.2499939,19.1634,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019065','Paderno Ponchielli','Paderno Ponchielli','','NO','G222',45.2395902,9.9272426,23.6587,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019066','Palazzo Pignano','Palazzo Pignano','','NO','G260',45.3890755,9.5778689,8.9005,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019067','Pandino','Pandino','','NO','G306',45.4058352,9.5529791,22.4174,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019068','Persico Dosimo','Persico Dosimo','','NO','G469',45.1848091,10.1044658,20.7393,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019069','Pescarolo ed Uniti','Pescarolo ed Uniti','','NO','G483',45.1956527,10.1860441,16.4929,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019070','Pessina Cremonese','Pessina Cremonese','','NO','G504',45.1834958,10.2469535,21.9063,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019072','Pianengo','Pianengo','','NO','G558',45.4005035,9.6928862,5.9115,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019073','Pieranica','Pieranica','','NO','G603',45.4251277,9.6106750,2.8526,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019074','Pieve d\'Olmi','Pieve d\'Olmi','','NO','G647',45.0899604,10.1232553,19.8841,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019075','Pieve San Giacomo','Pieve San Giacomo','','NO','G651',45.1269496,10.1862769,14.8557,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019076','Pizzighettone','Pizzighettone','','NO','G721',45.1866392,9.7830679,32.0847,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019077','Pozzaglio ed Uniti','Pozzaglio ed Uniti','','NO','B914',45.2003108,10.0483209,20.8847,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019078','Quintano','Quintano','','NO','H130',45.4202321,9.6195414,2.8440,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019079','Ricengo','Ricengo','','NO','H276',45.4065674,9.7244160,12.3437,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019080','Ripalta Arpina','Ripalta Arpina','','NO','H314',45.3018091,9.7272286,6.6638,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019081','Ripalta Cremasca','Ripalta Cremasca','','NO','H315',45.3347282,9.6944508,11.6147,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019082','Ripalta Guerina','Ripalta Guerina','','NO','H316',45.3059909,9.7049733,2.9052,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019083','Rivarolo del Re ed Uniti','Rivarolo del Re ed Uniti','','NO','H341',45.0292447,10.4705516,27.3573,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019084','Rivolta d\'Adda','Rivolta d\'Adda','','NO','H357',45.4703914,9.5130087,30.4206,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019085','Robecco d\'Oglio','Robecco d\'Oglio','','NO','H372',45.2614631,10.0782558,18.2297,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019086','Romanengo','Romanengo','','NO','H508',45.3773782,9.7854635,15.0420,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019087','Salvirola','Salvirola','','NO','H731',45.3546070,9.7803628,7.4623,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019088','San Bassano','San Bassano','','NO','H767',45.2442432,9.8086568,13.4917,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019089','San Daniele Po','San Daniele Po','','NO','H815',45.0665452,10.1760136,22.4776,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019090','San Giovanni in Croce','San Giovanni in Croce','','NO','H918',45.0785798,10.3745878,16.5721,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019091','San Martino del Lago','San Martino del Lago','','NO','I007',45.0742031,10.3171251,10.2201,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019092','Scandolara Ravara','Scandolara Ravara','','NO','I497',45.0519173,10.3018575,17.0329,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019093','Scandolara Ripa d\'Oglio','Scandolara Ripa d\'Oglio','','NO','I498',45.2218253,10.1569316,5.6294,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019094','Sergnano','Sergnano','','NO','I627',45.4275972,9.7041863,12.2760,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019095','Sesto ed Uniti','Sesto ed Uniti','','NO','I683',45.1761198,9.9154281,26.6688,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019096','Solarolo Rainerio','Solarolo Rainerio','','NO','I790',45.0812297,10.3566839,11.5466,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019097','Soncino','Soncino','','NO','I827',45.3997669,9.8738270,44.9839,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019098','Soresina','Soresina','','NO','I849',45.2885830,9.8543329,27.9311,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019099','Sospiro','Sospiro','','NO','I865',45.1055224,10.1570918,18.9589,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019100','Spinadesco','Spinadesco','','NO','I906',45.1482440,9.9283401,17.3283,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019101','Spineda','Spineda','','NO','I909',45.0604260,10.5165188,9.9193,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019102','Spino d\'Adda','Spino d\'Adda','','NO','I914',45.4005093,9.4924232,19.7026,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019103','Stagno Lombardo','Stagno Lombardo','','NO','I935',45.0732484,10.0878864,40.3892,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019104','Ticengo','Ticengo','','NO','L164',45.3691440,9.8266142,7.8185,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019105','Torlino Vimercati','Torlino Vimercati','','NO','L221',45.4186562,9.5969950,5.6603,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019106','Tornata','Tornata','','NO','L225',45.1033751,10.4315310,10.2345,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019107','Torre de\' Picenardi','Torre de\' Picenardi','','NO','L258',45.1439934,10.2869485,34.3399,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019108','Torricella del Pizzo','Torricella del Pizzo','','NO','L296',45.0190180,10.2940773,23.1945,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019109','Trescore Cremasco','Trescore Cremasco','','NO','L389',45.4020422,9.6239723,5.8594,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019110','Trigolo','Trigolo','','NO','L426',45.3286119,9.8140539,16.1099,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019111','Vaiano Cremasco','Vaiano Cremasco','','NO','L535',45.3702795,9.5892598,6.2452,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019112','Vailate','Vailate','','NO','L539',45.4612673,9.6036834,9.5203,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019113','Vescovato','Vescovato','','NO','L806',45.1771995,10.1665679,17.6099,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019114','Volongo','Volongo','','NO','M116',45.2113490,10.3023736,8.2017,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019115','Voltido','Voltido','','NO','M127',45.1109676,10.3337807,12.2939,'019');
INSERT INTO `gi_comuni` VALUES ('CR','019116','Piadena Drizzona','Piadena Drizzona','','NO','M418',45.1302875,10.3684133,31.2005,'019');
INSERT INTO `gi_comuni` VALUES ('MN','020001','Acquanegra sul Chiese','Acquanegra sul Chiese','','NO','A038',45.1623000,10.4312110,28.0882,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020002','Asola','Asola','','NO','A470',45.2209284,10.4132951,73.1922,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020003','Bagnolo San Vito','Bagnolo San Vito','','NO','A575',45.0921150,10.8781126,49.3799,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020007','Bozzolo','Bozzolo','','NO','B110',45.1062598,10.4821058,18.7906,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020008','Canneto sull\'Oglio','Canneto sull\'Oglio','','NO','B612',45.1501675,10.3753759,26.2574,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020010','Casalmoro','Casalmoro','','NO','B901',45.2596380,10.4087138,13.9014,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020011','Casaloldo','Casaloldo','','NO','B907',45.2540986,10.4772604,16.9552,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020012','Casalromano','Casalromano','','NO','B911',45.2004199,10.3662749,12.0792,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020013','Castelbelforte','Castelbelforte','','NO','C059',45.2139779,10.8913181,22.1375,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020014','Castel d\'Ario','Castel d\'Ario','','NO','C076',45.1887706,10.9752225,22.6286,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020015','Castel Goffredo','Castel Goffredo','','NO','C118',45.2981143,10.4744266,42.2237,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020016','Castellucchio','Castellucchio','','NO','C195',45.1490187,10.6458928,46.6020,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020017','Castiglione delle Stiviere','Castiglione delle Stiviere','','NO','C312',45.3895595,10.4888160,41.9419,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020018','Cavriana','Cavriana','','NO','C406',45.3510530,10.6000801,36.7732,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020019','Ceresara','Ceresara','','NO','C502',45.2646426,10.5689192,37.6499,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020020','Commessaggio','Commessaggio','','NO','C930',45.0346131,10.5454096,11.6487,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020021','Curtatone','Curtatone','','NO','D227',45.1317614,10.7259011,67.2142,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020022','Dosolo','Dosolo','','NO','D351',44.9536310,10.6413944,25.6573,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020024','Gazoldo degli Ippoliti','Gazoldo degli Ippoliti','','NO','D949',45.1999098,10.5796262,13.1154,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020025','Gazzuolo','Gazzuolo','','NO','D959',45.0703722,10.5832238,22.6787,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020026','Goito','Goito','','NO','E078',45.2549149,10.6743198,78.9991,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020027','Gonzaga','Gonzaga','','NO','E089',44.9543302,10.8219035,50.2989,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020028','Guidizzolo','Guidizzolo','','NO','E261',45.3187345,10.5822635,22.3774,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020029','Magnacavallo','Magnacavallo','','NO','E818',45.0065887,11.1823011,28.4894,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020030','Mantova','Mantova','','SI','E897',45.1574335,10.7928012,64.2143,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020031','Marcaria','Marcaria','','NO','E922',45.1196385,10.5335869,89.4259,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020032','Mariana Mantovana','Mariana Mantovana','','NO','E949',45.1934372,10.4866734,8.8820,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020033','Marmirolo','Marmirolo','','NO','E962',45.2209870,10.7565858,42.1615,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020034','Medole','Medole','','NO','F086',45.3254092,10.5103365,25.6801,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020035','Moglia','Moglia','','NO','F267',44.9317290,10.9117970,31.8698,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020036','Monzambano','Monzambano','','NO','F705',45.3861751,10.6919682,30.1781,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020037','Motteggiana','Motteggiana','','NO','B012',45.0365264,10.7622694,25.1719,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020038','Ostiglia','Ostiglia','','NO','G186',45.0646167,11.1334964,39.9923,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020039','Pegognaga','Pegognaga','','NO','G417',44.9960612,10.8590830,46.4195,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020041','Piubega','Piubega','','NO','G717',45.2268453,10.5348281,16.7266,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020042','Poggio Rusco','Poggio Rusco','','NO','G753',44.9774360,11.1188440,41.8830,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020043','Pomponesco','Pomponesco','','NO','G816',44.9271996,10.5923375,12.5464,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020044','Ponti sul Mincio','Ponti sul Mincio','','NO','G862',45.4127900,10.6871161,11.8082,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020045','Porto Mantovano','Porto Mantovano','','NO','G917',45.1887871,10.7900238,37.3228,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020046','Quingentole','Quingentole','','NO','H129',45.0389060,11.0436384,14.1194,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020047','Quistello','Quistello','','NO','H143',45.0090751,10.9804270,45.5714,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020048','Redondesco','Redondesco','','NO','H218',45.1666745,10.5128218,19.0120,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020050','Rivarolo Mantovano','Rivarolo Mantovano','','NO','H342',45.0708456,10.4320895,25.6768,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020051','Rodigo','Rodigo','','NO','H481',45.1993747,10.6243218,41.6729,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020052','Roncoferraro','Roncoferraro','','NO','H541',45.1342739,10.9543786,63.1772,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020053','Roverbella','Roverbella','','NO','H604',45.2657785,10.7677483,62.8196,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020054','Sabbioneta','Sabbioneta','','NO','H652',44.9996010,10.4899468,36.9643,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020055','San Benedetto Po','San Benedetto Po','','NO','H771',45.0410936,10.9285367,69.9580,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020056','San Giacomo delle Segnate','San Giacomo delle Segnate','','NO','H870',44.9718662,11.0331778,16.1239,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020057','San Giorgio Bigarello','San Giorgio Bigarello','','NO','H883',45.1651959,10.8457079,51.8093,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020058','San Giovanni del Dosso','San Giovanni del Dosso','','NO','H912',44.9661182,11.0797901,15.0555,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020059','San Martino dall\'Argine','San Martino dall\'Argine','','NO','I005',45.0996187,10.5183280,16.9188,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020060','Schivenoglia','Schivenoglia','','NO','I532',44.9949787,11.0729606,13.0859,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020061','Sermide e Felonica','Sermide e Felonica','','NO','I632',45.0065390,11.2992808,79.9035,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020062','Serravalle a Po','Serravalle a Po','','NO','I662',45.0651769,11.0767938,26.1182,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020063','Solferino','Solferino','','NO','I801',45.3702787,10.5659558,13.0032,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020064','Sustinente','Sustinente','','NO','L015',45.0683116,11.0223871,26.1797,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020065','Suzzara','Suzzara','','NO','L020',44.9899906,10.7449977,60.5076,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020066','Viadana','Viadana','','NO','L826',44.9262445,10.5207292,104.2577,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020068','Villimpenta','Villimpenta','','NO','M044',45.1449091,11.0294062,14.8617,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020070','Volta Mantovana','Volta Mantovana','','NO','M125',45.3208280,10.6589830,50.7297,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020071','Borgo Virgilio','Borgo Virgilio','','NO','M340',45.1177156,10.7879025,69.5460,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020072','Borgo Mantovano','Borgo Mantovano','','NO','M396',45.0576238,11.1253045,41.2998,'020');
INSERT INTO `gi_comuni` VALUES ('MN','020073','Borgocarbonara','Borgocarbonara','','NO','M406',45.0376325,11.2233994,30.3116,'020');
INSERT INTO `gi_comuni` VALUES ('BZ','021001','Aldino/Aldein','Aldino','Aldein','NO','A179',46.3678092,11.3541280,62.8401,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021002','Andriano/Andrian','Andriano','Andrian','NO','A286',46.5203668,11.2331345,5.2537,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021003','Anterivo/Altrei','Anterivo','Altrei','NO','A306',46.2776350,11.3660356,10.9603,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021004','Appiano sulla strada del vino/Eppan an der Weinstraße','Appiano sulla strada del vino','Eppan an der Weinstraße','NO','A332',46.4554699,11.2589922,58.9357,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021005','Avelengo/Hafling','Avelengo','Hafling','NO','A507',46.6461328,11.2245184,27.2631,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021006','Badia/Abtei','Badia','Abtei','NO','A537',46.6105610,11.8934113,82.6176,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021007','Barbiano/Barbian','Barbiano','Barbian','NO','A635',46.6036182,11.5198339,24.5340,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021008','Bolzano/Bozen','Bolzano','Bozen','SI','A952',46.4990522,11.3563105,51.8242,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021009','Braies/Prags','Braies','Prags','NO','B116',46.7189948,12.1296118,90.5676,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021010','Brennero/Brenner','Brennero','Brenner','NO','B145',46.9377877,11.4432560,114.8103,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021011','Bressanone/Brixen','Bressanone','Brixen','NO','B160',46.7165044,11.6567468,85.0060,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021012','Bronzolo/Branzoll','Bronzolo','Branzoll','NO','B203',46.4046421,11.3198839,7.5032,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021013','Brunico/Bruneck','Brunico','Bruneck','NO','B220',46.7966638,11.9354838,44.9474,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021014','Caines/Kuens','Caines','Kuens','NO','B364',46.7018443,11.1806584,1.6197,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021015','Caldaro sulla strada del vino/Kaltern an der Weinstraße','Caldaro sulla strada del vino','Kaltern an der Weinstraße','NO','B397',46.4132741,11.2466902,48.5651,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021016','Campo di Trens/Freienfeld','Campo di Trens','Freienfeld','NO','B529',46.8713172,11.4838016,95.8670,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021017','Campo Tures/Sand in Taufers','Campo Tures','Sand in Taufers','NO','B570',46.9198078,11.9523794,163.6857,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021018','Castelbello-Ciardes/Kastelbell-Tschars','Castelbello-Ciardes','Kastelbell-Tschars','NO','C062',46.6283324,10.9011791,53.8011,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021019','Castelrotto/Kastelruth','Castelrotto','Kastelruth','NO','C254',46.5681173,11.5592863,117.7194,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021020','Cermes/Tscherms','Cermes','Tscherms','NO','A022',46.6327495,11.1449304,6.6390,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021021','Chienes/Kiens','Chienes','Kiens','NO','C625',46.8064316,11.8363064,33.7426,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021022','Chiusa/Klausen','Chiusa','Klausen','NO','C652',46.6414552,11.5680025,51.0704,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021023','Cornedo all\'Isarco/Karneid','Cornedo all\'Isarco','Karneid','NO','B799',46.4940995,11.3918680,40.8714,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021024','Cortaccia sulla strada del vino/Kurtatsch an der Weinstraße','Cortaccia sulla strada del vino','Kurtatsch an der Weinstraße','NO','D048',46.3135356,11.2226025,29.2795,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021025','Cortina sulla strada del vino/Kurtinig an der Weinstraße','Cortina sulla strada del vino','Kurtinig an der Weinstraße','NO','D075',46.2689448,11.2227283,2.0454,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021026','Corvara in Badia/Corvara','Corvara in Badia','Corvara','NO','D079',46.5498600,11.8740570,38.7790,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021027','Curon Venosta/Graun im Vinschgau','Curon Venosta','Graun im Vinschgau','NO','D222',46.8066234,10.5421523,210.0216,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021028','Dobbiaco/Toblach','Dobbiaco','Toblach','NO','D311',46.7353586,12.2225801,124.9635,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021029','Egna/Neumarkt','Egna','Neumarkt','NO','D392',46.3138950,11.2729510,23.5464,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021030','Falzes/Pfalzen','Falzes','Pfalzen','NO','D484',46.8119432,11.8827973,33.2066,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021031','Fiè allo Sciliar/Völs am Schlern','Fiè allo Sciliar','Völs am Schlern','NO','D571',46.5176239,11.5016733,43.7495,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021032','Fortezza/Franzensfeste','Fortezza','Franzensfeste','NO','D731',46.7867403,11.6131943,62.0239,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021033','Funes/Villnöß','Funes','Villnöß','NO','D821',46.6422431,11.6804782,81.4666,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021034','Gais/Gais','Gais','Gais','NO','D860',46.8356705,11.9476819,60.5285,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021035','Gargazzone/Gargazon','Gargazzone','Gargazon','NO','D923',46.5847946,11.2013115,4.9600,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021036','Glorenza/Glurns','Glorenza','Glurns','NO','E069',46.6711327,10.5549783,13.1654,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021037','Laces/Latsch','Laces','Latsch','NO','E398',46.6171586,10.8592154,78.7618,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021038','Lagundo/Algund','Lagundo','Algund','NO','E412',46.6835885,11.1213208,23.3291,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021039','Laion/Lajen','Laion','Lajen','NO','E420',46.6087013,11.5650230,37.6163,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021040','Laives/Leifers','Laives','Leifers','NO','E421',46.4263553,11.3381330,24.5515,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021041','Lana/Lana','Lana','Lana','NO','E434',46.6161882,11.1453105,35.8625,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021042','Lasa/Laas','Lasa','Laas','NO','E457',46.6181641,10.6974972,110.1842,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021043','Lauregno/Laurein','Lauregno','Laurein','NO','E481',46.4542294,11.0622429,13.8364,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021044','Luson/Lüsen','Luson','Lüsen','NO','E764',46.7459388,11.7607410,74.3210,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021045','Magrè sulla strada del vino/Margreid an der Weinstraße','Magrè sulla strada del vino','Margreid an der Weinstraße','NO','E829',46.2867552,11.2089608,13.7157,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021046','Malles Venosta/Mals','Malles Venosta','Mals','NO','E862',46.6894687,10.5451958,247.7786,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021047','Marebbe/Enneberg','Marebbe','Enneberg','NO','E938',46.6975717,11.9327168,159.6993,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021048','Marlengo/Marling','Marlengo','Marling','NO','E959',46.6548175,11.1404466,13.0187,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021049','Martello/Martell','Martello','Martell','NO','E981',46.5660568,10.7824528,142.2836,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021050','Meltina/Mölten','Meltina','Mölten','NO','F118',46.5868603,11.2538278,37.1783,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021051','Merano/Meran','Merano','Meran','NO','F132',46.6720943,11.1616662,25.9844,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021052','Monguelfo-Tesido/Welsberg-Taisten','Monguelfo-Tesido','Welsberg-Taisten','NO','F371',46.7569944,12.1047870,46.2520,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021053','Montagna sulla strada del vino/Montan an der Weinstraße','Montagna sulla strada del vino','Montan an der Weinstraße','NO','F392',46.3313243,11.3027193,19.1674,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021054','Moso in Passiria/Moos in Passeier','Moso in Passiria','Moos in Passeier','NO','F766',46.8300157,11.1686181,193.8041,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021055','Nalles/Nals','Nalles','Nals','NO','F836',46.5431168,11.2034026,12.2144,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021056','Naturno/Naturns','Naturno','Naturns','NO','F849',46.6510249,11.0049681,66.7528,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021057','Naz-Sciaves/Natz-Schabs','Naz-Sciaves','Natz-Schabs','NO','F856',46.7705837,11.6658163,15.7148,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021058','Nova Levante/Welschnofen','Nova Levante','Welschnofen','NO','F949',46.4303192,11.5369847,51.0811,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021059','Nova Ponente/Deutschnofen','Nova Ponente','Deutschnofen','NO','F950',46.4144449,11.4255689,111.7664,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021060','Ora/Auer','Ora','Auer','NO','G083',46.3481366,11.2982227,11.6129,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021061','Ortisei/St. Ulrich','Ortisei','St. Ulrich','NO','G140',46.5760962,11.6717619,24.1339,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021062','Parcines/Partschins','Parcines','Partschins','NO','G328',46.6846276,11.0731517,55.8283,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021063','Perca/Percha','Perca','Percha','NO','G443',46.7915103,11.9832241,30.7610,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021064','Plaus/Plaus','Plaus','Plaus','NO','G299',46.6557283,11.0422942,5.0925,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021065','Ponte Gardena/Waidbruck','Ponte Gardena','Waidbruck','NO','G830',46.5969676,11.5302458,2.4388,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021066','Postal/Burgstall','Postal','Burgstall','NO','G936',46.6091131,11.1918722,6.6721,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021067','Prato allo Stelvio/Prad am Stilfserjoch','Prato allo Stelvio','Prad am Stilfserjoch','NO','H004',46.6172434,10.5888752,50.7297,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021068','Predoi/Prettau','Predoi','Prettau','NO','H019',47.0379923,12.1028171,86.6060,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021069','Proves/Proveis','Proves','Proveis','NO','H081',46.4762164,11.0222420,18.5177,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021070','Racines/Ratschings','Racines','Ratschings','NO','H152',46.8830590,11.3785520,203.1654,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021071','Rasun-Anterselva/Rasen-Antholz','Rasun-Anterselva','Rasen-Antholz','NO','H189',46.7807630,12.0493564,121.5559,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021072','Renon/Ritten','Renon','Ritten','NO','H236',46.5367991,11.4631081,111.5476,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021073','Rifiano/Riffian','Rifiano','Riffian','NO','H284',46.7018443,11.1806584,35.5423,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021074','Rio di Pusteria/Mühlbach','Rio di Pusteria','Mühlbach','NO','H299',46.7962820,11.6671114,83.7237,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021075','Rodengo/Rodeneck','Rodengo','Rodeneck','NO','H475',46.7767039,11.6904151,29.7318,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021076','Salorno sulla strada del vino/Salurn an der Weinstraße','Salorno sulla strada del vino','Salurn an der Weinstraße','NO','H719',46.2389494,11.2124245,33.5079,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021077','San Candido/Innichen','San Candido','Innichen','NO','H786',46.7325754,12.2829134,80.3251,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021079','San Genesio Atesino/Jenesien','San Genesio Atesino','Jenesien','NO','H858',46.5347406,11.3312871,68.5930,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021080','San Leonardo in Passiria/St. Leonhard in Passeier','San Leonardo in Passiria','St. Leonhard in Passeier','NO','H952',46.8116193,11.2438462,88.8045,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021081','San Lorenzo di Sebato/St. Lorenzen','San Lorenzo di Sebato','St. Lorenzen','NO','H956',46.7835453,11.9018130,51.1939,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021082','San Martino in Badia/St. Martin in Thurn','San Martino in Badia','St. Martin in Thurn','NO','H988',46.6820025,11.8982796,76.2790,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021083','San Martino in Passiria/St. Martin in Passeier','San Martino in Passiria','St. Martin in Passeier','NO','H989',46.7822205,11.2270570,30.3009,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021084','San Pancrazio/St. Pankraz','San Pancrazio','St. Pankraz','NO','I065',46.5856332,11.0865324,63.1865,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021085','Santa Cristina Valgardena/St. Christina in Gröden','Santa Cristina Valgardena','St. Christina in Gröden','NO','I173',46.5582877,11.7199851,31.8329,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021086','Sarentino/Sarntal','Sarentino','Sarntal','NO','I431',46.6427283,11.3566581,301.9615,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021087','Scena/Schenna','Scena','Schenna','NO','I519',46.6901016,11.1869585,47.9986,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021088','Selva dei Molini/Mühlwald','Selva dei Molini','Mühlwald','NO','I593',46.8903117,11.8621111,105.1547,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021089','Selva di Val Gardena/Wolkenstein in Gröden','Selva di Val Gardena','Wolkenstein in Gröden','NO','I591',46.5561577,11.7582758,56.3886,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021091','Senales/Schnals','Senales','Schnals','NO','I604',46.7052512,10.9097097,209.7410,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021092','Sesto/Sexten','Sesto','Sexten','NO','I687',46.7020896,12.3503066,80.1204,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021093','Silandro/Schlanders','Silandro','Schlanders','NO','I729',46.6279753,10.7731664,115.0829,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021094','Sluderno/Schluderns','Sluderno','Schluderns','NO','I771',46.6641667,10.5848011,20.9599,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021095','Stelvio/Stilfs','Stelvio','Stilfs','NO','I948',46.5956785,10.5446388,141.8691,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021096','Terento/Terenten','Terento','Terenten','NO','L106',46.8290123,11.7766225,42.5186,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021097','Terlano/Terlan','Terlano','Terlan','NO','L108',46.5290778,11.2486383,18.3956,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021098','Termeno sulla strada del vino/Tramin an der Weinstraße','Termeno sulla strada del vino','Tramin an der Weinstraße','NO','L111',46.3410870,11.2397625,19.8780,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021099','Tesimo/Tisens','Tesimo','Tisens','NO','L149',46.5637876,11.1693184,37.9307,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021100','Tires/Tiers','Tires','Tiers','NO','L176',46.4671749,11.5276908,42.1837,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021101','Tirolo/Tirol','Tirolo','Tirol','NO','L178',46.6906322,11.1538499,26.2335,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021102','Trodena nel parco naturale/Truden im Naturpark','Trodena nel parco naturale','Truden im Naturpark','NO','L444',46.3225638,11.3490311,20.9319,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021103','Tubre/Taufers im Münstertal','Tubre','Taufers im Münstertal','NO','L455',46.6465044,10.4644154,46.0975,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021104','Ultimo/Ulten','Ultimo','Ulten','NO','L490',46.5502782,11.0059276,208.5179,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021105','Vadena/Pfatten','Vadena','Pfatten','NO','L527',46.4145805,11.3052221,13.4026,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021106','Valdaora/Olang','Valdaora','Olang','NO','L552',46.7612104,12.0303526,49.2572,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021107','Val di Vizze/Pfitsch','Val di Vizze','Pfitsch','NO','L564',46.8997441,11.4624438,142.1790,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021108','Valle Aurina/Ahrntal','Valle Aurina','Ahrntal','NO','L595',46.9948795,11.9801403,188.4633,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021109','Valle di Casies/Gsies','Valle di Casies','Gsies','NO','L601',46.8111033,12.2273473,110.3344,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021110','Vandoies/Vintl','Vandoies','Vintl','NO','L660',46.8163767,11.7222705,110.5247,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021111','Varna/Vahrn','Varna','Vahrn','NO','L687',46.7401193,11.6356900,70.0487,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021112','Verano/Vöran','Verano','Vöran','NO','L745',46.6050315,11.2265497,22.7613,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021113','Villabassa/Niederdorf','Villabassa','Niederdorf','NO','L915',46.7377426,12.1690848,17.9763,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021114','Villandro/Villanders','Villandro','Villanders','NO','L971',46.6311600,11.5394862,43.9715,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021115','Vipiteno/Sterzing','Vipiteno','Sterzing','NO','M067',46.8979094,11.4318371,32.6929,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021116','Velturno/Feldthurns','Velturno','Feldthurns','NO','L724',46.6687892,11.5988803,24.4057,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021117','La Valle/Wengen','La Valle','Wengen','NO','E491',46.6576513,11.9250170,39.1748,'021');
INSERT INTO `gi_comuni` VALUES ('BZ','021118','Senale-San Felice/Unsere Liebe Frau im Walde-St. Felix','Senale-San Felice','Unsere Liebe Frau im Walde-St. Felix','NO','I603',46.4924668,11.1319034,27.7717,'021');
INSERT INTO `gi_comuni` VALUES ('TN','022001','Ala','Ala','','NO','A116',45.7566523,11.0051179,119.9659,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022002','Albiano','Albiano','','NO','A158',46.1450240,11.1933316,9.6929,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022003','Aldeno','Aldeno','','NO','A178',45.9772494,11.0913705,9.0002,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022005','Andalo','Andalo','','NO','A274',46.1656493,11.0042028,11.5634,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022006','Arco','Arco','','NO','A372',45.9192493,10.8862296,63.2326,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022007','Avio','Avio','','NO','A520',45.7355557,10.9418813,68.7373,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022009','Baselga di Pinè','Baselga di Pinè','','NO','A694',46.1297658,11.2445334,41.4787,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022011','Bedollo','Bedollo','','NO','A730',46.1615948,11.3034440,27.1676,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022013','Besenello','Besenello','','NO','A821',45.9417210,11.1096000,25.9531,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022015','Bieno','Bieno','','NO','A863',46.0803707,11.5535606,11.8967,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022017','Bleggio Superiore','Bleggio Superiore','','NO','A902',46.0253419,10.8370713,32.7235,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022018','Bocenago','Bocenago','','NO','A916',46.1184703,10.7590113,8.5472,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022021','Bondone','Bondone','','NO','A968',45.8083779,10.5405053,19.3242,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022022','Borgo Valsugana','Borgo Valsugana','','NO','B006',46.0530714,11.4564861,52.5623,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022025','Brentonico','Brentonico','','NO','B153',45.8188776,10.9547762,62.8559,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022026','Bresimo','Bresimo','','NO','B158',46.4104711,10.9686369,40.6400,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022029','Caderzone Terme','Caderzone Terme','','NO','B335',46.1293255,10.7565434,18.7985,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022032','Calceranica al Lago','Calceranica al Lago','','NO','B389',46.0040430,11.2427334,3.3742,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022033','Caldes','Caldes','','NO','B400',46.3654325,10.9445587,20.5357,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022034','Caldonazzo','Caldonazzo','','NO','B404',45.9914381,11.2618635,21.1192,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022035','Calliano','Calliano','','NO','B419',45.9359751,11.0946230,10.1859,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022036','Campitello di Fassa','Campitello di Fassa','','NO','B514',46.4757067,11.7400930,25.1231,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022037','Campodenno','Campodenno','','NO','B525',46.2571415,11.0345359,24.7265,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022038','Canal San Bovo','Canal San Bovo','','NO','B577',46.1562918,11.7317844,125.0303,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022039','Canazei','Canazei','','NO','B579',46.4769211,11.7713091,67.3454,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022040','Capriana','Capriana','','NO','B697',46.2626004,11.3390028,12.8099,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022042','Carisolo','Carisolo','','NO','B783',46.1691397,10.7637674,25.1697,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022043','Carzano','Carzano','','NO','B856',46.0707356,11.4936728,1.7395,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022045','Castel Condino','Castel Condino','','NO','C183',45.9153428,10.6029930,11.2633,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022047','Castello-Molina di Fiemme','Castello-Molina di Fiemme','','NO','C189',46.2818019,11.4350288,54.5407,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022048','Castello Tesino','Castello Tesino','','NO','C194',46.0624929,11.6337419,112.6273,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022049','Castelnuovo','Castelnuovo','','NO','C216',46.0523832,11.4939646,13.3714,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022050','Cavalese','Cavalese','','NO','C372',46.2907346,11.4593419,45.3725,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022051','Cavareno','Cavareno','','NO','C380',46.4076348,11.1366799,9.4947,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022052','Cavedago','Cavedago','','NO','C392',46.1834299,11.0279455,10.0846,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022053','Cavedine','Cavedine','','NO','C393',45.9939771,10.9708284,38.0157,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022054','Cavizzana','Cavizzana','','NO','C400',46.3682116,10.9583670,3.4266,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022058','Cimone','Cimone','','NO','C700',45.9782148,11.0684190,9.9498,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022059','Cinte Tesino','Cinte Tesino','','NO','C712',46.0543771,11.6162037,30.4653,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022060','Cis','Cis','','NO','C727',46.3992973,11.0029596,5.7333,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022061','Civezzano','Civezzano','','NO','C756',46.0898950,11.1792917,15.7703,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022062','Cles','Cles','','NO','C794',46.3650659,11.0346210,39.0082,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022064','Commezzadura','Commezzadura','','NO','C931',46.3212727,10.8392701,22.1223,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022068','Croviana','Croviana','','NO','D188',46.3446399,10.9045153,5.0727,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022071','Dambel','Dambel','','NO','D246',46.4056319,11.0953732,5.1243,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022074','Denno','Denno','','NO','D273',46.2746961,11.0511921,10.9376,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022078','Drena','Drena','','NO','D365',45.9706385,10.9445697,8.2706,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022079','Dro','Dro','','NO','D371',45.9620479,10.9112231,27.7651,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022081','Fai della Paganella','Fai della Paganella','','NO','D468',46.1780089,11.0694655,12.0982,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022083','Fiavè','Fiavè','','NO','D565',46.0055300,10.8429820,24.1732,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022085','Fierozzo','Fierozzo','','NO','D573',46.1111279,11.3182516,18.0108,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022087','Folgaria','Folgaria','','NO','D651',45.9164175,11.1702978,71.7261,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022089','Fornace','Fornace','','NO','D714',46.1175082,11.2063863,7.1663,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022090','Frassilongo','Frassilongo','','NO','D775',46.0858459,11.2927252,16.8786,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022091','Garniga Terme','Garniga Terme','','NO','D928',46.0014872,11.0855735,12.9533,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022092','Giovo','Giovo','','NO','E048',46.1570987,11.1513648,20.6325,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022093','Giustino','Giustino','','NO','E065',46.1487034,10.7687596,38.7709,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022095','Grigno','Grigno','','NO','E178',46.0177116,11.6359244,46.2851,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022097','Imer','Imer','','NO','E288',46.1511349,11.7993980,28.0483,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022098','Isera','Isera','','NO','E334',45.8869739,11.0083396,14.1310,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022102','Lavarone','Lavarone','','NO','E492',45.9397752,11.2692721,26.4056,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022103','Lavis','Lavis','','NO','E500',46.1390800,11.1123062,12.3425,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022104','Levico Terme','Levico Terme','','NO','E565',46.0110801,11.3023840,62.8388,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022106','Livo','Livo','','NO','E624',46.4047194,11.0189574,15.3685,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022108','Lona-Lases','Lona-Lases','','NO','E664',46.1464572,11.2186455,11.5087,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022109','Luserna','Luserna','','NO','E757',45.9217548,11.3242149,8.1817,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022110','Malé','Malé','','NO','E850',46.3522423,10.9128064,26.3878,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022112','Massimeno','Massimeno','','NO','F045',46.1420393,10.7731251,21.0444,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022113','Mazzin','Mazzin','','NO','F068',46.4703840,11.7284230,23.9510,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022114','Mezzana','Mezzana','','NO','F168',46.3156512,10.8028906,27.3992,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022115','Mezzano','Mezzano','','NO','F176',46.1546952,11.8067119,49.2883,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022116','Mezzocorona','Mezzocorona','','NO','F183',46.2167651,11.1180439,25.1871,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022117','Mezzolombardo','Mezzolombardo','','NO','F187',46.2131763,11.0901872,13.8810,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022118','Moena','Moena','','NO','F263',46.3766192,11.6597354,82.7821,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022120','Molveno','Molveno','','NO','F307',46.1429197,10.9661947,33.6927,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022123','Mori','Mori','','NO','F728',45.8519974,10.9762025,34.1319,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022124','Nago-Torbole','Nago-Torbole','','NO','F835',45.8704998,10.8749213,28.5149,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022127','Nogaredo','Nogaredo','','NO','F920',45.9121884,11.0227883,3.5403,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022128','Nomi','Nomi','','NO','F929',45.9288577,11.0715049,6.4315,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022129','Novaledo','Novaledo','','NO','F947',46.0225912,11.3659306,7.9018,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022130','Ospedaletto','Ospedaletto','','NO','G168',46.0436666,11.5529310,16.8368,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022131','Ossana','Ossana','','NO','G173',46.3074067,10.7360111,24.8939,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022133','Palù del Fersina','Palù del Fersina','','NO','G296',46.1299088,11.3520442,16.5468,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022134','Panchià','Panchià','','NO','G305',46.2860654,11.5411219,20.3305,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022135','Ronzo-Chienis','Ronzo-Chienis','','NO','M303',45.8912356,10.9504231,13.1895,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022136','Peio','Peio','','NO','G419',46.3553280,10.6890729,162.2239,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022137','Pellizzano','Pellizzano','','NO','G428',46.3095544,10.7605775,48.8308,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022138','Pelugo','Pelugo','','NO','G429',46.0882225,10.7233684,22.9628,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022139','Pergine Valsugana','Pergine Valsugana','','NO','G452',46.0605380,11.2405980,53.9821,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022142','Pieve Tesino','Pieve Tesino','','NO','G656',46.0688809,11.6106962,69.5319,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022143','Pinzolo','Pinzolo','','NO','G681',46.1599084,10.7658990,69.0538,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022144','Pomarolo','Pomarolo','','NO','G808',45.9279720,11.0422916,9.2586,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022147','Predazzo','Predazzo','','NO','H018',46.3125765,11.6027974,109.8387,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022150','Rabbi','Rabbi','','NO','H146',46.3991182,10.8499854,133.0161,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022153','Riva del Garda','Riva del Garda','','NO','H330',45.8848422,10.8389963,40.7098,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022155','Romeno','Romeno','','NO','H517',46.3952823,11.1208464,9.1820,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022156','Roncegno Terme','Roncegno Terme','','NO','H528',46.0509151,11.4098997,38.0335,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022157','Ronchi Valsugana','Ronchi Valsugana','','NO','H532',46.0671337,11.4343134,9.9871,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022159','Ronzone','Ronzone','','NO','H552',46.4232465,11.1501712,5.3265,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022160','Roverè della Luna','Roverè della Luna','','NO','H607',46.2495258,11.1698113,10.3444,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022161','Rovereto','Rovereto','','NO','H612',45.8865198,11.0451557,51.2261,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022162','Ruffrè-Mendola','Ruffrè-Mendola','','NO','H634',46.4144882,11.1775423,6.8213,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022163','Rumo','Rumo','','NO','H639',46.4411085,11.0172387,30.7448,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022164','Sagron Mis','Sagron Mis','','NO','H666',46.1948831,11.9434252,11.3889,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022165','Samone','Samone','','NO','H754',46.0818789,11.5203137,5.0297,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022167','San Michele all\'Adige','San Michele all\'Adige','','NO','I042',46.1926951,11.1340123,16.2689,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022168','Sant\'Orsola Terme','Sant\'Orsola Terme','','NO','I354',46.1081776,11.3022271,15.4628,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022169','Sanzeno','Sanzeno','','NO','I411',46.3746743,11.0684355,7.8014,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022170','Sarnonico','Sarnonico','','NO','I439',46.4202981,11.1416018,11.7926,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022171','Scurelle','Scurelle','','NO','I554',46.0639484,11.5067027,29.6362,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022172','Segonzano','Segonzano','','NO','I576',46.1905500,11.2587104,20.6325,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022173','Sfruz','Sfruz','','NO','I714',46.3369501,11.1151876,12.5089,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022176','Soraga di Fassa','Soraga di Fassa','','NO','I839',46.3958361,11.6686517,19.7314,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022177','Sover','Sover','','NO','I871',46.2212273,11.3153512,14.8514,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022179','Spiazzo','Spiazzo','','NO','I899',46.1028401,10.7367589,70.7373,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022180','Spormaggiore','Spormaggiore','','NO','I924',46.2186058,11.0482461,29.8027,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022181','Sporminore','Sporminore','','NO','I925',46.2371235,11.0307515,17.7864,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022182','Stenico','Stenico','','NO','I949',46.0511752,10.8535502,49.1043,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022183','Storo','Storo','','NO','I964',45.8491874,10.5805521,63.5321,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022184','Strembo','Strembo','','NO','I975',46.1194818,10.7515786,38.6515,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022188','Telve','Telve','','NO','L089',46.0711843,11.4792743,64.2033,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022189','Telve di Sopra','Telve di Sopra','','NO','L090',46.0704801,11.4713306,17.9230,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022190','Tenna','Tenna','','NO','L096',46.0144838,11.2662210,3.1686,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022191','Tenno','Tenno','','NO','L097',45.9205798,10.8325338,28.3319,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022193','Terragnolo','Terragnolo','','NO','L121',45.8791179,11.1514000,39.5237,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022195','Terzolas','Terzolas','','NO','L145',46.3614084,10.9260531,5.8813,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022196','Tesero','Tesero','','NO','L147',46.2893382,11.5112480,50.8561,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022199','Tione di Trento','Tione di Trento','','NO','L174',46.0348213,10.7255267,33.3386,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022200','Ton','Ton','','NO','L200',46.2661759,11.0854301,26.1848,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022202','Torcegno','Torcegno','','NO','L211',46.0732486,11.4498655,15.2897,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022203','Trambileno','Trambileno','','NO','L322',45.8697697,11.0733848,50.5881,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022205','Trento','Trento','','SI','L378',46.0691811,11.1218349,157.7590,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022209','Valfloriana','Valfloriana','','NO','L575',46.2501183,11.3426393,39.3877,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022210','Vallarsa','Vallarsa','','NO','L588',45.7825907,11.1181042,78.1877,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022213','Vermiglio','Vermiglio','','NO','L769',46.2988765,10.6929059,95.8261,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022216','Vignola-Falesina','Vignola-Falesina','','NO','L886',46.0444726,11.2772566,12.1661,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022222','Villa Lagarina','Villa Lagarina','','NO','L957',45.9171244,11.0310939,24.1858,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022224','Volano','Volano','','NO','M113',45.9171712,11.0606486,10.7991,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022226','Ziano di Fiemme','Ziano di Fiemme','','NO','M173',46.2864371,11.5613434,35.9239,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022228','Comano Terme','Comano Terme','','NO','M314',46.0344320,10.8706126,68.2592,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022229','Ledro','Ledro','','NO','M313',45.8887164,10.7327869,156.3585,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022230','Predaia','Predaia','','NO','M344',46.3212155,11.0653467,79.1331,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022231','San Lorenzo Dorsino','San Lorenzo Dorsino','','NO','M345',46.0772615,10.9083337,74.2174,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022232','Valdaone','Valdaone','','NO','M343',45.9467208,10.6211184,177.1923,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022233','Dimaro Folgarida','Dimaro Folgarida','','NO','M366',46.3260718,10.8742224,36.4844,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022234','Pieve di Bono-Prezzo','Pieve di Bono-Prezzo','','NO','M365',45.9389069,10.6383584,24.5592,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022235','Altavalle','Altavalle','','NO','M349',46.1808998,11.2376453,33.7391,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022236','Altopiano della Vigolana','Altopiano della Vigolana','','NO','M350',46.0049123,11.1989079,44.9491,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022237','Amblar-Don','Amblar-Don','','NO','M351',46.3897949,11.1356724,19.9460,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022238','Borgo Chiese','Borgo Chiese','','NO','M352',45.8895128,10.5980688,53.7792,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022239','Borgo Lares','Borgo Lares','','NO','M353',46.0343227,10.7497694,22.2576,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022240','Castel Ivano','Castel Ivano','','NO','M354',46.0663994,11.5235447,34.6367,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022241','Cembra Lisignago','Cembra Lisignago','','NO','M355',46.1751919,11.2205405,24.1037,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022242','Contà','Contà','','NO','M356',46.2870860,11.0349934,19.0578,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022243','Madruzzo','Madruzzo','','NO','M357',46.0242737,10.9835214,29.3921,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022244','Porte di Rendena','Porte di Rendena','','NO','M358',46.0614514,10.7120210,40.8955,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022245','Primiero San Martino di Castrozza','Primiero San Martino di Castrozza','','NO','M359',46.1763970,11.8301173,199.0346,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022246','Sella Giudicarie','Sella Giudicarie','','NO','M360',45.9840593,10.6697643,85.7179,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022247','Tre Ville','Tre Ville','','NO','M361',46.0549954,10.7803490,81.8640,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022248','Vallelaghi','Vallelaghi','','NO','M362',46.0779642,10.9993846,72.4904,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022249','Ville d\'Anaunia','Ville d\'Anaunia','','NO','M363',46.3270744,11.0236661,89.7702,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022250','San Giovanni di Fassa-Sèn Jan','San Giovanni di Fassa','Sèn Jan','NO','M390',46.4302212,11.6866100,99.3203,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022251','Terre d\'Adige','Terre d\'Adige','','NO','M407',46.1517652,11.0973158,16.3859,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022252','Borgo d\'Anaunia','Borgo d\'Anaunia','','NO','M429',46.4397606,11.1357690,63.3440,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022253','Novella','Novella','','NO','M430',46.3912405,11.0584148,46.4816,'022');
INSERT INTO `gi_comuni` VALUES ('TN','022254','Ville di Fiemme','Ville di Fiemme','','NO','M431',46.3006611,11.4478923,46.0351,'022');
INSERT INTO `gi_comuni` VALUES ('VR','023001','Affi','Affi','','NO','A061',45.5519099,10.7733561,9.9295,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023002','Albaredo d\'Adige','Albaredo d\'Adige','','NO','A137',45.3173538,11.2668649,28.2044,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023003','Angiari','Angiari','','NO','A292',45.2178721,11.2839776,13.5676,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023004','Arcole','Arcole','','NO','A374',45.3575871,11.2865322,18.6677,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023005','Badia Calavena','Badia Calavena','','NO','A540',45.5641095,11.1566127,26.7298,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023006','Bardolino','Bardolino','','NO','A650',45.5472076,10.7196587,57.4762,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023007','Belfiore','Belfiore','','NO','A737',45.3803532,11.2089989,26.3015,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023008','Bevilacqua','Bevilacqua','','NO','A837',45.2335638,11.3984142,12.2393,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023009','Bonavigo','Bonavigo','','NO','A964',45.2577438,11.2797734,18.0296,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023010','Boschi Sant\'Anna','Boschi Sant\'Anna','','NO','B070',45.2197920,11.3583521,9.3994,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023011','Bosco Chiesanuova','Bosco Chiesanuova','','NO','B073',45.6223297,11.0292177,64.9873,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023012','Bovolone','Bovolone','','NO','B107',45.2580864,11.1169939,41.5199,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023013','Brentino Belluno','Brentino Belluno','','NO','B152',45.6563250,10.8932508,25.8241,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023014','Brenzone sul Garda','Brenzone sul Garda','','NO','B154',45.7085317,10.7669327,51.6777,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023015','Bussolengo','Bussolengo','','NO','B296',45.4746833,10.8460716,24.1526,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023016','Buttapietra','Buttapietra','','NO','B304',45.3434923,10.9983363,17.4573,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023017','Caldiero','Caldiero','','NO','B402',45.4121607,11.1840619,10.4838,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023018','Caprino Veronese','Caprino Veronese','','NO','B709',45.6066044,10.7937996,47.8566,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023019','Casaleone','Casaleone','','NO','B886',45.1699003,11.2007702,38.1407,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023020','Castagnaro','Castagnaro','','NO','C041',45.1209104,11.4095821,35.0489,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023021','Castel d\'Azzano','Castel d\'Azzano','','NO','C078',45.3537764,10.9436668,9.7580,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023022','Castelnuovo del Garda','Castelnuovo del Garda','','NO','C225',45.4405876,10.7637341,34.4878,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023023','Cavaion Veronese','Cavaion Veronese','','NO','C370',45.5378429,10.7691187,12.7734,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023024','Cazzano di Tramigna','Cazzano di Tramigna','','NO','C412',45.4720130,11.2033871,12.3804,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023025','Cerea','Cerea','','NO','C498',45.1920103,11.2128455,70.2240,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023026','Cerro Veronese','Cerro Veronese','','NO','C538',45.5740280,11.0414180,10.2319,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023027','Cologna Veneta','Cologna Veneta','','NO','C890',45.3107239,11.3845338,43.0324,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023028','Colognola ai Colli','Colognola ai Colli','','NO','C897',45.4345243,11.1868625,20.6662,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023029','Concamarise','Concamarise','','NO','C943',45.2072746,11.1387413,7.8891,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023030','Costermano sul Garda','Costermano sul Garda','','NO','D118',45.5865166,10.7384415,16.5881,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023031','Dolcè','Dolcè','','NO','D317',45.5999467,10.8528852,31.0348,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023032','Erbè','Erbè','','NO','D419',45.2422529,10.9671541,16.3667,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023033','Erbezzo','Erbezzo','','NO','D420',45.6397007,11.0011490,31.4860,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023034','Ferrara di Monte Baldo','Ferrara di Monte Baldo','','NO','D549',45.6764379,10.8529728,26.5550,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023035','Fumane','Fumane','','NO','D818',45.5432218,10.8817052,34.2874,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023036','Garda','Garda','','NO','D915',45.5742356,10.7077490,14.3263,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023037','Gazzo Veronese','Gazzo Veronese','','NO','D957',45.1425964,11.1039206,57.1019,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023038','Grezzana','Grezzana','','NO','E171',45.5185461,11.0160717,49.7000,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023039','Illasi','Illasi','','NO','E284',45.4662749,11.1841327,25.1324,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023040','Isola della Scala','Isola della Scala','','NO','E349',45.2735107,11.0079035,69.5747,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023041','Isola Rizza','Isola Rizza','','NO','E358',45.2912675,11.1980509,17.0040,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023042','Lavagno','Lavagno','','NO','E489',45.4408227,11.1317891,14.4617,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023043','Lazise','Lazise','','NO','E502',45.5051321,10.7324961,63.1603,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023044','Legnago','Legnago','','NO','E512',45.1904026,11.3085626,78.6882,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023045','Malcesine','Malcesine','','NO','E848',45.7640798,10.8088719,68.9646,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023046','Marano di Valpolicella','Marano di Valpolicella','','NO','E911',45.5539130,10.9153732,18.7456,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023047','Mezzane di Sotto','Mezzane di Sotto','','NO','F172',45.4807248,11.1271034,19.8144,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023048','Minerbe','Minerbe','','NO','F218',45.2424767,11.3411093,29.7606,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023049','Montecchia di Crosara','Montecchia di Crosara','','NO','F461',45.4853462,11.2531791,20.8372,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023050','Monteforte d\'Alpone','Monteforte d\'Alpone','','NO','F508',45.4223914,11.2849456,20.3439,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023051','Mozzecane','Mozzecane','','NO','F789',45.3095639,10.8179169,24.8598,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023052','Negrar di Valpolicella','Negrar di Valpolicella','','NO','F861',45.5303636,10.9382332,40.3598,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023053','Nogara','Nogara','','NO','F918',45.1778593,11.0609083,38.5504,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023054','Nogarole Rocca','Nogarole Rocca','','NO','F921',45.2915088,10.8835887,29.6593,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023055','Oppeano','Oppeano','','NO','G080',45.3072778,11.1784606,46.3820,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023056','Palù','Palù','','NO','G297',45.3245958,11.1548079,13.8189,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023057','Pastrengo','Pastrengo','','NO','G365',45.4927196,10.7996733,8.9056,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023058','Pescantina','Pescantina','','NO','G481',45.4825653,10.8672579,19.7253,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023059','Peschiera del Garda','Peschiera del Garda','','NO','G489',45.4389318,10.6921608,18.0784,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023060','Povegliano Veronese','Povegliano Veronese','','NO','G945',45.3471272,10.8806605,18.1326,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023061','Pressana','Pressana','','NO','H048',45.2847668,11.4024443,17.2894,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023062','Rivoli Veronese','Rivoli Veronese','','NO','H356',45.5712834,10.8125835,18.2743,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023063','Roncà','Roncà','','NO','H522',45.4793873,11.2896507,18.1774,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023064','Ronco all\'Adige','Ronco all\'Adige','','NO','H540',45.3366803,11.2464761,42.8503,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023065','Roverchiara','Roverchiara','','NO','H606',45.2729034,11.2468901,19.6073,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023066','Roveredo di Guà','Roveredo di Guà','','NO','H610',45.2734384,11.4438382,10.1317,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023067','Roverè Veronese','Roverè Veronese','','NO','H608',45.5932050,11.0654830,36.3660,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023068','Salizzole','Salizzole','','NO','H714',45.2428157,11.0846585,30.6704,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023069','San Bonifacio','San Bonifacio','','NO','H783',45.3958934,11.2705049,33.9842,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023070','San Giovanni Ilarione','San Giovanni Ilarione','','NO','H916',45.5212617,11.2361401,25.4006,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023071','San Giovanni Lupatoto','San Giovanni Lupatoto','','NO','H924',45.3796632,11.0499716,19.1690,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023072','Sanguinetto','Sanguinetto','','NO','H944',45.1829497,11.1515942,13.6047,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023073','San Martino Buon Albergo','San Martino Buon Albergo','','NO','I003',45.4221859,11.0931194,34.8548,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023074','San Mauro di Saline','San Mauro di Saline','','NO','H712',45.5650297,11.1125139,11.3704,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023075','San Pietro di Morubio','San Pietro di Morubio','','NO','I105',45.2482909,11.2317448,16.0104,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023076','San Pietro in Cariano','San Pietro in Cariano','','NO','I109',45.5175977,10.8862668,20.3531,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023077','Sant\'Ambrogio di Valpolicella','Sant\'Ambrogio di Valpolicella','','NO','I259',45.5249260,10.8341696,23.4139,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023078','Sant\'Anna d\'Alfaedo','Sant\'Anna d\'Alfaedo','','NO','I292',45.6267918,10.9506810,43.4925,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023079','San Zeno di Montagna','San Zeno di Montagna','','NO','I414',45.6379333,10.7321641,28.5560,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023080','Selva di Progno','Selva di Progno','','NO','I594',45.6129959,11.1383667,41.2039,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023081','Soave','Soave','','NO','I775',45.4236004,11.2490087,23.1336,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023082','Sommacampagna','Sommacampagna','','NO','I821',45.4074130,10.8407310,41.0411,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023083','Sona','Sona','','NO','I826',45.4339925,10.8326675,41.1396,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023084','Sorgà','Sorgà','','NO','I850',45.2119461,10.9799551,31.3121,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023085','Terrazzo','Terrazzo','','NO','L136',45.1739777,11.3992151,20.5588,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023086','Torri del Benaco','Torri del Benaco','','NO','L287',45.6080223,10.6856610,45.9122,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023087','Tregnago','Tregnago','','NO','L364',45.5169363,11.1650842,37.1287,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023088','Trevenzuolo','Trevenzuolo','','NO','L396',45.2714012,10.9333178,26.7536,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023089','Valeggio sul Mincio','Valeggio sul Mincio','','NO','L567',45.3536172,10.7344034,63.7839,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023090','Velo Veronese','Velo Veronese','','NO','L722',45.6053682,11.0960150,19.0418,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023091','Verona','Verona','','SI','L781',45.4379175,10.9938661,198.7759,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023092','Veronella','Veronella','','NO','D193',45.3208235,11.3249673,20.6807,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023093','Vestenanova','Vestenanova','','NO','L810',45.5732048,11.2273150,24.3274,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023094','Vigasio','Vigasio','','NO','L869',45.3176476,10.9430248,30.7872,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023095','Villa Bartolomea','Villa Bartolomea','','NO','L912',45.1593440,11.3533973,52.7210,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023096','Villafranca di Verona','Villafranca di Verona','','NO','L949',45.3506503,10.8458927,57.3458,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023097','Zevio','Zevio','','NO','M172',45.3762798,11.1362173,54.9223,'023');
INSERT INTO `gi_comuni` VALUES ('VR','023098','Zimella','Zimella','','NO','M178',45.3639208,11.3392259,20.3436,'023');
INSERT INTO `gi_comuni` VALUES ('VI','024001','Agugliaro','Agugliaro','','NO','A093',45.3247487,11.5867096,14.9682,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024002','Albettone','Albettone','','NO','A154',45.3578410,11.5822318,20.3662,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024003','Alonte','Alonte','','NO','A220',45.3645470,11.4272569,11.4396,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024004','Altavilla Vicentina','Altavilla Vicentina','','NO','A231',45.5131507,11.4646528,16.5591,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024005','Altissimo','Altissimo','','NO','A236',45.6147625,11.2512378,15.2311,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024006','Arcugnano','Arcugnano','','NO','A377',45.4961743,11.5512513,41.5868,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024007','Arsiero','Arsiero','','NO','A444',45.8038242,11.3497040,41.5503,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024008','Arzignano','Arzignano','','NO','A459',45.5211395,11.3323459,34.1502,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024009','Asiago','Asiago','','NO','A465',45.8756867,11.5086690,162.2247,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024010','Asigliano Veneto','Asigliano Veneto','','NO','A467',45.3046899,11.4462677,8.1654,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024012','Bassano del Grappa','Bassano del Grappa','','NO','A703',45.7673367,11.7343570,46.9335,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024013','Bolzano Vicentino','Bolzano Vicentino','','NO','A954',45.6008514,11.6224664,19.7395,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024014','Breganze','Breganze','','NO','B132',45.7082809,11.5652991,21.5653,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024015','Brendola','Brendola','','NO','B143',45.4696707,11.4534115,25.2277,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024016','Bressanvido','Bressanvido','','NO','B161',45.6461630,11.6328526,8.5490,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024017','Brogliano','Brogliano','','NO','B196',45.5886529,11.3654592,12.2091,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024018','Caldogno','Caldogno','','NO','B403',45.6122915,11.5005898,16.1161,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024019','Caltrano','Caltrano','','NO','B433',45.7704785,11.4601720,22.5146,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024020','Calvene','Calvene','','NO','B441',45.7656354,11.5116068,11.6200,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024021','Camisano Vicentino','Camisano Vicentino','','NO','B485',45.5219846,11.7140053,29.5585,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024022','Campiglia dei Berici','Campiglia dei Berici','','NO','B511',45.3361939,11.5385758,11.0852,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024024','Carrè','Carrè','','NO','B835',45.7476688,11.4588357,8.5500,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024025','Cartigliano','Cartigliano','','NO','B844',45.7139333,11.6940061,7.4466,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024026','Cassola','Cassola','','NO','C037',45.7331237,11.7982861,12.7494,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024027','Castegnero','Castegnero','','NO','C056',45.4378852,11.5999313,11.2733,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024028','Castelgomberto','Castelgomberto','','NO','C119',45.5851548,11.3945924,17.2541,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024029','Chiampo','Chiampo','','NO','C605',45.5450529,11.2814224,22.6962,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024030','Chiuppano','Chiuppano','','NO','C650',45.7613656,11.4641388,4.6967,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024032','Cogollo del Cengio','Cogollo del Cengio','','NO','C824',45.7863280,11.4206591,36.5250,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024034','Cornedo Vicentino','Cornedo Vicentino','','NO','D020',45.6139068,11.3434426,23.5835,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024035','Costabissara','Costabissara','','NO','D107',45.5851831,11.4875330,13.2886,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024036','Creazzo','Creazzo','','NO','D136',45.5321472,11.4790011,10.6583,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024037','Crespadoro','Crespadoro','','NO','D156',45.6195713,11.2262542,30.2849,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024038','Dueville','Dueville','','NO','D379',45.6362183,11.5483237,19.7335,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024039','Enego','Enego','','NO','D407',45.9405126,11.7092305,52.7639,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024040','Fara Vicentino','Fara Vicentino','','NO','D496',45.7403949,11.5473874,15.3740,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024041','Foza','Foza','','NO','D750',45.8963663,11.6309769,35.1427,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024042','Gallio','Gallio','','NO','D882',45.8921830,11.5493285,48.2961,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024043','Gambellara','Gambellara','','NO','D897',45.4617531,11.3411532,12.8017,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024046','Grisignano di Zocco','Grisignano di Zocco','','NO','E184',45.4753995,11.6992936,17.7054,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024047','Grumolo delle Abbadesse','Grumolo delle Abbadesse','','NO','E226',45.5158331,11.6624322,15.0826,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024048','Isola Vicentina','Isola Vicentina','','NO','E354',45.6294461,11.4425844,26.6345,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024049','Laghi','Laghi','','NO','E403',45.8242433,11.2732926,22.2701,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024050','Lastebasse','Lastebasse','','NO','E465',45.9161519,11.2709816,18.5498,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024051','Longare','Longare','','NO','E671',45.4786943,11.6070851,22.9192,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024052','Lonigo','Lonigo','','NO','E682',45.3887612,11.3867847,48.8028,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024053','Lugo di Vicenza','Lugo di Vicenza','','NO','E731',45.7540807,11.5223689,14.8213,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024055','Malo','Malo','','NO','E864',45.6586903,11.4042994,30.3996,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024056','Marano Vicentino','Marano Vicentino','','NO','E912',45.6923580,11.4303062,12.7538,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024057','Marostica','Marostica','','NO','E970',45.7473893,11.6559215,36.2557,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024060','Montebello Vicentino','Montebello Vicentino','','NO','F442',45.4574930,11.3854989,21.4643,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024061','Montecchio Maggiore','Montecchio Maggiore','','NO','F464',45.5060202,11.4075531,30.4689,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024062','Montecchio Precalcino','Montecchio Precalcino','','NO','F465',45.6634585,11.5614929,14.4783,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024063','Monte di Malo','Monte di Malo','','NO','F486',45.6609341,11.3618731,24.0338,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024064','Montegalda','Montegalda','','NO','F514',45.4439518,11.6724410,17.0410,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024065','Montegaldella','Montegaldella','','NO','F515',45.4369720,11.6728131,13.3392,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024066','Monteviale','Monteviale','','NO','F662',45.5599798,11.4566028,8.1792,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024067','Monticello Conte Otto','Monticello Conte Otto','','NO','F675',45.5953203,11.5805304,10.1399,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024068','Montorso Vicentino','Montorso Vicentino','','NO','F696',45.4896411,11.3621649,9.4084,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024070','Mussolente','Mussolente','','NO','F829',45.7788164,11.8007713,15.3191,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024071','Nanto','Nanto','','NO','F838',45.4248194,11.5924507,14.4619,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024072','Nogarole Vicentino','Nogarole Vicentino','','NO','F922',45.5595840,11.2881754,8.9831,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024073','Nove','Nove','','NO','F957',45.7247706,11.6793546,8.2965,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024074','Noventa Vicentina','Noventa Vicentina','','NO','F964',45.2912510,11.5395561,22.9692,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024075','Orgiano','Orgiano','','NO','G095',45.3517994,11.4661503,18.0321,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024076','Pedemonte','Pedemonte','','NO','G406',45.9085706,11.3061669,12.5946,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024077','Pianezze','Pianezze','','NO','G560',45.7388750,11.6245642,5.0027,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024078','Piovene Rocchette','Piovene Rocchette','','NO','G694',45.7588651,11.4300887,12.8115,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024079','Pojana Maggiore','Pojana Maggiore','','NO','G776',45.2920721,11.5013277,28.3879,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024080','Posina','Posina','','NO','G931',45.7904588,11.2609301,43.8193,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024081','Pove del Grappa','Pove del Grappa','','NO','G943',45.7988260,11.7289807,9.8279,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024082','Pozzoleone','Pozzoleone','','NO','G957',45.6493122,11.6790718,11.1988,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024083','Quinto Vicentino','Quinto Vicentino','','NO','H134',45.5729623,11.6251904,17.3135,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024084','Recoaro Terme','Recoaro Terme','','NO','H214',45.7049788,11.2260480,60.1701,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024085','Roana','Roana','','NO','H361',45.8633161,11.4722782,77.9479,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024086','Romano d\'Ezzelino','Romano d\'Ezzelino','','NO','H512',45.7746624,11.7707139,21.5409,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024087','Rosà','Rosà','','NO','H556',45.7249403,11.7622407,24.2686,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024088','Rossano Veneto','Rossano Veneto','','NO','H580',45.7045310,11.7994258,10.6107,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024089','Rotzo','Rotzo','','NO','H594',45.8638268,11.3999520,28.4474,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024090','Salcedo','Salcedo','','NO','F810',45.7586658,11.5656067,6.1433,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024091','Sandrigo','Sandrigo','','NO','H829',45.6617718,11.6028768,28.0687,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024094','San Pietro Mussolino','San Pietro Mussolino','','NO','I117',45.5874049,11.2571208,4.0356,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024095','Santorso','Santorso','','NO','I353',45.7374649,11.3899874,13.3821,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024096','San Vito di Leguzzano','San Vito di Leguzzano','','NO','I401',45.6816835,11.3760488,6.0349,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024097','Sarcedo','Sarcedo','','NO','I425',45.7082008,11.5263699,13.9113,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024098','Sarego','Sarego','','NO','I430',45.4071249,11.4046094,24.1081,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024099','Schiavon','Schiavon','','NO','I527',45.6977167,11.6451703,12.0201,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024100','Schio','Schio','','NO','I531',45.7130770,11.3569936,65.8001,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024101','Solagna','Solagna','','NO','I783',45.8169031,11.7177505,15.7718,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024102','Sossano','Sossano','','NO','I867',45.3588878,11.5103653,20.4640,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024104','Tezze sul Brenta','Tezze sul Brenta','','NO','L156',45.6873222,11.7035351,18.0437,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024105','Thiene','Thiene','','NO','L157',45.7073550,11.4786221,19.5051,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024106','Tonezza del Cimone','Tonezza del Cimone','','NO','D717',45.8582126,11.3464822,13.9330,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024107','Torrebelvicino','Torrebelvicino','','NO','L248',45.7188669,11.3082439,20.9399,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024108','Torri di Quartesolo','Torri di Quartesolo','','NO','L297',45.5195661,11.6162872,18.8646,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024110','Trissino','Trissino','','NO','L433',45.5649209,11.3745773,22.1696,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024111','Valdagno','Valdagno','','NO','L551',45.6451460,11.2994587,50.0671,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024112','Valdastico','Valdastico','','NO','L554',45.8825612,11.3637394,23.7725,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024113','Valli del Pasubio','Valli del Pasubio','','NO','L624',45.7410722,11.2603616,48.8711,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024115','Velo d\'Astico','Velo d\'Astico','','NO','L723',45.7887810,11.3666999,21.8653,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024116','Vicenza','Vicenza','','SI','L840',45.5477021,11.5454113,80.8289,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024117','Villaga','Villaga','','NO','L952',45.4021008,11.5344366,23.2218,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024118','Villaverla','Villaverla','','NO','M032',45.6550004,11.4935830,15.8789,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024119','Zanè','Zanè','','NO','M145',45.7202870,11.4536651,7.7159,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024120','Zermeghedo','Zermeghedo','','NO','M170',45.4755592,11.3689997,2.9577,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024121','Zovencedo','Zovencedo','','NO','M194',45.4284152,11.5026209,9.1761,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024122','Zugliano','Zugliano','','NO','M199',45.7335946,11.5214183,13.6024,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024123','Val Liona','Val Liona','','NO','M384',45.4210981,11.4638462,28.1052,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024124','Barbarano Mossano','Barbarano Mossano','','NO','M401',45.4101349,11.5394798,33.4464,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024125','Valbrenta','Valbrenta','','NO','M423',45.8576957,11.6608060,93.3898,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024126','Colceresa','Colceresa','','NO','M426',45.7182167,11.6069203,19.2862,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024127','Lusiana Conco','Lusiana Conco','','NO','M427',45.7982817,11.6051891,61.1947,'024');
INSERT INTO `gi_comuni` VALUES ('VI','024128','Sovizzo','Sovizzo','','NO','M436',45.5538887,11.4343912,24.0452,'024');
INSERT INTO `gi_comuni` VALUES ('BL','025001','Agordo','Agordo','','NO','A083',46.2817715,12.0330418,23.8521,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025003','Alleghe','Alleghe','','NO','A206',46.4067101,12.0206164,29.4150,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025004','Arsiè','Arsiè','','NO','A443',45.9844055,11.7578548,64.9728,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025005','Auronzo di Cadore','Auronzo di Cadore','','NO','A501',46.5499622,12.4449302,220.4080,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025006','Belluno','Belluno','','SI','A757',46.1382162,12.2165030,147.1638,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025007','Borca di Cadore','Borca di Cadore','','NO','A982',46.4383584,12.2186670,26.6226,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025008','Calalzo di Cadore','Calalzo di Cadore','','NO','B375',46.4473463,12.3803953,43.4125,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025010','Cencenighe Agordino','Cencenighe Agordino','','NO','C458',46.3512168,11.9664536,18.3251,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025011','Cesiomaggiore','Cesiomaggiore','','NO','C577',46.0886676,11.9874111,81.6653,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025012','Chies d\'Alpago','Chies d\'Alpago','','NO','C630',46.1723775,12.3869656,44.8755,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025013','Cibiana di Cadore','Cibiana di Cadore','','NO','C672',46.3919151,12.2906347,21.3881,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025014','Colle Santa Lucia','Colle Santa Lucia','','NO','C872',46.4474444,12.0140535,15.3623,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025015','Comelico Superiore','Comelico Superiore','','NO','C920',46.5887605,12.5160324,95.7918,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025016','Cortina d\'Ampezzo','Cortina d\'Ampezzo','','NO','A266',46.5366396,12.1384911,253.1600,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025017','Danta di Cadore','Danta di Cadore','','NO','D247',46.5669502,12.5201472,8.0565,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025018','Domegge di Cadore','Domegge di Cadore','','NO','D330',46.4603058,12.4158237,50.0838,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025019','Falcade','Falcade','','NO','D470',46.3583517,11.8724672,53.1974,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025021','Feltre','Feltre','','NO','D530',46.0175889,11.9101867,100.1643,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025022','Fonzaso','Fonzaso','','NO','D686',46.0179976,11.7997209,27.5357,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025023','Canale d\'Agordo','Canale d\'Agordo','','NO','B574',46.3605465,11.9150471,45.7852,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025025','Gosaldo','Gosaldo','','NO','E113',46.2206503,11.9559592,48.5290,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025026','Lamon','Lamon','','NO','E429',46.0472759,11.7486734,54.6051,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025027','La Valle Agordina','La Valle Agordina','','NO','E490',46.2824146,12.0680897,48.8345,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025029','Limana','Limana','','NO','E588',46.0991700,12.1807741,39.0423,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025030','Livinallongo del Col di Lana','Livinallongo del Col di Lana','','NO','E622',46.4815058,11.9543975,99.8677,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025032','Lorenzago di Cadore','Lorenzago di Cadore','','NO','E687',46.4799423,12.4596805,27.3414,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025033','Lozzo di Cadore','Lozzo di Cadore','','NO','E708',46.4849058,12.4427645,30.6507,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025035','Ospitale di Cadore','Ospitale di Cadore','','NO','G169',46.3289108,12.3232592,39.3227,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025036','Pedavena','Pedavena','','NO','G404',46.0397686,11.8813978,25.1261,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025037','Perarolo di Cadore','Perarolo di Cadore','','NO','G442',46.3966496,12.3552762,44.2327,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025039','Pieve di Cadore','Pieve di Cadore','','NO','G642',46.4295398,12.3745856,67.2886,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025040','Ponte nelle Alpi','Ponte nelle Alpi','','NO','B662',46.1743601,12.3014960,57.7901,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025043','Rivamonte Agordino','Rivamonte Agordino','','NO','H327',46.2573175,12.0261986,23.0571,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025044','Rocca Pietore','Rocca Pietore','','NO','H379',46.4347251,11.9775763,73.4656,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025045','San Gregorio nelle Alpi','San Gregorio nelle Alpi','','NO','H938',46.1032856,12.0262451,19.4496,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025046','San Nicolò di Comelico','San Nicolò di Comelico','','NO','I063',46.5823189,12.5278755,24.1826,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025047','San Pietro di Cadore','San Pietro di Cadore','','NO','I088',46.5709685,12.5858700,52.2668,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025048','Santa Giustina','Santa Giustina','','NO','I206',46.0834481,12.0419725,35.5165,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025049','San Tomaso Agordino','San Tomaso Agordino','','NO','I347',46.3812489,11.9751610,19.2686,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025050','Santo Stefano di Cadore','Santo Stefano di Cadore','','NO','C919',46.5576822,12.5497265,100.7318,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025051','San Vito di Cadore','San Vito di Cadore','','NO','I392',46.4616773,12.2050545,61.6183,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025053','Sedico','Sedico','','NO','I563',46.1107838,12.0973836,91.2316,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025054','Selva di Cadore','Selva di Cadore','','NO','I592',46.4515650,12.0346619,33.2374,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025055','Seren del Grappa','Seren del Grappa','','NO','I626',45.9887217,11.8435237,61.8122,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025056','Sospirolo','Sospirolo','','NO','I866',46.1424404,12.0737477,66.1437,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025057','Soverzene','Soverzene','','NO','I876',46.2043733,12.3023080,15.0125,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025058','Sovramonte','Sovramonte','','NO','I673',46.0579741,11.7874290,50.3973,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025059','Taibon Agordino','Taibon Agordino','','NO','L030',46.2987594,12.0137265,90.2934,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025060','Tambre','Tambre','','NO','L040',46.1292708,12.4232971,45.2694,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025062','Vallada Agordina','Vallada Agordina','','NO','L584',46.3682538,11.9307859,12.8479,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025063','Valle di Cadore','Valle di Cadore','','NO','L590',46.4170826,12.3279303,40.9854,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025065','Vigo di Cadore','Vigo di Cadore','','NO','L890',46.4995336,12.4714395,69.3229,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025066','Vodo Cadore','Vodo Cadore','','NO','M108',46.4182262,12.2503919,47.0173,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025067','Voltago Agordino','Voltago Agordino','','NO','M124',46.2721188,12.0047342,23.1075,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025069','Zoppè di Cadore','Zoppè di Cadore','','NO','M189',46.3862086,12.1732565,4.2630,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025071','Longarone','Longarone','','NO','M342',46.2702254,12.2999261,122.6748,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025072','Alpago','Alpago','','NO','M375',46.1681530,12.3517195,80.1774,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025073','Val di Zoldo','Val di Zoldo','','NO','M374',46.3754275,12.1263541,141.8676,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025074','Borgo Valbelluna','Borgo Valbelluna','','NO','M421',46.0619333,12.0793453,167.7425,'025');
INSERT INTO `gi_comuni` VALUES ('BL','025075','Setteville','Setteville','','NO','M437',45.9325465,11.9067986,82.6282,'025');
INSERT INTO `gi_comuni` VALUES ('TV','026001','Altivole','Altivole','','NO','A237',45.7538739,11.9557147,21.8655,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026002','Arcade','Arcade','','NO','A360',45.7839979,12.2213960,8.0910,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026003','Asolo','Asolo','','NO','A471',45.8021819,11.9122804,25.4968,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026004','Borso del Grappa','Borso del Grappa','','NO','B061',45.8213282,11.7992237,33.1438,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026005','Breda di Piave','Breda di Piave','','NO','B128',45.7237134,12.3314674,25.8007,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026006','Caerano di San Marco','Caerano di San Marco','','NO','B349',45.7855987,12.0010506,12.1179,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026007','Cappella Maggiore','Cappella Maggiore','','NO','B678',45.9690342,12.3629441,11.2305,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026008','Carbonera','Carbonera','','NO','B744',45.6817429,12.2886687,20.1762,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026009','Casale sul Sile','Casale sul Sile','','NO','B879',45.5965265,12.3256943,26.9750,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026010','Casier','Casier','','NO','B965',45.6339825,12.2553891,13.6165,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026011','Castelcucco','Castelcucco','','NO','C073',45.8332609,11.8837296,8.9708,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026012','Castelfranco Veneto','Castelfranco Veneto','','NO','C111',45.6715874,11.9263173,51.6609,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026013','Castello di Godego','Castello di Godego','','NO','C190',45.6924172,11.8813924,18.0417,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026014','Cavaso del Tomba','Cavaso del Tomba','','NO','C384',45.8603270,11.8955725,18.7091,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026015','Cessalto','Cessalto','','NO','C580',45.7131900,12.6142451,28.2115,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026016','Chiarano','Chiarano','','NO','C614',45.7287451,12.5820102,19.6463,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026017','Cimadolmo','Cimadolmo','','NO','C689',45.7874776,12.3617875,17.9937,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026018','Cison di Valmarino','Cison di Valmarino','','NO','C735',45.9707810,12.1431667,28.9657,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026019','Codognè','Codognè','','NO','C815',45.8707064,12.4295696,21.7860,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026020','Colle Umberto','Colle Umberto','','NO','C848',45.9405759,12.3414518,13.2501,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026021','Conegliano','Conegliano','','NO','C957',45.8871590,12.2976689,36.7681,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026022','Cordignano','Cordignano','','NO','C992',45.9491657,12.4155156,26.1052,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026023','Cornuda','Cornuda','','NO','D030',45.8322163,12.0079124,12.7720,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026025','Crocetta del Montello','Crocetta del Montello','','NO','C670',45.8252052,12.0349496,26.4706,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026026','Farra di Soligo','Farra di Soligo','','NO','D505',45.9056283,12.1263592,28.2829,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026027','Follina','Follina','','NO','D654',45.9528176,12.1189877,24.4732,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026028','Fontanelle','Fontanelle','','NO','D674',45.8312342,12.4680709,35.4054,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026029','Fonte','Fonte','','NO','D680',45.7870493,11.8673381,14.7217,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026030','Fregona','Fregona','','NO','D794',46.0075533,12.3391381,42.5201,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026031','Gaiarine','Gaiarine','','NO','D854',45.8812684,12.4822421,28.7064,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026032','Giavera del Montello','Giavera del Montello','','NO','E021',45.7943792,12.1696152,19.8819,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026033','Godega di Sant\'Urbano','Godega di Sant\'Urbano','','NO','E071',45.9300780,12.3980924,24.2428,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026034','Gorgo al Monticano','Gorgo al Monticano','','NO','E092',45.7858864,12.5542236,27.4024,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026035','Istrana','Istrana','','NO','E373',45.6779637,12.1034709,26.7833,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026036','Loria','Loria','','NO','E692',45.7283480,11.8662813,23.3192,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026037','Mansuè','Mansuè','','NO','E893',45.8224410,12.5373812,27.0023,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026038','Mareno di Piave','Mareno di Piave','','NO','E940',45.8411343,12.3516332,27.5658,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026039','Maser','Maser','','NO','F009',45.8072598,11.9722633,25.7715,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026040','Maserada sul Piave','Maserada sul Piave','','NO','F012',45.7495082,12.3194344,28.5914,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026041','Meduna di Livenza','Meduna di Livenza','','NO','F088',45.8057321,12.6135545,15.2212,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026042','Miane','Miane','','NO','F190',45.9428922,12.0906756,30.7471,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026043','Mogliano Veneto','Mogliano Veneto','','NO','F269',45.5618086,12.2362803,46.0944,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026044','Monastier di Treviso','Monastier di Treviso','','NO','F332',45.6502421,12.4341934,25.5223,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026045','Monfumo','Monfumo','','NO','F360',45.8305713,11.9213811,11.5684,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026046','Montebelluna','Montebelluna','','NO','F443',45.7763260,12.0452386,48.6525,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026047','Morgano','Morgano','','NO','F725',45.6348811,12.0838041,11.6446,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026048','Moriago della Battaglia','Moriago della Battaglia','','NO','F729',45.8674075,12.1070329,13.6651,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026049','Motta di Livenza','Motta di Livenza','','NO','F770',45.7764086,12.6106789,37.4327,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026050','Nervesa della Battaglia','Nervesa della Battaglia','','NO','F872',45.8252694,12.2089674,35.2621,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026051','Oderzo','Oderzo','','NO','F999',45.7808901,12.4931568,42.3576,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026052','Ormelle','Ormelle','','NO','G115',45.7787337,12.4201979,18.9352,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026053','Orsago','Orsago','','NO','G123',45.9312958,12.4237806,10.8179,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026055','Paese','Paese','','NO','G229',45.6715412,12.1536037,37.8806,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026056','Pederobba','Pederobba','','NO','G408',45.8599644,11.9860486,26.7449,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026057','Pieve di Soligo','Pieve di Soligo','','NO','G645',45.8992115,12.1730953,19.0486,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026058','Ponte di Piave','Ponte di Piave','','NO','G846',45.7160448,12.4639508,32.1867,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026059','Ponzano Veneto','Ponzano Veneto','','NO','G875',45.7165447,12.2016124,22.3420,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026060','Portobuffolè','Portobuffolè','','NO','G909',45.8540122,12.5381387,5.3256,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026061','Possagno','Possagno','','NO','G933',45.8544918,11.8810147,12.1506,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026062','Povegliano','Povegliano','','NO','G944',45.7601512,12.2061028,13.2914,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026063','Preganziol','Preganziol','','NO','H022',45.6023388,12.2355498,22.7373,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026064','Quinto di Treviso','Quinto di Treviso','','NO','H131',45.6459097,12.1659991,18.8237,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026065','Refrontolo','Refrontolo','','NO','H220',45.9253601,12.2079595,12.7195,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026066','Resana','Resana','','NO','H238',45.6343394,11.9555481,24.8141,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026067','Revine Lago','Revine Lago','','NO','H253',45.9869862,12.2187601,18.8571,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026068','Riese Pio X','Riese Pio X','','NO','H280',45.7296409,11.9168175,30.6642,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026069','Roncade','Roncade','','NO','H523',45.6305412,12.3746102,61.8713,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026070','Salgareda','Salgareda','','NO','H706',45.7037888,12.4946401,27.6620,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026071','San Biagio di Callalta','San Biagio di Callalta','','NO','H781',45.6850589,12.3772478,48.0597,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026072','San Fior','San Fior','','NO','H843',45.9211646,12.3580363,17.8029,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026073','San Pietro di Feletto','San Pietro di Feletto','','NO','I103',45.9130645,12.2508368,19.0185,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026074','San Polo di Piave','San Polo di Piave','','NO','I124',45.7913673,12.3944202,20.6610,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026075','Santa Lucia di Piave','Santa Lucia di Piave','','NO','I221',45.8491413,12.2847025,20.0627,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026076','San Vendemiano','San Vendemiano','','NO','I382',45.8914139,12.3389811,18.3396,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026077','San Zenone degli Ezzelini','San Zenone degli Ezzelini','','NO','I417',45.7787833,11.8399672,19.9753,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026078','Sarmede','Sarmede','','NO','I435',45.9787128,12.3867774,18.0691,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026079','Segusino','Segusino','','NO','I578',45.9168419,11.9540856,18.0591,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026080','Sernaglia della Battaglia','Sernaglia della Battaglia','','NO','I635',45.8725267,12.1319975,20.0273,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026081','Silea','Silea','','NO','F116',45.6557233,12.2993726,18.5938,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026082','Spresiano','Spresiano','','NO','I927',45.7793816,12.2594009,25.9521,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026083','Susegana','Susegana','','NO','L014',45.8506881,12.2490277,44.2181,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026084','Tarzo','Tarzo','','NO','L058',45.9733053,12.2321836,23.8275,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026085','Trevignano','Trevignano','','NO','L402',45.7427447,12.0892400,26.6667,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026086','Treviso','Treviso','','SI','L407',45.6675463,12.2454788,55.8852,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026087','Valdobbiadene','Valdobbiadene','','NO','L565',45.9014209,11.9959884,63.3296,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026088','Vazzola','Vazzola','','NO','L700',45.8376929,12.3791525,26.4411,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026089','Vedelago','Vedelago','','NO','L706',45.6870778,12.0183158,61.9736,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026090','Vidor','Vidor','','NO','L856',45.8616008,12.0398381,13.3571,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026091','Villorba','Villorba','','NO','M048',45.7129407,12.2600954,30.3819,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026092','Vittorio Veneto','Vittorio Veneto','','NO','M089',45.9898877,12.2961845,83.0425,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026093','Volpago del Montello','Volpago del Montello','','NO','M118',45.7784697,12.1194690,44.6959,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026094','Zenson di Piave','Zenson di Piave','','NO','M163',45.6781775,12.4917658,9.3231,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026095','Zero Branco','Zero Branco','','NO','M171',45.6009417,12.1649401,26.2019,'026');
INSERT INTO `gi_comuni` VALUES ('TV','026096','Pieve del Grappa','Pieve del Grappa','','NO','M422',45.8273500,11.8387604,37.3929,'026');
INSERT INTO `gi_comuni` VALUES ('VE','027001','Annone Veneto','Annone Veneto','','NO','A302',45.7940231,12.6827581,26.3948,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027002','Campagna Lupia','Campagna Lupia','','NO','B493',45.3536777,12.0982799,87.6679,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027003','Campolongo Maggiore','Campolongo Maggiore','','NO','B546',45.3315428,12.0492324,23.6846,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027004','Camponogara','Camponogara','','NO','B554',45.3850823,12.0724762,21.3074,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027005','Caorle','Caorle','','NO','B642',45.5979212,12.8876859,153.7996,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027006','Cavarzere','Cavarzere','','NO','C383',45.1365177,12.0839843,139.9987,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027007','Ceggia','Ceggia','','NO','C422',45.6864373,12.6369876,22.4323,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027008','Chioggia','Chioggia','','NO','C638',45.2200243,12.2794625,188.3373,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027009','Cinto Caomaggiore','Cinto Caomaggiore','','NO','C714',45.8257422,12.7851999,21.4741,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027010','Cona','Cona','','NO','C938',45.1929582,12.0391670,65.4524,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027011','Concordia Sagittaria','Concordia Sagittaria','','NO','C950',45.7556268,12.8462659,67.2230,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027012','Dolo','Dolo','','NO','D325',45.4260089,12.0743406,24.3462,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027013','Eraclea','Eraclea','','NO','D415',45.5756996,12.6734182,95.7592,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027014','Fiesso d\'Artico','Fiesso d\'Artico','','NO','D578',45.4164840,12.0305566,6.5839,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027015','Fossalta di Piave','Fossalta di Piave','','NO','D740',45.6457628,12.5113163,9.8285,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027016','Fossalta di Portogruaro','Fossalta di Portogruaro','','NO','D741',45.7927318,12.9072729,30.8777,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027017','Fossò','Fossò','','NO','D748',45.3858643,12.0482008,10.1411,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027018','Gruaro','Gruaro','','NO','E215',45.8307460,12.8393824,17.5027,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027019','Jesolo','Jesolo','','NO','C388',45.5338649,12.6410918,97.0229,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027020','Marcon','Marcon','','NO','E936',45.5545056,12.2994262,26.0368,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027021','Martellago','Martellago','','NO','E980',45.5465334,12.1596472,20.0530,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027022','Meolo','Meolo','','NO','F130',45.6197007,12.4529792,26.6472,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027023','Mira','Mira','','NO','F229',45.4328132,12.1234186,98.8115,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027024','Mirano','Mirano','','NO','F241',45.4929145,12.1088960,45.8081,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027025','Musile di Piave','Musile di Piave','','NO','F826',45.6224382,12.5637438,45.1214,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027026','Noale','Noale','','NO','F904',45.5502071,12.0702096,24.8296,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027027','Noventa di Piave','Noventa di Piave','','NO','F963',45.6625705,12.5299436,18.0199,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027028','Pianiga','Pianiga','','NO','G565',45.4554957,12.0299801,19.9882,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027029','Portogruaro','Portogruaro','','NO','G914',45.7756676,12.8371753,102.5526,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027030','Pramaggiore','Pramaggiore','','NO','G981',45.8127376,12.7364460,24.2716,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027031','Quarto d\'Altino','Quarto d\'Altino','','NO','H117',45.5803036,12.3706731,28.2255,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027032','Salzano','Salzano','','NO','H735',45.5216937,12.0989403,17.3031,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027033','San Donà di Piave','San Donà di Piave','','NO','H823',45.6297319,12.5637034,78.2728,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027034','San Michele al Tagliamento','San Michele al Tagliamento','','NO','I040',45.7639594,12.9948339,115.1922,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027035','Santa Maria di Sala','Santa Maria di Sala','','NO','I242',45.5051417,12.0351233,27.9029,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027036','San Stino di Livenza','San Stino di Livenza','','NO','I373',45.7308554,12.6802294,68.0578,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027037','Scorzè','Scorzè','','NO','I551',45.5718500,12.1088439,33.6047,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027038','Spinea','Spinea','','NO','I908',45.4915494,12.1647165,14.7805,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027039','Stra','Stra','','NO','I965',45.4068917,12.0084054,8.9752,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027040','Teglio Veneto','Teglio Veneto','','NO','L085',45.8157656,12.8839192,11.4151,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027041','Torre di Mosto','Torre di Mosto','','NO','L267',45.6910966,12.7101774,37.9907,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027042','Venezia','Venezia','','SI','L736',45.4349413,12.3384837,418.5551,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027043','Vigonovo','Vigonovo','','NO','L899',45.3853362,12.0074471,12.9426,'227');
INSERT INTO `gi_comuni` VALUES ('VE','027044','Cavallino-Treporti','Cavallino-Treporti','','NO','M308',45.4537229,12.4538185,45.1803,'227');
INSERT INTO `gi_comuni` VALUES ('PD','028001','Abano Terme','Abano Terme','','NO','A001',45.3593736,11.7886941,21.3082,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028002','Agna','Agna','','NO','A075',45.1699726,11.9566924,18.8217,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028003','Albignasego','Albignasego','','NO','A161',45.3456914,11.8740900,21.2924,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028004','Anguillara Veneta','Anguillara Veneta','','NO','A296',45.1389226,11.8858494,21.6966,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028005','Arquà Petrarca','Arquà Petrarca','','NO','A434',45.2699824,11.7161795,12.8229,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028006','Arre','Arre','','NO','A438',45.2159215,11.9317163,12.4907,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028007','Arzergrande','Arzergrande','','NO','A458',45.2730830,12.0467403,13.7028,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028008','Bagnoli di Sopra','Bagnoli di Sopra','','NO','A568',45.1848460,11.8812222,34.7944,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028009','Baone','Baone','','NO','A613',45.2444990,11.6882190,24.3687,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028010','Barbona','Barbona','','NO','A637',45.1066863,11.6605915,8.9320,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028011','Battaglia Terme','Battaglia Terme','','NO','A714',45.2891277,11.7816731,6.1824,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028012','Boara Pisani','Boara Pisani','','NO','A906',45.1072651,11.7836132,16.8585,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028013','Borgoricco','Borgoricco','','NO','B031',45.5339278,11.9694033,20.5598,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028014','Bovolenta','Bovolenta','','NO','B106',45.2690157,11.9409464,22.7174,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028015','Brugine','Brugine','','NO','B213',45.2983020,11.9927024,19.7925,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028016','Cadoneghe','Cadoneghe','','NO','B345',45.4481918,11.9099715,12.8575,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028017','Campodarsego','Campodarsego','','NO','B524',45.5024466,11.9072475,25.8512,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028018','Campodoro','Campodoro','','NO','B531',45.4933902,11.7516419,11.3018,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028019','Camposampiero','Camposampiero','','NO','B563',45.5720016,11.9319171,21.0646,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028020','Campo San Martino','Campo San Martino','','NO','B564',45.5474151,11.8117903,13.0947,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028021','Candiana','Candiana','','NO','B589',45.2203336,11.9912322,21.8741,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028023','Carmignano di Brenta','Carmignano di Brenta','','NO','B795',45.6290042,11.6995169,14.6173,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028026','Cartura','Cartura','','NO','B848',45.2681015,11.8625604,15.8371,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028027','Casale di Scodosia','Casale di Scodosia','','NO','B877',45.1883557,11.4663473,21.2604,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028028','Casalserugo','Casalserugo','','NO','B912',45.3162828,11.9148408,15.3389,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028029','Castelbaldo','Castelbaldo','','NO','C057',45.1207501,11.4530020,15.2728,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028030','Cervarese Santa Croce','Cervarese Santa Croce','','NO','C544',45.4030512,11.6922243,18.0199,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028031','Cinto Euganeo','Cinto Euganeo','','NO','C713',45.2915499,11.6614669,19.6546,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028032','Cittadella','Cittadella','','NO','C743',45.6480074,11.7815446,36.3543,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028033','Codevigo','Codevigo','','NO','C812',45.2677964,12.1003422,70.3569,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028034','Conselve','Conselve','','NO','C964',45.2325197,11.8759071,24.3629,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028035','Correzzola','Correzzola','','NO','D040',45.2368128,12.0665058,42.3092,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028036','Curtarolo','Curtarolo','','NO','D226',45.5220050,11.8325388,14.8864,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028037','Este','Este','','NO','D442',45.2279980,11.6564243,32.4956,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028038','Fontaniva','Fontaniva','','NO','D679',45.6364672,11.7528826,20.7795,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028039','Galliera Veneta','Galliera Veneta','','NO','D879',45.6626856,11.8278176,8.9866,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028040','Galzignano Terme','Galzignano Terme','','NO','D889',45.3085983,11.7282983,18.2085,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028041','Gazzo','Gazzo','','NO','D956',45.5824970,11.7074268,22.9186,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028042','Grantorto','Grantorto','','NO','E145',45.5990319,11.7309660,14.5227,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028043','Granze','Granze','','NO','E146',45.1542916,11.7132881,11.7541,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028044','Legnaro','Legnaro','','NO','E515',45.3436896,11.9628273,15.1774,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028045','Limena','Limena','','NO','E592',45.4787314,11.8440473,14.9080,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028046','Loreggia','Loreggia','','NO','E684',45.5882583,11.9440215,19.0103,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028047','Lozzo Atestino','Lozzo Atestino','','NO','E709',45.2911491,11.6312793,24.3478,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028048','Maserà di Padova','Maserà di Padova','','NO','F011',45.3200845,11.8636084,17.5982,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028049','Masi','Masi','','NO','F013',45.1090097,11.4902332,13.6364,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028050','Massanzago','Massanzago','','NO','F033',45.5552335,12.0045455,13.0591,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028052','Megliadino San Vitale','Megliadino San Vitale','','NO','F092',45.1921626,11.5238627,15.3828,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028053','Merlara','Merlara','','NO','F148',45.1677457,11.4419112,21.4002,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028054','Mestrino','Mestrino','','NO','F161',45.4435790,11.7582195,18.6769,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028055','Monselice','Monselice','','NO','F382',45.2393526,11.7508737,49.9163,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028056','Montagnana','Montagnana','','NO','F394',45.2316688,11.4669891,45.0501,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028057','Montegrotto Terme','Montegrotto Terme','','NO','F529',45.3318135,11.7835019,15.5987,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028058','Noventa Padovana','Noventa Padovana','','NO','F962',45.4160943,11.9527692,6.9526,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028059','Ospedaletto Euganeo','Ospedaletto Euganeo','','NO','G167',45.2230957,11.6105400,21.4274,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028060','Padova','Padova','','SI','G224',45.4070200,11.8763460,92.8123,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028061','Pernumia','Pernumia','','NO','G461',45.2568490,11.7870934,13.5384,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028062','Piacenza d\'Adige','Piacenza d\'Adige','','NO','G534',45.1273638,11.5473435,18.1944,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028063','Piazzola sul Brenta','Piazzola sul Brenta','','NO','G587',45.5418147,11.7867559,40.5461,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028064','Piombino Dese','Piombino Dese','','NO','G688',45.6081136,11.9981300,29.5004,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028065','Piove di Sacco','Piove di Sacco','','NO','G693',45.2959033,12.0349722,35.5793,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028066','Polverara','Polverara','','NO','G802',45.3104322,11.9570152,9.8288,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028067','Ponso','Ponso','','NO','G823',45.1918266,11.5871579,10.9315,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028068','Pontelongo','Pontelongo','','NO','G850',45.2503308,12.0194985,10.7468,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028069','Ponte San Nicolò','Ponte San Nicolò','','NO','G855',45.3640106,11.9310479,13.6238,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028070','Pozzonovo','Pozzonovo','','NO','G963',45.1974147,11.7917908,24.6088,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028071','Rovolon','Rovolon','','NO','H622',45.3858134,11.6519477,27.6992,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028072','Rubano','Rubano','','NO','H625',45.4264765,11.7867584,14.3450,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028073','Saccolongo','Saccolongo','','NO','H655',45.4060501,11.7436702,13.8791,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028075','San Giorgio delle Pertiche','San Giorgio delle Pertiche','','NO','H893',45.5420107,11.9099845,18.8443,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028076','San Giorgio in Bosco','San Giorgio in Bosco','','NO','H897',45.5925886,11.8068173,28.3594,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028077','San Martino di Lupari','San Martino di Lupari','','NO','I008',45.6505371,11.8534580,24.1258,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028078','San Pietro in Gu','San Pietro in Gu','','NO','I107',45.6135021,11.6692650,17.5881,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028079','San Pietro Viminario','San Pietro Viminario','','NO','I120',45.2453762,11.8181660,13.4361,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028080','Santa Giustina in Colle','Santa Giustina in Colle','','NO','I207',45.5636454,11.9061438,17.7568,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028082','Sant\'Angelo di Piove di Sacco','Sant\'Angelo di Piove di Sacco','','NO','I275',45.3457135,12.0077348,13.8490,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028083','Sant\'Elena','Sant\'Elena','','NO','I319',45.1859564,11.7117989,9.0260,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028084','Sant\'Urbano','Sant\'Urbano','','NO','I375',45.1131590,11.6199118,31.4508,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028085','Saonara','Saonara','','NO','I418',45.3717891,11.9841250,13.1953,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028086','Selvazzano Dentro','Selvazzano Dentro','','NO','I595',45.3950699,11.7799055,19.7777,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028087','Solesino','Solesino','','NO','I799',45.1777954,11.7433027,10.0076,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028088','Stanghella','Stanghella','','NO','I938',45.1349536,11.7564874,19.8107,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028089','Teolo','Teolo','','NO','L100',45.3665997,11.7085695,31.0140,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028090','Terrassa Padovana','Terrassa Padovana','','NO','L132',45.2461133,11.9039443,15.0569,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028091','Tombolo','Tombolo','','NO','L199',45.6475384,11.8251459,11.0090,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028092','Torreglia','Torreglia','','NO','L270',45.3360586,11.7244874,18.9594,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028093','Trebaseleghe','Trebaseleghe','','NO','L349',45.5918998,12.0512531,30.7692,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028094','Tribano','Tribano','','NO','L414',45.2110881,11.8338334,19.1794,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028095','Urbana','Urbana','','NO','L497',45.1908147,11.4435110,17.0470,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028096','Veggiano','Veggiano','','NO','L710',45.4480174,11.7139960,16.5287,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028097','Vescovana','Vescovana','','NO','L805',45.1341127,11.7084384,22.1672,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028099','Vigodarzere','Vigodarzere','','NO','L892',45.4612450,11.8785437,20.0024,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028100','Vigonza','Vigonza','','NO','L900',45.4435720,11.9830286,33.3014,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028101','Villa del Conte','Villa del Conte','','NO','L934',45.5836874,11.8600757,17.3499,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028102','Villa Estense','Villa Estense','','NO','L937',45.1721350,11.6675634,16.1259,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028103','Villafranca Padovana','Villafranca Padovana','','NO','L947',45.4952060,11.7973426,24.3180,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028104','Villanova di Camposampiero','Villanova di Camposampiero','','NO','L979',45.4896640,11.9726346,12.0379,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028105','Vo\'','Vo\'','','NO','M103',45.3287327,11.6414012,19.9851,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028106','Due Carrare','Due Carrare','','NO','M300',45.2914273,11.8210716,26.7023,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028107','Borgo Veneto','Borgo Veneto','','NO','M402',45.2275937,11.5332921,39.1983,'028');
INSERT INTO `gi_comuni` VALUES ('PD','028108','Santa Caterina d\'Este','Santa Caterina d\'Este','','NO','M438',45.1734864,11.6179968,26.7330,'028');
INSERT INTO `gi_comuni` VALUES ('RO','029001','Adria','Adria','','NO','A059',45.0548809,12.0573027,112.9198,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029002','Ariano nel Polesine','Ariano nel Polesine','','NO','A400',44.9452072,12.1211296,81.5019,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029003','Arquà Polesine','Arquà Polesine','','NO','A435',45.0103199,11.7409732,19.6531,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029004','Badia Polesine','Badia Polesine','','NO','A539',45.0943205,11.4916410,44.2749,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029005','Bagnolo di Po','Bagnolo di Po','','NO','A574',45.0152408,11.5001500,21.1962,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029006','Bergantino','Bergantino','','NO','A795',45.0603591,11.2531327,17.9104,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029007','Bosaro','Bosaro','','NO','B069',45.0006374,11.7645909,6.2711,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029008','Calto','Calto','','NO','B432',44.9917214,11.3560167,10.7701,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029009','Canaro','Canaro','','NO','B578',44.9351380,11.6772942,32.7603,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029010','Canda','Canda','','NO','B582',45.0340388,11.5085095,14.4207,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029011','Castelguglielmo','Castelguglielmo','','NO','C122',45.0255254,11.5370696,22.2121,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029012','Castelmassa','Castelmassa','','NO','C207',45.0174698,11.3101995,11.7941,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029013','Castelnovo Bariano','Castelnovo Bariano','','NO','C215',45.0269920,11.2869645,38.1564,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029014','Ceneselli','Ceneselli','','NO','C461',45.0132767,11.3693465,28.6124,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029015','Ceregnano','Ceregnano','','NO','C500',45.0502613,11.8700305,30.1045,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029017','Corbola','Corbola','','NO','C987',45.0057413,12.0774201,18.5711,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029018','Costa di Rovigo','Costa di Rovigo','','NO','D105',45.0485049,11.6941782,16.0579,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029019','Crespino','Crespino','','NO','D161',44.9830747,11.8865657,31.8594,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029021','Ficarolo','Ficarolo','','NO','D568',44.9518662,11.4325932,17.9693,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029022','Fiesso Umbertiano','Fiesso Umbertiano','','NO','D577',44.9615450,11.6056553,27.4695,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029023','Frassinelle Polesine','Frassinelle Polesine','','NO','D776',44.9969399,11.6975404,21.5532,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029024','Fratta Polesine','Fratta Polesine','','NO','D788',45.0318474,11.6407506,20.7995,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029025','Gaiba','Gaiba','','NO','D855',44.9485059,11.4812242,12.1276,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029026','Gavello','Gavello','','NO','D942',45.0216539,11.9146635,24.4759,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029027','Giacciano con Baruchella','Giacciano con Baruchella','','NO','E008',45.0670859,11.4527301,18.4971,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029028','Guarda Veneta','Guarda Veneta','','NO','E240',44.9798280,11.8025827,17.1778,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029029','Lendinara','Lendinara','','NO','E522',45.0834254,11.5986852,55.4427,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029030','Loreo','Loreo','','NO','E689',45.0634449,12.1891561,40.0819,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029031','Lusia','Lusia','','NO','E761',45.0995335,11.6640779,17.9271,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029032','Melara','Melara','','NO','F095',45.0616604,11.1973972,17.5548,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029033','Occhiobello','Occhiobello','','NO','F994',44.9197709,11.5791937,32.1246,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029034','Papozze','Papozze','','NO','G323',44.9878877,12.0313213,21.5955,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029035','Pettorazza Grimani','Pettorazza Grimani','','NO','G525',45.1349263,11.9903457,21.5130,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029036','Pincara','Pincara','','NO','G673',44.9929733,11.6113255,17.7583,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029037','Polesella','Polesella','','NO','G782',44.9627208,11.7552902,16.5191,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029038','Pontecchio Polesine','Pontecchio Polesine','','NO','G836',45.0191531,11.8116477,11.5768,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029039','Porto Tolle','Porto Tolle','','NO','G923',44.9524057,12.3342179,259.8160,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029040','Rosolina','Rosolina','','NO','H573',45.0759427,12.2461188,75.3478,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029041','Rovigo','Rovigo','','SI','H620',45.0710925,11.7901339,108.7430,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029042','Salara','Salara','','NO','H689',44.9836926,11.4251908,14.3908,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029043','San Bellino','San Bellino','','NO','H768',45.0286420,11.5890383,16.0524,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029044','San Martino di Venezze','San Martino di Venezze','','NO','H996',45.1313259,11.8687491,31.1689,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029045','Stienta','Stienta','','NO','I953',44.9380089,11.5438526,23.9518,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029046','Taglio di Po','Taglio di Po','','NO','L026',45.0078743,12.2087365,78.6482,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029047','Trecenta','Trecenta','','NO','L359',45.0307141,11.4611120,34.8668,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029048','Villadose','Villadose','','NO','L939',45.0737272,11.8892666,31.9784,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029049','Villamarzana','Villamarzana','','NO','L967',45.0142696,11.6934669,14.4497,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029050','Villanova del Ghebbo','Villanova del Ghebbo','','NO','L985',45.0554063,11.6450651,11.5899,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029051','Villanova Marchesana','Villanova Marchesana','','NO','L988',44.9912263,11.9666006,18.0962,'029');
INSERT INTO `gi_comuni` VALUES ('RO','029052','Porto Viro','Porto Viro','','NO','G926',45.0263390,12.2182863,134.2519,'029');
INSERT INTO `gi_comuni` VALUES ('UD','030001','Aiello del Friuli','Aiello del Friuli','','NO','A103',45.8706935,13.3621945,13.4382,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030002','Amaro','Amaro','','NO','A254',46.3737679,13.0957077,33.2387,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030003','Ampezzo','Ampezzo','','NO','A267',46.4167220,12.7945769,73.3237,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030004','Aquileia','Aquileia','','NO','A346',45.7664990,13.3651526,37.5824,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030005','Arta Terme','Arta Terme','','NO','A447',46.4729248,13.0249050,42.7646,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030006','Artegna','Artegna','','NO','A448',46.2418585,13.1559996,11.3836,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030007','Attimis','Attimis','','NO','A491',46.1888082,13.3051415,33.4964,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030008','Bagnaria Arsa','Bagnaria Arsa','','NO','A553',45.8879568,13.3014201,18.7975,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030009','Basiliano','Basiliano','','NO','A700',46.0158327,13.1068022,42.5993,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030010','Bertiolo','Bertiolo','','NO','A810',45.9435991,13.0550942,26.5755,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030011','Bicinicco','Bicinicco','','NO','A855',45.9312480,13.2496330,15.9995,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030012','Bordano','Bordano','','NO','A983',46.3153810,13.1060039,14.8947,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030013','Buja','Buja','','NO','B259',46.2091174,13.1256971,25.6886,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030014','Buttrio','Buttrio','','NO','B309',46.0131143,13.3306289,17.6558,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030015','Camino al Tagliamento','Camino al Tagliamento','','NO','B483',45.9271655,12.9440574,22.4242,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030016','Campoformido','Campoformido','','NO','B536',46.0198972,13.1601115,21.8555,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030018','Carlino','Carlino','','NO','B788',45.8018017,13.1880662,29.9377,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030019','Cassacco','Cassacco','','NO','B994',46.1739443,13.1862703,11.7766,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030020','Castions di Strada','Castions di Strada','','NO','C327',45.9085447,13.1849332,32.6102,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030021','Cavazzo Carnico','Cavazzo Carnico','','NO','C389',46.3672565,13.0410374,39.5168,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030022','Cercivento','Cercivento','','NO','C494',46.5271816,12.9877567,15.8350,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030023','Cervignano del Friuli','Cervignano del Friuli','','NO','C556',45.8234677,13.3343357,29.5762,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030024','Chiopris-Viscone','Chiopris-Viscone','','NO','C641',45.9245255,13.4027729,8.9063,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030025','Chiusaforte','Chiusaforte','','NO','C656',46.4082254,13.3107517,99.7389,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030026','Cividale del Friuli','Cividale del Friuli','','NO','C758',46.0929379,13.4309580,50.9091,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030027','Codroipo','Codroipo','','NO','C817',45.9616945,12.9772079,74.9000,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030028','Colloredo di Monte Albano','Colloredo di Monte Albano','','NO','C885',46.1635000,13.1365043,21.9005,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030029','Comeglians','Comeglians','','NO','C918',46.5137743,12.8676016,19.1379,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030030','Corno di Rosazzo','Corno di Rosazzo','','NO','D027',45.9966278,13.4415942,12.7002,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030031','Coseano','Coseano','','NO','D085',46.0969525,13.0187350,23.8174,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030032','Dignano','Dignano','','NO','D300',46.0874314,12.9380670,27.8842,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030033','Dogna','Dogna','','NO','D316',46.4476642,13.3159533,70.4054,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030034','Drenchia','Drenchia','','NO','D366',46.1753124,13.6221992,12.4457,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030035','Enemonzo','Enemonzo','','NO','D408',46.4104445,12.8792528,23.2248,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030036','Faedis','Faedis','','NO','D455',46.1527461,13.3440843,46.6872,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030037','Fagagna','Fagagna','','NO','D461',46.1131327,13.0839970,37.0558,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030039','Flaibano','Flaibano','','NO','D630',46.0586724,12.9836840,17.2400,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030040','Forni Avoltri','Forni Avoltri','','NO','D718',46.5845083,12.7784400,80.7073,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030041','Forni di Sopra','Forni di Sopra','','NO','D719',46.4238035,12.5785614,81.8981,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030042','Forni di Sotto','Forni di Sotto','','NO','D720',46.3936248,12.6717915,93.5235,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030043','Gemona del Friuli','Gemona del Friuli','','NO','D962',46.2768996,13.1397315,56.3281,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030044','Gonars','Gonars','','NO','E083',45.8966233,13.2362607,19.7357,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030045','Grimacco','Grimacco','','NO','E179',46.1565447,13.5936486,15.6668,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030046','Latisana','Latisana','','NO','E473',45.7762603,12.9953168,37.6037,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030047','Lauco','Lauco','','NO','E476',46.4241786,12.9331387,34.9157,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030048','Lestizza','Lestizza','','NO','E553',45.9578189,13.1411030,34.4636,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030049','Lignano Sabbiadoro','Lignano Sabbiadoro','','NO','E584',45.6889113,13.1292478,15.7089,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030051','Lusevera','Lusevera','','NO','E760',46.2647409,13.2603193,52.8851,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030052','Magnano in Riviera','Magnano in Riviera','','NO','E820',46.2309874,13.1775829,8.2293,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030053','Majano','Majano','','NO','E833',46.1852379,13.0690561,28.5961,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030054','Malborghetto Valbruna','Malborghetto Valbruna','','NO','E847',46.5075371,13.4392782,124.4550,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030055','Manzano','Manzano','','NO','E899',45.9895658,13.3851951,31.0776,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030056','Marano Lagunare','Marano Lagunare','','NO','E910',45.7654010,13.1673802,86.7330,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030057','Martignacco','Martignacco','','NO','E982',46.0982242,13.1304382,26.9590,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030058','Mereto di Tomba','Mereto di Tomba','','NO','F144',46.0511519,13.0485614,27.4896,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030059','Moggio Udinese','Moggio Udinese','','NO','F266',46.4104436,13.1947629,142.2862,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030060','Moimacco','Moimacco','','NO','F275',46.0917947,13.3809387,11.9047,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030061','Montenars','Montenars','','NO','F574',46.2567020,13.1805473,20.4609,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030062','Mortegliano','Mortegliano','','NO','F756',45.9450334,13.1722080,30.3439,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030063','Moruzzo','Moruzzo','','NO','F760',46.1196634,13.1235749,17.7251,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030064','Muzzana del Turgnano','Muzzana del Turgnano','','NO','F832',45.8175715,13.1278044,24.2301,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030065','Nimis','Nimis','','NO','F898',46.2012857,13.2658476,33.6952,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030066','Osoppo','Osoppo','','NO','G163',46.2566988,13.0804590,22.3636,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030067','Ovaro','Ovaro','','NO','G198',46.4832996,12.8655099,58.2266,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030068','Pagnacco','Pagnacco','','NO','G238',46.1240621,13.1881417,14.8914,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030069','Palazzolo dello Stella','Palazzolo dello Stella','','NO','G268',45.8045032,13.0794296,34.9780,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030070','Palmanova','Palmanova','','NO','G284',45.9044411,13.3094918,13.4477,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030071','Paluzza','Paluzza','','NO','G300',46.5296263,13.0163773,69.9713,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030072','Pasian di Prato','Pasian di Prato','','NO','G352',46.0491717,13.1908126,15.5613,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030073','Paularo','Paularo','','NO','G381',46.5303787,13.1163523,84.1714,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030074','Pavia di Udine','Pavia di Udine','','NO','G389',45.9775563,13.2816710,34.7927,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030075','Pocenia','Pocenia','','NO','G743',45.8371461,13.0981559,24.4770,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030076','Pontebba','Pontebba','','NO','G831',46.5060930,13.3039405,99.9731,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030077','Porpetto','Porpetto','','NO','G891',45.8585338,13.2148221,17.6339,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030078','Povoletto','Povoletto','','NO','G949',46.1185191,13.2985727,38.3022,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030079','Pozzuolo del Friuli','Pozzuolo del Friuli','','NO','G966',45.9846802,13.1966103,34.0238,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030080','Pradamano','Pradamano','','NO','G969',46.0312496,13.2992839,16.0171,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030081','Prato Carnico','Prato Carnico','','NO','H002',46.5204965,12.7982076,81.8720,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030082','Precenicco','Precenicco','','NO','H014',45.7899524,13.0785037,27.2281,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030083','Premariacco','Premariacco','','NO','H029',46.0602378,13.3940439,39.5794,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030084','Preone','Preone','','NO','H038',46.3954015,12.8677043,22.3890,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030085','Prepotto','Prepotto','','NO','H040',46.0461019,13.4794808,33.0774,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030086','Pulfero','Pulfero','','NO','H089',46.1734124,13.4854184,48.3908,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030087','Ragogna','Ragogna','','NO','H161',46.1775594,12.9783372,22.2029,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030088','Ravascletto','Ravascletto','','NO','H196',46.5256001,12.9221136,26.5891,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030089','Raveo','Raveo','','NO','H200',46.4346050,12.8701577,12.9961,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030090','Reana del Rojale','Reana del Rojale','','NO','H206',46.1496730,13.2427805,20.1152,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030091','Remanzacco','Remanzacco','','NO','H229',46.0853376,13.3244494,30.6830,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030092','Resia','Resia','','NO','H242',46.3732604,13.3051004,119.3705,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030093','Resiutta','Resiutta','','NO','H244',46.3930891,13.2202549,20.3924,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030094','Rigolato','Rigolato','','NO','H289',46.5498463,12.8535885,30.7485,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030095','Rive d\'Arcano','Rive d\'Arcano','','NO','H347',46.1262629,13.0309297,22.4955,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030097','Ronchis','Ronchis','','NO','H533',45.8058070,12.9959635,18.5325,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030098','Ruda','Ruda','','NO','H629',45.8376648,13.4013396,19.4956,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030099','San Daniele del Friuli','San Daniele del Friuli','','NO','H816',46.1611417,13.0111890,34.1537,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030100','San Giorgio di Nogaro','San Giorgio di Nogaro','','NO','H895',45.8328428,13.2070080,26.5828,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030101','San Giovanni al Natisone','San Giovanni al Natisone','','NO','H906',45.9809499,13.4043114,24.4689,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030102','San Leonardo','San Leonardo','','NO','H951',46.1212960,13.5236287,26.7263,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030103','San Pietro al Natisone','San Pietro al Natisone','','NO','I092',46.1264746,13.4853218,23.8739,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030104','Santa Maria la Longa','Santa Maria la Longa','','NO','I248',45.9333093,13.2883054,19.5886,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030105','San Vito al Torre','San Vito al Torre','','NO','I404',45.8958279,13.3699835,11.9731,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030106','San Vito di Fagagna','San Vito di Fagagna','','NO','I405',46.0889680,13.0572722,8.5054,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030107','Sauris','Sauris','','NO','I464',46.4667000,12.7082908,41.3417,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030108','Savogna','Savogna','','NO','I478',46.1594308,13.5332310,22.4716,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030109','Sedegliano','Sedegliano','','NO','I562',46.0134771,12.9758326,50.5850,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030110','Socchieve','Socchieve','','NO','I777',46.4035648,12.8234709,66.7014,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030111','Stregna','Stregna','','NO','I974',46.1271409,13.5776572,19.8487,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030112','Sutrio','Sutrio','','NO','L018',46.5123645,12.9899938,20.5510,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030113','Taipana','Taipana','','NO','G736',46.2497930,13.3423616,65.5772,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030114','Talmassons','Talmassons','','NO','L039',45.9302973,13.1152868,42.9828,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030116','Tarcento','Tarcento','','NO','L050',46.2159104,13.2216426,35.4012,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030117','Tarvisio','Tarvisio','','NO','L057',46.5052702,13.5776745,208.1652,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030118','Tavagnacco','Tavagnacco','','NO','L065',46.1013122,13.2153235,15.2751,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030120','Terzo d\'Aquileia','Terzo d\'Aquileia','','NO','L144',45.8002827,13.3463633,28.2140,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030121','Tolmezzo','Tolmezzo','','NO','L195',46.4059327,13.0153268,64.3531,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030122','Torreano','Torreano','','NO','L246',46.1300297,13.4323095,34.8775,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030123','Torviscosa','Torviscosa','','NO','L309',45.8233064,13.2740988,48.7436,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030124','Trasaghis','Trasaghis','','NO','L335',46.2826517,13.0753834,78.2067,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030126','Treppo Grande','Treppo Grande','','NO','L382',46.1906899,13.1570283,11.2233,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030127','Tricesimo','Tricesimo','','NO','L421',46.1619806,13.2118085,17.7271,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030128','Trivignano Udinese','Trivignano Udinese','','NO','L438',45.9460820,13.3403472,18.6780,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030129','Udine','Udine','','SI','L483',46.0633481,13.2354304,56.9400,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030130','Varmo','Varmo','','NO','L686',45.8869831,12.9880412,34.5541,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030131','Venzone','Venzone','','NO','L743',46.3336840,13.1390782,54.3719,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030132','Verzegnis','Verzegnis','','NO','L801',46.3899220,12.9935887,39.2652,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030133','Villa Santina','Villa Santina','','NO','L909',46.4156296,12.9237029,12.7685,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030135','Visco','Visco','','NO','M073',45.8920720,13.3475202,3.5174,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030136','Zuglio','Zuglio','','NO','M200',46.4609175,13.0261403,18.3158,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030137','Forgaria nel Friuli','Forgaria nel Friuli','','NO','D700',46.2241985,12.9685097,28.6253,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030138','Campolongo Tapogliano','Campolongo Tapogliano','','NO','M311',45.8641576,13.3939957,10.8580,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030188','Rivignano Teor','Rivignano Teor','','NO','M317',45.8743254,13.0411857,47.2095,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030189','Sappada','Sappada','','NO','I421',46.5660798,12.6838628,62.4008,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030190','Fiumicello Villa Vicentina','Fiumicello Villa Vicentina','','NO','M400',45.7907661,13.4094111,28.6997,'030');
INSERT INTO `gi_comuni` VALUES ('UD','030191','Treppo Ligosullo','Treppo Ligosullo','','NO','M399',46.5397780,13.0731977,35.6406,'030');
INSERT INTO `gi_comuni` VALUES ('GO','031001','Capriva del Friuli','Capriva del Friuli','','NO','B712',45.9418047,13.5141197,6.3812,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031002','Cormons','Cormons','','NO','D014',45.9607460,13.4739527,35.0277,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031003','Doberdò del Lago-Doberdob','Doberdò del Lago','Doberdob','NO','D312',45.8444853,13.5398546,27.1582,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031004','Dolegna del Collio','Dolegna del Collio','','NO','D321',46.0317197,13.4792710,12.8243,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031005','Farra d\'Isonzo','Farra d\'Isonzo','','NO','D504',45.9073820,13.5179419,10.2410,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031006','Fogliano Redipuglia','Fogliano Redipuglia','','NO','D645',45.8648604,13.4816031,8.0928,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031007','Gorizia','Gorizia','','SI','E098',45.9414897,13.6221337,41.3656,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031008','Gradisca d\'Isonzo','Gradisca d\'Isonzo','','NO','E124',45.8891187,13.5037700,11.0977,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031009','Grado','Grado','','NO','E125',45.6752797,13.3864704,119.3847,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031010','Mariano del Friuli','Mariano del Friuli','','NO','E952',45.9179493,13.4584963,8.6235,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031011','Medea','Medea','','NO','F081',45.9171230,13.4234866,7.3939,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031012','Monfalcone','Monfalcone','','NO','F356',45.8102000,13.5332304,20.6559,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031013','Moraro','Moraro','','NO','F710',45.9304547,13.4950284,3.7535,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031014','Mossa','Mossa','','NO','F767',45.9383172,13.5477893,6.4063,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031015','Romans d\'Isonzo','Romans d\'Isonzo','','NO','H514',45.8908119,13.4392279,15.7640,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031016','Ronchi dei Legionari','Ronchi dei Legionari','','NO','H531',45.8242068,13.5004108,17.3042,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031017','Sagrado','Sagrado','','NO','H665',45.8763860,13.4853650,13.9261,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031018','San Canzian d\'Isonzo','San Canzian d\'Isonzo','','NO','H787',45.8095685,13.4434107,33.6393,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031019','San Floriano del Collio-Števerjan','San Floriano del Collio','Števerjan','NO','H845',45.9819104,13.5849937,10.3593,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031020','San Lorenzo Isontino','San Lorenzo Isontino','','NO','H964',45.9329690,13.5264525,4.3401,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031021','San Pier d\'Isonzo','San Pier d\'Isonzo','','NO','I082',45.8463883,13.4605533,8.8485,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031022','Savogna d\'Isonzo-Sovodnje ob Soči','Savogna d\'Isonzo','Sovodnje ob Soči','NO','I479',45.9018435,13.5709971,16.6983,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031023','Staranzano','Staranzano','','NO','I939',45.8060346,13.4998243,18.8213,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031024','Turriaco','Turriaco','','NO','L474',45.8209988,13.4447772,5.3108,'031');
INSERT INTO `gi_comuni` VALUES ('GO','031025','Villesse','Villesse','','NO','M043',45.8597866,13.4383506,11.8506,'031');
INSERT INTO `gi_comuni` VALUES ('TS','032001','Duino Aurisina-Devin Nabrežina','Duino Aurisina','Devin Nabrežina','NO','D383',45.7538928,13.6596630,45.3194,'032');
INSERT INTO `gi_comuni` VALUES ('TS','032002','Monrupino-Repentabor','Monrupino','Repentabor','NO','F378',45.7189340,13.8004595,12.7821,'032');
INSERT INTO `gi_comuni` VALUES ('TS','032003','Muggia','Muggia','','NO','F795',45.6044648,13.7675074,13.8375,'032');
INSERT INTO `gi_comuni` VALUES ('TS','032004','San Dorligo della Valle-Dolina','San Dorligo della Valle','Dolina','NO','D324',45.6078922,13.8567138,24.2861,'032');
INSERT INTO `gi_comuni` VALUES ('TS','032005','Sgonico-Zgonik','Sgonico','Zgonik','NO','I715',45.7357214,13.7469174,31.2370,'032');
INSERT INTO `gi_comuni` VALUES ('TS','032006','Trieste','Trieste','','SI','L424',45.6494502,13.7684078,85.0492,'032');
INSERT INTO `gi_comuni` VALUES ('PC','033001','Agazzano','Agazzano','','NO','A067',44.9467816,9.5206032,36.1946,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033002','Alseno','Alseno','','NO','A223',44.8963785,9.9646125,54.6842,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033003','Besenzone','Besenzone','','NO','A823',44.9874215,9.9532965,24.0109,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033004','Bettola','Bettola','','NO','A831',44.7761560,9.6053647,122.0739,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033005','Bobbio','Bobbio','','NO','A909',44.7663148,9.3866257,106.7810,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033006','Borgonovo Val Tidone','Borgonovo Val Tidone','','NO','B025',45.0180236,9.4468327,51.1659,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033007','Cadeo','Cadeo','','NO','B332',44.9654691,9.8522230,38.6006,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033008','Calendasco','Calendasco','','NO','B405',45.0877362,9.5937988,36.7668,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033010','Caorso','Caorso','','NO','B643',45.0497188,9.8719957,41.3152,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033011','Carpaneto Piacentino','Carpaneto Piacentino','','NO','B812',44.9150729,9.7885685,62.9531,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033012','Castell\'Arquato','Castell\'Arquato','','NO','C145',44.8512139,9.8673933,52.9846,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033013','Castel San Giovanni','Castel San Giovanni','','NO','C261',45.0585203,9.4340699,43.9874,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033014','Castelvetro Piacentino','Castelvetro Piacentino','','NO','C288',45.0966346,9.9880080,35.1034,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033015','Cerignale','Cerignale','','NO','C513',44.6773512,9.3512613,31.0965,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033016','Coli','Coli','','NO','C838',44.7434261,9.4128216,71.4751,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033017','Corte Brugnatella','Corte Brugnatella','','NO','D054',44.7124394,9.3797063,46.6208,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033018','Cortemaggiore','Cortemaggiore','','NO','D061',44.9967419,9.9310490,36.1549,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033019','Farini','Farini','','NO','D502',44.7133748,9.5706278,112.9411,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033020','Ferriere','Ferriere','','NO','D555',44.6449164,9.4988214,178.2477,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033021','Fiorenzuola d\'Arda','Fiorenzuola d\'Arda','','NO','D611',44.9285447,9.9075926,59.7293,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033022','Gazzola','Gazzola','','NO','D958',44.9593096,9.5471049,44.3598,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033023','Gossolengo','Gossolengo','','NO','E114',45.0000124,9.6132018,31.5219,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033024','Gragnano Trebbiense','Gragnano Trebbiense','','NO','E132',45.0121211,9.5691037,34.6254,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033025','Gropparello','Gropparello','','NO','E196',44.8322490,9.7303098,56.5364,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033026','Lugagnano Val d\'Arda','Lugagnano Val d\'Arda','','NO','E726',44.8225124,9.8264164,54.7530,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033027','Monticelli d\'Ongina','Monticelli d\'Ongina','','NO','F671',45.0901746,9.9345456,46.4404,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033028','Morfasso','Morfasso','','NO','F724',44.7216598,9.7032169,83.6500,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033030','Ottone','Ottone','','NO','G195',44.6224183,9.3321086,98.2021,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033032','Piacenza','Piacenza','','SI','G535',45.0519613,9.6926721,117.8364,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033033','Pianello Val Tidone','Pianello Val Tidone','','NO','G557',44.9483134,9.4054148,36.3382,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033034','Piozzano','Piozzano','','NO','G696',44.9254137,9.4943234,43.7872,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033035','Podenzano','Podenzano','','NO','G747',44.9561840,9.6861387,44.1740,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033036','Ponte dell\'Olio','Ponte dell\'Olio','','NO','G842',44.8678925,9.6428507,44.3715,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033037','Pontenure','Pontenure','','NO','G852',44.9996853,9.7860127,33.9475,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033038','Rivergaro','Rivergaro','','NO','H350',44.9107014,9.5975038,44.1830,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033039','Rottofreno','Rottofreno','','NO','H593',45.0577943,9.5498361,35.2478,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033040','San Giorgio Piacentino','San Giorgio Piacentino','','NO','H887',44.9544149,9.7374211,48.8983,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033041','San Pietro in Cerro','San Pietro in Cerro','','NO','G788',45.0205972,9.9511950,27.3545,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033042','Sarmato','Sarmato','','NO','I434',45.0603984,9.4914942,27.3187,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033043','Travo','Travo','','NO','L348',44.8610182,9.5428488,80.7014,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033044','Vernasca','Vernasca','','NO','L772',44.7999220,9.8295822,72.6551,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033045','Vigolzone','Vigolzone','','NO','L897',44.9115308,9.6697926,42.0247,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033046','Villanova sull\'Arda','Villanova sull\'Arda','','NO','L980',45.0258625,9.9974010,36.2663,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033047','Zerba','Zerba','','NO','M165',44.6655786,9.2876893,24.1929,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033048','Ziano Piacentino','Ziano Piacentino','','NO','L848',45.0010582,9.4007145,32.7671,'033');
INSERT INTO `gi_comuni` VALUES ('PC','033049','Alta Val Tidone','Alta Val Tidone','','NO','M386',44.9052281,9.3270957,100.9509,'033');
INSERT INTO `gi_comuni` VALUES ('PR','034001','Albareto','Albareto','','NO','A138',44.4458142,9.7004747,103.9527,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034002','Bardi','Bardi','','NO','A646',44.6328166,9.7320329,189.7748,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034003','Bedonia','Bedonia','','NO','A731',44.5034756,9.6312385,169.5264,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034004','Berceto','Berceto','','NO','A788',44.5092743,9.9889752,131.5838,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034005','Bore','Bore','','NO','A987',44.7190109,9.7943641,42.9530,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034006','Borgo Val di Taro','Borgo Val di Taro','','NO','B042',44.4882454,9.7670956,151.4145,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034007','Busseto','Busseto','','NO','B293',44.9813077,10.0412989,76.4002,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034008','Calestano','Calestano','','NO','B408',44.6006586,10.1221410,57.4601,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034009','Collecchio','Collecchio','','NO','C852',44.7527874,10.2158605,58.7571,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034010','Colorno','Colorno','','NO','C904',44.9294599,10.3759557,48.5797,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034011','Compiano','Compiano','','NO','C934',44.4955054,9.6626145,37.6009,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034012','Corniglio','Corniglio','','NO','D026',44.4761357,10.0888258,165.7244,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034013','Felino','Felino','','NO','D526',44.6955356,10.2407334,38.5386,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034014','Fidenza','Fidenza','','NO','B034',44.8659610,10.0608598,94.8667,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034015','Fontanellato','Fontanellato','','NO','D673',44.8827675,10.1725486,53.7279,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034016','Fontevivo','Fontevivo','','NO','D685',44.8564946,10.1760935,26.1718,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034017','Fornovo di Taro','Fornovo di Taro','','NO','D728',44.6895506,10.0990230,57.9110,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034018','Langhirano','Langhirano','','NO','E438',44.6144526,10.2664881,70.8351,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034019','Lesignano de\' Bagni','Lesignano de\' Bagni','','NO','E547',44.6440135,10.3016808,47.6563,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034020','Medesano','Medesano','','NO','F082',44.7567627,10.1401285,88.8669,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034022','Monchio delle Corti','Monchio delle Corti','','NO','F340',44.4123576,10.1232073,69.1862,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034023','Montechiarugolo','Montechiarugolo','','NO','F473',44.6934749,10.4221540,48.4190,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034024','Neviano degli Arduini','Neviano degli Arduini','','NO','F882',44.5836159,10.3177980,105.9865,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034025','Noceto','Noceto','','NO','F914',44.8100732,10.1772212,79.1973,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034026','Palanzano','Palanzano','','NO','G255',44.4353217,10.1924229,69.2053,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034027','Parma','Parma','','SI','G337',44.8010694,10.3283497,259.9187,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034028','Pellegrino Parmense','Pellegrino Parmense','','NO','G424',44.7333212,9.9268385,81.6421,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034030','Roccabianca','Roccabianca','','NO','H384',45.0080716,10.2181676,40.5102,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034031','Sala Baganza','Sala Baganza','','NO','H682',44.7155184,10.2283555,30.5810,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034032','Salsomaggiore Terme','Salsomaggiore Terme','','NO','H720',44.8156699,9.9780664,81.5739,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034033','San Secondo Parmense','San Secondo Parmense','','NO','I153',44.9190622,10.2269309,37.8277,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034035','Solignano','Solignano','','NO','I803',44.6151163,9.9793406,72.7183,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034036','Soragna','Soragna','','NO','I840',44.9268551,10.1223187,45.9356,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034038','Terenzo','Terenzo','','NO','E548',44.6100219,10.0876949,72.6657,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034039','Tizzano Val Parma','Tizzano Val Parma','','NO','L183',44.5204900,10.1987379,78.2126,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034040','Tornolo','Tornolo','','NO','L229',44.4849197,9.6245040,67.7339,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034041','Torrile','Torrile','','NO','L299',44.8906136,10.3550679,37.2944,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034042','Traversetolo','Traversetolo','','NO','L346',44.6397532,10.3816709,54.9249,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034044','Valmozzola','Valmozzola','','NO','L641',44.5682018,9.8849052,67.8178,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034045','Varano de\' Melegari','Varano de\' Melegari','','NO','L672',44.6870869,10.0143480,65.1129,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034046','Varsi','Varsi','','NO','L689',44.6629788,9.8456277,79.9082,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034049','Sissa Trecasali','Sissa Trecasali','','NO','M325',44.9524095,10.2605011,72.6524,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034050','Polesine Zibello','Polesine Zibello','','NO','M367',45.0180651,10.1268879,48.5500,'034');
INSERT INTO `gi_comuni` VALUES ('PR','034051','Sorbolo Mezzani','Sorbolo Mezzani','','NO','M411',44.8464718,10.4483378,66.7165,'034');
INSERT INTO `gi_comuni` VALUES ('RE','035001','Albinea','Albinea','','NO','A162',44.6196132,10.6020375,43.6099,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035002','Bagnolo in Piano','Bagnolo in Piano','','NO','A573',44.7626386,10.6725756,26.8880,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035003','Baiso','Baiso','','NO','A586',44.4952013,10.5988655,75.1188,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035004','Bibbiano','Bibbiano','','NO','A850',44.6633370,10.4732233,28.2801,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035005','Boretto','Boretto','','NO','A988',44.9064646,10.5541541,18.1343,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035006','Brescello','Brescello','','NO','B156',44.9015409,10.5160166,24.3293,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035008','Cadelbosco di Sopra','Cadelbosco di Sopra','','NO','B328',44.7631255,10.5945966,43.6013,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035009','Campagnola Emilia','Campagnola Emilia','','NO','B499',44.8412674,10.7591798,24.3428,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035010','Campegine','Campegine','','NO','B502',44.7813985,10.5310855,22.4338,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035011','Carpineti','Carpineti','','NO','B825',44.4547087,10.5195752,89.6993,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035012','Casalgrande','Casalgrande','','NO','B893',44.5898470,10.7392369,37.8080,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035013','Casina','Casina','','NO','B967',44.5116511,10.5004332,63.6722,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035014','Castellarano','Castellarano','','NO','C141',44.5095297,10.7306704,58.1113,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035015','Castelnovo di Sotto','Castelnovo di Sotto','','NO','C218',44.8115569,10.5637709,35.0758,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035016','Castelnovo ne\' Monti','Castelnovo ne\' Monti','','NO','C219',44.4373478,10.4032257,97.0586,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035017','Cavriago','Cavriago','','NO','C405',44.6948844,10.5267737,16.9783,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035018','Canossa','Canossa','','NO','C669',44.5925180,10.4083976,53.4913,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035020','Correggio','Correggio','','NO','D037',44.7714268,10.7814382,77.7996,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035021','Fabbrico','Fabbrico','','NO','D450',44.8716312,10.8095528,23.9250,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035022','Gattatico','Gattatico','','NO','D934',44.8051669,10.4753692,42.3983,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035023','Gualtieri','Gualtieri','','NO','E232',44.9054978,10.6305769,35.4709,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035024','Guastalla','Guastalla','','NO','E253',44.9223288,10.6540604,52.8488,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035026','Luzzara','Luzzara','','NO','E772',44.9601703,10.6856885,38.6553,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035027','Montecchio Emilia','Montecchio Emilia','','NO','F463',44.7000273,10.4465685,24.4918,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035028','Novellara','Novellara','','NO','F960',44.8451219,10.7318890,58.1666,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035029','Poviglio','Poviglio','','NO','G947',44.8407810,10.5414940,43.3052,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035030','Quattro Castella','Quattro Castella','','NO','H122',44.6357202,10.4727856,46.0776,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035032','Reggiolo','Reggiolo','','NO','H225',44.9176136,10.8035603,42.7477,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035033','Reggio nell\'Emilia','Reggio nell\'Emilia','','SI','H223',44.6971946,10.6303573,230.2522,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035034','Rio Saliceto','Rio Saliceto','','NO','H298',44.8092994,10.8029819,22.6618,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035035','Rolo','Rolo','','NO','H500',44.8871975,10.8563491,13.9645,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035036','Rubiera','Rubiera','','NO','H628',44.6534391,10.7832257,25.0765,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035037','San Martino in Rio','San Martino in Rio','','NO','I011',44.7327136,10.7846994,22.5557,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035038','San Polo d\'Enza','San Polo d\'Enza','','NO','I123',44.6264354,10.4207559,32.1275,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035039','Sant\'Ilario d\'Enza','Sant\'Ilario d\'Enza','','NO','I342',44.7605563,10.4514485,20.2425,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035040','Scandiano','Scandiano','','NO','I496',44.5992768,10.6879355,50.1720,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035041','Toano','Toano','','NO','L184',44.3763879,10.5589334,67.3945,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035042','Vetto','Vetto','','NO','L815',44.4840180,10.3391819,52.9331,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035043','Vezzano sul Crostolo','Vezzano sul Crostolo','','NO','L820',44.6009602,10.5464483,37.6853,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035044','Viano','Viano','','NO','L831',44.5482922,10.6204098,45.2349,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035045','Villa Minozzo','Villa Minozzo','','NO','L969',44.3654478,10.4674108,167.9913,'035');
INSERT INTO `gi_comuni` VALUES ('RE','035046','Ventasso','Ventasso','','NO','M364',44.3881421,10.3321156,258.3003,'035');
INSERT INTO `gi_comuni` VALUES ('MO','036001','Bastiglia','Bastiglia','','NO','A713',44.7265063,10.9998656,10.5643,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036002','Bomporto','Bomporto','','NO','A959',44.7273457,11.0427958,38.7390,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036003','Campogalliano','Campogalliano','','NO','B539',44.6904859,10.8413071,36.0365,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036004','Camposanto','Camposanto','','NO','B566',44.7879043,11.1383234,22.6580,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036005','Carpi','Carpi','','NO','B819',44.7821651,10.8849025,131.1778,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036006','Castelfranco Emilia','Castelfranco Emilia','','NO','C107',44.5962872,11.0531986,102.5252,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036007','Castelnuovo Rangone','Castelnuovo Rangone','','NO','C242',44.5490814,10.9396924,22.6684,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036008','Castelvetro di Modena','Castelvetro di Modena','','NO','C287',44.5031682,10.9431001,49.9343,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036009','Cavezzo','Cavezzo','','NO','C398',44.8359276,11.0297997,27.0475,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036010','Concordia sulla Secchia','Concordia sulla Secchia','','NO','C951',44.9182782,10.9879298,40.9278,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036011','Fanano','Fanano','','NO','D486',44.2072834,10.7951091,89.9769,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036012','Finale Emilia','Finale Emilia','','NO','D599',44.8340092,11.2927985,104.5342,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036013','Fiorano Modenese','Fiorano Modenese','','NO','D607',44.5390796,10.8114201,26.2968,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036014','Fiumalbo','Fiumalbo','','NO','D617',44.1795894,10.6473950,38.9990,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036015','Formigine','Formigine','','NO','D711',44.5759749,10.8401887,46.2149,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036016','Frassinoro','Frassinoro','','NO','D783',44.2955655,10.5732383,95.1944,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036017','Guiglia','Guiglia','','NO','E264',44.4279563,10.9572098,48.6594,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036018','Lama Mocogno','Lama Mocogno','','NO','E426',44.3082143,10.7305731,63.9122,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036019','Maranello','Maranello','','NO','E904',44.5251142,10.8674478,32.2183,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036020','Marano sul Panaro','Marano sul Panaro','','NO','E905',44.4561137,10.9662971,45.3816,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036021','Medolla','Medolla','','NO','F087',44.8503386,11.0708547,27.0222,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036022','Mirandola','Mirandola','','NO','F240',44.8868962,11.0539628,137.1094,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036023','Modena','Modena','','SI','F257',44.6459922,10.9263682,183.1182,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036024','Montecreto','Montecreto','','NO','F484',44.2489040,10.7208008,31.4097,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036025','Montefiorino','Montefiorino','','NO','F503',44.3594066,10.6253168,45.2442,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036026','Montese','Montese','','NO','F642',44.2674560,10.9403655,80.3593,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036027','Nonantola','Nonantola','','NO','F930',44.6771672,11.0435770,55.3426,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036028','Novi di Modena','Novi di Modena','','NO','F966',44.8942394,10.8986661,51.8697,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036029','Palagano','Palagano','','NO','G250',44.3206958,10.6477824,59.9891,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036030','Pavullo nel Frignano','Pavullo nel Frignano','','NO','G393',44.3394935,10.8339285,143.2399,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036031','Pievepelago','Pievepelago','','NO','G649',44.2069894,10.6169500,76.8979,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036032','Polinago','Polinago','','NO','G789',44.3442254,10.7231980,54.0255,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036033','Prignano sulla Secchia','Prignano sulla Secchia','','NO','H061',44.4371123,10.6909699,79.8304,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036034','Ravarino','Ravarino','','NO','H195',44.7240878,11.0994873,28.6712,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036035','Riolunato','Riolunato','','NO','H303',44.2303220,10.6529338,44.5933,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036036','San Cesario sul Panaro','San Cesario sul Panaro','','NO','H794',44.5614850,11.0338877,27.3444,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036037','San Felice sul Panaro','San Felice sul Panaro','','NO','H835',44.8399951,11.1466991,51.6710,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036038','San Possidonio','San Possidonio','','NO','I128',44.8923213,10.9960602,16.8785,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036039','San Prospero','San Prospero','','NO','I133',44.7879173,11.0228487,34.7254,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036040','Sassuolo','Sassuolo','','NO','I462',44.5402346,10.7826701,38.4702,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036041','Savignano sul Panaro','Savignano sul Panaro','','NO','I473',44.4795838,11.0337552,25.6402,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036042','Serramazzoni','Serramazzoni','','NO','F357',44.4212927,10.7902166,94.4055,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036043','Sestola','Sestola','','NO','I689',44.2301353,10.7713807,53.0087,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036044','Soliera','Soliera','','NO','I802',44.7384244,10.9242408,51.1148,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036045','Spilamberto','Spilamberto','','NO','I903',44.5337667,11.0237378,29.7985,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036046','Vignola','Vignola','','NO','L885',44.4798835,11.0113893,23.1175,'036');
INSERT INTO `gi_comuni` VALUES ('MO','036047','Zocca','Zocca','','NO','M183',44.3461654,10.9936418,69.3517,'036');
INSERT INTO `gi_comuni` VALUES ('BO','037001','Anzola dell\'Emilia','Anzola dell\'Emilia','','NO','A324',44.5471168,11.1930685,36.6736,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037002','Argelato','Argelato','','NO','A392',44.6423135,11.3476562,34.8353,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037003','Baricella','Baricella','','NO','A665',44.6470541,11.5345498,45.4105,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037005','Bentivoglio','Bentivoglio','','NO','A785',44.6348963,11.4186338,51.4550,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037006','Bologna','Bologna','','SI','A944',44.4941095,11.3417194,140.6001,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037007','Borgo Tossignano','Borgo Tossignano','','NO','B044',44.2774032,11.5892246,29.4500,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037008','Budrio','Budrio','','NO','B249',44.5377011,11.5361474,120.0198,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037009','Calderara di Reno','Calderara di Reno','','NO','B399',44.5657863,11.2716101,40.2301,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037010','Camugnano','Camugnano','','NO','B572',44.1689881,11.0874037,96.6453,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037011','Casalecchio di Reno','Casalecchio di Reno','','NO','B880',44.4812664,11.2823968,17.4212,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037012','Casalfiumanese','Casalfiumanese','','NO','B892',44.2976514,11.6168584,82.0377,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037013','Castel d\'Aiano','Castel d\'Aiano','','NO','C075',44.2806380,11.0013001,45.4664,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037014','Castel del Rio','Castel del Rio','','NO','C086',44.2131444,11.5044239,52.5849,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037015','Castel di Casio','Castel di Casio','','NO','B969',44.1629137,11.0368538,47.5228,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037016','Castel Guelfo di Bologna','Castel Guelfo di Bologna','','NO','C121',44.4321905,11.6772579,29.1070,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037017','Castello d\'Argile','Castello d\'Argile','','NO','C185',44.6812259,11.2966000,29.2272,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037019','Castel Maggiore','Castel Maggiore','','NO','C204',44.5750915,11.3648898,30.9651,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037020','Castel San Pietro Terme','Castel San Pietro Terme','','NO','C265',44.3981124,11.5891780,148.1678,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037021','Castenaso','Castenaso','','NO','C292',44.5089105,11.4687852,35.7415,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037022','Castiglione dei Pepoli','Castiglione dei Pepoli','','NO','C296',44.1416418,11.1539116,66.0360,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037024','Crevalcore','Crevalcore','','NO','D166',44.7226184,11.1470181,102.8250,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037025','Dozza','Dozza','','NO','D360',44.3594281,11.6286774,24.3535,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037026','Fontanelice','Fontanelice','','NO','D668',44.2574565,11.5583791,36.5354,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037027','Gaggio Montano','Gaggio Montano','','NO','D847',44.1986498,10.9358534,58.6350,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037028','Galliera','Galliera','','NO','D878',44.7447349,11.4359415,37.2432,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037030','Granarolo dell\'Emilia','Granarolo dell\'Emilia','','NO','E136',44.5534453,11.4477150,34.4602,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037031','Grizzana Morandi','Grizzana Morandi','','NO','E187',44.2577942,11.1521146,77.5719,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037032','Imola','Imola','','NO','E289',44.3530613,11.7141186,204.6929,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037033','Lizzano in Belvedere','Lizzano in Belvedere','','NO','A771',44.1616298,10.8936621,85.3969,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037034','Loiano','Loiano','','NO','E655',44.2701636,11.3217144,52.6069,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037035','Malalbergo','Malalbergo','','NO','E844',44.7188996,11.5339784,53.8010,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037036','Marzabotto','Marzabotto','','NO','B689',44.3403204,11.2050767,74.2334,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037037','Medicina','Medicina','','NO','F083',44.4764352,11.6404752,158.7048,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037038','Minerbio','Minerbio','','NO','F219',44.6251944,11.4908026,43.1863,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037039','Molinella','Molinella','','NO','F288',44.6203890,11.6703638,127.4285,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037040','Monghidoro','Monghidoro','','NO','F363',44.2194312,11.3166301,48.1364,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037041','Monterenzio','Monterenzio','','NO','F597',44.3252676,11.4050063,105.0664,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037042','Monte San Pietro','Monte San Pietro','','NO','F627',44.4577524,11.1996849,74.2800,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037044','Monzuno','Monzuno','','NO','F706',44.2767965,11.2714435,65.1978,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037045','Mordano','Mordano','','NO','F718',44.3977144,11.8105339,21.3714,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037046','Ozzano dell\'Emilia','Ozzano dell\'Emilia','','NO','G205',44.4460368,11.4789715,65.3875,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037047','Pianoro','Pianoro','','NO','G570',44.3851291,11.3432764,106.3598,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037048','Pieve di Cento','Pieve di Cento','','NO','G643',44.7136271,11.3070035,16.0699,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037050','Sala Bolognese','Sala Bolognese','','NO','H678',44.6297905,11.2768680,46.1751,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037051','San Benedetto Val di Sambro','San Benedetto Val di Sambro','','NO','G566',44.2155617,11.2330665,66.4463,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037052','San Giorgio di Piano','San Giorgio di Piano','','NO','H896',44.6469770,11.3751384,30.3721,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037053','San Giovanni in Persiceto','San Giovanni in Persiceto','','NO','G467',44.6386337,11.1868647,114.0224,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037054','San Lazzaro di Savena','San Lazzaro di Savena','','NO','H945',44.4704674,11.4080550,45.2728,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037055','San Pietro in Casale','San Pietro in Casale','','NO','I110',44.7019472,11.4063187,65.9156,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037056','Sant\'Agata Bolognese','Sant\'Agata Bolognese','','NO','I191',44.6645362,11.1338071,34.8250,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037057','Sasso Marconi','Sasso Marconi','','NO','G972',44.3943630,11.2449153,97.1560,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037059','Vergato','Vergato','','NO','L762',44.2839272,11.1127788,60.0823,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037060','Zola Predosa','Zola Predosa','','NO','M185',44.4921920,11.2181761,37.9132,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037061','Valsamoggia','Valsamoggia','','NO','M320',44.5046685,11.0830382,177.9150,'237');
INSERT INTO `gi_comuni` VALUES ('BO','037062','Alto Reno Terme','Alto Reno Terme','','NO','M369',44.1547130,10.9760459,73.4653,'237');
INSERT INTO `gi_comuni` VALUES ('FE','038001','Argenta','Argenta','','NO','A393',44.6145633,11.8370712,311.7039,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038003','Bondeno','Bondeno','','NO','A965',44.8852147,11.4184721,174.3248,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038004','Cento','Cento','','NO','C469',44.7275471,11.2905632,65.0755,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038005','Codigoro','Codigoro','','NO','C814',44.8318067,12.1049856,168.9178,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038006','Comacchio','Comacchio','','NO','C912',44.6947544,12.1836529,283.6377,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038007','Copparo','Copparo','','NO','C980',44.8952858,11.8276001,157.4731,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038008','Ferrara','Ferrara','','SI','D548',44.8360145,11.6187445,405.4266,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038010','Jolanda di Savoia','Jolanda di Savoia','','NO','E320',44.8852251,11.9767356,108.4882,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038011','Lagosanto','Lagosanto','','NO','E410',44.7655428,12.1414476,34.2913,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038012','Masi Torello','Masi Torello','','NO','F016',44.7940308,11.7952796,22.7557,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038014','Mesola','Mesola','','NO','F156',44.9224336,12.2293173,84.6852,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038017','Ostellato','Ostellato','','NO','G184',44.7453962,11.9408213,173.2867,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038018','Poggio Renatico','Poggio Renatico','','NO','G768',44.7647152,11.4854398,79.7481,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038019','Portomaggiore','Portomaggiore','','NO','G916',44.6977987,11.8057679,126.4189,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038022','Vigarano Mainarda','Vigarano Mainarda','','NO','L868',44.8403329,11.4986317,41.9918,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038023','Voghiera','Voghiera','','NO','M110',44.7576098,11.7511049,40.3623,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038025','Goro','Goro','','NO','E107',44.8538377,12.3027786,26.4417,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038027','Fiscaglia','Fiscaglia','','NO','M323',44.7984096,11.9729743,116.4348,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038028','Terre del Reno','Terre del Reno','','NO','M381',44.7936544,11.3846749,51.4692,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038029','Riva del Po','Riva del Po','','NO','M410',44.9792995,11.9789773,111.2878,'038');
INSERT INTO `gi_comuni` VALUES ('FE','038030','Tresignana','Tresignana','','NO','M409',44.8177907,11.8967981,42.6634,'038');
INSERT INTO `gi_comuni` VALUES ('RA','039001','Alfonsine','Alfonsine','','NO','A191',44.5052654,12.0409744,107.3050,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039002','Bagnacavallo','Bagnacavallo','','NO','A547',44.4165956,11.9774313,79.5266,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039003','Bagnara di Romagna','Bagnara di Romagna','','NO','A551',44.3893410,11.8263044,10.1205,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039004','Brisighella','Brisighella','','NO','B188',44.2240325,11.7726070,193.6812,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039005','Casola Valsenio','Casola Valsenio','','NO','B982',44.2235032,11.6230652,84.3700,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039006','Castel Bolognese','Castel Bolognese','','NO','C065',44.3191023,11.7989486,32.2331,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039007','Cervia','Cervia','','NO','C553',44.2610586,12.3498263,82.2801,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039008','Conselice','Conselice','','NO','C963',44.5126705,11.8290354,60.2256,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039009','Cotignola','Cotignola','','NO','D121',44.3843790,11.9422157,34.9459,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039010','Faenza','Faenza','','NO','D458',44.2855229,11.8824997,216.0013,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039011','Fusignano','Fusignano','','NO','D829',44.4680153,11.9593000,24.4467,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039012','Lugo','Lugo','','NO','E730',44.4210299,11.9116683,116.7802,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039013','Massa Lombarda','Massa Lombarda','','NO','F029',44.4465613,11.8282128,37.4191,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039014','Ravenna','Ravenna','','SI','H199',44.4173222,12.1991128,653.6013,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039015','Riolo Terme','Riolo Terme','','NO','H302',44.2761459,11.7245456,44.4428,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039016','Russi','Russi','','NO','H642',44.3723926,12.0328997,46.1346,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039017','Sant\'Agata sul Santerno','Sant\'Agata sul Santerno','','NO','I196',44.4423667,11.8616769,9.5549,'039');
INSERT INTO `gi_comuni` VALUES ('RA','039018','Solarolo','Solarolo','','NO','I787',44.3601603,11.8437521,26.0631,'039');
INSERT INTO `gi_comuni` VALUES ('FC','040001','Bagno di Romagna','Bagno di Romagna','','NO','A565',43.8589298,11.9745817,233.0217,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040003','Bertinoro','Bertinoro','','NO','A809',44.1491081,12.1334282,57.5081,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040004','Borghi','Borghi','','NO','B001',44.0314142,12.3545426,30.3487,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040005','Castrocaro Terme e Terra del Sole','Castrocaro Terme e Terra del Sole','','NO','C339',44.1760211,11.9500200,39.1520,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040007','Cesena','Cesena','','SI','C573',44.1362573,12.2419181,249.5049,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040008','Cesenatico','Cesenatico','','NO','C574',44.1996722,12.3953116,45.1438,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040009','Civitella di Romagna','Civitella di Romagna','','NO','C777',44.0070231,11.9386349,117.7520,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040011','Dovadola','Dovadola','','NO','D357',44.1215999,11.8874626,39.1461,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040012','Forlì','Forlì','','SI','D704',44.2227936,12.0402224,227.8987,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040013','Forlimpopoli','Forlimpopoli','','NO','D705',44.1873231,12.1266741,24.3591,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040014','Galeata','Galeata','','NO','D867',43.9963384,11.9104847,62.9597,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040015','Gambettola','Gambettola','','NO','D899',44.1202165,12.3385564,7.9270,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040016','Gatteo','Gatteo','','NO','D935',44.1095587,12.3860547,14.0201,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040018','Longiano','Longiano','','NO','E675',44.0740319,12.3270048,23.5520,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040019','Meldola','Meldola','','NO','F097',44.1271205,12.0606510,79.0755,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040020','Mercato Saraceno','Mercato Saraceno','','NO','F139',43.9570022,12.1957817,99.3415,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040022','Modigliana','Modigliana','','NO','F259',44.1562458,11.7927656,101.5512,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040028','Montiano','Montiano','','NO','F668',44.0835410,12.3043097,9.5585,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040031','Portico e San Benedetto','Portico e San Benedetto','','NO','G904',44.0253954,11.7833707,61.2768,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040032','Predappio','Predappio','','NO','H017',44.1017561,11.9805006,91.3057,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040033','Premilcuore','Premilcuore','','NO','H034',43.9768965,11.7774266,98.2454,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040036','Rocca San Casciano','Rocca San Casciano','','NO','H437',44.0616634,11.8421701,50.1019,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040037','Roncofreddo','Roncofreddo','','NO','H542',44.0419744,12.3181724,51.4923,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040041','San Mauro Pascoli','San Mauro Pascoli','','NO','I027',44.1070421,12.4155198,16.9120,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040043','Santa Sofia','Santa Sofia','','NO','I310',43.9473200,11.9081056,148.8234,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040044','Sarsina','Sarsina','','NO','I444',43.9186789,12.1412978,101.3182,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040045','Savignano sul Rubicone','Savignano sul Rubicone','','NO','I472',44.0920902,12.3990890,23.3603,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040046','Sogliano al Rubicone','Sogliano al Rubicone','','NO','I779',44.0048651,12.3001373,93.1480,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040049','Tredozio','Tredozio','','NO','L361',44.0793398,11.7437139,62.7938,'040');
INSERT INTO `gi_comuni` VALUES ('FC','040050','Verghereto','Verghereto','','NO','L764',43.7956184,12.0059594,117.6192,'040');
INSERT INTO `gi_comuni` VALUES ('PU','041001','Acqualagna','Acqualagna','','NO','A035',43.6166773,12.6704445,50.7655,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041002','Apecchio','Apecchio','','NO','A327',43.5580147,12.4176814,103.6839,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041005','Belforte all\'Isauro','Belforte all\'Isauro','','NO','A740',43.7169808,12.3756958,12.2299,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041006','Borgo Pace','Borgo Pace','','NO','B026',43.6581668,12.2945974,56.1249,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041007','Cagli','Cagli','','NO','B352',43.5454844,12.6474326,226.1150,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041008','Cantiano','Cantiano','','NO','B636',43.4725606,12.6282508,83.3822,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041009','Carpegna','Carpegna','','NO','B816',43.7811747,12.3359623,29.2326,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041010','Cartoceto','Cartoceto','','NO','B846',43.7745051,12.9388062,23.4698,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041013','Fano','Fano','','NO','D488',43.8433005,13.0196459,120.0077,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041014','Fermignano','Fermignano','','NO','D541',43.6765005,12.6452354,43.8185,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041015','Fossombrone','Fossombrone','','NO','D749',43.6889488,12.8060774,106.9293,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041016','Fratte Rosa','Fratte Rosa','','NO','D791',43.6320509,12.9011870,15.5496,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041017','Frontino','Frontino','','NO','D807',43.7645664,12.3774307,10.3953,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041018','Frontone','Frontone','','NO','D808',43.5144382,12.7383985,36.0033,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041019','Gabicce Mare','Gabicce Mare','','NO','D836',43.9663892,12.7563938,5.0695,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041020','Gradara','Gradara','','NO','E122',43.9408193,12.7730703,18.0674,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041021','Isola del Piano','Isola del Piano','','NO','E351',43.7371383,12.7829215,23.4532,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041022','Lunano','Lunano','','NO','E743',43.7304410,12.4409691,14.9969,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041023','Macerata Feltria','Macerata Feltria','','NO','E785',43.8030099,12.4427903,40.0474,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041025','Mercatello sul Metauro','Mercatello sul Metauro','','NO','F135',43.6471148,12.3367254,68.8482,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041026','Mercatino Conca','Mercatino Conca','','NO','F136',43.8704233,12.4935658,13.7162,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041027','Mombaroccio','Mombaroccio','','NO','F310',43.7968894,12.8547991,28.0570,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041028','Mondavio','Mondavio','','NO','F347',43.6746404,12.9690095,29.4666,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041029','Mondolfo','Mondolfo','','NO','F348',43.7515269,13.0954447,24.9893,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041030','Montecalvo in Foglia','Montecalvo in Foglia','','NO','F450',43.8115664,12.6316354,18.3855,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041031','Monte Cerignone','Monte Cerignone','','NO','F467',43.8409629,12.4125818,18.2317,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041034','Montefelcino','Montefelcino','','NO','F497',43.7350780,12.8333453,38.8133,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041035','Monte Grimano Terme','Monte Grimano Terme','','NO','F524',43.8654306,12.4729436,23.7934,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041036','Montelabbate','Montelabbate','','NO','F533',43.8490494,12.7907777,19.9605,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041038','Monte Porzio','Monte Porzio','','NO','F589',43.6898678,13.0452536,18.3952,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041041','Peglio','Peglio','','NO','G416',43.6960322,12.4960205,21.3492,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041043','Pergola','Pergola','','NO','G453',43.5628542,12.8360175,112.4177,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041044','Pesaro','Pesaro','','SI','G479',43.9101021,12.9133947,152.6834,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041045','Petriano','Petriano','','NO','G514',43.7802931,12.7333500,11.3670,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041047','Piandimeleto','Piandimeleto','','NO','G551',43.7241398,12.4153430,39.2115,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041048','Pietrarubbia','Pietrarubbia','','NO','G627',43.8041816,12.3773503,13.3640,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041049','Piobbico','Piobbico','','NO','G682',43.5888211,12.5103747,47.7914,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041051','San Costanzo','San Costanzo','','NO','H809',43.7632293,13.0694380,40.7793,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041054','San Lorenzo in Campo','San Lorenzo in Campo','','NO','H958',43.6044354,12.9464352,28.9292,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041057','Sant\'Angelo in Vado','Sant\'Angelo in Vado','','NO','I287',43.6649071,12.4131782,66.8499,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041058','Sant\'Ippolito','Sant\'Ippolito','','NO','I344',43.6848198,12.8709918,19.9488,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041061','Serra Sant\'Abbondio','Serra Sant\'Abbondio','','NO','I654',43.4907804,12.7706041,32.8424,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041064','Tavoleto','Tavoleto','','NO','L078',43.8462459,12.5925827,12.3443,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041065','Tavullia','Tavullia','','NO','L081',43.8979485,12.7531941,41.5435,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041066','Urbania','Urbania','','NO','L498',43.6683597,12.5242250,77.9709,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041067','Urbino','Urbino','','SI','L500',43.7250667,12.6372663,226.4693,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041068','Vallefoglia','Vallefoglia','','NO','M331',43.8547059,12.7575142,39.4267,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041069','Colli al Metauro','Colli al Metauro','','NO','M380',43.7521308,12.9177099,46.6224,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041070','Terre Roveresche','Terre Roveresche','','NO','M379',43.6864314,12.9627421,69.9390,'041');
INSERT INTO `gi_comuni` VALUES ('PU','041071','Sassocorvaro Auditore','Sassocorvaro Auditore','','NO','M413',43.7798220,12.4973936,87.8862,'041');
INSERT INTO `gi_comuni` VALUES ('AN','042001','Agugliano','Agugliano','','NO','A092',43.5433721,13.3860708,21.9060,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042002','Ancona','Ancona','','SI','A271',43.6167390,13.5188738,124.1132,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042003','Arcevia','Arcevia','','NO','A366',43.4999705,12.9396409,127.9037,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042004','Barbara','Barbara','','NO','A626',43.5807252,13.0247839,11.0411,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042005','Belvedere Ostrense','Belvedere Ostrense','','NO','A769',43.5805003,13.1665581,29.8716,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042006','Camerano','Camerano','','NO','B468',43.5308607,13.5529485,20.2660,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042007','Camerata Picena','Camerata Picena','','NO','B470',43.5781586,13.3527525,12.1431,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042008','Castelbellino','Castelbellino','','NO','C060',43.4878123,13.1460842,6.1593,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042010','Castelfidardo','Castelfidardo','','NO','C100',43.4644421,13.5465554,33.3247,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042011','Castelleone di Suasa','Castelleone di Suasa','','NO','C152',43.6073267,12.9762386,15.9121,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042012','Castelplanio','Castelplanio','','NO','C248',43.4945668,13.0813710,15.1389,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042013','Cerreto d\'Esi','Cerreto d\'Esi','','NO','C524',43.3207116,12.9852709,17.2095,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042014','Chiaravalle','Chiaravalle','','NO','C615',43.5997270,13.3254738,17.5459,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042015','Corinaldo','Corinaldo','','NO','D007',43.6487949,13.0478067,49.0723,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042016','Cupramontana','Cupramontana','','NO','D211',43.4453090,13.1158416,27.1126,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042017','Fabriano','Fabriano','','NO','D451',43.3341063,12.9073910,271.3107,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042018','Falconara Marittima','Falconara Marittima','','NO','D472',43.6233089,13.3938837,26.2849,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042019','Filottrano','Filottrano','','NO','D597',43.4357296,13.3512697,71.3935,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042020','Genga','Genga','','NO','D965',43.4294391,12.9349103,73.2612,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042021','Jesi','Jesi','','NO','E388',43.5227387,13.2437539,108.8818,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042022','Loreto','Loreto','','NO','E690',43.4400166,13.6065286,18.0330,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042023','Maiolati Spontini','Maiolati Spontini','','NO','E837',43.4774398,13.1190001,21.5032,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042024','Mergo','Mergo','','NO','F145',43.4713980,13.0374175,7.2533,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042025','Monsano','Monsano','','NO','F381',43.5634933,13.2503499,14.6919,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042026','Montecarotto','Montecarotto','','NO','F453',43.5263705,13.0637820,24.2948,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042027','Montemarciano','Montemarciano','','NO','F560',43.6400042,13.3103879,22.3690,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042029','Monte Roberto','Monte Roberto','','NO','F600',43.4814560,13.1384087,13.6215,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042030','Monte San Vito','Monte San Vito','','NO','F634',43.6006012,13.2710014,21.8698,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042031','Morro d\'Alba','Morro d\'Alba','','NO','F745',43.6010277,13.2139130,19.3929,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042032','Numana','Numana','','NO','F978',43.5134574,13.6215023,11.0171,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042033','Offagna','Offagna','','NO','G003',43.5272223,13.4414899,10.8015,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042034','Osimo','Osimo','','NO','G157',43.4861632,13.4819020,106.4372,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042035','Ostra','Ostra','','NO','F401',43.6125398,13.1583783,47.1073,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042036','Ostra Vetere','Ostra Vetere','','NO','F581',43.6036524,13.0573844,30.2231,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042037','Poggio San Marcello','Poggio San Marcello','','NO','G771',43.5114522,13.0770274,13.2150,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042038','Polverigi','Polverigi','','NO','G803',43.5252507,13.3940600,25.0092,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042040','Rosora','Rosora','','NO','H575',43.4827561,13.0693119,9.4151,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042041','San Marcello','San Marcello','','NO','H979',43.5767291,13.2061993,25.7715,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042042','San Paolo di Jesi','San Paolo di Jesi','','NO','I071',43.4549461,13.1736398,10.0710,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042043','Santa Maria Nuova','Santa Maria Nuova','','NO','I251',43.4958997,13.3105193,18.4843,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042044','Sassoferrato','Sassoferrato','','NO','I461',43.4359568,12.8586831,137.2861,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042045','Senigallia','Senigallia','','NO','I608',43.7147748,13.2177666,118.1333,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042046','Serra de\' Conti','Serra de\' Conti','','NO','I643',43.5424453,13.0379576,24.5124,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042047','Serra San Quirico','Serra San Quirico','','NO','I653',43.4477401,13.0150464,49.4245,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042048','Sirolo','Sirolo','','NO','I758',43.5259722,13.6160562,16.8056,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042049','Staffolo','Staffolo','','NO','I932',43.4328341,13.1862575,27.5555,'042');
INSERT INTO `gi_comuni` VALUES ('AN','042050','Trecastelli','Trecastelli','','NO','M318',43.6717951,13.1063385,38.7048,'042');
INSERT INTO `gi_comuni` VALUES ('MC','043002','Apiro','Apiro','','NO','A329',43.3924782,13.1309915,53.5921,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043003','Appignano','Appignano','','NO','A334',43.3640472,13.3462537,23.0066,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043004','Belforte del Chienti','Belforte del Chienti','','NO','A739',43.1642416,13.2377093,15.9965,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043005','Bolognola','Bolognola','','NO','A947',42.9943927,13.2266305,26.1774,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043006','Caldarola','Caldarola','','NO','B398',43.1383354,13.2262592,29.3252,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043007','Camerino','Camerino','','NO','B474',43.1360047,13.0678950,129.6920,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043008','Camporotondo di Fiastrone','Camporotondo di Fiastrone','','NO','B562',43.1317706,13.2655414,8.8469,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043009','Castelraimondo','Castelraimondo','','NO','C251',43.2099718,13.0577239,44.4318,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043010','Castelsantangelo sul Nera','Castelsantangelo sul Nera','','NO','C267',42.8943614,13.1530500,70.9658,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043011','Cessapalombo','Cessapalombo','','NO','C582',43.1090694,13.2584017,27.2751,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043012','Cingoli','Cingoli','','NO','C704',43.3742481,13.2164535,148.3730,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043013','Civitanova Marche','Civitanova Marche','','NO','C770',43.3068139,13.7283984,45.9581,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043014','Colmurano','Colmurano','','NO','C886',43.1638966,13.3567096,11.0399,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043015','Corridonia','Corridonia','','NO','D042',43.2480652,13.5088126,61.8351,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043016','Esanatoglia','Esanatoglia','','NO','D429',43.2514531,12.9461403,48.3249,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043017','Fiastra','Fiastra','','NO','D564',43.0357409,13.1560024,84.4216,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043019','Fiuminata','Fiuminata','','NO','D628',43.1885773,12.9316837,76.0047,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043020','Gagliole','Gagliole','','NO','D853',43.2394241,13.0679699,23.9647,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043021','Gualdo','Gualdo','','NO','E228',43.0673094,13.3379364,22.1281,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043022','Loro Piceno','Loro Piceno','','NO','E694',43.1660637,13.4162018,32.4824,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043023','Macerata','Macerata','','SI','E783',43.3002171,13.4531221,92.4898,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043024','Matelica','Matelica','','NO','F051',43.2508713,13.0072580,81.4145,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043025','Mogliano','Mogliano','','NO','F268',43.1862750,13.4818327,29.3554,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043026','Montecassiano','Montecassiano','','NO','F454',43.3636273,13.4366360,33.7441,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043027','Monte Cavallo','Monte Cavallo','','NO','F460',42.9934238,13.0013368,38.7011,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043028','Montecosaro','Montecosaro','','NO','F482',43.3168421,13.6351151,21.8091,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043029','Montefano','Montefano','','NO','F496',43.4115767,13.4383779,33.7177,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043030','Montelupone','Montelupone','','NO','F552',43.3443303,13.5671555,32.8509,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043031','Monte San Giusto','Monte San Giusto','','NO','F621',43.2360030,13.5941337,20.1184,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043032','Monte San Martino','Monte San Martino','','NO','F622',43.0312239,13.4391053,18.8827,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043033','Morrovalle','Morrovalle','','NO','F749',43.3146743,13.5799863,42.4529,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043034','Muccia','Muccia','','NO','F793',43.0820838,13.0437731,25.8648,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043035','Penna San Giovanni','Penna San Giovanni','','NO','G436',43.0563723,13.4242561,27.8079,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043036','Petriolo','Petriolo','','NO','G515',43.2210136,13.4656349,15.6862,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043038','Pieve Torina','Pieve Torina','','NO','G657',43.0443121,13.0503575,75.0057,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043039','Pioraco','Pioraco','','NO','G690',43.1788079,12.9848520,19.8114,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043040','Poggio San Vicino','Poggio San Vicino','','NO','D566',43.3744246,13.0784162,13.1847,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043041','Pollenza','Pollenza','','NO','F567',43.2677669,13.3475740,39.4141,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043042','Porto Recanati','Porto Recanati','','NO','G919',43.4298439,13.6648412,16.9861,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043043','Potenza Picena','Potenza Picena','','NO','F632',43.3662388,13.6202369,48.5056,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043044','Recanati','Recanati','','NO','H211',43.4038698,13.5489681,103.4677,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043045','Ripe San Ginesio','Ripe San Ginesio','','NO','H323',43.1429978,13.3674544,10.3074,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043046','San Ginesio','San Ginesio','','NO','H876',43.1079483,13.3167573,78.0755,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043047','San Severino Marche','San Severino Marche','','NO','I156',43.2287886,13.1772944,194.3335,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043048','Sant\'Angelo in Pontano','Sant\'Angelo in Pontano','','NO','I286',43.0991821,13.3955464,27.5340,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043049','Sarnano','Sarnano','','NO','I436',43.0355261,13.3007299,62.9680,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043050','Sefro','Sefro','','NO','I569',43.1462765,12.9492812,42.2339,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043051','Serrapetrona','Serrapetrona','','NO','I651',43.1768975,13.1893799,37.5360,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043052','Serravalle di Chienti','Serravalle di Chienti','','NO','I661',43.0717912,12.9520592,96.1059,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043053','Tolentino','Tolentino','','NO','L191',43.2087121,13.2843743,95.1714,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043054','Treia','Treia','','NO','L366',43.3112417,13.3122744,93.2989,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043055','Urbisaglia','Urbisaglia','','NO','L501',43.1972154,13.3773599,22.9271,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043056','Ussita','Ussita','','NO','L517',42.9440388,13.1384299,55.0587,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043057','Visso','Visso','','NO','M078',42.9308479,13.0888506,100.7932,'043');
INSERT INTO `gi_comuni` VALUES ('MC','043058','Valfornace','Valfornace','','NO','M382',43.0621930,13.0844292,48.2481,'043');
INSERT INTO `gi_comuni` VALUES ('AP','044001','Acquasanta Terme','Acquasanta Terme','','NO','A044',42.7691183,13.4092475,138.8873,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044002','Acquaviva Picena','Acquaviva Picena','','NO','A047',42.9446387,13.8127610,21.0432,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044005','Appignano del Tronto','Appignano del Tronto','','NO','A335',42.8990632,13.6659040,23.3298,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044006','Arquata del Tronto','Arquata del Tronto','','NO','A437',42.7774757,13.2941120,92.0336,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044007','Ascoli Piceno','Ascoli Piceno','','SI','A462',42.8532267,13.5771546,157.9561,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044010','Carassai','Carassai','','NO','B727',43.0321354,13.6835681,22.1210,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044011','Castel di Lama','Castel di Lama','','NO','C093',42.8703521,13.7128569,10.9872,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044012','Castignano','Castignano','','NO','C321',42.9380229,13.6216092,38.5731,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044013','Castorano','Castorano','','NO','C331',42.8982806,13.7276997,14.1233,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044014','Colli del Tronto','Colli del Tronto','','NO','C877',42.8780015,13.7481758,5.9645,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044015','Comunanza','Comunanza','','NO','C935',42.9578345,13.4139244,54.3730,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044016','Cossignano','Cossignano','','NO','D096',42.9840577,13.6879531,15.3525,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044017','Cupra Marittima','Cupra Marittima','','NO','D210',43.0250623,13.8590065,17.4035,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044020','Folignano','Folignano','','NO','D652',42.8210004,13.6325695,14.9589,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044021','Force','Force','','NO','D691',42.9630130,13.4910487,34.6876,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044023','Grottammare','Grottammare','','NO','E207',42.9883984,13.8683635,17.9335,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044027','Maltignano','Maltignano','','NO','E868',42.8314676,13.6864810,8.2915,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044029','Massignano','Massignano','','NO','F044',43.0509179,13.7972086,16.5458,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044031','Monsampolo del Tronto','Monsampolo del Tronto','','NO','F380',42.8974116,13.7945046,15.4135,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044032','Montalto delle Marche','Montalto delle Marche','','NO','F415',42.9874682,13.6068894,33.9115,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044034','Montedinove','Montedinove','','NO','F487',42.9705513,13.5869228,12.0076,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044036','Montefiore dell\'Aso','Montefiore dell\'Aso','','NO','F501',43.0516574,13.7512864,28.0033,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044038','Montegallo','Montegallo','','NO','F516',42.8420955,13.3329853,48.2176,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044044','Montemonaco','Montemonaco','','NO','F570',42.8992482,13.3268125,67.5478,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044045','Monteprandone','Monteprandone','','NO','F591',42.9201338,13.8357035,26.8679,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044054','Offida','Offida','','NO','G005',42.9349959,13.6912581,49.1820,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044056','Palmiano','Palmiano','','NO','G289',42.8993331,13.4584595,12.3888,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044063','Ripatransone','Ripatransone','','NO','H321',43.0002558,13.7625897,74.3630,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044064','Roccafluvione','Roccafluvione','','NO','H390',42.8612364,13.4751959,61.0680,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044065','Rotella','Rotella','','NO','H588',42.9545077,13.5609500,27.4939,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044066','San Benedetto del Tronto','San Benedetto del Tronto','','NO','H769',42.9434153,13.8832129,25.2292,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044071','Spinetoli','Spinetoli','','NO','I912',42.8892804,13.7734708,12.2945,'044');
INSERT INTO `gi_comuni` VALUES ('AP','044073','Venarotta','Venarotta','','NO','L728',42.8811941,13.4928768,30.0544,'044');
INSERT INTO `gi_comuni` VALUES ('MS','045001','Aulla','Aulla','','NO','A496',44.2092283,9.9681138,59.7714,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045002','Bagnone','Bagnone','','NO','A576',44.3194130,9.9930644,74.2706,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045003','Carrara','Carrara','','SI','B832',44.0775122,10.0967816,71.0567,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045004','Casola in Lunigiana','Casola in Lunigiana','','NO','B979',44.2015905,10.1757934,41.9773,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045005','Comano','Comano','','NO','C914',44.2911767,10.1290715,53.9256,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045006','Filattiera','Filattiera','','NO','D590',44.3311453,9.9369379,48.6335,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045007','Fivizzano','Fivizzano','','NO','D629',44.2368415,10.1228081,180.7381,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045008','Fosdinovo','Fosdinovo','','NO','D735',44.1344635,10.0189322,48.1796,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045009','Licciana Nardi','Licciana Nardi','','NO','E574',44.2651023,10.0384871,55.9239,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045010','Massa','Massa','','SI','F023',44.0366108,10.1411152,93.8856,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045011','Montignoso','Montignoso','','NO','F679',43.9871017,10.1485136,16.9674,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045012','Mulazzo','Mulazzo','','NO','F802',44.3212692,9.9072494,62.3117,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045013','Podenzana','Podenzana','','NO','G746',44.2063586,9.9409357,17.2284,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045014','Pontremoli','Pontremoli','','NO','G870',44.3773184,9.8833112,182.7137,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045015','Tresana','Tresana','','NO','L386',44.2377424,9.9510889,44.6136,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045016','Villafranca in Lunigiana','Villafranca in Lunigiana','','NO','L946',44.2924225,9.9513741,28.8749,'045');
INSERT INTO `gi_comuni` VALUES ('MS','045017','Zeri','Zeri','','NO','M169',44.3530294,9.7638303,73.4829,'045');
INSERT INTO `gi_comuni` VALUES ('LU','046001','Altopascio','Altopascio','','NO','A241',43.8149929,10.6748987,28.6358,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046002','Bagni di Lucca','Bagni di Lucca','','NO','A560',44.0103221,10.5915616,164.9667,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046003','Barga','Barga','','NO','A657',44.0734132,10.4850716,66.2621,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046004','Borgo a Mozzano','Borgo a Mozzano','','NO','B007',43.9782803,10.5434745,72.0260,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046005','Camaiore','Camaiore','','NO','B455',43.9385356,10.3041795,84.8147,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046006','Camporgiano','Camporgiano','','NO','B557',44.1585720,10.3337021,26.9494,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046007','Capannori','Capannori','','NO','B648',43.8493281,10.5753936,155.8573,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046008','Careggine','Careggine','','NO','B760',44.1206860,10.3250170,24.2736,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046009','Castelnuovo di Garfagnana','Castelnuovo di Garfagnana','','NO','C236',44.1099550,10.4115700,28.6287,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046010','Castiglione di Garfagnana','Castiglione di Garfagnana','','NO','C303',44.1485921,10.4096899,48.4558,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046011','Coreglia Antelminelli','Coreglia Antelminelli','','NO','C996',44.0644170,10.5253880,53.0834,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046013','Forte dei Marmi','Forte dei Marmi','','NO','D730',43.9601821,10.1667111,9.2547,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046014','Fosciandora','Fosciandora','','NO','D734',44.1153135,10.4552699,20.1686,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046015','Gallicano','Gallicano','','NO','D874',44.0607623,10.4352497,31.1899,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046017','Lucca','Lucca','','SI','E715',43.8442458,10.5015454,185.9898,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046018','Massarosa','Massarosa','','NO','F035',43.8684376,10.3422585,67.9079,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046019','Minucciano','Minucciano','','NO','F225',44.1702217,10.2078822,57.2579,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046020','Molazzana','Molazzana','','NO','F283',44.0731602,10.4190435,31.2380,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046021','Montecarlo','Montecarlo','','NO','F452',43.8508970,10.6677035,16.0335,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046022','Pescaglia','Pescaglia','','NO','G480',43.9659848,10.4107696,70.5294,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046023','Piazza al Serchio','Piazza al Serchio','','NO','G582',44.1829353,10.2995638,27.3077,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046024','Pietrasanta','Pietrasanta','','NO','G628',43.9601265,10.2264924,42.2266,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046025','Pieve Fosciana','Pieve Fosciana','','NO','G648',44.1329271,10.4115266,28.5148,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046026','Porcari','Porcari','','NO','G882',43.8399896,10.6163401,18.0093,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046027','San Romano in Garfagnana','San Romano in Garfagnana','','NO','I142',44.1682812,10.3472536,26.0289,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046028','Seravezza','Seravezza','','NO','I622',43.9952239,10.2284042,39.5187,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046030','Stazzema','Stazzema','','NO','I942',43.9971248,10.2958150,80.2623,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046031','Vagli Sotto','Vagli Sotto','','NO','L533',44.1132350,10.2805519,41.2862,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046033','Viareggio','Viareggio','','NO','L833',43.8669549,10.2497985,32.7524,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046034','Villa Basilica','Villa Basilica','','NO','L913',43.9278648,10.6451567,36.3366,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046035','Villa Collemandina','Villa Collemandina','','NO','L926',44.1599022,10.3967139,34.7106,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046036','Fabbriche di Vergemoli','Fabbriche di Vergemoli','','NO','M319',43.9993138,10.4322077,42.1997,'046');
INSERT INTO `gi_comuni` VALUES ('LU','046037','Sillano Giuncugnano','Sillano Giuncugnano','','NO','M347',44.2231650,10.3000078,81.2329,'046');
INSERT INTO `gi_comuni` VALUES ('PT','047002','Agliana','Agliana','','NO','A071',43.9027119,11.0063926,11.7461,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047003','Buggiano','Buggiano','','NO','B251',43.8799039,10.7275639,16.1626,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047005','Lamporecchio','Lamporecchio','','NO','E432',43.8168625,10.8966125,21.9824,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047006','Larciano','Larciano','','NO','E451',43.8243618,10.8778629,25.4695,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047007','Marliana','Marliana','','NO','E960',43.9337989,10.7699577,42.6902,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047008','Massa e Cozzile','Massa e Cozzile','','NO','F025',43.9099708,10.7441629,16.3031,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047009','Monsummano Terme','Monsummano Terme','','NO','F384',43.8724188,10.8147316,32.5603,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047010','Montale','Montale','','NO','F410',43.9348142,11.0216439,32.2551,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047011','Montecatini-Terme','Montecatini-Terme','','NO','A561',43.8840878,10.7727522,17.5712,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047012','Pescia','Pescia','','NO','G491',43.9043151,10.6889004,78.6860,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047013','Pieve a Nievole','Pieve a Nievole','','NO','G636',43.8790410,10.7949684,12.9622,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047014','Pistoia','Pistoia','','SI','G713',43.9338792,10.9182623,236.4624,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047016','Ponte Buggianese','Ponte Buggianese','','NO','G833',43.8408007,10.7474350,29.8167,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047017','Quarrata','Quarrata','','NO','H109',43.8471367,10.9785919,46.0423,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047018','Sambuca Pistoiese','Sambuca Pistoiese','','NO','H744',44.1040355,10.9990596,77.3497,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047020','Serravalle Pistoiese','Serravalle Pistoiese','','NO','I660',43.9057524,10.8328029,41.8738,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047021','Uzzano','Uzzano','','NO','L522',43.8815923,10.7087206,7.8041,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047022','Chiesina Uzzanese','Chiesina Uzzanese','','NO','C631',43.8392733,10.7196370,7.0839,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047023','Abetone Cutigliano','Abetone Cutigliano','','NO','M376',44.1001033,10.7557584,74.9055,'047');
INSERT INTO `gi_comuni` VALUES ('PT','047024','San Marcello Piteglio','San Marcello Piteglio','','NO','M377',44.0555494,10.7916830,134.9511,'047');
INSERT INTO `gi_comuni` VALUES ('FI','048001','Bagno a Ripoli','Bagno a Ripoli','','NO','A564',43.7512723,11.3196663,73.8318,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048002','Barberino di Mugello','Barberino di Mugello','','NO','A632',44.0004033,11.2385959,132.9396,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048004','Borgo San Lorenzo','Borgo San Lorenzo','','NO','B036',43.9547698,11.3877614,146.6511,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048005','Calenzano','Calenzano','','NO','B406',43.8650863,11.1672154,77.4714,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048006','Campi Bisenzio','Campi Bisenzio','','NO','B507',43.8205968,11.1380393,28.7466,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048008','Capraia e Limite','Capraia e Limite','','NO','B684',43.7425718,10.9757845,24.9906,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048010','Castelfiorentino','Castelfiorentino','','NO','C101',43.6057870,10.9712500,66.1839,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048011','Cerreto Guidi','Cerreto Guidi','','NO','C529',43.7602307,10.8770045,49.4217,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048012','Certaldo','Certaldo','','NO','C540',43.5473834,11.0408107,75.2447,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048013','Dicomano','Dicomano','','NO','D299',43.8914909,11.5236664,61.7850,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048014','Empoli','Empoli','','NO','D403',43.7189879,10.9472435,62.7238,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048015','Fiesole','Fiesole','','NO','D575',43.8065979,11.2936484,42.1681,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048017','Firenze','Firenze','','SI','D612',43.7692262,11.2566059,102.1789,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048018','Firenzuola','Firenzuola','','NO','D613',44.1182653,11.3780403,271.7573,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048019','Fucecchio','Fucecchio','','NO','D815',43.7285944,10.8100981,65.2748,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048020','Gambassi Terme','Gambassi Terme','','NO','D895',43.5387197,10.9534923,83.1840,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048021','Greve in Chianti','Greve in Chianti','','NO','E169',43.5829428,11.3168722,169.5530,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048022','Impruneta','Impruneta','','NO','E291',43.6857797,11.2546390,49.2931,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048024','Lastra a Signa','Lastra a Signa','','NO','E466',43.7703818,11.1060673,42.5954,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048025','Londa','Londa','','NO','E668',43.8603661,11.5668014,59.3153,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048026','Marradi','Marradi','','NO','E971',44.0756375,11.6126918,154.3306,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048027','Montaione','Montaione','','NO','F398',43.5524323,10.9115026,105.0052,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048028','Montelupo Fiorentino','Montelupo Fiorentino','','NO','F551',43.7297003,11.0198762,25.0036,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048030','Montespertoli','Montespertoli','','NO','F648',43.6430709,11.0750837,124.4984,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048031','Palazzuolo sul Senio','Palazzuolo sul Senio','','NO','G270',44.1123974,11.5474978,108.8752,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048032','Pelago','Pelago','','NO','G420',43.7700229,11.5056991,54.7453,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048033','Pontassieve','Pontassieve','','NO','G825',43.7758485,11.4399182,114.2082,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048035','Reggello','Reggello','','NO','H222',43.6824376,11.5363300,121.5403,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048036','Rignano sull\'Arno','Rignano sull\'Arno','','NO','H286',43.7218720,11.4535273,54.2987,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048037','Rufina','Rufina','','NO','H635',43.8270611,11.4883753,46.0019,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048038','San Casciano in Val di Pesa','San Casciano in Val di Pesa','','NO','H791',43.6566884,11.1843666,106.9081,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048039','San Godenzo','San Godenzo','','NO','H937',43.9262830,11.6197288,99.3244,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048041','Scandicci','Scandicci','','NO','B962',43.7584483,11.1811544,59.9636,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048043','Sesto Fiorentino','Sesto Fiorentino','','NO','I684',43.8320801,11.1983736,48.0989,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048044','Signa','Signa','','NO','I728',43.7822575,11.0968612,18.9491,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048046','Vaglia','Vaglia','','NO','L529',43.9065605,11.2814140,56.7042,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048049','Vicchio','Vicchio','','NO','L838',43.9335756,11.4652527,137.9278,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048050','Vinci','Vinci','','NO','M059',43.7875549,10.9264903,54.0600,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048052','Figline e Incisa Valdarno','Figline e Incisa Valdarno','','NO','M321',43.6635132,11.4495565,97.6504,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048053','Scarperia e San Piero','Scarperia e San Piero','','NO','M326',43.9974474,11.3554486,116.2616,'248');
INSERT INTO `gi_comuni` VALUES ('FI','048054','Barberino Tavarnelle','Barberino Tavarnelle','','NO','M408',43.5608690,11.1726921,123.6288,'248');
INSERT INTO `gi_comuni` VALUES ('LI','049001','Bibbona','Bibbona','','NO','A852',43.2694022,10.5985841,65.5981,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049002','Campiglia Marittima','Campiglia Marittima','','NO','B509',43.0310147,10.6034063,83.1732,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049003','Campo nell\'Elba','Campo nell\'Elba','','NO','B553',42.7446199,10.2334564,56.1402,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049004','Capoliveri','Capoliveri','','NO','B669',42.7425494,10.3820982,39.5990,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049005','Capraia Isola','Capraia Isola','','NO','B685',43.0498667,9.8424612,19.3668,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049006','Castagneto Carducci','Castagneto Carducci','','NO','C044',43.1606226,10.6101306,142.4476,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049007','Cecina','Cecina','','NO','C415',43.3121894,10.5193778,42.4962,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049008','Collesalvetti','Collesalvetti','','NO','C869',43.5891291,10.4760952,107.8828,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049009','Livorno','Livorno','','SI','E625',43.5522323,10.3080570,105.3355,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049010','Marciana','Marciana','','NO','E930',42.7898291,10.1680074,45.3102,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049011','Marciana Marina','Marciana Marina','','NO','E931',42.8042992,10.1998978,5.9601,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049012','Piombino','Piombino','','NO','G687',42.9219671,10.5268518,131.1552,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049013','Porto Azzurro','Porto Azzurro','','NO','E680',42.7645689,10.3987053,13.4140,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049014','Portoferraio','Portoferraio','','NO','G912',42.8151229,10.3309242,48.0966,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049017','Rosignano Marittimo','Rosignano Marittimo','','NO','H570',43.3506483,10.4566096,120.6128,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049018','San Vincenzo','San Vincenzo','','NO','I390',43.1007346,10.5380286,33.1416,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049019','Sassetta','Sassetta','','NO','I454',43.1283659,10.6442862,27.0629,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049020','Suvereto','Suvereto','','NO','L019',43.0790658,10.6791738,92.3054,'049');
INSERT INTO `gi_comuni` VALUES ('LI','049021','Rio','Rio','','NO','M391',42.8134989,10.3996872,36.6217,'049');
INSERT INTO `gi_comuni` VALUES ('PI','050001','Bientina','Bientina','','NO','A864',43.7099767,10.6197838,29.5691,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050002','Buti','Buti','','NO','B303',43.7275062,10.5873636,22.9361,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050003','Calci','Calci','','NO','B390',43.7258242,10.5156383,25.4971,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050004','Calcinaia','Calcinaia','','NO','B392',43.6826798,10.6157995,14.8528,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050005','Capannoli','Capannoli','','NO','B647',43.5840318,10.6789771,22.9427,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050006','Casale Marittimo','Casale Marittimo','','NO','B878',43.2972880,10.6154859,14.6314,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050008','Cascina','Cascina','','NO','B950',43.6765770,10.5486453,78.7206,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050009','Castelfranco di Sotto','Castelfranco di Sotto','','NO','C113',43.6995578,10.7452755,47.5218,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050010','Castellina Marittima','Castellina Marittima','','NO','C174',43.4118574,10.5755827,45.7917,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050011','Castelnuovo di Val di Cecina','Castelnuovo di Val di Cecina','','NO','C244',43.2067226,10.9056421,88.8145,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050012','Chianni','Chianni','','NO','C609',43.4859201,10.6426740,62.0807,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050014','Fauglia','Fauglia','','NO','D510',43.5670178,10.5158318,42.6221,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050015','Guardistallo','Guardistallo','','NO','E250',43.3127517,10.6329150,23.5632,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050016','Lajatico','Lajatico','','NO','E413',43.4750480,10.7285299,72.7166,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050019','Montecatini Val di Cecina','Montecatini Val di Cecina','','NO','F458',43.3918690,10.7482933,155.0883,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050020','Montescudaio','Montescudaio','','NO','F640',43.3266349,10.6273109,19.9883,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050021','Monteverdi Marittimo','Monteverdi Marittimo','','NO','F661',43.1769463,10.7148944,98.0728,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050022','Montopoli in Val d\'Arno','Montopoli in Val d\'Arno','','NO','F686',43.6687779,10.7605331,30.6471,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050023','Orciano Pisano','Orciano Pisano','','NO','G090',43.4933040,10.5109372,11.9291,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050024','Palaia','Palaia','','NO','G254',43.6047223,10.7731000,73.5184,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050025','Peccioli','Peccioli','','NO','G395',43.5479719,10.7210041,92.3486,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050026','Pisa','Pisa','','SI','G702',43.7154608,10.4010877,184.9305,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050027','Pomarance','Pomarance','','NO','G804',43.3000961,10.8738189,227.4585,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050028','Ponsacco','Ponsacco','','NO','G822',43.6203953,10.6333798,20.1109,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050029','Pontedera','Pontedera','','NO','G843',43.6639210,10.6356085,45.8874,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050030','Riparbella','Riparbella','','NO','H319',43.3646656,10.5998244,58.8681,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050031','San Giuliano Terme','San Giuliano Terme','','NO','A562',43.7634459,10.4431991,92.2244,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050032','San Miniato','San Miniato','','NO','I046',43.6795576,10.8526292,102.0092,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050033','Santa Croce sull\'Arno','Santa Croce sull\'Arno','','NO','I177',43.7113971,10.7788021,16.8493,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050034','Santa Luce','Santa Luce','','NO','I217',43.4724808,10.5648031,66.3260,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050035','Santa Maria a Monte','Santa Maria a Monte','','NO','I232',43.6987711,10.6922992,38.2200,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050036','Terricciola','Terricciola','','NO','L138',43.5247319,10.6762613,43.0544,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050037','Vecchiano','Vecchiano','','NO','L702',43.7815805,10.3865547,67.7594,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050038','Vicopisano','Vicopisano','','NO','L850',43.6999061,10.5844365,26.7669,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050039','Volterra','Volterra','','NO','M126',43.4017661,10.8594039,252.9447,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050040','Casciana Terme Lari','Casciana Terme Lari','','NO','M327',43.5664451,10.5923705,81.3544,'050');
INSERT INTO `gi_comuni` VALUES ('PI','050041','Crespina Lorenzana','Crespina Lorenzana','','NO','M328',43.5740065,10.5637603,46.1000,'050');
INSERT INTO `gi_comuni` VALUES ('AR','051001','Anghiari','Anghiari','','NO','A291',43.5404508,12.0571294,130.5090,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051002','Arezzo','Arezzo','','SI','A390',43.4667567,11.8820628,384.6071,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051003','Badia Tedalda','Badia Tedalda','','NO','A541',43.7088288,12.1850853,118.8946,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051004','Bibbiena','Bibbiena','','NO','A851',43.6943753,11.8182009,87.0359,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051005','Bucine','Bucine','','NO','B243',43.4794018,11.6170502,131.7347,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051006','Capolona','Capolona','','NO','B670',43.5635664,11.8594307,47.9660,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051007','Caprese Michelangelo','Caprese Michelangelo','','NO','B693',43.6418742,11.9865849,66.5434,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051008','Castel Focognano','Castel Focognano','','NO','C102',43.6515534,11.8356500,56.3064,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051010','Castel San Niccolò','Castel San Niccolò','','NO','C263',43.7419253,11.7053002,83.2323,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051011','Castiglion Fibocchi','Castiglion Fibocchi','','NO','C318',43.5277285,11.7632439,25.2753,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051012','Castiglion Fiorentino','Castiglion Fiorentino','','NO','C319',43.3413756,11.9239825,111.4933,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051013','Cavriglia','Cavriglia','','NO','C407',43.5222530,11.4885042,60.4552,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051014','Chitignano','Chitignano','','NO','C648',43.6613835,11.8805814,15.1493,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051015','Chiusi della Verna','Chiusi della Verna','','NO','C663',43.6999360,11.9344473,101.7133,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051016','Civitella in Val di Chiana','Civitella in Val di Chiana','','NO','C774',43.4031731,11.7709154,100.2367,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051017','Cortona','Cortona','','NO','D077',43.2750456,11.9851382,343.0360,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051018','Foiano della Chiana','Foiano della Chiana','','NO','D649',43.2523558,11.8184119,40.8497,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051020','Loro Ciuffenna','Loro Ciuffenna','','NO','E693',43.5933622,11.6315339,87.0622,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051021','Lucignano','Lucignano','','NO','E718',43.2747617,11.7462118,44.8691,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051022','Marciano della Chiana','Marciano della Chiana','','NO','E933',43.3050345,11.7860160,23.8076,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051023','Montemignaio','Montemignaio','','NO','F565',43.7399445,11.6198353,26.0077,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051024','Monterchi','Monterchi','','NO','F594',43.4855147,12.1118279,29.7961,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051025','Monte San Savino','Monte San Savino','','NO','F628',43.3314305,11.7245326,89.9362,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051026','Montevarchi','Montevarchi','','NO','F656',43.5236412,11.5673990,56.5396,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051027','Ortignano Raggiolo','Ortignano Raggiolo','','NO','G139',43.6814813,11.7525364,36.2095,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051030','Pieve Santo Stefano','Pieve Santo Stefano','','NO','G653',43.6688283,12.0416966,156.0944,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051031','Poppi','Poppi','','NO','G879',43.7233020,11.7656032,97.0674,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051033','San Giovanni Valdarno','San Giovanni Valdarno','','NO','H901',43.5665195,11.5300459,21.5437,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051034','Sansepolcro','Sansepolcro','','NO','I155',43.5709738,12.1416789,90.7984,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051035','Sestino','Sestino','','NO','I681',43.7083514,12.2972000,80.4496,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051037','Subbiano','Subbiano','','NO','I991',43.5754656,11.8703396,78.3906,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051038','Talla','Talla','','NO','L038',43.6019730,11.7867743,59.7380,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051039','Terranuova Bracciolini','Terranuova Bracciolini','','NO','L123',43.5508914,11.5858110,85.2187,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051040','Castelfranco Piandiscò','Castelfranco Piandiscò','','NO','M322',43.6209783,11.5543573,56.1531,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051041','Pratovecchio Stia','Pratovecchio Stia','','NO','M329',43.7986982,11.7086106,138.3229,'051');
INSERT INTO `gi_comuni` VALUES ('AR','051042','Laterina Pergine Valdarno','Laterina Pergine Valdarno','','NO','M392',43.4704532,11.6855258,70.6493,'051');
INSERT INTO `gi_comuni` VALUES ('SI','052001','Abbadia San Salvatore','Abbadia San Salvatore','','NO','A006',42.8809596,11.6772509,58.8852,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052002','Asciano','Asciano','','NO','A461',43.2348457,11.5594830,216.1480,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052003','Buonconvento','Buonconvento','','NO','B269',43.1383416,11.4821315,64.9065,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052004','Casole d\'Elsa','Casole d\'Elsa','','NO','B984',43.3414240,11.0452307,148.7432,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052005','Castellina in Chianti','Castellina in Chianti','','NO','C172',43.4699861,11.2856627,99.6619,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052006','Castelnuovo Berardenga','Castelnuovo Berardenga','','NO','C227',43.3455373,11.5020148,177.4617,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052007','Castiglione d\'Orcia','Castiglione d\'Orcia','','NO','C313',43.0045058,11.6167990,141.2997,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052008','Cetona','Cetona','','NO','C587',42.9655893,11.9002676,53.5020,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052009','Chianciano Terme','Chianciano Terme','','NO','C608',43.0585889,11.8312693,36.9234,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052010','Chiusdino','Chiusdino','','NO','C661',43.1551546,11.0881032,140.8620,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052011','Chiusi','Chiusi','','NO','C662',43.0166678,11.9477159,57.9527,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052012','Colle di Val d\'Elsa','Colle di Val d\'Elsa','','NO','C847',43.4213539,11.1173087,91.8515,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052013','Gaiole in Chianti','Gaiole in Chianti','','NO','D858',43.4678318,11.4340795,128.7263,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052015','Montepulciano','Montepulciano','','NO','F592',43.0927863,11.7804473,165.5298,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052016','Monteriggioni','Monteriggioni','','NO','F598',43.3930034,11.2188851,99.7098,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052017','Monteroni d\'Arbia','Monteroni d\'Arbia','','NO','F605',43.2312070,11.4220303,105.8594,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052018','Monticiano','Monticiano','','NO','F676',43.1397089,11.1801786,109.9684,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052019','Murlo','Murlo','','NO','F815',43.1684390,11.3912567,114.7207,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052020','Piancastagnaio','Piancastagnaio','','NO','G547',42.8493000,11.6919491,69.5796,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052021','Pienza','Pienza','','NO','G602',43.0766655,11.6791336,122.7713,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052022','Poggibonsi','Poggibonsi','','NO','G752',43.4673649,11.1466235,70.9717,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052023','Radda in Chianti','Radda in Chianti','','NO','H153',43.4864974,11.3741739,80.6659,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052024','Radicofani','Radicofani','','NO','H156',42.8968038,11.7664850,117.7363,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052025','Radicondoli','Radicondoli','','NO','H157',43.2610884,11.0418507,132.9228,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052026','Rapolano Terme','Rapolano Terme','','NO','H185',43.2864905,11.6041546,83.1856,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052027','San Casciano dei Bagni','San Casciano dei Bagni','','NO','H790',42.8712425,11.8752504,92.5284,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052028','San Gimignano','San Gimignano','','NO','H875',43.4675310,11.0430697,138.4427,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052030','San Quirico d\'Orcia','San Quirico d\'Orcia','','NO','I135',43.0603933,11.6037668,43.1070,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052031','Sarteano','Sarteano','','NO','I445',42.9895254,11.8691610,84.9332,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052032','Siena','Siena','','SI','I726',43.3180049,11.3320017,118.4303,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052033','Sinalunga','Sinalunga','','NO','A468',43.2121397,11.7369724,78.9550,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052034','Sovicille','Sovicille','','NO','I877',43.2802561,11.2280741,143.0608,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052035','Torrita di Siena','Torrita di Siena','','NO','L303',43.1666517,11.7719160,58.1014,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052036','Trequanda','Trequanda','','NO','L384',43.1889049,11.6676331,63.6009,'052');
INSERT INTO `gi_comuni` VALUES ('SI','052037','Montalcino','Montalcino','','NO','M378',43.0612441,11.4899181,309.2515,'052');
INSERT INTO `gi_comuni` VALUES ('GR','053001','Arcidosso','Arcidosso','','NO','A369',42.8714879,11.5387050,93.6798,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053002','Campagnatico','Campagnatico','','NO','B497',42.8827007,11.2749396,162.0507,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053003','Capalbio','Capalbio','','NO','B646',42.4529058,11.4221884,187.6326,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053004','Castel del Piano','Castel del Piano','','NO','C085',42.8929281,11.5376979,68.0654,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053005','Castell\'Azzara','Castell\'Azzara','','NO','C147',42.7734848,11.6977926,63.9618,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053006','Castiglione della Pescaia','Castiglione della Pescaia','','NO','C310',42.7725001,10.8908703,209.3302,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053007','Cinigiano','Cinigiano','','NO','C705',42.8911665,11.3945600,160.7460,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053008','Civitella Paganico','Civitella Paganico','','NO','C782',42.9938199,11.2815739,193.5576,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053009','Follonica','Follonica','','NO','D656',42.9225899,10.7598518,55.9555,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053010','Gavorrano','Gavorrano','','NO','D948',42.9255057,10.9059419,164.8901,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053011','Grosseto','Grosseto','','SI','E202',42.7602906,11.1137030,473.1703,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053012','Isola del Giglio','Isola del Giglio','','NO','E348',42.3663128,10.9002358,23.8365,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053013','Magliano in Toscana','Magliano in Toscana','','NO','E810',42.5981635,11.2942430,251.0014,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053014','Manciano','Manciano','','NO','E875',42.5873730,11.5155585,373.2220,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053015','Massa Marittima','Massa Marittima','','NO','F032',43.0503682,10.8879481,282.7542,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053016','Monte Argentario','Monte Argentario','','NO','F437',42.4387726,11.1157618,60.4803,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053017','Montieri','Montieri','','NO','F677',43.1307874,11.0161573,108.8030,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053018','Orbetello','Orbetello','','NO','G088',42.4374091,11.2098619,226.2554,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053019','Pitigliano','Pitigliano','','NO','G716',42.6350904,11.6692050,101.9521,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053020','Roccalbegna','Roccalbegna','','NO','H417',42.7858613,11.5075475,124.3660,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053021','Roccastrada','Roccastrada','','NO','H449',43.0112794,11.1674578,283.9704,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053022','Santa Fiora','Santa Fiora','','NO','I187',42.8315379,11.5855735,63.3481,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053023','Scansano','Scansano','','NO','I504',42.6879257,11.3330642,273.3372,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053024','Scarlino','Scarlino','','NO','I510',42.9061484,10.8522259,87.9030,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053025','Seggiano','Seggiano','','NO','I571',42.9285467,11.5588808,49.5180,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053026','Sorano','Sorano','','NO','I841',42.6815931,11.7137553,174.7841,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053027','Monterotondo Marittimo','Monterotondo Marittimo','','NO','F612',43.1454888,10.8559837,102.3975,'053');
INSERT INTO `gi_comuni` VALUES ('GR','053028','Semproniano','Semproniano','','NO','I601',42.7302185,11.5416973,82.0219,'053');
INSERT INTO `gi_comuni` VALUES ('PG','054001','Assisi','Assisi','','NO','A475',43.0708575,12.6149470,187.1762,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054002','Bastia Umbra','Bastia Umbra','','NO','A710',43.0666562,12.5489597,27.4810,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054003','Bettona','Bettona','','NO','A832',43.0135454,12.4845652,45.0155,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054004','Bevagna','Bevagna','','NO','A835',42.9338037,12.6089885,56.0537,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054005','Campello sul Clitunno','Campello sul Clitunno','','NO','B504',42.8200339,12.7769150,50.2524,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054006','Cannara','Cannara','','NO','B609',42.9950651,12.5827158,33.1585,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054007','Cascia','Cascia','','NO','B948',42.7181952,13.0135601,181.0321,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054008','Castel Ritaldi','Castel Ritaldi','','NO','C252',42.8231004,12.6724483,22.8935,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054009','Castiglione del Lago','Castiglione del Lago','','NO','C309',43.1276422,12.0534988,204.8966,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054010','Cerreto di Spoleto','Cerreto di Spoleto','','NO','C527',42.8210046,12.9172747,74.4395,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054011','Citerna','Citerna','','NO','C742',43.4980955,12.1163748,23.3750,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054012','Città della Pieve','Città della Pieve','','NO','C744',42.9521108,12.0025335,111.3422,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054013','Città di Castello','Città di Castello','','NO','C745',43.4570323,12.2382088,386.9325,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054014','Collazzone','Collazzone','','NO','C845',42.8995503,12.4359781,56.1568,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054015','Corciano','Corciano','','NO','C990',43.1283776,12.2861978,64.1667,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054016','Costacciaro','Costacciaro','','NO','D108',43.3589311,12.7119381,41.2758,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054017','Deruta','Deruta','','NO','D279',42.9820996,12.4197496,44.5987,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054018','Foligno','Foligno','','NO','D653',42.9558198,12.7032519,264.6782,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054019','Fossato di Vico','Fossato di Vico','','NO','D745',43.2946753,12.7613150,35.6835,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054020','Fratta Todina','Fratta Todina','','NO','D787',42.8575266,12.3665665,17.3208,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054021','Giano dell\'Umbria','Giano dell\'Umbria','','NO','E012',42.8337000,12.5780666,44.4697,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054022','Gualdo Cattaneo','Gualdo Cattaneo','','NO','E229',42.9091904,12.5561309,95.7968,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054023','Gualdo Tadino','Gualdo Tadino','','NO','E230',43.2309090,12.7848024,124.2958,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054024','Gubbio','Gubbio','','NO','E256',43.3529745,12.5793028,525.4922,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054025','Lisciano Niccone','Lisciano Niccone','','NO','E613',43.2465266,12.1432624,35.5928,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054026','Magione','Magione','','NO','E805',43.1427543,12.2052460,129.4341,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054027','Marsciano','Marsciano','','NO','E975',42.9107767,12.3373271,161.4197,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054028','Massa Martana','Massa Martana','','NO','F024',42.7755513,12.5232506,78.6492,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054029','Monte Castello di Vibio','Monte Castello di Vibio','','NO','F456',42.8403370,12.3523157,32.0541,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054030','Montefalco','Montefalco','','NO','F492',42.8937230,12.6523816,69.3904,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054031','Monteleone di Spoleto','Monteleone di Spoleto','','NO','F540',42.6515576,12.9518378,62.3907,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054032','Monte Santa Maria Tiberina','Monte Santa Maria Tiberina','','NO','F629',43.4367752,12.1626736,72.4165,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054033','Montone','Montone','','NO','F685',43.3639074,12.3269195,52.1395,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054034','Nocera Umbra','Nocera Umbra','','NO','F911',43.1112555,12.7901138,157.8607,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054035','Norcia','Norcia','','NO','F935',42.7925964,13.0931821,275.7573,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054036','Paciano','Paciano','','NO','G212',43.0223177,12.0707978,16.8288,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054037','Panicale','Panicale','','NO','G308',43.0293770,12.1000485,79.2051,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054038','Passignano sul Trasimeno','Passignano sul Trasimeno','','NO','G359',43.1848457,12.1366286,81.3834,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054039','Perugia','Perugia','','SI','G478',43.1118312,12.3885382,449.4110,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054040','Piegaro','Piegaro','','NO','G601',42.9705289,12.0860415,99.0092,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054041','Pietralunga','Pietralunga','','NO','G618',43.4422826,12.4367548,140.1156,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054042','Poggiodomo','Poggiodomo','','NO','G758',42.7116596,12.9347681,40.0512,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054043','Preci','Preci','','NO','H015',42.8789895,13.0389934,81.7893,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054044','San Giustino','San Giustino','','NO','H935',43.5484308,12.1765252,80.1108,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054045','Sant\'Anatolia di Narco','Sant\'Anatolia di Narco','','NO','I263',42.7329189,12.8356956,46.5280,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054046','Scheggia e Pascelupo','Scheggia e Pascelupo','','NO','I522',43.4035431,12.6682090,63.9146,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054047','Scheggino','Scheggino','','NO','I523',42.7125167,12.8310709,36.1451,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054048','Sellano','Sellano','','NO','I585',42.8889275,12.9271799,85.6942,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054049','Sigillo','Sigillo','','NO','I727',43.3315502,12.7409289,26.2027,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054050','Spello','Spello','','NO','I888',42.9921070,12.6710697,61.7929,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054051','Spoleto','Spoleto','','NO','I921',42.7343750,12.7383654,347.1161,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054052','Todi','Todi','','NO','L188',42.7819704,12.4069404,223.6367,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054053','Torgiano','Torgiano','','NO','L216',43.0255896,12.4339818,37.3873,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054054','Trevi','Trevi','','NO','L397',42.8774243,12.7477490,71.0133,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054055','Tuoro sul Trasimeno','Tuoro sul Trasimeno','','NO','L466',43.2087390,12.0716341,55.8526,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054056','Umbertide','Umbertide','','NO','D786',43.3065625,12.3269485,199.7793,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054057','Valfabbrica','Valfabbrica','','NO','L573',43.1594405,12.6016366,92.6168,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054058','Vallo di Nera','Vallo di Nera','','NO','L627',42.7696820,12.8623463,36.3201,'054');
INSERT INTO `gi_comuni` VALUES ('PG','054059','Valtopina','Valtopina','','NO','L653',43.0589297,12.7545816,40.4228,'054');
INSERT INTO `gi_comuni` VALUES ('TR','055001','Acquasparta','Acquasparta','','NO','A045',42.6903614,12.5462203,81.6640,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055002','Allerona','Allerona','','NO','A207',42.8115338,11.9737871,83.0550,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055003','Alviano','Alviano','','NO','A242',42.5878724,12.2955536,23.9315,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055004','Amelia','Amelia','','NO','A262',42.5587692,12.4119682,132.4167,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055005','Arrone','Arrone','','NO','A439',42.5827796,12.7691479,41.4482,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055006','Attigliano','Attigliano','','NO','A490',42.5148791,12.2893937,10.7145,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055007','Baschi','Baschi','','NO','A691',42.6701989,12.2162530,68.5994,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055008','Calvi dell\'Umbria','Calvi dell\'Umbria','','NO','B446',42.4013924,12.5675843,45.6985,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055009','Castel Giorgio','Castel Giorgio','','NO','C117',42.7077639,11.9795889,42.3585,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055010','Castel Viscardo','Castel Viscardo','','NO','C289',42.7554981,12.0015732,26.3394,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055011','Fabro','Fabro','','NO','D454',42.8633212,12.0129738,34.6154,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055012','Ferentillo','Ferentillo','','NO','D538',42.6205372,12.7900665,69.3595,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055013','Ficulle','Ficulle','','NO','D570',42.8360468,12.0662217,64.1270,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055014','Giove','Giove','','NO','E045',42.5092567,12.3252549,15.0963,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055015','Guardea','Guardea','','NO','E241',42.6235354,12.2971552,39.5550,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055016','Lugnano in Teverina','Lugnano in Teverina','','NO','E729',42.5742838,12.3305458,29.7063,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055017','Montecastrilli','Montecastrilli','','NO','F457',42.6497704,12.4878122,62.3422,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055018','Montecchio','Montecchio','','NO','F462',42.6623830,12.2870771,49.1428,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055019','Montefranco','Montefranco','','NO','F510',42.5970509,12.7662969,10.1284,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055020','Montegabbione','Montegabbione','','NO','F513',42.9215813,12.0927014,50.9403,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055021','Monteleone d\'Orvieto','Monteleone d\'Orvieto','','NO','F543',42.9164134,12.0513840,23.8336,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055022','Narni','Narni','','NO','F844',42.5192600,12.5151852,198.0534,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055023','Orvieto','Orvieto','','NO','G148',42.7181522,12.1082237,281.2834,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055024','Otricoli','Otricoli','','NO','G189',42.4232050,12.4782826,27.6674,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055025','Parrano','Parrano','','NO','G344',42.8638941,12.1065447,40.1395,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055026','Penna in Teverina','Penna in Teverina','','NO','G432',42.4923695,12.3554562,10.2837,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055027','Polino','Polino','','NO','G790',42.5848221,12.8439332,19.5493,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055028','Porano','Porano','','NO','G881',42.6872116,12.1021326,13.4881,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055029','San Gemini','San Gemini','','NO','H857',42.6134530,12.5463707,28.0850,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055030','San Venanzo','San Venanzo','','NO','I381',42.8691422,12.2664886,168.9557,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055031','Stroncone','Stroncone','','NO','I981',42.4982073,12.6627364,70.9777,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055032','Terni','Terni','','SI','L117',42.5607395,12.6467819,212.1674,'055');
INSERT INTO `gi_comuni` VALUES ('TR','055033','Avigliano Umbro','Avigliano Umbro','','NO','M258',42.6554332,12.4284779,51.2197,'055');
INSERT INTO `gi_comuni` VALUES ('VT','056001','Acquapendente','Acquapendente','','NO','A040',42.7439645,11.8647326,130.8617,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056002','Arlena di Castro','Arlena di Castro','','NO','A412',42.4629823,11.8238438,22.0529,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056003','Bagnoregio','Bagnoregio','','NO','A577',42.6258333,12.0985693,73.0103,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056004','Barbarano Romano','Barbarano Romano','','NO','A628',42.2521650,12.0656018,37.6078,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056005','Bassano Romano','Bassano Romano','','NO','A704',42.2181657,12.1929059,37.4293,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056006','Bassano in Teverina','Bassano in Teverina','','NO','A706',42.4631159,12.3084812,12.4415,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056007','Blera','Blera','','NO','A857',42.2751414,12.0252461,92.5448,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056008','Bolsena','Bolsena','','NO','A949',42.6440770,11.9867594,63.4369,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056009','Bomarzo','Bomarzo','','NO','A955',42.4911337,12.2513029,39.4302,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056010','Calcata','Calcata','','NO','B388',42.2199891,12.4257198,7.6681,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056011','Canepina','Canepina','','NO','B597',42.3808496,12.2334952,20.8185,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056012','Canino','Canino','','NO','B604',42.4642903,11.7489831,123.7302,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056013','Capodimonte','Capodimonte','','NO','B663',42.5516986,11.9124852,61.3770,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056014','Capranica','Capranica','','NO','B688',42.2564750,12.1780034,41.2491,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056015','Caprarola','Caprarola','','NO','B691',42.3276502,12.2380257,57.7922,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056016','Carbognano','Carbognano','','NO','B735',42.3317261,12.2669416,17.5129,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056017','Castel Sant\'Elia','Castel Sant\'Elia','','NO','C269',42.2495723,12.3682283,24.2390,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056018','Castiglione in Teverina','Castiglione in Teverina','','NO','C315',42.6446814,12.2037280,20.5067,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056019','Celleno','Celleno','','NO','C446',42.5599399,12.1260817,23.9428,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056020','Cellere','Cellere','','NO','C447',42.5080763,11.7679168,37.3990,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056021','Civita Castellana','Civita Castellana','','NO','C765',42.2888265,12.4112751,84.0444,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056022','Civitella d\'Agliano','Civitella d\'Agliano','','NO','C780',42.6060981,12.1881542,32.6462,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056023','Corchiano','Corchiano','','NO','C988',42.3454090,12.3573819,33.6604,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056024','Fabrica di Roma','Fabrica di Roma','','NO','D452',42.3344906,12.2954849,34.6431,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056025','Faleria','Faleria','','NO','D475',42.2262678,12.4430787,25.8682,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056026','Farnese','Farnese','','NO','D503',42.5499431,11.7251038,52.5228,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056027','Gallese','Gallese','','NO','D870',42.3731760,12.4026192,36.6056,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056028','Gradoli','Gradoli','','NO','E126',42.6440945,11.8561040,44.0649,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056029','Graffignano','Graffignano','','NO','E128',42.5730120,12.2044563,29.2063,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056030','Grotte di Castro','Grotte di Castro','','NO','E210',42.6739173,11.8702449,33.2086,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056031','Ischia di Castro','Ischia di Castro','','NO','E330',42.5440771,11.7565934,104.8317,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056032','Latera','Latera','','NO','E467',42.6262160,11.8285336,22.4258,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056033','Lubriano','Lubriano','','NO','E713',42.6352636,12.1067870,16.4842,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056034','Marta','Marta','','NO','E978',42.5354912,11.9248814,33.5746,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056035','Montalto di Castro','Montalto di Castro','','NO','F419',42.3534010,11.6038802,190.3416,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056036','Montefiascone','Montefiascone','','NO','F499',42.5379013,12.0303131,104.6714,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056037','Monte Romano','Monte Romano','','NO','F603',42.2677047,11.8987620,86.8110,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056038','Monterosi','Monterosi','','NO','F606',42.1967045,12.3078826,10.8677,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056039','Nepi','Nepi','','NO','F868',42.2424861,12.3486150,83.0771,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056040','Onano','Onano','','NO','G065',42.6919545,11.8161204,24.2052,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056041','Oriolo Romano','Oriolo Romano','','NO','G111',42.1589286,12.1382889,19.3867,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056042','Orte','Orte','','NO','G135',42.4603917,12.3862364,69.4845,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056043','Piansano','Piansano','','NO','G571',42.5175751,11.8283604,26.7072,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056044','Proceno','Proceno','','NO','H071',42.7570051,11.8304556,42.2673,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056045','Ronciglione','Ronciglione','','NO','H534',42.2914614,12.2168702,52.4879,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056046','Villa San Giovanni in Tuscia','Villa San Giovanni in Tuscia','','NO','H913',42.2834496,12.0529077,5.3397,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056047','San Lorenzo Nuovo','San Lorenzo Nuovo','','NO','H969',42.6857394,11.9058742,26.9895,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056048','Soriano nel Cimino','Soriano nel Cimino','','NO','I855',42.4184989,12.2320883,78.6117,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056049','Sutri','Sutri','','NO','L017',42.2417161,12.2246922,60.9981,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056050','Tarquinia','Tarquinia','','NO','D024',42.2545274,11.7586609,278.9929,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056051','Tessennano','Tessennano','','NO','L150',42.4769318,11.7894408,14.4976,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056052','Tuscania','Tuscania','','NO','L310',42.4167042,11.8757056,208.5351,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056053','Valentano','Valentano','','NO','L569',42.5691935,11.8183379,43.1416,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056054','Vallerano','Vallerano','','NO','L612',42.3836792,12.2640966,15.5119,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056055','Vasanello','Vasanello','','NO','A701',42.4184269,12.3470068,28.7397,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056056','Vejano','Vejano','','NO','L713',42.2159456,12.0950574,44.6465,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056057','Vetralla','Vetralla','','NO','L814',42.3209049,12.0533317,113.1904,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056058','Vignanello','Vignanello','','NO','L882',42.3837383,12.2780119,20.3244,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056059','Viterbo','Viterbo','','SI','M082',42.4169360,12.1044977,406.0012,'056');
INSERT INTO `gi_comuni` VALUES ('VT','056060','Vitorchiano','Vitorchiano','','NO','M086',42.4703096,12.1742220,30.3657,'056');
INSERT INTO `gi_comuni` VALUES ('RI','057001','Accumoli','Accumoli','','NO','A019',42.7133138,13.2579844,87.1008,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057002','Amatrice','Amatrice','','NO','A258',42.6270392,13.2919434,174.8661,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057003','Antrodoco','Antrodoco','','NO','A315',42.4166519,13.0781487,63.8122,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057004','Ascrea','Ascrea','','NO','A464',42.1960453,12.9967372,13.9643,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057005','Belmonte in Sabina','Belmonte in Sabina','','NO','A765',42.3179583,12.8927862,23.5906,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057006','Borbona','Borbona','','NO','A981',42.5120626,13.1319223,47.8800,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057007','Borgorose','Borgorose','','NO','B008',42.1928238,13.2317604,145.3195,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057008','Borgo Velino','Borgo Velino','','NO','A996',42.4056768,13.0582515,18.0325,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057009','Cantalice','Cantalice','','NO','B627',42.4682146,12.9033933,37.5738,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057010','Cantalupo in Sabina','Cantalupo in Sabina','','NO','B631',42.3061611,12.6480385,10.3805,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057011','Casaprota','Casaprota','','NO','B934',42.2519188,12.8038662,14.5010,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057012','Casperia','Casperia','','NO','A472',42.3379368,12.6701805,25.3395,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057013','Castel di Tora','Castel di Tora','','NO','C098',42.2148863,12.9654625,15.1712,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057014','Castelnuovo di Farfa','Castelnuovo di Farfa','','NO','C224',42.2319246,12.7430426,9.0458,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057015','Castel Sant\'Angelo','Castel Sant\'Angelo','','NO','C268',42.3948143,13.0295894,31.7185,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057016','Cittaducale','Cittaducale','','NO','C746',42.3864345,12.9481735,70.9389,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057017','Cittareale','Cittareale','','NO','C749',42.6174990,13.1594260,59.4810,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057018','Collalto Sabino','Collalto Sabino','','NO','C841',42.1361438,13.0478814,22.7677,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057019','Colle di Tora','Colle di Tora','','NO','C857',42.2090351,12.9491438,14.5677,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057020','Collegiove','Collegiove','','NO','C859',42.1754281,13.0385277,10.3414,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057021','Collevecchio','Collevecchio','','NO','C876',42.3355572,12.5525391,26.5495,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057022','Colli sul Velino','Colli sul Velino','','NO','C880',42.4988945,12.7814502,12.4446,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057023','Concerviano','Concerviano','','NO','C946',42.3232975,12.9855735,21.2146,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057024','Configni','Configni','','NO','C959',42.4235834,12.6423855,22.9133,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057025','Contigliano','Contigliano','','NO','C969',42.4108288,12.7663796,53.2213,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057026','Cottanello','Cottanello','','NO','D124',42.4060405,12.6864862,37.1225,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057027','Fara in Sabina','Fara in Sabina','','NO','D493',42.2098511,12.7290589,54.5651,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057028','Fiamignano','Fiamignano','','NO','D560',42.2647470,13.1252628,100.5535,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057029','Forano','Forano','','NO','D689',42.2980132,12.5950564,17.6494,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057030','Frasso Sabino','Frasso Sabino','','NO','D785',42.2297305,12.8052968,4.3276,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057031','Greccio','Greccio','','NO','E160',42.4525943,12.7696330,18.0075,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057032','Labro','Labro','','NO','E393',42.5256940,12.8000365,11.9433,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057033','Leonessa','Leonessa','','NO','E535',42.5614480,12.9641665,204.0404,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057034','Longone Sabino','Longone Sabino','','NO','E681',42.3216568,12.9560116,34.1359,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057035','Magliano Sabina','Magliano Sabina','','NO','E812',42.3616710,12.4812022,43.0811,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057036','Marcetelli','Marcetelli','','NO','E927',42.2265834,13.0468416,11.0482,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057037','Micigliano','Micigliano','','NO','F193',42.4518590,13.0536453,36.8852,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057038','Mompeo','Mompeo','','NO','F319',42.2480356,12.7521649,10.6802,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057039','Montasola','Montasola','','NO','F430',42.3854427,12.6809246,12.8491,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057040','Montebuono','Montebuono','','NO','F446',42.3655121,12.5979628,20.0114,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057041','Monteleone Sabino','Monteleone Sabino','','NO','F541',42.2321604,12.8593908,18.9845,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057042','Montenero Sabino','Montenero Sabino','','NO','F579',42.2811888,12.8129566,22.6992,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057043','Monte San Giovanni in Sabina','Monte San Giovanni in Sabina','','NO','F619',42.3280101,12.7778090,30.7763,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057044','Montopoli di Sabina','Montopoli di Sabina','','NO','F687',42.2445811,12.6917692,38.3407,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057045','Morro Reatino','Morro Reatino','','NO','F746',42.5255752,12.8325990,15.6782,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057046','Nespolo','Nespolo','','NO','F876',42.1566551,13.0695403,8.6462,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057047','Orvinio','Orvinio','','NO','B595',42.1317291,12.9362903,24.7047,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057048','Paganico Sabino','Paganico Sabino','','NO','G232',42.1892036,12.9968917,9.4446,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057049','Pescorocchiano','Pescorocchiano','','NO','G498',42.2061837,13.1485886,94.8586,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057050','Petrella Salto','Petrella Salto','','NO','G513',42.2945189,13.0682968,103.1298,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057051','Poggio Bustone','Poggio Bustone','','NO','G756',42.5019017,12.8885099,22.3270,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057052','Poggio Catino','Poggio Catino','','NO','G757',42.2948169,12.6918512,14.9115,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057053','Poggio Mirteto','Poggio Mirteto','','NO','G763',42.2643456,12.6838238,25.9254,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057054','Poggio Moiano','Poggio Moiano','','NO','G764',42.2016674,12.8770558,26.7117,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057055','Poggio Nativo','Poggio Nativo','','NO','G765',42.2160119,12.7958901,16.3173,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057056','Poggio San Lorenzo','Poggio San Lorenzo','','NO','G770',42.2523790,12.8441028,8.9430,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057057','Posta','Posta','','NO','G934',42.5234953,13.0960641,66.0168,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057058','Pozzaglia Sabina','Pozzaglia Sabina','','NO','G951',42.1588929,12.9647795,24.8886,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057059','Rieti','Rieti','','SI','H282',42.4029535,12.8608289,206.5099,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057060','Rivodutri','Rivodutri','','NO','H354',42.5162241,12.8550511,27.0231,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057061','Roccantica','Roccantica','','NO','H427',42.3208710,12.6930506,16.7513,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057062','Rocca Sinibalda','Rocca Sinibalda','','NO','H446',42.2740341,12.9261293,49.8403,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057063','Salisano','Salisano','','NO','H713',42.2587986,12.7472273,17.9572,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057064','Scandriglia','Scandriglia','','NO','I499',42.1651360,12.8431309,63.4658,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057065','Selci','Selci','','NO','I581',42.3198227,12.6228748,7.8618,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057066','Stimigliano','Stimigliano','','NO','I959',42.2975572,12.5657492,11.7244,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057067','Tarano','Tarano','','NO','L046',42.3560092,12.5950456,19.8394,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057068','Toffia','Toffia','','NO','L189',42.2125022,12.7516769,11.3668,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057069','Torricella in Sabina','Torricella in Sabina','','NO','L293',42.2607027,12.8698703,25.7919,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057070','Torri in Sabina','Torri in Sabina','','NO','L286',42.3531536,12.6384845,26.2588,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057071','Turania','Turania','','NO','G507',42.1373623,13.0102399,8.3691,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057072','Vacone','Vacone','','NO','L525',42.3859598,12.6419291,9.0818,'057');
INSERT INTO `gi_comuni` VALUES ('RI','057073','Varco Sabino','Varco Sabino','','NO','L676',42.2396846,13.0201465,24.8066,'057');
INSERT INTO `gi_comuni` VALUES ('RM','058001','Affile','Affile','','NO','A062',41.8840011,13.0972784,14.9986,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058002','Agosta','Agosta','','NO','A084',41.9820617,13.0320002,9.6772,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058003','Albano Laziale','Albano Laziale','','NO','A132',41.7289918,12.6586931,23.3512,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058004','Allumiere','Allumiere','','NO','A210',42.1563624,11.9020613,92.1489,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058005','Anguillara Sabazia','Anguillara Sabazia','','NO','A297',42.0927965,12.2699686,75.0529,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058006','Anticoli Corrado','Anticoli Corrado','','NO','A309',42.0092588,12.9901695,15.9575,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058007','Anzio','Anzio','','NO','A323',41.4481539,12.6287081,44.0142,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058008','Arcinazzo Romano','Arcinazzo Romano','','NO','A370',41.8797197,13.1146237,28.3361,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058009','Ariccia','Ariccia','','NO','A401',41.7198306,12.6706437,18.6809,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058010','Arsoli','Arsoli','','NO','A446',42.0415089,13.0164394,12.1713,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058011','Artena','Artena','','NO','A449',41.7398497,12.9124285,54.7430,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058012','Bellegra','Bellegra','','NO','A749',41.8819292,13.0285498,18.4049,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058013','Bracciano','Bracciano','','NO','B114',42.1036486,12.1755279,142.6922,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058014','Camerata Nuova','Camerata Nuova','','NO','B472',42.0189662,13.1081449,40.4591,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058015','Campagnano di Roma','Campagnano di Roma','','NO','B496',42.1408192,12.3835099,46.9492,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058016','Canale Monterano','Canale Monterano','','NO','B576',42.1366089,12.1038524,36.8853,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058017','Canterano','Canterano','','NO','B635',41.9425244,13.0377545,7.4521,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058018','Capena','Capena','','NO','B649',42.1401047,12.5402255,29.5408,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058019','Capranica Prenestina','Capranica Prenestina','','NO','B687',41.8621507,12.9523013,20.3372,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058020','Carpineto Romano','Carpineto Romano','','NO','B828',41.6044244,13.0853679,85.9683,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058021','Casape','Casape','','NO','B932',41.9057807,12.8873918,5.3435,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058022','Castel Gandolfo','Castel Gandolfo','','NO','C116',41.7466783,12.6506883,14.0368,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058023','Castel Madama','Castel Madama','','NO','C203',41.9757362,12.8676448,29.0447,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058024','Castelnuovo di Porto','Castelnuovo di Porto','','NO','C237',42.1253704,12.5004661,30.4692,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058025','Castel San Pietro Romano','Castel San Pietro Romano','','NO','C266',41.8461644,12.8942378,15.1274,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058026','Cave','Cave','','NO','C390',41.8172951,12.9286454,18.2742,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058027','Cerreto Laziale','Cerreto Laziale','','NO','C518',41.9444239,12.9814708,11.9423,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058028','Cervara di Roma','Cervara di Roma','','NO','C543',41.9881479,13.0676278,31.8571,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058029','Cerveteri','Cerveteri','','NO','C552',41.9982737,12.0992132,134.9465,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058030','Ciciliano','Ciciliano','','NO','C677',41.9613475,12.9423661,18.7927,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058031','Cineto Romano','Cineto Romano','','NO','C702',42.0501521,12.9639344,10.3871,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058032','Civitavecchia','Civitavecchia','','NO','C773',42.0916530,11.7933063,74.9031,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058033','Civitella San Paolo','Civitella San Paolo','','NO','C784',42.1958628,12.5820212,20.5390,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058034','Colleferro','Colleferro','','NO','C858',41.7302146,13.0058208,26.7795,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058035','Colonna','Colonna','','NO','C900',41.8342395,12.7511256,3.6538,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058036','Fiano Romano','Fiano Romano','','NO','D561',42.1718937,12.5924682,41.2773,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058037','Filacciano','Filacciano','','NO','D586',42.2558329,12.6029889,5.6015,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058038','Formello','Formello','','NO','D707',42.0798882,12.4007660,31.3912,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058039','Frascati','Frascati','','NO','D773',41.8062361,12.6803881,22.4823,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058040','Gallicano nel Lazio','Gallicano nel Lazio','','NO','D875',41.8715415,12.8197991,25.7183,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058041','Gavignano','Gavignano','','NO','D945',41.6980560,13.0524809,15.1575,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058042','Genazzano','Genazzano','','NO','D964',41.8332942,12.9726558,31.5266,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058043','Genzano di Roma','Genzano di Roma','','NO','D972',41.7069368,12.6910293,17.6377,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058044','Gerano','Gerano','','NO','D978',41.9337278,12.9942149,10.2229,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058045','Gorga','Gorga','','NO','E091',41.6560026,13.1104932,26.1172,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058046','Grottaferrata','Grottaferrata','','NO','E204',41.7887082,12.6671677,18.1254,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058047','Guidonia Montecelio','Guidonia Montecelio','','NO','E263',41.9998153,12.7263466,79.8803,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058048','Jenne','Jenne','','NO','E382',41.8875602,13.1672954,31.9158,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058049','Labico','Labico','','NO','E392',41.7857263,12.8863040,11.7294,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058050','Lanuvio','Lanuvio','','NO','C767',41.6756604,12.6977022,44.0187,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058051','Licenza','Licenza','','NO','E576',42.0741572,12.9017550,18.1105,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058052','Magliano Romano','Magliano Romano','','NO','E813',42.1597059,12.4364217,20.3639,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058053','Mandela','Mandela','','NO','B632',42.0318559,12.9239548,13.9068,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058054','Manziana','Manziana','','NO','E900',42.1300619,12.1301516,24.1417,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058055','Marano Equo','Marano Equo','','NO','E908',41.9943739,13.0169933,7.8079,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058056','Marcellina','Marcellina','','NO','E924',42.0234676,12.8071512,15.4916,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058057','Marino','Marino','','NO','E958',41.7696330,12.6586667,23.7724,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058058','Mazzano Romano','Mazzano Romano','','NO','F064',42.2044023,12.3992499,29.1704,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058059','Mentana','Mentana','','NO','F127',42.0343275,12.6377172,24.5454,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058060','Monte Compatri','Monte Compatri','','NO','F477',41.8082029,12.7371884,24.7636,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058061','Monteflavio','Monteflavio','','NO','F504',42.1104296,12.8312281,16.6235,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058062','Montelanico','Montelanico','','NO','F534',41.6495083,13.0395535,35.5435,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058063','Montelibretti','Montelibretti','','NO','F545',42.1353082,12.7394600,45.6587,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058064','Monte Porzio Catone','Monte Porzio Catone','','NO','F590',41.8157504,12.7167120,9.1056,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058065','Monterotondo','Monterotondo','','NO','F611',42.0516432,12.6167390,40.8926,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058066','Montorio Romano','Montorio Romano','','NO','F692',42.1372884,12.8063260,23.3799,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058067','Moricone','Moricone','','NO','F730',42.1168502,12.7737092,19.6832,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058068','Morlupo','Morlupo','','NO','F734',42.1434185,12.5046494,24.1090,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058069','Nazzano','Nazzano','','NO','F857',42.2284823,12.5971359,12.4492,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058070','Nemi','Nemi','','NO','F865',41.7200661,12.7143781,7.2027,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058071','Nerola','Nerola','','NO','F871',42.1610863,12.7870925,17.2728,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058072','Nettuno','Nettuno','','NO','F880',41.4574894,12.6614342,71.6073,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058073','Olevano Romano','Olevano Romano','','NO','G022',41.8601745,13.0322606,25.8396,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058074','Palestrina','Palestrina','','NO','G274',41.8394082,12.8889861,46.6886,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058075','Palombara Sabina','Palombara Sabina','','NO','G293',42.0670099,12.7654507,75.9972,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058076','Percile','Percile','','NO','G444',42.0948082,12.9086809,17.8034,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058077','Pisoniano','Pisoniano','','NO','G704',41.9082190,12.9592640,12.8428,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058078','Poli','Poli','','NO','G784',41.8871893,12.8935525,22.1028,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058079','Pomezia','Pomezia','','NO','G811',41.6692252,12.5018961,86.5875,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058080','Ponzano Romano','Ponzano Romano','','NO','G874',42.2580297,12.5719058,19.8512,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058081','Riano','Riano','','NO','H267',42.0895698,12.5246918,25.2674,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058082','Rignano Flaminio','Rignano Flaminio','','NO','H288',42.2100619,12.4810409,39.0611,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058083','Riofreddo','Riofreddo','','NO','H300',42.0614031,12.9995884,12.3234,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058084','Rocca Canterano','Rocca Canterano','','NO','H387',41.9570445,13.0208445,15.6066,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058085','Rocca di Cave','Rocca di Cave','','NO','H401',41.8463827,12.9455386,11.1880,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058086','Rocca di Papa','Rocca di Papa','','NO','H404',41.7594841,12.7082343,40.0384,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058087','Roccagiovine','Roccagiovine','','NO','H411',42.0500860,12.8987081,8.2578,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058088','Rocca Priora','Rocca Priora','','NO','H432',41.7943761,12.7635527,28.5937,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058089','Rocca Santo Stefano','Rocca Santo Stefano','','NO','H441',41.9106619,13.0245472,9.8011,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058090','Roiate','Roiate','','NO','H494',41.8740560,13.0643520,10.4871,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058091','Roma','Roma','','SI','H501',41.8929840,12.4835363,1288.6696,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058092','Roviano','Roviano','','NO','H618',42.0255457,12.9943598,8.4529,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058093','Sacrofano','Sacrofano','','NO','H658',42.1060963,12.4474736,28.4790,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058094','Sambuci','Sambuci','','NO','H745',41.9862256,12.9373113,8.5920,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058095','San Gregorio da Sassola','San Gregorio da Sassola','','NO','H942',41.9180986,12.8726989,35.4090,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058096','San Polo dei Cavalieri','San Polo dei Cavalieri','','NO','I125',42.0124208,12.8399787,42.5328,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058097','Santa Marinella','Santa Marinella','','NO','I255',42.0342507,11.8543787,48.9153,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058098','Sant\'Angelo Romano','Sant\'Angelo Romano','','NO','I284',42.0340357,12.7131516,21.2280,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058099','Sant\'Oreste','Sant\'Oreste','','NO','I352',42.2343122,12.5194233,43.1565,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058100','San Vito Romano','San Vito Romano','','NO','I400',41.8825767,12.9822742,12.6991,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058101','Saracinesco','Saracinesco','','NO','I424',42.0038537,12.9525381,10.9240,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058102','Segni','Segni','','NO','I573',41.6913336,13.0231401,60.8655,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058103','Subiaco','Subiaco','','NO','I992',41.9241295,13.0963431,62.7236,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058104','Tivoli','Tivoli','','NO','L182',41.9636191,12.7986373,67.9991,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058105','Tolfa','Tolfa','','NO','L192',42.1492769,11.9377723,167.9511,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058106','Torrita Tiberina','Torrita Tiberina','','NO','L302',42.2367435,12.6181778,10.7674,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058107','Trevignano Romano','Trevignano Romano','','NO','L401',42.1563075,12.2459558,38.8385,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058108','Vallepietra','Vallepietra','','NO','L611',41.9267448,13.2311212,52.9890,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058109','Vallinfreda','Vallinfreda','','NO','L625',42.0842819,12.9955887,16.5666,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058110','Valmontone','Valmontone','','NO','L639',41.7768467,12.9177584,41.0518,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058111','Velletri','Velletri','','NO','L719',41.6866627,12.7773485,118.3092,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058112','Vicovaro','Vicovaro','','NO','L851',42.0148724,12.8922639,35.6761,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058113','Vivaro Romano','Vivaro Romano','','NO','M095',42.1004237,13.0065284,12.8058,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058114','Zagarolo','Zagarolo','','NO','M141',41.8397164,12.8295290,28.1284,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058115','Lariano','Lariano','','NO','M207',41.7280199,12.8328913,22.6127,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058116','Ladispoli','Ladispoli','','NO','M212',41.9549834,12.0699040,26.2485,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058117','Ardea','Ardea','','NO','M213',41.6104493,12.5331237,72.0923,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058118','Ciampino','Ciampino','','NO','M272',41.8028309,12.6016734,13.3715,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058119','San Cesareo','San Cesareo','','NO','M295',41.8198093,12.8007734,23.2727,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058120','Fiumicino','Fiumicino','','NO','M297',41.7725190,12.2366426,214.5166,'258');
INSERT INTO `gi_comuni` VALUES ('RM','058122','Fonte Nuova','Fonte Nuova','','NO','M309',41.9963655,12.6191334,20.1069,'258');
INSERT INTO `gi_comuni` VALUES ('LT','059001','Aprilia','Aprilia','','NO','A341',41.5937112,12.6486064,178.3375,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059002','Bassiano','Bassiano','','NO','A707',41.5490106,13.0326931,32.1459,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059003','Campodimele','Campodimele','','NO','B527',41.3898013,13.5303127,38.2689,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059004','Castelforte','Castelforte','','NO','C104',41.3005920,13.8218458,29.7721,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059005','Cisterna di Latina','Cisterna di Latina','','NO','C740',41.5924722,12.8287969,143.8830,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059006','Cori','Cori','','NO','D003',41.6430180,12.9130254,85.3076,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059007','Fondi','Fondi','','NO','D662',41.3561734,13.4317348,144.5284,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059008','Formia','Formia','','NO','D708',41.2557581,13.6059574,74.2509,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059009','Gaeta','Gaeta','','NO','D843',41.2134737,13.5715917,29.2563,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059010','Itri','Itri','','NO','E375',41.2910621,13.5309194,101.2139,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059011','Latina','Latina','','SI','E472',41.4678964,12.9031901,278.0095,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059012','Lenola','Lenola','','NO','E527',41.4092228,13.4619499,45.1163,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059013','Maenza','Maenza','','NO','E798',41.5227399,13.1807601,42.0940,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059014','Minturno','Minturno','','NO','F224',41.2620131,13.7468061,42.3842,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059015','Monte San Biagio','Monte San Biagio','','NO','F616',41.3525576,13.3511779,65.4349,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059016','Norma','Norma','','NO','F937',41.5857769,12.9735662,31.0005,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059017','Pontinia','Pontinia','','NO','G865',41.4077161,13.0444865,111.9206,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059018','Ponza','Ponza','','NO','G871',40.8945196,12.9663633,10.4822,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059019','Priverno','Priverno','','NO','G698',41.4735007,13.1816334,57.0308,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059020','Prossedi','Prossedi','','NO','H076',41.5163340,13.2608242,35.3375,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059021','Roccagorga','Roccagorga','','NO','H413',41.5259527,13.1557370,24.5796,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059022','Rocca Massima','Rocca Massima','','NO','H421',41.6783492,12.9199135,18.3615,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059023','Roccasecca dei Volsci','Roccasecca dei Volsci','','NO','H444',41.4798825,13.2127912,23.4654,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059024','Sabaudia','Sabaudia','','NO','H647',41.2996133,13.0246448,145.7807,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059025','San Felice Circeo','San Felice Circeo','','NO','H836',41.2329400,13.0883534,32.7350,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059026','Santi Cosma e Damiano','Santi Cosma e Damiano','','NO','I339',41.2996127,13.8138749,31.7156,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059027','Sermoneta','Sermoneta','','NO','I634',41.5493637,12.9841578,45.0222,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059028','Sezze','Sezze','','NO','I712',41.4984503,13.0590790,100.5267,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059029','Sonnino','Sonnino','','NO','I832',41.4142408,13.2420926,64.1145,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059030','Sperlonga','Sperlonga','','NO','I892',41.2572489,13.4359428,18.4457,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059031','Spigno Saturnia','Spigno Saturnia','','NO','I902',41.3055109,13.7341001,38.7719,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059032','Terracina','Terracina','','NO','L120',41.2913038,13.2487436,136.7235,'059');
INSERT INTO `gi_comuni` VALUES ('LT','059033','Ventotene','Ventotene','','NO','L742',40.7961677,13.4327888,2.0207,'059');
INSERT INTO `gi_comuni` VALUES ('FR','060001','Acquafondata','Acquafondata','','NO','A032',41.5431316,13.9517193,25.6786,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060002','Acuto','Acuto','','NO','A054',41.7928482,13.1740386,13.2830,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060003','Alatri','Alatri','','NO','A123',41.7263991,13.3420878,96.4722,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060004','Alvito','Alvito','','NO','A244',41.6881211,13.7427130,51.5893,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060005','Amaseno','Amaseno','','NO','A256',41.4676760,13.3351998,77.8601,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060006','Anagni','Anagni','','NO','A269',41.7421952,13.1585797,113.1698,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060007','Aquino','Aquino','','NO','A348',41.4927211,13.7037108,19.4705,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060008','Arce','Arce','','NO','A363',41.5879643,13.5724953,39.4047,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060009','Arnara','Arnara','','NO','A421',41.5836525,13.3883799,12.3664,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060010','Arpino','Arpino','','NO','A433',41.6479321,13.6107152,56.0683,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060011','Atina','Atina','','NO','A486',41.6197927,13.8003603,30.1417,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060012','Ausonia','Ausonia','','NO','A502',41.3543477,13.7484988,19.5258,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060013','Belmonte Castello','Belmonte Castello','','NO','A763',41.5784982,13.8110367,14.0664,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060014','Boville Ernica','Boville Ernica','','NO','A720',41.6429592,13.4707806,28.3513,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060015','Broccostella','Broccostella','','NO','B195',41.7028359,13.6378497,11.9866,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060016','Campoli Appennino','Campoli Appennino','','NO','B543',41.7379257,13.6787741,32.5278,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060017','Casalattico','Casalattico','','NO','B862',41.6211446,13.7245986,28.3945,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060018','Casalvieri','Casalvieri','','NO','B919',41.6313026,13.7127270,27.2341,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060019','Cassino','Cassino','','NO','C034',41.4927017,13.8305219,83.7257,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060020','Castelliri','Castelliri','','NO','C177',41.6790578,13.5500313,15.2660,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060021','Castelnuovo Parano','Castelnuovo Parano','','NO','C223',41.3780925,13.7553517,10.0838,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060022','Castrocielo','Castrocielo','','NO','C340',41.5311137,13.6959424,27.8930,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060023','Castro dei Volsci','Castro dei Volsci','','NO','C338',41.5083571,13.4069390,58.1237,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060024','Ceccano','Ceccano','','NO','C413',41.5683975,13.3335366,61.2022,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060025','Ceprano','Ceprano','','NO','C479',41.5464400,13.5152588,38.3318,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060026','Cervaro','Cervaro','','NO','C545',41.4813536,13.9051462,39.1905,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060027','Colfelice','Colfelice','','NO','C836',41.5560569,13.6055268,14.5873,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060028','Collepardo','Collepardo','','NO','C864',41.7613848,13.3678561,24.8511,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060029','Colle San Magno','Colle San Magno','','NO','C870',41.5500795,13.6941396,45.0066,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060030','Coreno Ausonio','Coreno Ausonio','','NO','C998',41.3458935,13.7773755,26.3806,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060031','Esperia','Esperia','','NO','D440',41.3836013,13.6833073,108.1473,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060032','Falvaterra','Falvaterra','','NO','D483',41.5035982,13.5224656,12.8001,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060033','Ferentino','Ferentino','','NO','D539',41.6925618,13.2534569,81.0664,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060034','Filettino','Filettino','','NO','D591',41.8901111,13.3240771,78.0624,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060035','Fiuggi','Fiuggi','','NO','A310',41.8038810,13.2218843,32.9878,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060036','Fontana Liri','Fontana Liri','','NO','D667',41.6094983,13.5519546,16.2949,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060037','Fontechiari','Fontechiari','','NO','D682',41.6698513,13.6763704,15.9807,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060038','Frosinone','Frosinone','','SI','D810',41.6392366,13.3505701,46.6027,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060039','Fumone','Fumone','','NO','D819',41.7276137,13.2895794,15.0003,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060040','Gallinaro','Gallinaro','','NO','D881',41.6569273,13.7989428,17.5580,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060041','Giuliano di Roma','Giuliano di Roma','','NO','E057',41.5401330,13.2797292,33.1688,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060042','Guarcino','Guarcino','','NO','E236',41.7996223,13.3140146,40.2864,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060043','Isola del Liri','Isola del Liri','','NO','E340',41.6784748,13.5740961,16.1180,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060044','Monte San Giovanni Campano','Monte San Giovanni Campano','','NO','F620',41.6389981,13.5158351,48.6547,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060045','Morolo','Morolo','','NO','F740',41.6380586,13.1971241,26.4960,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060046','Paliano','Paliano','','NO','G276',41.8047945,13.0599327,71.2630,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060047','Pastena','Pastena','','NO','G362',41.4670777,13.4909162,42.3298,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060048','Patrica','Patrica','','NO','G374',41.5918344,13.2432908,27.4638,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060049','Pescosolido','Pescosolido','','NO','G500',41.7491372,13.6562481,44.6809,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060050','Picinisco','Picinisco','','NO','G591',41.6466005,13.8675979,62.2894,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060051','Pico','Pico','','NO','G592',41.4515021,13.5590977,32.8860,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060052','Piedimonte San Germano','Piedimonte San Germano','','NO','G598',41.4972719,13.7503043,17.0393,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060053','Piglio','Piglio','','NO','G659',41.8298189,13.1450701,35.2293,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060054','Pignataro Interamna','Pignataro Interamna','','NO','G662',41.4391423,13.7873095,24.4169,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060055','Pofi','Pofi','','NO','G749',41.5655085,13.4149357,30.6091,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060056','Pontecorvo','Pontecorvo','','NO','G838',41.4569915,13.6662695,88.9326,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060057','Posta Fibreno','Posta Fibreno','','NO','G935',41.6929764,13.6971101,9.7630,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060058','Ripi','Ripi','','NO','H324',41.6126339,13.4267073,32.0796,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060059','Rocca d\'Arce','Rocca d\'Arce','','NO','H393',41.5874841,13.5839669,11.4990,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060060','Roccasecca','Roccasecca','','NO','H443',41.5511880,13.6695207,43.1480,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060061','San Biagio Saracinisco','San Biagio Saracinisco','','NO','H779',41.6134861,13.9278922,31.1161,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060062','San Donato Val di Comino','San Donato Val di Comino','','NO','H824',41.7082281,13.8142284,37.4455,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060063','San Giorgio a Liri','San Giorgio a Liri','','NO','H880',41.4067572,13.7667502,15.8264,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060064','San Giovanni Incarico','San Giovanni Incarico','','NO','H917',41.5026991,13.5569017,24.3889,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060065','Sant\'Ambrogio sul Garigliano','Sant\'Ambrogio sul Garigliano','','NO','I256',41.3904677,13.8691649,8.8785,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060066','Sant\'Andrea del Garigliano','Sant\'Andrea del Garigliano','','NO','I265',41.3658634,13.8414280,17.1458,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060067','Sant\'Apollinare','Sant\'Apollinare','','NO','I302',41.4018505,13.8305440,17.7023,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060068','Sant\'Elia Fiumerapido','Sant\'Elia Fiumerapido','','NO','I321',41.5398497,13.8658351,41.1112,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060069','Santopadre','Santopadre','','NO','I351',41.6023196,13.6357164,21.7518,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060070','San Vittore del Lazio','San Vittore del Lazio','','NO','I408',41.4594133,13.9306378,27.5841,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060071','Serrone','Serrone','','NO','I669',41.8405932,13.0968298,15.4659,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060072','Settefrati','Settefrati','','NO','I697',41.6703927,13.8504149,50.8718,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060073','Sgurgola','Sgurgola','','NO','I716',41.6706386,13.1496362,19.3422,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060074','Sora','Sora','','NO','I838',41.7200790,13.6136807,72.2853,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060075','Strangolagalli','Strangolagalli','','NO','I973',41.6010672,13.4918943,10.2671,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060076','Supino','Supino','','NO','L009',41.6090926,13.2234378,35.6932,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060077','Terelle','Terelle','','NO','L105',41.5536199,13.7790458,31.5049,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060078','Torre Cajetani','Torre Cajetani','','NO','L243',41.7884877,13.2651239,12.0103,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060079','Torrice','Torrice','','NO','L290',41.6296836,13.3983829,18.0279,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060080','Trevi nel Lazio','Trevi nel Lazio','','NO','L398',41.8623768,13.2488039,54.1590,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060081','Trivigliano','Trivigliano','','NO','L437',41.7757559,13.2727726,12.7421,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060082','Vallecorsa','Vallecorsa','','NO','L598',41.4444647,13.4055668,39.5808,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060083','Vallemaio','Vallemaio','','NO','L605',41.3661888,13.8110919,18.5891,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060084','Vallerotonda','Vallerotonda','','NO','L614',41.5520883,13.9125546,59.0523,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060085','Veroli','Veroli','','NO','L780',41.6907583,13.4179161,119.3919,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060086','Vicalvi','Vicalvi','','NO','L836',41.6763458,13.7069463,8.3968,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060087','Vico nel Lazio','Vico nel Lazio','','NO','L843',41.7767699,13.3415545,45.8739,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060088','Villa Latina','Villa Latina','','NO','A081',41.6136076,13.8375346,17.0541,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060089','Villa Santa Lucia','Villa Santa Lucia','','NO','L905',41.5125474,13.7718531,17.6862,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060090','Villa Santo Stefano','Villa Santo Stefano','','NO','I364',41.5169756,13.3102455,20.1532,'060');
INSERT INTO `gi_comuni` VALUES ('FR','060091','Viticuso','Viticuso','','NO','M083',41.5251398,13.9694146,20.7524,'060');
INSERT INTO `gi_comuni` VALUES ('CE','061001','Ailano','Ailano','','NO','A106',41.3911662,14.2043037,15.9333,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061002','Alife','Alife','','NO','A200',41.3270094,14.3345102,64.3956,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061003','Alvignano','Alvignano','','NO','A243',41.2453217,14.3373594,38.2010,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061004','Arienzo','Arienzo','','NO','A403',41.0218684,14.4939604,14.1680,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061005','Aversa','Aversa','','NO','A512',40.9730655,14.2060698,8.9056,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061006','Baia e Latina','Baia e Latina','','NO','A579',41.3002385,14.2516464,24.3528,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061007','Bellona','Bellona','','NO','A755',41.1603290,14.2287080,11.5334,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061008','Caianello','Caianello','','NO','B361',41.3043673,14.0856532,15.4971,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061009','Caiazzo','Caiazzo','','NO','B362',41.1775083,14.3657164,37.4747,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061010','Calvi Risorta','Calvi Risorta','','NO','B445',41.2159505,14.1308098,16.0739,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061011','Camigliano','Camigliano','','NO','B477',41.1814693,14.2124235,5.8811,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061012','Cancello ed Arnone','Cancello ed Arnone','','NO','B581',41.0735637,14.0259771,49.4410,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061013','Capodrise','Capodrise','','NO','B667',41.0429987,14.2994620,3.4034,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061014','Capriati a Volturno','Capriati a Volturno','','NO','B704',41.4692464,14.1460783,17.9634,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061015','Capua','Capua','','NO','B715',41.1076110,14.2116031,48.5711,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061016','Carinaro','Carinaro','','NO','B779',40.9887208,14.2167353,6.3303,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061017','Carinola','Carinola','','NO','B781',41.1884864,13.9770767,59.5906,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061018','Casagiove','Casagiove','','NO','B860',41.0788605,14.3093941,6.3780,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061019','Casal di Principe','Casal di Principe','','NO','B872',41.0072944,14.1305543,23.4020,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061020','Casaluce','Casaluce','','NO','B916',41.0036785,14.1943754,9.6803,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061021','Casapulla','Casapulla','','NO','B935',41.0753246,14.2890749,3.0634,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061022','Caserta','Caserta','','SI','B963',41.0746371,14.3324351,54.0982,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061023','Castel Campagnano','Castel Campagnano','','NO','B494',41.1816978,14.4528960,17.2485,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061024','Castel di Sasso','Castel di Sasso','','NO','C097',41.1790760,14.2739952,20.6770,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061025','Castello del Matese','Castello del Matese','','NO','C178',41.3670692,14.3767893,21.9578,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061026','Castel Morrone','Castel Morrone','','NO','C211',41.1203538,14.3574631,25.6053,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061027','Castel Volturno','Castel Volturno','','NO','C291',41.0345745,13.9409555,74.8925,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061028','Cervino','Cervino','','NO','C558',41.0396279,14.4243873,8.2135,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061029','Cesa','Cesa','','NO','C561',40.9624213,14.2303405,2.7204,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061030','Ciorlano','Ciorlano','','NO','C716',41.4504233,14.1598505,28.5748,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061031','Conca della Campania','Conca della Campania','','NO','C939',41.3311319,13.9900241,26.4226,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061032','Curti','Curti','','NO','D228',41.0750360,14.2776485,1.7194,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061033','Dragoni','Dragoni','','NO','D361',41.2733560,14.3084734,25.9032,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061034','Fontegreca','Fontegreca','','NO','D683',41.4571555,14.1828972,9.7427,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061035','Formicola','Formicola','','NO','D709',41.2107548,14.2330512,15.7800,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061036','Francolise','Francolise','','NO','D769',41.1853786,14.0542009,40.7493,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061037','Frignano','Frignano','','NO','D799',40.9932361,14.1780914,9.9409,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061038','Gallo Matese','Gallo Matese','','NO','D884',41.4654697,14.2259544,31.0968,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061039','Galluccio','Galluccio','','NO','D886',41.3404692,13.9575788,31.9074,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061040','Giano Vetusto','Giano Vetusto','','NO','E011',41.2029602,14.1929561,10.8825,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061041','Gioia Sannitica','Gioia Sannitica','','NO','E039',41.2997098,14.4444263,54.2749,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061042','Grazzanise','Grazzanise','','NO','E158',41.0915185,14.1001968,46.6513,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061043','Gricignano di Aversa','Gricignano di Aversa','','NO','E173',40.9813873,14.2325877,9.9725,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061044','Letino','Letino','','NO','E554',41.4531356,14.2523968,31.6574,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061045','Liberi','Liberi','','NO','E570',41.2276552,14.2913924,17.5551,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061046','Lusciano','Lusciano','','NO','E754',40.9691488,14.1926181,4.6863,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061047','Macerata Campania','Macerata Campania','','NO','E784',41.0630029,14.2744235,7.6828,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061048','Maddaloni','Maddaloni','','NO','E791',41.0375022,14.3839547,36.4067,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061049','Marcianise','Marcianise','','NO','E932',41.0355050,14.2994529,30.0121,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061050','Marzano Appio','Marzano Appio','','NO','E998',41.3161409,14.0390252,28.4591,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061051','Mignano Monte Lungo','Mignano Monte Lungo','','NO','F203',41.4053030,13.9833179,53.0156,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061052','Mondragone','Mondragone','','NO','F352',41.1141646,13.8880133,55.7204,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061053','Orta di Atella','Orta di Atella','','NO','G130',40.9656494,14.2683042,10.9547,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061054','Parete','Parete','','NO','G333',40.9555959,14.1638997,5.5355,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061055','Pastorano','Pastorano','','NO','G364',41.1821337,14.2011431,13.7990,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061056','Piana di Monte Verna','Piana di Monte Verna','','NO','G541',41.1693303,14.3349150,23.2409,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061057','Piedimonte Matese','Piedimonte Matese','','NO','G596',41.3562149,14.3746593,41.1494,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061058','Pietramelara','Pietramelara','','NO','G620',41.2707357,14.1872252,23.9524,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061059','Pietravairano','Pietravairano','','NO','G630',41.3258929,14.1656666,33.7815,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061060','Pignataro Maggiore','Pignataro Maggiore','','NO','G661',41.1893297,14.1713530,32.4772,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061061','Pontelatone','Pontelatone','','NO','G849',41.1941395,14.2494341,31.7879,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061062','Portico di Caserta','Portico di Caserta','','NO','G903',41.0563166,14.2805140,1.9929,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061063','Prata Sannita','Prata Sannita','','NO','G991',41.4324018,14.2033718,20.9772,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061064','Pratella','Pratella','','NO','G995',41.4051580,14.1782777,33.6201,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061065','Presenzano','Presenzano','','NO','H045',41.3774988,14.0786552,31.9897,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061066','Raviscanina','Raviscanina','','NO','H202',41.3704844,14.2428349,24.7694,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061067','Recale','Recale','','NO','H210',41.0570770,14.3026973,3.1910,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061068','Riardo','Riardo','','NO','H268',41.2623140,14.1519759,16.5658,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061069','Rocca d\'Evandro','Rocca d\'Evandro','','NO','H398',41.3946769,13.8966164,50.3427,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061070','Roccamonfina','Roccamonfina','','NO','H423',41.2879618,13.9817319,30.9904,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061071','Roccaromana','Roccaromana','','NO','H436',41.2740478,14.2233677,27.7081,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061072','Rocchetta e Croce','Rocchetta e Croce','','NO','H459',41.2374269,14.1575296,12.8162,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061073','Ruviano','Ruviano','','NO','H165',41.2099186,14.4096895,24.2555,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061074','San Cipriano d\'Aversa','San Cipriano d\'Aversa','','NO','H798',41.0009426,14.1318758,6.0487,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061075','San Felice a Cancello','San Felice a Cancello','','NO','H834',41.0117444,14.4809342,27.2343,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061076','San Gregorio Matese','San Gregorio Matese','','NO','H939',41.3854221,14.3751951,56.4237,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061077','San Marcellino','San Marcellino','','NO','H978',40.9868334,14.1736291,4.6462,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061078','San Nicola la Strada','San Nicola la Strada','','NO','I056',41.0544521,14.3313669,4.9582,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061079','San Pietro Infine','San Pietro Infine','','NO','I113',41.4458655,13.9595251,13.8644,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061080','San Potito Sannitico','San Potito Sannitico','','NO','I130',41.3372202,14.3923741,23.0207,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061081','San Prisco','San Prisco','','NO','I131',41.0855918,14.2783070,7.6548,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061082','Santa Maria a Vico','Santa Maria a Vico','','NO','I233',41.0270191,14.4653637,10.7137,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061083','Santa Maria Capua Vetere','Santa Maria Capua Vetere','','NO','I234',41.0775739,14.2605406,16.0146,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061084','Santa Maria la Fossa','Santa Maria la Fossa','','NO','I247',41.0932136,14.1310740,30.0323,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061085','San Tammaro','San Tammaro','','NO','I261',41.0757593,14.2303714,36.9776,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061086','Sant\'Angelo d\'Alife','Sant\'Angelo d\'Alife','','NO','I273',41.3625641,14.2596762,33.4462,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061087','Sant\'Arpino','Sant\'Arpino','','NO','I306',40.9578502,14.2523215,3.2947,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061088','Sessa Aurunca','Sessa Aurunca','','NO','I676',41.2379337,13.9340661,162.1307,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061089','Sparanise','Sparanise','','NO','I885',41.1902278,14.0963026,18.8800,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061090','Succivo','Succivo','','NO','I993',40.9659173,14.2536483,6.9601,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061091','Teano','Teano','','NO','L083',41.2510222,14.0671507,89.6098,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061092','Teverola','Teverola','','NO','L155',40.9932496,14.2080196,6.5162,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061093','Tora e Piccilli','Tora e Piccilli','','NO','L205',41.3376478,14.0213507,12.4104,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061094','Trentola Ducenta','Trentola Ducenta','','NO','L379',40.9760990,14.1769681,6.5578,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061095','Vairano Patenora','Vairano Patenora','','NO','L540',41.3330748,14.1316771,43.4084,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061096','Valle Agricola','Valle Agricola','','NO','L594',41.4245033,14.2554685,24.7457,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061097','Valle di Maddaloni','Valle di Maddaloni','','NO','L591',41.0783769,14.4148680,10.9023,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061098','Villa di Briano','Villa di Briano','','NO','D801',40.9982922,14.1691967,8.6215,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061099','Villa Literno','Villa Literno','','NO','L844',41.0096982,14.0741238,61.9101,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061100','Vitulazio','Vitulazio','','NO','M092',41.1640478,14.2190717,23.2535,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061101','Falciano del Massico','Falciano del Massico','','NO','D471',41.1666027,13.9506124,46.6504,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061102','Cellole','Cellole','','NO','M262',41.2041623,13.8534412,36.9924,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061103','Casapesenna','Casapesenna','','NO','M260',40.9908512,14.1300921,3.0721,'061');
INSERT INTO `gi_comuni` VALUES ('CE','061104','San Marco Evangelista','San Marco Evangelista','','NO','F043',41.0375047,14.3431982,5.5608,'061');
INSERT INTO `gi_comuni` VALUES ('BN','062001','Airola','Airola','','NO','A110',41.0626979,14.5590240,14.9358,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062002','Amorosi','Amorosi','','NO','A265',41.2027701,14.4608972,11.5135,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062003','Apice','Apice','','NO','A328',41.1178951,14.9146002,48.6064,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062004','Apollosa','Apollosa','','NO','A330',41.0929440,14.6985621,20.9784,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062005','Arpaia','Arpaia','','NO','A431',41.0346738,14.5467694,4.7203,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062006','Arpaise','Arpaise','','NO','A432',41.0294841,14.7439506,6.8044,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062007','Baselice','Baselice','','NO','A696',41.3973533,14.9726170,47.7120,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062008','Benevento','Benevento','','SI','A783',41.1298996,14.7771972,130.9070,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062009','Bonea','Bonea','','NO','A970',41.0754328,14.6189415,11.2853,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062010','Bucciano','Bucciano','','NO','B239',41.0763128,14.5724236,8.3932,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062011','Buonalbergo','Buonalbergo','','NO','B267',41.2209181,14.9796927,24.9944,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062012','Calvi','Calvi','','NO','B444',41.0715057,14.8655776,22.5426,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062013','Campolattaro','Campolattaro','','NO','B541',41.2881294,14.7316695,17.4198,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062014','Campoli del Monte Taburno','Campoli del Monte Taburno','','NO','B542',41.1313884,14.6446022,9.6748,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062015','Casalduni','Casalduni','','NO','B873',41.2603281,14.6964530,23.2042,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062016','Castelfranco in Miscano','Castelfranco in Miscano','','NO','C106',41.2978856,15.0838084,43.3419,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062017','Castelpagano','Castelpagano','','NO','C245',41.3994829,14.8059286,38.3144,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062018','Castelpoto','Castelpoto','','NO','C250',41.1411171,14.7023892,11.9067,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062019','Castelvenere','Castelvenere','','NO','C280',41.2345947,14.5474554,15.2734,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062020','Castelvetere in Val Fortore','Castelvetere in Val Fortore','','NO','C284',41.4418809,14.9421752,34.6601,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062021','Cautano','Cautano','','NO','C359',41.1473687,14.6426080,19.8669,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062022','Ceppaloni','Ceppaloni','','NO','C476',41.0442332,14.7604181,23.5991,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062023','Cerreto Sannita','Cerreto Sannita','','NO','C525',41.2833577,14.5570897,33.1677,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062024','Circello','Circello','','NO','C719',41.3567167,14.8094891,45.5469,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062025','Colle Sannita','Colle Sannita','','NO','C846',41.3643138,14.8327815,37.1463,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062026','Cusano Mutri','Cusano Mutri','','NO','D230',41.3392565,14.5054594,58.9347,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062027','Dugenta','Dugenta','','NO','D380',41.1328945,14.4524106,15.7087,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062028','Durazzano','Durazzano','','NO','D386',41.0625190,14.4479321,13.1373,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062029','Faicchio','Faicchio','','NO','D469',41.2787382,14.4734197,43.9491,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062030','Foglianise','Foglianise','','NO','D644',41.1599832,14.6715488,11.9331,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062031','Foiano di Val Fortore','Foiano di Val Fortore','','NO','D650',41.3524623,14.9770024,41.3140,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062032','Forchia','Forchia','','NO','D693',41.0301770,14.5367509,5.3339,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062033','Fragneto l\'Abate','Fragneto l\'Abate','','NO','D755',41.2605354,14.7863056,20.8706,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062034','Fragneto Monforte','Fragneto Monforte','','NO','D756',41.2461792,14.7632697,24.5543,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062035','Frasso Telesino','Frasso Telesino','','NO','D784',41.1574447,14.5269386,21.9458,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062036','Ginestra degli Schiavoni','Ginestra degli Schiavoni','','NO','E034',41.2793638,15.0424344,14.9620,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062037','Guardia Sanframondi','Guardia Sanframondi','','NO','E249',41.2564650,14.5999841,21.3456,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062038','Limatola','Limatola','','NO','E589',41.1416088,14.3957372,18.1457,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062039','Melizzano','Melizzano','','NO','F113',41.1618164,14.5047015,17.5610,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062040','Moiano','Moiano','','NO','F274',41.0761045,14.5461532,19.9202,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062041','Molinara','Molinara','','NO','F287',41.2916189,14.9108578,24.3601,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062042','Montefalcone di Val Fortore','Montefalcone di Val Fortore','','NO','F494',41.3260098,15.0092426,42.0824,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062043','Montesarchio','Montesarchio','','NO','F636',41.0642601,14.6415703,26.4898,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062044','Morcone','Morcone','','NO','F717',41.3401604,14.6640467,100.6489,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062045','Paduli','Paduli','','NO','G227',41.1668352,14.8835107,45.7067,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062046','Pago Veiano','Pago Veiano','','NO','G243',41.2479455,14.8711864,23.6234,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062047','Pannarano','Pannarano','','NO','G311',41.0087189,14.7025310,12.0104,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062048','Paolisi','Paolisi','','NO','G318',41.0368720,14.5799198,6.0301,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062049','Paupisi','Paupisi','','NO','G386',41.1952453,14.6663897,6.7272,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062050','Pesco Sannita','Pesco Sannita','','NO','G494',41.2342772,14.8109576,24.1074,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062051','Pietraroja','Pietraroja','','NO','G626',41.3458732,14.5503609,35.9851,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062052','Pietrelcina','Pietrelcina','','NO','G631',41.1970942,14.8472705,28.2090,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062053','Ponte','Ponte','','NO','G827',41.2155158,14.6916310,17.6600,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062054','Pontelandolfo','Pontelandolfo','','NO','G848',41.2859875,14.6947067,29.2356,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062055','Puglianello','Puglianello','','NO','H087',41.2226335,14.4500879,8.6013,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062056','Reino','Reino','','NO','H227',41.2921980,14.8226288,23.7045,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062057','San Bartolomeo in Galdo','San Bartolomeo in Galdo','','NO','H764',41.4098974,15.0150959,82.3133,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062058','San Giorgio del Sannio','San Giorgio del Sannio','','NO','H894',41.0637871,14.8503776,22.5106,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062059','San Giorgio La Molara','San Giorgio La Molara','','NO','H898',41.2712258,14.9176733,65.4389,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062060','San Leucio del Sannio','San Leucio del Sannio','','NO','H953',41.0720533,14.7568460,10.1238,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062061','San Lorenzello','San Lorenzello','','NO','H955',41.2761050,14.5418344,13.8255,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062062','San Lorenzo Maggiore','San Lorenzo Maggiore','','NO','H967',41.2481969,14.6242291,16.1927,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062063','San Lupo','San Lupo','','NO','H973',41.2610113,14.6346696,15.1136,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062064','San Marco dei Cavoti','San Marco dei Cavoti','','NO','H984',41.3091889,14.8795883,49.1664,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062065','San Martino Sannita','San Martino Sannita','','NO','I002',41.0657990,14.8362929,6.2304,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062066','San Nazzaro','San Nazzaro','','NO','I049',41.0531544,14.8563834,1.7832,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062067','San Nicola Manfredi','San Nicola Manfredi','','NO','I062',41.0718255,14.8242916,18.9262,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062068','San Salvatore Telesino','San Salvatore Telesino','','NO','I145',41.2357898,14.4950891,18.3524,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062069','Santa Croce del Sannio','Santa Croce del Sannio','','NO','I179',41.3871267,14.7318589,16.6176,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062070','Sant\'Agata de\' Goti','Sant\'Agata de\' Goti','','NO','I197',41.0908729,14.5038580,63.3704,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062071','Sant\'Angelo a Cupolo','Sant\'Angelo a Cupolo','','NO','I277',41.0694764,14.8042670,11.0992,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062072','Sassinoro','Sassinoro','','NO','I455',41.3745665,14.6623049,13.3719,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062073','Solopaca','Solopaca','','NO','I809',41.1884124,14.5402259,30.9768,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062074','Telese Terme','Telese Terme','','NO','L086',41.2171066,14.5274571,10.2808,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062075','Tocco Caudio','Tocco Caudio','','NO','L185',41.1250524,14.6347038,27.1738,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062076','Torrecuso','Torrecuso','','NO','L254',41.1895321,14.6798782,29.4932,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062077','Vitulano','Vitulano','','NO','M093',41.1741733,14.6473172,35.9020,'062');
INSERT INTO `gi_comuni` VALUES ('BN','062078','Sant\'Arcangelo Trimonte','Sant\'Arcangelo Trimonte','','NO','F557',41.1696665,14.9393231,9.9650,'062');
INSERT INTO `gi_comuni` VALUES ('NA','063001','Acerra','Acerra','','NO','A024',40.9488464,14.3713270,54.7528,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063002','Afragola','Afragola','','NO','A064',40.9227260,14.3104275,17.7550,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063003','Agerola','Agerola','','NO','A068',40.6379506,14.5448355,19.9249,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063004','Anacapri','Anacapri','','NO','A268',40.5514414,14.2166506,6.1884,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063005','Arzano','Arzano','','NO','A455',40.9105451,14.2692063,4.7977,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063006','Bacoli','Bacoli','','NO','A535',40.7965649,14.0778473,13.7076,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063007','Barano d\'Ischia','Barano d\'Ischia','','NO','A617',40.7089192,13.9177654,10.7513,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063008','Boscoreale','Boscoreale','','NO','B076',40.7752706,14.4752793,11.4559,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063009','Boscotrecase','Boscotrecase','','NO','B077',40.7761725,14.4627505,7.3668,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063010','Brusciano','Brusciano','','NO','B227',40.9206208,14.4225514,5.6257,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063011','Caivano','Caivano','','NO','B371',40.9573265,14.3017409,27.0931,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063012','Calvizzano','Calvizzano','','NO','B452',40.9067051,14.1898941,4.0339,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063013','Camposano','Camposano','','NO','B565',40.9554641,14.5286535,3.4103,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063014','Capri','Capri','','NO','B696',40.5508774,14.2430358,4.2988,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063015','Carbonara di Nola','Carbonara di Nola','','NO','B740',40.8723685,14.5786904,3.7464,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063016','Cardito','Cardito','','NO','B759',40.9464136,14.2953088,3.2240,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063017','Casalnuovo di Napoli','Casalnuovo di Napoli','','NO','B905',40.9147654,14.3511785,7.5890,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063018','Casamarciano','Casamarciano','','NO','B922',40.9327877,14.5536282,6.5927,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063019','Casamicciola Terme','Casamicciola Terme','','NO','B924',40.7466033,13.9074731,6.0554,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063020','Casandrino','Casandrino','','NO','B925',40.9356223,14.2489030,3.2935,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063021','Casavatore','Casavatore','','NO','B946',40.8998198,14.2738849,1.4951,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063022','Casola di Napoli','Casola di Napoli','','NO','B980',40.6938621,14.5288962,2.7246,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063023','Casoria','Casoria','','NO','B990',40.9051396,14.2905447,12.2521,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063024','Castellammare di Stabia','Castellammare di Stabia','','NO','C129',40.6945288,14.4803261,18.1777,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063025','Castello di Cisterna','Castello di Cisterna','','NO','C188',40.9160480,14.4101679,3.9518,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063026','Cercola','Cercola','','NO','C495',40.8600258,14.3589060,3.8113,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063027','Cicciano','Cicciano','','NO','C675',40.9635007,14.5372175,7.5185,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063028','Cimitile','Cimitile','','NO','C697',40.9424154,14.5188147,2.6875,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063029','Comiziano','Comiziano','','NO','C929',40.9524647,14.5493665,2.3580,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063030','Crispano','Crispano','','NO','D170',40.9525529,14.2852554,2.1665,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063031','Forio','Forio','','NO','D702',40.7376538,13.8574085,12.8520,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063032','Frattamaggiore','Frattamaggiore','','NO','D789',40.9408290,14.2723257,5.5015,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063033','Frattaminore','Frattaminore','','NO','D790',40.9555882,14.2708843,2.0247,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063034','Giugliano in Campania','Giugliano in Campania','','NO','E054',40.9282852,14.2011141,94.6424,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063035','Gragnano','Gragnano','','NO','E131',40.6897428,14.5210102,14.7377,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063036','Grumo Nevano','Grumo Nevano','','NO','E224',40.9323455,14.2602098,2.9952,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063037','Ischia','Ischia','','NO','E329',40.7428697,13.9421641,8.4703,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063038','Lacco Ameno','Lacco Ameno','','NO','E396',40.7544312,13.8844160,2.1123,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063039','Lettere','Lettere','','NO','E557',40.7043520,14.5446212,12.0072,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063040','Liveri','Liveri','','NO','E620',40.9023632,14.5672388,3.0391,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063041','Marano di Napoli','Marano di Napoli','','NO','E906',40.8981459,14.1909690,15.3572,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063042','Mariglianella','Mariglianella','','NO','E954',40.9299327,14.4388346,3.3372,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063043','Marigliano','Marigliano','','NO','E955',40.9251279,14.4570430,22.7015,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063044','Massa Lubrense','Massa Lubrense','','NO','F030',40.6115335,14.3434159,20.0163,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063045','Melito di Napoli','Melito di Napoli','','NO','F111',40.9239621,14.2327474,3.8165,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063046','Meta','Meta','','NO','F162',40.6438361,14.4127602,2.4910,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063047','Monte di Procida','Monte di Procida','','NO','F488',40.7946367,14.0552946,3.7201,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063048','Mugnano di Napoli','Mugnano di Napoli','','NO','F799',40.9094636,14.2064944,5.0934,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063049','Napoli','Napoli','','SI','F839',40.8400998,14.2500966,119.0262,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063050','Nola','Nola','','NO','F924',40.9262297,14.5268057,38.7909,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063051','Ottaviano','Ottaviano','','NO','G190',40.8491987,14.4774484,19.8664,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063052','Palma Campania','Palma Campania','','NO','G283',40.8685878,14.5551642,20.4047,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063053','Piano di Sorrento','Piano di Sorrento','','NO','G568',40.6329973,14.4115334,7.2987,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063054','Pimonte','Pimonte','','NO','G670',40.6736054,14.5126432,12.1024,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063055','Poggiomarino','Poggiomarino','','NO','G762',40.7986310,14.5408294,12.9619,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063056','Pollena Trocchia','Pollena Trocchia','','NO','G795',40.8560034,14.3795240,7.8743,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063057','Pomigliano d\'Arco','Pomigliano d\'Arco','','NO','G812',40.9069813,14.3929288,12.0015,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063058','Pompei','Pompei','','NO','G813',40.7483869,14.5001837,12.4675,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063059','Portici','Portici','','NO','G902',40.8249752,14.3552331,4.6414,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063060','Pozzuoli','Pozzuoli','','NO','G964',40.8447187,14.0931386,43.5325,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063061','Procida','Procida','','NO','H072',40.7651817,14.0239517,4.2240,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063062','Qualiano','Qualiano','','NO','H101',40.9200907,14.1508980,7.5885,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063063','Quarto','Quarto','','NO','H114',40.8776317,14.1436311,14.3160,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063064','Ercolano','Ercolano','','NO','H243',40.8092084,14.3456962,19.8214,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063065','Roccarainola','Roccarainola','','NO','H433',40.9723176,14.5620723,28.3340,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063066','San Gennaro Vesuviano','San Gennaro Vesuviano','','NO','H860',40.8611970,14.5295044,7.0652,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063067','San Giorgio a Cremano','San Giorgio a Cremano','','NO','H892',40.8296536,14.3340820,4.1661,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063068','San Giuseppe Vesuviano','San Giuseppe Vesuviano','','NO','H931',40.8341961,14.5061744,14.4719,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063069','San Paolo Bel Sito','San Paolo Bel Sito','','NO','I073',40.9141956,14.5493636,2.7655,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063070','San Sebastiano al Vesuvio','San Sebastiano al Vesuvio','','NO','I151',40.8416248,14.3703907,2.8156,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063071','Sant\'Agnello','Sant\'Agnello','','NO','I208',40.6305059,14.3989057,4.0578,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063072','Sant\'Anastasia','Sant\'Anastasia','','NO','I262',40.8668641,14.4021529,18.7010,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063073','Sant\'Antimo','Sant\'Antimo','','NO','I293',40.9337372,14.2356736,5.9209,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063074','Sant\'Antonio Abate','Sant\'Antonio Abate','','NO','I300',40.7212865,14.5440496,8.1001,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063075','San Vitaliano','San Vitaliano','','NO','I391',40.9229244,14.4814834,5.0842,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063076','Saviano','Saviano','','NO','I469',40.9111242,14.5097021,13.9151,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063077','Scisciano','Scisciano','','NO','I540',40.9174260,14.4828620,5.3690,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063078','Serrara Fontana','Serrara Fontana','','NO','I652',40.7115286,13.8953460,6.3957,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063079','Somma Vesuviana','Somma Vesuviana','','NO','I820',40.8713316,14.4382419,30.9351,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063080','Sorrento','Sorrento','','NO','I862',40.6271100,14.3751883,10.1249,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063081','Striano','Striano','','NO','I978',40.8138081,14.5778294,7.7921,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063082','Terzigno','Terzigno','','NO','L142',40.8099380,14.4964045,23.6182,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063083','Torre Annunziata','Torre Annunziata','','NO','L245',40.7547980,14.4484649,7.5974,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063084','Torre del Greco','Torre del Greco','','NO','L259',40.7864447,14.3658584,30.6505,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063085','Tufino','Tufino','','NO','L460',40.9545636,14.5629059,5.1870,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063086','Vico Equense','Vico Equense','','NO','L845',40.6629487,14.4277330,28.9432,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063087','Villaricca','Villaricca','','NO','G309',40.9216421,14.1938225,6.9362,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063088','Visciano','Visciano','','NO','M072',40.9246587,14.5824798,10.7013,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063089','Volla','Volla','','NO','M115',40.8788851,14.3439901,6.2969,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063090','Santa Maria la Carità','Santa Maria la Carità','','NO','M273',40.7209253,14.5129830,4.1128,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063091','Trecase','Trecase','','NO','M280',40.7706962,14.4365275,6.2983,'263');
INSERT INTO `gi_comuni` VALUES ('NA','063092','Massa di Somma','Massa di Somma','','NO','M289',40.8464480,14.3773707,3.1212,'263');
INSERT INTO `gi_comuni` VALUES ('AV','064001','Aiello del Sabato','Aiello del Sabato','','NO','A101',40.8906907,14.8227216,10.8598,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064002','Altavilla Irpina','Altavilla Irpina','','NO','A228',41.0058074,14.7774963,14.1145,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064003','Andretta','Andretta','','NO','A284',40.9329261,15.3218258,43.7232,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064004','Aquilonia','Aquilonia','','NO','A347',40.9872320,15.4742636,56.1991,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064005','Ariano Irpino','Ariano Irpino','','NO','A399',41.1527811,15.0889167,186.7124,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064006','Atripalda','Atripalda','','NO','A489',40.9185663,14.8349870,8.5361,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064007','Avella','Avella','','NO','A508',40.9601647,14.6000648,28.9697,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064008','Avellino','Avellino','','SI','A509',40.9139371,14.7952966,30.6937,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064009','Bagnoli Irpino','Bagnoli Irpino','','NO','A566',40.8319068,15.0701888,69.0678,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064010','Baiano','Baiano','','NO','A580',40.9513542,14.6171830,12.5274,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064011','Bisaccia','Bisaccia','','NO','A881',41.0131182,15.3749633,102.4040,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064012','Bonito','Bonito','','NO','A975',41.1026691,15.0045722,18.9371,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064013','Cairano','Cairano','','NO','B367',40.8960823,15.3678762,13.7963,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064014','Calabritto','Calabritto','','NO','B374',40.7834629,15.2197677,55.9408,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064015','Calitri','Calitri','','NO','B415',40.8989326,15.4389434,100.9896,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064016','Candida','Candida','','NO','B590',40.9418378,14.8743660,5.3653,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064017','Caposele','Caposele','','NO','B674',40.8142269,15.2244016,41.4495,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064018','Capriglia Irpina','Capriglia Irpina','','NO','B706',40.9579842,14.7744019,7.6209,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064019','Carife','Carife','','NO','B776',41.0283221,15.2083904,16.5967,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064020','Casalbore','Casalbore','','NO','B866',41.2335940,15.0070933,28.2776,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064021','Cassano Irpino','Cassano Irpino','','NO','B997',40.8706122,15.0269058,13.2955,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064022','Castel Baronia','Castel Baronia','','NO','C058',41.0515312,15.1913809,15.2775,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064023','Castelfranci','Castelfranci','','NO','C105',40.9317435,15.0428663,11.8490,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064024','Castelvetere sul Calore','Castelvetere sul Calore','','NO','C283',40.9292721,14.9871898,16.8551,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064025','Cervinara','Cervinara','','NO','C557',41.0209362,14.6170784,29.4301,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064026','Cesinali','Cesinali','','NO','C576',40.8961006,14.8279263,3.8685,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064027','Chianche','Chianche','','NO','C606',41.0449855,14.7898279,6.4542,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064028','Chiusano di San Domenico','Chiusano di San Domenico','','NO','C659',40.9317931,14.9166789,24.6038,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064029','Contrada','Contrada','','NO','C971',40.8677092,14.7748353,10.1776,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064030','Conza della Campania','Conza della Campania','','NO','C976',40.8564639,15.3359012,51.7021,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064031','Domicella','Domicella','','NO','D331',40.8792827,14.5867839,6.3781,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064032','Flumeri','Flumeri','','NO','D638',41.0758817,15.1500012,34.3509,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064033','Fontanarosa','Fontanarosa','','NO','D671',41.0162673,15.0187218,16.7232,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064034','Forino','Forino','','NO','D701',40.8609205,14.7382845,20.5030,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064035','Frigento','Frigento','','NO','D798',41.0117225,15.0979543,38.0796,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064036','Gesualdo','Gesualdo','','NO','D998',41.0063845,15.0703301,27.6284,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064037','Greci','Greci','','NO','E161',41.2497369,15.1700974,30.0641,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064038','Grottaminarda','Grottaminarda','','NO','E206',41.0697519,15.0623401,29.2128,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064039','Grottolella','Grottolella','','NO','E214',40.9718396,14.7867992,7.1458,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064040','Guardia Lombardi','Guardia Lombardi','','NO','E245',40.9538970,15.2097120,56.1476,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064041','Lacedonia','Lacedonia','','NO','E397',41.0494143,15.4239436,81.9759,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064042','Lapio','Lapio','','NO','E448',40.9826358,14.9480429,15.2329,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064043','Lauro','Lauro','','NO','E487',40.8796372,14.6333022,11.0148,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064044','Lioni','Lioni','','NO','E605',40.8779745,15.1861309,47.0654,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064045','Luogosano','Luogosano','','NO','E746',40.9860476,14.9910221,5.7923,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064046','Manocalzati','Manocalzati','','NO','E891',40.9413538,14.8491976,8.9529,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064047','Marzano di Nola','Marzano di Nola','','NO','E997',40.8999832,14.5820367,4.6243,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064048','Melito Irpino','Melito Irpino','','NO','F110',41.1027150,15.0528650,20.6891,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064049','Mercogliano','Mercogliano','','NO','F141',40.9201360,14.7362114,19.9524,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064050','Mirabella Eclano','Mirabella Eclano','','NO','F230',41.0401785,14.9925819,33.9641,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064051','Montaguto','Montaguto','','NO','F397',41.2482531,15.2518390,18.5384,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064052','Montecalvo Irpino','Montecalvo Irpino','','NO','F448',41.1937677,15.0327078,54.0322,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064053','Montefalcione','Montefalcione','','NO','F491',40.9639615,14.8845266,15.3131,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064054','Monteforte Irpino','Monteforte Irpino','','NO','F506',40.8917495,14.7149028,26.7813,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064055','Montefredane','Montefredane','','NO','F511',40.9598771,14.8138153,9.4166,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064056','Montefusco','Montefusco','','NO','F512',41.0368640,14.8548417,8.3261,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064057','Montella','Montella','','NO','F546',40.8443563,15.0167582,82.1316,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064058','Montemarano','Montemarano','','NO','F559',40.9197147,14.9971083,34.5046,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064059','Montemiletto','Montemiletto','','NO','F566',41.0115481,14.9071777,21.7803,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064060','Monteverde','Monteverde','','NO','F660',40.9999837,15.5336205,39.8913,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064063','Morra De Sanctis','Morra De Sanctis','','NO','F744',40.9297284,15.2425028,29.9607,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064064','Moschiano','Moschiano','','NO','F762',40.8746068,14.6593725,13.5062,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064065','Mugnano del Cardinale','Mugnano del Cardinale','','NO','F798',40.9407292,14.6424562,12.2624,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064066','Nusco','Nusco','','NO','F988',40.8868180,15.0839340,52.9518,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064067','Ospedaletto d\'Alpinolo','Ospedaletto d\'Alpinolo','','NO','G165',40.9397497,14.7446972,5.8917,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064068','Pago del Vallo di Lauro','Pago del Vallo di Lauro','','NO','G242',40.8965620,14.6088552,4.6292,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064069','Parolise','Parolise','','NO','G340',40.9302769,14.8798206,3.1340,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064070','Paternopoli','Paternopoli','','NO','G370',40.9726051,15.0332641,18.3146,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064071','Petruro Irpino','Petruro Irpino','','NO','G519',41.0316348,14.7969725,3.1105,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064072','Pietradefusi','Pietradefusi','','NO','G611',41.0375475,14.8883965,9.1396,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064073','Pietrastornina','Pietrastornina','','NO','G629',40.9920901,14.7290281,15.6388,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064074','Prata di Principato Ultra','Prata di Principato Ultra','','NO','G990',40.9859154,14.8356244,10.7564,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064075','Pratola Serra','Pratola Serra','','NO','H006',40.9862889,14.8534440,8.9375,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064076','Quadrelle','Quadrelle','','NO','H097',40.9471916,14.6391701,6.7283,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064077','Quindici','Quindici','','NO','H128',40.8623821,14.6482533,24.1575,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064078','Roccabascerana','Roccabascerana','','NO','H382',41.0190878,14.7167077,12.4157,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064079','Rocca San Felice','Rocca San Felice','','NO','H438',40.9508663,15.1650810,14.4087,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064080','Rotondi','Rotondi','','NO','H592',41.0317133,14.5977412,7.9549,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064081','Salza Irpina','Salza Irpina','','NO','H733',40.9184134,14.8910357,5.1897,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064082','San Mango sul Calore','San Mango sul Calore','','NO','H975',40.9623384,14.9753690,14.6543,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064083','San Martino Valle Caudina','San Martino Valle Caudina','','NO','I016',41.0228957,14.6624580,22.8588,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064084','San Michele di Serino','San Michele di Serino','','NO','I034',40.8767085,14.8556310,4.4666,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064085','San Nicola Baronia','San Nicola Baronia','','NO','I061',41.0587974,15.1990686,7.1530,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064086','San Potito Ultra','San Potito Ultra','','NO','I129',40.9281128,14.8726160,4.5174,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064087','San Sossio Baronia','San Sossio Baronia','','NO','I163',41.0688293,15.2011229,19.1325,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064088','Santa Lucia di Serino','Santa Lucia di Serino','','NO','I219',40.8700592,14.8749665,3.9831,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064089','Sant\'Andrea di Conza','Sant\'Andrea di Conza','','NO','I264',40.8432017,15.3708198,6.9302,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064090','Sant\'Angelo all\'Esca','Sant\'Angelo all\'Esca','','NO','I279',41.0067484,14.9956544,5.3793,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064091','Sant\'Angelo a Scala','Sant\'Angelo a Scala','','NO','I280',40.9738867,14.7407277,10.9903,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064092','Sant\'Angelo dei Lombardi','Sant\'Angelo dei Lombardi','','NO','I281',40.9277918,15.1794955,54.2579,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064093','Santa Paolina','Santa Paolina','','NO','I301',41.0244742,14.8470737,8.4590,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064095','Santo Stefano del Sole','Santo Stefano del Sole','','NO','I357',40.8947248,14.8670970,10.7526,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064096','Savignano Irpino','Savignano Irpino','','NO','I471',41.2289422,15.1785849,38.6536,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064097','Scampitella','Scampitella','','NO','I493',41.0926947,15.3004097,15.3050,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064098','Senerchia','Senerchia','','NO','I606',40.7414809,15.2040271,32.2643,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064099','Serino','Serino','','NO','I630',40.8544014,14.8724267,52.3669,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064100','Sirignano','Sirignano','','NO','I756',40.9487302,14.6291078,6.0280,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064101','Solofra','Solofra','','NO','I805',40.8294071,14.8458927,22.4117,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064102','Sorbo Serpico','Sorbo Serpico','','NO','I843',40.9170777,14.8872688,7.9426,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064103','Sperone','Sperone','','NO','I893',40.9523584,14.6030447,4.9621,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064104','Sturno','Sturno','','NO','I990',41.0196261,15.1115403,16.5380,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064105','Summonte','Summonte','','NO','L004',40.9495275,14.7446332,12.0995,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064106','Taurano','Taurano','','NO','L061',40.8836701,14.6345433,9.9251,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064107','Taurasi','Taurasi','','NO','L062',41.0074396,14.9583879,14.3828,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064108','Teora','Teora','','NO','L102',40.8511409,15.2527744,23.3222,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064109','Torella dei Lombardi','Torella dei Lombardi','','NO','L214',40.9424787,15.1147636,27.1240,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064110','Torre Le Nocelle','Torre Le Nocelle','','NO','L272',41.0211270,14.9110201,10.1176,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064111','Torrioni','Torrioni','','NO','L301',41.0333332,14.8139848,4.1748,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064112','Trevico','Trevico','','NO','L399',41.0493233,15.2335024,10.3405,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064113','Tufo','Tufo','','NO','L461',41.0106612,14.8240860,6.0271,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064114','Vallata','Vallata','','NO','L589',41.0368118,15.2513816,47.4351,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064115','Vallesaccarda','Vallesaccarda','','NO','L616',41.0643027,15.2518936,14.8938,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064116','Venticano','Venticano','','NO','L739',41.0457225,14.9137389,14.1743,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064117','Villamaina','Villamaina','','NO','L965',40.9701069,15.0875575,9.0951,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064118','Villanova del Battista','Villanova del Battista','','NO','L973',41.1134151,15.1591074,20.0556,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064119','Volturara Irpina','Volturara Irpina','','NO','M130',40.8787546,14.9172176,32.5737,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064120','Zungoli','Zungoli','','NO','M203',41.1289126,15.2021351,19.2730,'064');
INSERT INTO `gi_comuni` VALUES ('AV','064121','Montoro','Montoro','','NO','M330',40.8218122,14.7597652,39.9163,'064');
INSERT INTO `gi_comuni` VALUES ('SA','065001','Acerno','Acerno','','NO','A023',40.7382142,15.0593612,72.3978,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065002','Agropoli','Agropoli','','NO','A091',40.3496786,14.9919287,32.5215,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065003','Albanella','Albanella','','NO','A128',40.4798716,15.1152263,40.6691,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065004','Alfano','Alfano','','NO','A186',40.1785032,15.4250269,4.8717,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065005','Altavilla Silentina','Altavilla Silentina','','NO','A230',40.5300657,15.1320577,52.5010,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065006','Amalfi','Amalfi','','NO','A251',40.6341679,14.6037836,5.7181,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065007','Angri','Angri','','NO','A294',40.7430974,14.5684278,13.5211,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065008','Aquara','Aquara','','NO','A343',40.4427014,15.2532326,32.8299,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065009','Ascea','Ascea','','NO','A460',40.1410489,15.1853818,37.3968,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065010','Atena Lucana','Atena Lucana','','NO','A484',40.4538805,15.5556920,25.9611,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065011','Atrani','Atrani','','NO','A487',40.6366469,14.6082704,0.1050,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065012','Auletta','Auletta','','NO','A495',40.5587681,15.4239542,35.4618,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065013','Baronissi','Baronissi','','NO','A674',40.7463416,14.7702388,17.7980,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065014','Battipaglia','Battipaglia','','NO','A717',40.6077244,14.9830424,57.2380,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065015','Bellosguardo','Bellosguardo','','NO','A756',40.4232128,15.3118824,17.0915,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065016','Bracigliano','Bracigliano','','NO','B115',40.8246897,14.7108722,14.3170,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065017','Buccino','Buccino','','NO','B242',40.6327616,15.3700604,65.8313,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065018','Buonabitacolo','Buonabitacolo','','NO','B266',40.2700403,15.6192032,15.6278,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065019','Caggiano','Caggiano','','NO','B351',40.5675738,15.4935750,35.3231,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065020','Calvanico','Calvanico','','NO','B437',40.7744967,14.8262920,14.7978,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065021','Camerota','Camerota','','NO','B476',40.0297911,15.3723811,70.7842,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065022','Campagna','Campagna','','NO','B492',40.6654830,15.1070383,136.0112,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065023','Campora','Campora','','NO','B555',40.3062406,15.2934136,29.1338,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065024','Cannalonga','Cannalonga','','NO','B608',40.2444642,15.2930535,17.7338,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065025','Capaccio Paestum','Capaccio Paestum','','NO','B644',40.4229749,15.0807411,113.0887,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065026','Casalbuono','Casalbuono','','NO','B868',40.2160488,15.6803516,34.9309,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065027','Casaletto Spartano','Casaletto Spartano','','NO','B888',40.1515352,15.6185347,86.8173,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065028','Casal Velino','Casal Velino','','NO','B895',40.1887136,15.1099257,31.9242,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065029','Caselle in Pittari','Caselle in Pittari','','NO','B959',40.1723348,15.5438731,45.3110,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065030','Castelcivita','Castelcivita','','NO','C069',40.4950065,15.2314358,57.3937,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065031','Castellabate','Castellabate','','NO','C125',40.2852576,14.9478922,37.3725,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065032','Castelnuovo Cilento','Castelnuovo Cilento','','NO','C231',40.2169042,15.1768319,18.0503,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065033','Castelnuovo di Conza','Castelnuovo di Conza','','NO','C235',40.8184113,15.3209772,14.1664,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065034','Castel San Giorgio','Castel San Giorgio','','NO','C259',40.7801063,14.6977542,13.7425,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065035','Castel San Lorenzo','Castel San Lorenzo','','NO','C262',40.4165992,15.2303506,14.0717,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065036','Castiglione del Genovesi','Castiglione del Genovesi','','NO','C306',40.7250616,14.8482450,10.1749,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065037','Cava de\' Tirreni','Cava de\' Tirreni','','NO','C361',40.7005722,14.7061621,36.3765,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065038','Celle di Bulgheria','Celle di Bulgheria','','NO','C444',40.0952233,15.4015894,31.4326,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065039','Centola','Centola','','NO','C470',40.0652647,15.3124493,47.9408,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065040','Ceraso','Ceraso','','NO','C485',40.1943516,15.2559876,46.6589,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065041','Cetara','Cetara','','NO','C584',40.6470228,14.7006341,5.2181,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065042','Cicerale','Cicerale','','NO','C676',40.3436066,15.1267134,41.6127,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065043','Colliano','Colliano','','NO','C879',40.7251108,15.2935584,55.2476,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065044','Conca dei Marini','Conca dei Marini','','NO','C940',40.6201192,14.5760601,1.0638,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065045','Controne','Controne','','NO','C973',40.5097280,15.2047396,7.6681,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065046','Contursi Terme','Contursi Terme','','NO','C974',40.6501169,15.2374106,28.7686,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065047','Corbara','Corbara','','NO','C984',40.7227330,14.5925624,6.8202,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065048','Corleto Monforte','Corleto Monforte','','NO','D011',40.4362023,15.3811350,58.8852,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065049','Cuccaro Vetere','Cuccaro Vetere','','NO','D195',40.1630238,15.3069650,17.5416,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065050','Eboli','Eboli','','NO','D390',40.6180674,15.0544926,137.5376,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065051','Felitto','Felitto','','NO','D527',40.3734365,15.2437875,41.4962,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065052','Fisciano','Fisciano','','NO','D615',40.7704773,14.7988216,31.7675,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065053','Furore','Furore','','NO','D826',40.6189376,14.5535449,1.8115,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065054','Futani','Futani','','NO','D832',40.1521331,15.3207727,14.8499,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065055','Giffoni Sei Casali','Giffoni Sei Casali','','NO','E026',40.7187834,14.9036082,35.4334,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065056','Giffoni Valle Piana','Giffoni Valle Piana','','NO','E027',40.7174501,14.9433336,88.3876,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065057','Gioi','Gioi','','NO','E037',40.2888306,15.2173891,28.2734,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065058','Giungano','Giungano','','NO','E060',40.3940973,15.1081352,11.7813,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065059','Ispani','Ispani','','NO','E365',40.0869323,15.5585253,8.3631,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065060','Laureana Cilento','Laureana Cilento','','NO','E480',40.2998604,15.0386316,14.0279,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065061','Laurino','Laurino','','NO','E485',40.3355619,15.3368913,69.8084,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065062','Laurito','Laurito','','NO','E486',40.1677313,15.4072390,20.1096,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065063','Laviano','Laviano','','NO','E498',40.7845707,15.3050610,55.7031,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065064','Lustra','Lustra','','NO','E767',40.2893686,15.0672743,14.9609,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065065','Magliano Vetere','Magliano Vetere','','NO','E814',40.3458446,15.2367931,23.0979,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065066','Maiori','Maiori','','NO','E839',40.6509910,14.6424092,16.5706,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065067','Mercato San Severino','Mercato San Severino','','NO','F138',40.7860622,14.7527430,30.4412,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065068','Minori','Minori','','NO','F223',40.6498822,14.6278178,2.7569,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065069','Moio della Civitella','Moio della Civitella','','NO','F278',40.2467656,15.2693979,17.4239,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065070','Montano Antilia','Montano Antilia','','NO','F426',40.1616881,15.3650277,33.2928,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065071','Montecorice','Montecorice','','NO','F479',40.2329452,14.9849151,22.4442,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065072','Montecorvino Pugliano','Montecorvino Pugliano','','NO','F480',40.6758894,14.9315661,29.1411,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065073','Montecorvino Rovella','Montecorvino Rovella','','NO','F481',40.6946657,14.9760822,42.3134,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065074','Monteforte Cilento','Monteforte Cilento','','NO','F507',40.3641901,15.1950740,22.1059,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065075','Monte San Giacomo','Monte San Giacomo','','NO','F618',40.3446152,15.5412082,51.5152,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065076','Montesano sulla Marcellana','Montesano sulla Marcellana','','NO','F625',40.2764998,15.7025145,109.8169,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065077','Morigerati','Morigerati','','NO','F731',40.1383253,15.5541722,21.4902,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065078','Nocera Inferiore','Nocera Inferiore','','NO','F912',40.7434969,14.6414634,20.9331,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065079','Nocera Superiore','Nocera Superiore','','NO','F913',40.7414843,14.6711170,14.8279,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065080','Novi Velia','Novi Velia','','NO','F967',40.2245743,15.2865704,34.6383,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065081','Ogliastro Cilento','Ogliastro Cilento','','NO','G011',40.3514900,15.0451514,13.2623,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065082','Olevano sul Tusciano','Olevano sul Tusciano','','NO','G023',40.6575872,15.0227993,26.9589,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065083','Oliveto Citra','Oliveto Citra','','NO','G039',40.6895801,15.2313348,31.9093,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065084','Omignano','Omignano','','NO','G063',40.2506077,15.0826961,10.0689,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065085','Orria','Orria','','NO','G121',40.2988165,15.1698285,26.4829,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065086','Ottati','Ottati','','NO','G192',40.4632838,15.3154119,53.7340,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065087','Padula','Padula','','NO','G226',40.3410019,15.6594715,66.9308,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065088','Pagani','Pagani','','NO','G230',40.7410886,14.6194269,12.7078,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065089','Palomonte','Palomonte','','NO','G292',40.6600363,15.2917294,28.2345,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065090','Pellezzano','Pellezzano','','NO','G426',40.7269770,14.7604151,14.1158,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065091','Perdifumo','Perdifumo','','NO','G447',40.2661852,15.0166508,24.0052,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065092','Perito','Perito','','NO','G455',40.2980920,15.1475897,23.7318,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065093','Pertosa','Pertosa','','NO','G476',40.5431355,15.4485138,6.4480,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065094','Petina','Petina','','NO','G509',40.5327644,15.3741380,35.4966,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065095','Piaggine','Piaggine','','NO','G538',40.3445201,15.3781291,62.9007,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065096','Pisciotta','Pisciotta','','NO','G707',40.1076157,15.2335407,31.3420,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065097','Polla','Polla','','NO','G793',40.5149780,15.4925864,48.2747,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065098','Pollica','Pollica','','NO','G796',40.1909236,15.0544312,28.6649,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065099','Pontecagnano Faiano','Pontecagnano Faiano','','NO','G834',40.6427639,14.8734195,36.9674,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065100','Positano','Positano','','NO','G932',40.6290039,14.4817214,9.0401,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065101','Postiglione','Postiglione','','NO','G939',40.5570322,15.2318580,48.4540,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065102','Praiano','Praiano','','NO','G976',40.6107963,14.5319266,2.8803,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065103','Prignano Cilento','Prignano Cilento','','NO','H062',40.3321212,15.0680101,12.0462,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065104','Ravello','Ravello','','NO','H198',40.6499959,14.6125505,8.0828,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065105','Ricigliano','Ricigliano','','NO','H277',40.6692448,15.4827838,28.0734,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065106','Roccadaspide','Roccadaspide','','NO','H394',40.4272571,15.1917896,64.3335,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065107','Roccagloriosa','Roccagloriosa','','NO','H412',40.1059759,15.4375786,40.9869,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065108','Roccapiemonte','Roccapiemonte','','NO','H431',40.7623066,14.6927210,5.2185,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065109','Rofrano','Rofrano','','NO','H485',40.2104072,15.4272076,63.6538,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065110','Romagnano al Monte','Romagnano al Monte','','NO','H503',40.6276836,15.4366169,9.6050,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065111','Roscigno','Roscigno','','NO','H564',40.3991358,15.3463772,15.2950,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065112','Rutino','Rutino','','NO','H644',40.2998452,15.0746118,9.7046,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065113','Sacco','Sacco','','NO','H654',40.3778791,15.3790154,23.7860,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065114','Sala Consilina','Sala Consilina','','NO','H683',40.4014737,15.5923754,59.7741,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065115','Salento','Salento','','NO','H686',40.2491965,15.1877758,23.6199,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065116','Salerno','Salerno','','SI','H703',40.6784645,14.7560790,59.9707,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065117','Salvitelle','Salvitelle','','NO','H732',40.5920335,15.4595643,9.5105,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065118','San Cipriano Picentino','San Cipriano Picentino','','NO','H800',40.7191670,14.8693489,17.3096,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065119','San Giovanni a Piro','San Giovanni a Piro','','NO','H907',40.0504434,15.4499650,38.0811,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065120','San Gregorio Magno','San Gregorio Magno','','NO','H943',40.6561875,15.4035874,50.2597,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065121','San Mango Piemonte','San Mango Piemonte','','NO','H977',40.7039202,14.8351693,6.2233,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065122','San Marzano sul Sarno','San Marzano sul Sarno','','NO','I019',40.7745535,14.5879095,5.2797,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065123','San Mauro Cilento','San Mauro Cilento','','NO','I031',40.2258666,15.0464494,15.1450,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065124','San Mauro la Bruca','San Mauro la Bruca','','NO','I032',40.1236461,15.2899053,19.2287,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065125','San Pietro al Tanagro','San Pietro al Tanagro','','NO','I089',40.4572142,15.4802353,15.6084,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065126','San Rufo','San Rufo','','NO','I143',40.4342971,15.4615611,32.2213,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065127','Santa Marina','Santa Marina','','NO','I253',40.1039882,15.5404372,28.2883,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065128','Sant\'Angelo a Fasanella','Sant\'Angelo a Fasanella','','NO','I278',40.4552541,15.3446226,32.3127,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065129','Sant\'Arsenio','Sant\'Arsenio','','NO','I307',40.4705830,15.4832596,19.9358,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065130','Sant\'Egidio del Monte Albino','Sant\'Egidio del Monte Albino','','NO','I317',40.7358738,14.5971477,6.1880,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065131','Santomenna','Santomenna','','NO','I260',40.8070189,15.3202132,8.9676,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065132','San Valentino Torio','San Valentino Torio','','NO','I377',40.7920890,14.6007800,9.0542,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065133','Sanza','Sanza','','NO','I410',40.2445145,15.5533120,128.7989,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065134','Sapri','Sapri','','NO','I422',40.0736150,15.6301604,14.3817,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065135','Sarno','Sarno','','NO','I438',40.8141594,14.6204121,40.0832,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065136','Sassano','Sassano','','NO','I451',40.3378359,15.5628436,47.6585,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065137','Scafati','Scafati','','NO','I483',40.7494251,14.5272811,20.0369,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065138','Scala','Scala','','NO','I486',40.6533122,14.6076620,13.8770,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065139','Serramezzana','Serramezzana','','NO','I648',40.2433760,15.0305040,7.3028,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065140','Serre','Serre','','NO','I666',40.5810590,15.1840602,66.8288,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065141','Sessa Cilento','Sessa Cilento','','NO','I677',40.2609604,15.0734590,17.9923,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065142','Siano','Siano','','NO','I720',40.8009404,14.6936941,8.3430,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065143','Sicignano degli Alburni','Sicignano degli Alburni','','NO','M253',40.5592374,15.3060463,81.1988,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065144','Stella Cilento','Stella Cilento','','NO','G887',40.2318458,15.0944302,14.4185,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065145','Stio','Stio','','NO','I960',40.3101404,15.2527832,24.3988,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065146','Teggiano','Teggiano','','NO','D292',40.3803754,15.5391033,61.8354,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065147','Torchiara','Torchiara','','NO','L212',40.3228610,15.0539059,8.4824,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065148','Torraca','Torraca','','NO','L233',40.1107853,15.6370691,16.1660,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065149','Torre Orsaia','Torre Orsaia','','NO','L274',40.1308844,15.4714180,20.7862,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065150','Tortorella','Tortorella','','NO','L306',40.1415424,15.6061014,34.0526,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065151','Tramonti','Tramonti','','NO','L323',40.6938001,14.6412231,24.9648,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065152','Trentinara','Trentinara','','NO','L377',40.4005975,15.1073624,23.4123,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065153','Valle dell\'Angelo','Valle dell\'Angelo','','NO','G540',40.3433191,15.3687262,36.8990,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065154','Vallo della Lucania','Vallo della Lucania','','NO','L628',40.2293396,15.2675157,25.0548,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065155','Valva','Valva','','NO','L656',40.7370660,15.2710193,26.5338,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065156','Vibonati','Vibonati','','NO','L835',40.0991111,15.5837784,20.3467,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065157','Vietri sul Mare','Vietri sul Mare','','NO','L860',40.6718253,14.7282821,8.9408,'065');
INSERT INTO `gi_comuni` VALUES ('SA','065158','Bellizzi','Bellizzi','','NO','M294',40.6222011,14.9461942,8.0508,'065');
INSERT INTO `gi_comuni` VALUES ('AQ','066001','Acciano','Acciano','','NO','A018',42.1766810,13.7183677,32.1628,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066002','Aielli','Aielli','','NO','A100',42.0802897,13.5902195,37.6519,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066003','Alfedena','Alfedena','','NO','A187',41.7338692,14.0343790,40.6151,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066004','Anversa degli Abruzzi','Anversa degli Abruzzi','','NO','A318',41.9944719,13.8028410,32.2518,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066005','Ateleta','Ateleta','','NO','A481',41.8548454,14.1976433,41.9710,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066006','Avezzano','Avezzano','','NO','A515',42.0306962,13.4265955,104.2448,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066007','Balsorano','Balsorano','','NO','A603',41.8088377,13.5595617,58.7601,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066008','Barete','Barete','','NO','A656',42.4509141,13.2808168,24.4708,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066009','Barisciano','Barisciano','','NO','A667',42.3251026,13.5917721,78.1545,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066010','Barrea','Barrea','','NO','A678',41.7574520,13.9912024,86.3618,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066011','Bisegna','Bisegna','','NO','A884',41.9210660,13.7569907,46.8634,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066012','Bugnara','Bugnara','','NO','B256',42.0226172,13.8639595,25.1417,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066013','Cagnano Amiterno','Cagnano Amiterno','','NO','B358',42.4589562,13.2316659,61.3030,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066014','Calascio','Calascio','','NO','B382',42.3253995,13.6947460,39.3802,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066015','Campo di Giove','Campo di Giove','','NO','B526',42.0121701,14.0443676,28.9477,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066016','Campotosto','Campotosto','','NO','B569',42.5576216,13.3672737,51.5693,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066017','Canistro','Canistro','','NO','B606',41.9403937,13.4095173,15.8598,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066018','Cansano','Cansano','','NO','B624',42.0045889,14.0109550,37.7396,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066019','Capestrano','Capestrano','','NO','B651',42.2678516,13.7692208,43.4775,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066020','Capistrello','Capistrello','','NO','B656',41.9654381,13.3899572,61.0913,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066021','Capitignano','Capitignano','','NO','B658',42.5200846,13.3007376,30.6823,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066022','Caporciano','Caporciano','','NO','B672',42.2520591,13.6709136,18.4685,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066023','Cappadocia','Cappadocia','','NO','B677',42.0068439,13.2801834,68.8470,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066024','Carapelle Calvisio','Carapelle Calvisio','','NO','B725',42.2990680,13.6827383,14.8813,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066025','Carsoli','Carsoli','','NO','B842',42.0962947,13.0831779,95.7443,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066026','Castel del Monte','Castel del Monte','','NO','C083',42.3646652,13.7265779,57.7881,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066027','Castel di Ieri','Castel di Ieri','','NO','C090',42.1150577,13.7398377,18.9283,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066028','Castel di Sangro','Castel di Sangro','','NO','C096',41.7842800,14.1086042,84.4020,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066029','Castellafiume','Castellafiume','','NO','C126',41.9883790,13.3333405,24.1035,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066030','Castelvecchio Calvisio','Castelvecchio Calvisio','','NO','C278',42.3100580,13.6887323,15.4849,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066031','Castelvecchio Subequo','Castelvecchio Subequo','','NO','C279',42.1313143,13.7292447,19.2382,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066032','Celano','Celano','','NO','C426',42.0842605,13.5475800,82.5383,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066033','Cerchio','Cerchio','','NO','C492',42.0637837,13.6002534,20.3239,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066034','Civita d\'Antino','Civita d\'Antino','','NO','C766',41.8856355,13.4706467,28.5626,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066035','Civitella Alfedena','Civitella Alfedena','','NO','C778',41.7652073,13.9407457,29.3568,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066036','Civitella Roveto','Civitella Roveto','','NO','C783',41.9147689,13.4274575,45.3535,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066037','Cocullo','Cocullo','','NO','C811',42.0329135,13.7741985,31.6502,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066038','Collarmele','Collarmele','','NO','C844',42.0612274,13.6267074,23.7311,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066039','Collelongo','Collelongo','','NO','C862',41.8866205,13.5834221,53.5951,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066040','Collepietro','Collepietro','','NO','C866',42.2209075,13.7806412,15.3128,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066041','Corfinio','Corfinio','','NO','C999',42.1245875,13.8440255,17.9099,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066042','Fagnano Alto','Fagnano Alto','','NO','D465',42.2534660,13.5748464,24.6100,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066043','Fontecchio','Fontecchio','','NO','D681',42.2315256,13.6069719,17.1765,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066044','Fossa','Fossa','','NO','D736',42.2960845,13.4867975,8.6970,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066045','Gagliano Aterno','Gagliano Aterno','','NO','D850',42.1259336,13.7004897,32.2815,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066046','Gioia dei Marsi','Gioia dei Marsi','','NO','E040',41.9540573,13.6932361,57.9764,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066047','Goriano Sicoli','Goriano Sicoli','','NO','E096',42.0799179,13.7733079,20.3303,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066048','Introdacqua','Introdacqua','','NO','E307',42.0077075,13.8987040,37.2070,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066049','L\'Aquila','L\'Aquila','','SI','A345',42.3501416,13.4011640,473.5912,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066050','Lecce nei Marsi','Lecce nei Marsi','','NO','E505',41.9348204,13.6860229,66.6432,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066051','Luco dei Marsi','Luco dei Marsi','','NO','E723',41.9618283,13.4690199,45.1262,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066052','Lucoli','Lucoli','','NO','E724',42.2909395,13.3390200,103.6774,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066053','Magliano de\' Marsi','Magliano de\' Marsi','','NO','E811',42.0925554,13.3647180,71.3548,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066054','Massa d\'Albe','Massa d\'Albe','','NO','F022',42.1091540,13.3923481,68.6616,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066055','Molina Aterno','Molina Aterno','','NO','M255',42.1478618,13.7352566,12.3640,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066056','Montereale','Montereale','','NO','F595',42.5285014,13.2392601,104.1115,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066057','Morino','Morino','','NO','F732',41.8646430,13.4579297,51.0335,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066058','Navelli','Navelli','','NO','F852',42.2364651,13.7265104,42.1895,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066059','Ocre','Ocre','','NO','F996',42.2837057,13.4738146,23.8024,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066060','Ofena','Ofena','','NO','G002',42.3281532,13.7584688,37.2063,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066061','Opi','Opi','','NO','G079',41.7804375,13.8299903,49.8443,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066062','Oricola','Oricola','','NO','G102',42.0496835,13.0388336,18.3466,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066063','Ortona dei Marsi','Ortona dei Marsi','','NO','G142',41.9974493,13.7290310,56.8321,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066064','Ortucchio','Ortucchio','','NO','G145',41.9547991,13.6459071,39.3343,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066065','Ovindoli','Ovindoli','','NO','G200',42.1331483,13.5173837,61.4089,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066066','Pacentro','Pacentro','','NO','G210',42.0510414,13.9928316,72.6361,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066067','Pereto','Pereto','','NO','G449',42.0579947,13.1017447,41.1099,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066068','Pescasseroli','Pescasseroli','','NO','G484',41.8084673,13.7889904,91.4752,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066069','Pescina','Pescina','','NO','G492',42.0256026,13.6596201,48.8373,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066070','Pescocostanzo','Pescocostanzo','','NO','G493',41.8902550,14.0655493,55.2922,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066071','Pettorano sul Gizio','Pettorano sul Gizio','','NO','G524',41.9729419,13.9599705,62.9741,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066072','Pizzoli','Pizzoli','','NO','G726',42.4360631,13.3014379,56.6435,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066073','Poggio Picenze','Poggio Picenze','','NO','G766',42.3211152,13.5419906,11.6543,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066074','Prata d\'Ansidonia','Prata d\'Ansidonia','','NO','G992',42.2793804,13.6033092,19.5892,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066075','Pratola Peligna','Pratola Peligna','','NO','H007',42.0968914,13.8721218,28.5213,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066076','Prezza','Prezza','','NO','H056',42.0570668,13.8336716,21.5901,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066077','Raiano','Raiano','','NO','H166',42.1026797,13.8160972,28.7147,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066078','Rivisondoli','Rivisondoli','','NO','H353',41.8723982,14.0687863,32.1365,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066079','Roccacasale','Roccacasale','','NO','H389',42.1221272,13.8895601,17.5651,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066080','Rocca di Botte','Rocca di Botte','','NO','H399',42.0263210,13.0677001,31.2195,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066081','Rocca di Cambio','Rocca di Cambio','','NO','H400',42.2367719,13.4896498,27.7580,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066082','Rocca di Mezzo','Rocca di Mezzo','','NO','H402',42.2050604,13.5190076,90.3276,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066083','Rocca Pia','Rocca Pia','','NO','H429',41.9345462,13.9770917,44.8642,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066084','Roccaraso','Roccaraso','','NO','H434',41.8466247,14.0786829,49.7363,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066085','San Benedetto dei Marsi','San Benedetto dei Marsi','','NO','H772',42.0064054,13.6233461,16.8689,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066086','San Benedetto in Perillis','San Benedetto in Perillis','','NO','H773',42.1828806,13.7694979,19.1643,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066087','San Demetrio ne\' Vestini','San Demetrio ne\' Vestini','','NO','H819',42.2879854,13.5587995,16.3343,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066088','San Pio delle Camere','San Pio delle Camere','','NO','I121',42.2857368,13.6552449,17.1658,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066089','Sante Marie','Sante Marie','','NO','I326',42.1030350,13.2028275,40.8488,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066090','Sant\'Eusanio Forconese','Sant\'Eusanio Forconese','','NO','I336',42.2892552,13.5249287,7.8453,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066091','Santo Stefano di Sessanio','Santo Stefano di Sessanio','','NO','I360',42.3426700,13.6459274,33.7224,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066092','San Vincenzo Valle Roveto','San Vincenzo Valle Roveto','','NO','I389',41.8340074,13.5244675,46.1723,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066093','Scanno','Scanno','','NO','I501',41.9042012,13.8781988,134.8607,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066094','Scontrone','Scontrone','','NO','I543',41.7457556,14.0387760,21.2008,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066095','Scoppito','Scoppito','','NO','I546',42.3710952,13.2562390,53.0194,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066096','Scurcola Marsicana','Scurcola Marsicana','','NO','I553',42.0630895,13.3427775,30.2406,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066097','Secinaro','Secinaro','','NO','I558',42.1526995,13.6798281,33.4103,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066098','Sulmona','Sulmona','','NO','I804',42.0474832,13.9241962,57.7005,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066099','Tagliacozzo','Tagliacozzo','','NO','L025',42.0679487,13.2546151,86.9727,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066100','Tione degli Abruzzi','Tione degli Abruzzi','','NO','L173',42.2037230,13.6373673,39.2177,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066101','Tornimparte','Tornimparte','','NO','L227',42.2884776,13.3008875,65.7949,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066102','Trasacco','Trasacco','','NO','L334',41.9578522,13.5383057,51.2585,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066103','Villalago','Villalago','','NO','L958',41.9358707,13.8349583,33.4679,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066104','Villa Santa Lucia degli Abruzzi','Villa Santa Lucia degli Abruzzi','','NO','M021',42.3328592,13.7787003,27.2305,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066105','Villa Sant\'Angelo','Villa Sant\'Angelo','','NO','M023',42.2704461,13.5372918,5.4200,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066106','Villavallelonga','Villavallelonga','','NO','M031',41.8674400,13.6245146,73.8984,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066107','Villetta Barrea','Villetta Barrea','','NO','M041',41.7759682,13.9356390,20.6993,'066');
INSERT INTO `gi_comuni` VALUES ('AQ','066108','Vittorito','Vittorito','','NO','M090',42.1252755,13.8165873,14.1833,'066');
INSERT INTO `gi_comuni` VALUES ('TE','067001','Alba Adriatica','Alba Adriatica','','NO','A125',42.8344339,13.9207580,9.5402,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067002','Ancarano','Ancarano','','NO','A270',42.8368030,13.7410609,14.0855,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067003','Arsita','Arsita','','NO','A445',42.5032138,13.7858830,34.0487,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067004','Atri','Atri','','NO','A488',42.5796768,13.9751825,92.1648,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067005','Basciano','Basciano','','NO','A692',42.5959032,13.7387180,18.9791,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067006','Bellante','Bellante','','NO','A746',42.7446726,13.8055734,49.8538,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067007','Bisenti','Bisenti','','NO','A885',42.5286436,13.8041395,30.7400,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067008','Campli','Campli','','NO','B515',42.7260652,13.6864943,73.4675,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067009','Canzano','Canzano','','NO','B640',42.6473456,13.8029890,16.9208,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067010','Castel Castagna','Castel Castagna','','NO','C040',42.5425536,13.7168150,18.3646,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067011','Castellalto','Castellalto','','NO','C128',42.6756666,13.8176452,33.9618,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067012','Castelli','Castelli','','NO','C169',42.4890546,13.7117698,49.8767,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067013','Castiglione Messer Raimondo','Castiglione Messer Raimondo','','NO','C316',42.5308843,13.8828221,30.8505,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067014','Castilenti','Castilenti','','NO','C322',42.5334797,13.9175834,24.1116,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067015','Cellino Attanasio','Cellino Attanasio','','NO','C449',42.5859088,13.8592625,44.0671,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067016','Cermignano','Cermignano','','NO','C517',42.5893020,13.7936488,26.2472,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067017','Civitella del Tronto','Civitella del Tronto','','NO','C781',42.7721988,13.6682873,77.4845,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067018','Colledara','Colledara','','NO','C311',42.5398672,13.6749807,17.9155,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067019','Colonnella','Colonnella','','NO','C901',42.8716781,13.8672877,21.5582,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067020','Controguerra','Controguerra','','NO','C972',42.8554551,13.8198243,22.5701,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067021','Corropoli','Corropoli','','NO','D043',42.8276396,13.8347595,22.2576,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067022','Cortino','Cortino','','NO','D076',42.6252874,13.5830721,63.1186,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067023','Crognaleto','Crognaleto','','NO','D179',42.5477588,13.4783809,124.3875,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067024','Fano Adriano','Fano Adriano','','NO','D489',42.5528966,13.5375947,35.5101,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067025','Giulianova','Giulianova','','NO','E058',42.7524502,13.9566587,27.9549,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067026','Isola del Gran Sasso d\'Italia','Isola del Gran Sasso d\'Italia','','NO','E343',42.5026625,13.6623241,83.9165,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067027','Montefino','Montefino','','NO','F500',42.5445735,13.8844508,18.4596,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067028','Montorio al Vomano','Montorio al Vomano','','NO','F690',42.5829343,13.6324751,53.7572,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067029','Morro d\'Oro','Morro d\'Oro','','NO','F747',42.6637407,13.9195156,28.7762,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067030','Mosciano Sant\'Angelo','Mosciano Sant\'Angelo','','NO','F764',42.7494052,13.8877757,48.7160,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067031','Nereto','Nereto','','NO','F870',42.8203894,13.8178305,7.0121,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067032','Notaresco','Notaresco','','NO','F942',42.6587702,13.8941722,38.1015,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067033','Penna Sant\'Andrea','Penna Sant\'Andrea','','NO','G437',42.5936274,13.7716417,10.9840,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067034','Pietracamela','Pietracamela','','NO','G608',42.5236392,13.5539029,44.8038,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067035','Pineto','Pineto','','NO','F831',42.6078889,14.0669983,38.1490,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067036','Rocca Santa Maria','Rocca Santa Maria','','NO','H440',42.6859365,13.5281766,61.4152,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067037','Roseto degli Abruzzi','Roseto degli Abruzzi','','NO','F585',42.6796047,14.0108565,53.0147,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067038','Sant\'Egidio alla Vibrata','Sant\'Egidio alla Vibrata','','NO','I318',42.8252509,13.7163583,18.5227,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067039','Sant\'Omero','Sant\'Omero','','NO','I348',42.7865955,13.8018177,34.2225,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067040','Silvi','Silvi','','NO','I741',42.5566685,14.1144014,20.7195,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067041','Teramo','Teramo','','SI','L103',42.6590815,13.7000048,152.6963,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067042','Torano Nuovo','Torano Nuovo','','NO','L207',42.8233161,13.7768667,10.1361,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067043','Torricella Sicura','Torricella Sicura','','NO','L295',42.6571794,13.6547938,54.6895,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067044','Tortoreto','Tortoreto','','NO','L307',42.8038957,13.9128173,22.6696,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067045','Tossicia','Tossicia','','NO','L314',42.5470341,13.6460041,27.3596,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067046','Valle Castellana','Valle Castellana','','NO','L597',42.7353826,13.4975833,131.2134,'067');
INSERT INTO `gi_comuni` VALUES ('TE','067047','Martinsicuro','Martinsicuro','','NO','E989',42.8852148,13.9160057,14.6162,'067');
INSERT INTO `gi_comuni` VALUES ('PE','068001','Abbateggio','Abbateggio','','NO','A008',42.2243803,14.0135289,15.1969,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068002','Alanno','Alanno','','NO','A120',42.2942947,13.9697977,32.5755,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068003','Bolognano','Bolognano','','NO','A945',42.2169765,13.9598537,17.0708,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068004','Brittoli','Brittoli','','NO','B193',42.3161019,13.8609009,15.9400,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068005','Bussi sul Tirino','Bussi sul Tirino','','NO','B294',42.2091149,13.8256334,26.1117,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068006','Cappelle sul Tavo','Cappelle sul Tavo','','NO','B681',42.4654416,14.1033236,5.5181,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068007','Caramanico Terme','Caramanico Terme','','NO','B722',42.1564611,14.0031810,85.1327,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068008','Carpineto della Nora','Carpineto della Nora','','NO','B827',42.3329625,13.8600482,23.9408,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068009','Castiglione a Casauria','Castiglione a Casauria','','NO','C308',42.2360710,13.8935300,16.2548,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068010','Catignano','Catignano','','NO','C354',42.3459651,13.9500842,17.0479,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068011','Cepagatti','Cepagatti','','NO','C474',42.3644170,14.0734460,30.8974,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068012','Città Sant\'Angelo','Città Sant\'Angelo','','NO','C750',42.5185898,14.0592184,61.9864,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068013','Civitaquana','Civitaquana','','NO','C771',42.3258867,13.8969166,22.1397,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068014','Civitella Casanova','Civitella Casanova','','NO','C779',42.3646121,13.8891099,31.1024,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068015','Collecorvino','Collecorvino','','NO','C853',42.4584456,14.0144681,31.8915,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068016','Corvara','Corvara','','NO','D078',42.2772961,13.8874547,13.6751,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068017','Cugnoli','Cugnoli','','NO','D201',42.3081731,13.9332664,16.0319,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068018','Elice','Elice','','NO','D394',42.5188169,13.9682753,14.0095,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068019','Farindola','Farindola','','NO','D501',42.4416285,13.8221020,45.5116,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068020','Lettomanoppello','Lettomanoppello','','NO','E558',42.2366163,14.0371505,15.0909,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068021','Loreto Aprutino','Loreto Aprutino','','NO','E691',42.4337543,13.9826062,59.5185,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068022','Manoppello','Manoppello','','NO','E892',42.2596889,14.0602503,39.3022,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068023','Montebello di Bertona','Montebello di Bertona','','NO','F441',42.4163758,13.8691537,21.6723,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068024','Montesilvano','Montesilvano','','NO','F646',42.5141348,14.1492830,23.7444,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068025','Moscufo','Moscufo','','NO','F765',42.4284332,14.0547155,19.9701,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068026','Nocciano','Nocciano','','NO','F908',42.3332354,13.9844745,13.7552,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068027','Penne','Penne','','NO','G438',42.4586929,13.9271371,91.0338,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068028','Pescara','Pescara','','SI','G482',42.4641173,14.2143544,34.5785,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068029','Pescosansonesco','Pescosansonesco','','NO','G499',42.2531955,13.8840771,18.3823,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068030','Pianella','Pianella','','NO','G555',42.3960603,14.0463604,47.0216,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068031','Picciano','Picciano','','NO','G589',42.4748466,13.9913866,7.7210,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068032','Pietranico','Pietranico','','NO','G621',42.2760090,13.9105099,14.9457,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068033','Popoli Terme','Popoli Terme','','NO','G878',42.1757658,13.8309036,34.8626,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068034','Roccamorice','Roccamorice','','NO','H425',42.2138718,14.0239845,25.0360,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068035','Rosciano','Rosciano','','NO','H562',42.3217520,14.0477953,27.3111,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068036','Salle','Salle','','NO','H715',42.1769279,13.9595185,21.8411,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068037','Sant\'Eufemia a Maiella','Sant\'Eufemia a Maiella','','NO','I332',42.1253586,14.0278433,40.6249,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068038','San Valentino in Abruzzo Citeriore','San Valentino in Abruzzo Citeriore','','NO','I376',42.2326167,13.9869333,16.1195,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068039','Scafa','Scafa','','NO','I482',42.2679597,14.0020214,10.4187,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068040','Serramonacesca','Serramonacesca','','NO','I649',42.2477773,14.0936043,23.6214,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068041','Spoltore','Spoltore','','NO','I922',42.4552070,14.1408617,36.9763,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068042','Tocco da Casauria','Tocco da Casauria','','NO','L186',42.2178098,13.9142915,29.5037,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068043','Torre de\' Passeri','Torre de\' Passeri','','NO','L263',42.2447716,13.9274988,5.9144,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068044','Turrivalignani','Turrivalignani','','NO','L475',42.2631562,14.0285208,6.2104,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068045','Vicoli','Vicoli','','NO','L846',42.3420621,13.8976725,9.1600,'068');
INSERT INTO `gi_comuni` VALUES ('PE','068046','Villa Celiera','Villa Celiera','','NO','L922',42.3800373,13.8589578,13.2028,'068');
INSERT INTO `gi_comuni` VALUES ('CH','069001','Altino','Altino','','NO','A235',42.1009949,14.3310258,15.2844,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069002','Archi','Archi','','NO','A367',42.0887974,14.3812550,28.5122,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069003','Ari','Ari','','NO','A398',42.2907829,14.2601863,11.6976,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069004','Arielli','Arielli','','NO','A402',42.2652590,14.3052731,11.7195,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069005','Atessa','Atessa','','NO','A485',42.0677950,14.4430274,110.1319,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069006','Bomba','Bomba','','NO','A956',42.0351147,14.3664144,17.3619,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069007','Borrello','Borrello','','NO','B057',41.9200623,14.3034111,14.5127,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069008','Bucchianico','Bucchianico','','NO','B238',42.3046169,14.1809347,38.1292,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069009','Montebello sul Sangro','Montebello sul Sangro','','NO','B268',41.9869388,14.3247355,5.4523,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069010','Canosa Sannita','Canosa Sannita','','NO','B620',42.2953113,14.3017597,14.0390,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069011','Carpineto Sinello','Carpineto Sinello','','NO','B826',42.0105479,14.5049209,29.5984,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069012','Carunchio','Carunchio','','NO','B853',41.9167303,14.5275183,32.3810,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069013','Casacanditella','Casacanditella','','NO','B859',42.2485365,14.1998823,12.6002,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069014','Casalanguida','Casalanguida','','NO','B861',42.0369313,14.4978686,13.5156,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069015','Casalbordino','Casalbordino','','NO','B865',42.1505877,14.5851134,46.3703,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069016','Casalincontrada','Casalincontrada','','NO','B896',42.2900628,14.1343548,16.2080,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069017','Casoli','Casoli','','NO','B985',42.1146738,14.2909104,66.9157,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069018','Castel Frentano','Castel Frentano','','NO','C114',42.1960409,14.3565821,21.8878,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069019','Castelguidone','Castelguidone','','NO','C123',41.8233724,14.5226422,15.1748,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069020','Castiglione Messer Marino','Castiglione Messer Marino','','NO','C298',41.8667215,14.4515222,47.2049,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069021','Celenza sul Trigno','Celenza sul Trigno','','NO','C428',41.8715956,14.5808981,22.6428,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069022','Chieti','Chieti','','SI','C632',42.3497201,14.1673107,59.6596,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069023','Civitaluparella','Civitaluparella','','NO','C768',41.9446862,14.3030105,22.4479,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069024','Civitella Messer Raimondo','Civitella Messer Raimondo','','NO','C776',42.0884075,14.2161803,12.6823,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069025','Colledimacine','Colledimacine','','NO','C855',42.0040479,14.2016631,11.2463,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069026','Colledimezzo','Colledimezzo','','NO','C856',41.9855136,14.3810291,11.1490,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069027','Crecchio','Crecchio','','NO','D137',42.2969807,14.3262500,18.9876,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069028','Cupello','Cupello','','NO','D209',42.0722999,14.6715162,48.4294,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069029','Dogliola','Dogliola','','NO','D315',41.9416848,14.6357569,11.8120,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069030','Fara Filiorum Petri','Fara Filiorum Petri','','NO','D494',42.2485513,14.1859438,14.8567,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069031','Fara San Martino','Fara San Martino','','NO','D495',42.0902471,14.2058701,44.8888,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069032','Filetto','Filetto','','NO','D592',42.2258737,14.2442072,13.5089,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069033','Fossacesia','Fossacesia','','NO','D738',42.2451832,14.4802977,30.2499,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069034','Fraine','Fraine','','NO','D757',41.9045445,14.4871877,16.5425,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069035','Francavilla al Mare','Francavilla al Mare','','NO','D763',42.4177823,14.2924499,22.8752,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069036','Fresagrandinaria','Fresagrandinaria','','NO','D796',41.9753758,14.6624512,25.0349,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069037','Frisa','Frisa','','NO','D803',42.2609317,14.3708669,11.5633,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069038','Furci','Furci','','NO','D823',42.0083385,14.5863184,25.8961,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069039','Gamberale','Gamberale','','NO','D898',41.9056534,14.2078197,15.5054,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069040','Gessopalena','Gessopalena','','NO','D996',42.0563074,14.2741459,31.7331,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069041','Gissi','Gissi','','NO','E052',42.0209627,14.5460849,36.6338,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069042','Giuliano Teatino','Giuliano Teatino','','NO','E056',42.2929613,14.2758000,10.0362,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069043','Guardiagrele','Guardiagrele','','NO','E243',42.1911316,14.2202753,56.1373,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069044','Guilmi','Guilmi','','NO','E266',41.9968897,14.4758286,12.6948,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069045','Lama dei Peligni','Lama dei Peligni','','NO','E424',42.0422908,14.1885991,31.3487,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069046','Lanciano','Lanciano','','NO','E435',42.2311629,14.3905243,66.7241,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069047','Lentella','Lentella','','NO','E531',41.9972482,14.6765848,12.6745,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069048','Lettopalena','Lettopalena','','NO','E559',42.0032894,14.1584430,21.2160,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069049','Liscia','Liscia','','NO','E611',41.9549836,14.5556118,8.2396,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069050','Miglianico','Miglianico','','NO','F196',42.3597154,14.2913816,22.6013,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069051','Montazzoli','Montazzoli','','NO','F433',41.9482594,14.4293088,39.1263,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069052','Monteferrante','Monteferrante','','NO','F498',41.9540834,14.3890250,15.2053,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069053','Montelapiano','Montelapiano','','NO','F535',41.9618254,14.3423411,8.2915,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069054','Montenerodomo','Montenerodomo','','NO','F578',41.9765361,14.2518453,29.7201,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069055','Monteodorisio','Monteodorisio','','NO','F582',42.0879248,14.6527970,25.3331,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069056','Mozzagrogna','Mozzagrogna','','NO','F785',42.2125518,14.4448448,14.3318,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069057','Orsogna','Orsogna','','NO','G128',42.2184600,14.2829107,25.2364,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069058','Ortona','Ortona','','NO','G141',42.3555927,14.4035297,70.8597,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069059','Paglieta','Paglieta','','NO','G237',42.1621046,14.4976040,33.5009,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069060','Palena','Palena','','NO','G271',41.9832225,14.1378275,93.8307,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069061','Palmoli','Palmoli','','NO','G290',41.9387838,14.5809977,32.6036,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069062','Palombaro','Palombaro','','NO','G294',42.1242476,14.2304825,17.3060,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069063','Pennadomo','Pennadomo','','NO','G434',42.0040899,14.3232368,10.7977,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069064','Pennapiedimonte','Pennapiedimonte','','NO','G435',42.1518253,14.1947794,47.0651,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069065','Perano','Perano','','NO','G441',42.1079546,14.3964056,6.5694,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069066','Pizzoferrato','Pizzoferrato','','NO','G724',41.9222243,14.2370323,31.0044,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069067','Poggiofiorito','Poggiofiorito','','NO','G760',42.2561579,14.3238196,10.0494,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069068','Pollutri','Pollutri','','NO','G799',42.1373848,14.5920163,26.1065,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069069','Pretoro','Pretoro','','NO','H052',42.2163666,14.1430760,25.9181,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069070','Quadri','Quadri','','NO','H098',41.9256410,14.2882905,7.3884,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069071','Rapino','Rapino','','NO','H184',42.2106574,14.1871731,20.6097,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069072','Ripa Teatina','Ripa Teatina','','NO','H320',42.3578421,14.2340363,20.3961,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069073','Roccamontepiano','Roccamontepiano','','NO','H424',42.2448287,14.1271812,18.1288,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069074','Rocca San Giovanni','Rocca San Giovanni','','NO','H439',42.2509579,14.4650728,21.6632,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069075','Roccascalegna','Roccascalegna','','NO','H442',42.0620160,14.3066332,22.9402,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069076','Roccaspinalveti','Roccaspinalveti','','NO','H448',41.9380880,14.4711303,33.0336,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069077','Roio del Sangro','Roio del Sangro','','NO','H495',41.9117527,14.3730141,11.9468,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069078','Rosello','Rosello','','NO','H566',41.9015733,14.3487644,19.0635,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069079','San Buono','San Buono','','NO','H784',41.9804645,14.5696826,25.4746,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069080','San Giovanni Lipioni','San Giovanni Lipioni','','NO','H923',41.8425355,14.5621284,8.7951,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069081','San Giovanni Teatino','San Giovanni Teatino','','NO','D690',42.4221424,14.1867294,17.8563,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069082','San Martino sulla Marrucina','San Martino sulla Marrucina','','NO','H991',42.2249702,14.2143132,7.3627,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069083','San Salvo','San Salvo','','NO','I148',42.0453950,14.7315971,19.8955,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069084','Santa Maria Imbaro','Santa Maria Imbaro','','NO','I244',42.2195739,14.4476339,5.6303,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069085','Sant\'Eusanio del Sangro','Sant\'Eusanio del Sangro','','NO','I335',42.1677746,14.3321823,24.1622,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069086','San Vito Chietino','San Vito Chietino','','NO','I394',42.3025501,14.4460875,17.2553,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069087','Scerni','Scerni','','NO','I520',42.1116779,14.5687307,41.3202,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069088','Schiavi di Abruzzo','Schiavi di Abruzzo','','NO','I526',41.8159087,14.4849478,45.7176,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069089','Taranta Peligna','Taranta Peligna','','NO','L047',42.0199369,14.1692149,21.6967,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069090','Tollo','Tollo','','NO','L194',42.3392944,14.3179759,14.9585,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069091','Torino di Sangro','Torino di Sangro','','NO','L218',42.1880447,14.5408522,32.0485,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069092','Tornareccio','Tornareccio','','NO','L224',42.0381939,14.4125207,28.0241,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069093','Torrebruna','Torrebruna','','NO','L253',41.8665346,14.5423918,23.5371,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069094','Torrevecchia Teatina','Torrevecchia Teatina','','NO','L284',42.3808809,14.2086892,14.7707,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069095','Torricella Peligna','Torricella Peligna','','NO','L291',42.0220305,14.2611566,36.1322,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069096','Treglio','Treglio','','NO','L363',42.2671070,14.4249137,4.7525,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069097','Tufillo','Tufillo','','NO','L459',41.9159495,14.6262889,21.5114,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069098','Vacri','Vacri','','NO','L526',42.2977509,14.2327533,12.0938,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069099','Vasto','Vasto','','NO','E372',42.1125156,14.7082457,71.2963,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069100','Villalfonsina','Villalfonsina','','NO','L961',42.1618394,14.5715742,9.1170,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069101','Villamagna','Villamagna','','NO','L964',42.3331194,14.2368668,12.6433,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069102','Villa Santa Maria','Villa Santa Maria','','NO','M022',41.9504269,14.3504806,16.4037,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069103','Pietraferrazzana','Pietraferrazzana','','NO','G613',41.9698977,14.3740349,4.4080,'069');
INSERT INTO `gi_comuni` VALUES ('CH','069104','Fallo','Fallo','','NO','D480',41.9389024,14.3224075,6.1025,'069');
INSERT INTO `gi_comuni` VALUES ('CB','070001','Acquaviva Collecroce','Acquaviva Collecroce','','NO','A050',41.8678272,14.7465799,28.5938,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070002','Baranello','Baranello','','NO','A616',41.5261463,14.5597033,25.3491,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070003','Bojano','Bojano','','NO','A930',41.4827437,14.4715215,53.0548,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070004','Bonefro','Bonefro','','NO','A971',41.7019073,14.9340894,31.2475,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070005','Busso','Busso','','NO','B295',41.5552457,14.5625092,23.4853,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070006','Campobasso','Campobasso','','SI','B519',41.5576976,14.6591565,55.7546,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070007','Campochiaro','Campochiaro','','NO','B522',41.4483347,14.5057909,35.8355,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070008','Campodipietra','Campodipietra','','NO','B528',41.5576322,14.7469403,20.0478,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070009','Campolieto','Campolieto','','NO','B544',41.6337293,14.7663180,24.7343,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070010','Campomarino','Campomarino','','NO','B550',41.9563864,15.0331726,77.2326,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070011','Casacalenda','Casacalenda','','NO','B858',41.7396465,14.8468331,66.9686,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070012','Casalciprano','Casalciprano','','NO','B871',41.5817176,14.5286473,19.1841,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070013','Castelbottaccio','Castelbottaccio','','NO','C066',41.7529025,14.7072510,11.4225,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070014','Castellino del Biferno','Castellino del Biferno','','NO','C175',41.7009887,14.7323011,15.5844,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070015','Castelmauro','Castelmauro','','NO','C197',41.8293254,14.7105765,43.8333,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070016','Castropignano','Castropignano','','NO','C346',41.6196534,14.5611649,26.6845,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070017','Cercemaggiore','Cercemaggiore','','NO','C486',41.4601953,14.7220886,57.0263,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070018','Cercepiccola','Cercepiccola','','NO','C488',41.4593571,14.6669880,16.8679,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070019','Civitacampomarano','Civitacampomarano','','NO','C764',41.7801697,14.6878335,38.6023,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070020','Colle d\'Anchise','Colle d\'Anchise','','NO','C854',41.5090992,14.5181023,15.7701,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070021','Colletorto','Colletorto','','NO','C875',41.6632665,14.9731720,36.3018,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070022','Duronia','Duronia','','NO','C772',41.6579371,14.4602430,22.8092,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070023','Ferrazzano','Ferrazzano','','NO','D550',41.5307051,14.6713306,17.1064,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070024','Fossalto','Fossalto','','NO','D737',41.6731763,14.5449534,28.6214,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070025','Gambatesa','Gambatesa','','NO','D896',41.5098351,14.9144189,43.3788,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070026','Gildone','Gildone','','NO','E030',41.5094478,14.7405707,29.6300,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070027','Guardialfiera','Guardialfiera','','NO','E244',41.8024887,14.7929574,43.7565,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070028','Guardiaregia','Guardiaregia','','NO','E248',41.4349482,14.5414535,43.4740,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070029','Guglionesi','Guglionesi','','NO','E259',41.9110347,14.9138638,100.8954,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070030','Jelsi','Jelsi','','NO','E381',41.5182012,14.7962250,28.6877,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070031','Larino','Larino','','NO','E456',41.8004323,14.9111623,89.0892,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070032','Limosano','Limosano','','NO','E599',41.6766108,14.6211270,28.1955,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070033','Lucito','Lucito','','NO','E722',41.7316062,14.6881134,31.1841,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070034','Lupara','Lupara','','NO','E748',41.7618841,14.7332686,25.6536,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070035','Macchia Valfortore','Macchia Valfortore','','NO','E780',41.5931191,14.9109158,26.8095,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070036','Mafalda','Mafalda','','NO','E799',41.9418902,14.7132552,32.5603,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070037','Matrice','Matrice','','NO','F055',41.6122506,14.7110278,20.3780,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070038','Mirabello Sannitico','Mirabello Sannitico','','NO','F233',41.5153299,14.6720699,21.5464,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070039','Molise','Molise','','NO','F294',41.6308502,14.4939898,5.1283,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070040','Monacilioni','Monacilioni','','NO','F322',41.6102203,14.8103249,27.4126,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070041','Montagano','Montagano','','NO','F391',41.6464027,14.6738708,26.6584,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070042','Montecilfone','Montecilfone','','NO','F475',41.9015374,14.8369332,22.8762,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070043','Montefalcone nel Sannio','Montefalcone nel Sannio','','NO','F495',41.8670939,14.6403633,32.4697,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070044','Montelongo','Montelongo','','NO','F548',41.7357435,14.9487298,12.8201,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070045','Montemitro','Montemitro','','NO','F569',41.8881449,14.6468935,16.4800,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070046','Montenero di Bisaccia','Montenero di Bisaccia','','NO','F576',41.9568910,14.7809097,92.9460,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070047','Montorio nei Frentani','Montorio nei Frentani','','NO','F689',41.7590240,14.9327329,31.5504,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070048','Morrone del Sannio','Morrone del Sannio','','NO','F748',41.7120231,14.7782110,45.9620,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070049','Oratino','Oratino','','NO','G086',41.5852554,14.5847060,18.0932,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070050','Palata','Palata','','NO','G257',41.8862876,14.7890493,43.3581,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070051','Petacciato','Petacciato','','NO','G506',42.0131944,14.8603466,35.7132,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070052','Petrella Tifernina','Petrella Tifernina','','NO','G512',41.6912178,14.6951939,26.5250,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070053','Pietracatella','Pietracatella','','NO','G609',41.5806497,14.8735277,50.1643,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070054','Pietracupa','Pietracupa','','NO','G610',41.6822347,14.5211094,10.0903,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070055','Portocannone','Portocannone','','NO','G910',41.9146690,15.0091179,13.1656,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070056','Provvidenti','Provvidenti','','NO','H083',41.7185126,14.8223623,14.2206,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070057','Riccia','Riccia','','NO','H273',41.4863720,14.8363348,70.2352,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070058','Ripabottoni','Ripabottoni','','NO','H311',41.6884341,14.8064746,32.0572,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070059','Ripalimosani','Ripalimosani','','NO','H313',41.6116261,14.6634492,33.5824,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070060','Roccavivara','Roccavivara','','NO','H454',41.8353420,14.5991199,21.1242,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070061','Rotello','Rotello','','NO','H589',41.7495452,15.0037799,70.8461,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070062','Salcito','Salcito','','NO','H693',41.7473198,14.5105039,27.9933,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070063','San Biase','San Biase','','NO','H782',41.7146904,14.5895208,11.8483,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070064','San Felice del Molise','San Felice del Molise','','NO','H833',41.8901444,14.7012316,24.1651,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070065','San Giacomo degli Schiavoni','San Giacomo degli Schiavoni','','NO','H867',41.9627481,14.9460044,11.2542,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070066','San Giovanni in Galdo','San Giovanni in Galdo','','NO','H920',41.5886495,14.7474887,19.2829,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070067','San Giuliano del Sannio','San Giuliano del Sannio','','NO','H928',41.4558587,14.6388731,24.0798,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070068','San Giuliano di Puglia','San Giuliano di Puglia','','NO','H929',41.6848886,14.9640425,41.9400,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070069','San Martino in Pensilis','San Martino in Pensilis','','NO','H990',41.8699867,15.0105612,100.5692,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070070','San Massimo','San Massimo','','NO','I023',41.4929928,14.4100441,27.3080,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070071','San Polo Matese','San Polo Matese','','NO','I122',41.4591790,14.4938326,15.0148,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070072','Santa Croce di Magliano','Santa Croce di Magliano','','NO','I181',41.7124154,14.9920009,53.2195,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070073','Sant\'Angelo Limosano','Sant\'Angelo Limosano','','NO','I289',41.6924048,14.6035178,17.0959,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070074','Sant\'Elia a Pianisi','Sant\'Elia a Pianisi','','NO','I320',41.6217388,14.8755227,67.9034,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070075','Sepino','Sepino','','NO','I618',41.4072720,14.6187359,61.6296,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070076','Spinete','Spinete','','NO','I910',41.5433368,14.4874696,17.8654,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070077','Tavenna','Tavenna','','NO','L069',41.9086678,14.7633797,22.0737,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070078','Termoli','Termoli','','NO','L113',42.0028555,14.9949761,55.1874,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070079','Torella del Sannio','Torella del Sannio','','NO','L215',41.6400017,14.5213357,16.7151,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070080','Toro','Toro','','NO','L230',41.5742136,14.7657412,24.1302,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070081','Trivento','Trivento','','NO','L435',41.7839873,14.5510575,73.8369,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070082','Tufara','Tufara','','NO','L458',41.4818504,14.9458127,35.5518,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070083','Ururi','Ururi','','NO','L505',41.8146595,15.0116178,31.5676,'070');
INSERT INTO `gi_comuni` VALUES ('CB','070084','Vinchiaturo','Vinchiaturo','','NO','M057',41.4939525,14.5873298,35.1684,'070');
INSERT INTO `gi_comuni` VALUES ('FG','071001','Accadia','Accadia','','NO','A015',41.1586170,15.3312354,30.5009,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071002','Alberona','Alberona','','NO','A150',41.4299431,15.1245871,49.6220,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071003','Anzano di Puglia','Anzano di Puglia','','NO','A320',41.1189491,15.2914149,10.7978,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071004','Apricena','Apricena','','NO','A339',41.7854937,15.4431214,172.7147,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071005','Ascoli Satriano','Ascoli Satriano','','NO','A463',41.2043966,15.5605750,337.1378,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071006','Biccari','Biccari','','NO','A854',41.3977635,15.1955195,106.6591,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071007','Bovino','Bovino','','NO','B104',41.2525032,15.3417160,85.1845,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071008','Cagnano Varano','Cagnano Varano','','NO','B357',41.8293497,15.7719111,167.0260,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071009','Candela','Candela','','NO','B584',41.1375450,15.5155674,96.9171,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071010','Carapelle','Carapelle','','NO','B724',41.3646029,15.6936748,24.5424,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071011','Carlantino','Carlantino','','NO','B784',41.5920037,14.9766292,34.6958,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071012','Carpino','Carpino','','NO','B829',41.8447768,15.8555098,79.8390,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071013','Casalnuovo Monterotaro','Casalnuovo Monterotaro','','NO','B904',41.6183401,15.1026791,48.1695,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071014','Casalvecchio di Puglia','Casalvecchio di Puglia','','NO','B917',41.5948378,15.1102844,31.7958,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071015','Castelluccio dei Sauri','Castelluccio dei Sauri','','NO','C198',41.3040432,15.4736150,51.1950,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071016','Castelluccio Valmaggiore','Castelluccio Valmaggiore','','NO','C202',41.3419248,15.2002806,26.7327,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071017','Castelnuovo della Daunia','Castelnuovo della Daunia','','NO','C222',41.5828708,15.1183733,61.4684,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071018','Celenza Valfortore','Celenza Valfortore','','NO','C429',41.5616528,14.9778822,65.5306,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071019','Celle di San Vito','Celle di San Vito','','NO','C442',41.3249829,15.1809500,18.3537,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071020','Cerignola','Cerignola','','NO','C514',41.2648778,15.9041862,593.7390,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071021','Chieuti','Chieuti','','NO','C633',41.8466349,15.1666266,61.2881,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071022','Deliceto','Deliceto','','NO','D269',41.2224489,15.3876782,75.7968,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071023','Faeto','Faeto','','NO','D459',41.3237846,15.1608059,25.8732,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071024','Foggia','Foggia','','SI','D643',41.4622051,15.5431113,509.2854,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071025','Ischitella','Ischitella','','NO','E332',41.9042996,15.8965514,85.1288,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071026','Isole Tremiti','Isole Tremiti','','NO','E363',42.1202605,15.5046145,3.2994,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071027','Lesina','Lesina','','NO','E549',41.8650691,15.3528220,160.6343,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071028','Lucera','Lucera','','NO','E716',41.5057058,15.3362235,340.0719,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071029','Manfredonia','Manfredonia','','NO','E885',41.6280962,15.9188769,355.0460,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071031','Mattinata','Mattinata','','NO','F059',41.7103966,16.0515998,73.3907,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071032','Monteleone di Puglia','Monteleone di Puglia','','NO','F538',41.1664314,15.2599057,36.2998,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071033','Monte Sant\'Angelo','Monte Sant\'Angelo','','NO','F631',41.7055003,15.9581748,244.9722,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071034','Motta Montecorvino','Motta Montecorvino','','NO','F777',41.5072417,15.1145705,20.0543,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071035','Orsara di Puglia','Orsara di Puglia','','NO','G125',41.2808177,15.2658636,82.9425,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071036','Orta Nova','Orta Nova','','NO','G131',41.3268277,15.7069353,105.5155,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071037','Panni','Panni','','NO','G312',41.2198904,15.2766416,32.6515,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071038','Peschici','Peschici','','NO','G487',41.9469536,16.0157309,49.4530,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071039','Pietramontecorvino','Pietramontecorvino','','NO','G604',41.5431227,15.1299786,71.7606,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071040','Poggio Imperiale','Poggio Imperiale','','NO','G761',41.8237110,15.3651800,52.8464,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071041','Rignano Garganico','Rignano Garganico','','NO','H287',41.6781127,15.5887825,90.0138,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071042','Rocchetta Sant\'Antonio','Rocchetta Sant\'Antonio','','NO','H467',41.1027983,15.4576112,72.3285,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071043','Rodi Garganico','Rodi Garganico','','NO','H480',41.9279413,15.8811785,13.6217,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071044','Roseto Valfortore','Roseto Valfortore','','NO','H568',41.3699072,15.0939119,49.9468,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071046','San Giovanni Rotondo','San Giovanni Rotondo','','NO','H926',41.7070077,15.7272656,261.9690,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071047','San Marco in Lamis','San Marco in Lamis','','NO','H985',41.7129353,15.6385841,233.9136,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071048','San Marco la Catola','San Marco la Catola','','NO','H986',41.5256684,15.0054368,28.5165,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071049','San Nicandro Garganico','San Nicandro Garganico','','NO','I054',41.8369729,15.5633690,172.7403,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071050','San Paolo di Civitate','San Paolo di Civitate','','NO','I072',41.7404466,15.2593219,90.6605,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071051','San Severo','San Severo','','NO','I158',41.6862049,15.3806446,335.3807,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071052','Sant\'Agata di Puglia','Sant\'Agata di Puglia','','NO','I193',41.1510067,15.3802022,116.1235,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071053','Serracapriola','Serracapriola','','NO','I641',41.8054128,15.1594113,143.8905,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071054','Stornara','Stornara','','NO','I962',41.2883229,15.7682964,33.6899,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071055','Stornarella','Stornarella','','NO','I963',41.2563854,15.7300576,33.8528,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071056','Torremaggiore','Torremaggiore','','NO','L273',41.6889850,15.2924300,210.0190,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071058','Troia','Troia','','NO','L447',41.3622123,15.3098447,168.8224,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071059','Vico del Gargano','Vico del Gargano','','NO','L842',41.8963157,15.9569128,111.2645,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071060','Vieste','Vieste','','NO','L858',41.8824648,16.1796703,169.0921,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071061','Volturara Appula','Volturara Appula','','NO','M131',41.4946846,15.0517398,52.2767,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071062','Volturino','Volturino','','NO','M132',41.4816263,15.1243594,58.2102,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071063','Ordona','Ordona','','NO','M266',41.3159843,15.6260359,39.5362,'071');
INSERT INTO `gi_comuni` VALUES ('FG','071064','Zapponeta','Zapponeta','','NO','M267',41.4555893,15.9549987,41.8074,'071');
INSERT INTO `gi_comuni` VALUES ('BA','072001','Acquaviva delle Fonti','Acquaviva delle Fonti','','NO','A048',40.8968023,16.8426152,132.6181,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072002','Adelfia','Adelfia','','NO','A055',41.0033877,16.8711576,29.7739,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072003','Alberobello','Alberobello','','NO','A149',40.7839704,17.2372225,41.0328,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072004','Altamura','Altamura','','NO','A225',40.8284111,16.5523558,430.3976,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072006','Bari','Bari','','SI','A662',41.1254785,16.8670863,116.9993,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072008','Binetto','Binetto','','NO','A874',41.0249839,16.7099242,17.4675,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072010','Bitetto','Bitetto','','NO','A892',41.0401869,16.7483775,33.7264,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072011','Bitonto','Bitonto','','NO','A893',41.1101665,16.6940714,174.0660,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072012','Bitritto','Bitritto','','NO','A894',41.0413090,16.8259837,18.1967,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072014','Capurso','Capurso','','NO','B716',41.0485905,16.9188070,15.1947,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072015','Casamassima','Casamassima','','NO','B923',40.9553880,16.9182742,78.4398,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072016','Cassano delle Murge','Cassano delle Murge','','NO','B998',40.8896021,16.7717311,90.2142,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072017','Castellana Grotte','Castellana Grotte','','NO','C134',40.8828985,17.1687493,68.6854,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072018','Cellamare','Cellamare','','NO','C436',41.0181250,16.9290108,6.0119,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072019','Conversano','Conversano','','NO','C975',40.9665299,17.1145414,128.5699,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072020','Corato','Corato','','NO','C983',41.1537234,16.4132867,169.7679,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072021','Gioia del Colle','Gioia del Colle','','NO','E038',40.8014568,16.9233093,208.9294,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072022','Giovinazzo','Giovinazzo','','NO','E047',41.1880532,16.6726122,44.4059,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072023','Gravina in Puglia','Gravina in Puglia','','NO','E155',40.8195622,16.4163079,384.5132,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072024','Grumo Appula','Grumo Appula','','NO','E223',41.0128387,16.7101208,81.4587,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072025','Locorotondo','Locorotondo','','NO','E645',40.7542447,17.3265998,48.1483,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072027','Modugno','Modugno','','NO','F262',41.0823478,16.7811249,32.4937,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072028','Mola di Bari','Mola di Bari','','NO','F280',41.0601866,17.0829143,50.6526,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072029','Molfetta','Molfetta','','NO','F284',41.2053661,16.6006722,58.7418,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072030','Monopoli','Monopoli','','NO','F376',40.9529257,17.3014267,157.4072,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072031','Noci','Noci','','NO','F915',40.7930112,17.1280576,150.4339,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072032','Noicattaro','Noicattaro','','NO','F923',41.0339124,16.9852638,40.7512,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072033','Palo del Colle','Palo del Colle','','NO','G291',41.0567859,16.7034029,79.7539,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072034','Poggiorsini','Poggiorsini','','NO','G769',40.9165520,16.2537472,43.4350,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072035','Polignano a Mare','Polignano a Mare','','NO','G787',40.9916543,17.2193566,63.7418,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072036','Putignano','Putignano','','NO','H096',40.8497063,17.1204885,100.3375,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072037','Rutigliano','Rutigliano','','NO','H643',41.0106742,17.0085210,53.8553,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072038','Ruvo di Puglia','Ruvo di Puglia','','NO','H645',41.1168666,16.4845748,223.9096,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072039','Sammichele di Bari','Sammichele di Bari','','NO','H749',40.8897011,16.9495249,34.1588,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072040','Sannicandro di Bari','Sannicandro di Bari','','NO','I053',41.0005533,16.7993814,56.5488,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072041','Santeramo in Colle','Santeramo in Colle','','NO','I330',40.7938777,16.7543754,144.9289,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072043','Terlizzi','Terlizzi','','NO','L109',41.1306400,16.5427159,69.0691,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072044','Toritto','Toritto','','NO','L220',40.9968363,16.6796297,75.9089,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072046','Triggiano','Triggiano','','NO','L425',41.0651814,16.9250287,20.2459,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072047','Turi','Turi','','NO','L472',40.9158697,17.0204210,71.4212,'272');
INSERT INTO `gi_comuni` VALUES ('BA','072048','Valenzano','Valenzano','','NO','L571',41.0418830,16.8872838,15.8895,'272');
INSERT INTO `gi_comuni` VALUES ('TA','073001','Avetrana','Avetrana','','NO','A514',40.3484878,17.7255470,74.2944,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073002','Carosino','Carosino','','NO','B808',40.4662031,17.3979804,11.0590,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073003','Castellaneta','Castellaneta','','NO','C136',40.6304704,16.9347741,242.4380,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073004','Crispiano','Crispiano','','NO','D171',40.6052874,17.2310990,112.2109,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073005','Faggiano','Faggiano','','NO','D463',40.4215577,17.3878223,21.4886,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073006','Fragagnano','Fragagnano','','NO','D754',40.4324352,17.4746129,22.6878,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073007','Ginosa','Ginosa','','NO','E036',40.5780011,16.7575052,188.8130,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073008','Grottaglie','Grottaglie','','NO','E205',40.5337583,17.4272599,101.5684,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073009','Laterza','Laterza','','NO','E469',40.6233910,16.7994893,161.0867,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073010','Leporano','Leporano','','NO','E537',40.3836413,17.3325867,15.2869,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073011','Lizzano','Lizzano','','NO','E630',40.3906529,17.4473169,46.9504,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073012','Manduria','Manduria','','NO','E882',40.4086081,17.6403644,180.2046,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073013','Martina Franca','Martina Franca','','NO','E986',40.7051135,17.3393164,298.9621,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073014','Maruggio','Maruggio','','NO','E995',40.3225013,17.5699567,49.1692,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073015','Massafra','Massafra','','NO','F027',40.5881822,17.1124417,128.4887,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073016','Monteiasi','Monteiasi','','NO','F531',40.5021263,17.3786010,9.7377,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073017','Montemesola','Montemesola','','NO','F563',40.5626952,17.3384464,16.3972,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073018','Monteparano','Monteparano','','NO','F587',40.4456083,17.4140162,3.7851,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073019','Mottola','Mottola','','NO','F784',40.6332725,17.0385218,212.9720,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073020','Palagianello','Palagianello','','NO','G251',40.6116659,16.9773892,44.0431,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073021','Palagiano','Palagiano','','NO','G252',40.5786950,17.0394357,70.1150,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073022','Pulsano','Pulsano','','NO','H090',40.3823679,17.3517970,18.9202,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073023','Roccaforzata','Roccaforzata','','NO','H409',40.4376024,17.3885443,6.1435,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073024','San Giorgio Ionico','San Giorgio Ionico','','NO','H882',40.4596023,17.3860656,23.6728,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073025','San Marzano di San Giuseppe','San Marzano di San Giuseppe','','NO','I018',40.4509218,17.5063259,19.2691,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073026','Sava','Sava','','NO','I467',40.4036374,17.5568385,44.5544,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073027','Taranto','Taranto','','SI','L049',40.4734399,17.2325724,249.0175,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073028','Torricella','Torricella','','NO','L294',40.3549082,17.5028474,26.9729,'073');
INSERT INTO `gi_comuni` VALUES ('TA','073029','Statte','Statte','','NO','M298',40.5649393,17.2038475,67.3203,'073');
INSERT INTO `gi_comuni` VALUES ('BR','074001','Brindisi','Brindisi','','SI','B180',40.6383521,17.9458098,333.1215,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074002','Carovigno','Carovigno','','NO','B809',40.7071909,17.6596879,106.6079,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074003','Ceglie Messapica','Ceglie Messapica','','NO','C424',40.6480963,17.5173854,131.7235,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074004','Cellino San Marco','Cellino San Marco','','NO','C448',40.4746196,17.9697461,37.8122,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074005','Cisternino','Cisternino','','NO','C741',40.7394110,17.4284438,53.9554,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074006','Erchie','Erchie','','NO','D422',40.4370757,17.7341475,44.7516,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074007','Fasano','Fasano','','NO','D508',40.8349654,17.3593214,131.7215,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074008','Francavilla Fontana','Francavilla Fontana','','NO','D761',40.5326899,17.5841407,177.9958,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074009','Latiano','Latiano','','NO','E471',40.5548303,17.7167698,55.0862,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074010','Mesagne','Mesagne','','NO','F152',40.5573159,17.8101522,124.2778,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074011','Oria','Oria','','NO','G098',40.5019879,17.6412614,83.5368,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074012','Ostuni','Ostuni','','NO','G187',40.7320927,17.5775643,226.3166,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074013','San Donaci','San Donaci','','NO','H822',40.4462245,17.9216359,34.0427,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074014','San Michele Salentino','San Michele Salentino','','NO','I045',40.6297556,17.6316330,26.6505,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074015','San Pancrazio Salentino','San Pancrazio Salentino','','NO','I066',40.4182452,17.8388623,56.7995,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074016','San Pietro Vernotico','San Pietro Vernotico','','NO','I119',40.4885934,18.0000200,46.7409,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074017','San Vito dei Normanni','San Vito dei Normanni','','NO','I396',40.6558381,17.7037098,67.0196,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074018','Torchiarolo','Torchiarolo','','NO','L213',40.4799318,18.0558832,32.8411,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074019','Torre Santa Susanna','Torre Santa Susanna','','NO','L280',40.4635830,17.7424847,55.4896,'074');
INSERT INTO `gi_comuni` VALUES ('BR','074020','Villa Castelli','Villa Castelli','','NO','L920',40.5776621,17.4759029,34.9541,'074');
INSERT INTO `gi_comuni` VALUES ('LE','075002','Alessano','Alessano','','NO','A184',39.8892354,18.3318997,28.8250,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075003','Alezio','Alezio','','NO','A185',40.0612876,18.0622661,16.5698,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075004','Alliste','Alliste','','NO','A208',39.9476271,18.0898902,23.6793,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075005','Andrano','Andrano','','NO','A281',39.9824266,18.3819407,15.9114,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075006','Aradeo','Aradeo','','NO','A350',40.1293860,18.1320206,8.4600,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075007','Arnesano','Arnesano','','NO','A425',40.3340985,18.0907770,13.6718,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075008','Bagnolo del Salento','Bagnolo del Salento','','NO','A572',40.1477648,18.3524353,6.5366,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075009','Botrugno','Botrugno','','NO','B086',40.0643310,18.3245568,9.5649,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075010','Calimera','Calimera','','NO','B413',40.2505756,18.2801247,11.1356,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075011','Campi Salentina','Campi Salentina','','NO','B506',40.3989252,18.0198803,45.7568,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075012','Cannole','Cannole','','NO','B616',40.1637870,18.3618889,20.4766,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075013','Caprarica di Lecce','Caprarica di Lecce','','NO','B690',40.2623493,18.2452456,10.8881,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075014','Carmiano','Carmiano','','NO','B792',40.3463194,18.0461355,23.9292,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075015','Carpignano Salentino','Carpignano Salentino','','NO','B822',40.1979772,18.3416751,48.9827,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075016','Casarano','Casarano','','NO','B936',40.0097559,18.1602468,38.4503,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075017','Castri di Lecce','Castri di Lecce','','NO','C334',40.2738851,18.2649338,12.7778,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075018','Castrignano de\' Greci','Castrignano de\' Greci','','NO','C335',40.1733798,18.2971130,9.4486,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075019','Castrignano del Capo','Castrignano del Capo','','NO','C336',39.8313438,18.3526581,20.7483,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075020','Cavallino','Cavallino','','NO','C377',40.3153500,18.1945580,22.8459,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075021','Collepasso','Collepasso','','NO','C865',40.0725668,18.1623445,12.7732,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075022','Copertino','Copertino','','NO','C978',40.2751225,18.0461176,59.1577,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075023','Corigliano d\'Otranto','Corigliano d\'Otranto','','NO','D006',40.1590999,18.2578548,28.8332,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075024','Corsano','Corsano','','NO','D044',39.8889147,18.3692398,9.1784,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075025','Cursi','Cursi','','NO','D223',40.1497981,18.3136446,8.6091,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075026','Cutrofiano','Cutrofiano','','NO','D237',40.1271464,18.2083555,56.4702,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075027','Diso','Diso','','NO','D305',40.0080661,18.3873390,11.5931,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075028','Gagliano del Capo','Gagliano del Capo','','NO','D851',39.8453105,18.3726354,16.6639,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075029','Galatina','Galatina','','NO','D862',40.1739095,18.1698200,82.1111,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075030','Galatone','Galatone','','NO','D863',40.1486758,18.0729802,46.9501,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075031','Gallipoli','Gallipoli','','NO','D883',40.0548261,17.9758288,40.4862,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075032','Giuggianello','Giuggianello','','NO','E053',40.0954147,18.3697271,10.5427,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075033','Giurdignano','Giurdignano','','NO','E061',40.1244493,18.4299478,13.8849,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075034','Guagnano','Guagnano','','NO','E227',40.4022601,17.9509569,38.3058,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075035','Lecce','Lecce','','SI','E506',40.3535014,18.1719245,239.1705,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075036','Lequile','Lequile','','NO','E538',40.3072298,18.1413697,36.1811,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075037','Leverano','Leverano','','NO','E563',40.2883060,17.9957065,49.2956,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075038','Lizzanello','Lizzanello','','NO','E629',40.3030443,18.2225937,25.4843,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075039','Maglie','Maglie','','NO','E815',40.1208448,18.2992233,22.6650,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075040','Martano','Martano','','NO','E979',40.2034981,18.3018645,22.2478,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075041','Martignano','Martignano','','NO','E984',40.2390614,18.2575607,6.5841,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075042','Matino','Matino','','NO','F054',40.0323436,18.1339676,26.8512,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075043','Melendugno','Melendugno','','NO','F101',40.2741367,18.3376797,92.3508,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075044','Melissano','Melissano','','NO','F109',39.9734452,18.1249260,12.8680,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075045','Melpignano','Melpignano','','NO','F117',40.1552535,18.2927222,10.7163,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075046','Miggiano','Miggiano','','NO','F194',39.9654726,18.3103429,8.0147,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075047','Minervino di Lecce','Minervino di Lecce','','NO','F221',40.0924299,18.4199397,17.8968,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075048','Monteroni di Lecce','Monteroni di Lecce','','NO','F604',40.3267972,18.0960393,16.7749,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075049','Montesano Salentino','Montesano Salentino','','NO','F623',39.9761655,18.3209211,8.6012,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075050','Morciano di Leuca','Morciano di Leuca','','NO','F716',39.8474616,18.3110932,13.6196,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075051','Muro Leccese','Muro Leccese','','NO','F816',40.1023400,18.3342280,16.5361,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075052','Nardò','Nardò','','NO','F842',40.1760702,18.0311005,193.3802,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075053','Neviano','Neviano','','NO','F881',40.1061504,18.1172053,16.4633,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075054','Nociglia','Nociglia','','NO','F916',40.0372694,18.3280982,10.8630,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075055','Novoli','Novoli','','NO','F970',40.3760160,18.0494984,18.0728,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075056','Ortelle','Ortelle','','NO','G136',40.0333795,18.3914186,10.1984,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075057','Otranto','Otranto','','NO','G188',40.1460239,18.4908325,76.7771,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075058','Palmariggi','Palmariggi','','NO','G285',40.1311621,18.3810448,9.2839,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075059','Parabita','Parabita','','NO','G325',40.0489353,18.1257791,21.0610,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075060','Patù','Patù','','NO','G378',39.8401141,18.3354633,8.8271,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075061','Poggiardo','Poggiardo','','NO','G751',40.0551952,18.3786296,20.0270,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075063','Racale','Racale','','NO','H147',39.9593504,18.0928562,24.2604,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075064','Ruffano','Ruffano','','NO','H632',39.9839146,18.2476415,39.4259,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075065','Salice Salentino','Salice Salentino','','NO','H708',40.3851878,17.9645095,59.3823,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075066','Salve','Salve','','NO','H729',39.8603269,18.2946568,32.6681,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075067','Sanarica','Sanarica','','NO','H757',40.0874740,18.3493898,12.8866,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075068','San Cesario di Lecce','San Cesario di Lecce','','NO','H793',40.3027607,18.1601881,8.2250,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075069','San Donato di Lecce','San Donato di Lecce','','NO','H826',40.2674646,18.1836726,21.6163,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075070','Sannicola','Sannicola','','NO','I059',40.0941287,18.0639448,28.0809,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075071','San Pietro in Lama','San Pietro in Lama','','NO','I115',40.3074606,18.1281132,8.1197,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075072','Santa Cesarea Terme','Santa Cesarea Terme','','NO','I172',40.0380094,18.4627142,26.9848,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075073','Scorrano','Scorrano','','NO','I549',40.0903361,18.2971255,35.4840,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075074','Seclì','Seclì','','NO','I559',40.1313876,18.1048621,8.9450,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075075','Sogliano Cavour','Sogliano Cavour','','NO','I780',40.1469476,18.1976309,5.3327,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075076','Soleto','Soleto','','NO','I800',40.1876558,18.2073851,30.6154,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075077','Specchia','Specchia','','NO','I887',39.9406280,18.2967392,25.0505,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075078','Spongano','Spongano','','NO','I923',40.0133736,18.3653107,12.6908,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075079','Squinzano','Squinzano','','NO','I930',40.4357529,18.0455262,31.3211,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075080','Sternatia','Sternatia','','NO','I950',40.2193906,18.2254956,16.6585,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075081','Supersano','Supersano','','NO','L008',40.0194794,18.2402701,36.5470,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075082','Surano','Surano','','NO','L010',40.0284816,18.3417913,8.9117,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075083','Surbo','Surbo','','NO','L011',40.3967854,18.1332581,20.7808,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075084','Taurisano','Taurisano','','NO','L064',39.9556749,18.2149601,23.8588,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075085','Taviano','Taviano','','NO','L074',39.9826953,18.0887353,22.2116,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075086','Tiggiano','Tiggiano','','NO','L166',39.9026995,18.3648450,7.5875,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075087','Trepuzzi','Trepuzzi','','NO','L383',40.4054317,18.0734638,23.5845,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075088','Tricase','Tricase','','NO','L419',39.9313132,18.3607114,42.9580,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075089','Tuglie','Tuglie','','NO','L462',40.0727446,18.1017697,8.4878,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075090','Ugento','Ugento','','NO','L484',39.9277408,18.1620192,99.8278,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075091','Uggiano la Chiesa','Uggiano la Chiesa','','NO','L485',40.1011477,18.4493313,14.9247,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075092','Veglie','Veglie','','NO','L711',40.3349657,17.9659269,62.5875,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075093','Vernole','Vernole','','NO','L776',40.2887173,18.3026602,61.2303,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075094','Zollino','Zollino','','NO','M187',40.2051100,18.2519054,9.8061,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075095','San Cassiano','San Cassiano','','NO','M264',40.0563869,18.3343662,9.0246,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075096','Castro','Castro','','NO','M261',40.0081838,18.4255237,4.3701,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075097','Porto Cesareo','Porto Cesareo','','NO','M263',40.2617565,17.8995696,34.7360,'075');
INSERT INTO `gi_comuni` VALUES ('LE','075098','Presicce-Acquarica','Presicce-Acquarica','','NO','M428',39.9014042,18.2630342,43.6624,'075');
INSERT INTO `gi_comuni` VALUES ('PZ','076001','Abriola','Abriola','','NO','A013',40.5079571,15.8121142,97.0869,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076002','Acerenza','Acerenza','','NO','A020',40.7954543,15.9417170,77.1447,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076003','Albano di Lucania','Albano di Lucania','','NO','A131',40.5839607,16.0372922,55.9739,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076004','Anzi','Anzi','','NO','A321',40.5162852,15.9247912,76.8848,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076005','Armento','Armento','','NO','A415',40.3059668,16.0655171,58.8226,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076006','Atella','Atella','','NO','A482',40.8773491,15.6527334,88.8245,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076007','Avigliano','Avigliano','','NO','A519',40.7296284,15.7179255,85.3545,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076008','Balvano','Balvano','','NO','A604',40.6511768,15.5120643,42.0191,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076009','Banzi','Banzi','','NO','A612',40.8595056,16.0135059,82.9951,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076010','Baragiano','Baragiano','','NO','A615',40.6819286,15.5915320,29.7458,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076011','Barile','Barile','','NO','A666',40.9460323,15.6735662,24.7160,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076012','Bella','Bella','','NO','A743',40.7603517,15.5395080,99.5003,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076013','Brienza','Brienza','','NO','B173',40.4784468,15.6300219,83.0955,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076014','Brindisi Montagna','Brindisi Montagna','','NO','B181',40.6093331,15.9400080,60.2115,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076015','Calvello','Calvello','','NO','B440',40.4749091,15.8475099,106.0626,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076016','Calvera','Calvera','','NO','B443',40.1480237,16.1442525,16.0459,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076017','Campomaggiore','Campomaggiore','','NO','B549',40.5658541,16.0724600,12.4424,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076018','Cancellara','Cancellara','','NO','B580',40.7306036,15.9252963,42.8012,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076019','Carbone','Carbone','','NO','B743',40.1415757,16.0895417,48.4782,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076020','San Paolo Albanese','San Paolo Albanese','','NO','B906',40.0372266,16.3343124,30.2020,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076021','Castelgrande','Castelgrande','','NO','C120',40.7859512,15.4322035,34.9214,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076022','Castelluccio Inferiore','Castelluccio Inferiore','','NO','C199',40.0053568,15.9767011,28.7657,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076023','Castelluccio Superiore','Castelluccio Superiore','','NO','C201',40.0098359,15.9753165,33.1069,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076024','Castelmezzano','Castelmezzano','','NO','C209',40.5306734,16.0484941,33.7621,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076025','Castelsaraceno','Castelsaraceno','','NO','C271',40.1649557,15.9927147,75.0676,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076026','Castronuovo di Sant\'Andrea','Castronuovo di Sant\'Andrea','','NO','C345',40.1873902,16.1867522,47.4800,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076027','Cersosimo','Cersosimo','','NO','C539',40.0464077,16.3479247,24.9628,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076028','Chiaromonte','Chiaromonte','','NO','C619',40.1242479,16.2150156,70.3229,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076029','Corleto Perticara','Corleto Perticara','','NO','D010',40.3836267,16.0427747,89.8158,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076030','Episcopia','Episcopia','','NO','D414',40.0735437,16.0978459,28.9285,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076031','Fardella','Fardella','','NO','D497',40.1139608,16.1666311,28.8189,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076032','Filiano','Filiano','','NO','D593',40.8093394,15.7068689,72.2036,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076033','Forenza','Forenza','','NO','D696',40.8593146,15.8570724,116.5415,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076034','Francavilla in Sinni','Francavilla in Sinni','','NO','D766',40.0814400,16.2029241,46.6348,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076035','Gallicchio','Gallicchio','','NO','D876',40.2900155,16.1373915,23.6177,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076036','Genzano di Lucania','Genzano di Lucania','','NO','D971',40.8503549,16.0314405,209.3631,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076037','Grumento Nova','Grumento Nova','','NO','E221',40.2860856,15.8903211,66.8838,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076038','Guardia Perticara','Guardia Perticara','','NO','E246',40.3628552,16.0978885,53.8126,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076039','Lagonegro','Lagonegro','','NO','E409',40.1240378,15.7665886,113.1480,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076040','Latronico','Latronico','','NO','E474',40.0881137,16.0102731,76.8565,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076041','Laurenzana','Laurenzana','','NO','E482',40.4590880,15.9722019,95.5866,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076042','Lauria','Lauria','','NO','E483',40.0471476,15.8354683,176.3236,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076043','Lavello','Lavello','','NO','E493',41.0489312,15.8006881,134.7931,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076044','Maratea','Maratea','','NO','E919',39.9929792,15.7230897,67.8617,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076045','Marsico Nuovo','Marsico Nuovo','','NO','E976',40.4194501,15.7333078,100.9750,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076046','Marsicovetere','Marsicovetere','','NO','E977',40.3744184,15.8266215,38.2049,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076047','Maschito','Maschito','','NO','F006',40.9070609,15.8298899,46.1360,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076048','Melfi','Melfi','','NO','F104',40.9943566,15.6529480,206.4465,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076049','Missanello','Missanello','','NO','F249',40.2812771,16.1660062,22.4880,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076050','Moliterno','Moliterno','','NO','F295',40.2419942,15.8688526,98.8456,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076051','Montemilone','Montemilone','','NO','F568',41.0285540,15.9681481,113.7987,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076052','Montemurro','Montemurro','','NO','F573',40.2977426,15.9932379,57.2631,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076053','Muro Lucano','Muro Lucano','','NO','F817',40.7520109,15.4841334,126.5371,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076054','Nemoli','Nemoli','','NO','F866',40.0671821,15.8001714,19.2612,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076055','Noepoli','Noepoli','','NO','F917',40.0870975,16.3280978,46.5572,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076056','Oppido Lucano','Oppido Lucano','','NO','G081',40.7651613,15.9902853,54.3295,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076057','Palazzo San Gervasio','Palazzo San Gervasio','','NO','G261',40.9304787,15.9808300,62.8749,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076058','Pescopagano','Pescopagano','','NO','G496',40.8358208,15.3969029,69.9110,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076059','Picerno','Picerno','','NO','G590',40.6379446,15.6373495,78.5128,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076060','Pietragalla','Pietragalla','','NO','G616',40.7480380,15.8824351,65.7572,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076061','Pietrapertosa','Pietrapertosa','','NO','G623',40.5158626,16.0637859,67.3469,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076062','Pignola','Pignola','','NO','G663',40.5746766,15.7844367,56.3472,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076063','Potenza','Potenza','','SI','G942',40.6394399,15.8050725,175.4401,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076064','Rapolla','Rapolla','','NO','H186',40.9766346,15.6719084,29.1776,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076065','Rapone','Rapone','','NO','H187',40.8466155,15.5003108,29.5199,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076066','Rionero in Vulture','Rionero in Vulture','','NO','H307',40.9257807,15.6731469,53.3074,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076067','Ripacandida','Ripacandida','','NO','H312',40.9109849,15.7236530,33.4281,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076068','Rivello','Rivello','','NO','H348',40.0771356,15.7576841,69.5522,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076069','Roccanova','Roccanova','','NO','H426',40.2141490,16.2050858,61.7922,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076070','Rotonda','Rotonda','','NO','H590',39.9536236,16.0375564,42.7457,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076071','Ruoti','Ruoti','','NO','H641',40.7176309,15.6765604,55.5652,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076072','Ruvo del Monte','Ruvo del Monte','','NO','H646',40.8472012,15.5402513,32.6905,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076073','San Chirico Nuovo','San Chirico Nuovo','','NO','H795',40.6758913,16.0795737,23.6470,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076074','San Chirico Raparo','San Chirico Raparo','','NO','H796',40.1904532,16.0764134,83.6052,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076075','San Costantino Albanese','San Costantino Albanese','','NO','H808',40.0352882,16.3047941,42.9257,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076076','San Fele','San Fele','','NO','H831',40.8206840,15.5402421,96.9293,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076077','San Martino d\'Agri','San Martino d\'Agri','','NO','H994',40.2379626,16.0519594,50.9229,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076078','San Severino Lucano','San Severino Lucano','','NO','I157',40.0206521,16.1392472,61.1062,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076079','Sant\'Angelo Le Fratte','Sant\'Angelo Le Fratte','','NO','I288',40.5462429,15.5590936,22.5145,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076080','Sant\'Arcangelo','Sant\'Arcangelo','','NO','I305',40.2464487,16.2749057,89.4517,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076081','Sarconi','Sarconi','','NO','I426',40.2471835,15.8887521,30.7241,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076082','Sasso di Castalda','Sasso di Castalda','','NO','I457',40.4879239,15.6778314,45.9752,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076083','Satriano di Lucania','Satriano di Lucania','','NO','G614',40.5448519,15.6383190,32.9347,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076084','Savoia di Lucania','Savoia di Lucania','','NO','H730',40.5692831,15.5512943,33.3438,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076085','Senise','Senise','','NO','I610',40.1433283,16.2907211,97.0875,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076086','Spinoso','Spinoso','','NO','I917',40.2678248,15.9667815,38.0141,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076087','Teana','Teana','','NO','L082',40.1259504,16.1539050,19.2479,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076088','Terranova di Pollino','Terranova di Pollino','','NO','L126',39.9767038,16.2982932,113.6373,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076089','Tito','Tito','','NO','L181',40.5825160,15.6767029,70.6956,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076090','Tolve','Tolve','','NO','L197',40.6961628,16.0193070,128.3617,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076091','Tramutola','Tramutola','','NO','L326',40.3148139,15.7904093,36.3739,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076092','Trecchina','Trecchina','','NO','L357',40.0264084,15.7778677,38.2846,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076093','Trivigno','Trivigno','','NO','L439',40.5802499,15.9888326,26.1445,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076094','Vaglio Basilicata','Vaglio Basilicata','','NO','L532',40.6657376,15.9200005,43.3880,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076095','Venosa','Venosa','','NO','L738',40.9645011,15.8230782,169.7335,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076096','Vietri di Potenza','Vietri di Potenza','','NO','L859',40.5983566,15.5076167,52.0774,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076097','Viggianello','Viggianello','','NO','L873',39.9725349,16.0849109,121.2528,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076098','Viggiano','Viggiano','','NO','L874',40.3399413,15.9018106,89.6985,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076099','Ginestra','Ginestra','','NO','E033',40.9312388,15.7333532,13.3482,'076');
INSERT INTO `gi_comuni` VALUES ('PZ','076100','Paterno','Paterno','','NO','M269',40.3769731,15.7320519,40.5480,'076');
INSERT INTO `gi_comuni` VALUES ('MT','077001','Accettura','Accettura','','NO','A017',40.4914864,16.1574102,90.4896,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077002','Aliano','Aliano','','NO','A196',40.3111913,16.2320406,98.3158,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077003','Bernalda','Bernalda','','NO','A801',40.4083092,16.6858517,125.3390,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077004','Calciano','Calciano','','NO','B391',40.5873776,16.1899238,49.3118,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077005','Cirigliano','Cirigliano','','NO','C723',40.3944980,16.1726557,14.9081,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077006','Colobraro','Colobraro','','NO','C888',40.1876354,16.4229581,66.0596,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077007','Craco','Craco','','NO','D128',40.3588525,16.4955431,77.2693,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077008','Ferrandina','Ferrandina','','NO','D547',40.4928517,16.4567912,217.9072,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077009','Garaguso','Garaguso','','NO','D909',40.5489471,16.2279736,38.8026,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077010','Gorgoglione','Gorgoglione','','NO','E093',40.3946017,16.1430767,34.6054,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077011','Grassano','Grassano','','NO','E147',40.6331659,16.2841518,41.5848,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077012','Grottole','Grottole','','NO','E213',40.6011245,16.3839534,116.8302,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077013','Irsina','Irsina','','NO','E326',40.7458339,16.2424783,264.2826,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077014','Matera','Matera','','SI','F052',40.6665696,16.6003782,393.2128,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077015','Miglionico','Miglionico','','NO','F201',40.5666430,16.5013821,88.6961,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077016','Montalbano Jonico','Montalbano Jonico','','NO','F399',40.2879472,16.5688645,135.5174,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077017','Montescaglioso','Montescaglioso','','NO','F637',40.5575121,16.6642492,175.6004,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077018','Nova Siri','Nova Siri','','NO','A942',40.1469488,16.5387989,52.3127,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077019','Oliveto Lucano','Oliveto Lucano','','NO','G037',40.5355375,16.1854856,31.0811,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077020','Pisticci','Pisticci','','NO','G712',40.3906439,16.5586462,234.9038,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077021','Policoro','Policoro','','NO','G786',40.2086976,16.6690809,67.7199,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077022','Pomarico','Pomarico','','NO','G806',40.5175492,16.5468922,129.8227,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077023','Rotondella','Rotondella','','NO','H591',40.1726344,16.5256667,76.6040,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077024','Salandra','Salandra','','NO','H687',40.5254607,16.3196746,77.4536,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077025','San Giorgio Lucano','San Giorgio Lucano','','NO','H888',40.1131596,16.3894120,39.4072,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077026','San Mauro Forte','San Mauro Forte','','NO','I029',40.4871609,16.2526900,87.2045,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077027','Stigliano','Stigliano','','NO','I954',40.4022207,16.2283702,211.1887,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077028','Tricarico','Tricarico','','NO','L418',40.6187894,16.1419886,178.0564,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077029','Tursi','Tursi','','NO','L477',40.2461016,16.4686050,160.2664,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077030','Valsinni','Valsinni','','NO','D513',40.1705995,16.4419838,32.2677,'077');
INSERT INTO `gi_comuni` VALUES ('MT','077031','Scanzano Jonico','Scanzano Jonico','','NO','M256',40.2502969,16.6909318,72.1191,'077');
INSERT INTO `gi_comuni` VALUES ('CS','078001','Acquaformosa','Acquaformosa','','NO','A033',39.7248037,16.0926766,22.5758,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078002','Acquappesa','Acquappesa','','NO','A041',39.4945573,15.9541238,14.8667,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078003','Acri','Acri','','NO','A053',39.4882853,16.3815795,200.1480,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078004','Aiello Calabro','Aiello Calabro','','NO','A102',39.1172831,16.1674619,38.3603,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078005','Aieta','Aieta','','NO','A105',39.9287312,15.8234411,48.0529,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078006','Albidona','Albidona','','NO','A160',39.9239252,16.4699721,64.9254,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078007','Alessandria del Carretto','Alessandria del Carretto','','NO','A183',39.9589202,16.3798073,41.3471,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078008','Altilia','Altilia','','NO','A234',39.1330677,16.2442056,10.7367,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078009','Altomonte','Altomonte','','NO','A240',39.6983785,16.1278902,65.9032,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078010','Amantea','Amantea','','NO','A253',39.1362632,16.0759069,29.4893,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078011','Amendolara','Amendolara','','NO','A263',39.9507040,16.5848561,60.4679,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078012','Aprigliano','Aprigliano','','NO','A340',39.2398883,16.3405837,121.9632,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078013','Belmonte Calabro','Belmonte Calabro','','NO','A762',39.1612212,16.0793013,23.5608,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078014','Belsito','Belsito','','NO','A768',39.1738901,16.2872576,11.4187,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078015','Belvedere Marittimo','Belvedere Marittimo','','NO','A773',39.6180467,15.8625305,37.2693,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078016','Bianchi','Bianchi','','NO','A842',39.1007611,16.4111430,32.9857,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078017','Bisignano','Bisignano','','NO','A887',39.5134255,16.2868148,86.0214,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078018','Bocchigliero','Bocchigliero','','NO','A912',39.4180260,16.7551387,98.8888,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078019','Bonifati','Bonifati','','NO','A973',39.5853794,15.8988839,33.4602,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078020','Buonvicino','Buonvicino','','NO','B270',39.6906566,15.8825065,30.5559,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078021','Calopezzati','Calopezzati','','NO','B424',39.5623161,16.8051651,22.3665,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078022','Caloveto','Caloveto','','NO','B426',39.5058265,16.7591729,24.8754,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078023','Campana','Campana','','NO','B500',39.4088052,16.8275509,104.6790,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078024','Canna','Canna','','NO','B607',40.0946949,16.5052741,20.0190,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078025','Cariati','Cariati','','NO','B774',39.4957422,16.9478750,28.9334,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078026','Carolei','Carolei','','NO','B802',39.2532360,16.2185817,15.5480,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078027','Carpanzano','Carpanzano','','NO','B813',39.1476772,16.3045585,13.9967,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078029','Cassano all\'Ionio','Cassano all\'Ionio','','NO','C002',39.7831027,16.3188368,159.0199,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078030','Castiglione Cosentino','Castiglione Cosentino','','NO','C301',39.3515198,16.2876435,14.2462,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078031','Castrolibero','Castrolibero','','NO','C108',39.3077096,16.1939873,11.6797,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078032','Castroregio','Castroregio','','NO','C348',39.9932090,16.4780039,41.2053,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078033','Castrovillari','Castrovillari','','NO','C349',39.8115656,16.2025143,130.2778,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078034','Celico','Celico','','NO','C430',39.3087250,16.3391339,100.2901,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078035','Cellara','Cellara','','NO','C437',39.2182545,16.3369305,5.7922,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078036','Cerchiara di Calabria','Cerchiara di Calabria','','NO','C489',39.8589051,16.3817116,81.6537,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078037','Cerisano','Cerisano','','NO','C515',39.2741531,16.1775875,15.3549,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078038','Cervicati','Cervicati','','NO','C554',39.5426000,16.1272748,12.1378,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078039','Cerzeto','Cerzeto','','NO','C560',39.5084756,16.1152436,21.8737,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078040','Cetraro','Cetraro','','NO','C588',39.5152774,15.9421631,65.9660,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078041','Civita','Civita','','NO','C763',39.8273167,16.3128944,27.9418,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078042','Cleto','Cleto','','NO','C795',39.0890623,16.1590956,19.1535,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078043','Colosimi','Colosimi','','NO','C905',39.1188047,16.3999270,25.6935,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078045','Cosenza','Cosenza','','SI','D086',39.2931743,16.2562466,37.8240,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078046','Cropalati','Cropalati','','NO','D180',39.5155667,16.7260731,33.8070,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078047','Crosia','Crosia','','NO','D184',39.5695729,16.7710744,21.2282,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078048','Diamante','Diamante','','NO','D289',39.6762246,15.8218326,12.1844,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078049','Dipignano','Dipignano','','NO','D304',39.2377043,16.2532632,23.2040,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078050','Domanico','Domanico','','NO','D328',39.2183463,16.2053078,23.8744,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078051','Fagnano Castello','Fagnano Castello','','NO','D464',39.5619928,16.0545134,29.6389,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078052','Falconara Albanese','Falconara Albanese','','NO','D473',39.2745889,16.0887080,19.4547,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078053','Figline Vegliaturo','Figline Vegliaturo','','NO','D582',39.2265517,16.3303338,4.0792,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078054','Firmo','Firmo','','NO','D614',39.7226823,16.1771810,11.7940,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078055','Fiumefreddo Bruzio','Fiumefreddo Bruzio','','NO','D624',39.2359267,16.0651702,31.9031,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078056','Francavilla Marittima','Francavilla Marittima','','NO','D764',39.8201328,16.3882951,32.7312,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078057','Frascineto','Frascineto','','NO','D774',39.8355384,16.2649508,28.9580,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078058','Fuscaldo','Fuscaldo','','NO','D828',39.4157761,16.0305417,60.8654,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078059','Grimaldi','Grimaldi','','NO','E180',39.1418168,16.2342267,24.5937,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078060','Grisolia','Grisolia','','NO','E185',39.7244846,15.8523326,51.8824,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078061','Guardia Piemontese','Guardia Piemontese','','NO','E242',39.4641026,15.9982188,21.5862,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078062','Lago','Lago','','NO','E407',39.1663721,16.1489039,50.0311,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078063','Laino Borgo','Laino Borgo','','NO','E417',39.9519284,15.9732478,56.9429,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078064','Laino Castello','Laino Castello','','NO','E419',39.9362945,15.9778421,37.2902,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078065','Lappano','Lappano','','NO','E450',39.3197141,16.3113094,12.1636,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078066','Lattarico','Lattarico','','NO','E475',39.4625403,16.1375604,43.8219,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078067','Longobardi','Longobardi','','NO','E677',39.2068181,16.0766496,18.4741,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078068','Longobucco','Longobucco','','NO','E678',39.4484731,16.6095561,212.3009,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078069','Lungro','Lungro','','NO','E745',39.7417322,16.1232889,35.7053,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078070','Luzzi','Luzzi','','NO','E773',39.4459568,16.2873464,77.6059,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078071','Maierà','Maierà','','NO','E835',39.7155106,15.8506195,17.7193,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078072','Malito','Malito','','NO','E859',39.1556079,16.2480932,16.7249,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078073','Malvito','Malvito','','NO','E872',39.5981557,16.0527619,38.2900,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078074','Mandatoriccio','Mandatoriccio','','NO','E878',39.4682418,16.8363255,37.1045,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078075','Mangone','Mangone','','NO','E888',39.2038346,16.3340461,12.6869,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078076','Marano Marchesato','Marano Marchesato','','NO','E914',39.3132019,16.1720428,5.0948,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078077','Marano Principato','Marano Principato','','NO','E915',39.2989812,16.1737372,6.2776,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078078','Marzi','Marzi','','NO','F001',39.1703010,16.3059928,15.8101,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078079','Mendicino','Mendicino','','NO','F125',39.2590904,16.1931805,35.2103,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078080','Mongrassano','Mongrassano','','NO','F370',39.5259442,16.1113403,34.9407,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078081','Montalto Uffugo','Montalto Uffugo','','NO','F416',39.4049504,16.1580887,76.4253,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078082','Montegiordano','Montegiordano','','NO','F519',40.0443256,16.5313608,35.9898,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078083','Morano Calabro','Morano Calabro','','NO','F708',39.8419618,16.1361031,115.8306,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078084','Mormanno','Mormanno','','NO','F735',39.8897190,15.9876875,79.1958,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078085','Mottafollone','Mottafollone','','NO','F775',39.6482476,16.0657989,31.7215,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078086','Nocara','Nocara','','NO','F907',40.1000493,16.4809948,34.2152,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078087','Oriolo','Oriolo','','NO','G110',40.0528258,16.4443265,86.1078,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078088','Orsomarso','Orsomarso','','NO','G129',39.8016634,15.9106050,90.3499,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078089','Paludi','Paludi','','NO','G298',39.5292409,16.6808786,41.6100,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078090','Panettieri','Panettieri','','NO','G307',39.0591871,16.4534562,15.0471,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078091','Paola','Paola','','NO','G317',39.3615342,16.0425040,42.8485,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078092','Papasidero','Papasidero','','NO','G320',39.8715022,15.9050614,55.6065,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078093','Parenti','Parenti','','NO','G331',39.1636464,16.4101110,37.5278,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078094','Paterno Calabro','Paterno Calabro','','NO','G372',39.2252190,16.2630841,24.3860,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078096','Pedivigliano','Pedivigliano','','NO','G411',39.1102047,16.3042204,16.7354,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078097','Piane Crati','Piane Crati','','NO','G553',39.2346786,16.3230465,2.3525,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078098','Pietrafitta','Pietrafitta','','NO','G615',39.2609451,16.3384391,9.4599,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078099','Pietrapaola','Pietrapaola','','NO','G622',39.4892464,16.8155760,52.9651,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078100','Plataci','Plataci','','NO','G733',39.8997000,16.4306188,49.5705,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078101','Praia a Mare','Praia a Mare','','NO','G975',39.8967135,15.7796770,23.7027,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078102','Rende','Rende','','NO','H235',39.3472643,16.2434615,55.4385,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078103','Rocca Imperiale','Rocca Imperiale','','NO','H416',40.1109948,16.5742032,55.5510,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078104','Roggiano Gravina','Roggiano Gravina','','NO','H488',39.6161718,16.1580292,44.8787,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078105','Rogliano','Rogliano','','NO','H490',39.1785721,16.3237627,42.0042,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078106','Rose','Rose','','NO','H565',39.3981949,16.2877951,47.4767,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078107','Roseto Capo Spulico','Roseto Capo Spulico','','NO','H572',39.9867558,16.6006653,30.6661,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078109','Rota Greca','Rota Greca','','NO','H585',39.4709530,16.1123331,12.9952,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078110','Rovito','Rovito','','NO','H621',39.3090980,16.3181625,10.7266,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078111','San Basile','San Basile','','NO','H765',39.8091467,16.1642835,19.1778,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078112','San Benedetto Ullano','San Benedetto Ullano','','NO','H774',39.4260537,16.1237008,19.6235,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078113','San Cosmo Albanese','San Cosmo Albanese','','NO','H806',39.5813151,16.4199386,11.7545,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078114','San Demetrio Corone','San Demetrio Corone','','NO','H818',39.5675929,16.3631827,62.0016,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078115','San Donato di Ninea','San Donato di Ninea','','NO','H825',39.7078583,16.0460622,82.0541,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078116','San Fili','San Fili','','NO','H841',39.3398909,16.1461440,20.8857,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078117','Sangineto','Sangineto','','NO','H877',39.6050666,15.9125859,27.6421,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078118','San Giorgio Albanese','San Giorgio Albanese','','NO','H881',39.5818330,16.4539247,22.4879,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078119','San Giovanni in Fiore','San Giovanni in Fiore','','NO','H919',39.2536506,16.6979715,282.6299,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078120','San Lorenzo Bellizzi','San Lorenzo Bellizzi','','NO','H961',39.8893564,16.3286002,40.3841,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078121','San Lorenzo del Vallo','San Lorenzo del Vallo','','NO','H962',39.6657306,16.2938842,23.0013,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078122','San Lucido','San Lucido','','NO','H971',39.3090455,16.0503126,27.0212,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078123','San Marco Argentano','San Marco Argentano','','NO','H981',39.5566983,16.1183363,80.3382,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078124','San Martino di Finita','San Martino di Finita','','NO','H992',39.4908003,16.1074632,24.0164,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078125','San Nicola Arcella','San Nicola Arcella','','NO','I060',39.8460680,15.7930222,11.7099,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078126','San Pietro in Amantea','San Pietro in Amantea','','NO','I108',39.1376441,16.1118668,9.5460,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078127','San Pietro in Guarano','San Pietro in Guarano','','NO','I114',39.3412037,16.3108806,48.3825,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078128','San Sosti','San Sosti','','NO','I165',39.6603141,16.0270921,43.3509,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078129','Santa Caterina Albanese','Santa Caterina Albanese','','NO','I171',39.5857029,16.0693982,17.4723,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078130','Santa Domenica Talao','Santa Domenica Talao','','NO','I183',39.8192687,15.8566303,36.1679,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078131','Sant\'Agata di Esaro','Sant\'Agata di Esaro','','NO','I192',39.6207460,15.9840664,47.3119,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078132','Santa Maria del Cedro','Santa Maria del Cedro','','NO','C717',39.7488660,15.8363084,18.3256,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078133','Santa Sofia d\'Epiro','Santa Sofia d\'Epiro','','NO','I309',39.5457939,16.3291296,39.3496,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078134','Santo Stefano di Rogliano','Santo Stefano di Rogliano','','NO','I359',39.1942708,16.3244324,19.1938,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078135','San Vincenzo La Costa','San Vincenzo La Costa','','NO','I388',39.3646944,16.1509595,18.5337,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078136','Saracena','Saracena','','NO','I423',39.7755978,16.1561803,109.3610,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078137','Scala Coeli','Scala Coeli','','NO','I485',39.4476441,16.8896851,67.6000,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078138','Scalea','Scalea','','NO','I489',39.8071019,15.7907032,22.4979,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078139','Scigliano','Scigliano','','NO','D290',39.1262879,16.3055550,17.7455,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078140','Serra d\'Aiello','Serra d\'Aiello','','NO','I642',39.0904195,16.1274864,4.7026,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078142','Spezzano Albanese','Spezzano Albanese','','NO','I895',39.6715655,16.3091613,32.1335,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078143','Spezzano della Sila','Spezzano della Sila','','NO','I896',39.3035030,16.3371445,79.9523,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078145','Tarsia','Tarsia','','NO','L055',39.6183919,16.2716383,48.1925,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078146','Terranova da Sibari','Terranova da Sibari','','NO','L124',39.6577730,16.3425875,43.1796,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078147','Terravecchia','Terravecchia','','NO','L134',39.4660802,16.9443910,20.2400,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078148','Torano Castello','Torano Castello','','NO','L206',39.5045160,16.1435726,30.3567,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078149','Tortora','Tortora','','NO','L305',39.9424908,15.8056095,57.7379,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078150','Trebisacce','Trebisacce','','NO','L353',39.8666427,16.5299465,26.7478,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078152','Vaccarizzo Albanese','Vaccarizzo Albanese','','NO','L524',39.5867838,16.4329576,8.6994,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078153','Verbicaro','Verbicaro','','NO','L747',39.7554374,15.9122955,32.3145,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078154','Villapiana','Villapiana','','NO','B903',39.8473963,16.4555597,39.9481,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078155','Zumpano','Zumpano','','NO','M202',39.3108451,16.2912485,8.2010,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078156','Casali del Manco','Casali del Manco','','NO','M385',39.2829030,16.3318391,168.4382,'078');
INSERT INTO `gi_comuni` VALUES ('CS','078157','Corigliano-Rossano','Corigliano-Rossano','','NO','M403',39.5988740,16.5191154,346.4314,'078');
INSERT INTO `gi_comuni` VALUES ('CZ','079002','Albi','Albi','','NO','A155',39.0249745,16.5954261,29.8050,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079003','Amaroni','Amaroni','','NO','A255',38.7935304,16.4483817,9.7879,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079004','Amato','Amato','','NO','A257',38.9423061,16.4616748,21.0001,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079005','Andali','Andali','','NO','A272',39.0136240,16.7697741,17.8440,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079007','Argusto','Argusto','','NO','A397',38.6812468,16.4358663,6.8556,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079008','Badolato','Badolato','','NO','A542',38.5681969,16.5259400,37.2033,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079009','Belcastro','Belcastro','','NO','A736',39.0172448,16.7846736,53.5871,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079011','Borgia','Borgia','','NO','B002',38.8267110,16.5093976,42.6029,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079012','Botricello','Botricello','','NO','B085',38.9343054,16.8550338,15.2656,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079017','Caraffa di Catanzaro','Caraffa di Catanzaro','','NO','B717',38.8806772,16.4880199,24.9006,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079018','Cardinale','Cardinale','','NO','B758',38.6431713,16.3879200,30.3650,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079020','Carlopoli','Carlopoli','','NO','B790',39.0556157,16.4545574,16.5227,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079023','Catanzaro','Catanzaro','','SI','C352',38.9049750,16.5953967,111.9368,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079024','Cenadi','Cenadi','','NO','C453',38.7189549,16.4155041,11.9541,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079025','Centrache','Centrache','','NO','C472',38.7294064,16.4301654,8.2865,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079027','Cerva','Cerva','','NO','C542',39.0186216,16.7427970,21.8267,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079029','Chiaravalle Centrale','Chiaravalle Centrale','','NO','C616',38.6841027,16.4141265,23.6818,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079030','Cicala','Cicala','','NO','C674',39.0220011,16.4869766,9.2683,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079033','Conflenti','Conflenti','','NO','C960',39.0701653,16.2889843,29.3194,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079034','Cortale','Cortale','','NO','D049',38.8390481,16.4102252,29.9848,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079036','Cropani','Cropani','','NO','D181',38.9690839,16.7812390,44.9240,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079039','Curinga','Curinga','','NO','D218',38.8279986,16.3169645,52.6508,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079042','Davoli','Davoli','','NO','D257',38.6483640,16.4877257,24.8921,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079043','Decollatura','Decollatura','','NO','D261',39.0467225,16.3562012,50.8308,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079047','Falerna','Falerna','','NO','D476',39.0025638,16.1678934,24.2919,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079048','Feroleto Antico','Feroleto Antico','','NO','D544',38.9621048,16.3882412,22.5896,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079052','Fossato Serralta','Fossato Serralta','','NO','D744',38.9967844,16.5784077,11.7939,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079055','Gagliato','Gagliato','','NO','D852',38.6767734,16.4627630,7.2782,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079056','Gasperina','Gasperina','','NO','D932',38.7389527,16.5093068,6.5777,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079058','Gimigliano','Gimigliano','','NO','E031',38.9753673,16.5291252,33.4406,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079059','Girifalco','Girifalco','','NO','E050',38.8218272,16.4249837,43.2090,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079060','Gizzeria','Gizzeria','','NO','E068',38.9793107,16.2083563,37.1906,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079061','Guardavalle','Guardavalle','','NO','E239',38.5055726,16.5062257,60.4795,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079063','Isca sullo Ionio','Isca sullo Ionio','','NO','E328',38.6006511,16.5196552,23.5163,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079065','Jacurso','Jacurso','','NO','E274',38.8465628,16.3785443,21.1841,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079068','Magisano','Magisano','','NO','E806',39.0134893,16.6269478,31.9639,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079069','Maida','Maida','','NO','E834',38.8603337,16.3598580,58.0658,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079071','Marcedusa','Marcedusa','','NO','E923',39.0271555,16.8359383,15.5899,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079072','Marcellinara','Marcellinara','','NO','E925',38.9270918,16.4912615,20.9994,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079073','Martirano','Martirano','','NO','E990',39.0821344,16.2483402,15.1278,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079074','Martirano Lombardo','Martirano Lombardo','','NO','E991',39.0757460,16.2311608,19.8511,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079077','Miglierina','Miglierina','','NO','F200',38.9474789,16.4724806,13.9155,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079080','Montauro','Montauro','','NO','F432',38.7489855,16.5108797,11.8815,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079081','Montepaone','Montepaone','','NO','F586',38.7222588,16.4970878,16.6771,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079083','Motta Santa Lucia','Motta Santa Lucia','','NO','F780',39.0915054,16.2900495,26.0187,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079087','Nocera Terinese','Nocera Terinese','','NO','F910',39.0370001,16.1644969,46.0332,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079088','Olivadi','Olivadi','','NO','G034',38.7251454,16.4244571,6.7962,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079089','Palermiti','Palermiti','','NO','G272',38.7499084,16.4536816,18.5083,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079092','Pentone','Pentone','','NO','G439',38.9850144,16.5818345,12.4334,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079094','Petrizzi','Petrizzi','','NO','G517',38.7007447,16.4739675,21.6151,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079095','Petronà','Petronà','','NO','G518',39.0408363,16.7567518,46.1571,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079096','Pianopoli','Pianopoli','','NO','D546',38.9535280,16.3895559,24.7721,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079099','Platania','Platania','','NO','G734',39.0043514,16.3186074,26.9834,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079108','San Floro','San Floro','','NO','H846',38.8374238,16.5189301,18.2606,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079110','San Mango d\'Aquino','San Mango d\'Aquino','','NO','H976',39.0591310,16.1901404,6.7348,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079114','San Pietro a Maida','San Pietro a Maida','','NO','I093',38.8478107,16.3474143,16.6264,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079115','San Pietro Apostolo','San Pietro Apostolo','','NO','I095',39.0044540,16.4692247,11.5161,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079116','San Sostene','San Sostene','','NO','I164',38.6376027,16.4857933,32.5346,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079117','Santa Caterina dello Ionio','Santa Caterina dello Ionio','','NO','I170',38.5334334,16.5208870,40.5305,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079118','Sant\'Andrea Apostolo dello Ionio','Sant\'Andrea Apostolo dello Ionio','','NO','I266',38.6231133,16.5286130,21.4295,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079122','San Vito sullo Ionio','San Vito sullo Ionio','','NO','I393',38.7105011,16.4071637,17.2777,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079123','Satriano','Satriano','','NO','I463',38.6685722,16.4835921,21.1428,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079126','Sellia','Sellia','','NO','I589',38.9841504,16.6253579,12.8733,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079127','Sellia Marina','Sellia Marina','','NO','I590',38.9058344,16.7440541,41.4631,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079129','Serrastretta','Serrastretta','','NO','I655',39.0124695,16.4161752,41.4950,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079130','Sersale','Sersale','','NO','I671',39.0114684,16.7261266,52.4176,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079131','Settingiano','Settingiano','','NO','I704',38.9113544,16.5145814,14.5076,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079133','Simeri Crichi','Simeri Crichi','','NO','I745',38.9551194,16.6401212,47.1328,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079134','Sorbo San Basile','Sorbo San Basile','','NO','I844',39.0186917,16.5691242,59.4605,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079137','Soverato','Soverato','','NO','I872',38.6878923,16.5498050,8.0801,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079138','Soveria Mannelli','Soveria Mannelli','','NO','I874',39.0839953,16.3733798,20.6765,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079139','Soveria Simeri','Soveria Simeri','','NO','I875',38.9462213,16.6804078,22.3590,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079142','Squillace','Squillace','','NO','I929',38.7804193,16.5201143,34.4086,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079143','Stalettì','Stalettì','','NO','I937',38.7655011,16.5403520,12.1736,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079146','Taverna','Taverna','','NO','L070',39.0197726,16.5821610,132.0427,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079147','Tiriolo','Tiriolo','','NO','L177',38.9474513,16.5095803,28.9963,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079148','Torre di Ruggiero','Torre di Ruggiero','','NO','L240',38.6515486,16.3722861,25.3228,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079151','Vallefiorita','Vallefiorita','','NO','I322',38.7758332,16.4601873,13.8462,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079157','Zagarise','Zagarise','','NO','M140',38.9992449,16.6603057,49.5668,'079');
INSERT INTO `gi_comuni` VALUES ('CZ','079160','Lamezia Terme','Lamezia Terme','','NO','M208',38.9602848,16.2953181,162.3507,'079');
INSERT INTO `gi_comuni` VALUES ('RC','080001','Africo','Africo','','NO','A065',38.0511934,16.1345363,53.5032,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080002','Agnana Calabra','Agnana Calabra','','NO','A077',38.3022988,16.2250342,8.6782,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080003','Anoia','Anoia','','NO','A303',38.4360424,16.0805725,10.4814,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080004','Antonimina','Antonimina','','NO','A314',38.2717845,16.1485756,22.9983,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080005','Ardore','Ardore','','NO','A385',38.1765771,16.2035695,32.6669,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080006','Bagaladi','Bagaladi','','NO','A544',38.0249222,15.8206102,30.4324,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080007','Bagnara Calabra','Bagnara Calabra','','NO','A552',38.2879012,15.8042612,24.9337,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080008','Benestare','Benestare','','NO','A780',38.1855851,16.1400529,18.4604,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080009','Bianco','Bianco','','NO','A843',38.0889656,16.1489125,30.1498,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080010','Bivongi','Bivongi','','NO','A897',38.4816874,16.4527106,25.6069,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080011','Bova','Bova','','NO','B097',37.9942787,15.9329542,47.7635,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080012','Bovalino','Bovalino','','NO','B098',38.1483459,16.1773615,18.1228,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080013','Bova Marina','Bova Marina','','NO','B099',37.9311997,15.9213885,29.1665,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080014','Brancaleone','Brancaleone','','NO','B118',37.9666782,16.1027518,36.0286,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080015','Bruzzano Zeffirio','Bruzzano Zeffirio','','NO','B234',38.0127086,16.0834153,20.6726,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080016','Calanna','Calanna','','NO','B379',38.1842804,15.7241309,11.0049,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080017','Camini','Camini','','NO','B481',38.4320784,16.4813450,17.2949,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080018','Campo Calabro','Campo Calabro','','NO','B516',38.2140996,15.6589648,7.8517,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080019','Candidoni','Candidoni','','NO','B591',38.5049049,16.0857435,27.1874,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080020','Canolo','Canolo','','NO','B617',38.3145715,16.2004776,28.1266,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080021','Caraffa del Bianco','Caraffa del Bianco','','NO','B718',38.0916850,16.0852360,11.4314,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080022','Cardeto','Cardeto','','NO','B756',38.0845989,15.7659707,36.9529,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080023','Careri','Careri','','NO','B766',38.1762904,16.1143059,38.6453,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080024','Casignana','Casignana','','NO','B966',38.1020152,16.0885204,24.2607,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080025','Caulonia','Caulonia','','NO','C285',38.3826963,16.4109212,101.9227,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080026','Ciminà','Ciminà','','NO','C695',38.2461817,16.1402380,49.4785,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080027','Cinquefrondi','Cinquefrondi','','NO','C710',38.4158820,16.0972702,29.7538,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080028','Cittanova','Cittanova','','NO','C747',38.3555374,16.0803750,61.7304,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080029','Condofuri','Condofuri','','NO','C954',38.0031930,15.8575186,60.5965,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080030','Cosoleto','Cosoleto','','NO','D089',38.2754214,15.9285741,34.4167,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080031','Delianuova','Delianuova','','NO','D268',38.2367933,15.9188680,21.4652,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080032','Feroleto della Chiesa','Feroleto della Chiesa','','NO','D545',38.4664026,16.0668546,7.7313,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080033','Ferruzzano','Ferruzzano','','NO','D557',38.0185107,16.1326460,19.0923,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080034','Fiumara','Fiumara','','NO','D619',38.2108116,15.6921461,6.6338,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080035','Galatro','Galatro','','NO','D864',38.4594224,16.1083842,51.1467,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080036','Gerace','Gerace','','NO','D975',38.2709665,16.2195217,28.7482,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080037','Giffone','Giffone','','NO','E025',38.4390837,16.1486254,14.7710,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080038','Gioia Tauro','Gioia Tauro','','NO','E041',38.4306222,15.8962820,37.9197,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080039','Gioiosa Ionica','Gioiosa Ionica','','NO','E044',38.3366083,16.3024263,36.5001,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080040','Grotteria','Grotteria','','NO','E212',38.3681436,16.2654113,38.0774,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080041','Laganadi','Laganadi','','NO','E402',38.1744881,15.7419961,8.2653,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080042','Laureana di Borrello','Laureana di Borrello','','NO','E479',38.4903786,16.0815441,35.2262,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080043','Locri','Locri','','NO','D976',38.2366405,16.2640514,25.8834,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080044','Mammola','Mammola','','NO','E873',38.3615904,16.2395092,81.0486,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080045','Marina di Gioiosa Ionica','Marina di Gioiosa Ionica','','NO','E956',38.3010435,16.3297455,15.9322,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080046','Maropati','Maropati','','NO','E968',38.4404754,16.0993456,10.4281,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080047','Martone','Martone','','NO','E993',38.3522252,16.2874621,8.2426,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080048','Melicuccà','Melicuccà','','NO','F105',38.3045126,15.8819695,17.5025,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080049','Melicucco','Melicucco','','NO','F106',38.4336336,16.0603687,6.5721,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080050','Melito di Porto Salvo','Melito di Porto Salvo','','NO','F112',37.9207094,15.7842149,35.2248,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080051','Molochio','Molochio','','NO','F301',38.3085749,16.0327740,37.4465,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080052','Monasterace','Monasterace','','NO','F324',38.4386490,16.5759211,15.8823,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080053','Montebello Jonico','Montebello Jonico','','NO','D746',37.9808389,15.7586522,56.6149,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080054','Motta San Giovanni','Motta San Giovanni','','NO','F779',38.0015510,15.6981118,46.2215,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080055','Oppido Mamertina','Oppido Mamertina','','NO','G082',38.2913301,15.9843755,59.0498,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080056','Palizzi','Palizzi','','NO','G277',37.9192211,15.9833127,52.6362,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080057','Palmi','Palmi','','NO','G288',38.3587791,15.8491639,32.1345,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080058','Pazzano','Pazzano','','NO','G394',38.4756639,16.4522824,15.5827,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080059','Placanica','Placanica','','NO','G729',38.4125296,16.4510739,29.4486,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080060','Platì','Platì','','NO','G735',38.2200915,16.0439532,50.7152,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080061','Polistena','Polistena','','NO','G791',38.4079272,16.0773759,11.5672,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080062','Portigliola','Portigliola','','NO','G905',38.2273990,16.2022260,5.9984,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080063','Reggio di Calabria','Reggio di Calabria','','SI','H224',38.1091169,15.6444474,239.3686,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080064','Riace','Riace','','NO','H265',38.4185247,16.4806287,16.2251,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080065','Rizziconi','Rizziconi','','NO','H359',38.4117719,15.9587429,40.5097,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080066','Roccaforte del Greco','Roccaforte del Greco','','NO','H408',38.0443400,15.9012492,44.0669,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080067','Roccella Ionica','Roccella Ionica','','NO','H456',38.3241232,16.4036447,38.0472,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080068','Roghudi','Roghudi','','NO','H489',37.9256473,15.7666409,46.7005,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080069','Rosarno','Rosarno','','NO','H558',38.4878556,15.9829365,39.5298,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080070','Samo','Samo','','NO','H013',38.0742081,16.0570186,50.1924,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080071','San Giorgio Morgeto','San Giorgio Morgeto','','NO','H889',38.3869302,16.1036197,35.4919,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080072','San Giovanni di Gerace','San Giovanni di Gerace','','NO','H903',38.3662164,16.2777569,13.4189,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080073','San Lorenzo','San Lorenzo','','NO','H959',38.0108196,15.8324529,64.2024,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080074','San Luca','San Luca','','NO','H970',38.1485579,16.0642381,105.0046,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080075','San Pietro di Caridà','San Pietro di Caridà','','NO','I102',38.5247950,16.1328645,48.0026,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080076','San Procopio','San Procopio','','NO','I132',38.2812909,15.8892528,11.3339,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080077','San Roberto','San Roberto','','NO','I139',38.2118104,15.7360269,34.7049,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080078','Santa Cristina d\'Aspromonte','Santa Cristina d\'Aspromonte','','NO','I176',38.2530090,15.9698769,23.1803,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080079','Sant\'Agata del Bianco','Sant\'Agata del Bianco','','NO','I198',38.0938040,16.0826591,20.4290,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080080','Sant\'Alessio in Aspromonte','Sant\'Alessio in Aspromonte','','NO','I214',38.1730585,15.7583950,3.9822,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080081','Sant\'Eufemia d\'Aspromonte','Sant\'Eufemia d\'Aspromonte','','NO','I333',38.2620655,15.8548300,32.9318,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080082','Sant\'Ilario dello Ionio','Sant\'Ilario dello Ionio','','NO','I341',38.2174804,16.1963840,14.1065,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080083','Santo Stefano in Aspromonte','Santo Stefano in Aspromonte','','NO','I371',38.1675293,15.7893976,17.8341,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080084','Scido','Scido','','NO','I536',38.2437945,15.9331707,17.6998,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080085','Scilla','Scilla','','NO','I537',38.2532842,15.7152898,43.6876,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080086','Seminara','Seminara','','NO','I600',38.3356498,15.8713492,33.9979,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080087','Serrata','Serrata','','NO','I656',38.5126970,16.1015688,21.9391,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080088','Siderno','Siderno','','NO','I725',38.2691261,16.2971314,31.9506,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080089','Sinopoli','Sinopoli','','NO','I753',38.2636459,15.8771330,24.9850,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080090','Staiti','Staiti','','NO','I936',38.0005444,16.0333852,16.3178,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080091','Stignano','Stignano','','NO','I955',38.4181305,16.4704860,17.8326,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080092','Stilo','Stilo','','NO','I956',38.4764155,16.4666170,78.3884,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080093','Taurianova','Taurianova','','NO','L063',38.3542871,16.0099917,48.5549,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080094','Terranova Sappo Minulio','Terranova Sappo Minulio','','NO','L127',38.3225357,16.0069993,9.2255,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080095','Varapodio','Varapodio','','NO','L673',38.3150522,15.9849522,29.0319,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080096','Villa San Giovanni','Villa San Giovanni','','NO','M018',38.2179416,15.6382652,12.2518,'280');
INSERT INTO `gi_comuni` VALUES ('RC','080097','San Ferdinando','San Ferdinando','','NO','M277',38.4831007,15.9162422,14.1561,'280');
INSERT INTO `gi_comuni` VALUES ('TP','081001','Alcamo','Alcamo','','NO','A176',37.9802778,12.9646022,130.9718,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081002','Buseto Palizzolo','Buseto Palizzolo','','NO','B288',38.0120285,12.7115085,73.1147,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081003','Calatafimi-Segesta','Calatafimi-Segesta','','NO','B385',37.9139493,12.8626365,154.6328,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081004','Campobello di Mazara','Campobello di Mazara','','NO','B521',37.6344794,12.7441005,65.8271,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081005','Castellammare del Golfo','Castellammare del Golfo','','NO','C130',38.0260282,12.8804483,126.6652,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081006','Castelvetrano','Castelvetrano','','NO','C286',37.6788811,12.7917830,207.7201,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081007','Custonaci','Custonaci','','NO','D234',38.0761517,12.6740639,70.6736,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081008','Erice','Erice','','NO','D423',38.0383277,12.5870507,47.9108,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081009','Favignana','Favignana','','NO','D518',37.9314799,12.3273684,38.6740,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081010','Gibellina','Gibellina','','NO','E023',37.8099650,12.8698853,46.5921,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081011','Marsala','Marsala','','NO','E974',37.7978183,12.4341430,243.6280,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081012','Mazara del Vallo','Mazara del Vallo','','NO','F061',37.6516443,12.5876096,275.1123,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081013','Paceco','Paceco','','NO','G208',37.9809810,12.5569562,57.8373,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081014','Pantelleria','Pantelleria','','NO','G315',36.8319094,11.9450974,84.2574,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081015','Partanna','Partanna','','NO','G347',37.7214074,12.8899222,82.4670,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081016','Poggioreale','Poggioreale','','NO','G767',37.7619517,13.0342764,37.8086,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081017','Salaparuta','Salaparuta','','NO','H688',37.7555917,13.0068106,41.3338,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081018','Salemi','Salemi','','NO','H700',37.8159540,12.8015223,182.0104,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081019','Santa Ninfa','Santa Ninfa','','NO','I291',37.7738304,12.8798802,63.1988,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081020','San Vito Lo Capo','San Vito Lo Capo','','NO','I407',38.1720996,12.7343016,59.8036,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081021','Trapani','Trapani','','SI','L331',38.0184622,12.5137056,180.1090,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081022','Valderice','Valderice','','NO','G319',38.0378097,12.6144300,52.2465,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081023','Vita','Vita','','NO','M081',37.8687016,12.8143218,9.1498,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081024','Petrosino','Petrosino','','NO','M281',37.7120414,12.4954407,45.3477,'081');
INSERT INTO `gi_comuni` VALUES ('TP','081025','Misiliscemi','Misiliscemi','','NO','M432',38.0184622,12.5137056,92.9675,'081');
INSERT INTO `gi_comuni` VALUES ('PA','082001','Alia','Alia','','NO','A195',37.7783166,13.7131245,45.7682,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082002','Alimena','Alimena','','NO','A202',37.6921748,14.1133572,59.7080,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082003','Aliminusa','Aliminusa','','NO','A203',37.8641415,13.7812450,13.4920,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082004','Altavilla Milicia','Altavilla Milicia','','NO','A229',38.0424983,13.5509313,23.8829,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082005','Altofonte','Altofonte','','NO','A239',38.0445519,13.2981327,35.3085,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082006','Bagheria','Bagheria','','NO','A546',38.0789303,13.5109853,30.0336,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082007','Balestrate','Balestrate','','NO','A592',38.0515930,13.0040335,6.7218,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082008','Baucina','Baucina','','NO','A719',37.9251383,13.5373142,24.3427,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082009','Belmonte Mezzagno','Belmonte Mezzagno','','NO','A764',38.0482273,13.3901322,29.5387,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082010','Bisacquino','Bisacquino','','NO','A882',37.6982030,13.2640065,64.8729,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082011','Bolognetta','Bolognetta','','NO','A946',37.9642093,13.4560231,27.1862,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082012','Bompietro','Bompietro','','NO','A958',37.7465845,14.1006448,42.5569,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082013','Borgetto','Borgetto','','NO','A991',38.0464082,13.1427185,26.0843,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082014','Caccamo','Caccamo','','NO','B315',37.9317016,13.6634378,187.7234,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082015','Caltavuturo','Caltavuturo','','NO','B430',37.8196440,13.8907977,97.9096,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082016','Campofelice di Fitalia','Campofelice di Fitalia','','NO','B533',37.8261182,13.4845955,35.1692,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082017','Campofelice di Roccella','Campofelice di Roccella','','NO','B532',37.9896610,13.8845425,14.2377,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082018','Campofiorito','Campofiorito','','NO','B535',37.7531310,13.2691540,22.1621,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082019','Camporeale','Camporeale','','NO','B556',37.8970755,13.0952611,38.6305,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082020','Capaci','Capaci','','NO','B645',38.1702065,13.2390704,6.2091,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082021','Carini','Carini','','NO','B780',38.1330386,13.1821555,76.2240,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082022','Castelbuono','Castelbuono','','NO','C067',37.9330234,14.0878432,60.9752,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082023','Casteldaccia','Casteldaccia','','NO','C074',38.0536799,13.5300149,33.8483,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082024','Castellana Sicula','Castellana Sicula','','NO','C135',37.7830961,14.0410425,72.8116,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082025','Castronovo di Sicilia','Castronovo di Sicilia','','NO','C344',37.6797017,13.6042248,200.8403,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082026','Cefalà Diana','Cefalà Diana','','NO','C420',37.9152081,13.4630188,8.9983,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082027','Cefalù','Cefalù','','NO','C421',38.0395615,14.0217101,65.9095,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082028','Cerda','Cerda','','NO','C496',37.9037767,13.8153862,43.9345,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082029','Chiusa Sclafani','Chiusa Sclafani','','NO','C654',37.6769989,13.2699695,57.6229,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082030','Ciminna','Ciminna','','NO','C696',37.8981654,13.5582775,56.6650,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082031','Cinisi','Cinisi','','NO','C708',38.1544865,13.1094838,33.2880,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082032','Collesano','Collesano','','NO','C871',37.9212990,13.9375852,107.9764,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082033','Contessa Entellina','Contessa Entellina','','NO','C968',37.7285408,13.1842707,136.7148,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082034','Corleone','Corleone','','NO','D009',37.8120259,13.3017298,229.2300,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082035','Ficarazzi','Ficarazzi','','NO','D567',38.0877388,13.4632604,3.4962,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082036','Gangi','Gangi','','NO','D907',37.7972068,14.2057486,127.6587,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082037','Geraci Siculo','Geraci Siculo','','NO','D977',37.8584663,14.1542961,112.8478,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082038','Giardinello','Giardinello','','NO','E013',38.0872576,13.1579371,12.5164,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082039','Giuliana','Giuliana','','NO','E055',37.6779626,13.2340353,24.0538,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082040','Godrano','Godrano','','NO','E074',37.9030936,13.4278567,39.3536,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082041','Gratteri','Gratteri','','NO','E149',37.9675345,13.9739445,38.5271,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082042','Isnello','Isnello','','NO','E337',37.9439619,14.0061535,50.9875,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082043','Isola delle Femmine','Isola delle Femmine','','NO','E350',38.1984348,13.2487626,3.3945,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082044','Lascari','Lascari','','NO','E459',37.9996776,13.9414145,10.0752,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082045','Lercara Friddi','Lercara Friddi','','NO','E541',37.7476139,13.6029841,37.5153,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082046','Marineo','Marineo','','NO','E957',37.9526150,13.4141519,33.4426,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082047','Mezzojuso','Mezzojuso','','NO','F184',37.8643763,13.4645465,49.3295,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082048','Misilmeri','Misilmeri','','NO','F246',38.0350758,13.4511643,69.3941,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082049','Monreale','Monreale','','NO','F377',38.0824454,13.2923324,530.1857,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082050','Montelepre','Montelepre','','NO','F544',38.0896825,13.1732815,10.3517,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082051','Montemaggiore Belsito','Montemaggiore Belsito','','NO','F553',37.8478252,13.7628173,32.2928,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082052','Palazzo Adriano','Palazzo Adriano','','NO','G263',37.6819645,13.3786464,129.5169,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082053','Palermo','Palermo','','SI','G273',38.1149587,13.3622199,160.1115,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082054','Partinico','Partinico','','NO','G348',38.0478357,13.1151247,108.0688,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082055','Petralia Soprana','Petralia Soprana','','NO','G510',37.7961315,14.1080918,55.8143,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082056','Petralia Sottana','Petralia Sottana','','NO','G511',37.8061325,14.0921887,177.6513,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082057','Piana degli Albanesi','Piana degli Albanesi','','NO','G543',37.9948593,13.2826120,64.8343,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082058','Polizzi Generosa','Polizzi Generosa','','NO','G792',37.8127997,13.9995079,135.1974,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082059','Pollina','Pollina','','NO','G797',37.9942256,14.1466012,49.7924,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082060','Prizzi','Prizzi','','NO','H070',37.7216127,13.4316531,95.0936,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082061','Roccamena','Roccamena','','NO','H422',37.8381804,13.1554997,33.3416,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082062','Roccapalumba','Roccapalumba','','NO','H428',37.8056190,13.6391312,31.6759,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082063','San Cipirello','San Cipirello','','NO','H797',37.9602299,13.1817720,20.6072,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082064','San Giuseppe Jato','San Giuseppe Jato','','NO','H933',37.9706636,13.1827067,30.0202,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082065','San Mauro Castelverde','San Mauro Castelverde','','NO','I028',37.9144040,14.1903705,114.4063,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082066','Santa Cristina Gela','Santa Cristina Gela','','NO','I174',37.9863995,13.3258478,38.7625,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082067','Santa Flavia','Santa Flavia','','NO','I188',38.0813668,13.5249681,14.3234,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082068','Sciara','Sciara','','NO','I534',37.9144697,13.7625636,31.1309,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082069','Sclafani Bagni','Sclafani Bagni','','NO','I541',37.8209366,13.8547650,135.2715,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082070','Termini Imerese','Termini Imerese','','NO','L112',37.9867542,13.6966863,76.8206,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082071','Terrasini','Terrasini','','NO','L131',38.1528772,13.0823896,19.9079,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082072','Torretta','Torretta','','NO','L282',38.1312233,13.2328906,25.9207,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082073','Trabia','Trabia','','NO','L317',37.9957944,13.6553071,21.8040,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082074','Trappeto','Trappeto','','NO','L332',38.0665570,13.0367809,4.0040,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082075','Ustica','Ustica','','NO','L519',38.7115402,13.1921429,8.4521,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082076','Valledolmo','Valledolmo','','NO','L603',37.7466659,13.8282203,25.8698,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082077','Ventimiglia di Sicilia','Ventimiglia di Sicilia','','NO','L740',37.9257504,13.5675452,27.1000,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082078','Vicari','Vicari','','NO','L837',37.8264817,13.5708044,86.1338,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082079','Villabate','Villabate','','NO','L916',38.0756060,13.4433238,3.8649,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082080','Villafrati','Villafrati','','NO','L951',37.9080201,13.4868056,25.7600,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082081','Scillato','Scillato','','NO','I538',37.8566065,13.9068406,31.7989,'282');
INSERT INTO `gi_comuni` VALUES ('PA','082082','Blufi','Blufi','','NO','M268',37.7520506,14.0742410,22.1840,'282');
INSERT INTO `gi_comuni` VALUES ('ME','083001','Alcara li Fusi','Alcara li Fusi','','NO','A177',38.0211879,14.7014792,63.0521,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083002','Alì','Alì','','NO','A194',38.0268853,15.4187009,16.0641,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083003','Alì Terme','Alì Terme','','NO','A201',38.0035658,15.4227467,5.9842,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083004','Antillo','Antillo','','NO','A313',37.9759835,15.2451944,43.7899,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083005','Barcellona Pozzo di Gotto','Barcellona Pozzo di Gotto','','NO','A638',38.1468683,15.2185727,59.2569,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083006','Basicò','Basicò','','NO','A698',38.0615691,15.0611719,12.0348,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083007','Brolo','Brolo','','NO','B198',38.1568103,14.8274071,7.6142,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083008','Capizzi','Capizzi','','NO','B660',37.8486349,14.4787374,69.9596,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083009','Capo d\'Orlando','Capo d\'Orlando','','NO','B666',38.1597588,14.7448100,14.7608,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083010','Capri Leone','Capri Leone','','NO','B695',38.1087118,14.7080639,6.6379,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083011','Caronia','Caronia','','NO','B804',38.0245454,14.4406007,227.2031,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083012','Casalvecchio Siculo','Casalvecchio Siculo','','NO','B918',37.9580567,15.3234505,33.8019,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083013','Castel di Lucio','Castel di Lucio','','NO','C094',37.8869130,14.3109412,28.7503,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083014','Castell\'Umberto','Castell\'Umberto','','NO','C051',38.0846179,14.8069740,11.4646,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083015','Castelmola','Castelmola','','NO','C210',37.8587023,15.2776867,16.8942,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083016','Castroreale','Castroreale','','NO','C347',38.0984172,15.2110471,53.0339,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083017','Cesarò','Cesarò','','NO','C568',37.8439559,14.7115812,217.0515,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083018','Condrò','Condrò','','NO','C956',38.1756511,15.3266280,5.2902,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083019','Falcone','Falcone','','NO','D474',38.1162911,15.0822986,9.3420,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083020','Ficarra','Ficarra','','NO','D569',38.1104370,14.8276394,18.8154,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083021','Fiumedinisi','Fiumedinisi','','NO','D622',38.0259504,15.3821131,36.3230,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083022','Floresta','Floresta','','NO','D635',37.9876009,14.9096556,31.2482,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083023','Fondachelli-Fantina','Fondachelli-Fantina','','NO','D661',37.9840021,15.1739538,42.1471,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083024','Forza d\'Agrò','Forza d\'Agrò','','NO','D733',37.9136310,15.3354609,11.3787,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083025','Francavilla di Sicilia','Francavilla di Sicilia','','NO','D765',37.9011562,15.1361282,82.6270,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083026','Frazzanò','Frazzanò','','NO','D793',38.0723198,14.7445824,6.6631,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083027','Furci Siculo','Furci Siculo','','NO','D824',37.9612244,15.3802572,18.2272,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083028','Furnari','Furnari','','NO','D825',38.1045898,15.1259814,13.5149,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083029','Gaggi','Gaggi','','NO','D844',37.8616228,15.2181382,7.8133,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083030','Galati Mamertino','Galati Mamertino','','NO','D861',38.0317061,14.7729101,39.4620,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083031','Gallodoro','Gallodoro','','NO','D885',37.9014456,15.2935799,6.9171,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083032','Giardini-Naxos','Giardini-Naxos','','NO','E014',37.8401776,15.2770705,5.1847,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083033','Gioiosa Marea','Gioiosa Marea','','NO','E043',38.1736355,14.8949064,26.5683,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083034','Graniti','Graniti','','NO','E142',37.8880114,15.2228037,10.0397,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083035','Gualtieri Sicaminò','Gualtieri Sicaminò','','NO','E233',38.1635885,15.3166954,14.0203,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083036','Itala','Itala','','NO','E374',38.0514190,15.4365261,11.1170,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083037','Leni','Leni','','NO','E523',38.5549965,14.8252162,8.7946,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083038','Letojanni','Letojanni','','NO','E555',37.8803032,15.3061811,6.8449,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083039','Librizzi','Librizzi','','NO','E571',38.0968577,14.9581733,23.6404,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083040','Limina','Limina','','NO','E594',37.9406345,15.2725426,9.7302,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083041','Lipari','Lipari','','NO','E606',38.4694248,14.9568853,90.8901,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083042','Longi','Longi','','NO','E674',38.0271229,14.7527119,42.0974,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083043','Malfa','Malfa','','NO','E855',38.5773694,14.8345015,8.8649,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083044','Malvagna','Malvagna','','NO','E869',37.9185030,15.0554020,6.5146,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083045','Mandanici','Mandanici','','NO','E876',38.0020899,15.3169971,11.7651,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083046','Mazzarrà Sant\'Andrea','Mazzarrà Sant\'Andrea','','NO','F066',38.0898500,15.1359412,6.6785,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083047','Merì','Merì','','NO','F147',38.1675124,15.2463924,1.7745,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083048','Messina','Messina','','SI','F158',38.1938524,15.5552753,212.7847,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083049','Milazzo','Milazzo','','NO','F206',38.2204545,15.2420507,24.7597,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083050','Militello Rosmarino','Militello Rosmarino','','NO','F210',38.0461872,14.6766594,29.5476,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083051','Mirto','Mirto','','NO','F242',38.0850980,14.7527744,9.3135,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083052','Mistretta','Mistretta','','NO','F251',37.9297506,14.3629242,127.3274,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083053','Moio Alcantara','Moio Alcantara','','NO','F277',37.8989928,15.0505788,8.6931,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083054','Monforte San Giorgio','Monforte San Giorgio','','NO','F359',38.1566465,15.3836870,32.2710,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083055','Mongiuffi Melia','Mongiuffi Melia','','NO','F368',37.9042307,15.2749428,24.1800,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083056','Montagnareale','Montagnareale','','NO','F395',38.1317756,14.9464410,16.3411,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083057','Montalbano Elicona','Montalbano Elicona','','NO','F400',38.0234288,15.0141039,67.4737,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083058','Motta Camastra','Motta Camastra','','NO','F772',37.8955938,15.1722645,25.4034,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083059','Motta d\'Affermo','Motta d\'Affermo','','NO','F773',37.9809581,14.3022521,14.3866,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083060','Naso','Naso','','NO','F848',38.1218409,14.7901383,36.8082,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083061','Nizza di Sicilia','Nizza di Sicilia','','NO','F901',37.9925087,15.4122037,13.9364,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083062','Novara di Sicilia','Novara di Sicilia','','NO','F951',38.0161960,15.1319935,49.0752,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083063','Oliveri','Oliveri','','NO','G036',38.1241287,15.0592845,10.7303,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083064','Pace del Mela','Pace del Mela','','NO','G209',38.1794418,15.3052249,12.2526,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083065','Pagliara','Pagliara','','NO','G234',37.9864087,15.3595257,14.4046,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083066','Patti','Patti','','NO','G377',38.1396330,14.9639041,49.7336,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083067','Pettineo','Pettineo','','NO','G522',37.9665727,14.2908578,30.4914,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083068','Piraino','Piraino','','NO','G699',38.1615868,14.8638238,16.7876,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083069','Raccuja','Raccuja','','NO','H151',38.0554804,14.9106551,25.2109,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083070','Reitano','Reitano','','NO','H228',37.9728583,14.3446291,14.2759,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083071','Roccafiorita','Roccafiorita','','NO','H405',37.9299946,15.2678376,1.1909,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083072','Roccalumera','Roccalumera','','NO','H418',37.9753023,15.3945899,8.8326,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083073','Roccavaldina','Roccavaldina','','NO','H380',38.1815990,15.3726367,7.2601,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083074','Roccella Valdemone','Roccella Valdemone','','NO','H455',37.9325578,15.0096533,41.3136,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083075','Rodì Milici','Rodì Milici','','NO','H479',38.1101038,15.1697267,36.0993,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083076','Rometta','Rometta','','NO','H519',38.1709762,15.4142967,31.9741,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083077','San Filippo del Mela','San Filippo del Mela','','NO','H842',38.1692030,15.2717769,9.9672,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083078','San Fratello','San Fratello','','NO','H850',38.0131007,14.5962676,67.5807,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083079','San Marco d\'Alunzio','San Marco d\'Alunzio','','NO','H982',38.0736801,14.6993377,26.2866,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083080','San Pier Niceto','San Pier Niceto','','NO','I084',38.1589250,15.3519124,36.8727,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083081','San Piero Patti','San Piero Patti','','NO','I086',38.0505256,14.9665465,41.8802,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083082','San Salvatore di Fitalia','San Salvatore di Fitalia','','NO','I147',38.0709489,14.7774948,14.9048,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083083','Santa Domenica Vittoria','Santa Domenica Vittoria','','NO','I184',37.9152388,14.9616979,20.2134,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083084','Sant\'Agata di Militello','Sant\'Agata di Militello','','NO','I199',38.0694288,14.6338526,34.2606,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083085','Sant\'Alessio Siculo','Sant\'Alessio Siculo','','NO','I215',37.9219251,15.3466453,6.1876,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083086','Santa Lucia del Mela','Santa Lucia del Mela','','NO','I220',38.1416422,15.2799364,86.0170,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083087','Santa Marina Salina','Santa Marina Salina','','NO','I254',38.5594468,14.8716366,8.7268,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083088','Sant\'Angelo di Brolo','Sant\'Angelo di Brolo','','NO','I283',38.1131443,14.8825688,30.2727,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083089','Santa Teresa di Riva','Santa Teresa di Riva','','NO','I311',37.9453985,15.3684945,8.0693,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083090','San Teodoro','San Teodoro','','NO','I328',37.8459516,14.7019642,13.7072,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083091','Santo Stefano di Camastra','Santo Stefano di Camastra','','NO','I370',38.0163828,14.3484709,21.9799,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083092','Saponara','Saponara','','NO','I420',38.1934627,15.4337114,26.3206,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083093','Savoca','Savoca','','NO','I477',37.9559006,15.3398283,8.7869,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083094','Scaletta Zanclea','Scaletta Zanclea','','NO','I492',38.0427137,15.4594196,4.8040,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083095','Sinagra','Sinagra','','NO','I747',38.0827810,14.8491170,23.7400,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083096','Spadafora','Spadafora','','NO','I881',38.2222066,15.3747966,10.6725,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083097','Taormina','Taormina','','NO','L042',37.8511325,15.2829642,12.5899,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083098','Torregrotta','Torregrotta','','NO','L271',38.1917148,15.3525521,4.1538,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083099','Tortorici','Tortorici','','NO','L308',38.0298047,14.8234732,70.2699,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083100','Tripi','Tripi','','NO','L431',38.0486565,15.0986575,54.8471,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083101','Tusa','Tusa','','NO','L478',37.9844457,14.2385323,41.2288,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083102','Ucria','Ucria','','NO','L482',38.0456778,14.8809905,26.3083,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083103','Valdina','Valdina','','NO','L561',38.1933269,15.3705901,2.6683,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083104','Venetico','Venetico','','NO','L735',38.2189374,15.3647409,4.3679,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083105','Villafranca Tirrena','Villafranca Tirrena','','NO','L950',38.2354175,15.4325380,14.2903,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083106','Terme Vigliatore','Terme Vigliatore','','NO','M210',38.1365952,15.1623997,13.3009,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083107','Acquedolci','Acquedolci','','NO','M211',38.0560742,14.5881794,12.8237,'283');
INSERT INTO `gi_comuni` VALUES ('ME','083108','Torrenova','Torrenova','','NO','M286',38.0887929,14.6786567,13.0314,'283');
INSERT INTO `gi_comuni` VALUES ('AG','084001','Agrigento','Agrigento','','SI','A089',37.3113942,13.5770814,243.2013,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084002','Alessandria della Rocca','Alessandria della Rocca','','NO','A181',37.5696565,13.4535317,62.5671,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084003','Aragona','Aragona','','NO','A351',37.4029259,13.6177064,74.7247,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084004','Bivona','Bivona','','NO','A896',37.6170901,13.4401853,88.9401,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084005','Burgio','Burgio','','NO','B275',37.5986863,13.2900279,42.4353,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084006','Calamonaci','Calamonaci','','NO','B377',37.5253458,13.2909803,32.7221,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084007','Caltabellotta','Caltabellotta','','NO','B427',37.5769462,13.2159237,124.4765,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084008','Camastra','Camastra','','NO','B460',37.2522330,13.7935756,16.4446,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084009','Cammarata','Cammarata','','NO','B486',37.6333397,13.6378039,192.6497,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084010','Campobello di Licata','Campobello di Licata','','NO','B520',37.2592027,13.9184552,81.5484,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084011','Canicattì','Canicattì','','NO','B602',37.3584387,13.8498168,91.8223,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084012','Casteltermini','Casteltermini','','NO','C275',37.5407130,13.6433957,99.6528,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084013','Castrofilippo','Castrofilippo','','NO','C341',37.3483833,13.7501388,18.2310,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084014','Cattolica Eraclea','Cattolica Eraclea','','NO','C356',37.4392357,13.3953492,61.4930,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084015','Cianciana','Cianciana','','NO','C668',37.5181197,13.4343210,37.8863,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084016','Comitini','Comitini','','NO','C928',37.4085737,13.6438754,21.6874,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084017','Favara','Favara','','NO','D514',37.3147284,13.6598468,83.2048,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084018','Grotte','Grotte','','NO','E209',37.4027301,13.6988427,24.1040,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084019','Joppolo Giancaxio','Joppolo Giancaxio','','NO','E390',37.3875824,13.5539454,19.3039,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084020','Lampedusa e Linosa','Lampedusa e Linosa','','NO','E431',35.5024670,12.6095358,26.2563,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084021','Licata','Licata','','NO','E573',37.1013548,13.9374415,179.3235,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084022','Lucca Sicula','Lucca Sicula','','NO','E714',37.5783712,13.3067392,18.7624,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084023','Menfi','Menfi','','NO','F126',37.5986844,12.9686690,113.5758,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084024','Montallegro','Montallegro','','NO','F414',37.3938530,13.3500542,27.9376,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084025','Montevago','Montevago','','NO','F655',37.7027510,12.9898218,33.0552,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084026','Naro','Naro','','NO','F845',37.2961098,13.7915271,207.5601,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084027','Palma di Montechiaro','Palma di Montechiaro','','NO','G282',37.1915581,13.7636785,77.2204,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084028','Porto Empedocle','Porto Empedocle','','NO','F299',37.2884473,13.5275312,25.0923,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084029','Racalmuto','Racalmuto','','NO','H148',37.4084508,13.7320228,68.1829,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084030','Raffadali','Raffadali','','NO','H159',37.4046866,13.5311269,22.2057,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084031','Ravanusa','Ravanusa','','NO','H194',37.2680829,13.9731874,50.0340,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084032','Realmonte','Realmonte','','NO','H205',37.3065074,13.4627306,20.3940,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084033','Ribera','Ribera','','NO','H269',37.5026531,13.2665287,118.6001,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084034','Sambuca di Sicilia','Sambuca di Sicilia','','NO','H743',37.6488023,13.1130456,96.4879,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084035','San Biagio Platani','San Biagio Platani','','NO','H778',37.5089835,13.5242084,42.9417,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084036','San Giovanni Gemini','San Giovanni Gemini','','NO','H914',37.6300981,13.6414590,26.5129,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084037','Santa Elisabetta','Santa Elisabetta','','NO','I185',37.4315051,13.5549684,16.4792,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084038','Santa Margherita di Belice','Santa Margherita di Belice','','NO','I224',37.6918018,13.0240486,67.2382,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084039','Sant\'Angelo Muxaro','Sant\'Angelo Muxaro','','NO','I290',37.4790747,13.5441564,64.2781,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084040','Santo Stefano Quisquina','Santo Stefano Quisquina','','NO','I356',37.6246599,13.4905099,84.8335,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084041','Sciacca','Sciacca','','NO','I533',37.5067376,13.0827731,191.5576,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084042','Siculiana','Siculiana','','NO','I723',37.3361041,13.4196832,40.9164,'084');
INSERT INTO `gi_comuni` VALUES ('AG','084043','Villafranca Sicula','Villafranca Sicula','','NO','L944',37.5866610,13.2906107,17.3065,'084');
INSERT INTO `gi_comuni` VALUES ('CL','085001','Acquaviva Platani','Acquaviva Platani','','NO','A049',37.5715166,13.7000968,14.8761,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085002','Bompensiere','Bompensiere','','NO','A957',37.4737536,13.7807498,20.0486,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085003','Butera','Butera','','NO','B302',37.1863729,14.1862208,298.2823,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085004','Caltanissetta','Caltanissetta','','SI','B429',37.4902819,14.0634723,420.1404,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085005','Campofranco','Campofranco','','NO','B537',37.5121988,13.7125883,36.4276,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085006','Delia','Delia','','NO','D267',37.3558270,13.9278051,12.3276,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085007','Gela','Gela','','NO','D960',37.0652335,14.2500329,278.6804,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085008','Marianopoli','Marianopoli','','NO','E953',37.5986365,13.9154826,13.2395,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085009','Mazzarino','Mazzarino','','NO','F065',37.3051113,14.2140704,296.4990,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085010','Milena','Milena','','NO','E618',37.4710709,13.7364208,24.6449,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085011','Montedoro','Montedoro','','NO','F489',37.4536746,13.8164882,14.2493,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085012','Mussomeli','Mussomeli','','NO','F830',37.5801559,13.7540014,163.9665,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085013','Niscemi','Niscemi','','NO','F899',37.1452485,14.3855376,97.1850,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085014','Resuttano','Resuttano','','NO','H245',37.6800129,14.0311433,38.5345,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085015','Riesi','Riesi','','NO','H281',37.2828253,14.0820047,66.0827,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085016','San Cataldo','San Cataldo','','NO','H792',37.4872222,13.9914224,73.0933,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085017','Santa Caterina Villarmosa','Santa Caterina Villarmosa','','NO','I169',37.5917440,14.0327501,76.0292,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085018','Serradifalco','Serradifalco','','NO','I644',37.4562382,13.8819693,42.1744,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085019','Sommatino','Sommatino','','NO','I824',37.3341870,13.9910375,34.5921,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085020','Sutera','Sutera','','NO','L016',37.5254893,13.7313207,35.6329,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085021','Vallelunga Pratameno','Vallelunga Pratameno','','NO','L609',37.6814192,13.8312829,39.3587,'085');
INSERT INTO `gi_comuni` VALUES ('CL','085022','Villalba','Villalba','','NO','L959',37.6548874,13.8439844,41.8130,'085');
INSERT INTO `gi_comuni` VALUES ('EN','086001','Agira','Agira','','NO','A070',37.6569660,14.5235367,163.4741,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086002','Aidone','Aidone','','NO','A098',37.4158501,14.4476961,210.0933,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086003','Assoro','Assoro','','NO','A478',37.6279649,14.4241376,111.9703,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086004','Barrafranca','Barrafranca','','NO','A676',37.3730458,14.2038017,53.6659,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086005','Calascibetta','Calascibetta','','NO','B381',37.5894745,14.2729408,89.0511,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086006','Catenanuova','Catenanuova','','NO','C353',37.5677101,14.6917486,11.2662,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086007','Centuripe','Centuripe','','NO','C471',37.6205916,14.7416959,173.7047,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086008','Cerami','Cerami','','NO','C480',37.8100533,14.5088009,95.5464,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086009','Enna','Enna','','SI','C342',37.5666873,14.2791626,358.2691,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086010','Gagliano Castelferrato','Gagliano Castelferrato','','NO','D849',37.7101871,14.5356965,56.3449,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086011','Leonforte','Leonforte','','NO','E536',37.6391420,14.3924793,84.6150,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086012','Nicosia','Nicosia','','NO','F892',37.7481024,14.3985785,217.9515,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086013','Nissoria','Nissoria','','NO','F900',37.6550570,14.4493899,62.0616,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086014','Piazza Armerina','Piazza Armerina','','NO','G580',37.3845517,14.3660867,304.7234,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086015','Pietraperzia','Pietraperzia','','NO','G624',37.4215983,14.1369678,118.7484,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086016','Regalbuto','Regalbuto','','NO','H221',37.6521595,14.6407053,170.6853,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086017','Sperlinga','Sperlinga','','NO','I891',37.7651299,14.3526995,59.3888,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086018','Troina','Troina','','NO','L448',37.7850906,14.6004811,168.0723,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086019','Valguarnera Caropepe','Valguarnera Caropepe','','NO','L583',37.4964159,14.3879702,9.4699,'086');
INSERT INTO `gi_comuni` VALUES ('EN','086020','Villarosa','Villarosa','','NO','M011',37.5873629,14.1742753,55.3547,'086');
INSERT INTO `gi_comuni` VALUES ('CT','087001','Aci Bonaccorsi','Aci Bonaccorsi','','NO','A025',37.5975848,15.1077200,1.6894,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087002','Aci Castello','Aci Castello','','NO','A026',37.5535086,15.1479323,8.6819,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087003','Aci Catena','Aci Catena','','NO','A027',37.6026002,15.1418158,8.5433,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087004','Acireale','Acireale','','NO','A028',37.6122222,15.1659495,40.3343,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087005','Aci Sant\'Antonio','Aci Sant\'Antonio','','NO','A029',37.6058579,15.1256761,14.6090,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087006','Adrano','Adrano','','NO','A056',37.6616807,14.8327329,83.4098,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087007','Belpasso','Belpasso','','NO','A766',37.5912460,14.9772371,166.4667,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087008','Biancavilla','Biancavilla','','NO','A841',37.6463241,14.8617083,70.1930,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087009','Bronte','Bronte','','NO','B202',37.7878697,14.8332628,251.2006,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087010','Calatabiano','Calatabiano','','NO','B384',37.8233987,15.2279046,26.4889,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087011','Caltagirone','Caltagirone','','NO','B428',37.2380063,14.5127637,383.4023,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087012','Camporotondo Etneo','Camporotondo Etneo','','NO','B561',37.5673629,15.0058705,6.4584,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087013','Castel di Iudica','Castel di Iudica','','NO','C091',37.4940735,14.6492878,103.2643,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087014','Castiglione di Sicilia','Castiglione di Sicilia','','NO','C297',37.8826947,15.1225880,119.3143,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087015','Catania','Catania','','SI','C351',37.5029702,15.0869640,183.2204,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087016','Fiumefreddo di Sicilia','Fiumefreddo di Sicilia','','NO','D623',37.7929606,15.2082755,12.2699,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087017','Giarre','Giarre','','NO','E017',37.7297668,15.1840252,27.2632,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087018','Grammichele','Grammichele','','NO','E133',37.2150218,14.6369789,31.8307,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087019','Gravina di Catania','Gravina di Catania','','NO','E156',37.5602207,15.0619022,4.9958,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087020','Licodia Eubea','Licodia Eubea','','NO','E578',37.1557689,14.7030547,111.9851,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087021','Linguaglossa','Linguaglossa','','NO','E602',37.8403415,15.1440436,60.2725,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087022','Maletto','Maletto','','NO','E854',37.8315482,14.8664398,41.0665,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087023','Mascali','Mascali','','NO','F004',37.7573329,15.1962350,38.1126,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087024','Mascalucia','Mascalucia','','NO','F005',37.5731567,15.0532031,16.0599,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087025','Militello in Val di Catania','Militello in Val di Catania','','NO','F209',37.2709741,14.7961629,62.0025,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087026','Milo','Milo','','NO','F214',37.7221026,15.1161310,16.8917,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087027','Mineo','Mineo','','NO','F217',37.2645873,14.6916209,245.4697,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087028','Mirabella Imbaccari','Mirabella Imbaccari','','NO','F231',37.3241995,14.4457640,15.6354,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087029','Misterbianco','Misterbianco','','NO','F250',37.5206417,15.0069602,38.0575,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087030','Motta Sant\'Anastasia','Motta Sant\'Anastasia','','NO','F781',37.5122199,14.9697283,35.7428,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087031','Nicolosi','Nicolosi','','NO','F890',37.6142520,15.0268111,42.6644,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087032','Palagonia','Palagonia','','NO','G253',37.3281522,14.7463589,57.4506,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087033','Paternò','Paternò','','NO','G371',37.5772701,14.9032493,144.6085,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087034','Pedara','Pedara','','NO','G402',37.6170023,15.0599416,19.0390,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087035','Piedimonte Etneo','Piedimonte Etneo','','NO','G597',37.8079693,15.1778471,26.3555,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087036','Raddusa','Raddusa','','NO','H154',37.4728044,14.5317664,23.6412,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087037','Ramacca','Ramacca','','NO','H168',37.3845912,14.6935469,306.9534,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087038','Randazzo','Randazzo','','NO','H175',37.8773442,14.9463374,206.1238,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087039','Riposto','Riposto','','NO','H325',37.7317378,15.2038981,13.3492,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087040','San Cono','San Cono','','NO','H805',37.2897566,14.3657766,6.7441,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087041','San Giovanni la Punta','San Giovanni la Punta','','NO','H922',37.5770238,15.0940079,10.8200,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087042','San Gregorio di Catania','San Gregorio di Catania','','NO','H940',37.5649716,15.1083352,5.5786,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087043','San Michele di Ganzaria','San Michele di Ganzaria','','NO','I035',37.2794031,14.4260957,25.8048,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087044','San Pietro Clarenza','San Pietro Clarenza','','NO','I098',37.5725663,15.0235379,6.3941,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087045','Sant\'Agata li Battiati','Sant\'Agata li Battiati','','NO','I202',37.5591476,15.0779850,3.0681,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087046','Sant\'Alfio','Sant\'Alfio','','NO','I216',37.7413491,15.1424693,25.7345,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087047','Santa Maria di Licodia','Santa Maria di Licodia','','NO','I240',37.6163386,14.8875094,26.3550,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087048','Santa Venerina','Santa Venerina','','NO','I314',37.6867643,15.1386959,18.7282,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087049','Scordia','Scordia','','NO','I548',37.2965329,14.8463037,24.5240,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087050','Trecastagni','Trecastagni','','NO','L355',37.6169285,15.0790604,19.2526,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087051','Tremestieri Etneo','Tremestieri Etneo','','NO','L369',37.5759652,15.0719368,6.4640,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087052','Valverde','Valverde','','NO','L658',37.5788833,15.1248225,5.4796,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087053','Viagrande','Viagrande','','NO','L828',37.6106409,15.0967066,10.0687,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087054','Vizzini','Vizzini','','NO','M100',37.1609443,14.7484952,127.3753,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087055','Zafferana Etnea','Zafferana Etnea','','NO','M139',37.6922897,15.1053372,76.9030,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087056','Mazzarrone','Mazzarrone','','NO','M271',37.0838962,14.5620234,34.8657,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087057','Maniace','Maniace','','NO','M283',37.8614690,14.8090993,37.2614,'287');
INSERT INTO `gi_comuni` VALUES ('CT','087058','Ragalna','Ragalna','','NO','M287',37.6345610,14.9431133,39.2135,'287');
INSERT INTO `gi_comuni` VALUES ('RG','088001','Acate','Acate','','NO','A014',37.0261826,14.4943275,102.4073,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088002','Chiaramonte Gulfi','Chiaramonte Gulfi','','NO','C612',37.0312936,14.7011067,127.8152,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088003','Comiso','Comiso','','NO','C927',36.9455343,14.6046950,64.6553,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088004','Giarratana','Giarratana','','NO','E016',37.0482208,14.7932333,43.7663,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088005','Ispica','Ispica','','NO','E366',36.7857388,14.9076642,113.6616,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088006','Modica','Modica','','NO','F258',36.8587642,14.7612710,292.7530,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088007','Monterosso Almo','Monterosso Almo','','NO','F610',37.0888005,14.7626117,56.5223,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088008','Pozzallo','Pozzallo','','NO','G953',36.7261176,14.8464303,15.3683,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088009','Ragusa','Ragusa','','SI','H163',36.9249942,14.7306497,444.5324,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088010','Santa Croce Camerina','Santa Croce Camerina','','NO','I178',36.8286918,14.5248845,40.8083,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088011','Scicli','Scicli','','NO','I535',36.7936353,14.7067803,138.6719,'088');
INSERT INTO `gi_comuni` VALUES ('RG','088012','Vittoria','Vittoria','','NO','M088',36.9483586,14.5383775,182.9005,'088');
INSERT INTO `gi_comuni` VALUES ('SR','089001','Augusta','Augusta','','NO','A494',37.2303015,15.2201393,111.6989,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089002','Avola','Avola','','NO','A522',36.9083469,15.1355286,74.7954,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089003','Buccheri','Buccheri','','NO','B237',37.1263889,14.8504594,57.1820,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089004','Buscemi','Buscemi','','NO','B287',37.0854498,14.8841734,52.2803,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089005','Canicattini Bagni','Canicattini Bagni','','NO','B603',37.0348811,15.0617551,15.0575,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089006','Carlentini','Carlentini','','NO','B787',37.2672030,15.0102803,159.0158,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089007','Cassaro','Cassaro','','NO','C006',37.1059229,14.9467665,19.7408,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089008','Ferla','Ferla','','NO','D540',37.1183471,14.9408746,25.0004,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089009','Floridia','Floridia','','NO','D636',37.0816453,15.1525208,26.5775,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089010','Francofonte','Francofonte','','NO','D768',37.2306515,14.8799321,74.5515,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089011','Lentini','Lentini','','NO','E532',37.2846821,14.9987595,216.5415,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089012','Melilli','Melilli','','NO','F107',37.1783092,15.1267560,136.1915,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089013','Noto','Noto','','NO','F943',36.8906253,15.0704986,554.7900,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089014','Pachino','Pachino','','NO','G211',36.7156466,15.0935436,50.9069,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089015','Palazzolo Acreide','Palazzolo Acreide','','NO','G267',37.0617230,14.9039918,87.1110,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089016','Rosolini','Rosolini','','NO','H574',36.8201486,14.9536590,76.4424,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089017','Siracusa','Siracusa','','SI','I754',37.0598005,15.2933648,208.0666,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089018','Solarino','Solarino','','NO','I785',37.1005965,15.1201880,13.1891,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089019','Sortino','Sortino','','NO','I864',37.1625240,15.0337712,92.4898,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089020','Portopalo di Capo Passero','Portopalo di Capo Passero','','NO','M257',36.6831809,15.1342940,14.8340,'089');
INSERT INTO `gi_comuni` VALUES ('SR','089021','Priolo Gargallo','Priolo Gargallo','','NO','M279',37.1594655,15.1862061,57.2615,'089');
INSERT INTO `gi_comuni` VALUES ('SS','090001','Aggius','Aggius','','NO','A069',40.9289389,9.0642903,86.4447,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090002','Alà dei Sardi','Alà dei Sardi','','NO','A115',40.6504108,9.3292895,197.5098,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090003','Alghero','Alghero','','NO','A192',40.5464537,8.3277848,225.4283,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090004','Anela','Anela','','NO','A287',40.4434708,9.0566971,36.7806,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090005','Ardara','Ardara','','NO','A379',40.6238442,8.8093374,38.1727,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090006','Arzachena','Arzachena','','NO','A453',41.0792316,9.3881760,231.3198,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090007','Banari','Banari','','NO','A606',40.5719361,8.6976777,21.3619,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090008','Benetutti','Benetutti','','NO','A781',40.4553660,9.1711170,94.0662,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090009','Berchidda','Berchidda','','NO','A789',40.7862673,9.1640444,202.2616,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090010','Bessude','Bessude','','NO','A827',40.5527525,8.7298322,26.5444,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090011','Bonnanaro','Bonnanaro','','NO','A976',40.5322208,8.7657771,21.9897,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090012','Bono','Bono','','NO','A977',40.4169676,9.0296345,74.5704,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090013','Bonorva','Bonorva','','NO','A978',40.4168477,8.7685525,149.2255,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090014','Bortigiadas','Bortigiadas','','NO','B063',40.8910123,9.0422470,75.6675,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090015','Borutta','Borutta','','NO','B064',40.5217288,8.7434181,4.7251,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090016','Bottidda','Bottidda','','NO','B094',40.3937953,9.0105107,33.9806,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090017','Buddusò','Buddusò','','NO','B246',40.5785004,9.2610968,176.6947,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090018','Bultei','Bultei','','NO','B264',40.4570873,9.0614259,96.8985,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090019','Bulzi','Bulzi','','NO','B265',40.8474774,8.8291720,21.5336,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090020','Burgos','Burgos','','NO','B276',40.3904125,8.9938897,18.0448,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090021','Calangianus','Calangianus','','NO','B378',40.9230386,9.1923149,126.9890,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090022','Cargeghe','Cargeghe','','NO','B772',40.6674817,8.6160297,11.8350,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090023','Castelsardo','Castelsardo','','NO','C272',40.9158321,8.7132537,43.7875,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090024','Cheremule','Cheremule','','NO','C600',40.5061006,8.7251250,24.6767,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090025','Chiaramonti','Chiaramonti','','NO','C613',40.7517918,8.8199190,98.6865,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090026','Codrongianos','Codrongianos','','NO','C818',40.6581170,8.6800810,30.6171,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090027','Cossoine','Cossoine','','NO','D100',40.4312377,8.7124729,39.0075,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090028','Esporlatu','Esporlatu','','NO','D441',40.3859295,8.9904755,18.4967,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090029','Florinas','Florinas','','NO','D637',40.6480045,8.6654661,36.3706,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090030','Giave','Giave','','NO','E019',40.4520259,8.7505741,46.9926,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090031','Illorai','Illorai','','NO','E285',40.3544020,9.0012141,57.2968,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090032','Ittireddu','Ittireddu','','NO','E376',40.5438976,8.9020994,23.7404,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090033','Ittiri','Ittiri','','NO','E377',40.5941423,8.5688580,111.9759,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090034','Laerru','Laerru','','NO','E401',40.8183747,8.8355973,20.1676,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090035','La Maddalena','La Maddalena','','NO','E425',41.2126688,9.4066497,52.9633,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090036','Luogosanto','Luogosanto','','NO','E747',41.0505932,9.2055237,134.8124,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090037','Luras','Luras','','NO','E752',40.9361480,9.1750280,88.1996,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090038','Mara','Mara','','NO','E902',40.4106317,8.6369344,18.6458,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090039','Martis','Martis','','NO','E992',40.7787323,8.8088208,22.8742,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090040','Monteleone Rocca Doria','Monteleone Rocca Doria','','NO','F542',40.4721766,8.5603377,13.5419,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090041','Monti','Monti','','NO','F667',40.8050645,9.3259302,123.7173,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090042','Mores','Mores','','NO','F721',40.5490558,8.8339124,94.6979,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090043','Muros','Muros','','NO','F818',40.6763612,8.6168701,11.4566,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090044','Nughedu San Nicolò','Nughedu San Nicolò','','NO','F975',40.5564247,9.0219725,67.5119,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090045','Nule','Nule','','NO','F976',40.4608335,9.1873138,51.6780,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090046','Nulvi','Nulvi','','NO','F977',40.7805043,8.7442174,67.4655,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090047','Olbia','Olbia','','NO','G015',40.9230373,9.5048082,385.4385,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090048','Olmedo','Olmedo','','NO','G046',40.6501073,8.3784159,33.7185,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090049','Oschiri','Oschiri','','NO','G153',40.7188338,9.0988878,215.4962,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090050','Osilo','Osilo','','NO','G156',40.7442069,8.6715995,97.7405,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090051','Ossi','Ossi','','NO','G178',40.6751629,8.5916334,30.1370,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090052','Ozieri','Ozieri','','NO','G203',40.5861258,8.9995115,252.7650,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090053','Padria','Padria','','NO','G225',40.3977971,8.6302943,48.4825,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090054','Palau','Palau','','NO','G258',41.1777410,9.3840277,44.7216,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090055','Pattada','Pattada','','NO','G376',40.5828817,9.1119924,164.5307,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090056','Perfugas','Perfugas','','NO','G450',40.8298483,8.8837230,60.9238,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090057','Ploaghe','Ploaghe','','NO','G740',40.6656887,8.7490657,95.7620,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090058','Porto Torres','Porto Torres','','NO','G924',40.8369351,8.4018957,104.5143,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090059','Pozzomaggiore','Pozzomaggiore','','NO','G962',40.3995466,8.6570336,78.8488,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090060','Putifigari','Putifigari','','NO','H095',40.5621937,8.4602723,52.8938,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090061','Romana','Romana','','NO','H507',40.4841261,8.5865093,21.3928,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090062','Aglientu','Aglientu','','NO','H848',41.0813834,9.1127797,148.3581,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090063','Santa Teresa Gallura','Santa Teresa Gallura','','NO','I312',41.2397328,9.1888286,103.3964,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090064','Sassari','Sassari','','SI','I452',40.7265233,8.5592613,547.3165,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090065','Sedini','Sedini','','NO','I565',40.8502792,8.8171559,40.5273,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090066','Semestene','Semestene','','NO','I598',40.3981374,8.7255418,39.4882,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090067','Sennori','Sennori','','NO','I614',40.7880621,8.5954070,31.1034,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090068','Siligo','Siligo','','NO','I732',40.5769515,8.7256421,43.1861,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090069','Sorso','Sorso','','NO','I863',40.7969296,8.5773138,67.0055,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090070','Tempio Pausania','Tempio Pausania','','NO','L093',40.9030138,9.1036300,210.5560,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090071','Thiesi','Thiesi','','NO','L158',40.5216887,8.7205896,63.1137,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090072','Tissi','Tissi','','NO','L180',40.6791358,8.5619721,10.2203,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090073','Torralba','Torralba','','NO','L235',40.5142045,8.7620078,36.3386,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090074','Trinità d\'Agultu e Vignola','Trinità d\'Agultu e Vignola','','NO','L428',40.9854201,8.9139638,134.0923,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090075','Tula','Tula','','NO','L464',40.7336608,8.9867205,66.2784,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090076','Uri','Uri','','NO','L503',40.6380340,8.4856063,56.7643,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090077','Usini','Usini','','NO','L509',40.6636665,8.5406397,30.6058,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090078','Villanova Monteleone','Villanova Monteleone','','NO','L989',40.5035184,8.4704378,202.5996,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090079','Valledoria','Valledoria','','NO','L604',40.9273145,8.8230888,25.3739,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090080','Telti','Telti','','NO','L088',40.8762056,9.3529714,83.3583,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090081','Badesi','Badesi','','NO','M214',40.9682101,8.8789760,31.4632,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090082','Viddalba','Viddalba','','NO','M259',40.9168458,8.8945467,50.3657,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090083','Golfo Aranci','Golfo Aranci','','NO','M274',41.0014374,9.6223253,37.2703,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090084','Loiri Porto San Paolo','Loiri Porto San Paolo','','NO','M275',40.8419559,9.4978587,118.5158,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090085','Sant\'Antonio di Gallura','Sant\'Antonio di Gallura','','NO','M276',40.9909629,9.3013017,81.3029,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090086','Tergu','Tergu','','NO','M282',40.8628464,8.7123773,36.7250,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090087','Santa Maria Coghinas','Santa Maria Coghinas','','NO','M284',40.9042188,8.8631162,23.4126,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090088','Erula','Erula','','NO','M292',40.7914980,8.9441479,39.3701,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090089','Stintino','Stintino','','NO','M290',40.9372021,8.2241665,59.0931,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090090','Padru','Padru','','NO','M301',40.7669937,9.5226021,158.0559,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090091','Budoni','Budoni','','NO','B248',40.7066909,9.6997840,56.2221,'090');
INSERT INTO `gi_comuni` VALUES ('SS','090092','San Teodoro','San Teodoro','','NO','I329',40.7719443,9.6720751,105.0422,'090');
INSERT INTO `gi_comuni` VALUES ('NU','091001','Aritzo','Aritzo','','NO','A407',39.9574052,9.1963677,75.1827,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091002','Arzana','Arzana','','NO','A454',39.9185907,9.5286247,162.7551,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091003','Atzara','Atzara','','NO','A492',39.9916032,9.0762558,35.9520,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091004','Austis','Austis','','NO','A503',40.0711880,9.0904981,50.7483,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091005','Bari Sardo','Bari Sardo','','NO','A663',39.8402169,9.6449392,37.6252,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091006','Baunei','Baunei','','NO','A722',40.0315279,9.6635730,212.1102,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091007','Belvì','Belvì','','NO','A776',39.9604304,9.1844284,18.2857,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091008','Birori','Birori','','NO','A880',40.2660941,8.8155369,17.2688,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091009','Bitti','Bitti','','NO','A895',40.4748367,9.3813085,215.6329,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091010','Bolotana','Bolotana','','NO','A948',40.3275503,8.9587621,108.4147,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091011','Borore','Borore','','NO','B056',40.2154670,8.8035463,42.6400,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091012','Bortigali','Bortigali','','NO','B062',40.2828788,8.8367869,67.3199,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091016','Desulo','Desulo','','NO','D287',40.0111745,9.2287223,74.4912,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091017','Dorgali','Dorgali','','NO','D345',40.2891998,9.5881763,226.4556,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091018','Dualchi','Dualchi','','NO','D376',40.2303524,8.9001553,23.2240,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091019','Elini','Elini','','NO','D395',39.9000010,9.5312673,11.0154,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091024','Fonni','Fonni','','NO','D665',40.1198167,9.2522737,111.9435,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091025','Gadoni','Gadoni','','NO','D842',39.9129897,9.1840200,43.6913,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091026','Gairo','Gairo','','NO','D859',39.8477909,9.5060900,77.9533,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091027','Galtellì','Galtellì','','NO','D888',40.3867774,9.6170833,56.2449,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091028','Gavoi','Gavoi','','NO','D947',40.1587402,9.1949394,38.1416,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091031','Girasole','Girasole','','NO','E049',39.9499913,9.6617752,13.0996,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091032','Ilbono','Ilbono','','NO','E283',39.8935446,9.5412574,30.6940,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091033','Irgoli','Irgoli','','NO','E323',40.4091823,9.6306960,75.1924,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091035','Jerzu','Jerzu','','NO','E387',39.7934315,9.5171035,102.2460,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091037','Lanusei','Lanusei','','NO','E441',39.8767694,9.5423161,53.0246,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091038','Lei','Lei','','NO','E517',40.3073635,8.9201235,18.9689,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091039','Loceri','Loceri','','NO','E644',39.8561789,9.5829299,19.4307,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091040','Loculi','Loculi','','NO','E646',40.4066293,9.6111014,38.2054,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091041','Lodè','Lodè','','NO','E647',40.5907790,9.5411170,122.9840,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091042','Lotzorai','Lotzorai','','NO','E700',39.9693149,9.6625836,16.8982,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091043','Lula','Lula','','NO','E736',40.4710897,9.4848597,148.3524,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091044','Macomer','Macomer','','NO','E788',40.2652637,8.7816691,122.6579,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091046','Mamoiada','Mamoiada','','NO','E874',40.2127472,9.2840788,49.1188,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091047','Meana Sardo','Meana Sardo','','NO','F073',39.9450361,9.0720208,73.5623,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091050','Noragugume','Noragugume','','NO','F933',40.2244816,8.9197501,26.6769,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091051','Nuoro','Nuoro','','SI','F979',40.3233328,9.3310574,192.3949,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091055','Oliena','Oliena','','NO','G031',40.2712485,9.4059811,166.0006,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091056','Ollolai','Ollolai','','NO','G044',40.1688210,9.1798885,27.0576,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091057','Olzai','Olzai','','NO','G058',40.1825216,9.1485630,69.6841,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091058','Onanì','Onanì','','NO','G064',40.4842909,9.4406896,72.2646,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091059','Onifai','Onifai','','NO','G070',40.4074761,9.6513177,43.3919,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091060','Oniferi','Oniferi','','NO','G071',40.2720006,9.1702746,35.7414,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091061','Orani','Orani','','NO','G084',40.2500756,9.1773546,129.9487,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091062','Orgosolo','Orgosolo','','NO','G097',40.2060313,9.3542967,222.5267,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091063','Orosei','Orosei','','NO','G119',40.3775732,9.6975731,90.9812,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091064','Orotelli','Orotelli','','NO','G120',40.3027481,9.1122974,61.4669,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091066','Ortueri','Ortueri','','NO','G146',40.0362435,8.9854523,38.7906,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091067','Orune','Orune','','NO','G147',40.4058788,9.3699717,128.2488,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091068','Osidda','Osidda','','NO','G154',40.5239688,9.2188584,26.0002,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091069','Osini','Osini','','NO','G158',39.8222848,9.4972066,39.5498,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091070','Ottana','Ottana','','NO','G191',40.2348697,9.0463516,45.3419,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091071','Ovodda','Ovodda','','NO','G201',40.0961338,9.1613036,40.8453,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091072','Perdasdefogu','Perdasdefogu','','NO','G445',39.6779621,9.4413391,78.0903,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091073','Posada','Posada','','NO','G929',40.6329286,9.7177774,33.0856,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091077','Sarule','Sarule','','NO','I448',40.2287166,9.1662131,52.5405,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091083','Silanus','Silanus','','NO','I730',40.2903694,8.8894473,48.1514,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091084','Sindia','Sindia','','NO','I748',40.2957950,8.6594559,58.8185,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091085','Siniscola','Siniscola','','NO','I751',40.5736604,9.6948884,196.8252,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091086','Sorgono','Sorgono','','NO','I851',40.0278091,9.1037459,55.9871,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091088','Talana','Talana','','NO','L036',40.0410662,9.4970216,118.7005,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091089','Tertenia','Tertenia','','NO','L140',39.6968893,9.5772222,117.7256,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091090','Teti','Teti','','NO','L153',40.0963489,9.1177740,44.1337,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091091','Tiana','Tiana','','NO','L160',40.0674316,9.1490307,19.0630,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091093','Tonara','Tonara','','NO','L202',40.0246859,9.1735533,52.2172,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091094','Torpè','Torpè','','NO','L231',40.6285523,9.6785174,92.3598,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091095','Tortolì','Tortolì','','NO','A355',39.9263329,9.6562323,40.4156,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091097','Triei','Triei','','NO','L423',40.0376735,9.6403947,32.8492,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091098','Ulassai','Ulassai','','NO','L489',39.8115257,9.4999928,122.3609,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091099','Urzulei','Urzulei','','NO','L506',40.0918873,9.5055061,129.6323,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091100','Ussassai','Ussassai','','NO','L514',39.8098040,9.3940859,47.4295,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091101','Villagrande Strisaili','Villagrande Strisaili','','NO','L953',39.9608797,9.5058374,210.2386,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091103','Cardedu','Cardedu','','NO','M285',39.7958404,9.6250604,33.4594,'091');
INSERT INTO `gi_comuni` VALUES ('NU','091104','Lodine','Lodine','','NO','E649',40.1477574,9.2194270,7.8026,'091');
INSERT INTO `gi_comuni` VALUES ('CA','092003','Assemini','Assemini','','NO','A474',39.2896239,9.0064108,118.3218,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092009','Cagliari','Cagliari','','SI','B354',39.2152268,9.1106174,84.9156,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092011','Capoterra','Capoterra','','NO','B675',39.1738289,8.9743512,68.3273,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092015','Decimomannu','Decimomannu','','NO','D259',39.3112283,8.9659473,27.9950,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092037','Maracalagonis','Maracalagonis','','NO','E903',39.2848068,9.2284156,101.9098,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092050','Pula','Pula','','NO','H088',39.0108695,9.0004006,138.8054,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092051','Quartu Sant\'Elena','Quartu Sant\'Elena','','NO','H118',39.2409207,9.1853448,96.1551,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092066','Sarroch','Sarroch','','NO','I443',39.0635271,9.0116008,68.3268,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092068','Selargius','Selargius','','NO','I580',39.2537196,9.1651890,26.6759,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092074','Sestu','Sestu','','NO','I695',39.2998158,9.0921102,48.3672,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092075','Settimo San Pietro','Settimo San Pietro','','NO','I699',39.2916869,9.1840736,23.0848,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092080','Sinnai','Sinnai','','NO','I752',39.2968627,9.2059574,224.0890,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092090','Uta','Uta','','NO','L521',39.2918858,8.9541303,134.5601,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092099','Villa San Pietro','Villa San Pietro','','NO','I118',39.0334279,8.9950738,40.2756,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092105','Quartucciu','Quartucciu','','NO','H119',39.2539502,9.1802767,27.7490,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092108','Elmas','Elmas','','NO','D399',39.2707024,9.0490807,14.0078,'292');
INSERT INTO `gi_comuni` VALUES ('CA','092109','Monserrato','Monserrato','','NO','F383',39.2590950,9.1375189,6.5140,'292');
INSERT INTO `gi_comuni` VALUES ('PN','093001','Andreis','Andreis','','NO','A283',46.2018822,12.6145355,27.1496,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093002','Arba','Arba','','NO','A354',46.1462206,12.7905022,15.4566,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093004','Aviano','Aviano','','NO','A516',46.0670312,12.5883503,113.3703,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093005','Azzano Decimo','Azzano Decimo','','NO','A530',45.8810710,12.7148590,51.5640,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093006','Barcis','Barcis','','NO','A640',46.1910542,12.5600577,103.5713,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093007','Brugnera','Brugnera','','NO','B215',45.8991158,12.5367092,29.3553,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093008','Budoia','Budoia','','NO','B247',46.0427509,12.5322553,37.2530,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093009','Caneva','Caneva','','NO','B598',45.9688455,12.4489172,41.8896,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093010','Casarsa della Delizia','Casarsa della Delizia','','NO','B940',45.9570701,12.8421526,20.5343,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093011','Castelnovo del Friuli','Castelnovo del Friuli','','NO','C217',46.1998527,12.9032116,22.6638,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093012','Cavasso Nuovo','Cavasso Nuovo','','NO','C385',46.1948477,12.7713806,10.6174,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093013','Chions','Chions','','NO','C640',45.8623672,12.7524155,33.1289,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093014','Cimolais','Cimolais','','NO','C699',46.2880889,12.4378051,100.9842,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093015','Claut','Claut','','NO','C790',46.2675228,12.5136560,165.9270,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093016','Clauzetto','Clauzetto','','NO','C791',46.2300810,12.9170536,28.7216,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093017','Cordenons','Cordenons','','NO','C991',45.9885428,12.7075933,56.4599,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093018','Cordovado','Cordovado','','NO','C993',45.8499475,12.8824814,12.1281,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093019','Erto e Casso','Erto e Casso','','NO','D426',46.2784511,12.3727673,52.2407,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093020','Fanna','Fanna','','NO','D487',46.1878686,12.7545229,10.2610,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093021','Fiume Veneto','Fiume Veneto','','NO','D621',45.9281652,12.7345360,35.3646,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093022','Fontanafredda','Fontanafredda','','NO','D670',45.9886791,12.5477521,46.3488,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093024','Frisanco','Frisanco','','NO','D804',46.2127524,12.7235961,60.8178,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093025','Maniago','Maniago','','NO','E889',46.1707520,12.7079941,69.2116,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093026','Meduno','Meduno','','NO','F089',46.2176164,12.7884747,31.8794,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093027','Montereale Valcellina','Montereale Valcellina','','NO','F596',46.1551869,12.6562713,67.6997,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093028','Morsano al Tagliamento','Morsano al Tagliamento','','NO','F750',45.8583120,12.9290204,32.3080,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093029','Pasiano di Pordenone','Pasiano di Pordenone','','NO','G353',45.8515717,12.6278570,45.4905,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093030','Pinzano al Tagliamento','Pinzano al Tagliamento','','NO','G680',46.1829797,12.9462277,21.6266,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093031','Polcenigo','Polcenigo','','NO','G780',46.0303242,12.5018028,49.8980,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093032','Porcia','Porcia','','NO','G886',45.9580573,12.6115006,29.3547,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093033','Pordenone','Pordenone','','SI','G888',45.9541959,12.6600751,38.3996,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093034','Prata di Pordenone','Prata di Pordenone','','NO','G994',45.8943238,12.5968116,22.8561,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093035','Pravisdomini','Pravisdomini','','NO','H010',45.8178502,12.6931706,16.5656,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093036','Roveredo in Piano','Roveredo in Piano','','NO','H609',46.0092917,12.6181222,15.8861,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093037','Sacile','Sacile','','NO','H657',45.9544236,12.5028836,32.9166,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093038','San Giorgio della Richinvelda','San Giorgio della Richinvelda','','NO','H891',46.0455288,12.8666077,47.9249,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093039','San Martino al Tagliamento','San Martino al Tagliamento','','NO','H999',46.0209766,12.8639794,17.9430,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093040','San Quirino','San Quirino','','NO','I136',46.0365688,12.6806520,51.5827,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093041','San Vito al Tagliamento','San Vito al Tagliamento','','NO','I403',45.9156105,12.8554146,60.9353,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093042','Sequals','Sequals','','NO','I621',46.1654092,12.8277766,27.5259,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093043','Sesto al Reghena','Sesto al Reghena','','NO','I686',45.8482366,12.8159022,40.2229,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093044','Spilimbergo','Spilimbergo','','NO','I904',46.1122448,12.9057541,72.0445,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093045','Tramonti di Sopra','Tramonti di Sopra','','NO','L324',46.3098226,12.7896173,124.8185,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093046','Tramonti di Sotto','Tramonti di Sotto','','NO','L325',46.2851408,12.7956145,85.7923,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093047','Travesio','Travesio','','NO','L347',46.1959902,12.8709116,28.2695,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093049','Vito d\'Asio','Vito d\'Asio','','NO','M085',46.2333381,12.9586269,53.5289,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093050','Vivaro','Vivaro','','NO','M096',46.0781082,12.7755920,37.6422,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093051','Zoppola','Zoppola','','NO','M190',45.9659814,12.7722381,45.4898,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093052','Vajont','Vajont','','NO','M265',46.1462734,12.6978451,1.6865,'093');
INSERT INTO `gi_comuni` VALUES ('PN','093053','Valvasone Arzene','Valvasone Arzene','','NO','M346',45.9962529,12.8619335,29.5801,'093');
INSERT INTO `gi_comuni` VALUES ('IS','094001','Acquaviva d\'Isernia','Acquaviva d\'Isernia','','NO','A051',41.6712663,14.1497435,13.4534,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094002','Agnone','Agnone','','NO','A080',41.8062197,14.3668467,96.3473,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094003','Bagnoli del Trigno','Bagnoli del Trigno','','NO','A567',41.7042336,14.4581096,36.9647,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094004','Belmonte del Sannio','Belmonte del Sannio','','NO','A761',41.8251165,14.4235884,20.6011,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094005','Cantalupo nel Sannio','Cantalupo nel Sannio','','NO','B630',41.5218442,14.3921665,15.9042,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094006','Capracotta','Capracotta','','NO','B682',41.8339090,14.2642223,42.4927,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094007','Carovilli','Carovilli','','NO','B810',41.7132931,14.2950481,41.9002,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094008','Carpinone','Carpinone','','NO','B830',41.5881276,14.3270254,32.3020,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094009','Castel del Giudice','Castel del Giudice','','NO','C082',41.8541623,14.2317792,15.1132,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094010','Castelpetroso','Castelpetroso','','NO','C246',41.5591435,14.3454790,22.8018,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094011','Castelpizzuto','Castelpizzuto','','NO','C247',41.5214584,14.2926432,15.4156,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094012','Castel San Vincenzo','Castel San Vincenzo','','NO','C270',41.6550789,14.0631844,21.8621,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094013','Castelverrino','Castelverrino','','NO','C200',41.7683845,14.3974362,6.3805,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094014','Cerro al Volturno','Cerro al Volturno','','NO','C534',41.6539464,14.1029427,23.8002,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094015','Chiauci','Chiauci','','NO','C620',41.6779420,14.3855333,15.5837,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094016','Civitanova del Sannio','Civitanova del Sannio','','NO','C769',41.6678067,14.4036339,50.1595,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094017','Colli a Volturno','Colli a Volturno','','NO','C878',41.5992215,14.1034325,25.1146,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094018','Conca Casale','Conca Casale','','NO','C941',41.4942120,14.0066611,14.8027,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094019','Filignano','Filignano','','NO','D595',41.5453277,14.0561852,30.8707,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094020','Forlì del Sannio','Forlì del Sannio','','NO','D703',41.6952319,14.1812608,32.3504,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094021','Fornelli','Fornelli','','NO','D715',41.6057627,14.1409222,23.2144,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094022','Frosolone','Frosolone','','NO','D811',41.6013771,14.4498773,49.7628,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094023','Isernia','Isernia','','SI','E335',41.5875657,14.2260998,68.8032,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094024','Longano','Longano','','NO','E669',41.5217511,14.2464643,27.4988,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094025','Macchia d\'Isernia','Macchia d\'Isernia','','NO','E778',41.5624695,14.1673858,17.6016,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094026','Macchiagodena','Macchiagodena','','NO','E779',41.5596172,14.4057652,34.2413,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094027','Miranda','Miranda','','NO','F239',41.6414241,14.2481979,22.2112,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094028','Montaquila','Montaquila','','NO','F429',41.5661086,14.1170292,25.5795,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094029','Montenero Val Cocchiara','Montenero Val Cocchiara','','NO','F580',41.7148090,14.0658789,22.1477,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094030','Monteroduni','Monteroduni','','NO','F601',41.5226019,14.1756988,37.4332,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094031','Pesche','Pesche','','NO','G486',41.6109746,14.2817871,12.8459,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094032','Pescolanciano','Pescolanciano','','NO','G495',41.6787216,14.3368036,34.5289,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094033','Pescopennataro','Pescopennataro','','NO','G497',41.8780199,14.2947985,18.7442,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094034','Pettoranello del Molise','Pettoranello del Molise','','NO','G523',41.5732635,14.2771671,15.6957,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094035','Pietrabbondante','Pietrabbondante','','NO','G606',41.7486663,14.3874472,27.4381,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094036','Pizzone','Pizzone','','NO','G727',41.6668258,14.0357337,33.3437,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094037','Poggio Sannita','Poggio Sannita','','NO','B317',41.7790466,14.4137280,25.6228,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094038','Pozzilli','Pozzilli','','NO','G954',41.5001153,14.0927389,34.3966,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094039','Rionero Sannitico','Rionero Sannitico','','NO','H308',41.7122198,14.1397722,29.6069,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094040','Roccamandolfi','Roccamandolfi','','NO','H420',41.4929276,14.3492952,53.4705,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094041','Roccasicura','Roccasicura','','NO','H445',41.6982861,14.2315480,28.6816,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094042','Rocchetta a Volturno','Rocchetta a Volturno','','NO','H458',41.6242163,14.0857487,23.3309,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094043','San Pietro Avellana','San Pietro Avellana','','NO','I096',41.7886068,14.1837398,44.6682,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094044','Sant\'Agapito','Sant\'Agapito','','NO','I189',41.5437397,14.2216791,15.9640,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094045','Santa Maria del Molise','Santa Maria del Molise','','NO','I238',41.5524276,14.3708003,17.0676,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094046','Sant\'Angelo del Pesco','Sant\'Angelo del Pesco','','NO','I282',41.8830173,14.2556138,15.6562,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094047','Sant\'Elena Sannita','Sant\'Elena Sannita','','NO','B466',41.5764350,14.4716510,13.9331,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094048','Scapoli','Scapoli','','NO','I507',41.6152943,14.0588035,19.0558,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094049','Sessano del Molise','Sessano del Molise','','NO','I679',41.6382378,14.3319021,25.6013,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094050','Sesto Campano','Sesto Campano','','NO','I682',41.4212701,14.0769995,35.3365,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094051','Vastogirardi','Vastogirardi','','NO','L696',41.7742152,14.2595877,60.8071,'094');
INSERT INTO `gi_comuni` VALUES ('IS','094052','Venafro','Venafro','','NO','L725',41.4857263,14.0450786,46.6125,'094');
INSERT INTO `gi_comuni` VALUES ('OR','095001','Abbasanta','Abbasanta','','NO','A007',40.1238434,8.8210489,39.8155,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095002','Aidomaggiore','Aidomaggiore','','NO','A097',40.1717081,8.8562723,41.2362,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095003','Albagiara','Albagiara','','NO','A126',39.7885562,8.8602779,9.1697,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095004','Ales','Ales','','NO','A180',39.7691496,8.8159032,22.2043,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095005','Allai','Allai','','NO','A204',39.9581021,8.8600076,27.4814,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095006','Arborea','Arborea','','NO','A357',39.7744121,8.5819723,94.6679,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095007','Ardauli','Ardauli','','NO','A380',40.0815395,8.9111149,20.5644,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095008','Assolo','Assolo','','NO','A477',39.8098835,8.9165607,16.3373,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095009','Asuni','Asuni','','NO','A480',39.8717717,8.9480564,21.3275,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095010','Baradili','Baradili','','NO','A614',39.7225638,8.8978409,5.6376,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095011','Baratili San Pietro','Baratili San Pietro','','NO','A621',39.9931850,8.5550983,6.0017,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095012','Baressa','Baressa','','NO','A655',39.7147871,8.8742774,12.5369,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095013','Bauladu','Bauladu','','NO','A721',40.0198633,8.6711834,23.8997,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095014','Bidonì','Bidonì','','NO','A856',40.1130278,8.9348896,11.7746,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095015','Bonarcado','Bonarcado','','NO','A960',40.1012502,8.6546871,28.1862,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095016','Boroneddu','Boroneddu','','NO','B055',40.1125575,8.8699410,4.7191,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095017','Busachi','Busachi','','NO','B281',40.0333248,8.8978064,58.9103,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095018','Cabras','Cabras','','NO','B314',39.9299854,8.5314064,101.9826,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095019','Cuglieri','Cuglieri','','NO','D200',40.1897247,8.5682600,120.2139,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095020','Fordongianus','Fordongianus','','NO','D695',39.9949645,8.8080290,39.1001,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095021','Ghilarza','Ghilarza','','NO','E004',40.1210995,8.8348298,54.7792,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095022','Gonnoscodina','Gonnoscodina','','NO','E087',39.7015264,8.8357502,8.8355,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095023','Gonnosnò','Gonnosnò','','NO','D585',39.7615408,8.8675516,15.4039,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095024','Gonnostramatza','Gonnostramatza','','NO','E088',39.6800843,8.8315492,17.7951,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095025','Marrubiu','Marrubiu','','NO','E972',39.7493164,8.6363514,61.3844,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095026','Masullas','Masullas','','NO','F050',39.7003920,8.7851162,18.7094,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095027','Milis','Milis','','NO','F208',40.0492136,8.6373456,18.7948,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095028','Mogorella','Mogorella','','NO','F270',39.8628850,8.8582116,17.2504,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095029','Mogoro','Mogoro','','NO','F272',39.6841476,8.7743671,48.7775,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095030','Morgongiori','Morgongiori','','NO','F727',39.7469189,8.7686309,45.1188,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095031','Narbolia','Narbolia','','NO','F840',40.0475024,8.5752053,40.4584,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095032','Neoneli','Neoneli','','NO','F867',40.0660585,8.9463242,47.7691,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095033','Norbello','Norbello','','NO','F934',40.1335419,8.8323518,26.2796,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095034','Nughedu Santa Vittoria','Nughedu Santa Vittoria','','NO','F974',40.1019741,8.9538537,28.5185,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095035','Nurachi','Nurachi','','NO','F980',39.9733736,8.5396504,16.0416,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095036','Nureci','Nureci','','NO','F985',39.8244030,8.9740720,13.1272,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095037','Ollastra','Ollastra','','NO','G043',39.9514226,8.7348029,21.6227,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095038','Oristano','Oristano','','SI','G113',39.9039737,8.5911783,84.5703,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095039','Palmas Arborea','Palmas Arborea','','NO','G286',39.8769686,8.6463780,39.4513,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095040','Pau','Pau','','NO','G379',39.7921861,8.8031487,13.8817,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095041','Paulilatino','Paulilatino','','NO','G384',40.0864617,8.7605242,104.3258,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095042','Pompu','Pompu','','NO','G817',39.7248476,8.7955930,5.3831,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095043','Riola Sardo','Riola Sardo','','NO','H301',39.9964986,8.5385558,47.9381,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095044','Ruinas','Ruinas','','NO','F271',39.9057400,8.8966102,30.5852,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095045','Samugheo','Samugheo','','NO','H756',39.9470925,8.9396509,81.5300,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095046','San Nicolò d\'Arcidano','San Nicolò d\'Arcidano','','NO','A368',39.6852137,8.6468396,28.2230,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095047','Santa Giusta','Santa Giusta','','NO','I205',39.8781643,8.6082351,69.4534,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095048','Villa Sant\'Antonio','Villa Sant\'Antonio','','NO','I298',39.8575439,8.9008525,18.6929,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095049','Santu Lussurgiu','Santu Lussurgiu','','NO','I374',40.1401234,8.6509893,99.9073,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095050','San Vero Milis','San Vero Milis','','NO','I384',40.0110419,8.5986588,72.3759,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095051','Scano di Montiferro','Scano di Montiferro','','NO','I503',40.2161983,8.5843363,60.4645,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095052','Sedilo','Sedilo','','NO','I564',40.1747798,8.9211943,68.5187,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095053','Seneghe','Seneghe','','NO','I605',40.0805900,8.6117019,57.8092,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095054','Senis','Senis','','NO','I609',39.8214774,8.9397785,16.2381,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095055','Sennariolo','Sennariolo','','NO','I613',40.2121563,8.5551414,15.8381,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095056','Siamaggiore','Siamaggiore','','NO','I717',39.9484300,8.6365181,13.1321,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095057','Siamanna','Siamanna','','NO','I718',39.9198002,8.7596474,28.3448,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095058','Simala','Simala','','NO','I742',39.7194085,8.8293263,13.3464,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095059','Simaxis','Simaxis','','NO','I743',39.9311084,8.6888822,27.7352,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095060','Sini','Sini','','NO','I749',39.7525136,8.9065259,8.8515,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095061','Siris','Siris','','NO','I757',39.7117334,8.7762070,6.0689,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095062','Solarussa','Solarussa','','NO','I791',39.9530506,8.6707212,31.7647,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095063','Sorradile','Sorradile','','NO','I861',40.1065981,8.9326614,26.4828,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095064','Tadasuni','Tadasuni','','NO','L023',40.1106074,8.8826147,5.1496,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095065','Terralba','Terralba','','NO','L122',39.7201551,8.6361824,49.7337,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095066','Tramatza','Tramatza','','NO','L321',40.0028094,8.6486680,16.9477,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095067','Tresnuraghes','Tresnuraghes','','NO','L393',40.2508580,8.5188213,31.3996,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095068','Ulà Tirso','Ulà Tirso','','NO','L488',40.0446665,8.9057370,19.1827,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095069','Uras','Uras','','NO','L496',39.6984062,8.7012158,39.2666,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095070','Usellus','Usellus','','NO','L508',39.8060527,8.8528945,35.1174,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095071','Villanova Truschedu','Villanova Truschedu','','NO','L991',39.9895651,8.7527057,16.6183,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095072','Villaurbana','Villaurbana','','NO','M030',39.8864090,8.7775648,58.7328,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095073','Villa Verde','Villa Verde','','NO','A609',39.7942850,8.8199365,17.6789,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095074','Zeddiani','Zeddiani','','NO','M153',39.9895986,8.5957140,12.0524,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095075','Zerfaliu','Zerfaliu','','NO','M168',39.9575251,8.7056300,15.7513,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095076','Siapiccia','Siapiccia','','NO','I721',39.9265073,8.7620649,17.8311,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095077','Curcuris','Curcuris','','NO','D214',39.7462372,8.8316646,7.2083,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095078','Soddì','Soddì','','NO','I778',40.1280581,8.8767570,5.4929,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095079','Bosa','Bosa','','NO','B068',40.2990825,8.4978472,128.3954,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095080','Flussio','Flussio','','NO','D640',40.2666787,8.5410670,6.7159,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095082','Laconi','Laconi','','NO','E400',39.8538607,9.0521702,124.6461,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095083','Magomadas','Magomadas','','NO','E825',40.2640913,8.5257138,9.0335,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095084','Modolo','Modolo','','NO','F261',40.2737852,8.5274457,2.6162,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095085','Montresta','Montresta','','NO','F698',40.3739970,8.4996685,31.4672,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095086','Sagama','Sagama','','NO','H661',40.2607993,8.5779657,11.8501,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095087','Suni','Suni','','NO','L006',40.2801903,8.5504438,47.3012,'095');
INSERT INTO `gi_comuni` VALUES ('OR','095088','Tinnura','Tinnura','','NO','L172',40.2689656,8.5483145,3.8266,'095');
INSERT INTO `gi_comuni` VALUES ('BI','096001','Ailoche','Ailoche','','NO','A107',45.6980330,8.2203728,10.6328,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096002','Andorno Micca','Andorno Micca','','NO','A280',45.6155995,8.0532934,11.8006,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096003','Benna','Benna','','NO','A784',45.5124344,8.1250813,9.3772,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096004','Biella','Biella','','SI','A859',45.5665653,8.0538009,46.2028,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096005','Bioglio','Bioglio','','NO','A876',45.6075942,8.1302895,18.7685,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096006','Borriana','Borriana','','NO','B058',45.5059818,8.0395926,5.6089,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096007','Brusnengo','Brusnengo','','NO','B229',45.5960995,8.2525705,10.2075,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096008','Callabiana','Callabiana','','NO','B417',45.6337147,8.0907494,6.3149,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096009','Camandona','Camandona','','NO','B457',45.6416371,8.0999946,9.0332,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096010','Camburzano','Camburzano','','NO','B465',45.5441956,8.0032675,3.8031,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096012','Candelo','Candelo','','NO','B586',45.5461774,8.1127386,15.2087,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096013','Caprile','Caprile','','NO','B708',45.6929104,8.2129569,11.2608,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096014','Casapinta','Casapinta','','NO','B933',45.6150183,8.1933864,2.8668,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096015','Castelletto Cervo','Castelletto Cervo','','NO','C155',45.5189723,8.2251079,15.0262,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096016','Cavaglià','Cavaglià','','NO','C363',45.4057988,8.0935282,25.4060,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096018','Cerrione','Cerrione','','NO','C532',45.4808140,8.0740403,28.2783,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096019','Coggiola','Coggiola','','NO','C819',45.6844872,8.1851614,23.8620,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096020','Cossato','Cossato','','NO','D094',45.5701108,8.1805973,27.8485,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096021','Crevacuore','Crevacuore','','NO','D165',45.6858091,8.2471924,8.7256,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096023','Curino','Curino','','NO','D219',45.6277452,8.2358752,21.3990,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096024','Donato','Donato','','NO','D339',45.5282951,7.9074963,11.7421,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096025','Dorzano','Dorzano','','NO','D350',45.4252355,8.0969585,4.9475,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096026','Gaglianico','Gaglianico','','NO','D848',45.5392903,8.0748078,4.4024,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096027','Gifflenga','Gifflenga','','NO','E024',45.4932607,8.2316110,2.3605,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096028','Graglia','Graglia','','NO','E130',45.5580809,7.9812834,20.2410,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096030','Magnano','Magnano','','NO','E821',45.4627413,8.0050937,10.3599,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096031','Massazza','Massazza','','NO','F037',45.4920633,8.1651997,11.6686,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096032','Masserano','Masserano','','NO','F042',45.5958238,8.2226511,27.1345,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096033','Mezzana Mortigliengo','Mezzana Mortigliengo','','NO','F167',45.6252619,8.1886984,4.2789,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096034','Miagliano','Miagliano','','NO','F189',45.6141585,8.0437762,0.7910,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096035','Mongrando','Mongrando','','NO','F369',45.5192620,8.0072400,16.1830,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096037','Mottalciata','Mottalciata','','NO','F776',45.5083671,8.2078734,18.2088,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096038','Muzzano','Muzzano','','NO','F833',45.5606719,7.9864713,6.2464,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096039','Netro','Netro','','NO','F878',45.5379889,7.9478896,12.9390,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096040','Occhieppo Inferiore','Occhieppo Inferiore','','NO','F992',45.5531805,8.0225656,3.9994,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096041','Occhieppo Superiore','Occhieppo Superiore','','NO','F993',45.5646904,8.0040775,4.9678,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096042','Pettinengo','Pettinengo','','NO','G521',45.6131155,8.1056446,15.1443,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096043','Piatto','Piatto','','NO','G577',45.5917923,8.1351752,3.5993,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096044','Piedicavallo','Piedicavallo','','NO','G594',45.6896600,7.9557364,17.6409,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096046','Pollone','Pollone','','NO','G798',45.5835955,8.0010161,16.4302,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096047','Ponderano','Ponderano','','NO','G820',45.5385081,8.0568100,7.1060,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096048','Portula','Portula','','NO','G927',45.6753478,8.1791676,11.1967,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096049','Pralungo','Pralungo','','NO','G980',45.5908963,8.0381100,7.2758,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096050','Pray','Pray','','NO','G974',45.6761271,8.2087311,9.3153,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096053','Ronco Biellese','Ronco Biellese','','NO','H538',45.5816115,8.0988092,3.9888,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096054','Roppolo','Roppolo','','NO','H553',45.4203830,8.0686496,8.5179,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096055','Rosazza','Rosazza','','NO','H561',45.6762006,7.9774465,9.1754,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096056','Sagliano Micca','Sagliano Micca','','NO','H662',45.6228634,8.0452978,14.3057,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096057','Sala Biellese','Sala Biellese','','NO','H681',45.5083493,7.9554536,8.1203,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096058','Salussola','Salussola','','NO','H726',45.4493194,8.1088759,38.3773,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096059','Sandigliano','Sandigliano','','NO','H821',45.5214764,8.0759985,10.2483,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096063','Sordevolo','Sordevolo','','NO','I847',45.5715416,7.9752732,13.7932,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096064','Sostegno','Sostegno','','NO','I868',45.6536011,8.2691035,18.3959,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096065','Strona','Strona','','NO','I980',45.6207039,8.1692727,3.9315,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096066','Tavigliano','Tavigliano','','NO','L075',45.6234060,8.0534063,11.3329,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096067','Ternengo','Ternengo','','NO','L116',45.5901348,8.1149281,1.8075,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096068','Tollegno','Tollegno','','NO','L193',45.5944224,8.0532492,3.3556,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096069','Torrazzo','Torrazzo','','NO','L239',45.4981102,7.9554548,5.6421,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096071','Valdengo','Valdengo','','NO','L556',45.5708118,8.1361905,7.8906,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096072','Vallanzengo','Vallanzengo','','NO','L586',45.6035658,8.1483039,4.6289,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096074','Valle San Nicolao','Valle San Nicolao','','NO','L620',45.6070330,8.1410595,12.9078,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096075','Veglio','Veglio','','NO','L712',45.6400214,8.1141356,6.8284,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096076','Verrone','Verrone','','NO','L785',45.5027485,8.1168102,8.4266,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096077','Vigliano Biellese','Vigliano Biellese','','NO','L880',45.5621001,8.1098516,8.2724,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096078','Villa del Bosco','Villa del Bosco','','NO','L933',45.6202542,8.2825654,3.9132,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096079','Villanova Biellese','Villanova Biellese','','NO','L978',45.4827272,8.1927205,7.8399,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096080','Viverone','Viverone','','NO','M098',45.4256108,8.0506566,12.0918,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096081','Zimone','Zimone','','NO','M179',45.4494705,8.0373284,3.1530,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096082','Zubiena','Zubiena','','NO','M196',45.4927873,7.9973532,12.6231,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096083','Zumaglia','Zumaglia','','NO','M201',45.5947498,8.0886722,2.8020,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096085','Lessona','Lessona','','NO','M371',45.5913214,8.1962551,12.8926,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096086','Campiglia Cervo','Campiglia Cervo','','NO','M373',45.6631238,7.9983769,28.2054,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096087','Quaregna Cerreto','Quaregna Cerreto','','NO','M414',45.5763656,8.1647575,8.5504,'096');
INSERT INTO `gi_comuni` VALUES ('BI','096088','Valdilana','Valdilana','','NO','M417',45.6645239,8.1611371,61.0463,'096');
INSERT INTO `gi_comuni` VALUES ('LC','097001','Abbadia Lariana','Abbadia Lariana','','NO','A005',45.8992038,9.3320688,16.4678,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097002','Airuno','Airuno','','NO','A112',45.7544205,9.4224345,4.3305,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097003','Annone di Brianza','Annone di Brianza','','NO','A301',45.8039614,9.3319246,5.8843,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097004','Ballabio','Ballabio','','NO','A594',45.8961032,9.4241871,14.9362,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097005','Barzago','Barzago','','NO','A683',45.7554940,9.3166631,3.6293,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097006','Barzanò','Barzanò','','NO','A686',45.7346682,9.3167949,3.6671,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097007','Barzio','Barzio','','NO','A687',45.9469087,9.4684496,21.3962,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097008','Bellano','Bellano','','NO','A745',46.0441644,9.3035587,22.0968,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097009','Bosisio Parini','Bosisio Parini','','NO','B081',45.8020230,9.2893883,5.9223,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097010','Brivio','Brivio','','NO','B194',45.7422368,9.4471076,7.8779,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097011','Bulciago','Bulciago','','NO','B261',45.7530074,9.2879360,3.0492,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097012','Calco','Calco','','NO','B396',45.7255915,9.4181714,4.4464,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097013','Calolziocorte','Calolziocorte','','NO','B423',45.8014877,9.4329346,9.0413,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097014','Carenno','Carenno','','NO','B763',45.8014357,9.4616215,7.7941,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097015','Casargo','Casargo','','NO','B937',46.0383264,9.3884582,19.6973,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097016','Casatenovo','Casatenovo','','NO','B943',45.6984393,9.3117774,12.7487,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097017','Cassago Brianza','Cassago Brianza','','NO','B996',45.7404878,9.2948016,3.4170,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097018','Cassina Valsassina','Cassina Valsassina','','NO','C024',45.9319194,9.4786757,2.6976,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097019','Castello di Brianza','Castello di Brianza','','NO','C187',45.7560840,9.3471334,3.6137,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097020','Cernusco Lombardone','Cernusco Lombardone','','NO','C521',45.6930101,9.4011024,3.6983,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097021','Cesana Brianza','Cesana Brianza','','NO','C563',45.8190280,9.2994843,3.6999,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097022','Civate','Civate','','NO','C752',45.8290341,9.3439951,9.2900,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097023','Colico','Colico','','NO','C839',46.1358541,9.3746798,34.9966,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097024','Colle Brianza','Colle Brianza','','NO','C851',45.7630456,9.3645487,8.3554,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097025','Cortenova','Cortenova','','NO','D065',45.9997826,9.3837362,11.6350,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097026','Costa Masnaga','Costa Masnaga','','NO','D112',45.7700916,9.2731053,5.6768,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097027','Crandola Valsassina','Crandola Valsassina','','NO','D131',46.0227657,9.3787388,8.6338,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097028','Cremella','Cremella','','NO','D143',45.7399303,9.3033783,1.8204,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097029','Cremeno','Cremeno','','NO','D145',45.9353286,9.4727330,13.2887,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097030','Dervio','Dervio','','NO','D280',46.0762261,9.3066309,11.8369,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097031','Dolzago','Dolzago','','NO','D327',45.7695971,9.3417316,2.3612,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097032','Dorio','Dorio','','NO','D346',46.1010737,9.3180375,11.6045,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097033','Ello','Ello','','NO','D398',45.7878261,9.3664068,2.3545,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097034','Erve','Erve','','NO','D428',45.8200200,9.4509871,6.0459,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097035','Esino Lario','Esino Lario','','NO','D436',45.9939122,9.3324756,17.8680,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097036','Galbiate','Galbiate','','NO','D865',45.8170586,9.3742665,15.4916,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097037','Garbagnate Monastero','Garbagnate Monastero','','NO','D913',45.7698671,9.3054137,3.5293,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097038','Garlate','Garlate','','NO','D926',45.8061112,9.4032737,3.7257,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097039','Imbersago','Imbersago','','NO','E287',45.7060470,9.4463326,3.2248,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097040','Introbio','Introbio','','NO','E305',45.9739439,9.4536005,26.0878,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097042','Lecco','Lecco','','SI','E507',45.8553170,9.3937359,45.0831,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097043','Lierna','Lierna','','NO','E581',45.9586893,9.3038471,11.2938,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097044','Lomagna','Lomagna','','NO','E656',45.6676557,9.3734273,4.1365,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097045','Malgrate','Malgrate','','NO','E858',45.8525725,9.3745953,1.8300,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097046','Mandello del Lario','Mandello del Lario','','NO','E879',45.9173366,9.3195789,43.5477,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097047','Margno','Margno','','NO','E947',46.0305728,9.3807033,3.6597,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097048','Merate','Merate','','NO','F133',45.6998895,9.4169888,11.1854,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097049','Missaglia','Missaglia','','NO','F248',45.7085635,9.3343588,11.5789,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097050','Moggio','Moggio','','NO','F265',45.9322769,9.4879969,13.4589,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097051','Molteno','Molteno','','NO','F304',45.7785389,9.3066766,3.0521,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097052','Monte Marenzo','Monte Marenzo','','NO','F561',45.7696237,9.4540729,3.0944,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097053','Montevecchia','Montevecchia','','NO','F657',45.7047125,9.3827751,5.5781,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097054','Monticello Brianza','Monticello Brianza','','NO','F674',45.7099159,9.3144869,4.6022,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097055','Morterone','Morterone','','NO','F758',45.8762467,9.4826883,13.8194,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097056','Nibionno','Nibionno','','NO','F887',45.7522578,9.2632339,3.5678,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097057','Oggiono','Oggiono','','NO','G009',45.7912938,9.3502952,7.7019,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097058','Olgiate Molgora','Olgiate Molgora','','NO','G026',45.7282674,9.4031496,7.1860,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097059','Olginate','Olginate','','NO','G030',45.7985460,9.4121420,7.8812,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097060','Oliveto Lario','Oliveto Lario','','NO','G040',45.9306516,9.2830202,15.6843,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097061','Osnago','Osnago','','NO','G161',45.6770582,9.3900792,4.3480,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097062','Paderno d\'Adda','Paderno d\'Adda','','NO','G218',45.6814391,9.4440146,3.3243,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097063','Pagnona','Pagnona','','NO','G241',46.0592608,9.4037825,9.2788,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097064','Parlasco','Parlasco','','NO','G336',46.0183857,9.3446464,3.1008,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097065','Pasturo','Pasturo','','NO','G368',45.9510320,9.4422409,21.8878,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097067','Perledo','Perledo','','NO','G456',46.0131619,9.2959698,13.5990,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097068','Pescate','Pescate','','NO','G485',45.8297746,9.3950893,2.0847,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097069','Premana','Premana','','NO','H028',46.0520700,9.4233919,33.1814,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097070','Primaluna','Primaluna','','NO','H063',45.9864725,9.4301540,22.9674,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097071','Robbiate','Robbiate','','NO','G223',45.6881282,9.4391135,4.6305,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097072','Rogeno','Rogeno','','NO','H486',45.7825114,9.2723723,4.5021,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097074','Santa Maria Hoè','Santa Maria Hoè','','NO','I243',45.7436352,9.3714681,2.4924,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097075','Sirone','Sirone','','NO','I759',45.7726977,9.3243964,3.2905,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097076','Sirtori','Sirtori','','NO','I761',45.7370518,9.3319126,4.2246,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097077','Sueglio','Sueglio','','NO','I994',46.0853531,9.3318577,4.2278,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097078','Suello','Suello','','NO','I996',45.8185745,9.3082028,2.7672,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097079','Taceno','Taceno','','NO','L022',46.0230276,9.3634367,3.6533,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097082','Valgreghentino','Valgreghentino','','NO','L581',45.7711916,9.4119292,6.5414,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097083','Valmadrera','Valmadrera','','NO','L634',45.8471678,9.3603367,12.7189,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097084','Varenna','Varenna','','NO','L680',46.0098904,9.2841564,12.6235,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097086','Vercurago','Vercurago','','NO','L751',45.8113598,9.4243522,2.2116,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097090','Viganò','Viganò','','NO','L866',45.7258236,9.3253555,1.6299,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097091','Verderio','Verderio','','NO','M337',45.6685444,9.4393998,6.3373,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097092','La Valletta Brianza','La Valletta Brianza','','NO','M348',45.7406252,9.3610295,8.8809,'097');
INSERT INTO `gi_comuni` VALUES ('LC','097093','Valvarrone','Valvarrone','','NO','M395',46.0812669,9.3398721,14.9066,'097');
INSERT INTO `gi_comuni` VALUES ('LO','098001','Abbadia Cerreto','Abbadia Cerreto','','NO','A004',45.3123062,9.5925492,6.3958,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098002','Bertonico','Bertonico','','NO','A811',45.2330898,9.6688792,20.8473,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098003','Boffalora d\'Adda','Boffalora d\'Adda','','NO','A919',45.3608493,9.4938332,8.5945,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098004','Borghetto Lodigiano','Borghetto Lodigiano','','NO','A995',45.2138438,9.4991577,24.1735,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098005','Borgo San Giovanni','Borgo San Giovanni','','NO','B017',45.2755808,9.4254608,7.7131,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098006','Brembio','Brembio','','NO','B141',45.2141027,9.5727341,17.2668,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098008','Casaletto Lodigiano','Casaletto Lodigiano','','NO','B887',45.2931082,9.3618349,9.3690,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098009','Casalmaiocco','Casalmaiocco','','NO','B899',45.3529357,9.3741950,4.7760,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098010','Casalpusterlengo','Casalpusterlengo','','NO','B910',45.1789729,9.6480271,25.5735,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098011','Caselle Landi','Caselle Landi','','NO','B961',45.1012149,9.7928224,25.8962,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098012','Caselle Lurani','Caselle Lurani','','NO','B958',45.2792449,9.3587019,7.5477,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098013','Castelnuovo Bocca d\'Adda','Castelnuovo Bocca d\'Adda','','NO','C228',45.1133069,9.8688431,20.6756,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098014','Castiglione d\'Adda','Castiglione d\'Adda','','NO','C304',45.2155497,9.6949497,13.0205,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098015','Castiraga Vidardo','Castiraga Vidardo','','NO','C329',45.2545989,9.3983186,5.1380,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098017','Cavenago d\'Adda','Cavenago d\'Adda','','NO','C394',45.2840766,9.6018731,16.1025,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098018','Cervignano d\'Adda','Cervignano d\'Adda','','NO','C555',45.3729548,9.4243994,4.1565,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098019','Codogno','Codogno','','NO','C816',45.1602059,9.7036819,20.9991,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098020','Comazzo','Comazzo','','NO','C917',45.4421304,9.4670826,12.7784,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098021','Cornegliano Laudense','Cornegliano Laudense','','NO','D021',45.2841368,9.4704823,5.9551,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098022','Corno Giovine','Corno Giovine','','NO','D028',45.1324249,9.7592525,9.9780,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098023','Cornovecchio','Cornovecchio','','NO','D029',45.1366323,9.7985457,6.5171,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098024','Corte Palasio','Corte Palasio','','NO','D068',45.3148328,9.5608408,15.4626,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098025','Crespiatica','Crespiatica','','NO','D159',45.3558442,9.5747222,7.1796,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098026','Fombio','Fombio','','NO','D660',45.1371739,9.6844881,7.2696,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098027','Galgagnano','Galgagnano','','NO','D868',45.3578932,9.4429201,5.9903,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098028','Graffignana','Graffignana','','NO','E127',45.2098050,9.4531950,10.6751,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098029','Guardamiglio','Guardamiglio','','NO','E238',45.1092279,9.6811195,10.4333,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098030','Livraga','Livraga','','NO','E627',45.1930032,9.5455692,12.2975,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098031','Lodi','Lodi','','SI','E648',45.3144787,9.5028118,41.0931,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098032','Lodi Vecchio','Lodi Vecchio','','NO','E651',45.3014322,9.4160266,16.5345,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098033','Maccastorna','Maccastorna','','NO','E777',45.1465495,9.8557689,5.4342,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098034','Mairago','Mairago','','NO','E840',45.2515490,9.5799384,11.1781,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098035','Maleo','Maleo','','NO','E852',45.1682056,9.7645457,19.6926,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098036','Marudo','Marudo','','NO','E994',45.2529404,9.3744312,4.3024,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098037','Massalengo','Massalengo','','NO','F028',45.2633035,9.4899714,8.4741,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098038','Meleti','Meleti','','NO','F102',45.1191504,9.8368814,7.4156,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098039','Merlino','Merlino','','NO','F149',45.4326183,9.4295973,10.6957,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098040','Montanaso Lombardo','Montanaso Lombardo','','NO','F423',45.3349580,9.4631243,9.7253,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098041','Mulazzano','Mulazzano','','NO','F801',45.3731070,9.3983928,15.4810,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098042','Orio Litta','Orio Litta','','NO','G107',45.1570023,9.5570198,9.8793,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098043','Ospedaletto Lodigiano','Ospedaletto Lodigiano','','NO','G166',45.1654653,9.5827999,8.3860,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098044','Ossago Lodigiano','Ossago Lodigiano','','NO','G171',45.2436915,9.5372630,11.3077,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098045','Pieve Fissiraga','Pieve Fissiraga','','NO','G096',45.2639927,9.4590423,12.0892,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098046','Salerano sul Lambro','Salerano sul Lambro','','NO','H701',45.2950665,9.3879231,4.3597,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098047','San Fiorano','San Fiorano','','NO','H844',45.1369385,9.7248706,9.0642,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098048','San Martino in Strada','San Martino in Strada','','NO','I012',45.2707573,9.5303397,13.4015,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098049','San Rocco al Porto','San Rocco al Porto','','NO','I140',45.0816398,9.6928931,30.9271,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098050','Sant\'Angelo Lodigiano','Sant\'Angelo Lodigiano','','NO','I274',45.2381371,9.4110589,19.9413,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098051','Santo Stefano Lodigiano','Santo Stefano Lodigiano','','NO','I362',45.1196364,9.7361936,10.3610,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098052','Secugnago','Secugnago','','NO','I561',45.2314594,9.5918574,6.8471,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098053','Senna Lodigiana','Senna Lodigiana','','NO','I612',45.1483621,9.5925396,26.9621,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098054','Somaglia','Somaglia','','NO','I815',45.1469602,9.6379226,20.9900,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098055','Sordio','Sordio','','NO','I848',45.3405679,9.3658397,2.7119,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098056','Tavazzano con Villavesco','Tavazzano con Villavesco','','NO','F260',45.3291501,9.4070504,15.8955,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098057','Terranova dei Passerini','Terranova dei Passerini','','NO','L125',45.1980871,9.6779411,11.1410,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098058','Turano Lodigiano','Turano Lodigiano','','NO','L469',45.2489315,9.6209757,16.0387,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098059','Valera Fratta','Valera Fratta','','NO','L572',45.2551786,9.3320187,8.0799,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098060','Villanova del Sillaro','Villanova del Sillaro','','NO','L977',45.2380639,9.4811183,13.4747,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098061','Zelo Buon Persico','Zelo Buon Persico','','NO','M158',45.4130134,9.4300018,18.6286,'098');
INSERT INTO `gi_comuni` VALUES ('LO','098062','Castelgerundo','Castelgerundo','','NO','M393',45.2037611,9.7251019,20.2395,'098');
INSERT INTO `gi_comuni` VALUES ('RN','099001','Bellaria-Igea Marina','Bellaria-Igea Marina','','NO','A747',44.1474509,12.4581610,18.6149,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099002','Cattolica','Cattolica','','NO','C357',43.9638211,12.7447210,6.0425,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099003','Coriano','Coriano','','NO','D004',43.9643705,12.6025823,46.8094,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099004','Gemmano','Gemmano','','NO','D961',43.9042734,12.5828603,18.7179,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099005','Misano Adriatico','Misano Adriatico','','NO','F244',43.9733325,12.6932780,22.5834,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099006','Mondaino','Mondaino','','NO','F346',43.8559747,12.6713746,19.5639,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099008','Montefiore Conca','Montefiore Conca','','NO','F502',43.8907192,12.6105186,22.3321,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099009','Montegridolfo','Montegridolfo','','NO','F523',43.8590139,12.6891673,7.0633,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099011','Morciano di Romagna','Morciano di Romagna','','NO','F715',43.9136981,12.6459452,5.4508,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099013','Riccione','Riccione','','NO','H274',44.0000075,12.6550798,17.3918,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099014','Rimini','Rimini','','SI','H294',44.0608208,12.5652307,135.9883,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099015','Saludecio','Saludecio','','NO','H724',43.8726567,12.6689315,34.7154,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099016','San Clemente','San Clemente','','NO','H801',43.9322304,12.6256026,20.5312,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099017','San Giovanni in Marignano','San Giovanni in Marignano','','NO','H921',43.9393040,12.7136116,21.1970,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099018','Santarcangelo di Romagna','Santarcangelo di Romagna','','NO','I304',44.0628758,12.4470221,44.5912,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099020','Verucchio','Verucchio','','NO','L797',43.9836899,12.4213811,27.3308,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099021','Casteldelci','Casteldelci','','NO','C080',43.7911632,12.1552453,49.9015,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099022','Maiolo','Maiolo','','NO','E838',43.8740544,12.3107123,24.1819,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099023','Novafeltria','Novafeltria','','NO','F137',43.8958929,12.2902996,41.9610,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099024','Pennabilli','Pennabilli','','NO','G433',43.8183047,12.2647445,69.6699,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099025','San Leo','San Leo','','NO','H949',43.8960804,12.3432173,53.3896,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099026','Sant\'Agata Feltria','Sant\'Agata Feltria','','NO','I201',43.8639857,12.2083964,79.6185,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099027','Talamello','Talamello','','NO','L034',43.9049179,12.2861910,10.6707,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099028','Poggio Torriana','Poggio Torriana','','NO','M324',44.0268317,12.4075532,35.0949,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099029','Montescudo-Monte Colombo','Montescudo-Monte Colombo','','NO','M368',43.9203367,12.5529617,32.4561,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099030','Montecopiolo','Montecopiolo','','NO','F478',43.8412513,12.3593666,35.5829,'099');
INSERT INTO `gi_comuni` VALUES ('RN','099031','Sassofeltrio','Sassofeltrio','','NO','I460',43.8924663,12.5093049,21.2676,'099');
INSERT INTO `gi_comuni` VALUES ('PO','100001','Cantagallo','Cantagallo','','NO','B626',44.0282521,11.1072003,95.5545,'100');
INSERT INTO `gi_comuni` VALUES ('PO','100002','Carmignano','Carmignano','','NO','B794',43.8141069,11.0182895,38.2242,'100');
INSERT INTO `gi_comuni` VALUES ('PO','100003','Montemurlo','Montemurlo','','NO','F572',43.9271477,11.0368809,30.8791,'100');
INSERT INTO `gi_comuni` VALUES ('PO','100004','Poggio a Caiano','Poggio a Caiano','','NO','G754',43.8163447,11.0561919,6.2451,'100');
INSERT INTO `gi_comuni` VALUES ('PO','100005','Prato','Prato','','SI','G999',43.8808908,11.0968044,97.3751,'100');
INSERT INTO `gi_comuni` VALUES ('PO','100006','Vaiano','Vaiano','','NO','L537',43.9685863,11.1231782,33.8267,'100');
INSERT INTO `gi_comuni` VALUES ('PO','100007','Vernio','Vernio','','NO','L775',44.0535558,11.1560114,63.2849,'100');
INSERT INTO `gi_comuni` VALUES ('KR','101001','Belvedere di Spinello','Belvedere di Spinello','','NO','A772',39.2114110,16.8882745,30.1115,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101002','Caccuri','Caccuri','','NO','B319',39.2271420,16.7790270,61.5060,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101003','Carfizzi','Carfizzi','','NO','B771',39.3063074,16.9764050,20.7556,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101004','Casabona','Casabona','','NO','B857',39.2481940,16.9575684,67.5583,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101005','Castelsilano','Castelsilano','','NO','B968',39.2709147,16.7656006,39.7937,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101006','Cerenzia','Cerenzia','','NO','C501',39.2448933,16.7841998,22.1052,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101007','Cirò','Cirò','','NO','C725',39.3808491,17.0639000,70.7980,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101008','Cirò Marina','Cirò Marina','','NO','C726',39.3662841,17.1297136,41.8989,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101009','Cotronei','Cotronei','','NO','D123',39.1595617,16.7808385,79.4458,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101010','Crotone','Crotone','','SI','D122',39.0799456,17.1249895,181.9712,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101011','Crucoli','Crucoli','','NO','D189',39.4240906,17.0039903,50.2899,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101012','Cutro','Cutro','','NO','D236',39.0331225,16.9814702,133.2736,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101013','Isola di Capo Rizzuto','Isola di Capo Rizzuto','','NO','E339',38.9589529,17.0957152,127.0062,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101014','Melissa','Melissa','','NO','F108',39.3067378,17.0241516,51.5894,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101015','Mesoraca','Mesoraca','','NO','F157',39.0813235,16.7867853,94.4962,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101016','Pallagorio','Pallagorio','','NO','G278',39.3070905,16.9109876,44.4692,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101017','Petilia Policastro','Petilia Policastro','','NO','G508',39.1131776,16.7877683,98.3470,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101018','Roccabernarda','Roccabernarda','','NO','H383',39.1341404,16.8712653,64.9278,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101019','Rocca di Neto','Rocca di Neto','','NO','H403',39.1913378,17.0005139,44.2733,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101020','San Mauro Marchesato','San Mauro Marchesato','','NO','I026',39.1023293,16.9217679,41.8556,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101021','San Nicola dell\'Alto','San Nicola dell\'Alto','','NO','I057',39.2904491,16.9744287,8.0486,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101022','Santa Severina','Santa Severina','','NO','I308',39.1478007,16.9150093,52.4666,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101023','Savelli','Savelli','','NO','I468',39.3122255,16.7776573,48.6853,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101024','Scandale','Scandale','','NO','I494',39.1239943,16.9603933,54.2587,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101025','Strongoli','Strongoli','','NO','I982',39.2677645,17.0519125,85.9605,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101026','Umbriatico','Umbriatico','','NO','L492',39.3532078,16.9180964,73.3543,'101');
INSERT INTO `gi_comuni` VALUES ('KR','101027','Verzino','Verzino','','NO','L802',39.3123936,16.8616855,46.0335,'101');
INSERT INTO `gi_comuni` VALUES ('VV','102001','Acquaro','Acquaro','','NO','A043',38.5551864,16.1906219,24.9840,'102');
INSERT INTO `gi_comuni` VALUES ('VV','102002','Arena','Arena','','NO','A386',38.5625110,16.2112501,34.3604,'102');
INSERT INTO `gi_comuni` VALUES ('VV','102003','Briatico','Briatico','','NO','B169',38.7242928,16.0292205,27.5877,'102');
INSERT INTO `gi_comuni` VALUES ('VV','102004','Brognaturo','Brognaturo','','NO','B197',38.